/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.gui.InterfaceShowDuplicateApp;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import javax.swing.JFrame;

public class ShowDuplicateApp
extends UnicastRemoteObject
implements InterfaceShowDuplicateApp {
    public static final String CNAME = "ShowDuplicateApp";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.lib.util.Res");
    private Registry m_rmiRegistry;
    private InterfaceShowDuplicateApp m_existingAppRef = null;
    private JFrame m_jFrameApp;

    public ShowDuplicateApp(String string, JFrame jFrame) throws RemoteException {
        this.m_jFrameApp = jFrame;
        this.initializeRegistry();
        string = string + ":" + System.getProperty("user.name");
        if (this.checkForApp(string)) {
            if (this.isSameDisplay(string)) {
                Trace.logInfo((String)CNAME, (String)("Another instance of the " + string + " application is already running on " + "the same DISPLAY.  Will attempt to bring it to " + "the front, then exit."));
                this.showExisting(string);
            } else {
                Trace.logInfo((String)CNAME, (String)("Another instance of the " + string + " application is already running on " + "a different DISPLAY.  This is not allowed. " + "Will show error popup, then exit."));
                String string2 = res.getString("ShowDuplicateApp_App_Already_Running");
                Message.show(jFrame, string2);
            }
            System.exit(1);
        } else {
            Trace.logInfo((String)CNAME, (String)("This is the only (" + string + ") running--registering it with RMI."));
            this.registerWithRmi(string);
        }
    }

    public boolean isAlive() throws RemoteException {
        Trace.logInfo((String)"ShowDuplicateApp:isAlive", (String)"Process is alive.");
        return true;
    }

    public void show() throws RemoteException {
        Trace.logInfo((String)"ShowDuplicateApp:show", (String)"show() was invoked on existing application frame.");
        if (this.m_jFrameApp != null && this.m_jFrameApp.isVisible()) {
            if (this.m_jFrameApp.getState() == 1) {
                this.m_jFrameApp.setState(0);
            } else {
                this.m_jFrameApp.show();
            }
            this.m_jFrameApp.requestFocus();
        }
    }

    public String getProperty(String string) throws RemoteException {
        return System.getProperty(string);
    }

    private void initializeRegistry() throws RemoteException {
        TimeoutFactory timeoutFactory = new TimeoutFactory(5);
        try {
            this.m_rmiRegistry = LocateRegistry.createRegistry(1099, timeoutFactory, timeoutFactory);
        }
        catch (RemoteException remoteException) {
            Trace.logInfo((String)"ShowDuplicateApp:initializeRegistry", (String)("RemoteException: " + remoteException.getMessage() + ".  Failed to create registry on this host and port=" + 1099 + "; assuming it already exists."));
            try {
                this.m_rmiRegistry = LocateRegistry.getRegistry("localhost", 1099, timeoutFactory);
            }
            catch (RemoteException remoteException2) {
                Trace.logError((String)"ShowDuplicateApp:initializeRegistry", (String)("RemoteException: " + remoteException2.getMessage() + "; failed to get registry on this host and port=" + 1099 + "."), (Throwable)remoteException2);
                throw remoteException2;
            }
        }
    }

    private boolean checkForApp(String string) {
        boolean bl = false;
        this.m_existingAppRef = (InterfaceShowDuplicateApp)this.lookup(string);
        if (this.m_existingAppRef == null) {
            Trace.logInfo((String)"ShowDuplicateApp:checkForApp", (String)("Unable to find application (" + string + ") using RMI registry on this host " + "and port=" + 1099 + "."));
        } else {
            Trace.logInfo((String)"ShowDuplicateApp:checkForApp", (String)("Found application (" + string + ") using RMI registry.  Checking if it's running..."));
            try {
                bl = this.m_existingAppRef.isAlive();
            }
            catch (RemoteException remoteException) {
                Trace.logInfo((String)"ShowDuplicateApp:checkForApp", (String)("RemoteException:  [" + remoteException.getMessage() + "].  Unable to talk to application (" + string + ").  Assuming it's not running."));
            }
        }
        return bl;
    }

    private void showExisting(String string) {
        try {
            this.m_existingAppRef.show();
        }
        catch (RemoteException remoteException) {
            Trace.logError((String)"ShowDuplicateApp:showExisting", (String)("RemoteException: " + remoteException.getMessage() + " calling remote show method of existing " + "application (" + string + ")."), (Throwable)remoteException);
        }
    }

    private boolean isSameDisplay(String string) {
        boolean bl = false;
        try {
            String string2 = System.getProperty("lax.nl.env.DISPLAY");
            String string3 = this.m_existingAppRef.getProperty("lax.nl.env.DISPLAY");
            bl = string2 == null || string3 == null || string2.equals(string3);
            Trace.logInfo((String)"ShowDuplicateApp:isSameDisplay", (String)("isSameDisplay returning (" + bl + "). " + "Current DISPLAY=" + string2 + ", Existing DISPLAY=" + string3));
        }
        catch (RemoteException remoteException) {
            Trace.logError((String)"ShowDuplicateApp:isSameDisplay", (String)("RemoteException: " + remoteException.getMessage() + " calling remote getProperty method for property=" + "lax.nl.env.DISPLAY of existing application (" + string + ")."), (Throwable)remoteException);
        }
        return bl;
    }

    private boolean registerWithRmi(String string) {
        boolean bl;
        try {
            String string2 = this.buildUrl("localhost", 1099, string);
            this.m_rmiRegistry.rebind(string2, this);
            Trace.logInfo((String)"ShowDuplicateApp:registerWithRmi", (String)("Application (" + string + ") has been registered with RMI registry."));
            bl = true;
        }
        catch (Exception exception) {
            Trace.logError((String)"ShowDuplicateApp:registerWithRmi", (String)("Exception: " + exception.getMessage() + " trying to register application" + " (" + string + ") with RMI registry.  WARNING: " + "This application instance will be allowed to start, " + "but duplicate application checking will not work " + "properly with it (i.e., if a another instance of " + "the application is started, it will also be allowed " + "to start."), (Throwable)exception);
            bl = false;
        }
        return bl;
    }

    private Remote lookup(String string) {
        Remote remote = null;
        String string2 = this.buildUrl("localhost", 1099, string);
        try {
            remote = this.m_rmiRegistry.lookup(string2);
        }
        catch (Exception exception) {
            remote = null;
            Trace.logInfo((String)"ShowDuplicateApp:lookup", (String)("Exception: " + exception.getMessage() + " from m_rmiRegistry.lookup for " + "name (" + string2 + ")."));
        }
        return remote;
    }

    private String buildUrl(String string, int n, String string2) {
        if (string == null || string.trim().length() == 0) {
            string = "localhost";
        }
        if (n <= 0) {
            n = 1099;
        }
        return "rmi://" + string + ":" + n + "/" + string2;
    }

    private static class TimeoutFactory
    extends RMISocketFactory {
        private int timeout;

        public TimeoutFactory(int n) {
            this.timeout = n;
        }

        public Socket createSocket(String string, int n) throws IOException {
            Socket socket = RMISocketFactory.getDefaultSocketFactory().createSocket(string, n);
            socket.setSoTimeout(this.timeout * 1000);
            return socket;
        }

        public ServerSocket createServerSocket(int n) throws IOException {
            return RMISocketFactory.getDefaultSocketFactory().createServerSocket(n);
        }
    }
}

