/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.components;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.StringTokenizer;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.UIManager;

public class JButtonTask
extends JButton {
    private boolean m_bMouseOver = false;
    private final int BUTTON_PAD = 2;
    private Dimension m_dimPreferredSize = null;
    private Dimension m_dimMinimumSize = null;

    public JButtonTask() {
        this.addMouseListener(new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                JButtonTask.this.jButton1_mouseEntered(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                JButtonTask.this.jButton1_mouseExited(mouseEvent);
            }
        });
    }

    protected void paintComponent(Graphics graphics) {
        int n;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Dimension dimension = this.getSize();
        if (this.isContentAreaFilled()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        Icon icon = this.getIcon();
        if (this.m_bMouseOver) {
            icon = this.getDisabledIcon(icon);
        }
        if (icon != null) {
            int n2 = 2;
            n = (dimension.height - icon.getIconHeight()) / 2;
            Rectangle rectangle = new Rectangle(n2, n, icon.getIconWidth(), icon.getIconHeight());
            icon.paintIcon(this, graphics, n2, n);
        }
        if (this.m_bMouseOver) {
            graphics.setColor(UIManager.getColor("textHighlight"));
        } else {
            graphics.setColor(this.getForeground());
        }
        String[] stringArray = this.getTextLines();
        n = 2;
        int n3 = 0;
        if (icon != null) {
            n += icon.getIconWidth() + 2;
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            String string = stringArray[n4];
            graphics.drawString(string, n, n3 += fontMetrics.getMaxAscent());
            if (this.m_bMouseOver) {
                Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
                int n5 = (int)rectangle2D.getWidth();
                graphics.drawLine(n, n3 + 1, n + n5, n3 + 1);
            }
            ++n4;
        }
    }

    public void setPreferredSize(Dimension dimension) {
        this.m_dimPreferredSize = dimension;
    }

    public void setMinimumSize(Dimension dimension) {
        this.m_dimMinimumSize = dimension;
    }

    public Dimension getPreferredSize() {
        if (this.m_dimPreferredSize != null) {
            return this.m_dimPreferredSize;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Graphics graphics = this.getGraphics();
        String[] stringArray = this.getTextLines();
        int n = stringArray.length * (fontMetrics.getMaxAscent() + 2) + 2;
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(stringArray[n3], graphics);
            if ((int)rectangle2D.getWidth() > n2) {
                n2 = (int)rectangle2D.getWidth();
            }
            ++n3;
        }
        n2 += 2;
        int n4 = 0;
        int n5 = 0;
        Icon icon = this.getIcon();
        if (icon != null) {
            n4 = 2 + icon.getIconWidth() + 2;
            n5 = 2 + icon.getIconHeight() + 2;
        }
        int n6 = Math.max(n5, n);
        int n7 = n4 + n2;
        Dimension dimension = new Dimension(n7, n6);
        return dimension;
    }

    public Dimension getMinimumSize() {
        if (this.m_dimMinimumSize != null) {
            return this.m_dimMinimumSize;
        }
        Dimension dimension = new Dimension(100, 50);
        return dimension;
    }

    public String[] getTextLines() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Graphics graphics = this.getGraphics();
        String string = this.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        int n = stringTokenizer.countTokens();
        if (n > 3) {
            n = 3;
        }
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        return stringArray;
    }

    void jButton1_mouseEntered(MouseEvent mouseEvent) {
        this.m_bMouseOver = true;
        this.repaint();
    }

    void jButton1_mouseExited(MouseEvent mouseEvent) {
        this.m_bMouseOver = false;
        this.repaint();
    }

    public Icon getDisabledIcon(Icon icon) {
        ImageIcon imageIcon = (ImageIcon)icon;
        Image image = GrayFilter.createDisabledImage(imageIcon.getImage());
        ImageIcon imageIcon2 = new ImageIcon(image);
        return imageIcon2;
    }

    public boolean isFocusTraversable() {
        return false;
    }
}

