/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class JComboBoxAvocent
extends JComboBox {
    public JComboBoxAvocent(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
        this.init();
    }

    public JComboBoxAvocent(Object[] objectArray) {
        super(objectArray);
        this.init();
    }

    public JComboBoxAvocent(Vector vector) {
        super(vector);
        this.init();
    }

    public JComboBoxAvocent() {
        this.init();
    }

    public void setEditable(boolean bl) {
        super.setEditable(bl);
        this.updateBackgroundColor();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.updateBackgroundColor();
    }

    protected void updateBackgroundColor() {
        String string = "control";
        if (this.isEnabled()) {
            string = this.isEditable() ? "TextField.background" : "ComboBox.background";
        }
        this.getEditor().getEditorComponent().setBackground(UIManager.getColor(string));
        ((ListCellRendererAvocent)this.getRenderer()).setBackgroundColor(UIManager.getColor(string));
    }

    private void init() {
        MyComboBoxEditor myComboBoxEditor = new MyComboBoxEditor(this);
        this.setEditor(myComboBoxEditor);
        this.setRenderer(new ListCellRendererAvocent());
        this.updateBackgroundColor();
        myComboBoxEditor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = JComboBoxAvocent.this.getRootPane().getDefaultButton();
                if (jButton != null) {
                    jButton.doClick(20);
                }
            }
        });
    }

    public class ListCellRendererAvocent
    extends BasicComboBoxRenderer {
        Color m_cBackgroundColor;

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Component component = super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (!bl) {
                component.setBackground(this.m_cBackgroundColor);
            }
            return component;
        }

        public void setBackgroundColor(Color color) {
            this.m_cBackgroundColor = color;
        }
    }

    public class MyTextField
    extends JTextField {
        private JComboBox m_jcb;

        public MyTextField(String string, int n, JComboBox jComboBox) {
            super(string, n);
            this.m_jcb = jComboBox;
            Border border = ((JComponent)jComboBox.getEditor().getEditorComponent()).getBorder();
            super.setBorder(border);
        }

        public void fireActionPerformed() {
            if (JComboBoxAvocent.this.isPopupVisible()) {
                JComboBoxAvocent.this.hidePopup();
            } else {
                super.fireActionPerformed();
            }
        }

        public void setBorder(Border border) {
        }
    }

    public class MyComboBoxEditor
    extends BasicComboBoxEditor {
        public MyComboBoxEditor(JComboBox jComboBox) {
            this.editor = new MyTextField("", 9, jComboBox);
        }

        public void setItem(Object object) {
            super.setItem(object);
            this.editor.selectAll();
        }
    }
}

