/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.components;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.gui.components.InterfaceSortableTableModel;
import com.avocent.lib.gui.components.InterfaceTableModelWrapper;
import com.avocent.lib.gui.components.SortArrowIcon;
import com.avocent.lib.gui.components.TableModelColumnSorted;
import com.avocent.lib.gui.renderers.DefaultTableCellRendererIconName;
import com.avocent.lib.util.StringUtilities;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.FocusManager;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class JTableAvocent
extends JTable {
    protected static final int DEFAULT_AVCT_STD_FEATURE_LEVEL = 0;
    public static final int SORTABLE = 1;
    private int featureLevel;
    static /* synthetic */ Class class$com$avocent$lib$gui$renderers$TableCellIconName;

    public JTableAvocent() {
        this(0);
    }

    public JTableAvocent(int n) {
        super.setAutoResizeMode(3);
        this.setAvctStdTableFeatures(n);
        this.enableAvctStdTableFeatures();
    }

    public JTableAvocent(TableModel tableModel) {
        this(tableModel, 0);
    }

    public JTableAvocent(TableModel tableModel, int n) {
        super(tableModel);
        super.setAutoResizeMode(3);
        this.setAvctStdTableFeatures(n);
        this.enableAvctStdTableFeatures();
    }

    public JTableAvocent(Object[][] objectArray, Object[] objectArray2) {
        this(objectArray, objectArray2, 0);
    }

    public JTableAvocent(Object[][] objectArray, Object[] objectArray2, int n) {
        super(objectArray, objectArray2);
        super.setAutoResizeMode(3);
        this.setAvctStdTableFeatures(n);
        this.enableAvctStdTableFeatures();
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        int n2 = keyEvent.getKeyCode();
        if (!(keyEvent.isControlDown() || keyEvent.isAltDown() || n2 != 27 && n2 != 10)) {
            return false;
        }
        return super.processKeyBinding(keyStroke, keyEvent, n, bl);
    }

    public boolean isFocusTraversable() {
        return this.getRowSelectionAllowed() && this.getModel() != null && this.getModel().getRowCount() > 0;
    }

    public void setAvctStdTableFeatures(int n) throws IllegalArgumentException {
        if (n <= -1) {
            Trace.logError((String)"JTableAvocent", (String)"setAvctStdTableFeatures() argument was less than zero");
            throw new IllegalArgumentException();
        }
        this.featureLevel = n;
        if ((n & 1) != 0) {
            this.setSortable(true);
        }
    }

    public final boolean enableAvctStdTableFeatures() {
        this.getTableHeader().setDefaultRenderer(new JButtonHeaderRenderer());
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
        inputMap.put(keyStroke, "focusNextComponent");
        actionMap.put("focusNextComponent", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FocusManager.getCurrentKeyboardFocusManager().focusNextComponent(JTableAvocent.this);
            }
        });
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(9, 1);
        inputMap.put(keyStroke2, "focusPreviousComponent");
        actionMap.put("focusPreviousComponent", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                FocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(JTableAvocent.this);
            }
        });
        this.getTableHeader().setReorderingAllowed(false);
        if (this.isSortable()) {
            this.setDefaultRenderer(class$com$avocent$lib$gui$renderers$TableCellIconName == null ? (class$com$avocent$lib$gui$renderers$TableCellIconName = JTableAvocent.class$("com.avocent.lib.gui.renderers.TableCellIconName")) : class$com$avocent$lib$gui$renderers$TableCellIconName, new DefaultTableCellRendererIconName());
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            int n = 0;
            while (n < this.getModel().getColumnCount()) {
                defaultTableCellRenderer.setHorizontalAlignment(2);
                this.setDefaultRenderer(this.getColumnClass(n), defaultTableCellRenderer);
                ++n;
            }
            return true;
        }
        return false;
    }

    public boolean isSortable() {
        return (this.featureLevel & 1) != 0 && this.getSortableModel() != null;
    }

    public void setSortable(boolean bl) {
        if (bl) {
            InterfaceSortableTableModel interfaceSortableTableModel = this.getSortableModel();
            if (interfaceSortableTableModel == null) {
                TableModelColumnSorted tableModelColumnSorted = new TableModelColumnSorted(this);
            }
            this.featureLevel |= 1;
        } else {
            this.featureLevel &= 0xFFFFFFFE;
        }
    }

    public void setInitialSortColumn(int n) {
    }

    public boolean getNextSortDirection() {
        InterfaceSortableTableModel interfaceSortableTableModel = this.getSortableModel();
        return interfaceSortableTableModel != null ? !interfaceSortableTableModel.isAscending() : true;
    }

    public void setNextSortDirection(boolean bl) {
    }

    public int getLastClickedColumnNum() {
        InterfaceSortableTableModel interfaceSortableTableModel = this.getSortableModel();
        return interfaceSortableTableModel != null ? interfaceSortableTableModel.getSortColumn() : -1;
    }

    public void doInitialColumnSorting() {
    }

    public void doInitialColumnSorting(int n) {
    }

    public boolean sortTableData(int n) {
        InterfaceSortableTableModel interfaceSortableTableModel = this.getSortableModel();
        if (interfaceSortableTableModel != null) {
            interfaceSortableTableModel.sort(n);
        }
        return true;
    }

    public int mapIndex(int n) {
        if (n < 0 || n >= this.getRowCount()) {
            return n;
        }
        TableModel tableModel = this.getModel();
        if (tableModel instanceof InterfaceTableModelWrapper) {
            InterfaceTableModelWrapper interfaceTableModelWrapper = (InterfaceTableModelWrapper)tableModel;
            return interfaceTableModelWrapper.mapIndex(n);
        }
        return n;
    }

    public String toString() {
        return StringUtilities.toSystemString((Object)this);
    }

    private InterfaceSortableTableModel getSortableModel() {
        TableModel tableModel = this.getModel();
        while (tableModel instanceof InterfaceTableModelWrapper) {
            if (tableModel instanceof InterfaceSortableTableModel) {
                return (InterfaceSortableTableModel)tableModel;
            }
            tableModel = ((InterfaceTableModelWrapper)tableModel).getNestedModel();
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class JButtonHeaderRenderer
    extends JButton
    implements TableCellRenderer {
        private SortArrowIcon m_iiAscending;
        private SortArrowIcon m_iiDescending;

        public JButtonHeaderRenderer() {
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setHorizontalTextPosition(2);
            this.setHorizontalAlignment(2);
            try {
                this.m_iiAscending = new SortArrowIcon(2);
                this.m_iiDescending = new SortArrowIcon(1);
            }
            catch (Exception exception) {
                Trace.logError((String)"AbstractTableModelUnitList:JButtonHeaderRenderer", (String)"failed to load sort order icons");
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                this.setText(object.toString());
            } else {
                this.setText("");
            }
            if (JTableAvocent.this.isSortable()) {
                InterfaceSortableTableModel interfaceSortableTableModel = JTableAvocent.this.getSortableModel();
                if (interfaceSortableTableModel != null && n2 == interfaceSortableTableModel.getSortColumn()) {
                    this.setIcon(interfaceSortableTableModel.isAscending() ? this.m_iiAscending : this.m_iiDescending);
                } else {
                    this.setIcon(null);
                }
            }
            return this;
        }
    }
}

