/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.components;

import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.gui.components.JTextFieldAvocent;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.net.IpAddress;
import com.avocent.lib.util.ResourceManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;

public class JTextFieldIPAddress
extends JTextFieldAvocent {
    public static final String CNAME = "JTextFieldIPAddress";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.lib.gui.components.Res");
    public static final int ADDRESS_REQUIRED = 1;
    public static final int NUMERIC_IP = 2;
    public static final int ALLOW_BROADCAST = 4;
    public static final int ALLOW_LOOPBACK = 8;
    public static final int ALLOW_ALL_ZEROS = 16;
    public static final int DOMAIN_NAME_ONLY = 32;
    public static final int FULLY_QUALIFIED_ONLY = 64;
    public static final int ALLOW_256_LENGTH = 128;
    private boolean m_bRequired;
    private boolean m_bNumericOnly;
    private boolean m_bNoLoopback;
    private boolean m_bNoBroadcast;
    private boolean m_bNotAllZeros;
    private boolean m_bDomainNameOnly;
    private boolean m_bFullyQualifiedOnly;
    private boolean m_bAllow256Length;

    public JTextFieldIPAddress() {
        this(0);
    }

    public JTextFieldIPAddress(int n) {
        this.setStyle(n);
        this.setName(res.getString("JTextFieldIPAddress_Default_Adddress_Name"));
    }

    public final void setStyle(int n) {
        this.m_bRequired = (n & 1) != 0;
        this.m_bNumericOnly = (n & 2) != 0;
        this.m_bNoLoopback = (n & 8) == 0;
        this.m_bNoBroadcast = (n & 4) == 0;
        this.m_bNotAllZeros = (n & 0x10) == 0;
        this.m_bDomainNameOnly = (n & 0x20) != 0;
        this.m_bFullyQualifiedOnly = (n & 0x40) != 0;
        this.m_bAllow256Length = (n & 0x80) != 0;
    }

    public IpAddress getIpAddress() throws ExceptionInvalidArgument {
        if (this.isDataValid()) {
            String string = this.getText().trim();
            try {
                InetAddress inetAddress = InetAddress.getByName(string);
                return new IpAddress(inetAddress.getAddress());
            }
            catch (UnknownHostException unknownHostException) {
                String string2 = res.getString("JTextFieldIPAddress_The_Address_field_is_unknown");
                String string3 = MessageFormat.format(string2, this.getName(), string);
                Message.show(this, string3);
                this.requestFocusInWindow();
                throw new ExceptionInvalidArgument((Throwable)unknownHostException);
            }
        }
        throw new ExceptionInvalidArgument();
    }

    public boolean isDataValid() {
        String string;
        String string2;
        String string3;
        block14: {
            string3 = this.getText().trim();
            if (string3.length() == 0) {
                if (this.m_bRequired) {
                    String string4 = res.getString("JTextFieldIPAddress_The_Address_field_is");
                    String string5 = MessageFormat.format(string4, this.getName());
                    Message.show(this, string5);
                    this.requestFocusInWindow();
                    return false;
                }
                return true;
            }
            int n = 128;
            if (this.m_bAllow256Length) {
                n = 256;
            }
            if (string3.length() > n) {
                String string6 = res.getString("JTextFieldIPAddress_The_Address_field_is1");
                String string7 = MessageFormat.format(string6, this.getName(), String.valueOf(n));
                Message.show(this, string7);
                this.requestFocusInWindow();
                return false;
            }
            if (string3.indexOf(32) != -1) {
                String string8 = res.getString("JTextFieldIPAddress_The_Address_field_is2");
                String string9 = MessageFormat.format(string8, this.getName());
                Message.show(this, string9);
                this.requestFocusInWindow();
                return false;
            }
            if (!this.m_bDomainNameOnly) {
                try {
                    IpAddress ipAddress = new IpAddress(string3);
                    if (ipAddress.isZeroAddress() && this.m_bNotAllZeros) {
                        String string10 = res.getString("JTextFieldIPAddress_The_Address_field_is4");
                        String string11 = MessageFormat.format(string10, this.getName());
                        Message.show(this, string11);
                        this.requestFocusInWindow();
                        return false;
                    }
                    if (ipAddress.isLoopbackAddress() && this.m_bNoLoopback) {
                        String string12 = res.getString("JTextFieldIPAddress_The_Address_field_is3");
                        String string13 = MessageFormat.format(string12, this.getName());
                        Message.show(this, string13);
                        this.requestFocusInWindow();
                        return false;
                    }
                    if (ipAddress.getLong() == 0xFFFFFFFFL && this.m_bNoBroadcast) {
                        String string14 = res.getString("JTextFieldIPAddress_The_Address_field_is255");
                        String string15 = MessageFormat.format(string14, this.getName());
                        Message.show(this, string15);
                        this.requestFocusInWindow();
                        return false;
                    }
                    return true;
                }
                catch (ExceptionInvalidArgument exceptionInvalidArgument) {
                    if (!this.m_bNumericOnly) break block14;
                    String string16 = res.getString("JTextFieldIPAddress_The_Address_field_is6");
                    String string17 = MessageFormat.format(string16, this.getName());
                    Message.show(this, string17);
                    this.requestFocusInWindow();
                    return false;
                }
            }
        }
        if (!string3.matches(string2 = (string = "[a-zA-Z0-9]([a-zA-Z0-9\\-]*[a-zA-Z0-9])?") + "(\\." + string + ")*")) {
            String string18 = this.m_bDomainNameOnly ? res.getString("JTextFieldIPAddress_The_Address_field_is8") : res.getString("JTextFieldIPAddress_The_Address_field_is7");
            String string19 = MessageFormat.format(string18, this.getName());
            Message.show(this, string19);
            this.requestFocusInWindow();
            return false;
        }
        if (this.m_bFullyQualifiedOnly && string3.indexOf(46) == -1) {
            String string20 = res.getString("JTextFieldIPAddress_The_Address_field_is8");
            String string21 = MessageFormat.format(string20, this.getName());
            Message.show(this, string21);
            this.requestFocusInWindow();
            return false;
        }
        String string22 = ".*[a-zA-Z].*";
        if (!string3.matches(string22)) {
            String string23 = this.m_bDomainNameOnly ? res.getString("JTextFieldIPAddress_The_Address_field_is8") : res.getString("JTextFieldIPAddress_The_Address_field_is6");
            String string24 = MessageFormat.format(string23, this.getName());
            Message.show(this, string24);
            this.requestFocusInWindow();
            return false;
        }
        return true;
    }
}

