/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.components;

import com.avocent.lib.debug.Assert;
import com.avocent.lib.debug.Trace;
import com.avocent.lib.gui.components.InterfaceSortableTableModel;
import com.avocent.lib.gui.components.InterfaceTableModelWrapper;
import com.avocent.lib.util.InterfaceStringComparable;
import com.avocent.lib.util.ReverseComparator;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class TableModelColumnSorted
extends AbstractTableModel
implements InterfaceTableModelWrapper,
InterfaceSortableTableModel {
    public static final int NONE = 1;
    public static final int ASCENDING = 2;
    public static final int DESCENDING = 3;
    protected int m_nCurrentlySortedColumn = -1;
    protected int m_nCurrentSortingMethod = 1;
    protected JTable m_jtTable;
    protected TableModel m_tmPeer;
    protected int[] m_anSortedRowIndex;
    protected Collator m_collator = Collator.getInstance();
    private static final Comparator m_compAscending = new ComparableComparator();
    private static final Comparator m_compDescending = new ReverseComparator(m_compAscending);

    public TableModelColumnSorted() {
        this.m_tmPeer = new DefaultTableModel();
        this.m_collator.setStrength(1);
        this.m_collator.setDecomposition(1);
    }

    public TableModelColumnSorted(JTable jTable) {
        this(jTable.getModel(), jTable);
    }

    public TableModelColumnSorted(TableModel tableModel, JTable jTable) {
        this.m_tmPeer = tableModel;
        this.setTable(jTable);
        this.m_tmPeer.addTableModelListener(this);
        this.m_collator.setStrength(1);
        this.m_collator.setDecomposition(1);
    }

    public synchronized void setTable(JTable jTable) {
        this.m_jtTable = jTable;
        MouseAdapter mouseAdapter = new MouseAdapter(){
            int m_nMousePressedColumn;
            int[] nSelRows;

            public void mousePressed(MouseEvent mouseEvent) {
                int n;
                this.nSelRows = TableModelColumnSorted.this.m_jtTable.getSelectedRows();
                int n2 = TableModelColumnSorted.this.m_jtTable.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                this.m_nMousePressedColumn = n = TableModelColumnSorted.this.m_jtTable.convertColumnIndexToModel(n2);
                TableModelColumnSorted.this.m_jtTable.getTableHeader().repaint();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                int n = TableModelColumnSorted.this.m_jtTable.getColumnModel().getColumnIndexAtX(mouseEvent.getX());
                int n2 = TableModelColumnSorted.this.m_jtTable.convertColumnIndexToModel(n);
                int n3 = 0;
                while (n3 < this.nSelRows.length) {
                    TableModelColumnSorted.this.m_jtTable.addRowSelectionInterval(this.nSelRows[n3], this.nSelRows[n3]);
                    ++n3;
                }
                if (this.m_nMousePressedColumn == n2) {
                    TableModelColumnSorted.this.sortByColumn(n2, true);
                }
                TableModelColumnSorted.this.m_jtTable.getTableHeader().repaint();
            }
        };
        this.m_jtTable.getTableHeader().addMouseListener(mouseAdapter);
        this.m_jtTable.setModel(this);
    }

    public void resort() {
        this.sortByColumn(this.m_nCurrentlySortedColumn, false);
    }

    public synchronized void sortByColumn(int n, boolean bl) {
        int n2;
        if (this.m_nCurrentlySortedColumn != n) {
            this.m_nCurrentSortingMethod = 1;
            n2 = 2;
        } else {
            n2 = this.m_nCurrentSortingMethod;
        }
        this.m_nCurrentlySortedColumn = n;
        if (bl) {
            switch (this.m_nCurrentSortingMethod) {
                case 2: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
                default: {
                    n2 = 2;
                }
            }
        }
        if (n2 != 1) {
            OrderedValueWrapper[] orderedValueWrapperArray = new OrderedValueWrapper[this.getRowCount()];
            int n3 = 0;
            while (n3 < this.getRowCount()) {
                int n4 = this.m_anSortedRowIndex != null && this.getRowCount() == this.m_anSortedRowIndex.length ? this.m_anSortedRowIndex[n3] : n3;
                Object object = this.m_tmPeer.getValueAt(n4, n);
                if (object == null) {
                    Trace.logError((String)"DS NMM TableModelColumnSorted", (String)"Cannot sort table containing null values");
                    return;
                }
                if (!(object instanceof Comparable) && !(object instanceof InterfaceStringComparable)) {
                    Trace.logError((String)"DS NMM TableModelColumnSorted", (String)("Cannot sort table containing object of type (" + object.getClass().getName() + ")."));
                    return;
                }
                if (object instanceof String || object instanceof InterfaceStringComparable && ((InterfaceStringComparable)object).isStringComparable()) {
                    object = this.m_collator.getCollationKey(object.toString());
                }
                boolean bl2 = this.m_jtTable.isRowSelected(n3);
                orderedValueWrapperArray[n3] = new OrderedValueWrapper((Comparable)object, n4, bl2);
                ++n3;
            }
            if (n2 == 3) {
                Arrays.sort(orderedValueWrapperArray, m_compDescending);
            } else {
                Arrays.sort(orderedValueWrapperArray, m_compAscending);
            }
            this.m_anSortedRowIndex = new int[orderedValueWrapperArray.length];
            final boolean[] blArray = new boolean[orderedValueWrapperArray.length];
            int n5 = 0;
            while (n5 < this.m_anSortedRowIndex.length) {
                this.m_anSortedRowIndex[n5] = orderedValueWrapperArray[n5].getRowIndex();
                blArray[n5] = orderedValueWrapperArray[n5].isSelected();
                ++n5;
            }
            Runnable runnable = new Runnable(){

                public void run() {
                    TableModelColumnSorted.this.fireTableDataChanged();
                    int n = 0;
                    while (n < TableModelColumnSorted.this.m_anSortedRowIndex.length) {
                        if (blArray[n]) {
                            TableModelColumnSorted.this.m_jtTable.addRowSelectionInterval(n, n);
                        }
                        ++n;
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    TableModelColumnSorted.this.fireTableDataChanged();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
        this.m_nCurrentSortingMethod = n2;
    }

    public int getSortedRowIndexAt(int n) {
        return this.mapIndex(n);
    }

    protected synchronized void checkTable() {
        if (this.m_anSortedRowIndex != null && this.m_anSortedRowIndex.length != this.m_tmPeer.getRowCount()) {
            this.resort();
        }
    }

    public void fireTableChanged(TableModelEvent tableModelEvent) {
        if (!SwingUtilities.isEventDispatchThread()) {
            final TableModelEvent tableModelEvent2 = tableModelEvent;
            Runnable runnable = new Runnable(){

                public void run() {
                    TableModelColumnSorted.this.localFireTableChanged(tableModelEvent2);
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            this.localFireTableChanged(tableModelEvent);
        }
    }

    private void localFireTableChanged(TableModelEvent tableModelEvent) {
        Assert.isEventDispatchThread();
        super.fireTableChanged(tableModelEvent);
    }

    public void packColumn(int n, int n2) {
        DefaultTableColumnModel defaultTableColumnModel = (DefaultTableColumnModel)this.m_jtTable.getColumnModel();
        TableColumn tableColumn = defaultTableColumnModel.getColumn(n);
        int n3 = 0;
        TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
        if (tableCellRenderer == null) {
            tableCellRenderer = this.m_jtTable.getTableHeader().getDefaultRenderer();
        }
        Component component = tableCellRenderer.getTableCellRendererComponent(this.m_jtTable, tableColumn.getHeaderValue(), false, false, 0, 0);
        n3 = component.getPreferredSize().width;
        int n4 = 0;
        while (n4 < this.m_jtTable.getRowCount()) {
            tableCellRenderer = this.m_jtTable.getCellRenderer(n4, n);
            component = tableCellRenderer.getTableCellRendererComponent(this.m_jtTable, this.m_jtTable.getValueAt(n4, n), false, false, n4, n);
            n3 = Math.max(n3, component.getPreferredSize().width);
            ++n4;
        }
        tableColumn.setPreferredWidth(n3 += 2 * n2);
    }

    public void packAllColumns(int n) {
        int n2 = 0;
        while (n2 < this.getColumnCount()) {
            this.packColumn(n2, n);
            ++n2;
        }
    }

    public int getRowCount() {
        return this.m_tmPeer.getRowCount();
    }

    public int getColumnCount() {
        return this.m_tmPeer.getColumnCount();
    }

    public String getColumnName(int n) {
        return this.m_tmPeer.getColumnName(n);
    }

    public Class getColumnClass(int n) {
        return this.m_tmPeer.getColumnClass(n);
    }

    public boolean isCellEditable(int n, int n2) {
        int n3 = this.mapIndex(n);
        return this.m_tmPeer.isCellEditable(n3, n2);
    }

    public Object getValueAt(int n, int n2) {
        this.checkTable();
        if (this.m_nCurrentSortingMethod == 1) {
            return this.m_tmPeer.getValueAt(n, n2);
        }
        return this.m_tmPeer.getValueAt(this.m_anSortedRowIndex[n], n2);
    }

    public void setValueAt(Object object, int n, int n2) {
        this.checkTable();
        this.m_tmPeer.setValueAt(object, this.mapIndex(n), n2);
    }

    public TableModel getNestedModel() {
        return this.m_tmPeer;
    }

    public int mapIndex(int n) {
        if (this.m_anSortedRowIndex != null) {
            return this.m_anSortedRowIndex[n];
        }
        return n;
    }

    public void sort(int n) {
        int n2 = this.getSortColumn();
        this.sortByColumn(n, n2 == n);
    }

    public int getSortColumn() {
        return this.m_nCurrentlySortedColumn;
    }

    public boolean isAscending() {
        return this.m_nCurrentSortingMethod == 2;
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getColumn();
        if (n == -1) {
            this.resort();
        } else if (n == this.m_nCurrentlySortedColumn) {
            this.sortByColumn(n, true);
        } else if (this.getRowCount() != this.m_anSortedRowIndex.length) {
            this.sortByColumn(n, true);
        } else {
            this.fireTableDataChanged();
        }
    }

    private static class ComparableComparator
    implements Comparator {
        private ComparableComparator() {
        }

        public boolean equals(Object object) {
            return object == this;
        }

        public int compare(Object object, Object object2) {
            return ((Comparable)object).compareTo(object2);
        }
    }

    class OrderedValueWrapper
    implements Comparable {
        Comparable m_cValue;
        int m_nRowIndex;
        boolean m_bIsSelected;

        OrderedValueWrapper(Comparable comparable, int n, boolean bl) {
            this.m_cValue = comparable;
            this.m_nRowIndex = n;
            this.m_bIsSelected = bl;
        }

        Object getValue() {
            return this.m_cValue;
        }

        int getRowIndex() {
            return this.m_nRowIndex;
        }

        boolean isSelected() {
            return this.m_bIsSelected;
        }

        public int compareTo(Object object) {
            if (object instanceof OrderedValueWrapper) {
                return this.m_cValue.compareTo(((OrderedValueWrapper)object).getValue());
            }
            return 0;
        }
    }
}

