/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.dialogs;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.dialogs.JDialogProgress;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class InputStreamProgressMonitoring
extends InputStream {
    protected JDialogProgress m_jdpProgress;
    protected BufferedInputStream m_bisStream;

    public InputStreamProgressMonitoring(File file, JDialogProgress jDialogProgress) throws ExceptionConstructorFailed {
        try {
            this.m_jdpProgress = jDialogProgress;
            this.m_jdpProgress.setRange(0, (int)file.length());
            this.m_bisStream = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.logError((String)"Progress Monitor Input Stream", (String)fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
            throw new ExceptionConstructorFailed(fileNotFoundException.getMessage());
        }
    }

    public InputStreamProgressMonitoring(InputStream inputStream, int n, JDialogProgress jDialogProgress) throws ExceptionConstructorFailed {
        this.m_jdpProgress = jDialogProgress;
        this.m_jdpProgress.setRange(0, n);
        this.m_bisStream = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
    }

    public int read() throws IOException {
        if (this.m_jdpProgress.checkCancelButton()) {
            throw new IOException("User canceled operation.");
        }
        this.m_jdpProgress.offsetValue(1);
        return this.m_bisStream.read();
    }

    public int read(byte[] byArray) throws IOException {
        if (this.m_jdpProgress.checkCancelButton()) {
            throw new IOException("User canceled operation.");
        }
        int n = this.m_bisStream.read(byArray);
        this.m_jdpProgress.offsetValue(n);
        return n;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.m_jdpProgress.checkCancelButton()) {
            throw new IOException("User canceled operation.");
        }
        int n3 = this.m_bisStream.read(byArray, n, n2);
        this.m_jdpProgress.offsetValue(n3);
        return n3;
    }

    public long skip(long l) throws IOException {
        if (this.m_jdpProgress.checkCancelButton()) {
            throw new IOException("User canceled operation.");
        }
        long l2 = this.m_bisStream.skip(l);
        this.m_jdpProgress.offsetValue((int)l2);
        return l2;
    }

    public boolean markSupported() {
        return false;
    }

    public void reset() throws IOException {
        this.m_bisStream.reset();
    }

    public int available() throws IOException {
        return this.m_bisStream.available();
    }

    public void close() throws IOException {
        this.m_bisStream.close();
    }

    public void mark(int n) {
        this.m_bisStream.mark(n);
    }
}

