/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.dialogs;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JDialogCentered
extends JDialog
implements ActionListener {
    protected Container m_cParent = null;
    protected static String ESCAPE_KEY = "Escape Key";
    private int m_nTitleWidth = -1;
    private static final int SCREEN_WIDTH = Toolkit.getDefaultToolkit().getScreenSize().width;

    public JDialogCentered(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.m_cParent = frame;
        this.activateKeyboardControl();
    }

    public JDialogCentered(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.m_cParent = dialog;
        this.activateKeyboardControl();
    }

    public JDialogCentered(Frame frame, boolean bl) {
        super(frame, "", bl);
        this.m_cParent = frame;
        this.activateKeyboardControl();
    }

    public JDialogCentered() {
        super((Dialog)null, "", false);
        this.m_cParent = null;
        this.activateKeyboardControl();
    }

    public void setVisible(boolean bl) {
        if (bl && !this.isVisible()) {
            Rectangle rectangle = null;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            rectangle = this.m_cParent == null || !this.m_cParent.isVisible() ? new Rectangle(0, 0, (int)dimension.getWidth(), (int)dimension.getHeight()) : this.m_cParent.getBounds();
            Rectangle rectangle2 = this.getBounds();
            int n = rectangle.x + (rectangle.width - rectangle2.width) / 2;
            int n2 = rectangle.y + (rectangle.height - rectangle2.height) / 2;
            if (n < 0) {
                n = 0;
            } else if ((double)(n + rectangle2.width) >= dimension.getWidth()) {
                n = (int)dimension.getWidth() - rectangle2.width;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if ((double)(n2 + rectangle2.height) >= dimension.getHeight()) {
                n2 = (int)dimension.getHeight() - rectangle2.height;
            }
            this.setLocation(n, n2);
        }
        super.setVisible(bl);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        int n = this.getTitleBarWidth();
        if (n > dimension.width) {
            dimension.width = n;
        }
        return dimension;
    }

    public void setTitle(String string) {
        this.m_nTitleWidth = -1;
        super.setTitle(string);
        if (this.isVisible()) {
            this.pack();
        }
    }

    private int getTitleBarWidth() {
        if (this.m_nTitleWidth >= 0) {
            return this.m_nTitleWidth;
        }
        String string = this.getTitle();
        if (string == null) {
            string = "";
        }
        Font font = UIManager.getFont("InternalFrame.titleFont");
        this.m_nTitleWidth = SwingUtilities.computeStringWidth(this.getFontMetrics(font), string);
        this.m_nTitleWidth += UIManager.getIcon("InternalFrame.maximizeIcon").getIconWidth() + UIManager.getIcon("InternalFrame.minimizeIcon").getIconWidth() + UIManager.getIcon("InternalFrame.closeIcon").getIconWidth() + UIManager.getIcon("InternalFrame.icon").getIconWidth();
        this.m_nTitleWidth = (int)((double)this.m_nTitleWidth / 0.8);
        if (this.m_nTitleWidth > SCREEN_WIDTH) {
            this.m_nTitleWidth = SCREEN_WIDTH;
        }
        return this.m_nTitleWidth;
    }

    private void activateKeyboardControl() {
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY, KeyStroke.getKeyStroke(27, 0), 2);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ESCAPE_KEY) && !this.doEscape()) {
            this.setVisible(false);
            this.dispose();
        }
    }

    public boolean doEscape() {
        return false;
    }
}

