/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.dialogs;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

public class JDialogPassword
extends JDialogCentered {
    public static final String CNAME = "JDialogPassword";
    private static ResourceManager res = ResourceManager.getManager((String)"com.avocent.lib.gui.dialogs.Res");
    private static final String TRACE_CONTEXT = "JDialogProgress";
    private static final String DEFAULT_TITLE = res.getString("JDialogPassword_Enter_Password");
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    public static final int CLOSED_OPTION = -1;
    private String m_szPassword = null;
    private char[] m_acPassword = null;
    private int m_nValue = -1;
    JPanel m_jPanel = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JLabel m_jlPassword = new JLabel();
    JPasswordField m_jpfPassword = new JPasswordField();
    JLabel m_jlPasswordVerify = new JLabel();
    JPasswordField m_jpfPasswordVerify = new JPasswordField();
    JPanel m_jpButtonPanel = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JButton m_jbOk = new JButton();
    JButton m_jbCancel = new JButton();

    public JDialogPassword(Frame frame) throws ExceptionConstructorFailed {
        this(frame, DEFAULT_TITLE);
    }

    public JDialogPassword(Frame frame, String string) throws ExceptionConstructorFailed {
        super(frame, string, true);
        try {
            this.jbInit();
            this.setTitle(string);
            ButtonPanel.equalize(this.m_jpButtonPanel);
            this.pack();
            this.setResizable(false);
            this.m_jpfPassword.requestFocus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JDialogPassword(Dialog dialog) throws ExceptionConstructorFailed {
        this(dialog, DEFAULT_TITLE);
    }

    public JDialogPassword(Dialog dialog, String string) throws ExceptionConstructorFailed {
        super(dialog, string, true);
        try {
            this.jbInit();
            this.setTitle(string);
            ButtonPanel.equalize(this.m_jpButtonPanel);
            this.pack();
            this.setResizable(false);
            this.m_jpfPassword.requestFocus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.m_jPanel.setLayout(this.gridBagLayout1);
        this.getContentPane().add(this.m_jPanel);
        this.m_jlPassword.setText(res.getString("JDialogPassword_Password_"));
        this.m_jlPasswordVerify.setText(res.getString("JDialogPassword_Verify_Password_"));
        this.m_jpfPassword.setPreferredSize(new Dimension(116, 21));
        this.m_jpfPasswordVerify.setPreferredSize(new Dimension(116, 21));
        this.m_jpButtonPanel.setLayout(this.gridBagLayout2);
        this.m_jbOk.setText(res.getString("JDialogPassword_OK"));
        this.m_jbCancel.setText(res.getString("JDialogPassword_Cancel"));
        this.getRootPane().setDefaultButton(this.m_jbOk);
        this.m_jbOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogPassword.this.m_jbOk_actionPerformed(actionEvent);
            }
        });
        this.m_jbCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogPassword.this.m_jbCancel_actionPerformed(actionEvent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JDialogPassword.this.this_windowClosing(windowEvent);
            }
        });
        this.m_jPanel.add((Component)this.m_jlPassword, new GridBagConstraints(-1, 0, 1, 1, 0.0, 0.5, 17, 0, new Insets(20, 20, 5, 5), 0, 0));
        this.m_jPanel.add((Component)this.m_jpfPassword, new GridBagConstraints(-1, 0, 0, 1, 1.0, 0.5, 10, 2, new Insets(20, 5, 5, 30), 1, 1));
        this.m_jPanel.add((Component)this.m_jlPasswordVerify, new GridBagConstraints(-1, 1, 1, 1, 0.0, 0.5, 17, 0, new Insets(5, 20, 5, 5), 0, 0));
        this.m_jPanel.add((Component)this.m_jpfPasswordVerify, new GridBagConstraints(-1, 1, 0, 1, 1.0, 0.5, 10, 2, new Insets(5, 5, 5, 30), 1, 1));
        this.m_jPanel.add((Component)this.m_jpButtonPanel, new GridBagConstraints(-1, 2, 0, 1, 1.0, 0.9, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_jpButtonPanel.add((Component)this.m_jbOk, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.m_jpButtonPanel.add((Component)this.m_jbCancel, new GridBagConstraints(-1, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 10, 5, 10), 0, 0));
        this.getContentPane().add((Component)this.m_jPanel, "Center");
    }

    public static int showDialog(Frame frame, StringBuffer stringBuffer) throws ExceptionInvalidArgument {
        return JDialogPassword.showDialog(frame, DEFAULT_TITLE, stringBuffer);
    }

    public static int showDialog(Frame frame, String string, StringBuffer stringBuffer) throws ExceptionInvalidArgument {
        if (stringBuffer == null || stringBuffer.length() != 0) {
            String string2 = "Invalid argument: sbPassword, the given StringBuffer must not be null and must be of length zero.";
            Trace.logError((String)TRACE_CONTEXT, (String)string2);
            throw new ExceptionInvalidArgument(string2);
        }
        JDialogPassword jDialogPassword = null;
        try {
            jDialogPassword = new JDialogPassword(frame, string);
            jDialogPassword.setVisible(true);
        }
        catch (ExceptionConstructorFailed exceptionConstructorFailed) {
            // empty catch block
        }
        int n = -1;
        if (jDialogPassword != null) {
            n = jDialogPassword.getValue();
            if (n == 0) {
                char[] cArray = jDialogPassword.getPassword();
                if (cArray == null || cArray.length == 0) {
                    stringBuffer = null;
                } else {
                    stringBuffer.append(cArray);
                }
            } else {
                stringBuffer = null;
            }
            jDialogPassword.dispose();
        } else {
            stringBuffer = null;
        }
        return n;
    }

    public static int showDialog(Dialog dialog, StringBuffer stringBuffer) throws ExceptionInvalidArgument {
        return JDialogPassword.showDialog(dialog, DEFAULT_TITLE, stringBuffer);
    }

    public static int showDialog(Dialog dialog, String string, StringBuffer stringBuffer) throws ExceptionInvalidArgument {
        return JDialogPassword.showDialog(dialog, string, stringBuffer, true);
    }

    public static int showDialog(Dialog dialog, String string, StringBuffer stringBuffer, boolean bl) throws ExceptionInvalidArgument {
        if (stringBuffer == null || stringBuffer.length() != 0) {
            String string2 = "Invalid argument: sbPassword, the given StringBuffer must not be null and must be of length zero.";
            Trace.logError((String)TRACE_CONTEXT, (String)string2);
            throw new ExceptionInvalidArgument(string2);
        }
        JDialogPassword jDialogPassword = null;
        try {
            jDialogPassword = new JDialogPassword(dialog, string);
            jDialogPassword.m_jlPasswordVerify.setVisible(bl);
            jDialogPassword.m_jpfPasswordVerify.setVisible(bl);
            jDialogPassword.pack();
            jDialogPassword.setVisible(true);
        }
        catch (ExceptionConstructorFailed exceptionConstructorFailed) {
            // empty catch block
        }
        int n = -1;
        if (jDialogPassword != null) {
            n = jDialogPassword.getValue();
            if (n == 0) {
                char[] cArray = jDialogPassword.getPassword();
                if (cArray == null || cArray.length == 0) {
                    stringBuffer = null;
                } else {
                    stringBuffer.append(cArray);
                }
            } else {
                stringBuffer = null;
            }
            jDialogPassword.dispose();
        } else {
            stringBuffer = null;
        }
        return n;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.getRootPane().setDefaultButton(this.m_jbOk);
        }
        super.setVisible(bl);
    }

    public void setValue(int n) {
        this.m_nValue = n;
    }

    public int getValue() {
        return this.m_nValue;
    }

    public String getStringPassword() {
        return this.m_szPassword;
    }

    public char[] getPassword() {
        return this.m_acPassword;
    }

    private void m_jbOk_actionPerformed(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("OK pressed. \"" + this.getTitle() + "\" dialog is closing..."));
        char[] cArray = this.m_jpfPassword.getPassword();
        String string = new String(cArray).trim();
        if (!this.m_jpfPasswordVerify.isVisible()) {
            this.m_acPassword = cArray;
            this.m_szPassword = string;
            this.m_nValue = 0;
            this.setVisible(false);
        } else {
            char[] cArray2 = this.m_jpfPasswordVerify.getPassword();
            String string2 = new String(cArray2).trim();
            if (string.length() == 0 && string2.length() == 0) {
                this.m_acPassword = null;
                this.m_szPassword = null;
                this.m_nValue = 0;
                this.setVisible(false);
            } else if (string.length() == 0 || string2.length() == 0 || !string.equals(string2)) {
                Message.show(this, res.getString("JDialogPassword_password_mismatch"));
                this.m_jpfPasswordVerify.requestFocus();
            } else {
                this.m_acPassword = cArray;
                this.m_szPassword = string;
                this.m_nValue = 0;
                this.setVisible(false);
            }
        }
    }

    private void m_jbCancel_actionPerformed(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("Cancel pressed. \"" + this.getTitle() + "\" dialog is closing..."));
        this.m_nValue = 1;
        this.setVisible(false);
    }

    private void this_windowClosing(WindowEvent windowEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("\"" + this.getTitle() + "\" dialog is closing..."));
        this.m_nValue = -1;
        this.dispose();
    }

    public boolean doEscape() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("<ESC> key pressed. \"" + this.getTitle() + "\" dialog is closing..."));
        this.m_nValue = -1;
        return false;
    }
}

