/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.dialogs;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.gui.components.JWrappingLabel;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class JDialogProgress
extends JDialogCentered {
    public static final String CNAME = "JDialogProgress";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.lib.gui.dialogs.Res");
    JPanel panelControls = new JPanel();
    JWrappingLabel jWrappingLabelStatus = new JWrappingLabel();
    JProgressBar jProgressBar1 = new JProgressBar();
    JButton jButtonCancel = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private String m_szTitle = res.getString("JDialogProgress_In_Progress");
    private boolean m_bCancel = false;
    private boolean m_bParentDisabled = false;
    private int m_nLower = 0;
    private int m_nUpper = 100;
    private int m_nStep = 1;
    private int m_nValue = 0;
    protected Vector m_vListenerList = new Vector();

    public JDialogProgress(Frame frame, String string) {
        this(frame, string, false);
    }

    public JDialogProgress(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        try {
            this.jbInit();
            this.pack();
            this.setModal(false);
            this.setResizable(false);
            this.m_bCancel = false;
            this.jButtonCancel.requestFocus();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JDialogProgress(Dialog dialog, String string) {
        this(dialog, string, false);
    }

    public JDialogProgress(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        try {
            this.jbInit();
            this.pack();
            this.setModal(false);
            this.setResizable(false);
            this.m_bCancel = false;
            this.jButtonCancel.requestFocus();
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    JDialogProgress.this.m_bCancel = true;
                    JDialogProgress.this.fireCancelButtonPressed(null);
                }
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JDialogProgress() {
        this((Dialog)null, "", false);
    }

    void jbInit() throws Exception {
        this.panelControls.setLayout(this.gridBagLayout1);
        this.jButtonCancel.setText(res.getString("JDialogProgress_Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogProgress.this.jButtonCancel_actionPerformed(actionEvent);
            }
        });
        this.panelControls.add((Component)this.jWrappingLabelStatus, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(12, 12, 0, 12), 0, 0));
        this.panelControls.add((Component)this.jProgressBar1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(17, 12, 0, 12), 150, 3));
        this.panelControls.add((Component)this.jButtonCancel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(17, 12, 12, 12), 0, 0));
        this.getContentPane().add((Component)this.panelControls, "South");
    }

    void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        this.m_bCancel = true;
        this.fireCancelButtonPressed(actionEvent);
    }

    public boolean checkCancelButton() {
        boolean bl = this.m_bCancel;
        this.m_bCancel = false;
        return bl;
    }

    public void setEnableCancelButton(boolean bl) {
        this.jButtonCancel.setEnabled(bl);
    }

    public boolean isEnableCancelButton() {
        return this.jButtonCancel.isEnabled();
    }

    public void setStatusMessage(String string) {
        this.jWrappingLabelStatus.setText(string);
    }

    public int getPercentValue() {
        return this.jProgressBar1.getValue();
    }

    public int getLowerLimit() {
        return this.m_nLower;
    }

    public int getUpperLimit() {
        return this.m_nUpper;
    }

    public void setPercentValue(int n) {
        this.jProgressBar1.setValue(n);
    }

    public void disableParent() {
        this.m_cParent.setEnabled(false);
        this.m_bParentDisabled = true;
    }

    public void reEnableParent() {
        if (this.m_bParentDisabled) {
            this.m_cParent.setEnabled(true);
            this.m_bParentDisabled = false;
        }
    }

    public void setRange(int n, int n2) {
        if (n >= n2) {
            Trace.logError((String)"Progress", (String)("Invalid range:Lower=" + Integer.toString(n) + " Upper=" + Integer.toString(n2)));
            return;
        }
        this.m_nLower = n;
        this.m_nUpper = n2;
    }

    public void setValue(int n) {
        this.m_nValue = n < this.m_nLower ? this.m_nLower : (n > this.m_nUpper ? this.m_nUpper : n);
        int n2 = this.m_nUpper - this.m_nLower;
        if (n2 <= 0) {
            Trace.logError((String)"Progress", (String)("Divisor <= 0:Lower=" + Integer.toString(this.m_nLower) + " Upper=" + Integer.toString(this.m_nUpper)));
            return;
        }
        int n3 = n - this.m_nLower;
        int n4 = n3 * 100 / n2;
        this.setPercentValue(n4);
    }

    public void setStep(int n) {
        this.m_nStep = n;
    }

    public void offsetValue(int n) {
        int n2 = this.m_nValue + n;
        this.setValue(n2);
    }

    public void stepIt() {
        int n = this.m_nValue + this.m_nStep;
        this.setValue(n);
    }

    public void addListener(ActionListener actionListener) {
        this.m_vListenerList.addElement(actionListener);
    }

    public void removeListener(ActionListener actionListener) {
        this.m_vListenerList.removeElement(actionListener);
    }

    protected void fireCancelButtonPressed(ActionEvent actionEvent) {
        int n = 0;
        while (n < this.m_vListenerList.size()) {
            ((ActionListener)this.m_vListenerList.elementAt(n)).actionPerformed(actionEvent);
            ++n;
        }
    }
}

