/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.dialogs;

import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.dialogs.JOptionPaneFixedSize;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.dialogs.RunnerB;
import com.avocent.lib.gui.dialogs.RunnerM;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.FileChooserUI;
import javax.swing.plaf.basic.BasicFileChooserUI;
import javax.swing.plaf.metal.MetalFileChooserUI;

public class JFileChooserDialog
extends JFileChooser {
    public static final String CNAME = "JFileChooserDialog";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.lib.gui.dialogs.Res");
    private static String m_szInitDirectory = ".";
    private String m_szFileExistsWarn = res.getString("JFileChooserDialog_The_file_exists");
    private String m_szInvalidFileName = res.getString("JFileChooserDialog_Invalid_text_in_the");
    private String m_szTitle = res.getString("JFileChooserDialog_Open_File");
    private String m_szButton = res.getString("JFileChooserDialog_Open");
    private String m_szAllFilesExt = "*";
    private String m_szEmptyFile = "";
    private String m_szDotExt = ".";
    private File m_fEmptyFile = new File(this.m_szEmptyFile);
    private String m_szSelectedFileExt = null;
    private File m_fSelectedFile = null;
    private String m_szSelectedFile = null;
    private boolean m_bIsNoFileSelected = true;
    private Component m_parent = null;
    private Properties m_propFilters = new Properties();
    private Hashtable m_hashFilters = new Hashtable();
    private boolean m_bIsAllFilesFilter = false;
    private boolean m_bIsSelectedAllFilesFilter = false;
    private boolean m_bIsFilterChanged = false;
    private boolean m_bIsOpenMode = false;

    public JFileChooserDialog(boolean bl) {
        this(null, bl);
    }

    public JFileChooserDialog(Component component, boolean bl) {
        super(m_szInitDirectory);
        this.m_bIsOpenMode = bl;
        this.m_parent = component;
        this.m_bIsAllFilesFilter = true;
        this.setAcceptAllFileFilterUsed(true);
        this.initDialog();
    }

    public JFileChooserDialog(Component component, Properties properties, String string, String string2, String string3, boolean bl) throws ExceptionConstructorFailed {
        this(component, properties, string, string2, string3, bl, m_szInitDirectory);
    }

    public JFileChooserDialog(Component component, Properties properties, String string, String string2, String string3, boolean bl, String string4) throws ExceptionConstructorFailed {
        super(string4);
        this.m_parent = component;
        this.m_propFilters = properties;
        if (this.m_propFilters == null) {
            this.m_bIsAllFilesFilter = true;
            this.setAcceptAllFileFilterUsed(true);
        } else if (this.m_propFilters.containsKey(this.m_szAllFilesExt)) {
            this.m_bIsAllFilesFilter = true;
            this.setAcceptAllFileFilterUsed(true);
        } else {
            this.m_bIsAllFilesFilter = false;
            this.setAcceptAllFileFilterUsed(false);
        }
        if (string == null) {
            throw new ExceptionConstructorFailed("Parameter szSelectedFileExt cannot be null");
        }
        this.m_szSelectedFileExt = string;
        this.m_szTitle = string2;
        this.m_szButton = string3;
        this.m_bIsOpenMode = bl;
        this.initDialog();
    }

    private void keepFileNameValue(JFileChooser jFileChooser) {
        FileChooserUI fileChooserUI = jFileChooser.getUI();
        if (fileChooserUI instanceof BasicFileChooserUI) {
            BasicFileChooserUI basicFileChooserUI = (BasicFileChooserUI)jFileChooser.getUI();
            RunnerB runnerB = new RunnerB(basicFileChooserUI, basicFileChooserUI.getFileName());
            SwingUtilities.invokeLater(runnerB);
        } else if (fileChooserUI instanceof MetalFileChooserUI) {
            MetalFileChooserUI metalFileChooserUI = (MetalFileChooserUI)jFileChooser.getUI();
            RunnerM runnerM = new RunnerM(metalFileChooserUI, metalFileChooserUI.getFileName());
            SwingUtilities.invokeLater(runnerM);
        }
    }

    private void initDialog() {
        String string = "";
        String string2 = "";
        FileFilterInfo fileFilterInfo = null;
        FileFilterInfo fileFilterInfo2 = null;
        this.setDialogTitle(this.m_szTitle);
        int n = 0;
        Enumeration<?> enumeration = this.m_propFilters.propertyNames();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            string2 = this.m_propFilters.getProperty(string);
            fileFilterInfo = new FileFilterInfo(string, string2);
            this.m_hashFilters.put(string, fileFilterInfo);
            if (!string.equals(this.m_szAllFilesExt)) {
                this.addChoosableFileFilter(fileFilterInfo);
            }
            if (this.m_szSelectedFileExt.equals(string) && fileFilterInfo != null) {
                fileFilterInfo2 = fileFilterInfo;
            }
            ++n;
        }
        if (fileFilterInfo2 != null) {
            this.setFileFilter(fileFilterInfo2);
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                JFileChooser jFileChooser = (JFileChooser)propertyChangeEvent.getSource();
                if (string.equals("fileFilterChanged")) {
                    if (propertyChangeEvent.getNewValue() instanceof FileFilterInfo) {
                        JFileChooserDialog.this.m_bIsSelectedAllFilesFilter = false;
                        FileFilterInfo fileFilterInfo = (FileFilterInfo)propertyChangeEvent.getNewValue();
                        JFileChooserDialog.this.m_szSelectedFileExt = fileFilterInfo.getExtension();
                    } else {
                        JFileChooserDialog.this.m_bIsSelectedAllFilesFilter = true;
                    }
                    JFileChooserDialog.this.m_bIsFilterChanged = true;
                    JFileChooserDialog.this.keepFileNameValue(jFileChooser);
                } else if (string.equals("SelectedFileChangedProperty")) {
                    JFileChooserDialog.this.m_fSelectedFile = jFileChooser.getSelectedFile();
                    if (JFileChooserDialog.this.m_fSelectedFile == null || JFileChooserDialog.this.m_fSelectedFile.isDirectory()) {
                        // empty if block
                    }
                }
            }
        };
        this.addPropertyChangeListener(propertyChangeListener);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = (JFileChooser)actionEvent.getSource();
                JFileChooserDialog.this.m_fSelectedFile = jFileChooser.getSelectedFile();
                if (JFileChooserDialog.this.m_fSelectedFile == null) {
                    JFileChooserDialog.this.m_bIsNoFileSelected = true;
                }
            }
        };
        this.addActionListener(actionListener);
    }

    public int showDialog(Component component, String string) {
        int n;
        block11: {
            block10: {
                block12: {
                    n = -1;
                    while (true) {
                        this.m_bIsNoFileSelected = false;
                        boolean bl = false;
                        n = super.showDialog(component, string);
                        if (n == 1) {
                            return n;
                        }
                        if (n != 0) break block10;
                        if (this.m_bIsNoFileSelected && !this.m_bIsFilterChanged) {
                            Message.show(component, this.m_szInvalidFileName);
                            continue;
                        }
                        if (this.m_bIsSelectedAllFilesFilter) {
                            if (this.m_fSelectedFile.exists()) {
                                bl = true;
                            }
                        } else {
                            String string2 = this.getSelectedFileExt();
                            if (string2 != null) {
                                String string3 = this.m_fSelectedFile.getAbsolutePath();
                                if (!string3.endsWith(string2)) {
                                    this.m_fSelectedFile = new File(string3 + this.m_szDotExt + string2);
                                    this.setSelectedFile(this.m_fSelectedFile);
                                }
                                if (this.m_fSelectedFile.exists()) {
                                    bl = true;
                                }
                            }
                        }
                        if (this.m_fSelectedFile.getName().equals(this.m_szEmptyFile) || this.m_bIsOpenMode || !bl) break;
                        if (JOptionPaneFixedSize.showConfirmDialog(component, this.m_szFileExistsWarn, this.m_szTitle, 0, 2) != 0) {
                            this.m_bIsNoFileSelected = true;
                            this.setSelectedFile(this.m_fEmptyFile);
                            continue;
                        }
                        break block11;
                        break;
                    }
                    if (!this.m_fSelectedFile.getName().equals(this.m_szEmptyFile)) break block12;
                    n = -1;
                    break block11;
                }
                if (this.m_bIsSelectedAllFilesFilter || this.getSelectedFileExt() != null) break block11;
                this.m_fSelectedFile = new File(this.m_fSelectedFile.getAbsolutePath() + this.m_szDotExt + this.m_szSelectedFileExt);
                this.setSelectedFile(this.m_fSelectedFile);
                break block11;
            }
            n = -1;
        }
        return n;
    }

    private String getSelectedFileExt() {
        String string = null;
        String string2 = null;
        if (!this.m_bIsSelectedAllFilesFilter) {
            return this.m_szSelectedFileExt;
        }
        Enumeration enumeration = this.m_hashFilters.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            if (!this.m_fSelectedFile.getName().endsWith(this.m_szDotExt + string)) continue;
            string2 = string;
            break;
        }
        return string2;
    }

    public void setSelectedFile(File file) {
        if (file == null || !file.isDirectory()) {
            this.m_fSelectedFile = file;
            super.setSelectedFile(this.m_fSelectedFile);
        }
    }

    public File getSelectedFile() {
        return this.m_fSelectedFile;
    }

    public Properties getPropFilters() {
        return this.m_propFilters;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getLayout().preferredLayoutSize(this);
        return dimension;
    }

    class FileFilterInfo
    extends FileFilter {
        private String m_description = null;
        private String m_extension = null;

        public FileFilterInfo(String string, String string2) {
            this.m_description = string2;
            this.m_extension = string.toLowerCase();
        }

        public String getDescription() {
            return this.m_description;
        }

        public String getExtension() {
            return this.m_extension;
        }

        public boolean accept(File file) {
            if (file == null) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().toLowerCase().endsWith(this.m_extension);
        }
    }
}

