/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.dialogs;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.gui.dialogs.JDialogProgress;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class OutputStreamProgressMonitoring
extends OutputStream {
    protected JDialogProgress m_jdpProgress;
    protected BufferedOutputStream m_bosStream;

    public OutputStreamProgressMonitoring(File file, long l, JDialogProgress jDialogProgress) throws ExceptionConstructorFailed {
        try {
            this.m_jdpProgress = jDialogProgress;
            this.m_jdpProgress.setRange(0, (int)l);
            this.m_bosStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Trace.logError((String)"Progress Monitor Input Stream", (String)fileNotFoundException.getMessage(), (Throwable)fileNotFoundException);
            throw new ExceptionConstructorFailed(fileNotFoundException.getMessage());
        }
    }

    public OutputStreamProgressMonitoring(OutputStream outputStream, int n, JDialogProgress jDialogProgress) throws ExceptionConstructorFailed {
        this.m_jdpProgress = jDialogProgress;
        this.m_jdpProgress.setRange(0, n);
        this.m_bosStream = outputStream instanceof BufferedOutputStream ? (BufferedOutputStream)outputStream : new BufferedOutputStream(outputStream);
    }

    public void write(byte[] byArray) throws IOException {
        if (this.m_jdpProgress.checkCancelButton()) {
            throw new IOException("User canceled operation.");
        }
        this.m_jdpProgress.offsetValue(byArray.length);
        this.m_bosStream.write(byArray);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.m_jdpProgress.checkCancelButton()) {
            throw new IOException("User canceled operation.");
        }
        this.m_jdpProgress.offsetValue(n2);
        this.m_bosStream.write(byArray, n, n2);
    }

    public void write(int n) throws IOException {
        this.m_jdpProgress.offsetValue(1);
        this.m_bosStream.write(n);
    }

    public void flush() throws IOException {
        this.m_bosStream.flush();
    }

    public void close() throws IOException {
        this.m_bosStream.close();
    }
}

