/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.panels;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.gui.panels.BackgroundImage;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JPanel;

public class JPanelBackgroundImages
extends JPanel {
    private Vector m_vImages = new Vector();

    public JPanelBackgroundImages() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void jbInit() throws Exception {
    }

    public void addImage(BackgroundImage backgroundImage) {
        this.m_vImages.addElement(backgroundImage);
    }

    protected void paintComponent(Graphics graphics) {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        graphics.setColor(this.getBackground());
        Rectangle rectangle = new Rectangle(insets.left, insets.top, dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n = 0;
        while (n < this.m_vImages.size()) {
            BackgroundImage backgroundImage = (BackgroundImage)this.m_vImages.elementAt(n);
            switch (backgroundImage.getStyle()) {
                case 1: {
                    this.drawNormalImage(graphics, rectangle, backgroundImage.getImage(), backgroundImage.getPosition());
                    break;
                }
                case 2: {
                    JPanelBackgroundImages.drawStretchedImage(graphics, rectangle, backgroundImage.getImage());
                    break;
                }
                case 3: {
                    JPanelBackgroundImages.drawTiledImage(graphics, rectangle, backgroundImage.getImage());
                    break;
                }
                default: {
                    Trace.logError((String)"JPanelBackgroundImages", (String)"Invalid Image Style");
                }
            }
            ++n;
        }
    }

    private void drawNormalImage(Graphics graphics, Rectangle rectangle, Image image, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        switch (n) {
            case 1: {
                n2 = rectangle.x + (rectangle.width - n4) / 2;
                n3 = rectangle.y;
                break;
            }
            case 2: {
                n2 = rectangle.x + (rectangle.width - n4);
                n3 = rectangle.y;
                break;
            }
            case 3: {
                n2 = rectangle.x + (rectangle.width - n4);
                n3 = rectangle.y + (rectangle.height - n5) / 2;
                break;
            }
            case 4: {
                n2 = rectangle.x + (rectangle.width - n4);
                n3 = rectangle.y + (rectangle.height - n5);
                break;
            }
            case 5: {
                n2 = rectangle.x + (rectangle.width - n4) / 2;
                n3 = rectangle.y + (rectangle.height - n5);
                break;
            }
            case 6: {
                n2 = rectangle.x;
                n3 = rectangle.y + (rectangle.height - n5);
                break;
            }
            case 7: {
                n2 = rectangle.x;
                n3 = rectangle.y + (rectangle.height - n5) / 2;
                break;
            }
            case 8: {
                n2 = rectangle.x;
                n3 = rectangle.y;
                break;
            }
            case 0: {
                n2 = rectangle.x + (rectangle.width - n4) / 2;
                n3 = rectangle.y + (rectangle.height - n5) / 2;
            }
        }
        graphics.drawImage(image, n2, n3, null);
    }

    private static void drawStretchedImage(Graphics graphics, Rectangle rectangle, Image image) {
        graphics.drawImage(image, rectangle.x, rectangle.y, rectangle.width, rectangle.height, null);
    }

    private static void drawTiledImage(Graphics graphics, Rectangle rectangle, Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        int n3 = rectangle.x;
        while (n3 < rectangle.x + rectangle.width) {
            int n4 = rectangle.y;
            while (n4 < rectangle.y + rectangle.height) {
                graphics.drawImage(image, n3, n4, null);
                n4 += n2;
            }
            n3 += n;
        }
    }
}

