/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.panels;

import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.exceptions.ExceptionNoValue;
import com.avocent.lib.gui.panels.ButtonSelector;
import com.avocent.lib.gui.panels.InterfaceSelectorPanel;
import com.avocent.lib.gui.panels.TabSelector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class JPanelSelector
extends JPanel
implements InterfaceSelectorPanel,
ActionListener {
    public static final int STYLE_BUTTON = 1;
    public static final int STYLE_TAB = 2;
    private int m_nStyle = 1;
    private ButtonGroup m_buttongroup = new ButtonGroup();
    private GridBagLayout m_gridBagLayout = new GridBagLayout();
    private int m_nJustifyButtons = 3;
    Color m_colorNormalText = new Color(192, 192, 192);
    Color m_colorSelectedText = new Color(255, 255, 255);
    Color m_colorNormalTab = new Color(128, 0, 0);
    Color m_colorSelectedTab = new Color(220, 0, 0);
    Color m_colorTabHighlight = new Color(255, 0, 0);
    Color m_colorTabShadow = new Color(92, 0, 0);

    public JPanelSelector(int n, Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
        this.m_nStyle = 2;
        this.m_colorNormalText = color;
        this.m_colorSelectedText = color2;
        this.m_colorNormalTab = color3;
        this.m_colorSelectedTab = color4;
        this.m_colorTabHighlight = color5;
        this.m_colorTabShadow = color6;
        this.m_nJustifyButtons = n;
        this.setOpaque(false);
        super.setLayout(this.m_gridBagLayout);
    }

    public JPanelSelector(int n, Color color, Color color2) {
        this.m_nStyle = 1;
        this.m_colorNormalText = color;
        this.m_colorSelectedText = color2;
        this.m_nJustifyButtons = n;
        this.setOpaque(false);
        super.setLayout(this.m_gridBagLayout);
    }

    public void addSelector(int n, ImageIcon imageIcon, ImageIcon imageIcon2, String string, ActionListener actionListener) {
        Border border;
        ButtonSelector buttonSelector;
        if (this.m_nStyle == 1) {
            buttonSelector = new ButtonSelector(n, string);
            buttonSelector.addActionListener(actionListener);
            buttonSelector.setIcon(imageIcon);
            buttonSelector.setSelectedIcon(imageIcon2);
            buttonSelector.setPressedIcon(imageIcon2);
            buttonSelector.setBorderPainted(false);
            buttonSelector.setFocusPainted(false);
            buttonSelector.setContentAreaFilled(false);
            buttonSelector.setMargin(new Insets(15, 15, 15, 15));
            border = BorderFactory.createEmptyBorder();
            buttonSelector.setBorder(border);
            buttonSelector.setCursor(new Cursor(12));
            buttonSelector.setHorizontalTextPosition(0);
            buttonSelector.setVerticalTextPosition(3);
            buttonSelector.setForeground(this.m_colorNormalText);
            this.add(buttonSelector);
            this.m_buttongroup.add(buttonSelector);
        }
        if (this.m_nStyle == 2) {
            buttonSelector = new TabSelector(n, string, this.m_colorNormalText, this.m_colorSelectedText, this.m_colorNormalTab, this.m_colorSelectedTab, this.m_colorTabHighlight, this.m_colorTabShadow);
            buttonSelector.addActionListener(actionListener);
            buttonSelector.addActionListener(this);
            buttonSelector.setBorderPainted(false);
            buttonSelector.setFocusPainted(false);
            buttonSelector.setContentAreaFilled(false);
            border = BorderFactory.createEmptyBorder();
            buttonSelector.setBorder(border);
            buttonSelector.setCursor(new Cursor(12));
            this.add(buttonSelector);
            this.m_buttongroup.add(buttonSelector);
        }
        this.updateButtonPositionInfo();
    }

    public void setSelectorText(int n, final String string) throws ExceptionInvalidArgument {
        if (string == null || string.length() == 0) {
            throw new ExceptionInvalidArgument();
        }
        Enumeration<AbstractButton> enumeration = this.m_buttongroup.getElements();
        while (enumeration.hasMoreElements()) {
            try {
                final ButtonSelector buttonSelector = (ButtonSelector)enumeration.nextElement();
                if (buttonSelector.getID() != n) continue;
                if (SwingUtilities.isEventDispatchThread()) {
                    buttonSelector.setText(string);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            buttonSelector.setText(string);
                        }
                    });
                }
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ExceptionInvalidArgument();
    }

    protected void paintComponent(Graphics graphics) {
        if (this.m_nStyle == 2) {
            Dimension dimension = this.getSize();
            Rectangle rectangle = new Rectangle(dimension);
            graphics.setColor(this.m_colorSelectedTab);
            graphics.fillRect(rectangle.x + 0, rectangle.y + 20, rectangle.width, 10);
            graphics.setColor(this.m_colorNormalTab);
            graphics.fillRect(rectangle.x + 0, rectangle.y + 30, rectangle.width, 3);
            graphics.setColor(this.m_colorTabShadow);
            graphics.fillRect(rectangle.x + 0, rectangle.y + 19, rectangle.width, 1);
        }
    }

    public void setLayout(LayoutManager layoutManager) {
    }

    public void updateButtonPositionInfo() {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            Serializable serializable;
            if (this.m_nStyle == 2) {
                try {
                    TabSelector tabSelector = (TabSelector)componentArray[n];
                    serializable = null;
                    if (n >= 1) {
                        serializable = (TabSelector)componentArray[n - 1];
                    }
                    TabSelector tabSelector2 = null;
                    if (n < componentArray.length - 1) {
                        tabSelector2 = (TabSelector)componentArray[n + 1];
                    }
                    tabSelector.setNextPrev((TabSelector)serializable, tabSelector2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (this.m_nJustifyButtons != 0) {
                    int n2 = 0;
                    n2 = this.m_nJustifyButtons == 3 ? 0 : componentArray.length - 1;
                    serializable = (GridBagLayout)this.getLayout();
                    int n3 = this.m_nJustifyButtons == 3 ? 13 : 17;
                    int n4 = 0;
                    if (this.m_nStyle == 1) {
                        n4 = 7;
                    }
                    GridBagConstraints gridBagConstraints = n == n2 ? new GridBagConstraints(n, 0, 1, 1, 0.5, 0.0, n3, 0, new Insets(0, n4, 0, n4), 0, 0) : new GridBagConstraints(n, 0, 1, 1, 0.0, 0.0, n3, 0, new Insets(0, n4, 0, n4), 0, 0);
                    ((GridBagLayout)serializable).setConstraints(componentArray[n], gridBagConstraints);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
    }

    public int getSelection() throws ExceptionNoValue {
        Enumeration<AbstractButton> enumeration = this.m_buttongroup.getElements();
        while (enumeration.hasMoreElements()) {
            try {
                ButtonSelector buttonSelector = (ButtonSelector)enumeration.nextElement();
                if (!buttonSelector.isSelected()) continue;
                return buttonSelector.getID();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ExceptionNoValue();
    }

    public void setSelected(int n) throws ExceptionInvalidArgument {
        Enumeration<AbstractButton> enumeration = this.m_buttongroup.getElements();
        while (enumeration.hasMoreElements()) {
            try {
                ButtonSelector buttonSelector = (ButtonSelector)enumeration.nextElement();
                if (buttonSelector.getID() != n) continue;
                buttonSelector.doClick();
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ExceptionInvalidArgument();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.repaint();
    }
}

