/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.panels;

import com.avocent.lib.gui.panels.ButtonSelector;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javax.swing.SwingUtilities;

public class TabSelector
extends ButtonSelector {
    private TabSelector m_tabPrev = null;
    private TabSelector m_tabNext = null;
    private static final int TAB_SIDE_WIDTH = 18;
    private static final int TAB_HEIGHT = 33;
    private static final int HORZ_TEXT_PAD = 5;
    Color m_colorNormalText = new Color(192, 192, 192);
    Color m_colorSelectedText = new Color(255, 255, 255);
    Color m_colorNormalTab = new Color(128, 0, 0);
    Color m_colorSelectedTab = new Color(220, 0, 0);
    Color m_colorTabHighlight = new Color(255, 0, 0);
    Color m_colorTabShadow = new Color(92, 0, 0);

    TabSelector(int n, String string, Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
        super(n, string);
        this.m_colorNormalText = color;
        this.m_colorSelectedText = color2;
        this.m_colorNormalTab = color3;
        this.m_colorSelectedTab = color4;
        this.m_colorTabHighlight = color5;
        this.m_colorTabShadow = color6;
    }

    public void setNextPrev(TabSelector tabSelector, TabSelector tabSelector2) {
        this.m_tabPrev = tabSelector;
        this.m_tabNext = tabSelector2;
    }

    protected void paintComponent(Graphics graphics) {
        Dimension dimension = this.getSize();
        Rectangle rectangle = new Rectangle(dimension);
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, 18, 33);
        Rectangle rectangle3 = new Rectangle(rectangle.x + rectangle.width - 18, rectangle.y, 18, 33);
        Rectangle rectangle4 = new Rectangle(rectangle.x + 18, rectangle.y, rectangle.width - 18 - 18, 33);
        this.drawMiddle(graphics, rectangle4);
        this.drawText(graphics, rectangle4);
        this.drawTabLeftSide(graphics, rectangle2);
        this.drawTabRightSide(graphics, rectangle3);
    }

    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Graphics graphics = this.getGraphics();
        String string = this.getText();
        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string, graphics);
        Dimension dimension = new Dimension(23 + (int)rectangle2D.getWidth() + 5 + 18, 33);
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension(59, 33);
        return dimension;
    }

    private void drawText(Graphics graphics, Rectangle rectangle) {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        Rectangle rectangle2 = new Rectangle();
        Rectangle rectangle3 = new Rectangle();
        String string = SwingUtilities.layoutCompoundLabel(fontMetrics, this.getText(), null, 3, 0, 0, 0, rectangle, rectangle2, rectangle3, 0);
        if (this.isSelected()) {
            graphics.setColor(this.m_colorSelectedText);
        } else {
            graphics.setColor(this.m_colorNormalText);
        }
        graphics.drawString(string, rectangle3.x, rectangle3.y);
    }

    public void drawMiddle(Graphics graphics, Rectangle rectangle) {
        if (this.isSelected()) {
            graphics.setColor(this.m_colorSelectedTab);
            graphics.fillRect(rectangle.x + 0, rectangle.y + 0, rectangle.width, 30);
            graphics.setColor(this.m_colorNormalTab);
            graphics.fillRect(rectangle.x + 0, rectangle.y + 30, rectangle.width, 3);
        } else {
            graphics.setColor(this.m_colorTabHighlight);
            graphics.fillRect(rectangle.x + 0, rectangle.y + 0, rectangle.width, 2);
            graphics.setColor(this.m_colorNormalTab);
            graphics.fillRect(rectangle.x + 0, rectangle.y + 2, rectangle.width, 17);
            graphics.fillRect(rectangle.x + 0, rectangle.y + 30, rectangle.width, 3);
            graphics.setColor(this.m_colorTabShadow);
            graphics.fillRect(rectangle.x + 0, rectangle.y + 19, rectangle.width, 1);
            graphics.setColor(this.m_colorSelectedTab);
            graphics.fillRect(rectangle.x + 0, rectangle.y + 20, rectangle.width, 10);
        }
    }

    public void drawTabLeftSide(Graphics graphics, Rectangle rectangle) {
        if (this.m_tabPrev == null) {
            if (this.isSelected()) {
                this.drawLeftSide_S(graphics, rectangle);
            } else {
                this.drawLeftSide_N(graphics, rectangle);
            }
        } else if (this.isSelected()) {
            this.drawLeftSideNS(graphics, rectangle);
        } else if (this.m_tabPrev.isSelected()) {
            this.drawLeftSideSN(graphics, rectangle);
        } else {
            this.drawLeftSideNN(graphics, rectangle);
        }
    }

    public void drawTabRightSide(Graphics graphics, Rectangle rectangle) {
        if (this.m_tabNext == null) {
            if (this.isSelected()) {
                this.drawRightSideS_(graphics, rectangle);
            } else {
                this.drawRightSideN_(graphics, rectangle);
            }
        } else if (this.isSelected()) {
            this.drawRightSideSN(graphics, rectangle);
        } else if (this.m_tabNext.isSelected()) {
            this.drawRightSideNS(graphics, rectangle);
        } else {
            this.drawRightSideNN(graphics, rectangle);
        }
    }

    public void drawRightSideS_(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(this.m_colorSelectedTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 0, 2, 30);
        graphics.fillRect(rectangle.x + 2, rectangle.y + 1, 2, 29);
        graphics.fillRect(rectangle.x + 4, rectangle.y + 2, 2, 28);
        graphics.fillRect(rectangle.x + 6, rectangle.y + 3, 1, 27);
        graphics.fillRect(rectangle.x + 7, rectangle.y + 4, 1, 26);
        graphics.fillRect(rectangle.x + 8, rectangle.y + 5, 1, 25);
        graphics.fillRect(rectangle.x + 9, rectangle.y + 7, 1, 23);
        graphics.fillRect(rectangle.x + 10, rectangle.y + 9, 1, 21);
        graphics.fillRect(rectangle.x + 11, rectangle.y + 11, 1, 19);
        graphics.fillRect(rectangle.x + 12, rectangle.y + 14, 1, 16);
        graphics.fillRect(rectangle.x + 13, rectangle.y + 17, 1, 13);
        graphics.fillRect(rectangle.x + 14, rectangle.y + 19, 4, 11);
        graphics.setColor(this.m_colorNormalTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 30, 18, 3);
        graphics.setColor(this.m_colorTabShadow);
        graphics.fillRect(rectangle.x + 15, rectangle.y + 19, 3, 1);
    }

    public void drawRightSideSN(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(this.m_colorSelectedTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 0, 8, 30);
        graphics.fillRect(rectangle.x + 8, rectangle.y + 1, 2, 29);
        graphics.fillRect(rectangle.x + 10, rectangle.y + 2, 2, 28);
        graphics.fillRect(rectangle.x + 12, rectangle.y + 3, 1, 27);
        graphics.fillRect(rectangle.x + 13, rectangle.y + 4, 1, 26);
        graphics.fillRect(rectangle.x + 14, rectangle.y + 5, 1, 25);
        graphics.fillRect(rectangle.x + 15, rectangle.y + 6, 1, 24);
        graphics.fillRect(rectangle.x + 16, rectangle.y + 8, 1, 22);
        graphics.fillRect(rectangle.x + 17, rectangle.y + 11, 1, 19);
        graphics.setColor(this.m_colorNormalTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 30, 18, 3);
    }

    public void drawRightSideNS(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(this.m_colorSelectedTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 20, 18, 10);
        graphics.fillRect(rectangle.x + 16, rectangle.y + 18, 1, 2);
        graphics.fillRect(rectangle.x + 17, rectangle.y + 14, 1, 6);
        graphics.setColor(this.m_colorTabHighlight);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 0, 6, 1);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 1, 7, 1);
        graphics.setColor(this.m_colorNormalTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 2, 12, 17);
        graphics.fillRect(rectangle.x + 6, rectangle.y + 0, 2, 1);
        graphics.fillRect(rectangle.x + 7, rectangle.y + 1, 3, 1);
        graphics.fillRect(rectangle.x + 12, rectangle.y + 3, 1, 16);
        graphics.fillRect(rectangle.x + 13, rectangle.y + 4, 1, 15);
        graphics.fillRect(rectangle.x + 14, rectangle.y + 5, 1, 14);
        graphics.fillRect(rectangle.x + 15, rectangle.y + 6, 1, 12);
        graphics.fillRect(rectangle.x + 16, rectangle.y + 8, 1, 7);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 30, 18, 3);
        graphics.setColor(this.m_colorTabShadow);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 19, 16, 1);
        graphics.fillRect(rectangle.x + 15, rectangle.y + 18, 1, 2);
        graphics.fillRect(rectangle.x + 16, rectangle.y + 15, 1, 3);
        graphics.fillRect(rectangle.x + 17, rectangle.y + 11, 1, 4);
    }

    public void drawRightSideNN(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(this.m_colorSelectedTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 20, 18, 10);
        graphics.setColor(this.m_colorTabHighlight);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 0, 9, 2);
        graphics.fillRect(rectangle.x + 9, rectangle.y + 1, 2, 1);
        graphics.setColor(this.m_colorNormalTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 2, 11, 17);
        graphics.fillRect(rectangle.x + 11, rectangle.y + 1, 1, 18);
        graphics.fillRect(rectangle.x + 12, rectangle.y + 2, 1, 17);
        graphics.fillRect(rectangle.x + 13, rectangle.y + 4, 1, 15);
        graphics.fillRect(rectangle.x + 14, rectangle.y + 5, 1, 14);
        graphics.fillRect(rectangle.x + 15, rectangle.y + 6, 1, 13);
        graphics.fillRect(rectangle.x + 16, rectangle.y + 8, 1, 11);
        graphics.fillRect(rectangle.x + 17, rectangle.y + 11, 1, 8);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 30, 18, 3);
        graphics.setColor(this.m_colorTabShadow);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 19, 18, 1);
    }

    public void drawRightSideN_(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(this.m_colorSelectedTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 20, 18, 10);
        graphics.setColor(this.m_colorTabHighlight);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 0, 1, 2);
        graphics.setColor(this.m_colorNormalTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 2, 1, 17);
        graphics.fillRect(rectangle.x + 1, rectangle.y + 0, 1, 19);
        graphics.fillRect(rectangle.x + 2, rectangle.y + 1, 2, 18);
        graphics.fillRect(rectangle.x + 4, rectangle.y + 2, 2, 17);
        graphics.fillRect(rectangle.x + 6, rectangle.y + 3, 1, 16);
        graphics.fillRect(rectangle.x + 7, rectangle.y + 4, 1, 15);
        graphics.fillRect(rectangle.x + 8, rectangle.y + 5, 1, 14);
        graphics.fillRect(rectangle.x + 9, rectangle.y + 7, 1, 12);
        graphics.fillRect(rectangle.x + 10, rectangle.y + 9, 1, 10);
        graphics.fillRect(rectangle.x + 11, rectangle.y + 11, 1, 8);
        graphics.fillRect(rectangle.x + 12, rectangle.y + 14, 1, 5);
        graphics.fillRect(rectangle.x + 13, rectangle.y + 17, 1, 2);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 30, 18, 3);
        graphics.setColor(this.m_colorTabShadow);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 19, 18, 1);
    }

    public void drawLeftSide_S(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(this.m_colorSelectedTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 20, 18, 10);
        graphics.fillRect(rectangle.x + 3, rectangle.y + 19, 15, 1);
        graphics.fillRect(rectangle.x + 4, rectangle.y + 17, 14, 2);
        graphics.fillRect(rectangle.x + 5, rectangle.y + 14, 13, 3);
        graphics.fillRect(rectangle.x + 6, rectangle.y + 11, 12, 3);
        graphics.fillRect(rectangle.x + 7, rectangle.y + 9, 11, 2);
        graphics.fillRect(rectangle.x + 8, rectangle.y + 7, 10, 2);
        graphics.fillRect(rectangle.x + 9, rectangle.y + 5, 9, 2);
        graphics.fillRect(rectangle.x + 10, rectangle.y + 4, 8, 1);
        graphics.fillRect(rectangle.x + 11, rectangle.y + 3, 7, 1);
        graphics.fillRect(rectangle.x + 12, rectangle.y + 2, 6, 1);
        graphics.fillRect(rectangle.x + 14, rectangle.y + 1, 4, 1);
        graphics.fillRect(rectangle.x + 16, rectangle.y + 0, 2, 1);
        graphics.setColor(this.m_colorNormalTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 30, 18, 3);
        graphics.setColor(this.m_colorTabShadow);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 19, 3, 1);
    }

    public void drawLeftSideSN(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(this.m_colorSelectedTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 14, 1, 16);
        graphics.fillRect(rectangle.x + 1, rectangle.y + 17, 1, 13);
        graphics.fillRect(rectangle.x + 2, rectangle.y + 19, 1, 11);
        graphics.fillRect(rectangle.x + 3, rectangle.y + 20, 15, 10);
        graphics.setColor(this.m_colorTabHighlight);
        graphics.fillRect(rectangle.x + 2, rectangle.y + 9, 1, 1);
        graphics.fillRect(rectangle.x + 3, rectangle.y + 7, 1, 2);
        graphics.fillRect(rectangle.x + 4, rectangle.y + 5, 1, 3);
        graphics.fillRect(rectangle.x + 5, rectangle.y + 4, 1, 3);
        graphics.fillRect(rectangle.x + 6, rectangle.y + 3, 1, 3);
        graphics.fillRect(rectangle.x + 7, rectangle.y + 3, 1, 2);
        graphics.fillRect(rectangle.x + 8, rectangle.y + 2, 2, 2);
        graphics.fillRect(rectangle.x + 10, rectangle.y + 1, 4, 2);
        graphics.fillRect(rectangle.x + 13, rectangle.y + 0, 5, 2);
        graphics.setColor(this.m_colorNormalTab);
        graphics.fillRect(rectangle.x + 1, rectangle.y + 12, 1, 2);
        graphics.fillRect(rectangle.x + 2, rectangle.y + 10, 1, 7);
        graphics.fillRect(rectangle.x + 3, rectangle.y + 9, 1, 10);
        graphics.fillRect(rectangle.x + 4, rectangle.y + 8, 1, 11);
        graphics.fillRect(rectangle.x + 5, rectangle.y + 7, 1, 12);
        graphics.fillRect(rectangle.x + 6, rectangle.y + 6, 1, 13);
        graphics.fillRect(rectangle.x + 7, rectangle.y + 5, 1, 14);
        graphics.fillRect(rectangle.x + 8, rectangle.y + 4, 2, 15);
        graphics.fillRect(rectangle.x + 10, rectangle.y + 3, 4, 16);
        graphics.fillRect(rectangle.x + 14, rectangle.y + 2, 4, 17);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 30, 18, 3);
        graphics.setColor(this.m_colorTabShadow);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 13, 1, 1);
        graphics.fillRect(rectangle.x + 1, rectangle.y + 11, 1, 1);
        graphics.fillRect(rectangle.x + 1, rectangle.y + 14, 1, 3);
        graphics.fillRect(rectangle.x + 2, rectangle.y + 17, 1, 2);
        graphics.fillRect(rectangle.x + 3, rectangle.y + 19, 15, 1);
    }

    public void drawLeftSideNS(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(this.m_colorSelectedTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 11, 1, 19);
        graphics.fillRect(rectangle.x + 1, rectangle.y + 8, 1, 22);
        graphics.fillRect(rectangle.x + 2, rectangle.y + 5, 1, 25);
        graphics.fillRect(rectangle.x + 3, rectangle.y + 4, 1, 26);
        graphics.fillRect(rectangle.x + 4, rectangle.y + 3, 1, 27);
        graphics.fillRect(rectangle.x + 5, rectangle.y + 2, 1, 28);
        graphics.fillRect(rectangle.x + 6, rectangle.y + 1, 3, 29);
        graphics.fillRect(rectangle.x + 9, rectangle.y + 0, 9, 30);
        graphics.setColor(this.m_colorNormalTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 30, 18, 3);
        graphics.setColor(this.m_colorTabShadow);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 10, 1, 1);
    }

    public void drawLeftSideNN(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(this.m_colorSelectedTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 20, 18, 10);
        graphics.setColor(this.m_colorTabHighlight);
        graphics.fillRect(rectangle.x + 2, rectangle.y + 9, 1, 1);
        graphics.fillRect(rectangle.x + 3, rectangle.y + 7, 1, 2);
        graphics.fillRect(rectangle.x + 4, rectangle.y + 5, 1, 3);
        graphics.fillRect(rectangle.x + 5, rectangle.y + 4, 1, 3);
        graphics.fillRect(rectangle.x + 6, rectangle.y + 3, 1, 3);
        graphics.fillRect(rectangle.x + 7, rectangle.y + 3, 1, 2);
        graphics.fillRect(rectangle.x + 8, rectangle.y + 2, 2, 2);
        graphics.fillRect(rectangle.x + 10, rectangle.y + 1, 4, 2);
        graphics.fillRect(rectangle.x + 13, rectangle.y + 0, 5, 2);
        graphics.setColor(this.m_colorNormalTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 14, 1, 5);
        graphics.fillRect(rectangle.x + 1, rectangle.y + 17, 1, 2);
        graphics.fillRect(rectangle.x + 1, rectangle.y + 12, 1, 2);
        graphics.fillRect(rectangle.x + 2, rectangle.y + 10, 1, 7);
        graphics.fillRect(rectangle.x + 3, rectangle.y + 9, 1, 10);
        graphics.fillRect(rectangle.x + 4, rectangle.y + 8, 1, 11);
        graphics.fillRect(rectangle.x + 5, rectangle.y + 7, 1, 12);
        graphics.fillRect(rectangle.x + 6, rectangle.y + 6, 1, 13);
        graphics.fillRect(rectangle.x + 7, rectangle.y + 5, 1, 14);
        graphics.fillRect(rectangle.x + 8, rectangle.y + 4, 2, 15);
        graphics.fillRect(rectangle.x + 10, rectangle.y + 3, 4, 16);
        graphics.fillRect(rectangle.x + 14, rectangle.y + 2, 4, 17);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 30, 18, 3);
        graphics.setColor(this.m_colorTabShadow);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 13, 1, 1);
        graphics.fillRect(rectangle.x + 1, rectangle.y + 11, 1, 1);
        graphics.fillRect(rectangle.x + 1, rectangle.y + 14, 1, 3);
        graphics.fillRect(rectangle.x + 2, rectangle.y + 17, 1, 2);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 19, 18, 1);
    }

    public void drawLeftSide_N(Graphics graphics, Rectangle rectangle) {
        graphics.setColor(this.m_colorSelectedTab);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 20, 18, 10);
        graphics.setColor(this.m_colorTabHighlight);
        graphics.fillRect(rectangle.x + 4, rectangle.y + 17, 1, 2);
        graphics.fillRect(rectangle.x + 5, rectangle.y + 14, 1, 3);
        graphics.fillRect(rectangle.x + 6, rectangle.y + 11, 1, 3);
        graphics.fillRect(rectangle.x + 7, rectangle.y + 9, 1, 2);
        graphics.fillRect(rectangle.x + 8, rectangle.y + 7, 1, 2);
        graphics.fillRect(rectangle.x + 9, rectangle.y + 5, 1, 3);
        graphics.fillRect(rectangle.x + 10, rectangle.y + 4, 1, 2);
        graphics.fillRect(rectangle.x + 11, rectangle.y + 3, 1, 2);
        graphics.fillRect(rectangle.x + 12, rectangle.y + 2, 2, 2);
        graphics.fillRect(rectangle.x + 14, rectangle.y + 1, 2, 2);
        graphics.fillRect(rectangle.x + 16, rectangle.y + 0, 2, 2);
        graphics.setColor(this.m_colorNormalTab);
        graphics.fillRect(rectangle.x + 5, rectangle.y + 17, 1, 2);
        graphics.fillRect(rectangle.x + 6, rectangle.y + 14, 1, 5);
        graphics.fillRect(rectangle.x + 7, rectangle.y + 11, 1, 8);
        graphics.fillRect(rectangle.x + 8, rectangle.y + 9, 1, 10);
        graphics.fillRect(rectangle.x + 9, rectangle.y + 8, 1, 11);
        graphics.fillRect(rectangle.x + 10, rectangle.y + 6, 1, 13);
        graphics.fillRect(rectangle.x + 11, rectangle.y + 5, 1, 14);
        graphics.fillRect(rectangle.x + 12, rectangle.y + 4, 2, 15);
        graphics.fillRect(rectangle.x + 14, rectangle.y + 3, 2, 16);
        graphics.fillRect(rectangle.x + 16, rectangle.y + 2, 2, 17);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 30, 18, 3);
        graphics.setColor(this.m_colorTabShadow);
        graphics.fillRect(rectangle.x + 0, rectangle.y + 19, 18, 1);
    }
}

