/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.propsheet;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionInvalidArgument;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.propsheet.InterfacePropertySheetPanel;
import com.avocent.lib.util.ResourceManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Hashtable;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JDialogPropertySheet
extends JDialogCentered {
    public static final String CNAME = "JDialogPropertySheet";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.lib.gui.propsheet.Res");
    JPanel panelTabbedPane = new JPanel();
    JPanel jPanelButtons = new JPanel();
    JTabbedPane jTabbedPane = new JTabbedPane();
    JButton jButtonOK = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton jButtonApply = new JButton();
    JButton jButtonCancel = new JButton();
    JButton jButtonHelp = new JButton();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    private int m_nPage = 0;
    private Hashtable m_hashtable = new Hashtable();
    private boolean m_bApplyButtonOldState = false;

    public JDialogPropertySheet(Frame frame, String string) throws ExceptionConstructorFailed {
        super(frame, string, true);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)CNAME, (String)"jbInit failed");
            this.dispose();
            throw new ExceptionConstructorFailed();
        }
        this.putValue("Parent Frame", frame);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        ButtonPanel.equalize(this.jPanelButtons);
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        this.getGlassPane().addMouseListener(new MouseAdapter(){});
        this.getGlassPane().addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent keyEvent) {
                keyEvent.consume();
            }

            public void keyReleased(KeyEvent keyEvent) {
                keyEvent.consume();
            }

            public void keyTyped(KeyEvent keyEvent) {
                keyEvent.consume();
            }
        });
        this.getGlassPane().setFocusable(true);
    }

    void jbInit() throws Exception {
        this.panelTabbedPane.setLayout(this.gridBagLayout3);
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                JDialogPropertySheet.this.this_keyPressed(keyEvent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JDialogPropertySheet.this.this_windowClosing(windowEvent);
            }
        });
        this.getContentPane().setLayout(this.gridBagLayout2);
        this.jPanelButtons.setLayout(this.gridBagLayout1);
        this.jTabbedPane.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                JDialogPropertySheet.this.jTabbedPane_keyPressed(keyEvent);
            }
        });
        this.jTabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JDialogPropertySheet.this.jTabbedPane_stateChanged(changeEvent);
            }
        });
        this.jButtonOK.setText(res.getString("JDialogPropertySheet_OK"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogPropertySheet.this.jButtonOK_actionPerformed(actionEvent);
            }
        });
        this.jButtonApply.setEnabled(false);
        this.jButtonApply.setRequestFocusEnabled(false);
        this.jButtonApply.setMnemonic(res.getString("JDialogPropertySheet_Apply_Button_Mnemonic").charAt(0));
        this.jButtonApply.setText(res.getString("JDialogPropertySheet_Apply"));
        this.jButtonApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogPropertySheet.this.jButtonApply_actionPerformed(actionEvent);
            }
        });
        this.jButtonCancel.setText(res.getString("JDialogPropertySheet_Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogPropertySheet.this.jButtonCancel_actionPerformed(actionEvent);
            }
        });
        this.jButtonHelp.setRequestFocusEnabled(false);
        this.jButtonHelp.setMnemonic(res.getString("JDialogPropertySheet_Help_Button_Mnemonic").charAt(0));
        this.jButtonHelp.setText(res.getString("JDialogPropertySheet_Help"));
        this.jButtonHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogPropertySheet.this.jButtonHelp_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.panelTabbedPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.jPanelButtons, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 15, 1, new Insets(6, 0, 0, 0), 0, 0));
        this.panelTabbedPane.add((Component)this.jTabbedPane, new GridBagConstraints(0, 0, 0, 0, 1.0, 1.0, 10, 1, new Insets(6, 6, 3, 6), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonOK, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 13, 0, new Insets(3, 12, 11, 6), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonApply, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 0, 11, 6), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 0, 11, 6), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonHelp, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 0, 11, 6), 0, 0));
    }

    public void addPage(InterfacePropertySheetPanel interfacePropertySheetPanel) throws ExceptionInvalidArgument {
        if (interfacePropertySheetPanel == null || !(interfacePropertySheetPanel instanceof JPanel)) {
            Trace.logError((String)"JDialogPropertySheet:addPage", (String)"the page is not a valid JPanel");
            throw new ExceptionInvalidArgument();
        }
        this.jTabbedPane.addTab(interfacePropertySheetPanel.getTitle(), interfacePropertySheetPanel.getIcon(), (JPanel)((Object)interfacePropertySheetPanel), interfacePropertySheetPanel.getTooltip());
    }

    public boolean onInit() {
        if (this.jTabbedPane.getComponentCount() == 0) {
            Trace.logError((String)"JDialogPropertySheet:onInit", (String)"no panels have been added to the property sheet");
            return false;
        }
        int n = 0;
        while (n < this.jTabbedPane.getComponentCount()) {
            InterfacePropertySheetPanel interfacePropertySheetPanel = (InterfacePropertySheetPanel)((Object)this.jTabbedPane.getComponentAt(n));
            if (!interfacePropertySheetPanel.onInit()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    private void handleOkButton() {
        if (this.jTabbedPane.getComponentCount() == 0) {
            Trace.logError((String)"JDialogPropertySheet:handleOkButton", (String)"no panels have been added to the property sheet");
            return;
        }
        this.showBusyCursor();
        this.disableButtons();
        InterfacePropertySheetPanel interfacePropertySheetPanel = (InterfacePropertySheetPanel)((Object)this.jTabbedPane.getSelectedComponent());
        if (!interfacePropertySheetPanel.isPageValid()) {
            this.showNormalCursor();
            this.enableButtons();
            return;
        }
        int n = this.jTabbedPane.getSelectedIndex();
        int n2 = 0;
        while (n2 < this.jTabbedPane.getComponentCount()) {
            InterfacePropertySheetPanel interfacePropertySheetPanel2 = (InterfacePropertySheetPanel)((Object)this.jTabbedPane.getComponentAt(n2));
            if (n2 != n && !interfacePropertySheetPanel2.isPageValid()) {
                this.showNormalCursor();
                this.enableButtons();
                this.jTabbedPane.setSelectedIndex(n2);
                return;
            }
            ++n2;
        }
        if (!interfacePropertySheetPanel.onOk()) {
            this.onDestroy();
            return;
        }
        int n3 = 0;
        while (n3 < this.jTabbedPane.getComponentCount()) {
            InterfacePropertySheetPanel interfacePropertySheetPanel3 = (InterfacePropertySheetPanel)((Object)this.jTabbedPane.getComponentAt(n3));
            if (n3 != n && !interfacePropertySheetPanel3.onOk()) break;
            ++n3;
        }
        this.onDestroy();
    }

    private void handleApplyButton() {
        if (this.jTabbedPane.getComponentCount() == 0) {
            Trace.logError((String)"JDialogPropertySheet:handleApplyButton", (String)"no panels have been added to the property sheet");
            return;
        }
        this.showBusyCursor();
        this.disableButtons();
        InterfacePropertySheetPanel interfacePropertySheetPanel = (InterfacePropertySheetPanel)((Object)this.jTabbedPane.getSelectedComponent());
        if (!interfacePropertySheetPanel.isPageValid()) {
            this.showNormalCursor();
            this.enableButtons();
            return;
        }
        int n = this.jTabbedPane.getSelectedIndex();
        int n2 = 0;
        while (n2 < this.jTabbedPane.getComponentCount()) {
            InterfacePropertySheetPanel interfacePropertySheetPanel2 = (InterfacePropertySheetPanel)((Object)this.jTabbedPane.getComponentAt(n2));
            if (n2 != n && !interfacePropertySheetPanel2.isPageValid()) {
                this.showNormalCursor();
                this.enableButtons();
                this.jTabbedPane.setSelectedIndex(n2);
                return;
            }
            ++n2;
        }
        if (!interfacePropertySheetPanel.onApply()) {
            this.showNormalCursor();
            this.enableButtons();
            return;
        }
        int n3 = 0;
        while (n3 < this.jTabbedPane.getComponentCount()) {
            InterfacePropertySheetPanel interfacePropertySheetPanel3 = (InterfacePropertySheetPanel)((Object)this.jTabbedPane.getComponentAt(n3));
            if (n3 != n && !interfacePropertySheetPanel3.onApply()) {
                this.showNormalCursor();
                this.enableButtons();
                this.jTabbedPane.setSelectedIndex(n3);
                break;
            }
            ++n3;
        }
        this.showNormalCursor();
        this.enableButtons();
        this.setApplyButtonEnabled(false);
    }

    private void onDestroy() {
        if (this.jTabbedPane.getComponentCount() == 0) {
            Trace.logError((String)"JDialogPropertySheet:onDestroy", (String)"no panels have been added to the property sheet");
            return;
        }
        this.showBusyCursor();
        this.disableButtons();
        int n = 0;
        while (n < this.jTabbedPane.getComponentCount()) {
            InterfacePropertySheetPanel interfacePropertySheetPanel = (InterfacePropertySheetPanel)((Object)this.jTabbedPane.getComponentAt(n));
            interfacePropertySheetPanel.onDestroy();
            ++n;
        }
        this.setVisible(false);
        this.dispose();
    }

    private void showBusyCursor() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JDialogPropertySheet.this.setCursor(Cursor.getPredefinedCursor(3));
                }
            });
        }
        catch (Exception exception) {
            Trace.logError((String)"JDialogPropertySheet.showBusyCursor()", (String)("Exception caught during invokeAndWait() call " + exception.getMessage()));
        }
    }

    private void showNormalCursor() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JDialogPropertySheet.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            });
        }
        catch (Exception exception) {
            Trace.logError((String)"JDialogPropertySheet.showNormalCursor()", (String)("Exception caught during invokeAndWait() call " + exception.getMessage()));
        }
    }

    private void disableButtons() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JDialogPropertySheet.this.m_bApplyButtonOldState = JDialogPropertySheet.this.jButtonApply.isEnabled();
                    JDialogPropertySheet.this.jButtonApply.setEnabled(false);
                    JDialogPropertySheet.this.jButtonOK.setEnabled(false);
                    JDialogPropertySheet.this.jButtonCancel.setEnabled(false);
                    JDialogPropertySheet.this.jButtonHelp.setEnabled(false);
                }
            });
        }
        catch (Exception exception) {
            Trace.logError((String)"JDialogPropertySheet.disableButtons()", (String)("Exception caught during invokeAndWait() call " + exception.getMessage()));
        }
    }

    private void enableButtons() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    JDialogPropertySheet.this.jButtonApply.setEnabled(JDialogPropertySheet.this.m_bApplyButtonOldState);
                    JDialogPropertySheet.this.jButtonOK.setEnabled(true);
                    JDialogPropertySheet.this.jButtonCancel.setEnabled(true);
                    JDialogPropertySheet.this.jButtonHelp.setEnabled(true);
                }
            });
        }
        catch (Exception exception) {
            Trace.logError((String)"JDialogPropertySheet.enableButtons()", (String)("Exception caught during invokeAndWait() call " + exception.getMessage()));
        }
    }

    public Object putValue(Object object, Object object2) {
        return this.m_hashtable.put(object, object2);
    }

    public Object getValue(Object object) {
        return this.m_hashtable.get(object);
    }

    void jTabbedPane_stateChanged(ChangeEvent changeEvent) {
        if (this.jTabbedPane.getSelectedIndex() == this.m_nPage) {
            return;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                JDialogPropertySheet.this.showBusyCursor();
                JDialogPropertySheet.this.disableButtons();
                InterfacePropertySheetPanel interfacePropertySheetPanel = (InterfacePropertySheetPanel)((Object)JDialogPropertySheet.this.jTabbedPane.getComponentAt(JDialogPropertySheet.this.m_nPage));
                if (interfacePropertySheetPanel.isPageValid()) {
                    JDialogPropertySheet.this.m_nPage = JDialogPropertySheet.this.jTabbedPane.getSelectedIndex();
                    interfacePropertySheetPanel = (InterfacePropertySheetPanel)((Object)JDialogPropertySheet.this.jTabbedPane.getComponentAt(JDialogPropertySheet.this.m_nPage));
                    interfacePropertySheetPanel.onSetActive();
                } else {
                    JDialogPropertySheet.this.jTabbedPane.setSelectedIndex(JDialogPropertySheet.this.m_nPage);
                }
                JDialogPropertySheet.this.showNormalCursor();
                JDialogPropertySheet.this.enableButtons();
            }
        });
        thread.start();
    }

    void jButtonOK_actionPerformed(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                JDialogPropertySheet.this.handleOkButton();
            }
        });
        thread.start();
    }

    void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                JDialogPropertySheet.this.onDestroy();
            }
        });
        thread.start();
    }

    void jButtonApply_actionPerformed(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                JDialogPropertySheet.this.handleApplyButton();
            }
        });
        thread.start();
    }

    void jButtonHelp_actionPerformed(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                InterfacePropertySheetPanel interfacePropertySheetPanel = (InterfacePropertySheetPanel)((Object)JDialogPropertySheet.this.jTabbedPane.getSelectedComponent());
                interfacePropertySheetPanel.onHelp();
            }
        });
        thread.start();
    }

    void this_windowClosing(WindowEvent windowEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                JDialogPropertySheet.this.onDestroy();
            }
        });
        thread.start();
    }

    void this_keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (!(keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isShiftDown() || n != 27)) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    JDialogPropertySheet.this.onDestroy();
                }
            });
            thread.start();
        }
    }

    void jTabbedPane_keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (!(keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isShiftDown() || n != 27)) {
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    JDialogPropertySheet.this.onDestroy();
                }
            });
            thread.start();
        }
    }

    public void setApplyButtonEnabled(boolean bl) {
        final boolean bl2 = bl;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDialogPropertySheet.this.jButtonApply.setEnabled(bl2);
            }
        });
    }

    public void setCursor(Cursor cursor) {
        if (cursor.equals(Cursor.getPredefinedCursor(3))) {
            this.disablePropertySheet();
        } else if (cursor.equals(Cursor.getPredefinedCursor(0))) {
            this.enablePropertySheet();
        }
        super.setCursor(cursor);
    }

    private void disablePropertySheet() {
        final Component component = this.getGlassPane();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.setVisible(true);
                component.requestFocusInWindow();
            }
        });
    }

    private void enablePropertySheet() {
        final Component component = this.getGlassPane();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.setVisible(false);
            }
        });
    }
}

