/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.lib.gui.wizards;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionAlreadyExists;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.components.ButtonPanel;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.gui.wizards.InterfaceWizardPanel;
import com.avocent.lib.gui.wizards.JPanelCompletion;
import com.avocent.lib.gui.wizards.JPanelInterior;
import com.avocent.lib.gui.wizards.JPanelWelcome;
import com.avocent.lib.gui.wizards.JPanelWizardTemplate;
import com.avocent.lib.util.ResourceManager;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class JDialogWizard
extends JDialogCentered {
    public static final String CNAME = "JDialogWizard";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.lib.gui.wizards.Res");
    JPanel jpanelWizard = new JPanel();
    JPanel jPanelWizardButtons = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton jButtonBack = new JButton();
    JButton jButtonNextFinDone = new JButton();
    JButton jButtonCancel = new JButton();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JPanel jPanelWizardTop = new JPanel();
    CardLayout cardLayout1 = new CardLayout();
    JPanel jPanelDivider = new JPanel();
    public static final int INVALID_PAGE_ID = -1;
    private int m_nButtons = 2;
    private int m_nCurrentPage = -1;
    private Hashtable m_hashtable = new Hashtable();
    private Vector m_vPreviousPages = new Vector();
    private boolean m_bCanceled = false;
    static /* synthetic */ Class class$com$avocent$lib$gui$wizards$JDialogWizard;

    public JDialogWizard() throws ExceptionConstructorFailed {
        this((Frame)null, true);
    }

    public JDialogWizard(Frame frame) throws ExceptionConstructorFailed {
        this(frame, true);
    }

    private JDialogWizard(Frame frame, boolean bl) throws ExceptionConstructorFailed {
        super(frame, "", bl);
        try {
            this.jbInit();
            this.pack();
            this.setResizable(false);
            ButtonPanel.equalize(this.jPanelWizardButtons);
            this.pack();
        }
        catch (Exception exception) {
            Message.show(frame, res.getString("JDialogWizard_Unable_to_display_the"));
            Trace.logError((String)"Wizard", (String)"Unable to initialize wizard");
            throw new ExceptionConstructorFailed();
        }
    }

    void jbInit() throws Exception {
        this.jpanelWizard.setLayout(this.gridBagLayout1);
        this.jPanelWizardButtons.setLayout(this.gridBagLayout3);
        this.jButtonBack.setMnemonic(res.getString("JDialogWizard_Back_Mnemonic").charAt(0));
        this.jButtonBack.setText(res.getString("JDialogWizard_Back"));
        this.jButtonBack.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogWizard.this.jButtonBack_actionPerformed(actionEvent);
            }
        });
        this.jButtonNextFinDone.setText(res.getString("JDialogWizard_Next"));
        this.jButtonNextFinDone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogWizard.this.jButtonNextFinDone_actionPerformed(actionEvent);
            }
        });
        this.jButtonCancel.setText(res.getString("JDialogWizard_Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogWizard.this.jButtonCancel_actionPerformed(actionEvent);
            }
        });
        this.jPanelWizardTop.setLayout(this.cardLayout1);
        this.jPanelDivider.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelDivider.setMaximumSize(new Dimension(Short.MAX_VALUE, 2));
        this.jPanelDivider.setMinimumSize(new Dimension(14, 2));
        this.jPanelDivider.setPreferredSize(new Dimension(14, 2));
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                JDialogWizard.this.jpanelWizard_keyPressed(keyEvent);
            }
        });
        this.getContentPane().add(this.jpanelWizard);
        this.jPanelWizardButtons.add((Component)this.jButtonBack, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 13, 0, new Insets(12, 12, 11, 0), 0, 0));
        this.jPanelWizardButtons.add((Component)this.jButtonNextFinDone, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 0, 11, 0), 0, 0));
        this.jPanelWizardButtons.add((Component)this.jButtonCancel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 5, 11, 11), 7, 0));
        this.jpanelWizard.add((Component)this.jPanelDivider, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jpanelWizard.add((Component)this.jPanelWizardTop, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jpanelWizard.add((Component)this.jPanelWizardButtons, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Trace.startLogging(null);
        try {
            JFrame jFrame = new JFrame("Test");
            jFrame.setBounds(50, 50, 500, 400);
            jFrame.setVisible(true);
            JDialogWizard jDialogWizard = new JDialogWizard(jFrame);
            ImageIcon imageIcon = new ImageIcon((class$com$avocent$lib$gui$wizards$JDialogWizard == null ? (class$com$avocent$lib$gui$wizards$JDialogWizard = JDialogWizard.class$("com.avocent.lib.gui.wizards.JDialogWizard")) : class$com$avocent$lib$gui$wizards$JDialogWizard).getResource("welcome.gif"));
            jDialogWizard.addWelcomePage(1, 2, "Welcome Title Test", "Welcome to the Test Wizard This is a really long welcome", "This wizard helps you test the wizard.  This is a really long introduction text for someone who really goes crazy.", imageIcon);
            JPanelWizardTemplate jPanelWizardTemplate = new JPanelWizardTemplate(jDialogWizard, 2, "Page 2 Title");
            jDialogWizard.addInteriorPage("Test Header Title", "Test Header Message", null, jPanelWizardTemplate);
            jDialogWizard.putValue("FinishStatus", "You have successfully completed the test wizard with this long status message.");
            jDialogWizard.putValue("FinishClose", "To close the test wizard press Finish.");
            jDialogWizard.putValue("FinishButtons", new Integer(25));
            jDialogWizard.putValue("FinishHeader", "The New Appliance Wizard was unsuccessful");
            jDialogWizard.putValue("FinishExclamation", new Boolean(true));
            String[] stringArray2 = new String[]{"Unit1 was successfully updated", "Unit2 failed to updated, Reason: The unit was having a really really bad day", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven"};
            JList<String> jList = new JList<String>(stringArray2);
            jDialogWizard.putValue("FinishComponent", jList);
            jDialogWizard.addCompletionPage(3, "Finish Title Test", imageIcon);
            jDialogWizard.pack();
            jDialogWizard.setVisible(true);
        }
        catch (Exception exception) {
            Trace.logError((String)"DialogWizard", (String)"Unit Test Error");
        }
        System.exit(0);
    }

    public Object putValue(Object object, Object object2) {
        return this.m_hashtable.put(object, object2);
    }

    public Object removeValue(Object object) {
        return this.m_hashtable.remove(object);
    }

    public Object getValue(Object object) {
        return this.m_hashtable.get(object);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            Rectangle rectangle = this.getParent().getBounds();
            Rectangle rectangle2 = this.getBounds();
            int n = rectangle.x + (rectangle.width - rectangle2.width) / 2;
            int n2 = rectangle.y + (rectangle.height - rectangle2.height) / 2;
            this.setLocation(n > 0 ? n : 0, n2 > 0 ? n2 : 0);
        }
        super.setVisible(bl);
    }

    private void addPage(InterfaceWizardPanel interfaceWizardPanel) {
        JPanel jPanel = (JPanel)((Object)interfaceWizardPanel);
        String string = Integer.toString(interfaceWizardPanel.getID());
        this.jPanelWizardTop.add(string, jPanel);
    }

    public void addWelcomePage(int n, int n2, String string, String string2, String string3, ImageIcon imageIcon) throws ExceptionRequestFailed {
        try {
            JPanelWelcome jPanelWelcome = new JPanelWelcome(this, n, n2, string, string2, string3, imageIcon);
            this.addPage(jPanelWelcome);
            this.showPage(n);
        }
        catch (Exception exception) {
            Trace.logError((String)"Wizard", (String)("Failed to add welcome page " + string));
            throw new ExceptionRequestFailed();
        }
    }

    public void addCompletionPage(JPanelCompletion jPanelCompletion) throws ExceptionRequestFailed {
        try {
            this.addPage(jPanelCompletion);
        }
        catch (Exception exception) {
            Trace.logError((String)"Wizard", (String)"Failed to add completion page ");
            throw new ExceptionRequestFailed();
        }
    }

    public void addCompletionPage(int n, String string, ImageIcon imageIcon) throws ExceptionRequestFailed {
        try {
            JPanelCompletion jPanelCompletion = new JPanelCompletion(this, n, string, imageIcon);
            this.addPage(jPanelCompletion);
        }
        catch (Exception exception) {
            Trace.logError((String)"Wizard", (String)("Failed to add completion page " + string));
            throw new ExceptionRequestFailed();
        }
    }

    public void addInteriorPage(String string, String string2, ImageIcon imageIcon, InterfaceWizardPanel interfaceWizardPanel) throws ExceptionAlreadyExists, ExceptionRequestFailed {
        try {
            JPanelInterior jPanelInterior = new JPanelInterior();
            jPanelInterior.setComponentPanel(string, string2, imageIcon, interfaceWizardPanel);
            this.addPage(jPanelInterior);
        }
        catch (Exception exception) {
            Trace.logError((String)"Wizard", (String)("Failed to add interior page " + string));
            throw new ExceptionRequestFailed();
        }
    }

    public void setWizardButtons(int n) {
        try {
            this.setWizardButtons(n, true);
        }
        catch (Exception exception) {
            Trace.logError((String)"Wizard", (String)"Unable to update the buttons", (Throwable)exception);
        }
    }

    public void setWizardButtons(int n, boolean bl) throws ExceptionRequestFailed {
        final int n2 = n;
        Runnable runnable = new Runnable(){

            public void run() {
                if ((n2 & 2) != 0 && (n2 & 4) != 0 && (n2 & 0x10) != 0) {
                    Trace.logError((String)"JWizard", (String)"Invalid Argument to setWizardButtons call");
                    return;
                }
                JDialogWizard.this.m_nButtons = n2;
                if ((n2 & 1) != 0) {
                    JDialogWizard.this.jButtonBack.setEnabled(true);
                } else {
                    JDialogWizard.this.jButtonBack.setEnabled(false);
                }
                if ((n2 & 8) != 0) {
                    JDialogWizard.this.jButtonCancel.setEnabled(true);
                } else {
                    JDialogWizard.this.jButtonCancel.setEnabled(false);
                }
                if ((n2 & 2) != 0) {
                    JDialogWizard.this.jButtonNextFinDone.setEnabled(true);
                    JDialogWizard.this.jButtonNextFinDone.setText(res.getString("JDialogWizard_Next"));
                    JDialogWizard.this.jButtonNextFinDone.setMnemonic(res.getString("JDialogWizard_Next_Mnemonic").charAt(0));
                } else if ((n2 & 4) != 0) {
                    JDialogWizard.this.jButtonNextFinDone.setEnabled(true);
                    JDialogWizard.this.jButtonNextFinDone.setText(res.getString("JDialogWizard_Finish"));
                    JDialogWizard.this.jButtonNextFinDone.setMnemonic(res.getString("JDialogWizard_Finish_Mnemonic").charAt(0));
                } else if ((n2 & 0x10) != 0) {
                    JDialogWizard.this.jButtonNextFinDone.setEnabled(true);
                    JDialogWizard.this.jButtonNextFinDone.setText(res.getString("JDialogWizard_Done"));
                    JDialogWizard.this.jButtonNextFinDone.setMnemonic(res.getString("JDialogWizard_Done_Mnemonic").charAt(0));
                } else {
                    JDialogWizard.this.jButtonNextFinDone.setEnabled(false);
                    JDialogWizard.this.jButtonNextFinDone.setText(res.getString("JDialogWizard_Next"));
                    JDialogWizard.this.jButtonNextFinDone.setMnemonic(res.getString("JDialogWizard_Next_Mnemonic").charAt(0));
                }
            }
        };
        if (bl) {
            SwingUtilities.invokeLater(runnable);
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                Trace.logError((String)"Wizard", (String)"Unable to update the buttons", (Throwable)exception);
                throw new ExceptionRequestFailed();
            }
        }
    }

    public void setDefaultButton(int n) {
        if ((n & 2) != 0) {
            this.getRootPane().setDefaultButton(this.jButtonNextFinDone);
        } else if ((n & 4) != 0) {
            this.getRootPane().setDefaultButton(this.jButtonNextFinDone);
        } else if ((n & 0x10) != 0) {
            this.getRootPane().setDefaultButton(this.jButtonNextFinDone);
        } else if ((n & 1) != 0) {
            this.getRootPane().setDefaultButton(this.jButtonBack);
        } else if ((n & 8) != 0) {
            this.getRootPane().setDefaultButton(this.jButtonCancel);
        }
    }

    public void setDefaultButton(JButton jButton) {
        this.getRootPane().setDefaultButton(jButton);
    }

    public void showPage(int n) {
        Trace.logInfo((String)"Wizard:showPage", (String)("Show Page " + n));
        final String string = Integer.toString(n);
        this.m_nCurrentPage = n;
        Trace.logInfo((String)"Wizard:showPage", (String)"Finding Page");
        Component[] componentArray = this.jPanelWizardTop.getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            InterfaceWizardPanel interfaceWizardPanel = (InterfaceWizardPanel)((Object)componentArray[n2]);
            if (this.m_nCurrentPage == interfaceWizardPanel.getID()) {
                Trace.logInfo((String)"Wizard:showPage", (String)"Found Page, calling Page's onSetActive");
                interfaceWizardPanel.onSetActive();
                Trace.logInfo((String)"Wizard:showPage", (String)"Page's onSetActive completed");
                final String string2 = interfaceWizardPanel.getTitle();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Trace.logInfo((String)"Wizard:showPage:invokeLater", (String)"Setting Title");
                        JDialogWizard.this.setTitle(string2);
                        Trace.logInfo((String)"Wizard:showPage:invokeLater", (String)"Showing new page");
                        CardLayout cardLayout = (CardLayout)JDialogWizard.this.jPanelWizardTop.getLayout();
                        cardLayout.show(JDialogWizard.this.jPanelWizardTop, string);
                        Trace.logInfo((String)"Wizard:showPage:invokeLater", (String)"Page shown");
                    }
                });
                Trace.logInfo((String)"Wizard:showPage", (String)"showPage done");
                return;
            }
            ++n2;
        }
    }

    void jButtonNextFinDone_actionPerformed(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                JDialogWizard.this.jPanelWizardTop.grabFocus();
                Component[] componentArray = JDialogWizard.this.jPanelWizardTop.getComponents();
                int n = 0;
                while (n < componentArray.length) {
                    InterfaceWizardPanel interfaceWizardPanel = (InterfaceWizardPanel)((Object)componentArray[n]);
                    if (JDialogWizard.this.m_nCurrentPage == interfaceWizardPanel.getID()) {
                        String string = JDialogWizard.this.jButtonNextFinDone.getText();
                        if (string.equalsIgnoreCase(res.getString("JDialogWizard_Finish")) || string.equalsIgnoreCase(res.getString("JDialogWizard_Done"))) {
                            int n2 = JDialogWizard.this.m_nButtons;
                            JDialogWizard.this.setWizardButtons(0);
                            JDialogWizard.this.setCursor(Cursor.getPredefinedCursor(3));
                            Trace.logInfo((String)"Wizard:onFinish", (String)"Calling page onFinish");
                            boolean bl = interfaceWizardPanel.onFinish();
                            Trace.logInfo((String)"Wizard:onFinish", (String)("onFinish returned page " + new Boolean(bl).toString()));
                            JDialogWizard.this.setWizardButtons(n2);
                            JDialogWizard.this.setCursor(Cursor.getPredefinedCursor(0));
                            if (bl) {
                                JDialogWizard.this.closeWizard(false);
                            }
                        } else {
                            Trace.logInfo((String)"Wizard:onNext", (String)("Disable Buttons (Old=" + JDialogWizard.this.m_nButtons + ")"));
                            int n3 = JDialogWizard.this.m_nButtons;
                            JDialogWizard.this.setWizardButtons(0);
                            JDialogWizard.this.setCursor(Cursor.getPredefinedCursor(3));
                            Trace.logInfo((String)"Wizard:onNext", (String)"Calling current page onNext");
                            int n4 = interfaceWizardPanel.onNext();
                            Trace.logInfo((String)"Wizard:onNext", (String)("onNext returned page " + n4));
                            Trace.logInfo((String)"Wizard:onNext", (String)("Re-enable Buttons (Old=" + n3 + ")"));
                            JDialogWizard.this.setWizardButtons(n3);
                            JDialogWizard.this.setCursor(Cursor.getPredefinedCursor(0));
                            if (n4 == -1 || n4 == JDialogWizard.this.m_nCurrentPage) {
                                Trace.logInfo((String)"Wizard:onNext", (String)("Next Page " + n4 + " is same or invalid. Ignoring"));
                            } else {
                                JDialogWizard.this.m_vPreviousPages.addElement(new Integer(JDialogWizard.this.m_nCurrentPage));
                                Trace.logInfo((String)"Wizard:onNext", (String)("Showing Next Page " + n4));
                                JDialogWizard.this.showPage(n4);
                            }
                        }
                        Trace.logInfo((String)"Wizard:onNext", (String)"Done");
                        return;
                    }
                    ++n;
                }
                Trace.logError((String)"Wizard:onNext", (String)("Error - Current Page not found =" + JDialogWizard.this.m_nCurrentPage));
            }
        });
        thread.start();
    }

    void jButtonBack_actionPerformed(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                JDialogWizard.this.jPanelWizardTop.grabFocus();
                Component[] componentArray = JDialogWizard.this.jPanelWizardTop.getComponents();
                int n = 0;
                while (n < componentArray.length) {
                    InterfaceWizardPanel interfaceWizardPanel = (InterfaceWizardPanel)((Object)componentArray[n]);
                    if (JDialogWizard.this.m_nCurrentPage == interfaceWizardPanel.getID()) {
                        int n2 = JDialogWizard.this.m_nButtons;
                        JDialogWizard.this.setWizardButtons(0);
                        JDialogWizard.this.setCursor(Cursor.getPredefinedCursor(3));
                        Trace.logInfo((String)"Wizard", (String)"Calling page onBack");
                        int n3 = interfaceWizardPanel.onBack();
                        Trace.logInfo((String)"Wizard", (String)("onBack returned page " + n3));
                        if (n3 == -1 || n3 == JDialogWizard.this.m_nCurrentPage) {
                            Trace.logInfo((String)"Wizard", (String)("Previous Page " + n3 + " is same or invalid. Ignoring"));
                        } else {
                            if (JDialogWizard.this.m_vPreviousPages.size() > 0) {
                                JDialogWizard.this.m_vPreviousPages.removeElementAt(JDialogWizard.this.m_vPreviousPages.size() - 1);
                            }
                            Trace.logInfo((String)"Wizard", (String)("Showing Previous Page " + n3));
                            JDialogWizard.this.showPage(n3);
                        }
                        Trace.logInfo((String)"Wizard", (String)("Re-enable Buttons (Old=" + n2 + ")"));
                        JDialogWizard.this.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    ++n;
                }
            }
        });
        thread.start();
    }

    void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                JDialogWizard.this.closeWizard(true);
            }
        });
        thread.start();
    }

    public void closeWizard(boolean bl) {
        this.setWizardButtons(0);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setCanceled(bl);
        Component[] componentArray = this.jPanelWizardTop.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            InterfaceWizardPanel interfaceWizardPanel = (InterfaceWizardPanel)((Object)componentArray[n]);
            interfaceWizardPanel.onDestroy();
            ++n;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
        this.setVisible(false);
    }

    public boolean doEscape() {
        this.closeWizard(true);
        return true;
    }

    public synchronized boolean isCanceled() {
        return this.m_bCanceled;
    }

    private synchronized void setCanceled(boolean bl) {
        this.m_bCanceled = bl;
    }

    public int getPreviousPageID() {
        if (this.m_vPreviousPages.size() > 0) {
            Integer n = (Integer)this.m_vPreviousPages.elementAt(this.m_vPreviousPages.size() - 1);
            return n;
        }
        return -1;
    }

    void jpanelWizard_keyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (!(keyEvent.isControlDown() || keyEvent.isAltDown() || keyEvent.isShiftDown())) {
            switch (n) {
                default: {
                    break;
                }
                case 27: {
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            JDialogWizard.this.closeWizard(true);
                        }
                    });
                    thread.start();
                }
            }
        }
    }

    public void showBusyCursor() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDialogWizard.this.setCursor(Cursor.getPredefinedCursor(3));
            }
        });
    }

    public void showNormalCursor() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JDialogWizard.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

