/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

public class AVSPStatus {
    public static final int USER_LOGIN_STATUS = 33536;
    public static final int USER_LOGIN_STATUS_NEW_TYPE = 33541;
    public static final int VIDEO_CONNECT_STATUS = 132;
    public static final byte VIDEO_ENCODING_AVC = 4;
    public static final byte VIDEO_ENCODING_DVC7 = 8;
    public static final byte VIDEO_ENCODING_DVC15 = 16;
    public static final byte LOGIN_SUCCEEDED = 0;
    public static final byte LOGIN_FAILED = -1;
    public static final byte LOGIN_FAILED_TIMEOUT = -2;
    public static final byte LOGIN_FAILED_INVALID_USER_NAME = 1;
    public static final byte LOGIN_FAILED_INVALID_PASSWORD = 2;
    public static final byte LOGIN_FAILED_CHANNEL_ACCESS_DENIED = 3;
    public static final byte LOGIN_FAILED_CHANNEL_IN_USE = 4;
    public static final byte LOGIN_FAILED_CHANNEL_NOT_FOUND = 5;
    public static final byte LOGIN_FAILED_SERVER_NOT_AVAILABLE_CAN_PREEMPT = 6;
    public static final byte LOGIN_FAILED_CHANNEL_IN_USE_BY_LOCAL_USER = 7;
    public static final byte LOGIN_FAILED_ALL_CHANNELS_IN_USE = 8;
    public static final byte LOGIN_FAILED_INSUFFICIENT_ACCESS_RIGHTS = 9;
    public static final byte LOGIN_FAILED_USER_LOCKED_OUT = 10;
    public static final byte LOGIN_FAILED_CHANNEL_IN_USE_BY_LOCAL_USER_CAN_PREEMPT = 11;
    public static final byte LOGIN_FAILED_CHANNEL_IN_USE_BY_EXCLUSIVE_LOCAL_USER = 12;
    public static final byte LOGIN_FAILED_CHANNEL_UPGRADE_IN_PROGRESS = 13;
    public static final byte LOGIN_FAILED_CHANNEL_IN_USE_BY_EXCLUSIVE_USER = 14;
    public static final byte LOGIN_FAILED_SHARE_REQUEST_DENIED = 15;
    public static final byte LOGIN_FAILED_SHARE_REQUEST_TIMED_OUT = 16;
    public static final byte LOGIN_FAILED_EXCLUSIVE_REQUEST_FAILED = 17;
    public static final byte LOGIN_FAILED_PEM_BLOCKAGE = 18;
    public static final byte LOGIN_FAILED_PEM_BLOCKAGE_USER_CAN_PREEMPT = 19;
    public static final byte LOGIN_FAILED_PEM_BLOCKAGE_BY_LOCAL_USER = 20;
    public static final byte LOGIN_FAILED_PEM_BLOCKAGE_BY_LOCAL_USER_CAN_PREEMPT = 21;
    public static final byte LOGIN_FAILED_NETWORK_AUTH_SERVER_ERROR = 22;
    public static final byte LOGIN_FAILED_INVALID_EXPIRED_CERT_ERROR = 23;
    public static final byte LOGIN_FAILED_CHANNEL_IN_USE_BY_LOCAL_USER_CAN_PREEMPT_TIMEOUT_INFO = 50;
    public static final byte LOGIN_FAILED_SERVER_NOT_AVAILABLE_CAN_PREEMPT_TIMEOUT_INFO = 51;
    public static final byte LOGIN_FAILED_PREEMPT_REJECTED = 52;
    public static final byte LOGIN_FAILED_PEM_BLOCKAGE_BY_LOCAL_USER_CAN_PREEMPT_TIMEOUT_INFO = 53;
    public static final byte LOGIN_FAILED_PEM_BLOCKAGE_USER_CAN_PREEMPT_TIMEOUT_INFO = 54;
    public static final byte LOGIN_FAILED_MAX_NUMBER_SHARED_USERS = 60;
    public static final byte LOGIN_FAILED_PREEMPTION_IN_PROGRESS = 61;
    public static final byte LOGIN_FAILED_EXCLUSIVE_MODE_NOT_AVAILABLE_THIS_USER = 62;
    public static final byte LOGIN_FAILED_EXCLUSIVE_MODE_NOT_AVAILABLE_ANY_USER = 63;
    public static final byte LOGIN_FAILED_NO_PREEMPTION_PRIVILEGES = 64;
    public static final byte CONNECTION_FAILED_NETWORK_PROBLEM = 100;
    private static final byte SHARE_REQUEST_TIMEOUT_DEFAULT = 30;
    private byte m_byLoginStatus = (byte)-1;
    private int m_nApplianceRandom = 0;
    private int m_nClientRandom = 0;
    private String m_szUserName = null;
    private boolean m_bVideoSocketUsed = true;
    private boolean m_bVideoEncrypted = false;
    private boolean m_bOtherUserCanRejectPreemption = false;
    private byte m_byVideoEncoding = 0;
    private short m_sSessionType = 0;
    private byte m_byPreemptionTimeout = 0;
    private byte m_byShareRequestTimeout = (byte)30;
    private byte m_bySharePreemptionMode = 0;

    public AVSPStatus() {
        this.m_nClientRandom = (int)(Math.random() * 1.0E7);
        this.m_byLoginStatus = (byte)-1;
    }

    public final byte getLoginStatus() {
        return this.m_byLoginStatus;
    }

    public final void setLoginStatus(byte by) {
        this.m_byLoginStatus = by;
    }

    public final int getClientRandom() {
        return this.m_nClientRandom;
    }

    public final int getApplianceRandom() {
        return this.m_nApplianceRandom;
    }

    public final void setApplianceRandom(int n) {
        this.m_nApplianceRandom = n;
    }

    public final String getUserName() {
        return this.m_szUserName;
    }

    public final void setUserName(String string) {
        this.m_szUserName = string;
    }

    public final boolean canOtherUserRejectPreemption() {
        return this.m_bOtherUserCanRejectPreemption;
    }

    public final void setOtherUserCanRejectPreemption(boolean bl) {
        this.m_bOtherUserCanRejectPreemption = bl;
    }

    public final byte getPreemptionTimeout() {
        return this.m_byPreemptionTimeout;
    }

    public final void setPreemptionTimeout(byte by) {
        this.m_byPreemptionTimeout = by;
    }

    public final byte getShareRequestTimeout() {
        byte by = this.m_byShareRequestTimeout;
        if ((this.m_bySharePreemptionMode & 0x20) == 32) {
            return by;
        }
        return 30;
    }

    public final void setShareRequestTimeout(byte by) {
        this.m_byShareRequestTimeout = by;
    }

    public final boolean isVideoSocketUsed() {
        return this.m_bVideoSocketUsed;
    }

    public final void setVideoSocketUsed(boolean bl) {
        this.m_bVideoSocketUsed = bl;
    }

    public final boolean isVideoEncrypted() {
        return this.m_bVideoEncrypted;
    }

    public final void setVideoEncrypted(boolean bl) {
        this.m_bVideoEncrypted = bl;
    }

    public final boolean isSharingAvailable() {
        return (this.m_bySharePreemptionMode & 1) == 1;
    }

    public final boolean isStealthModeAvailable() {
        return (this.m_bySharePreemptionMode & 2) == 2;
    }

    public final boolean isPreemptionAvailable() {
        return (this.m_bySharePreemptionMode & 4) == 4;
    }

    public final boolean doesPreemptedUserHaveRightToRejectPreemption() {
        return (this.m_bySharePreemptionMode & 0xC) == 12;
    }

    public final boolean isPreemptionTimeoutAvailable() {
        return (this.m_bySharePreemptionMode & 0x14) == 20;
    }

    public final void setSharePreemptionMode(byte by) {
        this.m_bySharePreemptionMode = by;
    }

    public final byte getVideoEncodingType() {
        return this.m_byVideoEncoding;
    }

    public final void setVideoEncodingType(byte by) {
        this.m_byVideoEncoding = by;
    }

    public final void setVideoSessionType(short s) {
        this.m_sSessionType = s;
    }

    public final boolean isSharedSession() {
        return (this.m_sSessionType & 0x20) == 32;
    }

    public final boolean isPassiveSession() {
        return (this.m_sSessionType & 0x40) == 64;
    }

    public final boolean isStealthSession() {
        return (this.m_sSessionType & 0x80) == 128;
    }

    public final boolean isScanSession() {
        return (this.m_sSessionType & 0x100) == 256;
    }
}

