/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.interfaces.InterfaceViewer3;
import com.avocent.lib.util.OS;
import com.avocent.lib.util.UsernamePassword;
import com.avocent.protocols.socket.SSLHelper;
import com.avocent.video.AVSPStatus;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionAVSP;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.DSAuthImpersonator;
import com.avocent.video.DSConnect;
import com.avocent.video.DSEncryptValues;
import com.avocent.video.DSPath;
import com.avocent.video.DataInputStreamEndian;
import com.avocent.video.DataOutputStreamEndian;
import com.avocent.video.InterfaceViewWindow;
import com.avocent.video.JPanelAppliance;
import com.avocent.video.JPanelApplianceNonBuffered;
import com.avocent.video.LinuxLibrary;
import com.avocent.video.PanelToolbarNormal;
import com.avocent.video.PersistentStorage;
import com.avocent.video.SolarisLibrary;
import com.avocent.video.Win32Library;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import netscape.javascript.JSObject;

public class AppletVideoViewer
extends JApplet
implements InterfaceViewWindow {
    private static String TRACE_CONTEXT = "VideoViewerTrace";
    protected Vector m_vKeyPressedList = new Vector();
    boolean m_bProcessingGeneratedKeyPress = false;
    private boolean isStandalone = false;
    private static final int INPUT_BUFFER_SIZE = 32768;
    private static final int PORT_NUMBER_AASP_KVM = 8192;
    private static final int PORT_NUMBER_AVSP_VIDEO = 8192;
    private static final int PORT_NUMBER_AVSP_SSL = 2068;
    private static final int PORT_NUMBER_PHASE6_AUTH = 8191;
    private static final int PORT_NUMBER_PHASE6_KVM = 8192;
    JSObject jsoWindow = null;
    ApplianceSession m_applianceSession;
    JPanelAppliance m_appliancePanel;
    Socket m_socketAppliance;
    private DataOutputStreamEndian m_dosAppliance;
    private DataInputStreamEndian m_disAppliance;
    private DataOutputStreamEndian m_dosApplianceVideo;
    private DataInputStreamEndian m_disApplianceVideo;
    private DSEncryptValues m_encryptValues;
    private PanelToolbarNormal m_panelToolbar;
    private long m_lLastResizeTime = System.currentTimeMillis();
    private Thread m_threadResize = null;
    private JScrollPane m_scrollPane;
    private Frame m_frameParent = null;
    private int m_nInsetsX = 10;
    private int m_nInsetsY = 27;
    private int m_nLastResizeX = 0;
    private int m_nLastResizeY = 0;
    String m_szTDID = "";
    String m_szIFaceViewer = "";
    String m_szStandalone = "";
    String m_szSessionType = "";
    String m_szLocale = "";
    String m_szServerURL = "";
    String m_szIPAddress = "";
    String m_szApplianceInputPort = "";
    String m_szServerName = "";
    private int m_nHWND = 0;
    private Win32Library m_libWin32;
    private boolean m_bResizeUnderProgramControl = false;
    private boolean m_bKeyboardHooked = false;
    private boolean m_bAltKeyPressed = false;
    private boolean m_bAltKeyReleaseOnTabOrEscSent = false;
    private boolean m_bCtrlKeyPressed = false;
    private boolean m_bCtrlKeyReleaseOnEscSent = false;
    private int[][] m_anAutoScaleSizes = new int[][]{{128, 96, 640, 480, 5}, {160, 120, 640, 480, 4}, {213, 160, 640, 480, 3}, {320, 240, 640, 480, 2}, {416, 312, 832, 624, 2}, {512, 384, 1024, 768, 2}, {640, 480, 640, 480, 1}, {704, 528, 704, 528, 1}, {768, 576, 768, 576, 1}, {832, 624, 832, 624, 1}, {960, 720, 960, 720, 1}, {1024, 768, 1024, 768, 1}};
    static /* synthetic */ Class class$com$avocent$video$AppletVideoViewer;

    public String getParameter(String string, String string2) {
        return this.isStandalone ? System.getProperty(string, string2) : (this.getParameter(string) != null ? this.getParameter(string) : string2);
    }

    public void init() {
        File file;
        if (!Trace.isTraceEnabled()) {
            try {
                Trace.startLogging(null);
            }
            catch (Exception exception) {
                System.out.println("Can't load properties file for trace logging");
            }
        }
        try {
            this.jsoWindow = JSObject.getWindow((Applet)this);
        }
        catch (Exception exception) {
            Trace.logError((String)"VideoViewerTrace", (String)exception.getMessage(), (Throwable)exception);
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            Trace.logError((String)"VideoViewerTrace", (String)exception.getMessage(), (Throwable)exception);
        }
        if (OS.isWindows()) {
            if (!Win32Library.isWin32LibLoaded()) {
                try {
                    file = null;
                    float f = new Float(System.getProperty("os.version")).floatValue();
                    if ((double)f >= 4.0) {
                        file = new File(System.getProperty("deployment.system.profile") + "/system32");
                    }
                    Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.init System directory=" + file.getPath()));
                    InputStream inputStream = (class$com$avocent$video$AppletVideoViewer == null ? (class$com$avocent$video$AppletVideoViewer = AppletVideoViewer.class$("com.avocent.video.AppletVideoViewer")) : class$com$avocent$video$AppletVideoViewer).getResource("/acvvWin32Lib.dll").openStream();
                    File file2 = new File(file + "/" + "acvvWin32Lib.dll");
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.init writing acvvWin32Lib.dll to=" + file2.getPath()));
                    byte[] byArray = new byte[8192];
                    int n = 0;
                    do {
                        if ((n = inputStream.read(byArray)) <= 0) continue;
                        fileOutputStream.write(byArray, 0, n);
                    } while (n > 0);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.init fileTmpDll.exists=" + file2.exists()));
                    file2.deleteOnExit();
                    Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.init fileTmpDll.getName=" + file2.getName()));
                    try {
                        Trace.logInfo((String)"VideoViewerTrace", (String)"AppletVideoViewer.init about to call constructor for Win32Library");
                        this.m_libWin32 = new Win32Library();
                        Trace.logInfo((String)"VideoViewerTrace", (String)"AppletVideoViewer.init about to call Win32Library.initLib");
                        AppletVideoViewer appletVideoViewer = this;
                        appletVideoViewer.m_libWin32.initLib();
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                        Trace.logError((String)TRACE_CONTEXT, (String)unsatisfiedLinkError.getMessage(), (Throwable)unsatisfiedLinkError);
                        if (OS.isLinux()) {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)("Was Linux native library loaded? " + (LinuxLibrary.isLibraryLoaded() ? "YES" : "NO")));
                        } else if (OS.isSolaris()) {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)("Was Solaris native library loaded? " + (SolarisLibrary.isLibraryLoaded() ? "YES" : "NO")));
                        }
                    }
                }
                catch (Exception exception) {
                    Trace.logError((String)"VideoViewerTrace", (String)exception.getMessage(), (Throwable)exception);
                }
            }
        } else if (OS.isLinux()) {
            if (!LinuxLibrary.isLibraryLoaded()) {
                try {
                    file = null;
                    file = new File(System.getProperty("deployment.system.profile"));
                    Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.init System directory=" + file.getPath()));
                    InputStream inputStream = (class$com$avocent$video$AppletVideoViewer == null ? (class$com$avocent$video$AppletVideoViewer = AppletVideoViewer.class$("com.avocent.video.AppletVideoViewer")) : class$com$avocent$video$AppletVideoViewer).getResource("/libavctLinux.so").openStream();
                    File file3 = new File(file + "/" + "libavctLinux.so");
                    FileOutputStream fileOutputStream = new FileOutputStream(file3);
                    Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.init writing linux.so to=" + file3.getPath()));
                    byte[] byArray = new byte[8192];
                    int n = 0;
                    do {
                        if ((n = inputStream.read(byArray)) <= 0) continue;
                        fileOutputStream.write(byArray, 0, n);
                    } while (n > 0);
                    fileOutputStream.flush();
                    fileOutputStream.close();
                    Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.init fileTmpDll.exists=" + file3.exists()));
                    file3.deleteOnExit();
                    Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.init fileTmpDll.getName=" + file3.getName()));
                }
                catch (Exception exception) {
                    Trace.logError((String)"VideoViewerTrace", (String)exception.getMessage(), (Throwable)exception);
                }
            }
        } else if (OS.isSolaris() && !SolarisLibrary.isLibraryLoaded()) {
            try {
                file = null;
                file = new File(System.getProperty("deployment.system.profile"));
                Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.init System directory=" + file.getPath()));
                InputStream inputStream = (class$com$avocent$video$AppletVideoViewer == null ? (class$com$avocent$video$AppletVideoViewer = AppletVideoViewer.class$("com.avocent.video.AppletVideoViewer")) : class$com$avocent$video$AppletVideoViewer).getResource("/libavctSolaris.so").openStream();
                File file4 = new File(file + "/" + "libavctSolaris.so");
                FileOutputStream fileOutputStream = new FileOutputStream(file4);
                Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.init writing solaris.so to=" + file4.getPath()));
                byte[] byArray = new byte[8192];
                int n = 0;
                do {
                    if ((n = inputStream.read(byArray)) <= 0) continue;
                    fileOutputStream.write(byArray, 0, n);
                } while (n > 0);
                fileOutputStream.flush();
                fileOutputStream.close();
                Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.init fileTmpDll.exists=" + file4.exists()));
                file4.deleteOnExit();
                Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.init fileTmpDll.getName=" + file4.getName()));
            }
            catch (Exception exception) {
                Trace.logError((String)"VideoViewerTrace", (String)exception.getMessage(), (Throwable)exception);
            }
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                int n = (int)componentEvent.getComponent().getSize().getHeight();
                int n2 = (int)componentEvent.getComponent().getSize().getWidth();
            }
        });
    }

    public void start() {
        block13: {
            Trace.logInfo((String)"VideoViewerTrace", (String)"In applet Start method");
            Container container = this.getParent();
            while (!(container instanceof Frame)) {
                container = ((Component)container).getParent();
            }
            this.m_frameParent = (Frame)container;
            if (Win32Library.isWin32LibLoaded()) {
                try {
                    this.m_nHWND = this.m_libWin32.getHWND(this.m_frameParent);
                }
                catch (Exception exception) {
                    Trace.logError((String)TRACE_CONTEXT, (String)("JFrameViewer.addNotify exception on setMouseWheelHook " + exception.getMessage()), (Throwable)exception);
                }
            } else if (LinuxLibrary.isLibraryLoaded() || SolarisLibrary.isLibraryLoaded()) {
                this.setVisible(true);
            }
            this.m_szTDID = this.getParameter("tdid");
            Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.start m_szTDID=" + this.m_szTDID));
            this.m_szIFaceViewer = this.getParameter("interfaceviewer");
            Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.start m_szIFaceViewer=" + this.m_szIFaceViewer));
            this.m_szStandalone = this.getParameter("standalone");
            Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.start m_szStandalone=" + this.m_szStandalone));
            this.m_szSessionType = this.getParameter("sessiontype");
            Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.start m_szSessionType=" + this.m_szSessionType));
            this.m_szLocale = this.getParameter("locale");
            Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.start m_szLocale=" + this.m_szLocale));
            this.m_szServerURL = this.getParameter("serverurl");
            Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.start m_szServerURL=" + this.m_szServerURL));
            this.m_szIPAddress = this.getParameter("ipaddress");
            Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.start m_szIPAddress=" + this.m_szIPAddress));
            this.m_szApplianceInputPort = this.getParameter("applianceinputport");
            Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.start m_szApplianceInputPort=" + this.m_szApplianceInputPort));
            this.m_szServerName = this.getParameter("servername");
            Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.start m_szServerName=" + this.m_szServerName));
            String string = "a:" + this.m_szIPAddress + "," + "c:" + "0" + "," + "p:" + this.m_szApplianceInputPort + "," + "s:" + this.m_szServerName;
            try {
                Object object;
                UsernamePassword usernamePassword;
                DSPath dSPath = new DSPath(string, "");
                boolean bl = this.phase6Connect(dSPath);
                if (!bl || !(bl = this.avspConnect(dSPath, usernamePassword = new UsernamePassword("" + this.m_encryptValues.nConsoleRandomNum, "" + this.m_encryptValues.nApplianceRandomNum), this.m_szServerName, true, true))) break block13;
                Object object2 = null;
                if (this.m_szIFaceViewer == null || this.m_szIFaceViewer.length() == 0) {
                    object = new PersistentStorage(dSPath.getIPAddress(), dSPath.getPortNumber(), dSPath.getRIPId(), dSPath.getCascadeChannel());
                    object2 = object;
                } else {
                    try {
                        object = Class.forName(this.m_szIFaceViewer);
                        object2 = (InterfaceViewer3)((Class)object).newInstance();
                    }
                    catch (Exception exception) {
                        Trace.logError((String)"VideoViewerTrace", (String)exception.getMessage(), (Throwable)exception);
                        bl = false;
                    }
                }
                if (bl) {
                    this.m_applianceSession = new ApplianceSessionAVSP(this, 640, 480, 1, (InterfaceViewer3)object2, null, dSPath, this.m_disAppliance, this.m_dosAppliance, this.m_disApplianceVideo, this.m_dosApplianceVideo, false, false, "", false, false, false, false, 0, false);
                    this.m_appliancePanel = OS.isLinux() ? new JPanelApplianceNonBuffered(this.m_applianceSession) : new JPanelAppliance(this.m_applianceSession);
                    this.getContentPane().setLayout(new BorderLayout());
                    object = this.getRootPane().getLayeredPane();
                    ((JLayeredPane)object).setLayer(this.m_appliancePanel, 1);
                    ((Container)object).add(this.m_appliancePanel);
                    ((JComponent)object).setVisible(true);
                    this.getContentPane().setVisible(true);
                    this.setVisible(true);
                }
            }
            catch (Exception exception) {
                Trace.logError((String)"VideoViewerTrace", (String)exception.getMessage(), (Throwable)exception);
            }
        }
    }

    public void stop() {
        Trace.logInfo((String)"VideoViewerTrace", (String)"In applet Stop method");
    }

    public void destroy() {
        Trace.logInfo((String)"VideoViewerTrace", (String)"In applet destroy method");
    }

    private Object jsoWindowCall(String string, Object[] objectArray) {
        if (this.jsoWindow != null) {
            return this.jsoWindow.call(string, objectArray);
        }
        return null;
    }

    private Object jsoGetMember(String string) {
        if (this.jsoWindow != null) {
            return this.jsoWindow.getMember(string);
        }
        return null;
    }

    public JPanelAppliance getPanelAppliance() {
        return this.m_appliancePanel;
    }

    public int getBitmapWidth() {
        return this.m_appliancePanel.getBitmapWidth();
    }

    public int getBitmapHeight() {
        return this.m_appliancePanel.getBitmapHeight();
    }

    public int getPixelArrayWidth() {
        return this.m_appliancePanel.getPixelArrayWidth();
    }

    public void initWindow(ApplianceSession applianceSession, int n, int n2, short s, short s2, short s3, short s4, int n3) {
        this.initWindow(applianceSession, n, n2, s, s2, s3, s4, n3, true);
    }

    public void initWindow(ApplianceSession applianceSession, int n, int n2, short s, short s2, short s3, short s4, int n3, boolean bl) {
        Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoWindow.initWindow sWidth=" + s + " sHeight=" + s2 + " sVideoWidth=" + s3 + " sVideoHeight=" + s4));
        this.m_applianceSession = applianceSession;
        this.m_appliancePanel.initPanelAppliance(this.m_applianceSession, n, n2, s, s2, s3, s4, n3, true, bl);
        this.m_appliancePanel.setVisible(true);
        this.m_bResizeUnderProgramControl = true;
        this.resizeTo(s / n3, s2 / n3);
        this.initToolbar(this.m_applianceSession);
        this.m_appliancePanel.setVideoQueueSleepTimeActivated();
    }

    public void initToolbar(ApplianceSession applianceSession) {
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        JLayeredPane jLayeredPane = this.getRootPane().getLayeredPane();
        if (this.m_panelToolbar != null) {
            jLayeredPane.remove(this.m_panelToolbar);
            applianceSession.getApplianceWindow().getPanelAppliance().invalidate();
        }
        this.m_panelToolbar = new PanelToolbarNormal(applianceSessionInfo.getPanedWidth() / applianceSessionInfo.getDecimationFactor() / 2, 0, applianceSessionInfo.getPanedWidth() / applianceSessionInfo.getDecimationFactor(), this.m_frameParent, this.m_nHWND, this.m_appliancePanel, "", applianceSession, false, false, applianceSessionInfo.getToolbarHideDelay());
        jLayeredPane.setLayer(this.m_panelToolbar, 2);
        jLayeredPane.add(this.m_panelToolbar);
        this.m_panelToolbar.initToolbar(applianceSession);
    }

    public void mouseAlign() {
    }

    public void setConnectionType(int n) {
    }

    public void notifyLockedModeChanged() {
    }

    public void notifyReserveModeChanged() {
    }

    public void notifyManualVideoAdjustDialogClosed() {
    }

    public void notifyVmAvailableChanged() {
    }

    public void repaintAppliance() {
    }

    public void terminate() {
    }

    public void bringWindowToTop() {
    }

    public Component getViewComponent() {
        return this;
    }

    public void enableScalingControls(boolean bl) {
    }

    public boolean isSingleCursorActive() {
        return false;
    }

    public void activateSingleCursorMode(boolean bl) {
    }

    public void fullScreenToggle() {
    }

    public boolean activateMenu() {
        return true;
    }

    public void resizeVideoWindow(int n, int n2) {
        this.resizeVideoWindow(n, n2, true);
    }

    public void resizeVideoWindow(int n, int n2, boolean bl) {
        Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.resizeVideoWindow nWidth=" + n + " nHeight=" + n2));
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        this.initWindow(this.m_applianceSession, 0, 0, (short)n, (short)n2, applianceSessionInfo.getVideoWidth(), applianceSessionInfo.getVideoHeight(), applianceSessionInfo.getDecimationFactor(), bl);
    }

    public Frame getFrameWindow() {
        return this.m_frameParent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean phase6Connect(DSPath dSPath) {
        boolean bl;
        block30: {
            IOException iOException2222;
            FilterInputStream filterInputStream;
            FilterOutputStream filterOutputStream;
            Socket socket;
            block26: {
                block25: {
                    bl = false;
                    DSConnect dSConnect = null;
                    Socket socket2 = null;
                    socket = null;
                    filterOutputStream = null;
                    filterInputStream = null;
                    socket = new Socket(InetAddress.getByName(dSPath.getIPAddress()), 8191);
                    Trace.logInfo((String)"VideoViewerTrace", (String)("Socket DSAuth connected to: " + socket.getInetAddress().getHostAddress().toString()));
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(socket.getInputStream());
                    filterOutputStream = new DataOutputStreamEndian(bufferedOutputStream);
                    filterInputStream = new DataInputStreamEndian(bufferedInputStream, socket);
                    DSAuthImpersonator dSAuthImpersonator = new DSAuthImpersonator();
                    if (!dSAuthImpersonator.DSConnectAuth((DataOutputStreamEndian)filterOutputStream, (DataInputStreamEndian)filterInputStream, socket.getLocalAddress().toString(), dSPath.getPortNumber(), dSPath.getCascadeChannel())) break block25;
                    socket2 = new Socket(InetAddress.getByName(dSPath.getIPAddress()), 8192);
                    socket2.setTcpNoDelay(true);
                    socket2.setTrafficClass(24);
                    socket2.setReceiveBufferSize(32768);
                    Trace.logInfo((String)"VideoViewerTrace", (String)("Socket connected to: " + socket2.getInetAddress().getHostAddress().toString()));
                    BufferedOutputStream bufferedOutputStream2 = new BufferedOutputStream(socket2.getOutputStream());
                    BufferedInputStream bufferedInputStream2 = new BufferedInputStream(socket2.getInputStream());
                    this.m_dosAppliance = new DataOutputStreamEndian(bufferedOutputStream2);
                    this.m_disAppliance = new DataInputStreamEndian(bufferedInputStream2, socket2);
                    dSConnect = new DSConnect();
                    if (this.m_encryptValues != null) {
                        bl = true;
                        break block25;
                    }
                    Trace.logInfo((String)"VideoViewerTrace", (String)("(phase6connect) DSConnectAppliance error: " + dSConnect.getLastError()));
                }
                Object var14_14 = null;
                if (filterOutputStream == null) break block26;
                try {
                    filterOutputStream.close();
                }
                catch (IOException iOException2222) {
                    Trace.logError((String)"VideoViewerTrace", (String)"(phase6connect) IOException", (Throwable)iOException2222);
                }
            }
            if (filterInputStream != null) {
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException2222) {
                    Trace.logError((String)"VideoViewerTrace", (String)"(phase6connect) IOException", (Throwable)iOException2222);
                }
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException2222) {
                    Trace.logError((String)"VideoViewerTrace", (String)"(phase6connect) IOException", (Throwable)iOException2222);
                }
            }
            break block30;
            {
                catch (IOException iOException3) {
                    IOException iOException42222;
                    Trace.logError((String)"VideoViewerTrace", (String)("(phase6connect) IOException:" + iOException3.getMessage()), (Throwable)iOException3);
                    Object var14_15 = null;
                    if (filterOutputStream != null) {
                        try {
                            filterOutputStream.close();
                        }
                        catch (IOException iOException42222) {
                            Trace.logError((String)"VideoViewerTrace", (String)"(phase6connect) IOException", (Throwable)iOException42222);
                        }
                    }
                    if (filterInputStream != null) {
                        try {
                            filterInputStream.close();
                        }
                        catch (IOException iOException42222) {
                            Trace.logError((String)"VideoViewerTrace", (String)"(phase6connect) IOException", (Throwable)iOException42222);
                        }
                    }
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (IOException iOException42222) {
                            Trace.logError((String)"VideoViewerTrace", (String)"(phase6connect) IOException", (Throwable)iOException42222);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                IOException iOException52222;
                Object var14_16 = null;
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (IOException iOException52222) {
                        Trace.logError((String)"VideoViewerTrace", (String)"(phase6connect) IOException", (Throwable)iOException52222);
                    }
                }
                if (filterInputStream != null) {
                    try {
                        filterInputStream.close();
                    }
                    catch (IOException iOException52222) {
                        Trace.logError((String)"VideoViewerTrace", (String)"(phase6connect) IOException", (Throwable)iOException52222);
                    }
                }
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException52222) {
                        Trace.logError((String)"VideoViewerTrace", (String)"(phase6connect) IOException", (Throwable)iOException52222);
                    }
                }
                throw throwable;
            }
        }
        return bl;
    }

    private boolean avspConnect(DSPath dSPath, UsernamePassword usernamePassword, String string, boolean bl, boolean bl2) {
        boolean bl3 = false;
        try {
            Closeable closeable;
            boolean bl4 = false;
            boolean bl5 = false;
            SSLSocket sSLSocket = null;
            try {
                closeable = new Socket(this.m_szIPAddress, 2068);
                sSLSocket = SSLHelper.createSSLSocket((Socket)closeable, (String)this.m_szIPAddress, (int)2068, (int)30000, null, null, null);
                sSLSocket.setTcpNoDelay(true);
                Trace.logInfo((String)"VideoViewerTrace", (String)("VideoSessionManager::avspConnect: Socket connected to: " + sSLSocket.getInetAddress().getHostAddress().toString()));
            }
            catch (SSLException sSLException) {
                Trace.logError((String)"VideoViewerTrace", (String)("VideoSessionManager::avspConnect: Failed to connectSSL due to SSL exception" + sSLException.getMessage()), (Throwable)sSLException);
                return false;
            }
            closeable = new BufferedOutputStream(sSLSocket.getOutputStream());
            BufferedInputStream bufferedInputStream = new BufferedInputStream(sSLSocket.getInputStream());
            this.m_dosAppliance = new DataOutputStreamEndian((OutputStream)closeable);
            this.m_disAppliance = new DataInputStreamEndian(bufferedInputStream, sSLSocket);
            AVSPStatus aVSPStatus = new AVSPStatus();
            sSLSocket.setSoTimeout(30000);
            DSConnect.dsConnectApplianceAVSP(this.m_dosAppliance, this.m_disAppliance, dSPath, usernamePassword.getUsername(), usernamePassword.getPassword(), bl4, aVSPStatus);
            sSLSocket.setSoTimeout(0);
            if (aVSPStatus.getLoginStatus() == 0) {
                Socket socket = new Socket(InetAddress.getByName(dSPath.getIPAddress()), 8192);
                socket.setTcpNoDelay(true);
                socket.setReceiveBufferSize(32768);
                Trace.logInfo((String)"VideoViewerTrace", (String)("Video Socket connected to: " + socket.getInetAddress().getHostAddress().toString()));
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(socket.getOutputStream());
                BufferedInputStream bufferedInputStream2 = new BufferedInputStream(socket.getInputStream());
                this.m_dosApplianceVideo = new DataOutputStreamEndian(bufferedOutputStream);
                this.m_disApplianceVideo = new DataInputStreamEndian(bufferedInputStream2, socket);
                socket.setSoTimeout(30000);
                if (DSConnect.dsConnectVideoAVSP(this.m_dosApplianceVideo, this.m_disApplianceVideo, aVSPStatus.getClientRandom(), aVSPStatus.getApplianceRandom())) {
                    socket.setSoTimeout(0);
                    bl3 = true;
                    bl4 = false;
                } else {
                    this.m_dosAppliance.close();
                    this.m_disAppliance.close();
                    this.m_dosApplianceVideo.close();
                    this.m_disApplianceVideo.close();
                }
            } else {
                this.m_dosAppliance.close();
                this.m_disAppliance.getSocket().close();
                this.m_disAppliance.close();
                if (!bl2) {
                    Trace.logInfo((String)"VideoViewerTrace", (String)"(videoViewer avspConnect) returning false the login failed and bDisplayErrorMessage false");
                    return false;
                }
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"VideoViewerTrace", (String)"asvpConnect error", (Throwable)exception);
        }
        return bl3;
    }

    public void resize(int n, int n2) {
        Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.resize nX=" + n + " nY=" + n2));
        this.m_nLastResizeX = n;
        this.m_nLastResizeY = n2;
        this.m_lLastResizeTime = System.currentTimeMillis();
        if (this.m_appliancePanel != null && this.m_applianceSession != null && this.m_threadResize == null) {
            this.m_threadResize = new Thread(new Runnable(){

                public void run() {
                    Trace.logInfo((String)"VideoViewerTrace", (String)"AppletVideoViewer.resize start of m_threadResize");
                    while (System.currentTimeMillis() - AppletVideoViewer.this.m_lLastResizeTime < 1000L) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    AppletVideoViewer.this.resizedComplete();
                    AppletVideoViewer.this.m_threadResize = null;
                }
            });
            this.m_threadResize.start();
        }
    }

    private void resizedComplete() {
        Trace.logInfo((String)"VideoViewerTrace", (String)("AppletVideoViewer.resizedComplete nX=" + this.m_nLastResizeX + " nY=" + this.m_nLastResizeY));
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        if (this.m_bResizeUnderProgramControl) {
            this.m_bResizeUnderProgramControl = false;
        } else if (applianceSessionInfo.isAutoScale()) {
            this.componentResizedAutoScale();
        } else if (applianceSessionInfo.isFullScale()) {
            // empty if block
        }
    }

    private void resizeTo(int n, int n2) {
        this.jsoWindowCall("resizeTo", new Object[]{"" + (n + this.m_nInsetsX), "" + (n2 + this.m_nInsetsY)});
    }

    public void componentResizedAutoScale() {
        int n;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(AppletVideoViewer componentResizedAutoScale) in auto scale mode");
        Insets insets = this.m_scrollPane.getInsets();
        int n2 = this.m_nLastResizeX - this.m_nInsetsX - insets.left - insets.right;
        int n3 = this.m_nLastResizeY - this.m_nInsetsY - insets.top - insets.bottom;
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(AppletVideoViewer componentResizedAutoScale) nX:" + n2 + " nY:" + n3 + " sessionInfo.getPanedWidth:" + applianceSessionInfo.getPanedWidth() + " sessionInfo.getPanedHeight:" + applianceSessionInfo.getPanedHeight()));
        if (n2 > 1024 || n3 > 768) {
            int n4 = 1024;
            int n5 = 768;
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(AppletVideoViewer componentResizedAutoScale) size of panel is larger than permissible size, calling resizeTo, nNewX:" + n4 + " nNewY:" + n5));
            this.resizeTo(n4, n5);
            return;
        }
        if (n2 == applianceSessionInfo.getPanedWidth() && n3 == applianceSessionInfo.getPanedHeight() && applianceSessionInfo.getDecimationFactor() == 1) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(AppletVideoViewer componentResizedAutoScale) no panel resize necessary");
            short s = applianceSessionInfo.getPanedWidth();
            short s2 = applianceSessionInfo.getPanedHeight();
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(AppletVideoViewer componentResizedAutoScale) no panel resize necessary, calling setSize, nNewX:" + s + " nNewY:" + s2));
            this.resizeTo(s, s2);
            try {
                this.m_applianceSession.cmdStartVideo();
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            }
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (n2 > applianceSessionInfo.getPanedWidth() / applianceSessionInfo.getDecimationFactor()) {
            bl = true;
            bl2 = true;
        } else if (n3 > applianceSessionInfo.getPanedHeight() / applianceSessionInfo.getDecimationFactor()) {
            bl = true;
        } else if (n2 < applianceSessionInfo.getPanedWidth() / applianceSessionInfo.getDecimationFactor()) {
            bl2 = true;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 1;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(AppletVideoViewer componentResizedAutoScale) m_sizeScreen:" + dimension.getWidth() + "x" + dimension.getHeight() + " bMakingLarger:" + bl + " bWidthChanging:" + bl2));
        Trace.logInfo((String)TRACE_CONTEXT, (String)("m_anAutoScaleSizes.length=" + this.m_anAutoScaleSizes.length + " [0][0]=" + this.m_anAutoScaleSizes[0][0] + " [0][1]=" + this.m_anAutoScaleSizes[0][1] + " [1][0]=" + this.m_anAutoScaleSizes[1][0]));
        if (bl) {
            if (bl2) {
                for (n = this.m_anAutoScaleSizes.length - 1; n >= 0; --n) {
                    if (n2 <= this.m_anAutoScaleSizes[n][0]) continue;
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("nCnt=" + n + " m_anAutoScaleSizes[nCnt][0]=" + this.m_anAutoScaleSizes[n][0]));
                    if (n < this.m_anAutoScaleSizes.length - 1) {
                        n6 = this.m_anAutoScaleSizes[n + 1][2];
                        n7 = this.m_anAutoScaleSizes[n + 1][3];
                        n8 = this.m_anAutoScaleSizes[n + 1][4];
                        break;
                    }
                    n6 = this.m_anAutoScaleSizes[n][2];
                    n7 = this.m_anAutoScaleSizes[n][3];
                    n8 = this.m_anAutoScaleSizes[n][4];
                    break;
                }
                if (n6 == 0) {
                    n = this.m_anAutoScaleSizes.length - 1;
                    n6 = this.m_anAutoScaleSizes[n][2];
                    n7 = this.m_anAutoScaleSizes[n][3];
                    n8 = this.m_anAutoScaleSizes[n][4];
                }
            } else {
                for (n = this.m_anAutoScaleSizes.length; n >= 0; --n) {
                    if (n3 <= this.m_anAutoScaleSizes[n][1]) continue;
                    if (n < this.m_anAutoScaleSizes.length - 1) {
                        n6 = this.m_anAutoScaleSizes[n + 1][2];
                        n7 = this.m_anAutoScaleSizes[n + 1][3];
                        n8 = this.m_anAutoScaleSizes[n + 1][4];
                        break;
                    }
                    n6 = this.m_anAutoScaleSizes[n][2];
                    n7 = this.m_anAutoScaleSizes[n][3];
                    n8 = this.m_anAutoScaleSizes[n][4];
                    break;
                }
                if (n7 == 0) {
                    n = this.m_anAutoScaleSizes.length - 1;
                    n6 = this.m_anAutoScaleSizes[n][2];
                    n7 = this.m_anAutoScaleSizes[n][3];
                    n8 = this.m_anAutoScaleSizes[n][4];
                }
            }
        } else if (bl2) {
            for (n = 0; n < this.m_anAutoScaleSizes.length; ++n) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("nCnt=" + n + " nX=" + n2 + " m_anAutoScaleSizes[nCnt][0]=" + this.m_anAutoScaleSizes[n][0]));
                if (n2 >= this.m_anAutoScaleSizes[n][0]) continue;
                Trace.logInfo((String)TRACE_CONTEXT, (String)("nCnt=" + n + " m_anAutoScaleSizes[nCnt][0]=" + this.m_anAutoScaleSizes[n][0]));
                if (n > 0) {
                    n6 = this.m_anAutoScaleSizes[n - 1][2];
                    n7 = this.m_anAutoScaleSizes[n - 1][3];
                    n8 = this.m_anAutoScaleSizes[n - 1][4];
                    break;
                }
                n6 = this.m_anAutoScaleSizes[n][2];
                n7 = this.m_anAutoScaleSizes[n][3];
                n8 = this.m_anAutoScaleSizes[n][4];
                break;
            }
            if (n6 == 0) {
                n6 = this.m_anAutoScaleSizes[0][2];
                n7 = this.m_anAutoScaleSizes[0][3];
                n8 = this.m_anAutoScaleSizes[0][4];
            }
        } else {
            for (n = 0; n < this.m_anAutoScaleSizes.length; ++n) {
                if (n3 >= this.m_anAutoScaleSizes[n][1]) continue;
                if (n > 0) {
                    n6 = this.m_anAutoScaleSizes[n - 1][2];
                    n7 = this.m_anAutoScaleSizes[n - 1][3];
                    n8 = this.m_anAutoScaleSizes[n - 1][4];
                    break;
                }
                n6 = this.m_anAutoScaleSizes[n][2];
                n7 = this.m_anAutoScaleSizes[n][3];
                n8 = this.m_anAutoScaleSizes[n][4];
                break;
            }
            if (n7 == 0) {
                n6 = this.m_anAutoScaleSizes[0][2];
                n7 = this.m_anAutoScaleSizes[0][3];
                n8 = this.m_anAutoScaleSizes[0][4];
            }
        }
        try {
            n = applianceSessionInfo.getDecimationFactor();
            short s = applianceSessionInfo.getPanedWidth();
            short s3 = applianceSessionInfo.getPanedHeight();
            applianceSessionInfo.setPanedWidth((short)n6);
            applianceSessionInfo.setPanedHeight((short)n7);
            applianceSessionInfo.setDecimationFactor(n8);
            this.m_applianceSession.setPersistentData(applianceSessionInfo);
            if (n != n8 && s == n6 && s3 == n7) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(AppletVideoViewer componentResizedAutoScale) calling cmdRefreshPane");
                this.m_applianceSession.cmdRefreshPane();
            } else if (s == n6 && s3 == n7) {
                this.resizeVideoWindow(n6, n7);
            } else {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(AppletVideoViewer componentResizedAutoScale) calling cmdStartVideo");
                this.m_applianceSession.cmdStartVideo();
            }
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void notifyKeyPressed(short s) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewer.notifyKeyPressed sScanCode:" + s));
        if (SolarisLibrary.isLibraryLoaded()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewer.notifyKeyPressed Solaris KeyPress sScanCode:" + s));
            this.m_applianceSession.cmdKeyPressed(s + 1);
            if (s + 1 == 83 || s + 1 == 57) {
                this.m_applianceSession.cmdKeyReleased(s + 1);
            }
            return;
        }
        if (!this.m_appliancePanel.hasFocus()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyPressed ignoring because we don't have focus");
            return;
        }
        if (!this.m_bKeyboardHooked && (s == 107 || s == 108) && OS.isWindows()) {
            return;
        }
        if (LinuxLibrary.isLibraryLoaded() && !this.m_bProcessingGeneratedKeyPress) {
            this.m_vKeyPressedList.addElement(new Short(s));
        }
        if (s == 56 || s == 105) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyPressed ALT key pressed");
            this.m_bAltKeyPressed = true;
            this.m_bAltKeyReleaseOnTabOrEscSent = false;
        } else if (s == 29 || s == 101) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyPressed CTRL key pressed");
            this.m_bCtrlKeyPressed = true;
            this.m_bCtrlKeyReleaseOnEscSent = false;
        }
        this.m_applianceSession.cmdScanCodeKeyPressed(s);
    }

    public void notifyKeyReleased(short s) {
        Object object;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewer.notifyKeyReleased sScanCode:" + s));
        if (SolarisLibrary.isLibraryLoaded()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewer.notifyKeyReleased Solaris KeyRelease sScanCode:" + s));
            if (s + 1 == 83 || s + 1 == 57) {
                this.m_applianceSession.cmdKeyPressed(s + 1);
            }
            this.m_applianceSession.cmdKeyReleased(s + 1);
            return;
        }
        if (!this.m_appliancePanel.hasFocus()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased ignoring because we don't have focus");
            return;
        }
        if (!this.m_bKeyboardHooked && (s == 107 || s == 108) && OS.isWindows()) {
            return;
        }
        if (LinuxLibrary.isLibraryLoaded()) {
            object = this.getKeyPressForScanCode(s);
            if (object == null) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("Generating missing key press for sScanCode:" + s));
                this.m_bProcessingGeneratedKeyPress = true;
                this.notifyKeyPressed(s);
                this.m_bProcessingGeneratedKeyPress = false;
            } else {
                this.m_vKeyPressedList.removeElement(object);
            }
        }
        if (s == 56 || s == 105) {
            this.m_bAltKeyPressed = false;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased ALT key released");
            this.m_bAltKeyReleaseOnTabOrEscSent = false;
        } else if (s == 29 || s == 101) {
            this.m_bCtrlKeyPressed = false;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased CTRL key released");
            this.m_bCtrlKeyReleaseOnEscSent = false;
        }
        if (this.m_bAltKeyPressed && (s == 15 || s == 1)) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased TAB or ESC key released with ALT down");
            if (!this.m_bAltKeyReleaseOnTabOrEscSent) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased sending ALT key released then pressed/released pair");
                object = new Thread(new Runnable(){

                    public void run() {
                        AppletVideoViewer.this.m_applianceSession.cmdKeyReleased(18);
                        AppletVideoViewer.this.m_applianceSession.cmdKeyPressed(18);
                        AppletVideoViewer.this.m_applianceSession.cmdKeyReleased(18);
                    }
                });
                ((Thread)object).start();
                this.m_bAltKeyReleaseOnTabOrEscSent = true;
            }
            return;
        }
        if (this.m_bCtrlKeyPressed && s == 1) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased ESC key released with CTRL down");
            if (!this.m_bCtrlKeyReleaseOnEscSent) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased sending CTRL key released");
                object = new Thread(new Runnable(){

                    public void run() {
                        AppletVideoViewer.this.m_applianceSession.cmdKeyReleased(17);
                    }
                });
                ((Thread)object).start();
                this.m_bCtrlKeyReleaseOnEscSent = true;
            }
            return;
        }
        this.m_applianceSession.cmdScanKeyReleased(s);
    }

    Short getKeyPressForScanCode(short s) {
        Short s2 = null;
        for (int i = 0; i < this.m_vKeyPressedList.size(); ++i) {
            Short s3 = (Short)this.m_vKeyPressedList.elementAt(i);
            if (s3 != s) continue;
            s2 = s3;
            break;
        }
        return s2;
    }

    public void setLinuxKeyboardPassThru(boolean bl, Component component) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

