/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.interfaces.InterfaceViewer3;
import com.avocent.lib.interfaces.SessionStatus;
import com.avocent.lib.util.StringUtilities;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.DSData;
import com.avocent.video.DSPath;
import com.avocent.video.InterfaceConnectedUsersListener;
import com.avocent.video.InterfaceNotifyOnClosing;
import com.avocent.video.InterfaceViewWindow;
import com.avocent.video.JDialogManualVideoAdjust;
import com.avocent.video.JPanelAppliance;
import com.avocent.video.KeyStroke;
import com.avocent.video.KeyboardMacro;
import com.avocent.video.Queue;
import java.awt.Frame;
import java.awt.Window;
import java.io.IOException;
import java.security.cert.CertificateEncodingException;
import java.util.Properties;
import java.util.Vector;

public abstract class ApplianceSession
extends Thread {
    public static final int VIDEO_ENCODING_AVC = 1;
    public static final int VIDEO_ENCODING_DVC = 2;
    public static final int VIDEO_COLOR_DEPTH_NOT_DEFINED = 0;
    public static final int VIDEO_STOPPAGE_REASON_CALIBRATING = 0;
    public static final int VIDEO_STOPPAGE_REASON_NO_SIGNAL = 1;
    public static final int PROJECT_UNKNOWN = 0;
    public static final int PROJECT_AVWORKS_NAUTILUS = 1;
    public static final int PROJECT_DSVIEW_31 = 2;
    public static final int PROJECT_NEC = 3;
    public static final int PROJECT_GLACIERD = 4;
    public static final int PROJECT_STINGRAY = 5;
    public static final int CONNECTION_TYPE_INITIAL = 0;
    public static final int CONNECTION_TYPE_ACTIVE = 1;
    public static final int CONNECTION_TYPE_EXCLUSIVE = 2;
    public static final int CONNECTION_TYPE_ACTIVE_SHARING_PRIMARY = 3;
    public static final int CONNECTION_TYPE_ACTIVE_SHARING_SECONDARY = 4;
    public static final int CONNECTION_TYPE_PASSIVE = 5;
    public static final int CONNECTION_TYPE_STEALTH = 6;
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    protected InterfaceViewer3 m_iFaceViewer;
    private String m_szTitle;
    private ApplianceSessionInfo m_sessionInfo;
    protected DSPath m_dsPath;
    private String m_szApplianceIP;
    private String m_szApplianceName;
    private int m_nAppliancePort;
    private int m_nApplianceChannel;
    private String m_szDeviceID;
    private String m_szRipID;
    private String m_szLoginTimeOut;
    private boolean m_bhasApcp;
    private int m_nApplianceType;
    private boolean m_bEnableScalingControls = true;
    private boolean m_bEnableFullScreenSupport = true;
    private boolean m_bEnableVideoAdjustSupport = true;
    protected boolean m_bEnableConnectedUserSupport = true;
    private boolean m_bSharingConnection = false;
    private boolean m_bStealthConnection = false;
    private boolean m_bSingleCursorMouseRelative = false;
    private boolean m_bSharedConnectionAtLaunch = false;
    private boolean m_bPPPConnection = false;
    private boolean m_bPassiveConnection = false;
    private int m_nVideoPacketsReceivedTotal = 0;
    private int m_nVideoPacketsReceivedSinceLastConfirm = 0;
    private Vector m_vNotifyOnClosing = new Vector();
    private JDialogManualVideoAdjust m_dlgManualVideoAdjust;
    private String m_szHelpURL;
    protected SessionStatus m_sessionStatus = null;
    protected boolean m_bUserHasRightsToLaunchVirtualMedia = false;
    protected boolean m_bVirtualMediaAvailableForTD = false;
    protected boolean m_bEncryptVM = true;
    protected boolean m_bReserveMode = false;
    protected boolean m_bLockedMode = false;
    protected boolean m_bExclusiveModeAvailable = false;
    protected String m_szOEM = "";
    protected String m_szLaunchApp = "";
    protected Properties m_propertiesLaunch = null;
    protected int m_nApplicationCode = 0;
    protected int m_nConnectionType = 0;
    protected int m_nClientRandomNumber = 0;
    protected int m_nApplianceRandomNumber = 0;

    public ApplianceSession(String string, InterfaceViewer3 interfaceViewer3, SessionStatus sessionStatus, DSPath dSPath, String string2, int n, int n2, String string3) {
        super(string);
        this.m_iFaceViewer = interfaceViewer3;
        this.m_sessionStatus = sessionStatus;
        this.m_dsPath = dSPath;
        this.m_szTitle = string2;
        this.m_szApplianceIP = this.m_dsPath.getIPAddress();
        this.m_szApplianceName = this.m_dsPath.getServerName();
        this.m_nAppliancePort = this.m_dsPath.getPortNumber();
        this.m_nApplianceChannel = this.m_dsPath.getCascadeChannel();
        this.m_szDeviceID = this.m_dsPath.getDeviceID();
        this.m_szRipID = this.m_dsPath.getRIPId();
        this.m_szLoginTimeOut = "" + this.m_dsPath.getLoginTimeOut();
        this.m_bhasApcp = this.m_dsPath.hasApcp();
        this.m_nApplianceType = n;
        this.m_nApplicationCode = n2;
        this.m_szHelpURL = string3;
        if (this.m_szHelpURL != null && this.m_szHelpURL.length() == 0) {
            this.m_szHelpURL = null;
        }
        this.m_dlgManualVideoAdjust = null;
        this.m_sessionInfo = new ApplianceSessionInfo(this.m_iFaceViewer, this.m_szDeviceID, this.m_nApplicationCode);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSession constructor) DeviceID=" + this.m_szDeviceID + " IP=" + this.m_szApplianceIP + " Name=" + this.m_szApplianceName + " Port=" + this.m_nAppliancePort + " Channel=" + this.m_nApplianceChannel + " Type=" + this.m_nApplianceType));
        this.logEventSession(0);
    }

    public abstract void setPersistentMacroData(ApplianceSessionInfo var1);

    public abstract void setGlobalMacroData(ApplianceSessionInfo var1);

    public abstract void setApplianceWindow(InterfaceViewWindow var1);

    public abstract InterfaceViewWindow getApplianceWindow();

    public abstract boolean isSessionRunning();

    public abstract void flushInputQueue();

    public abstract void cmdMouseMoved(boolean var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, int var8, int var9, char var10) throws IOException;

    public abstract void cmdMouseMovedRelative(boolean var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, int var8, int var9, char var10) throws IOException;

    public abstract void cmdKeyPressed(int var1);

    public abstract void cmdKeyPressed(int var1, boolean var2);

    public abstract void cmdKeyPressed(int var1, char var2, int var3);

    public abstract void cmdScanCodeKeyPressed(int var1);

    public abstract void cmdKeyReleased(int var1);

    public abstract void cmdKeyReleased(int var1, boolean var2);

    public abstract void cmdKeyReleased(int var1, char var2, int var3);

    public abstract void cmdScanKeyReleased(int var1);

    public abstract void cmdSendKeystrokes(KeyStroke[] var1);

    public abstract void cmdSendMacroKeystrokes(KeyboardMacro var1);

    public abstract void cmdNumLockSet(boolean var1);

    public abstract void cmdScrollLockSet(boolean var1);

    public abstract void cmdCapsLockSet(boolean var1);

    public abstract void cmdGetConnectedUsers() throws IOException;

    public abstract void cmdExclusiveMode(boolean var1) throws IOException;

    public abstract void cmdKanaLockSet(boolean var1);

    public abstract void cmdMouseAlign() throws IOException;

    public abstract void cmdMouseReenable(boolean var1) throws IOException;

    public abstract void cmdPS2Reset() throws IOException;

    public abstract void cmdKBStatusRequest() throws IOException;

    public abstract void cmdFocusControl(boolean var1) throws IOException;

    public abstract void cmdStopVideo() throws IOException;

    public abstract void cmdStartVideo() throws IOException;

    public abstract void cmdFullScale() throws IOException;

    public abstract void cmdRefreshPane() throws IOException;

    public abstract void cmdAutoAdjustVideo() throws IOException;

    public abstract void cmdThrottleVideo(int var1) throws IOException;

    public abstract void cmdVideoTestPattern(boolean var1) throws IOException;

    public abstract void cmdVideoWidth(int var1) throws IOException;

    public abstract void cmdVideoFine(int var1) throws IOException;

    public abstract void cmdVideoHorzCapture(int var1) throws IOException;

    public abstract void cmdVideoVertCapture(int var1) throws IOException;

    public abstract void cmdVideoContrast(int var1) throws IOException;

    public abstract void cmdVideoBrightness(int var1) throws IOException;

    public abstract void cmdVideoNoiseThreshold(int var1) throws IOException;

    public abstract void cmdVideoPriorityThreshold(int var1) throws IOException;

    public abstract void cmdVideoSetup() throws IOException;

    public abstract void cmdVideoSetColorDepth(int var1, boolean var2) throws IOException;

    public abstract void cmdRejectPreemptionRequest() throws IOException;

    public abstract void closingPreemptWarningDlg();

    public abstract boolean isInitialKBMouseStatusReceived();

    public abstract void terminateSession();

    public abstract int getVideoEncodingType();

    public abstract int getColorDepth();

    public abstract float getProtocolVersion();

    public abstract String getProtocolType();

    public abstract void enableInactivityTimeout(int var1);

    public abstract void setMouseThrottle(int var1);

    public abstract void registerConnectedUsersListener(InterfaceConnectedUsersListener var1);

    public abstract void unregisterConnectedUsersListener(InterfaceConnectedUsersListener var1);

    public abstract void initPixelArray(int var1, int var2);

    public abstract void setAVCPixels(int var1, int var2, int var3, int var4, byte[] var5);

    public abstract boolean useJavaKeyCodes();

    public abstract void setPowerOff();

    public abstract void setPowerOn();

    public abstract void setPowerCycle();

    public abstract int getPowerState();

    public abstract void cmdMouseAcceleration(int var1) throws IOException;

    public abstract void videoConfigChanged(JPanelAppliance var1);

    public void registerWindow(Window window) {
        try {
            this.m_iFaceViewer.registerWindow(window, this.m_szTitle, 4);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public InterfaceViewer3 getIFaceViewer() {
        return this.m_iFaceViewer;
    }

    private boolean logEvent(int n, String[] stringArray) {
        if (this.m_iFaceViewer != null) {
            int n2 = this.m_iFaceViewer.logEvent(n, stringArray);
            return n2 == 0;
        }
        return false;
    }

    public boolean logEventMacro(int n, String string, String string2) {
        String[] stringArray = new String[]{string, string2};
        return this.logEvent(n, stringArray);
    }

    public boolean logEventSession(int n) {
        String[] stringArray = new String[3];
        stringArray[0] = this.m_dsPath.getDeviceID();
        if (this.m_sessionStatus != null) {
            try {
                stringArray[1] = StringUtilities.encodeAsBase64((byte[])this.m_sessionStatus.getAdsapCert().getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                Trace.logError((String)TRACE_CONTEXT, (String)certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            }
        }
        stringArray[2] = "video";
        return this.logEvent(n, stringArray);
    }

    public boolean logEventSession(int n, String string) {
        String[] stringArray = new String[4];
        stringArray[0] = this.m_dsPath.getDeviceID();
        if (this.m_sessionStatus != null) {
            try {
                stringArray[1] = StringUtilities.encodeAsBase64((byte[])this.m_sessionStatus.getAdsapCert().getEncoded());
            }
            catch (CertificateEncodingException certificateEncodingException) {
                Trace.logError((String)TRACE_CONTEXT, (String)certificateEncodingException.getMessage(), (Throwable)certificateEncodingException);
            }
        }
        stringArray[2] = "video";
        stringArray[3] = string;
        return this.logEvent(n, stringArray);
    }

    public boolean wasStartedFromCommandLine() {
        return this.m_iFaceViewer == null;
    }

    public final String getTitle() {
        return this.m_szTitle;
    }

    public String getApplianceIP() {
        return this.m_szApplianceIP;
    }

    public String getApplianceName() {
        return this.m_szApplianceName;
    }

    public int getAppliancePort() {
        return this.m_nAppliancePort;
    }

    public int getApplianceChannel() {
        return this.m_nApplianceChannel;
    }

    public final int getApplianceType() {
        return this.m_nApplianceType;
    }

    public void setApplianceType(int n) {
        this.m_nApplianceType = n;
    }

    public boolean areScalingControlsEnabled() {
        return this.m_bEnableScalingControls;
    }

    public void setScalingControlsEnabled(boolean bl) {
        this.m_bEnableScalingControls = bl;
        if (!bl) {
            this.m_sessionInfo.setAutoScale(false);
            this.m_sessionInfo.setFullScale(false);
        }
    }

    public boolean isFullScreenSupportEnabled() {
        return this.m_bEnableFullScreenSupport;
    }

    public void setFullScreenSupportEnabled(boolean bl) {
        this.m_bEnableFullScreenSupport = bl;
    }

    public boolean isVideoAdjustSupportEnabled() {
        return this.m_bEnableVideoAdjustSupport;
    }

    public void setVideoAdjustSupportEnabled(boolean bl) {
        this.m_bEnableVideoAdjustSupport = bl;
    }

    public boolean isConnectedUserSupportEnabled() {
        return this.m_bEnableConnectedUserSupport;
    }

    public void setConnectedUserSupportEnabled(boolean bl) {
        this.m_bEnableConnectedUserSupport = bl;
    }

    public boolean isConnectionShared() {
        return this.m_bSharingConnection;
    }

    public void setConnectionShared(boolean bl) {
        this.m_bSharingConnection = bl;
    }

    public int getConnectionType() {
        return this.m_nConnectionType;
    }

    public void setConnectionType(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSession.setConnectionType nConnectionType=" + n));
        this.m_nConnectionType = n;
        try {
            this.getApplianceWindow().setConnectionType(this.m_nConnectionType);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public boolean isStealthConnection() {
        return this.m_bStealthConnection;
    }

    public void setStealthConnection(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSession.setStealthConnection bStealthConnection=" + bl));
        this.m_bStealthConnection = bl;
    }

    public boolean isPassiveConnection() {
        return this.m_bPassiveConnection;
    }

    public void setPassiveConnection(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSession.setPassiveConnection bPassiveConnection=" + bl));
        this.m_bPassiveConnection = bl;
    }

    public boolean isConnectionSharedAtLaunch() {
        return this.m_bSharedConnectionAtLaunch;
    }

    public void setConnectionSharedAtLaunch(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSession.setConnectionSharedAtLaunch bSharedConnectionAtLaunch=" + bl));
        this.m_bSharedConnectionAtLaunch = bl;
    }

    public boolean isPPPConnection() {
        return this.m_bPPPConnection;
    }

    public void setPPPConnection(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSession.setPPPConnection bPPPConnection=" + bl));
        this.m_bPPPConnection = bl;
    }

    public boolean canUserEditGlobals() {
        if (this.m_sessionStatus == null) {
            return true;
        }
        return (this.m_sessionStatus.getSpecialRights() & 1) != 0;
    }

    public boolean canUserControlPower() {
        if (this.m_sessionStatus == null) {
            return false;
        }
        return (this.m_sessionStatus.getSpecialRights() & 2) != 0;
    }

    public SessionStatus getSessionStatus() {
        return this.m_sessionStatus;
    }

    public void setUserHasRightsToLaunchVirtualMedia(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSession.setUserHasRightsToLaunchVirtualMedia bUserHasRightsToLaunchVirtualMedia=" + bl));
        this.m_bUserHasRightsToLaunchVirtualMedia = bl;
    }

    public boolean doesUserHaveRightsToLaunchVirtualMedia() {
        return this.m_bUserHasRightsToLaunchVirtualMedia;
    }

    public void setVirtualMediaAvailableForTD(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSession.setVirtualMediaAvailableForTD bVirtualMediaAvailableForTD=" + bl));
        this.m_bVirtualMediaAvailableForTD = bl;
    }

    public boolean isVirtualMediaAvailableForTD() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSession.isVirtualMediaAvailableForTD m_bVirtualMediaAvailableForTD=" + this.m_bVirtualMediaAvailableForTD));
        return this.m_bVirtualMediaAvailableForTD;
    }

    public void setEncryptVirtualMedia(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSession.setEncryptVirtualMedia bEncryptVM=" + bl));
        this.m_bEncryptVM = bl;
    }

    public boolean getEncryptVirtualMedia() {
        return this.m_bEncryptVM;
    }

    public void setExclusiveModeAvailable(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSession.setExclusiveModeAvailable bExclusiveModeAvailable=" + bl));
        this.m_bExclusiveModeAvailable = bl;
    }

    public boolean isExclusiveModeAvailable() {
        return this.m_bExclusiveModeAvailable;
    }

    public void setReserveMode(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSession.setReserveMode bReserveMode=" + bl));
        this.m_bReserveMode = bl;
    }

    public boolean isReserveModeActive() {
        return this.m_bReserveMode;
    }

    public void setLockedMode(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSession.setLockedMode bLocked=" + bl));
        this.m_bLockedMode = bl;
    }

    public boolean isLockedMode() {
        return this.m_bLockedMode;
    }

    public int getApplication() {
        return this.m_nApplicationCode;
    }

    public void setApplication(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSession.setApplication nApplicationCode=" + n));
        this.m_nApplicationCode = n;
    }

    public void setLaunchProperties(Properties properties) {
        this.m_propertiesLaunch = properties;
    }

    public Properties getLaunchProperties() {
        return this.m_propertiesLaunch;
    }

    public final int getTotalVideoPacketsReceived() {
        return this.m_nVideoPacketsReceivedTotal;
    }

    public final int getTotalVideoPacketsReceivedSinceLastConfirm() {
        return this.m_nVideoPacketsReceivedSinceLastConfirm;
    }

    public void clearTotalVideoPacketsReceived() {
        this.m_nVideoPacketsReceivedTotal = 0;
        this.m_nVideoPacketsReceivedSinceLastConfirm = 0;
    }

    public void clearTotalVideoPacketsReceivedSinceLastConfirm() {
        this.m_nVideoPacketsReceivedSinceLastConfirm = 0;
    }

    public void incrementTotalVideoPacketsReceived() {
        ++this.m_nVideoPacketsReceivedTotal;
        ++this.m_nVideoPacketsReceivedSinceLastConfirm;
    }

    public ApplianceSessionInfo getPersistentData() {
        return new ApplianceSessionInfo(this.m_sessionInfo);
    }

    public final String getDeviceID() {
        return this.m_szDeviceID;
    }

    public final String getRipID() {
        return this.m_szRipID;
    }

    public final String getLoginTimeOut() {
        return this.m_szLoginTimeOut;
    }

    public final int isApcp() {
        if (this.m_bhasApcp) {
            return 1;
        }
        return 0;
    }

    public final int getApplianceRandomNumber() {
        return this.m_nApplianceRandomNumber;
    }

    public final int getClientRandomNumber() {
        return this.m_nClientRandomNumber;
    }

    public ApplianceSessionInfo getPersistentDataReference() {
        return this.m_sessionInfo;
    }

    public void setPersistentData(ApplianceSessionInfo applianceSessionInfo) {
        this.m_sessionInfo = applianceSessionInfo;
    }

    public void setSingleCursorMouseRelative(boolean bl) {
        this.m_bSingleCursorMouseRelative = bl;
    }

    public boolean isSingleCursorMouseRelative() {
        return this.m_bSingleCursorMouseRelative;
    }

    public final void setNotifyOnClosing(InterfaceNotifyOnClosing interfaceNotifyOnClosing) {
        this.m_vNotifyOnClosing.add(interfaceNotifyOnClosing);
    }

    public final void removeNotifyOnClosing(InterfaceNotifyOnClosing interfaceNotifyOnClosing) {
        this.m_vNotifyOnClosing.remove(interfaceNotifyOnClosing);
    }

    public final void allNotifyOnClosing() {
        if (this.m_vNotifyOnClosing.size() > 0) {
            for (int i = 0; i < this.m_vNotifyOnClosing.size(); ++i) {
                ((InterfaceNotifyOnClosing)this.m_vNotifyOnClosing.get(i)).applianceSessionClosing();
            }
        }
    }

    protected final void removeAllNotifyOnClosing() {
        for (int i = 0; i < this.m_vNotifyOnClosing.size(); ++i) {
            this.m_vNotifyOnClosing.remove(0);
        }
        this.m_vNotifyOnClosing = null;
    }

    public void displayManualVideoAdjustDlg() {
        if (this.m_dlgManualVideoAdjust == null) {
            this.m_dlgManualVideoAdjust = new JDialogManualVideoAdjust((Frame)((Object)this.getApplianceWindow()), this, this.m_szHelpURL);
            this.m_dlgManualVideoAdjust.initDialogManualVideoAdjust();
            this.m_dlgManualVideoAdjust.setVisible(true);
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSession displayVideoAdjustmentsDlg) m_dlgManualVideoAdjust != null, bringing dialog to foreground");
            this.m_dlgManualVideoAdjust.toFront();
        }
    }

    public void closingManualVideoAdjustDlg() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSession closingManualVideoAdjustDlg)");
        this.m_dlgManualVideoAdjust = null;
        this.getApplianceWindow().notifyManualVideoAdjustDialogClosed();
    }

    public boolean isManualVideoAdjustDlgDisplayed() {
        return this.m_dlgManualVideoAdjust != null;
    }

    protected JDialogManualVideoAdjust getManualVideoAdjustDlg() {
        return this.m_dlgManualVideoAdjust;
    }

    public void closeDlgManualVideoAdjust() {
        if (this.m_dlgManualVideoAdjust != null) {
            this.m_dlgManualVideoAdjust.setVisible(false);
            this.m_dlgManualVideoAdjust.dispose();
            this.m_dlgManualVideoAdjust = null;
        }
    }

    private void processFinally() {
        this.m_iFaceViewer = null;
        this.m_szTitle = null;
        this.m_dlgManualVideoAdjust = null;
    }

    protected class DSQueueAvailable
    extends DSQueue {
        protected DSQueueAvailable(int n) {
            super(n);
        }

        protected DSQueueAvailable(DSData[] dSDataArray) {
            super(dSDataArray);
        }

        protected DSData getData() throws IOException {
            DSData dSData = (DSData)super.get();
            dSData.clearHeaderAndCommand();
            return dSData;
        }

        public void putData(DSData dSData) throws IOException {
            super.putData(dSData);
        }

        public String toString() {
            return "DSQueueAvailable";
        }
    }

    protected class DSQueue
    extends Queue {
        protected DSQueue(int n) {
            super(n);
        }

        protected DSQueue(DSData[] dSDataArray) {
            super(dSDataArray);
        }

        protected DSData getData() throws IOException {
            return (DSData)super.get();
        }

        protected void putData(DSData dSData) throws IOException {
            super.put(dSData);
        }

        public String toString() {
            return "DSQueue";
        }
    }
}

