/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.interfaces.InterfaceViewer3;
import com.avocent.lib.interfaces.SessionStatus;
import com.avocent.lib.util.OS;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.ThreadContinuous;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.DSData;
import com.avocent.video.DSKeyListener;
import com.avocent.video.DSPath;
import com.avocent.video.DataInputStreamEndian;
import com.avocent.video.DataOutputStreamEndian;
import com.avocent.video.DvcCommand7;
import com.avocent.video.InterfaceConnectedUsersListener;
import com.avocent.video.InterfaceViewWindow;
import com.avocent.video.JDialogInactivityTimeout;
import com.avocent.video.JFrameViewer;
import com.avocent.video.JPanelAppliance;
import com.avocent.video.KeyStroke;
import com.avocent.video.KeyboardMacro;
import com.avocent.video.Packet;
import com.avocent.video.PacketProtocolAERP;
import com.avocent.video.PacketVideoDVC;
import com.avocent.video.PacketVideoDvcNB;
import com.avocent.video.RC4;
import com.avocent.video.SessionManager;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.SwingUtilities;

class ApplianceSessionAERP
extends ApplianceSession {
    public static final String CNAME = "ApplianceSessionAERP";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    private InterfaceViewWindow m_windowAppliance;
    private ThreadDSDataInput m_dsDataInput;
    private ThreadDSDataInput m_dsDataInputVideo;
    private ThreadDSDataOutput m_dsDataOutput;
    private ApplianceSession.DSQueue m_queueInput;
    private ApplianceSession.DSQueue m_queueInputVideo;
    private ApplianceSession.DSQueue m_queueOutput;
    private ApplianceSession.DSQueueAvailable m_queueAvailable;
    private DSPacketIO m_dsPacketIO;
    private DSPacketIO m_dsPacketIOVideo;
    private DSKeyListener m_dsKeyListener;
    private static final int PORT_NUMBER_EMBEDDED_UDP = 623;
    private static final int MAX_DATAGRAM_LENGTH = 4096;
    private static final int MAX_OOS_ARRAY_ENTRIES = 500;
    private static final int MAX_SEQUENCE_NUMBER = 65536;
    private static final byte STATUS_RESEND_REQUESTED = 1;
    private static final byte STATUS_DATA_AVAILABLE = 2;
    private byte[] m_baPacketStatus = new byte[65536];
    private PacketProtocolAERP[] m_dsOOSArray = new PacketProtocolAERP[500];
    private int m_nResendReqActive = 0;
    private int m_nResendFrameCnt = 0;
    private PacketProtocolAERP m_dsPacket;
    private PacketVideoDVC m_dsPacketVideoDVC7;
    private PacketProtocolAERP m_dsPacketVideoConfirm;
    private DvcCommand7 m_dvcCommand7;
    private DSSendHeartbeat m_sendHeartbeat;
    private static int HEARTBEAT_INTERVAL = 10000;
    private long m_lLastHBPacketSendTime;
    private long m_nLastHBPacketDelayTime;
    private DataOutputStreamEndian m_dosAppliance;
    private DataInputStreamEndian m_disAppliance;
    private DatagramSocket m_udpConnection;
    private boolean m_bRunIOQueue;
    private Object m_syncRunIOQueue = new Object();
    private boolean m_bRunSession;
    private Object m_syncRunSession = new Object();
    private int m_nVideoPacketThreshold = 48;
    private boolean m_bNumLockAppliance = false;
    private boolean m_bCapsLockAppliance = false;
    private boolean m_bScrollLockAppliance = false;
    private boolean m_bInitKBStatusReceived = false;
    private boolean m_bInitKBStatusRequestSent = false;
    private byte[] abyPixelBuffer = new byte[3072];
    private String m_szHelpURL;
    private String m_szIpAddress;
    private int m_nVideoEncodingType = 2;
    private boolean m_bProcessingDVCFrame = false;
    private boolean m_bProcessFinallyRun = false;
    private int m_nColorDepth = 0;
    private int m_nProtocolVersionMajor = 0;
    private int m_nProtocolVersionMinor = 0;
    private long m_lTimeLastSentMouseEvent = 0L;
    private long m_lTimeLastReceivedMouseEvent = 0L;
    private int m_nXLastReceivedMouseEvent = 0;
    private int m_nYLastReceivedMouseEvent = 0;
    private int m_nXLastSentMouseEvent = 0;
    private int m_nYLastSentMouseEvent = 0;
    private Thread m_threadMousePacing = null;
    private int m_nMouseThrottleTime = 20;
    boolean m_bButtonLeftDown = false;
    boolean m_bButtonMiddleDown = false;
    boolean m_bButtonRightDown = false;
    private boolean m_bActivityOccurred = false;
    private ThreadInactivityTimeout m_threadInactivityTimeout = null;
    private boolean m_bDisplayUserNoticeOnNetworkError = true;
    private Vector m_vConnectedUsersListeners = new Vector();
    private int m_nAvgPacketCnt = 0;
    private int m_nPacketAckDelay = 0;
    private boolean m_bIsV2Appliance = false;
    private boolean m_bPPPConnection = false;
    private boolean m_bUseUdpForVideo = false;
    private boolean m_bUseUdpForControl = false;
    private boolean m_bEncryptVideo = false;
    private static int CAPABILITIES_REQ_TIMEOUT = 2000;
    private long m_lReqCapabilitiesTime;
    private int m_nCapabilitiesRetryCount = 0;
    private boolean m_bCapabilitiesRcvd = false;
    private boolean m_bEncryptionRC4Support = false;
    private boolean m_bVersion2MsgSupport = false;
    private boolean m_bVideoHandshakeSupport = false;
    private boolean m_bShortVideoPacketSupport = false;
    private int m_nMaxReceiveSize = 0;
    private RC4 m_rc4;
    private String m_rc4Key = "everygoodboydoesfine";
    private static int MSG_ACK_INTERVAL = 500;
    private static int MAX_NUM_RETRIES = 5;
    private int m_nLastSeqNumSent = -1;
    private int m_nLastRecvSeqNum = 0;
    private boolean m_bMsgSentAckPending = false;
    private int m_nRecvSeqNumAckPending = -1;
    private static int MAX_NO_VIDEO_INTERVAL = 1000;
    private static int MAX_NO_VIDEO_INTERVAL_PPP = 10000;
    private static boolean m_bStartVideoSent = false;
    private static boolean m_bFirstRefreshRcvd = false;
    private boolean m_bIsStartOfFrame = false;
    private boolean m_bIsEndOfFrame = false;
    private int m_nVideoDataOffset = 16;
    private int m_nCurrentVideoFrame = -1;
    private int m_nLastVideoFrameAck = -1;
    private int m_nCurrentVideoSequence = 0;
    private long m_lLastVideoFrameRecvTime = 0L;
    private int m_nMaximumVideoNoResponse = 0;
    private static int MAX_RESEND_REQUESTS = 10;
    private boolean m_bVideoPaused = false;

    public ApplianceSessionAERP(InterfaceViewer3 interfaceViewer3, SessionStatus sessionStatus, DSPath dSPath, String string, String string2, int n, DataInputStreamEndian dataInputStreamEndian, DataOutputStreamEndian dataOutputStreamEndian, DatagramSocket datagramSocket, String string3, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2) {
        super(CNAME, interfaceViewer3, sessionStatus, dSPath, string, n, n2, string3);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP constructor with own window) strApplianceIP: " + dSPath.getIPAddress()));
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP constructor Parameters: Title=" + string + " Appliance Name=" + string2 + " Type=" + n + " isPPP=" + bl + " helpURL=" + string3 + " UDP for Control=" + bl2 + " UDP for Video=" + bl3 + " Video Encrypted=" + bl4));
        this.clearTotalVideoPacketsReceived();
        this.m_nVideoPacketThreshold = 48;
        this.m_dsPath = dSPath;
        this.m_disAppliance = dataInputStreamEndian;
        this.m_dosAppliance = dataOutputStreamEndian;
        this.m_udpConnection = datagramSocket;
        this.m_szIpAddress = dSPath.getIPAddress();
        this.m_szHelpURL = string3;
        if (this.m_szHelpURL != null && this.m_szHelpURL.length() == 0) {
            this.m_szHelpURL = null;
        }
        this.setConnectionSharedAtLaunch(false);
        this.setScalingControlsEnabled(false);
        this.setStealthConnection(false);
        this.setSingleCursorMouseRelative(false);
        this.setFullScreenSupportEnabled(false);
        this.setVideoAdjustSupportEnabled(false);
        this.setConnectedUserSupportEnabled(false);
        this.setPPPConnection(bl);
        this.m_bPPPConnection = bl;
        this.m_bUseUdpForVideo = bl3;
        this.m_bUseUdpForControl = bl2;
        this.m_bEncryptVideo = bl4;
        this.m_nMaximumVideoNoResponse = bl ? MAX_NO_VIDEO_INTERVAL_PPP : MAX_NO_VIDEO_INTERVAL;
        if (n == 3) {
            this.m_bIsV2Appliance = false;
            this.m_bCapabilitiesRcvd = true;
        } else {
            this.m_bIsV2Appliance = true;
        }
        try {
            this.initQueues();
            this.m_windowAppliance = new JFrameViewer(this, this.m_szHelpURL, true);
            this.initVideoDecodePackets();
            this.m_windowAppliance.initToolbar(this);
            this.m_windowAppliance.getPanelAppliance().setPPPConnection(this.isPPPConnection());
            this.m_dsKeyListener = new DSKeyListener(this);
            this.m_windowAppliance.getPanelAppliance().addKeyListener(this.m_dsKeyListener);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP constructor) adding key listener:" + this.m_dsKeyListener));
            this.m_windowAppliance.getPanelAppliance().addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    ApplianceSessionAERP.this.m_windowAppliance.getPanelAppliance().requestFocusInWindow();
                }
            });
            this.start();
        }
        catch (IOException iOException) {
            Message.show(null, (String)RES.getString("ApplianceSessionAERP_appliance_session_cant_start"));
        }
        catch (NullPointerException nullPointerException) {
            Message.show(null, (String)RES.getString("ApplianceSessionAERP_appliance_session_cant_start"));
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public ApplianceSessionAERP(InterfaceViewWindow interfaceViewWindow, int n, int n2, int n3, InterfaceViewer3 interfaceViewer3, SessionStatus sessionStatus, DSPath dSPath, int n4, DataInputStreamEndian dataInputStreamEndian, DataOutputStreamEndian dataOutputStreamEndian, DatagramSocket datagramSocket, String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n5) {
        super(CNAME, interfaceViewer3, sessionStatus, dSPath, "", n4, n5, string);
        this.m_szIpAddress = dSPath.getIPAddress();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP constructor) : " + this.m_szIpAddress));
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP constructor Parameters:  Appliance Name=" + dSPath.getServerName() + " Type=" + n4 + " IPAddress=" + dSPath.getIPAddress() + " isPPP=" + bl + " UDP for Control=" + bl2 + " UDP for Video=" + bl3 + " Video Encrypted=" + bl4));
        this.clearTotalVideoPacketsReceived();
        this.m_nVideoPacketThreshold = 48;
        this.m_dsPath = dSPath;
        this.m_disAppliance = dataInputStreamEndian;
        this.m_dosAppliance = dataOutputStreamEndian;
        this.m_udpConnection = datagramSocket;
        if (n4 == 3) {
            this.m_bIsV2Appliance = false;
            this.m_bCapabilitiesRcvd = true;
        } else {
            this.m_bIsV2Appliance = true;
        }
        this.m_bPPPConnection = bl;
        this.m_bUseUdpForVideo = bl3;
        this.m_bUseUdpForControl = bl2;
        this.m_bEncryptVideo = bl4;
        this.m_nMaximumVideoNoResponse = bl ? MAX_NO_VIDEO_INTERVAL_PPP : MAX_NO_VIDEO_INTERVAL;
        this.setSingleCursorMouseRelative(false);
        this.setFullScreenSupportEnabled(false);
        this.setVideoAdjustSupportEnabled(false);
        this.setConnectedUserSupportEnabled(false);
        this.setApplianceWindow(interfaceViewWindow);
        this.m_windowAppliance.getPanelAppliance().setPPPConnection(bl);
        if (this.m_windowAppliance.getPanelAppliance().getApplianceSession() == null) {
            this.m_windowAppliance.getPanelAppliance().setApplianceSession(this);
        }
        this.getPersistentDataReference().setPanedWidth((short)n, true);
        this.getPersistentDataReference().setPanedHeight((short)n2, true);
        this.getPersistentDataReference().setDecimationFactor(n3, true);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("( ApplianceSessionAERP constructor) m_sessionInfo m_fPaneScaled:" + this.getPersistentDataReference().isPaneScaled() + " m_sPanedWidth:" + this.getPersistentDataReference().getPanedWidth() + " m_sPanedHeight:" + this.getPersistentDataReference().getPanedHeight()));
        try {
            this.initQueues();
            this.start();
        }
        catch (IOException iOException) {
            Message.show(null, (String)RES.getString("ApplianceSessionAERP_appliance_session_cant_start"));
        }
    }

    public void setPersistentData(ApplianceSessionInfo applianceSessionInfo) {
        JPanelAppliance jPanelAppliance;
        if (applianceSessionInfo != null) {
            super.setPersistentData(applianceSessionInfo);
            try {
                this.getPersistentDataReference().setAll();
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
            }
        }
        switch (this.getPersistentDataReference().getThrottleType()) {
            case 0: 
            case 4: {
                this.m_nVideoPacketThreshold = 48;
                break;
            }
            case 1: {
                this.m_nVideoPacketThreshold = 24;
                break;
            }
            case 2: {
                this.m_nVideoPacketThreshold = 7;
                break;
            }
            case 3: {
                this.m_nVideoPacketThreshold = 4;
            }
        }
        if (this.m_windowAppliance != null && (jPanelAppliance = this.m_windowAppliance.getPanelAppliance()) != null) {
            jPanelAppliance.setSessionInfo(this.getPersistentDataReference());
        }
    }

    public void setPersistentMacroData(ApplianceSessionInfo applianceSessionInfo) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP setPersistentMacroData)");
        this.setPersistentData(applianceSessionInfo);
    }

    public void setGlobalMacroData(ApplianceSessionInfo applianceSessionInfo) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP setGlobalMacroData)");
        JPanelAppliance jPanelAppliance = this.m_windowAppliance.getPanelAppliance();
        if (jPanelAppliance != null) {
            jPanelAppliance.setSessionInfo(this.getPersistentDataReference());
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAVSP setGlobalMacroData)");
    }

    public void setApplianceWindow(InterfaceViewWindow interfaceViewWindow) {
        this.m_windowAppliance = interfaceViewWindow;
    }

    public InterfaceViewWindow getApplianceWindow() {
        return this.m_windowAppliance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.setRunSession(true);
            this.setRunIOQueue(true);
            if (!this.m_bUseUdpForVideo && !this.m_bUseUdpForControl) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP run) Single TCP Connection");
                this.m_dsPacketIO = new DSPacketIO(this.m_disAppliance, this.m_dosAppliance, this.m_queueAvailable);
            } else if (this.m_bUseUdpForControl) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP run) Single UDP Connection");
                this.m_dsPacketIO = new DSPacketIO(this.m_udpConnection, this.m_queueAvailable, this.m_szIpAddress);
            } else {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP run) TCP Control Connection, UDP Video Connection");
                this.m_dsPacketIO = new DSPacketIO(this.m_disAppliance, this.m_dosAppliance, this.m_queueAvailable);
                this.m_dsPacketIOVideo = new DSPacketIO(this.m_udpConnection, this.m_queueAvailable, this.m_szIpAddress);
            }
            this.m_dsDataInput = new ThreadDSDataInput(this.m_queueInput, this.m_dsPacketIO);
            this.m_dsDataOutput = new ThreadDSDataOutput(this.m_queueOutput, this.m_dsPacketIO);
            if (!this.m_bUseUdpForControl && this.m_bUseUdpForVideo) {
                this.m_dsDataInputVideo = new ThreadDSDataInput(this.m_queueInputVideo, this.m_dsPacketIOVideo);
                new ThreadVideoProcess(this.m_queueInputVideo, this.m_queueAvailable, this.m_bIsV2Appliance);
            }
            if (!this.m_bIsV2Appliance) {
                this.cmdKBStatusRequest();
            } else if (!this.cmdExchangeCapabilities()) {
                this.cmdKBStatusRequest();
            }
            this.m_sendHeartbeat = new DSSendHeartbeat();
            this.m_lLastHBPacketSendTime = System.currentTimeMillis();
            while (this.isSessionRunning()) {
                if (!this.m_bCapabilitiesRcvd && System.currentTimeMillis() - this.m_lReqCapabilitiesTime > (long)CAPABILITIES_REQ_TIMEOUT) {
                    if (this.m_nCapabilitiesRetryCount == 3) {
                        this.m_bIsV2Appliance = false;
                        this.m_bCapabilitiesRcvd = true;
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP run)No capabilities response from V2 appliance - assume V1 ");
                        this.cmdKBStatusRequest();
                    } else {
                        this.cmdExchangeCapabilities();
                    }
                }
                block19: while (this.m_queueInput.hasData()) {
                    this.m_dsPacket.setData((DSData)this.m_queueInput.get());
                    try {
                        byte by = this.m_dsPacket.getPacketType();
                        if (!this.m_bIsV2Appliance || this.checkSequenceNumber(this.m_dsPacket, by)) {
                            switch (by) {
                                case 2: {
                                    this.setVideoResolution(this.m_dsPacket, (short)1024, (short)768);
                                    this.processCmdVideoDVC7(this.m_dsPacket);
                                    if (this.getResendReqActive() > 0) {
                                        this.processStoredData();
                                    }
                                    this.m_queueAvailable.putData(this.m_dsPacket.getData());
                                    continue block19;
                                }
                                case 3: {
                                    this.setVideoResolution(this.m_dsPacket, (short)800, (short)600);
                                    this.processCmdVideoDVC7(this.m_dsPacket);
                                    if (this.getResendReqActive() > 0) {
                                        this.processStoredData();
                                    }
                                    this.m_queueAvailable.putData(this.m_dsPacket.getData());
                                    continue block19;
                                }
                                case 4: {
                                    this.setVideoResolution(this.m_dsPacket, (short)640, (short)480);
                                    this.processCmdVideoDVC7(this.m_dsPacket);
                                    if (this.getResendReqActive() > 0) {
                                        this.processStoredData();
                                    }
                                    this.m_queueAvailable.putData(this.m_dsPacket.getData());
                                    continue block19;
                                }
                                case 9: {
                                    this.processCmdKBStatus(this.m_dsPacket);
                                    continue block19;
                                }
                                case 6: {
                                    this.processVideoLostSync(this.m_dsPacket);
                                    continue block19;
                                }
                                case 13: {
                                    this.processVersionResp(this.m_dsPacket);
                                    continue block19;
                                }
                                case 12: {
                                    this.processHBResponse(this.m_dsPacket);
                                    continue block19;
                                }
                                case 33: {
                                    this.processCapabilitiesResponse(this.m_dsPacket);
                                    continue block19;
                                }
                                case 37: {
                                    this.checkMsgAcknowledge(this.m_dsPacket);
                                    this.m_queueAvailable.putData(this.m_dsPacket.getData());
                                    continue block19;
                                }
                            }
                            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP run)Unknown packet type: " + by + " packet header len:" + this.m_dsPacket.getHeaderLength() + " packet len:" + this.m_dsPacket.getPacketLength() + " space available in m_queueAvailable=" + this.m_queueAvailable.getAvailableSpace()));
                            String string = "First 16 bytes of packet=";
                            for (int i = 0; i < 16; ++i) {
                                if (i % 4 == 0) {
                                    string = string + "  ";
                                }
                                string = string + Integer.toHexString(this.m_dsPacket.getData(i) & 0xFF) + " ";
                            }
                            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP run) " + string));
                            this.m_queueAvailable.putData(this.m_dsPacket.getData());
                            this.m_dsPacket.clearDataObject();
                            continue;
                        }
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP run)packet not valid: Type= " + by + " packet header len:" + this.m_dsPacket.getHeaderLength() + " packet len:" + this.m_dsPacket.getPacketLength() + " space available in m_queueAvailable=" + this.m_queueAvailable.getAvailableSpace()));
                        this.m_queueAvailable.putData(this.m_dsPacket.getData());
                        this.m_dsPacket.clearDataObject();
                    }
                    catch (NullPointerException nullPointerException) {
                        Trace.logError((String)TRACE_CONTEXT, (String)nullPointerException.getMessage(), (Throwable)nullPointerException);
                        this.m_queueAvailable.putData(this.m_dsPacket.getData());
                    }
                }
                this.m_queueInput.waitForData();
            }
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP run)IOException: " + iOException.getMessage()), (Throwable)iOException);
        }
        finally {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP calling processFinally for KM queue");
            this.processFinally();
        }
    }

    public void initPixelArray(int n, int n2) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP initPixelArray) nWidth=" + n));
        this.m_dsPacketVideoDVC7.initPixelArray(n, n2);
    }

    public int getDvcCurrentPixel() {
        return this.m_dsPacketVideoDVC7.getDvcCurrentPixel();
    }

    public void setDvcCurrentPixel(int n) {
        this.m_dsPacketVideoDVC7.setDvcCurrentPixel(n);
    }

    public int getVideoEncodingType() {
        return this.m_nVideoEncodingType;
    }

    public int getColorDepth() {
        return this.m_nColorDepth;
    }

    public float getProtocolVersion() {
        float f = (float)this.m_nProtocolVersionMajor + (float)this.m_nProtocolVersionMinor / 10.0f;
        return f;
    }

    public String getProtocolType() {
        return "AERP";
    }

    public void registerConnectedUsersListener(InterfaceConnectedUsersListener interfaceConnectedUsersListener) {
        this.m_vConnectedUsersListeners.add(interfaceConnectedUsersListener);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP registerConnectedUsersListener) IN Size=" + this.m_vConnectedUsersListeners.size()));
    }

    public void unregisterConnectedUsersListener(InterfaceConnectedUsersListener interfaceConnectedUsersListener) {
        this.m_vConnectedUsersListeners.remove(interfaceConnectedUsersListener);
    }

    public void flushInputQueue() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP flushInputQueue m_bProcessingDVCFrame=)" + this.m_bProcessingDVCFrame + " input queue=" + this.m_queueInput.getUsedElements() + " input Video queue=" + this.m_queueInputVideo.getUsedElements()));
        int n = 10;
        while (this.m_bProcessingDVCFrame && n-- > 0) {
            try {
                ApplianceSessionAERP.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            ApplianceSessionAERP.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean bl = false;
        while (!bl) {
            if (!this.m_bUseUdpForVideo) {
                while (this.m_queueInput.hasData()) {
                    try {
                        this.m_queueAvailable.putData((DSData)this.m_queueInput.get());
                    }
                    catch (IOException iOException) {}
                }
            } else {
                while (this.m_queueInputVideo.hasData()) {
                    try {
                        this.m_queueAvailable.putData((DSData)this.m_queueInputVideo.get());
                    }
                    catch (IOException iOException) {}
                }
            }
            try {
                ApplianceSessionAERP.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.m_bUseUdpForVideo) {
                bl = !this.m_queueInput.hasData();
                continue;
            }
            bl = !this.m_queueInputVideo.hasData();
        }
    }

    public void cmdKBStatusRequest() throws IOException {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdKBStatusRequest) Exiting isRunIOQueueSet FALSE");
            return;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdKBStatusRequest) Initial Status Rcvd=" + this.isInitialKBMouseStatusReceived()));
        if (!this.m_bInitKBStatusRequestSent) {
            this.m_bInitKBStatusRequestSent = true;
            this.cmdMessage((byte)9);
        }
    }

    public void cmdMouseMoved(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, int n2, char c) throws IOException {
        this.m_bActivityOccurred = true;
        this.cmdMouse(bl, bl2, bl3, bl4, bl5, bl6, bl7, n, n2, c);
    }

    public void cmdMouseAlign() throws IOException {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdMouseAlign) Exiting isRunIOQueueSet FALSE");
            return;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdMouseAlign)");
        DSData dSData = this.m_queueAvailable.getData();
        PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
        packetProtocolAERP.setCmdMouseData(dSData, (short)0, (short)0, (short)0);
        this.m_queueOutput.putData(packetProtocolAERP.getData());
        this.cmdRefreshPane();
    }

    public void cmdFocusControl(boolean bl) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdFocusControl) - bFocusOn=" + bl));
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdFocusControl) Exiting isRunIOQueueSet FALSE");
            return;
        }
        DSData dSData = this.m_queueAvailable.getData();
        PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
        packetProtocolAERP.setCmdMouseFocus(dSData, bl, this.m_nXLastSentMouseEvent, this.m_nYLastSentMouseEvent);
        this.m_queueOutput.putData(packetProtocolAERP.getData());
    }

    public void cmdPS2Reset() throws IOException {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdPS2Reset) Exiting isRunIOQueueSet FALSE");
            return;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdPS2Reset)");
        DSData dSData = this.m_queueAvailable.getData();
        PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
        packetProtocolAERP.setCommand(dSData, (short)14, 6);
        this.m_queueOutput.putData(packetProtocolAERP.getData());
    }

    public void cmdKeyPressed(int n) {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdKeyPressed) Exiting isRunIOQueueSet FALSE");
            return;
        }
        this.m_bActivityOccurred = true;
        try {
            DSData dSData = this.m_queueAvailable.getData();
            PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
            int n2 = this.getKeyLocation(n);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdKeyPressed) nKeyCode: " + n + " nKeyLocation=" + n2));
            packetProtocolAERP.setKeyboardPressedCommand(dSData, n, n2);
            this.m_queueOutput.putData(packetProtocolAERP.getData());
            try {
                ApplianceSessionAERP.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)("(JPanelAppliance keyPressed) IOException: " + iOException.getMessage()), (Throwable)iOException);
        }
    }

    public void cmdKeyPressed(int n, boolean bl) {
    }

    public void cmdKeyPressed(int n, char c, int n2) {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdKeyPressed) Exiting isRunIOQueueSet FALSE");
            return;
        }
        this.m_bActivityOccurred = true;
        int n3 = 1;
        switch (n2) {
            case 2: {
                n3 = 2;
                break;
            }
            case 4: 
            case 108: {
                n3 = 4;
                break;
            }
            case 3: {
                n3 = 3;
                break;
            }
            default: {
                n3 = 1;
            }
        }
        try {
            DSData dSData = this.m_queueAvailable.getData();
            PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
            packetProtocolAERP.setKeyboardPressedCommand(dSData, n, n3);
            this.m_queueOutput.putData(packetProtocolAERP.getData());
            try {
                ApplianceSessionAERP.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)("(JPanelAppliance keyPressed) IOException: " + iOException.getMessage()), (Throwable)iOException);
        }
    }

    public void cmdKeyReleased(int n) {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdKeyReleased) Exiting isRunIOQueueSet FALSE");
            return;
        }
        this.m_bActivityOccurred = true;
        try {
            DSData dSData = this.m_queueAvailable.getData();
            PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
            int n2 = this.getKeyLocation(n);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdKeyReleased) nKeyCode: " + n + " nKeyLocation=" + n2));
            packetProtocolAERP.setKeyboardReleasedCommand(dSData, n, n2);
            this.m_queueOutput.putData(packetProtocolAERP.getData());
            try {
                ApplianceSessionAERP.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)("(JPanelAppliance cmdKeyReleased) IOException: " + iOException.getMessage()), (Throwable)iOException);
        }
    }

    public void cmdKeyReleased(int n, boolean bl) {
    }

    public void cmdKeyReleased(int n, char c, int n2) {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdKeyReleased) Exiting isRunIOQueueSet FALSE");
            return;
        }
        this.m_bActivityOccurred = true;
        int n3 = 1;
        switch (n2) {
            case 2: {
                n3 = 2;
                break;
            }
            case 4: 
            case 108: {
                n3 = 4;
                break;
            }
            case 3: {
                n3 = 3;
                break;
            }
            default: {
                n3 = 1;
            }
        }
        try {
            DSData dSData = this.m_queueAvailable.getData();
            PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
            packetProtocolAERP.setKeyboardReleasedCommand(dSData, n, n3);
            this.m_queueOutput.putData(packetProtocolAERP.getData());
            try {
                ApplianceSessionAERP.sleep(20L);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)("(JPanelAppliance keyPressed) IOException: " + iOException.getMessage()), (Throwable)iOException);
        }
    }

    public void cmdSendKeystrokes(KeyStroke[] keyStrokeArray) {
        this.m_bActivityOccurred = true;
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            if (keyStrokeArray[i].getStrokeType() == 0 || keyStrokeArray[i].getStrokeType() == 2) {
                this.cmdKeyPressed(this.translateKeyUSBToJavaKeyCode(keyStrokeArray[i].getUsbCode()));
            }
            if (keyStrokeArray[i].getStrokeType() != 1 && keyStrokeArray[i].getStrokeType() != 2) continue;
            this.cmdKeyReleased(this.translateKeyUSBToJavaKeyCode(keyStrokeArray[i].getUsbCode()));
        }
    }

    public void cmdSendMacroKeystrokes(KeyboardMacro keyboardMacro) {
        this.cmdSendKeystrokes(keyboardMacro.getKeyStrokes());
    }

    public void cmdNumLockSet(boolean bl) {
        if (bl != this.m_bNumLockAppliance) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdNumLockSet) appliance state: " + this.m_bNumLockAppliance + " does not match keyboard state:" + bl + " Sending VK_NUM_LOCK"));
            this.cmdKeyPressed(144);
            this.cmdKeyReleased(144);
            this.m_bNumLockAppliance = bl;
        }
    }

    public void cmdScrollLockSet(boolean bl) {
        if (bl != this.m_bScrollLockAppliance) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdScrollLockSet) appliance state: " + this.m_bScrollLockAppliance + " does not match keyboard state:" + bl + " Sending VK_SCROLL_LOCK"));
            this.cmdKeyPressed(145);
            this.cmdKeyReleased(145);
            this.m_bScrollLockAppliance = bl;
        }
    }

    public void cmdCapsLockSet(boolean bl) {
        if (bl != this.m_bCapsLockAppliance) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdCapsLockSet) appliance state: " + this.m_bCapsLockAppliance + " does not match keyboard state:" + bl + " Sending VK_CAPS_LOCK"));
            this.cmdKeyPressed(20);
            this.cmdKeyReleased(20);
            this.m_bCapsLockAppliance = bl;
        }
    }

    public void cmdStartVideo() throws IOException {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdStartVideo) Exiting isRunIOQueueSet FALSE");
            return;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdStartVideo)");
        if (this.m_bVideoPaused) {
            this.cmdMessage((byte)8);
        } else if (this.m_bPPPConnection) {
            this.cmdMessage((byte)1);
        } else {
            this.cmdMessage((byte)0);
        }
    }

    public void cmdStopVideo() throws IOException {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdStopVideo) Exiting isRunIOQueueSet FALSE");
            return;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdStopVideo)");
        this.cmdMessage((byte)7);
        this.m_bVideoPaused = true;
    }

    public void cmdRefreshPane() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdRefreshPane)");
        if (!m_bStartVideoSent) {
            this.cmdStartVideoData();
            return;
        }
        if (!m_bFirstRefreshRcvd) {
            m_bFirstRefreshRcvd = true;
            return;
        }
        this.cmdStopVideo();
        this.cmdSendVideoNAK();
        this.m_nCurrentVideoFrame = -1;
        this.m_nLastVideoFrameAck = -1;
        this.m_nCurrentVideoSequence = 0;
        this.m_bProcessingDVCFrame = false;
        for (int i = 0; i < 65536; ++i) {
            this.m_baPacketStatus[i] = 0;
        }
        this.setResendReqActive(false);
        this.cmdStartVideo();
    }

    public void cmdThrottleVideo(int n) throws IOException {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdThrottleVideo) Exiting isRunIOQueueSet FALSE");
            return;
        }
        int n2 = 5000000;
        switch (n) {
            case 0: 
            case 4: {
                n2 = 5000000;
                break;
            }
            case 1: {
                n2 = 1544000;
                break;
            }
            case 2: {
                n2 = 512000;
                break;
            }
            case 3: {
                n2 = 256000;
                break;
            }
            case 5: {
                n2 = 5000;
                break;
            }
            default: {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("Unexpected video throttle (" + n + ") replaced with default value."));
                n2 = 5000000;
            }
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdThrottleVideo) nThrottleValue:" + n + " bps= " + n2));
        DSData dSData = this.m_queueAvailable.getData();
        PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
        packetProtocolAERP.setCommand(dSData, (short)10, n2);
        this.m_queueOutput.putData(packetProtocolAERP.getData());
    }

    public void enableInactivityTimeout(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSessionAERP.enableInactivityTimeout nMinutes=" + n));
        this.m_bActivityOccurred = false;
        this.m_threadInactivityTimeout = new ThreadInactivityTimeout(n);
        this.m_threadInactivityTimeout.start();
    }

    public void setMouseThrottle(int n) {
        this.m_nMouseThrottleTime = n;
    }

    public void terminateSession() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP terminateSession)");
        if (this.m_threadInactivityTimeout != null) {
            this.m_threadInactivityTimeout.stopThread();
            this.m_threadInactivityTimeout = null;
        }
        this.m_bDisplayUserNoticeOnNetworkError = false;
        this.setRunSession(false);
    }

    public void close() {
        try {
            this.m_dosAppliance.close();
            this.m_disAppliance.close();
            this.m_dosAppliance = null;
            this.m_disAppliance = null;
            if (this.m_bUseUdpForVideo) {
                this.m_udpConnection.close();
            }
            this.m_udpConnection = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public RC4 getRc4() {
        return this.m_rc4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSessionRunning() {
        Object object = this.m_syncRunSession;
        synchronized (object) {
            return this.m_bRunSession;
        }
    }

    public synchronized boolean isInitialKBMouseStatusReceived() {
        return this.m_bInitKBStatusReceived;
    }

    public void cmdVideoGetColorDepth() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdVideoGetColorDepth IGNORED)");
    }

    public void cmdVideoSetColorDepth(int n, boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdVideoSetColorDepth IGNORED)");
    }

    public void cmdVideoPriorityThreshold(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdVideoPriorityThreshold IGNORED)");
    }

    public void cmdVideoNoiseThreshold(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdVideoNoiseThreshold) IGNORED nThreshold:" + n));
    }

    public void cmdVideoBrightness(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdVideoBrightness) IGNORED nBrightness:" + n));
    }

    public void cmdVideoContrast(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdVideoContrast) IGNORED nContrast:" + n));
    }

    public void cmdVideoVertCapture(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdVideoVertCapture) IGNORED nCapture:" + n));
    }

    public void cmdVideoHorzCapture(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdVideoHorzCapture) IGNORED nCapture:" + n));
    }

    public void cmdVideoFine(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdVideoFine) IGNORED nFine:" + n));
    }

    public void cmdVideoWidth(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdVideoWidth) IGNORED nWidth:" + n));
    }

    public void cmdRejectPreemptionRequest() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdRejectPreemptionRequest IGNORED)");
    }

    public void closingPreemptWarningDlg() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP closingPreemptWarningDlg IGNORED)");
    }

    public void cmdVideoTestPattern(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdVideoTestPattern) IGNORED bPatternOn:" + bl));
    }

    public void cmdKanaLockSet(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdKanaLockSet) IGNORED bLock:" + bl));
    }

    public void setAVCPixels(int n, int n2, int n3, int n4, byte[] byArray) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP setAVCPixels) IGNORED ");
    }

    public void cmdVideoSetup() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdVideoSetup ) IGNORED");
    }

    public void cmdGetConnectedUsers() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdGetConnectedUsers) IGNORED");
    }

    public void cmdExclusiveMode(boolean bl) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdExclusiveMode) IGNORED");
    }

    public void cmdMouseMovedRelative(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, int n2, char c) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdMouseMovedRelative) IGNORED");
    }

    public void cmdMouseReenable(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdMouseReenable) IGNORED");
    }

    public void cmdScanCodeKeyPressed(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdScanCodeKeyPressed)  IGNORED ScanCodeKey" + n));
    }

    public void cmdScanKeyReleased(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP cmdScanKeyReleased)  IGNORED ScanCodeKey" + n));
    }

    public void cmdFullScale() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdFullScale) IGNORED");
    }

    public void cmdAutoAdjustVideo() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdAutoAdjustVideo) IGNORED");
    }

    public boolean canUserEditGlobals() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP canUserEditGlobals) IGNORED");
        return false;
    }

    public void setPowerOff() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP setPowerOff) IGNORED");
    }

    public void setPowerOn() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP setPowerOn) IGNORED");
    }

    public void setPowerCycle() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP setPowerCycle) IGNORED");
    }

    public int getPowerState() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP getPowerState) IGNORED");
        return 0;
    }

    public void cmdMouseAcceleration(int n) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdMouseAcceleration) IGNORED");
    }

    public boolean canUserControlPower() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP canUserControlPower) Invalid for AERP");
        return false;
    }

    public boolean useJavaKeyCodes() {
        return true;
    }

    public void videoConfigChanged(JPanelAppliance jPanelAppliance) {
        this.m_dsPacketVideoDVC7.videoConfigChanged(jPanelAppliance);
    }

    private void initQueues() throws IOException {
        int n;
        this.m_queueInput = (ApplianceSession)this.new ApplianceSession.DSQueue(200);
        this.m_queueInputVideo = (ApplianceSession)this.new ApplianceSession.DSQueue(200);
        this.m_queueOutput = (ApplianceSession)this.new ApplianceSession.DSQueue(20);
        this.m_queueAvailable = (ApplianceSession)this.new ApplianceSession.DSQueueAvailable(this.m_queueInput.getSize() + this.m_queueOutput.getSize() + 10);
        for (n = 0; n < this.m_queueAvailable.getSize(); ++n) {
            this.m_queueAvailable.putData(new DSData(8, 0));
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP initQueues) QueueAvailable size=" + this.m_queueAvailable.getUsedElements() + " Input Queue size=" + this.m_queueInput.getAvailableSpace() + " Output Queue size=" + this.m_queueOutput.getAvailableSpace() + " ThrottleType: " + this.getPersistentDataReference().getThrottleType()));
        if (this.m_bUseUdpForVideo) {
            for (n = 0; n < 65536; ++n) {
                this.m_baPacketStatus[n] = 0;
            }
            this.setResendReqActive(false);
            for (n = 0; n < 500; ++n) {
                DSData dSData = new DSData(8, 0);
                this.m_dsOOSArray[n] = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
            }
        }
        this.m_dsPacket = new PacketProtocolAERP(this.m_bIsV2Appliance);
        this.m_dsPacketVideoDVC7 = OS.isLinux() ? new PacketVideoDvcNB(8, 8, 0, 4) : new PacketVideoDVC(8, 8, 0, 4);
        this.m_dsPacketVideoConfirm = new PacketProtocolAERP(this.m_bIsV2Appliance);
        this.m_dvcCommand7 = new DvcCommand7();
    }

    private void cmdStartVideoData() throws IOException {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdStartVideoData) Exiting isRunIOQueueSet FALSE");
            return;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdStartVideoData)");
        m_bStartVideoSent = true;
        if (this.m_bPPPConnection) {
            this.cmdMessage((byte)1);
        } else {
            this.cmdMessage((byte)0);
        }
    }

    private void cmdMouse(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, int n2, int n3) throws IOException {
        PacketProtocolAERP packetProtocolAERP;
        DSData dSData;
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdMouse) Exiting isRunIOQueueSet FALSE");
            return;
        }
        int n4 = n;
        int n5 = n2;
        if (bl != this.m_bButtonLeftDown || bl2 != this.m_bButtonMiddleDown || bl3 != this.m_bButtonRightDown) {
            dSData = this.m_queueAvailable.getData();
            packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
            packetProtocolAERP.setCmdMouseData(dSData, bl, bl2, bl3, this.m_bButtonLeftDown, this.m_bButtonMiddleDown, this.m_bButtonRightDown);
            this.m_queueOutput.putData(packetProtocolAERP.getData());
            this.m_bButtonLeftDown = bl;
            this.m_bButtonMiddleDown = bl2;
            this.m_bButtonRightDown = bl3;
        }
        if (this.getPersistentDataReference().isPaneScaled()) {
            n4 = this.getPersistentDataReference().getVideoWidth() * n / this.getPersistentDataReference().getPanedWidth();
            n5 = this.getPersistentDataReference().getVideoHeight() * n2 / this.getPersistentDataReference().getPanedHeight();
        }
        if (this.m_nMouseThrottleTime > 0) {
            long l = System.currentTimeMillis();
            if (!(l - this.m_lTimeLastSentMouseEvent >= (long)this.m_nMouseThrottleTime || bl || bl2 || bl3 || bl4 || bl5 || bl6 || bl7 || n3 != 0)) {
                this.m_lTimeLastReceivedMouseEvent = l;
                this.m_nXLastReceivedMouseEvent = n4;
                this.m_nYLastReceivedMouseEvent = n5;
                if (this.m_threadMousePacing == null) {
                    this.m_threadMousePacing = new Thread(new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(ApplianceSessionAERP.this.m_nMouseThrottleTime);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (ApplianceSessionAERP.this.m_nXLastReceivedMouseEvent != ApplianceSessionAERP.this.m_nXLastSentMouseEvent || ApplianceSessionAERP.this.m_nYLastReceivedMouseEvent != ApplianceSessionAERP.this.m_nYLastSentMouseEvent) {
                                try {
                                    DSData dSData = ApplianceSessionAERP.this.m_queueAvailable.getData();
                                    PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(dSData, ApplianceSessionAERP.this.m_bIsV2Appliance);
                                    packetProtocolAERP.setCmdMouseData(dSData, (short)0, (short)ApplianceSessionAERP.this.m_nXLastReceivedMouseEvent, (short)ApplianceSessionAERP.this.m_nYLastReceivedMouseEvent);
                                    ApplianceSessionAERP.this.m_queueOutput.putData(packetProtocolAERP.getData());
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                ApplianceSessionAERP.this.m_lTimeLastSentMouseEvent = System.currentTimeMillis();
                                ApplianceSessionAERP.this.m_nXLastSentMouseEvent = ApplianceSessionAERP.this.m_nXLastReceivedMouseEvent;
                                ApplianceSessionAERP.this.m_nYLastSentMouseEvent = ApplianceSessionAERP.this.m_nYLastReceivedMouseEvent;
                            }
                            ApplianceSessionAERP.this.m_threadMousePacing = null;
                        }
                    });
                    this.m_threadMousePacing.start();
                }
                return;
            }
            this.m_lTimeLastSentMouseEvent = l;
            this.m_nXLastSentMouseEvent = n4;
            this.m_nYLastSentMouseEvent = n5;
        }
        dSData = this.m_queueAvailable.getData();
        packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
        packetProtocolAERP.setCmdMouseData(dSData, (short)n3, (short)n4, (short)n5);
        this.m_queueOutput.putData(packetProtocolAERP.getData());
    }

    private int getKeyLocation(int n) {
        int n2 = 0;
        switch (n) {
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 144: {
                n2 = 4;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return n2;
    }

    private void cmdMessageAcknowledge() throws IOException {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdMessageAcknowledge) Exiting isRunIOQueueSet FALSE");
            return;
        }
        DSData dSData = this.m_queueAvailable.getData();
        PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
        packetProtocolAERP.setSeqNumRecv(this.getRecvSeqNumAckPending());
        packetProtocolAERP.setCommand(dSData, (short)37);
        this.m_queueOutput.putData(packetProtocolAERP.getData());
    }

    private void cmdInitEncryption() throws IOException {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdInitEncryption) Exiting isRunIOQueueSet FALSE");
            return;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdInitEncryption)");
        DSData dSData = this.m_queueAvailable.getData();
        PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
        packetProtocolAERP.setInitEncryptKey(dSData, this.m_rc4Key.getBytes());
        this.m_queueOutput.putData(packetProtocolAERP.getData());
    }

    private void cmdSendHeartbeat() throws IOException {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdSendHeartbeat) Exiting isRunIOQueueSet FALSE");
            return;
        }
        DSData dSData = this.m_queueAvailable.getData();
        PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
        packetProtocolAERP.setCommand(dSData, (short)12, (int)System.currentTimeMillis());
        this.m_queueOutput.putData(packetProtocolAERP.getData());
        this.m_lLastHBPacketSendTime = System.currentTimeMillis();
    }

    private void cmdVideoFrameComplete() throws IOException {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdVideoFrameComplete) Exiting isRunIOQueueSet FALSE");
            return;
        }
        if (this.m_nLastVideoFrameAck == -1) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdVideoFrameComplete) Frame # not set");
            return;
        }
        DSData dSData = this.m_queueAvailable.getData();
        this.m_dsPacketVideoConfirm.setData(dSData);
        this.m_dsPacketVideoConfirm.setCommand(dSData, (short)35, this.m_nLastVideoFrameAck);
        if (this.m_nPacketAckDelay > 0) {
            try {
                ApplianceSessionAERP.sleep(this.m_nPacketAckDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.m_queueOutput.putData(this.m_dsPacketVideoConfirm.getData());
    }

    private void cmdSendVideoNAK() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdSendVideoNAK)");
        this.cmdMessage((byte)5);
        this.m_bProcessingDVCFrame = false;
        this.m_dvcCommand7.setCommand(0);
    }

    private void cmdMessage(byte by) throws IOException {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdMessage) Exiting isRunIOQueueSet FALSE");
            return;
        }
        DSData dSData = this.m_queueAvailable.getData();
        PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
        packetProtocolAERP.setCommand(dSData, by);
        this.m_queueOutput.putData(packetProtocolAERP.getData());
    }

    private boolean cmdExchangeCapabilities() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdExchangeCapabilities)");
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdExchangeCapabilities) Exiting isRunIOQueueSet FALSE");
            return false;
        }
        this.m_lReqCapabilitiesTime = System.currentTimeMillis();
        ++this.m_nCapabilitiesRetryCount;
        try {
            DSData dSData = this.m_queueAvailable.getData();
            PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
            packetProtocolAERP.getServerCapabilities(dSData, this.m_bUseUdpForVideo, this.m_bEncryptVideo);
            this.m_queueOutput.putData(packetProtocolAERP.getData());
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdExchangeCapabilities) IOEXCEPTION");
            return false;
        }
        return true;
    }

    private void sendApplianceClose() throws IOException {
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP sendApplianceClose) Exiting isRunIOQueueSet FALSE");
            return;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP sendApplianceClose)");
        this.cmdMessage((byte)38);
    }

    private void addSequenceNumber(PacketProtocolAERP packetProtocolAERP) {
        byte by = packetProtocolAERP.getPacketType();
        if (this.m_bUseUdpForControl && (by == 33 || this.m_bVersion2MsgSupport) && by != 37) {
            packetProtocolAERP.setSeqNumSent(this.getNextSeqNumber());
            if (this.getRecvSeqNumAckPending() != -1) {
                packetProtocolAERP.setSeqNumRecv(this.getRecvSeqNumAckPending());
            }
        }
    }

    private boolean requestResendVideoData(int n) {
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        if (!this.isRunIOQueueSet()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP requestResendVideoData) Exiting isRunIOQueueSet FALSE");
            return false;
        }
        if (this.getResendReqActive() > MAX_RESEND_REQUESTS) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP requestResendVideoData) Exiting maximum resend messages sent for this frame");
            return false;
        }
        try {
            DSData dSData = this.m_queueAvailable.getData();
            PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(dSData, this.m_bIsV2Appliance);
            String string = " ";
            for (n2 = 0; n2 < n - this.m_nCurrentVideoSequence; ++n2) {
                n4 = this.m_nCurrentVideoSequence + n2;
                if (this.m_baPacketStatus[n4] != 0) continue;
                packetProtocolAERP.setResendVideoSeqNum(dSData, n4, n3++);
                string = string + " " + n4;
                int n5 = n4;
                this.m_baPacketStatus[n5] = (byte)(this.m_baPacketStatus[n5] | 1);
            }
            if (n3 > 0) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP requestResendVideoData) NextAvailSeqNum=" + n + " requesting resend for " + n3 + " sequence numbers:" + string));
                if (n3 % 2 != 0) {
                    packetProtocolAERP.setResendVideoSeqNum(dSData, n4, n3);
                }
                packetProtocolAERP.setResendVideoData(dSData, this.m_nCurrentVideoFrame, n3);
                this.m_queueOutput.putData(packetProtocolAERP.getData());
                this.setResendReqActive(true);
            } else {
                this.m_queueAvailable.putData(packetProtocolAERP.getData());
            }
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP cmdExchangeCapabilities) IOEXCEPTION");
            return false;
        }
        return true;
    }

    private boolean checkSequenceNumber(PacketProtocolAERP packetProtocolAERP, int n) {
        boolean bl = true;
        if (this.m_bUseUdpForControl && (n == 33 || this.m_bVersion2MsgSupport)) {
            int n2 = packetProtocolAERP.getSeqNumSent();
            int n3 = 1;
            n3 = this.getRecvSeqNumAckPending() == -1 ? 1 : (this.getRecvSeqNumAckPending() + 1) % 8;
            if (n2 != -1) {
                if (n2 != n3) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP checkSequenceNumber) SEQ#=" + n2 + " sent by appliance is not one more than last SEQ# received= " + (n3 - 1)));
                    bl = false;
                }
                if (bl) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP checkSequenceNumber) Appliance requests ACK SEQ#=" + n2));
                    try {
                        this.setRecvSeqNumAckPending(n2);
                        this.cmdMessageAcknowledge();
                    }
                    catch (Exception exception) {
                        Trace.logError((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP checkSequenceNumber) Exception on ACK send", (Throwable)exception);
                    }
                }
            }
        }
        return bl;
    }

    private void checkMsgAcknowledge(PacketProtocolAERP packetProtocolAERP) {
        if (!this.m_bUseUdpForControl) {
            return;
        }
        if (this.getMsgSentAckPending() && (packetProtocolAERP.getPacketType() == 33 || this.m_bVersion2MsgSupport)) {
            int n = packetProtocolAERP.getSeqNumRecv();
            int n2 = this.getLastSeqNumRcvd();
            int n3 = (this.getLastSeqNumRcvd() + 1) % 8;
            if (n != n2 && n == n3) {
                this.setMsgSentAckPending(false);
                this.setLastSeqNumRcvd(n);
            }
        }
    }

    private void processCmdVideoDVC7(PacketProtocolAERP packetProtocolAERP) throws IOException {
        this.incrementTotalVideoPacketsReceived();
        try {
            if (!this.isValidVideoPacket(packetProtocolAERP)) {
                return;
            }
            if (this.m_bProcessingDVCFrame) {
                if (this.m_bEncryptionRC4Support) {
                    DSData dSData = packetProtocolAERP.getData();
                    byte[] byArray = dSData.getData();
                    this.getRc4().rc4(byArray, this.m_nVideoDataOffset, packetProtocolAERP.getPacketLength());
                    dSData.setData(byArray);
                    packetProtocolAERP.setData(dSData);
                }
                this.m_dsPacketVideoDVC7.setData(packetProtocolAERP.getData());
                this.m_dsPacketVideoDVC7.setPacketVideoType(1);
                this.m_dsPacketVideoDVC7.setVideoDataOffset(this.m_nVideoDataOffset);
                if (this.m_bIsStartOfFrame) {
                    this.m_dsPacketVideoDVC7.setDVCStartOfFrameParameters();
                } else {
                    this.m_dsPacketVideoDVC7.setCommandOffset(this.m_nVideoDataOffset);
                }
                do {
                    this.m_dsPacketVideoDVC7.getNextCommand(this.m_dvcCommand7, this.m_bIsEndOfFrame);
                    if (this.m_dvcCommand7.getCommand() == 0) continue;
                    try {
                        this.m_dsPacketVideoDVC7.setDvcVideo(this.m_dvcCommand7);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        Trace.logError((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP processCmdVideoDVC7) ArrayIndexOutOfBoundsException", (Throwable)arrayIndexOutOfBoundsException);
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP processCmdVideoDVC7) ArrayIndexOutOfBoundsException Current Frame#=" + this.m_nCurrentVideoFrame + " Sequence#=" + this.m_nCurrentVideoSequence));
                        this.cmdRefreshPane();
                    }
                } while (this.m_bProcessingDVCFrame && this.isSessionRunning() && this.m_dvcCommand7.getCommand() != 0);
                if (this.m_bIsEndOfFrame) {
                    this.m_nResendFrameCnt = 0;
                    this.m_windowAppliance.getPanelAppliance().dvcEndOfFrame();
                    this.m_bProcessingDVCFrame = false;
                    if (this.m_bVideoHandshakeSupport) {
                        this.m_nLastVideoFrameAck = this.m_nCurrentVideoFrame;
                        this.cmdVideoFrameComplete();
                        this.clearTotalVideoPacketsReceivedSinceLastConfirm();
                    }
                    ++this.m_nCurrentVideoFrame;
                    this.m_nCurrentVideoSequence = 0;
                }
            }
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP processCmdVideoDVC7) Exception in processing DVC command", (Throwable)exception);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP processCmdVideoDVC7) Exception Current Video Frame=" + this.m_nCurrentVideoFrame + " Sequence=" + this.m_nCurrentVideoSequence));
            this.cmdRefreshPane();
        }
    }

    private boolean isValidVideoPacket(PacketProtocolAERP packetProtocolAERP) throws IOException {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        this.m_bIsStartOfFrame = packetProtocolAERP.isStartOfFrame();
        this.m_bIsEndOfFrame = packetProtocolAERP.isEndOfFrame();
        if (this.m_bEncryptionRC4Support) {
            bl2 = packetProtocolAERP.isFlagSet(1024);
        }
        if (this.m_bShortVideoPacketSupport) {
            bl = packetProtocolAERP.isFlagSet(2048);
        }
        int n2 = packetProtocolAERP.getFrameNumber();
        int n3 = 0;
        if (this.m_bVideoHandshakeSupport && n2 == this.m_nLastVideoFrameAck) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP isValidVideoPacket) Already ACK Frame # " + n2));
            return false;
        }
        if (n2 != this.m_nCurrentVideoFrame && this.m_nCurrentVideoFrame != -1) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP isValidVideoPacket) Unexpected Frame # " + n2 + " expected " + this.m_nCurrentVideoFrame));
            this.cmdRefreshPane();
            return false;
        }
        if (this.m_bIsV2Appliance) {
            n3 = packetProtocolAERP.getSequenceNumber();
            if (this.m_nCurrentVideoFrame == -1 && n3 != 0) {
                return false;
            }
            if (n3 < this.m_nCurrentVideoSequence) {
                if (n3 == 1) {
                    ++this.m_nResendFrameCnt;
                }
                if (this.m_nResendFrameCnt == 2) {
                    this.cmdRefreshPane();
                }
                return false;
            }
            if (n3 != this.m_nCurrentVideoSequence) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP isValidVideoPacket) Sequence # wrong for Frame # " + n2 + " got " + n3 + " expected " + this.m_nCurrentVideoSequence + " Flags: SOF=" + this.m_bIsStartOfFrame + " EOF=" + this.m_bIsEndOfFrame));
                if (!this.m_bUseUdpForVideo) {
                    this.cmdRefreshPane();
                    return false;
                }
                if (this.m_nCurrentVideoSequence == 0) {
                    return false;
                }
                this.processOOSData(packetProtocolAERP, n3);
                return false;
            }
            ++this.m_nCurrentVideoSequence;
        }
        if (this.m_bIsStartOfFrame) {
            if (this.m_bProcessingDVCFrame) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP isValidVideoPacket) frame start before EOF received");
                this.cmdRefreshPane();
                return false;
            }
            if (this.m_nCurrentVideoFrame == -1) {
                this.m_nCurrentVideoFrame = n2;
            }
            this.m_bProcessingDVCFrame = true;
            this.m_bProcessingDVCFrame = this.m_windowAppliance.getPanelAppliance().setDvcStartOfFrame(packetProtocolAERP.getXResolution(), packetProtocolAERP.getYResolution(), this.getPersistentDataReference().getDecimationFactor());
            this.setDvcCurrentPixel(0);
            for (n = 0; n < 65536; ++n) {
                this.m_baPacketStatus[n] = 0;
            }
            this.setResendReqActive(false);
        } else if (this.m_nCurrentVideoFrame == -1) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP isValidVideoPacket) Data with no Start of Frame - frame #=" + n2 + " Sequence #=" + n3));
            return false;
        }
        this.m_nVideoDataOffset = 16;
        n = 0;
        int n4 = 0;
        if (!bl) {
            this.m_nVideoDataOffset += 8;
        } else {
            n = packetProtocolAERP.getPixelStartOffset();
            n4 = packetProtocolAERP.getPixelCount();
        }
        int n5 = 0;
        if (bl2) {
            this.m_nVideoDataOffset += 4;
            n5 = packetProtocolAERP.getEncryptionSeqCtr();
            if (n5 != this.getRc4().getByteCount()) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP processCmdVideoDVC7) wrong encryption seq ctr value=" + n5 + " should be " + this.getRc4().getByteCount()));
                this.cmdRefreshPane();
                return false;
            }
        }
        return true;
    }

    private void processOOSData(PacketProtocolAERP packetProtocolAERP, int n) throws IOException {
        if (n - this.m_nCurrentVideoSequence > 500) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP processOOSData) too many missing seq # got " + n + " current expected " + this.m_nCurrentVideoSequence));
            this.cmdRefreshPane();
            return;
        }
        int n2 = n % 500;
        this.m_dsOOSArray[n2].setData(packetProtocolAERP.getData());
        int n3 = n;
        this.m_baPacketStatus[n3] = (byte)(this.m_baPacketStatus[n3] | 2);
        if (!this.requestResendVideoData(n)) {
            this.cmdRefreshPane();
        }
    }

    private void processStoredData() {
        if (this.getResendReqActive() == 0) {
            return;
        }
        int n = this.m_nCurrentVideoSequence;
        boolean bl = false;
        boolean bl2 = false;
        try {
            boolean bl3 = bl = (this.m_baPacketStatus[n] & 2) != 0;
            while (bl) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP processStoredData) processing stored seq#=" + n));
                bl2 = true;
                this.processCmdVideoDVC7(this.m_dsOOSArray[n % 500]);
                this.m_baPacketStatus[n] = 0;
                bl = (this.m_baPacketStatus[++n] & 2) != 0;
            }
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP processStoredData)IOException: " + iOException.getMessage()), (Throwable)iOException);
        }
        if (bl2) {
            bl2 = false;
            for (int i = 0; i < 65536; ++i) {
                if (this.m_baPacketStatus[i] == 0) continue;
                bl2 = true;
            }
            if (!bl2) {
                this.setResendReqActive(false);
            }
        }
    }

    private void processCmdKBStatus(PacketProtocolAERP packetProtocolAERP) throws IOException {
        try {
            this.m_bScrollLockAppliance = packetProtocolAERP.isLEDStatusScrollLock();
            this.m_bNumLockAppliance = packetProtocolAERP.isLEDStatusNumLock();
            this.m_bCapsLockAppliance = packetProtocolAERP.isLEDStatusCapsLock();
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP processCmdKBStatus) Appliance ScrollLock=" + this.m_bScrollLockAppliance + " NumLock=" + this.m_bNumLockAppliance + " CapsLock=" + this.m_bCapsLockAppliance));
            if (!this.isInitialKBMouseStatusReceived()) {
                this.cmdStartVideoData();
            }
            this.setInitialKBMouseStatusReceived();
            this.m_queueAvailable.putData(packetProtocolAERP.getData());
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Exception in ApplianceSessionAERP.responseKBMouseStatus " + exception.getMessage()), (Throwable)exception);
        }
    }

    private void processVersionResp(PacketProtocolAERP packetProtocolAERP) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP processVersionResp)");
        this.m_nProtocolVersionMajor = packetProtocolAERP.getDataAsInt(8);
        this.m_nProtocolVersionMinor = packetProtocolAERP.getDataAsInt(12);
        this.m_queueAvailable.putData(packetProtocolAERP.getData());
    }

    private void processCapabilitiesResponse(PacketProtocolAERP packetProtocolAERP) {
        if (this.m_bCapabilitiesRcvd) {
            return;
        }
        this.m_bCapabilitiesRcvd = true;
        this.m_bVideoHandshakeSupport = packetProtocolAERP.isCapabilitySet(4);
        this.m_bShortVideoPacketSupport = packetProtocolAERP.isCapabilitySet(8);
        this.m_bEncryptionRC4Support = packetProtocolAERP.isCapabilitySet(1);
        this.m_bVersion2MsgSupport = packetProtocolAERP.isCapabilitySet(2);
        this.m_nMaxReceiveSize = packetProtocolAERP.getMaxReceiveSizeCapability();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP processCapabilitiesResponse) VideoHandshake=" + this.m_bVideoHandshakeSupport + " ShortVideo=" + this.m_bShortVideoPacketSupport + " RC4 Encryption=" + this.m_bEncryptionRC4Support + " Version2Msg=" + this.m_bVersion2MsgSupport + " MaxReceiveSize=" + this.m_nMaxReceiveSize));
        if (this.m_bVersion2MsgSupport && !this.m_bUseUdpForControl) {
            this.m_bVersion2MsgSupport = false;
        }
        if (this.m_bEncryptionRC4Support) {
            this.m_rc4 = new RC4(this.m_rc4Key.getBytes());
            try {
                this.cmdInitEncryption();
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP processCapabilitiesResponse) Exception on Encryption init", (Throwable)exception);
            }
        }
        try {
            this.cmdKBStatusRequest();
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP processCapabilitiesResponse) Exception on Video Startup", (Throwable)exception);
        }
    }

    private void processHBResponse(PacketProtocolAERP packetProtocolAERP) throws IOException {
        int n = packetProtocolAERP.getDataAsInt(8);
        int n2 = (int)System.currentTimeMillis();
        this.m_nLastHBPacketDelayTime = n2 - n;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP processHBResponse) delay time=" + this.m_nLastHBPacketDelayTime));
        this.m_queueAvailable.putData(packetProtocolAERP.getData());
    }

    private void processVideoLostSync(PacketProtocolAERP packetProtocolAERP) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP processVideoLostSync)");
        this.m_queueAvailable.put(packetProtocolAERP.getData());
        this.getApplianceWindow().getPanelAppliance().videoTemporarilyStopped(1);
        this.m_nCurrentVideoFrame = -1;
        this.m_nLastVideoFrameAck = -1;
        this.m_nCurrentVideoSequence = 0;
        this.m_bProcessingDVCFrame = false;
    }

    private void setVideoResolution(PacketProtocolAERP packetProtocolAERP, short s, short s2) {
        boolean bl = false;
        short s3 = packetProtocolAERP.getXResolution();
        short s4 = packetProtocolAERP.getYResolution();
        if (s3 == -1 || s3 != s) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP setVideoResolution) X Res Changed from " + s3 + " to " + s));
            bl = true;
        }
        if (s4 == -1 || s4 != s2) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP setVideoResolution) Y Res Changed from " + s4 + " to " + s2));
            bl = true;
        }
        packetProtocolAERP.setXResolution(s);
        packetProtocolAERP.setYResolution(s2);
    }

    private void initVideo() throws IOException {
        this.getApplianceWindow().resizeVideoWindow(this.getPersistentDataReference().getPanedWidth(), this.getPersistentDataReference().getPanedHeight());
        this.cmdStartVideo();
        if (!this.m_bPPPConnection) {
            this.cmdThrottleVideo(this.getPersistentDataReference().getThrottleType());
        } else {
            this.cmdThrottleVideo(5);
        }
        this.cmdMouseAlign();
    }

    private void processCmdUserDisconnect(Packet packet) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP processCmdUserDisconnect)");
        this.m_queueAvailable.putData(packet.getData());
        this.getApplianceWindow().activateSingleCursorMode(false);
        this.m_bDisplayUserNoticeOnNetworkError = false;
        Message.show(null, (String)RES.getString("ApplianceSessionAERP_Session_Disconnected_By_Administrator"));
        this.m_windowAppliance.terminate();
    }

    private int translateKeyUSBToJavaKeyCode(int n) {
        int n2 = 0;
        switch (n) {
            case 42: {
                n2 = 8;
                break;
            }
            case 43: {
                n2 = 9;
                break;
            }
            case 40: {
                n2 = 10;
                break;
            }
            case 225: 
            case 229: {
                n2 = 16;
                break;
            }
            case 224: 
            case 228: {
                n2 = 17;
                break;
            }
            case 226: 
            case 230: {
                n2 = 18;
                break;
            }
            case 72: {
                n2 = 19;
                break;
            }
            case 57: {
                n2 = 20;
                break;
            }
            case 41: {
                n2 = 27;
                break;
            }
            case 44: {
                n2 = 32;
                break;
            }
            case 75: {
                n2 = 33;
                break;
            }
            case 78: {
                n2 = 34;
                break;
            }
            case 77: {
                n2 = 35;
                break;
            }
            case 74: {
                n2 = 36;
                break;
            }
            case 80: {
                n2 = 37;
                break;
            }
            case 82: {
                n2 = 38;
                break;
            }
            case 79: {
                n2 = 39;
                break;
            }
            case 81: {
                n2 = 40;
                break;
            }
            case 54: {
                n2 = 44;
                break;
            }
            case 45: {
                n2 = 45;
                break;
            }
            case 55: {
                n2 = 46;
                break;
            }
            case 56: {
                n2 = 47;
                break;
            }
            case 39: {
                n2 = 48;
                break;
            }
            case 30: {
                n2 = 49;
                break;
            }
            case 31: {
                n2 = 50;
                break;
            }
            case 32: {
                n2 = 51;
                break;
            }
            case 33: {
                n2 = 52;
                break;
            }
            case 34: {
                n2 = 53;
                break;
            }
            case 35: {
                n2 = 54;
                break;
            }
            case 36: {
                n2 = 55;
                break;
            }
            case 37: {
                n2 = 56;
                break;
            }
            case 38: {
                n2 = 57;
                break;
            }
            case 51: {
                n2 = 59;
                break;
            }
            case 46: {
                n2 = 61;
                break;
            }
            case 4: {
                n2 = 65;
                break;
            }
            case 5: {
                n2 = 66;
                break;
            }
            case 6: {
                n2 = 67;
                break;
            }
            case 7: {
                n2 = 68;
                break;
            }
            case 8: {
                n2 = 69;
                break;
            }
            case 9: {
                n2 = 70;
                break;
            }
            case 10: {
                n2 = 71;
                break;
            }
            case 11: {
                n2 = 72;
                break;
            }
            case 12: {
                n2 = 73;
                break;
            }
            case 13: {
                n2 = 74;
                break;
            }
            case 14: {
                n2 = 75;
                break;
            }
            case 15: {
                n2 = 76;
                break;
            }
            case 16: {
                n2 = 77;
                break;
            }
            case 17: {
                n2 = 78;
                break;
            }
            case 18: {
                n2 = 79;
                break;
            }
            case 19: {
                n2 = 80;
                break;
            }
            case 20: {
                n2 = 81;
                break;
            }
            case 21: {
                n2 = 82;
                break;
            }
            case 22: {
                n2 = 83;
                break;
            }
            case 23: {
                n2 = 84;
                break;
            }
            case 24: {
                n2 = 85;
                break;
            }
            case 25: {
                n2 = 86;
                break;
            }
            case 26: {
                n2 = 87;
                break;
            }
            case 27: {
                n2 = 88;
                break;
            }
            case 28: {
                n2 = 89;
                break;
            }
            case 29: {
                n2 = 90;
                break;
            }
            case 47: {
                n2 = 91;
                break;
            }
            case 49: {
                n2 = 92;
                break;
            }
            case 48: {
                n2 = 93;
                break;
            }
            case 98: {
                n2 = 96;
                break;
            }
            case 89: {
                n2 = 97;
                break;
            }
            case 90: {
                n2 = 98;
                break;
            }
            case 91: {
                n2 = 99;
                break;
            }
            case 92: {
                n2 = 100;
                break;
            }
            case 93: {
                n2 = 101;
                break;
            }
            case 94: {
                n2 = 102;
                break;
            }
            case 95: {
                n2 = 103;
                break;
            }
            case 96: {
                n2 = 104;
                break;
            }
            case 97: {
                n2 = 105;
                break;
            }
            case 85: {
                n2 = 106;
                break;
            }
            case 87: {
                n2 = 107;
                break;
            }
            case 86: {
                n2 = 109;
                break;
            }
            case 99: {
                n2 = 110;
                break;
            }
            case 84: {
                n2 = 111;
                break;
            }
            case 58: {
                n2 = 112;
                break;
            }
            case 59: {
                n2 = 113;
                break;
            }
            case 60: {
                n2 = 114;
                break;
            }
            case 61: {
                n2 = 115;
                break;
            }
            case 62: {
                n2 = 116;
                break;
            }
            case 63: {
                n2 = 117;
                break;
            }
            case 64: {
                n2 = 118;
                break;
            }
            case 65: {
                n2 = 119;
                break;
            }
            case 66: {
                n2 = 120;
                break;
            }
            case 67: {
                n2 = 121;
                break;
            }
            case 68: {
                n2 = 122;
                break;
            }
            case 69: {
                n2 = 123;
                break;
            }
            case 76: {
                n2 = 127;
                break;
            }
            case 83: {
                n2 = 144;
                break;
            }
            case 71: {
                n2 = 145;
                break;
            }
            case 70: {
                n2 = 154;
                break;
            }
            case 73: {
                n2 = 155;
                break;
            }
            case 120: {
                n2 = 65480;
                break;
            }
            case 118: {
                n2 = 65482;
                break;
            }
            case 124: {
                n2 = 65485;
                break;
            }
            case 125: {
                n2 = 65487;
                break;
            }
            case 126: {
                n2 = 65488;
                break;
            }
            case 123: {
                n2 = 65489;
                break;
            }
            case 102: {
                n2 = 414865;
                break;
            }
            case 116: {
                n2 = 414854;
                break;
            }
            case 117: {
                n2 = 414868;
                break;
            }
            case 119: {
                n2 = 414852;
                break;
            }
            case 65481: {
                n2 = 121;
                break;
            }
            case 65483: {
                n2 = 122;
                break;
            }
            case 414864: {
                n2 = 127;
                break;
            }
            case 128: {
                n2 = 414866;
                break;
            }
            case 129: {
                n2 = 414867;
                break;
            }
            case 138: {
                n2 = 417792;
                break;
            }
            case 139: {
                n2 = 417793;
                break;
            }
            case 135: {
                n2 = 417794;
                break;
            }
            case 137: {
                n2 = 417795;
                break;
            }
            case 227: {
                n2 = 417796;
                break;
            }
            case 101: {
                n2 = 417797;
            }
        }
        return n2;
    }

    private void processFinally() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP processFinally)");
        if (!this.m_bProcessFinallyRun) {
            DSData dSData;
            this.m_bProcessFinallyRun = true;
            this.closeDlgManualVideoAdjust();
            try {
                while (this.m_queueOutput.hasData()) {
                    try {
                        dSData = this.m_queueOutput.getData();
                        dSData = null;
                    }
                    catch (IOException iOException) {}
                }
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP run) sending cmdStopVideo");
                this.cmdStopVideo();
                try {
                    ApplianceSessionAERP.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP run) resetting the run queues flag");
                this.setRunIOQueue(false);
                if (this.m_bUseUdpForVideo) {
                    this.m_dsPacketIOVideo.setRunPacketIO(false);
                }
                this.m_dsPacketIO.setRunPacketIO(false);
                try {
                    ApplianceSessionAERP.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                Trace.logError((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP run)IOException: " + iOException.getMessage()), (Throwable)iOException);
            }
            try {
                if (this.m_bIsV2Appliance) {
                    this.sendApplianceClose();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.close();
            this.allNotifyOnClosing();
            this.m_windowAppliance.terminate();
            try {
                ApplianceSessionAERP.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (this.m_queueInputVideo.hasData()) {
                try {
                    dSData = this.m_queueInputVideo.getData();
                    dSData = null;
                }
                catch (IOException iOException) {}
            }
            this.m_queueInputVideo = null;
            while (this.m_queueInput.hasData()) {
                try {
                    dSData = this.m_queueInput.getData();
                    dSData = null;
                }
                catch (IOException iOException) {}
            }
            this.m_queueInput = null;
            while (this.m_queueAvailable.hasData()) {
                try {
                    dSData = this.m_queueAvailable.getData();
                    dSData = null;
                }
                catch (IOException iOException) {}
            }
            this.m_queueAvailable = null;
            this.setPersistentData(null);
            this.m_windowAppliance = null;
            this.m_dsDataInput = null;
            this.m_dsDataOutput = null;
            this.m_dsDataInputVideo = null;
            this.m_vConnectedUsersListeners.removeAllElements();
            this.abyPixelBuffer = null;
            this.m_dsPacketIO = null;
            this.m_dsPacketIOVideo = null;
            this.m_dsPacket = null;
            this.m_dsPacketVideoDVC7 = null;
            this.m_dsPacketVideoConfirm = null;
            this.m_sendHeartbeat = null;
            for (int i = 0; i < 500; ++i) {
                this.m_dsOOSArray[i] = null;
            }
            this.removeAllNotifyOnClosing();
            this.setPersistentData(null);
        }
    }

    private synchronized void displayNetworkErrorTerminationMessage() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(ApplianceSessionAERP displayNetworkErrorTerminationMessage)");
        if (this.m_bDisplayUserNoticeOnNetworkError) {
            this.m_bDisplayUserNoticeOnNetworkError = false;
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    Object[] objectArray = new Object[]{ApplianceSessionAERP.this.getTitle()};
                    String string = MessageFormat.format(RES.getString("ApplianceSessionAERP_Network_Error_Termination_Message"), objectArray);
                    Message.show(null, (String)string);
                }
            });
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRunIOQueue(boolean bl) {
        Object object = this.m_syncRunIOQueue;
        synchronized (object) {
            this.m_bRunIOQueue = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunIOQueueSet() {
        Object object = this.m_syncRunIOQueue;
        synchronized (object) {
            return this.m_bRunIOQueue;
        }
    }

    private synchronized int getNextSeqNumber() {
        this.m_nLastSeqNumSent = this.m_nLastSeqNumSent == -1 ? 1 : (this.m_nLastSeqNumSent == 7 ? 0 : ++this.m_nLastSeqNumSent);
        return this.m_nLastSeqNumSent;
    }

    private synchronized int getLastSeqNumSent() {
        return this.m_nLastSeqNumSent;
    }

    private synchronized boolean getMsgSentAckPending() {
        return this.m_bMsgSentAckPending;
    }

    private synchronized void setMsgSentAckPending(boolean bl) {
        this.m_bMsgSentAckPending = bl;
    }

    private synchronized int getLastSeqNumRcvd() {
        return this.m_nLastRecvSeqNum;
    }

    private synchronized void setLastSeqNumRcvd(int n) {
        this.m_nLastRecvSeqNum = n;
    }

    private synchronized int getRecvSeqNumAckPending() {
        return this.m_nRecvSeqNumAckPending;
    }

    private synchronized void setRecvSeqNumAckPending(int n) {
        this.m_nRecvSeqNumAckPending = n;
    }

    private synchronized void setResendReqActive(boolean bl) {
        this.m_nResendReqActive = bl ? ++this.m_nResendReqActive : 0;
    }

    private synchronized int getResendReqActive() {
        return this.m_nResendReqActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setRunSession(boolean bl) {
        Object object = this.m_syncRunSession;
        synchronized (object) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(ApplianceSessionAERP.setRunSession) bRunSession: " + bl));
            this.m_bRunSession = bl;
            if (bl) {
                SessionManager.addSession(this);
            } else {
                SessionManager.removeSession(this);
            }
        }
    }

    private synchronized void setInitialKBMouseStatusReceived() {
        this.m_bInitKBStatusReceived = true;
    }

    private void initVideoDecodePackets() {
        this.m_dsPacketVideoDVC7.setRenderPanel(this.m_windowAppliance.getPanelAppliance());
    }

    static /* synthetic */ boolean access$1400(ApplianceSessionAERP applianceSessionAERP) {
        return applianceSessionAERP.m_bActivityOccurred;
    }

    static /* synthetic */ boolean access$1402(ApplianceSessionAERP applianceSessionAERP, boolean bl) {
        applianceSessionAERP.m_bActivityOccurred = bl;
        return applianceSessionAERP.m_bActivityOccurred;
    }

    private class DSSendHeartbeat
    extends Thread {
        int nRetries = 0;
        int nLastAckResent = 0;

        DSSendHeartbeat() {
            this.start();
        }

        public void run() {
            while (ApplianceSessionAERP.this.isRunIOQueueSet()) {
                try {
                    long l;
                    long l2 = System.currentTimeMillis() - ApplianceSessionAERP.this.m_lLastHBPacketSendTime;
                    if (ApplianceSessionAERP.this.m_nLastVideoFrameAck != -1 && ApplianceSessionAERP.this.m_bVideoHandshakeSupport && (l = System.currentTimeMillis() - ApplianceSessionAERP.this.m_lLastVideoFrameRecvTime) > (long)ApplianceSessionAERP.this.m_nMaximumVideoNoResponse) {
                        Trace.logInfo((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(ApplianceSessionAERP DSSendHeartbeat run) sending video confirm in heartbeat thread Elapsed Time since Video Frame or Confirm resent=" + l + " Last ACK frame #=" + ApplianceSessionAERP.this.m_nLastVideoFrameAck + " # Retries=" + this.nRetries));
                        ApplianceSessionAERP.this.cmdVideoFrameComplete();
                        ApplianceSessionAERP.this.m_lLastVideoFrameRecvTime = System.currentTimeMillis();
                        if (this.nLastAckResent == ApplianceSessionAERP.this.m_nLastVideoFrameAck) {
                            ++this.nRetries;
                            if (this.nRetries == MAX_NUM_RETRIES) {
                                ApplianceSessionAERP.this.cmdSendVideoNAK();
                                ApplianceSessionAERP.this.clearTotalVideoPacketsReceivedSinceLastConfirm();
                            }
                        } else {
                            this.nRetries = 1;
                            this.nLastAckResent = ApplianceSessionAERP.this.m_nLastVideoFrameAck;
                        }
                    }
                    if (l2 > (long)HEARTBEAT_INTERVAL) {
                        Trace.logInfo((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(ApplianceSessionAERP DSSendHeartbeat run) sending heartbeat packet Elapsed Time:" + l2));
                        ApplianceSessionAERP.this.cmdSendHeartbeat();
                    }
                    try {
                        DSSendHeartbeat.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (IOException iOException) {
                    Trace.logError((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(DSSendHeartbeat run IOEXCEPTION) " + iOException.getMessage()), (Throwable)iOException);
                    return;
                }
            }
            Trace.logInfo((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)"(ApplianceSessionAERP (DSSendHeartbeat run) Exiting isRunIOQueueSet FALSE");
        }
    }

    private class ThreadVideoProcess
    extends Thread {
        private ApplianceSession.DSQueueAvailable m_queueAvailable;
        private ApplianceSession.DSQueue m_queueInputVideo;
        private boolean m_bIsV2Appliance = false;

        ThreadVideoProcess(ApplianceSession.DSQueue dSQueue, ApplianceSession.DSQueueAvailable dSQueueAvailable, boolean bl) {
            super("ThreadVideoProcess");
            this.m_queueAvailable = dSQueueAvailable;
            this.m_queueInputVideo = dSQueue;
            this.m_bIsV2Appliance = bl;
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(this.m_bIsV2Appliance);
            try {
                while (ApplianceSessionAERP.this.isSessionRunning()) {
                    boolean bl = false;
                    block13: while (this.m_queueInputVideo.hasData()) {
                        packetProtocolAERP.setData((DSData)this.m_queueInputVideo.get());
                        try {
                            byte by = packetProtocolAERP.getPacketType();
                            if (this.m_bIsV2Appliance && !ApplianceSessionAERP.this.checkSequenceNumber(packetProtocolAERP, by)) continue;
                            switch (by) {
                                case 2: {
                                    ApplianceSessionAERP.this.setVideoResolution(packetProtocolAERP, (short)1024, (short)768);
                                    ApplianceSessionAERP.this.processCmdVideoDVC7(packetProtocolAERP);
                                    if (ApplianceSessionAERP.this.getResendReqActive() > 0) {
                                        ApplianceSessionAERP.this.processStoredData();
                                    }
                                    this.m_queueAvailable.putData(packetProtocolAERP.getData());
                                    continue block13;
                                }
                                case 3: {
                                    ApplianceSessionAERP.this.setVideoResolution(packetProtocolAERP, (short)800, (short)600);
                                    ApplianceSessionAERP.this.processCmdVideoDVC7(packetProtocolAERP);
                                    if (ApplianceSessionAERP.this.getResendReqActive() > 0) {
                                        ApplianceSessionAERP.this.processStoredData();
                                    }
                                    this.m_queueAvailable.putData(packetProtocolAERP.getData());
                                    continue block13;
                                }
                                case 4: {
                                    ApplianceSessionAERP.this.setVideoResolution(packetProtocolAERP, (short)640, (short)480);
                                    ApplianceSessionAERP.this.processCmdVideoDVC7(packetProtocolAERP);
                                    if (ApplianceSessionAERP.this.getResendReqActive() > 0) {
                                        ApplianceSessionAERP.this.processStoredData();
                                    }
                                    this.m_queueAvailable.putData(packetProtocolAERP.getData());
                                    continue block13;
                                }
                                case 6: {
                                    ApplianceSessionAERP.this.processVideoLostSync(packetProtocolAERP);
                                    continue block13;
                                }
                            }
                            Trace.logError((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(ApplianceSessionAERP ThreadVideoProcess run)Unknown packet type: " + packetProtocolAERP.getPacketType() + " packet header len:" + packetProtocolAERP.getHeaderLength() + " packet len:" + packetProtocolAERP.getPacketLength()));
                            String string = "First 16 bytes of packet=";
                            for (int i = 0; i < 16; ++i) {
                                if (i % 4 == 0) {
                                    string = string + "  ";
                                }
                                string = string + Integer.toHexString(packetProtocolAERP.getData(i) & 0xFF) + " ";
                            }
                            Trace.logInfo((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(ApplianceSessionAERP ThreadVideoProcess) " + string));
                            this.m_queueAvailable.put(packetProtocolAERP.getData());
                        }
                        catch (NullPointerException nullPointerException) {
                            Trace.logError((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)nullPointerException.getMessage(), (Throwable)nullPointerException);
                        }
                        catch (IOException iOException) {
                            Trace.logError((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(ThreadVideoProcess run)IOException: " + iOException.getMessage()), (Throwable)iOException);
                        }
                    }
                    this.m_queueInputVideo.waitForData();
                }
            }
            finally {
                Trace.logInfo((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)"(ApplianceSessionAERP calling processFinally for video queue");
                ApplianceSessionAERP.this.processFinally();
            }
        }
    }

    private class ThreadDSDataOutput
    extends Thread {
        ApplianceSession.DSQueue m_queueDataOutput;
        DSPacketIO m_dsDataPacketIO;
        PacketProtocolAERP m_dsLastSentPacket;
        PacketProtocolAERP m_dsCombinedPacket;
        byte[] baData;
        int m_nLastPacketSentTime;

        ThreadDSDataOutput(ApplianceSession.DSQueue dSQueue, DSPacketIO dSPacketIO) {
            super("ThreadDSDataOutput");
            this.baData = new byte[ApplianceSessionAERP.this.m_nMaxReceiveSize];
            this.m_nLastPacketSentTime = 0;
            this.m_queueDataOutput = dSQueue;
            this.m_dsDataPacketIO = dSPacketIO;
            this.m_dsLastSentPacket = new PacketProtocolAERP(new DSData(8, 0), ApplianceSessionAERP.this.m_bIsV2Appliance);
            this.m_dsCombinedPacket = new PacketProtocolAERP(ApplianceSessionAERP.this.m_bIsV2Appliance);
            this.start();
        }

        public void run() {
            int n = 0;
            boolean bl = false;
            int n2 = 0;
            int n3 = 0;
            while (ApplianceSessionAERP.this.isRunIOQueueSet()) {
                try {
                    while (this.m_queueDataOutput.hasData()) {
                        DSData dSData;
                        DSData dSData2;
                        while (ApplianceSessionAERP.this.getMsgSentAckPending()) {
                            n = (int)System.currentTimeMillis() - this.m_nLastPacketSentTime;
                            if (n2 == MAX_NUM_RETRIES) {
                                Trace.logInfo((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(ApplianceSessionAERP ThreadDSDataOutput run) MAX Retries - skipping Seq #=" + ApplianceSessionAERP.this.getLastSeqNumRcvd()));
                                ApplianceSessionAERP.this.setLastSeqNumRcvd(ApplianceSessionAERP.this.getLastSeqNumRcvd() + 1);
                                ApplianceSessionAERP.this.setMsgSentAckPending(false);
                            } else if (n > MSG_ACK_INTERVAL) {
                                Trace.logInfo((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(ApplianceSessionAERP ThreadDSDataOutput run) resending packet Last Sequence Number ACK=" + ApplianceSessionAERP.this.getLastSeqNumRcvd() + " SendInterval=" + n + " PacketType=" + this.m_dsLastSentPacket.getPacketType()));
                                dSData2 = this.m_dsLastSentPacket.getData();
                                dSData = ApplianceSessionAERP.this.m_queueAvailable.getData();
                                dSData.setData(dSData2.getData());
                                ApplianceSessionAERP.this.m_dsPacketIO.writeDSData(dSData);
                                this.m_nLastPacketSentTime = (int)System.currentTimeMillis();
                                ++n2;
                                try {
                                    ThreadDSDataOutput.sleep(50L);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (n3 != ApplianceSessionAERP.this.getLastSeqNumRcvd()) continue;
                        }
                        dSData2 = this.m_queueDataOutput.getData();
                        if (ApplianceSessionAERP.this.m_bUseUdpForControl) {
                            if (this.m_queueDataOutput.hasData()) {
                                dSData = ApplianceSessionAERP.this.m_queueAvailable.getData();
                                byte[] byArray = dSData.getData();
                                int n4 = 8;
                                byte[] byArray2 = dSData2.getData();
                                int n5 = dSData2.getUsedLength();
                                System.arraycopy(byArray2, 0, byArray, n4, n5);
                                n4 += n5;
                                ApplianceSessionAERP.this.m_queueAvailable.putData(dSData2);
                                while (this.m_queueDataOutput.hasData() && n4 < ApplianceSessionAERP.this.m_nMaxReceiveSize - 120) {
                                    dSData2 = this.m_queueDataOutput.getData();
                                    byArray2 = dSData2.getData();
                                    n5 = dSData2.getUsedLength();
                                    System.arraycopy(byArray2, 0, byArray, n4, n5);
                                    n4 += n5;
                                    ApplianceSessionAERP.this.m_queueAvailable.putData(dSData2);
                                }
                                dSData.setData(byArray);
                                this.m_dsCombinedPacket.setCombinedCommand(dSData, n4);
                                dSData2 = this.m_dsCombinedPacket.getData();
                            }
                            this.m_dsLastSentPacket.setData(dSData2);
                            if (ApplianceSessionAERP.this.m_bIsV2Appliance) {
                                ApplianceSessionAERP.this.addSequenceNumber(this.m_dsLastSentPacket);
                            }
                            if (ApplianceSessionAERP.this.getLastSeqNumSent() != -1 && this.m_dsLastSentPacket.isSeqNumSentSet()) {
                                ApplianceSessionAERP.this.setMsgSentAckPending(true);
                                n3 = ApplianceSessionAERP.this.getLastSeqNumSent();
                                n2 = 0;
                            }
                            ApplianceSessionAERP.this.m_dsPacketIO.writeDSData(this.m_dsLastSentPacket.getData());
                        } else {
                            ApplianceSessionAERP.this.m_dsPacketIO.writeDSData(dSData2);
                        }
                        this.m_nLastPacketSentTime = (int)System.currentTimeMillis();
                    }
                    this.m_queueDataOutput.waitForData();
                }
                catch (IOException iOException) {
                    Trace.logError((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(ThreadDSDataOutput run) " + iOException.getMessage()), (Throwable)iOException);
                    if (ApplianceSessionAERP.this.m_windowAppliance != null) {
                        ApplianceSessionAERP.this.m_windowAppliance.terminate();
                    } else {
                        ApplianceSessionAERP.this.setRunSession(false);
                    }
                    ApplianceSessionAERP.this.displayNetworkErrorTerminationMessage();
                    break;
                }
            }
            Trace.logInfo((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)"(ApplianceSessionAERP (ThreadDSDataOutput run) Exiting isRunIOQueueSet FALSE");
        }
    }

    private class ThreadDSDataInput
    extends Thread {
        ApplianceSession.DSQueue m_queueDataInput;
        DSPacketIO m_dsDataPacketIO;

        ThreadDSDataInput(ApplianceSession.DSQueue dSQueue, DSPacketIO dSPacketIO) {
            super("ThreadDSDataInput");
            this.m_queueDataInput = dSQueue;
            this.m_dsDataPacketIO = dSPacketIO;
            this.start();
        }

        public void run() {
            PacketProtocolAERP packetProtocolAERP = new PacketProtocolAERP(ApplianceSessionAERP.this.m_bIsV2Appliance);
            while (ApplianceSessionAERP.this.isRunIOQueueSet()) {
                try {
                    DSData dSData = this.m_dsDataPacketIO.readDSData();
                    if (dSData != null) {
                        if (ApplianceSessionAERP.this.m_bUseUdpForVideo) {
                            packetProtocolAERP.setData(dSData);
                            if (packetProtocolAERP.isVideoPacket()) {
                                ApplianceSessionAERP.this.m_lLastVideoFrameRecvTime = System.currentTimeMillis();
                            }
                        }
                        if (ApplianceSessionAERP.this.m_bUseUdpForControl) {
                            ApplianceSessionAERP.this.checkMsgAcknowledge(packetProtocolAERP);
                        }
                        this.m_queueDataInput.put(dSData);
                        continue;
                    }
                    try {
                        ThreadDSDataInput.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Exception exception) {
                    Trace.logError((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(ThreadDSDataInput run) " + exception.getMessage()), (Throwable)exception);
                    if (ApplianceSessionAERP.this.m_windowAppliance != null) {
                        ApplianceSessionAERP.this.m_windowAppliance.terminate();
                    } else {
                        ApplianceSessionAERP.this.setRunSession(false);
                    }
                    ApplianceSessionAERP.this.displayNetworkErrorTerminationMessage();
                    break;
                }
            }
            Trace.logInfo((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)"(ApplianceSessionAERP (ThreadDSDataInput run) Exiting isRunIOQueueSet FALSE");
        }
    }

    class ThreadInactivityTimeout
    extends ThreadContinuous {
        int m_nMinutesElapsed = 0;
        int m_nSecondsElapsed = 0;
        int m_nMaxMinutesInactivity = 0;

        ThreadInactivityTimeout(int n) {
            super("Elapsed Time Dialog Counter", 1000L);
            this.m_nMaxMinutesInactivity = n;
        }

        protected void performTask() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ ThreadInactivityTimeout this$1;
                {
                    this.this$1 = threadInactivityTimeout;
                }

                public void run() {
                    try {
                        if (ApplianceSessionAERP.access$1400(ThreadInactivityTimeout.access$1300(this.this$1))) {
                            this.this$1.m_nMinutesElapsed = 0;
                            this.this$1.m_nSecondsElapsed = 0;
                            ApplianceSessionAERP.access$1402(ThreadInactivityTimeout.access$1300(this.this$1), false);
                        } else if (++this.this$1.m_nSecondsElapsed >= 60) {
                            ++this.this$1.m_nMinutesElapsed;
                            this.this$1.m_nSecondsElapsed = 0;
                            if (this.this$1.m_nMinutesElapsed >= this.this$1.m_nMaxMinutesInactivity) {
                                ThreadInactivityTimeout.access$1300(this.this$1).getApplianceWindow().activateSingleCursorMode(false);
                                ThreadInactivityTimeout.access$1300(this.this$1).getApplianceWindow().bringWindowToTop();
                                Frame frame = null;
                                if (ThreadInactivityTimeout.access$1300(this.this$1).getApplianceWindow() instanceof Frame) {
                                    frame = (Frame)((Object)ThreadInactivityTimeout.access$1300(this.this$1).getApplianceWindow());
                                }
                                JDialogInactivityTimeout jDialogInactivityTimeout = new JDialogInactivityTimeout(frame, ThreadInactivityTimeout.access$1300(this.this$1).getTitle(), this.this$1.m_nMaxMinutesInactivity);
                                jDialogInactivityTimeout.setModal(true);
                                jDialogInactivityTimeout.setVisible(true);
                                if (!jDialogInactivityTimeout.wasOKButtonPressed()) {
                                    Trace.logInfo((String)"VideoViewerTrace", (String)"(ApplianceSessionAERP ThreadInactivityTimeout) sesson timed out, calling terminateSession");
                                    ApplianceSessionAERP.access$000(ThreadInactivityTimeout.access$1300(this.this$1)).terminate();
                                }
                                this.this$1.m_nMinutesElapsed = 0;
                                this.this$1.m_nSecondsElapsed = 0;
                                ApplianceSessionAERP.access$1402(ThreadInactivityTimeout.access$1300(this.this$1), false);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }

        static /* synthetic */ ApplianceSessionAERP access$1300(ThreadInactivityTimeout threadInactivityTimeout) {
            return threadInactivityTimeout.ApplianceSessionAERP.this;
        }
    }

    private class DSPacketIO {
        private DataInputStreamEndian m_dis;
        private DataOutputStreamEndian m_dos;
        private DatagramSocket m_dsUdp;
        private ApplianceSession.DSQueue m_queueAvailable;
        private boolean m_bRunPacketIO;
        private Object m_syncPacketIO = new Object();
        private boolean m_bUdpConnection;
        private String m_szIpAddress;
        private DatagramPacket m_receiveUdpPacket;

        private DSPacketIO(DataInputStreamEndian dataInputStreamEndian, DataOutputStreamEndian dataOutputStreamEndian, ApplianceSession.DSQueue dSQueue) throws IOException {
            this.m_dis = dataInputStreamEndian;
            this.m_dos = dataOutputStreamEndian;
            this.m_queueAvailable = dSQueue;
            this.m_bRunPacketIO = true;
            this.m_bUdpConnection = false;
        }

        private DSPacketIO(DatagramSocket datagramSocket, ApplianceSession.DSQueue dSQueue, String string) throws IOException {
            Trace.logInfo((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(ApplianceSessionAERP DSPacketIO constructor for UDP) IP=" + string));
            this.m_dsUdp = datagramSocket;
            this.m_queueAvailable = dSQueue;
            this.m_bRunPacketIO = true;
            this.m_bUdpConnection = true;
            this.m_szIpAddress = string;
        }

        private DSData readDSData() throws IOException, Exception {
            DSData dSData = this.m_queueAvailable.getData();
            byte[] byArray = dSData.getData();
            int n = 0;
            while (this.isRunPacketIOSet()) {
                try {
                    if (!this.m_bUdpConnection) {
                        int n2;
                        int n3 = 0;
                        for (n2 = 0; n2 < 8; n2 += n3) {
                            n3 = this.m_dis.read(byArray, n2, 8 - n2);
                            if (n3 >= 0) {
                                continue;
                            }
                            Trace.logInfo((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(ApplianceSessionAERP readDSData) read error:" + n3));
                            this.m_queueAvailable.put(dSData);
                            return null;
                        }
                        n = dSData.getPacketLength() - 8;
                        for (n2 = 0; n2 < n; n2 += n3) {
                            n3 = this.m_dis.read(byArray, 8 + n2, n - n2);
                            if (n3 >= 0) {
                                continue;
                            }
                            Trace.logInfo((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(ApplianceSessionAERP readDSData) read error:" + n3));
                            this.m_queueAvailable.put(dSData);
                            return null;
                        }
                        String string = "First 16 bytes of TCP packet=";
                        for (int i = 0; i < 16; ++i) {
                            if (i % 4 == 0) {
                                string = string + "  ";
                            }
                            string = string + Integer.toHexString(byArray[i] & 0xFF) + " ";
                        }
                        string = string + " Length=" + n;
                        dSData.setUsedLength(8 + n);
                        return dSData;
                    }
                    this.m_receiveUdpPacket = new DatagramPacket(byArray, dSData.getSize());
                    this.m_dsUdp.receive(this.m_receiveUdpPacket);
                    n = this.m_receiveUdpPacket.getLength();
                    dSData.setUsedLength(n);
                    String string = "First 16 bytes of UDP packet=";
                    for (int i = 0; i < 16; ++i) {
                        if (i % 4 == 0) {
                            string = string + "  ";
                        }
                        string = string + Integer.toHexString(byArray[i] & 0xFF) + " ";
                    }
                    string = string + " Length=" + n;
                    return dSData;
                }
                catch (IOException iOException) {
                    if (!this.isRunPacketIOSet()) continue;
                    Trace.logError((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(DSData readDSData)IOException: " + iOException.getMessage()));
                    if (!this.m_bUdpConnection) {
                        Trace.logError((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(DSData readDSData)IOException Packet data: " + byArray[0] + " " + byArray[1] + " " + byArray[2] + " " + byArray[3] + " " + byArray[4] + " " + byArray[5] + " " + byArray[6] + " " + byArray[7] + " Packet length: " + n + " Socket Port: " + this.m_dis.getSocket().getPort()), (Throwable)iOException);
                    }
                    this.m_queueAvailable.put(dSData);
                    throw iOException;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    Trace.logError((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(DSData readDSData)IndexOutOfBoundsException: " + indexOutOfBoundsException.getMessage()));
                    if (!this.m_bUdpConnection) {
                        Trace.logError((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(DSData readDSData)IOException Packet data: " + byArray[0] + " " + byArray[1] + " " + byArray[2] + " " + byArray[3] + " " + byArray[4] + " " + byArray[5] + " " + byArray[6] + " " + byArray[7] + " Packet length: " + n + " Socket Port: " + this.m_dis.getSocket().getPort()), (Throwable)indexOutOfBoundsException);
                    }
                    this.m_queueAvailable.put(dSData);
                    throw indexOutOfBoundsException;
                }
                catch (Exception exception) {
                    if (!this.isRunPacketIOSet()) continue;
                    Trace.logError((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(DSData readDSData)Exception: " + exception.getMessage()));
                    if (!this.m_bUdpConnection) {
                        Trace.logError((String)ApplianceSessionAERP.TRACE_CONTEXT, (String)("(DSData readDSData)IOException Packet data: " + byArray[0] + " " + byArray[1] + " " + byArray[2] + " " + byArray[3] + " " + byArray[4] + " " + byArray[5] + " " + byArray[6] + " " + byArray[7] + " Packet length: " + n + " Socket Port: " + this.m_dis.getSocket().getPort()), (Throwable)exception);
                    }
                    this.m_queueAvailable.put(dSData);
                    throw exception;
                }
            }
            return null;
        }

        private void writeDSData(DSData dSData) throws IOException {
            byte[] byArray = dSData.getData();
            int n = dSData.getUsedLength();
            String string = "First 20 bytes of packet=";
            for (int i = 0; i < 20; ++i) {
                if (i % 4 == 0) {
                    string = string + "  ";
                }
                string = string + Integer.toHexString(byArray[i] & 0xFF) + " ";
            }
            string = string + " Length=" + n;
            if (!this.m_bUdpConnection) {
                this.m_dos.write(byArray, 0, n);
                this.m_dos.flush();
            } else {
                DatagramPacket datagramPacket = new DatagramPacket(byArray, n, InetAddress.getByName(this.m_szIpAddress), 623);
                this.m_dsUdp.send(datagramPacket);
            }
            this.m_queueAvailable.putData(dSData);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setRunPacketIO(boolean bl) {
            Object object = this.m_syncPacketIO;
            synchronized (object) {
                this.m_bRunPacketIO = bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isRunPacketIOSet() {
            Object object = this.m_syncPacketIO;
            synchronized (object) {
                return this.m_bRunPacketIO;
            }
        }
    }
}

