/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.interfaces.InterfaceViewer3;
import com.avocent.lib.interfaces.SessionStatus;
import com.avocent.lib.util.OS;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.ThreadContinuous;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.BrandNaming;
import com.avocent.video.DSData;
import com.avocent.video.DSKeyTranslator;
import com.avocent.video.DSPath;
import com.avocent.video.DataInputStreamEndian;
import com.avocent.video.DataOutputStreamEndian;
import com.avocent.video.DvcCommand15;
import com.avocent.video.DvcCommand7;
import com.avocent.video.InterfaceConnectedUsersListener;
import com.avocent.video.InterfaceNativeKeyEventListener;
import com.avocent.video.InterfaceViewWindow;
import com.avocent.video.JDialogInactivityTimeout;
import com.avocent.video.JDialogMessage;
import com.avocent.video.JDialogPreemptWarning;
import com.avocent.video.JDialogPreemptionRequestCancelled;
import com.avocent.video.JDialogShareResponse;
import com.avocent.video.JFrameFullScreen;
import com.avocent.video.JFrameViewer;
import com.avocent.video.JFrameViewerCmdPanel;
import com.avocent.video.JPanelAppliance;
import com.avocent.video.KeyStroke;
import com.avocent.video.KeyTranslator;
import com.avocent.video.KeyboardMacro;
import com.avocent.video.LinuxLibrary;
import com.avocent.video.PacketProtocolAVSP;
import com.avocent.video.PacketVideoAVC;
import com.avocent.video.PacketVideoDVC;
import com.avocent.video.PacketVideoDvcNB;
import com.avocent.video.SessionManager;
import com.avocent.video.SolarisLibrary;
import com.avocent.video.debugPulse;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.io.IOException;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class ApplianceSessionAVSP
extends ApplianceSession {
    public static final String CNAME = "ApplianceSessionAVSP";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    private static final String TRACE_CONTEXT = "VideoViewerTrace.ApplianceSessionAVSP";
    private static final int KEYSTROKE_ROLLOVER_DELAY = 60;
    private static final int MAX_UNACKNOWLEDGED_MOUSE_PACKETS = 50;
    private static final int MAX_HEARTBEAT_INTERVAL = 5000;
    private static final int MAX_VIDEO_PACKET_ACK_INTERVAL = 1000;
    public static final int NO_SESSION_RUNNING = 0;
    public static final int THIS_ID_SESSION_RUNNING = 1;
    public static final int OTHER_ID_SESSION_RUNNING = 2;
    private InterfaceViewWindow m_windowAppliance;
    private ThreadVideoProcess m_threadVideoProcess;
    private ThreadDSDataInput m_dsDataInputKM;
    private ThreadDSDataOutput m_dsDataOutputKM;
    private ApplianceSession.DSQueue m_queueInputKM;
    private DSQueueKMOutput m_queueOutputKM;
    private ThreadDSDataInput m_dsDataInputVideo;
    private ThreadDSDataOutput m_dsDataOutputVideo;
    private ApplianceSession.DSQueue m_queueInputVideo;
    private ApplianceSession.DSQueue m_queueOutputVideo;
    private ApplianceSession.DSQueueAvailable m_queueAvailableKM;
    private ApplianceSession.DSQueueAvailable m_queueAvailableVideo;
    private DSPacketIO m_dsPacketIOKM;
    private DSPacketIO m_dsPacketIOVideo;
    private PacketProtocolAVSP m_dsPacket;
    private PacketProtocolAVSP m_dsPacketKeyboard;
    private PacketProtocolAVSP m_dsPacketVideoControl;
    private PacketProtocolAVSP m_dsPacketSessionControl;
    private PacketProtocolAVSP m_dsPacketVideoConfirm;
    private PacketVideoAVC m_dsPacketVideoAVC;
    private PacketVideoDVC m_dsPacketVideoDVC15;
    private PacketVideoDVC m_dsPacketVideoDVC7;
    private int m_dsPacketVideoType;
    private DvcCommand15 m_dvcCommand15;
    private DvcCommand7 m_dvcCommand7;
    private ThreadDSSendHeartbeat m_sendHeartbeat;
    private DataOutputStreamEndian m_dosApplianceKM;
    private DataInputStreamEndian m_disApplianceKM;
    private DataOutputStreamEndian m_dosApplianceVideo;
    private DataInputStreamEndian m_disApplianceVideo;
    private long m_lLastVideoPacketReceivedTime;
    private long m_lLastKMPacketSentTime;
    private int m_nNumUnacknowledgedMousePacketsSent = 0;
    private Object m_syncNumUnacknowledgedMousePacketsSent = new Object();
    private boolean m_bRunIOQueue;
    private Object m_syncRunIOQueue = new Object();
    private boolean m_bRunSession;
    private Object m_syncRunSession = new Object();
    private int m_nVideoPacketThreshold = 48;
    private boolean m_bNumLockAppliance = false;
    private boolean m_bCapsLockAppliance = false;
    private boolean m_bScrollLockAppliance = false;
    private boolean m_bKanaLockAppliance = false;
    private boolean m_bInitKBStatusReceived = false;
    private boolean m_bDisplayUserNoticeOnNetworkError = true;
    private boolean m_bDisplaySessionDisconnectNotice = true;
    private boolean m_bVideoStarted = false;
    private boolean m_bProcessFinallyRun = false;
    private DSKeyTranslator m_dsKeyTranslator = new DSKeyTranslator();
    protected KeyTranslator m_ktKeyTranslator;
    private byte[] abyPixelBuffer = new byte[3072];
    private String m_szHelpURL;
    private int m_nVideoEncodingType = 1;
    private int m_nColorDepth = 0;
    private int m_nProtocolVersionMajor = 0;
    private int m_nProtocolVersionMinor = 0;
    private boolean m_bActivityOccurred = false;
    private ThreadInactivityTimeout m_threadInactivityTimeout = null;
    private boolean m_bProcessingDVCFrame = false;
    private boolean m_bFirstResolutionNoticeReceived = false;
    private long m_lTimeLastSentMouseEvent = 0L;
    private long m_lTimeLastReceivedMouseEvent = 0L;
    private int m_nXLastReceivedMouseEvent = 0;
    private int m_nYLastReceivedMouseEvent = 0;
    private int m_nXLastSentMouseEvent = 0;
    private int m_nYLastSentMouseEvent = 0;
    private Thread m_threadMousePacing = null;
    private int m_nMouseThrottleTime = 0;
    private Vector m_vConnectedUsersListeners = new Vector();
    private boolean m_bPixelArrayInitDone = false;
    private JDialogPreemptWarning m_dlgPreemptWarning = null;
    private JDialogPreemptionRequestCancelled m_dlgPreemptionRequestCancelled = null;
    private boolean m_bThumbnail = false;
    private boolean m_bDisconnectMessageCleared = true;
    private JDialogShareResponse m_dlgShareResponse = null;
    private boolean m_bShareRequestPending = false;
    private String szMsg;

    public ApplianceSessionAVSP(InterfaceViewer3 interfaceViewer3, SessionStatus sessionStatus, DSPath dSPath, String string, DataInputStreamEndian dataInputStreamEndian, DataOutputStreamEndian dataOutputStreamEndian, DataInputStreamEndian dataInputStreamEndian2, DataOutputStreamEndian dataOutputStreamEndian2, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, int n2, int n3) {
        super(CNAME, interfaceViewer3, sessionStatus, dSPath, string, 2, n, string2);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("constructor szApplianceIP: " + dSPath.getIPAddress()));
        this.clearTotalVideoPacketsReceived();
        this.m_nVideoPacketThreshold = 48;
        this.m_nNumUnacknowledgedMousePacketsSent = 0;
        this.m_bEnableConnectedUserSupport = false;
        this.m_disApplianceKM = dataInputStreamEndian;
        this.m_dosApplianceKM = dataOutputStreamEndian;
        this.m_disApplianceVideo = dataInputStreamEndian2;
        this.m_dosApplianceVideo = dataOutputStreamEndian2;
        this.m_szHelpURL = string2;
        this.setConnectionSharedAtLaunch(bl);
        this.setScalingControlsEnabled(!bl);
        this.setPPPConnection(bl2);
        this.setStealthConnection(bl3);
        this.setPassiveConnection(bl4);
        this.m_nClientRandomNumber = n2;
        this.m_nApplianceRandomNumber = n3;
        try {
            this.initQueues();
            if (dSPath.showToolbar()) {
                this.setApplianceWindow(new JFrameViewer(this, this.m_szHelpURL, false));
            } else {
                this.setFullScreenMode();
                this.setApplianceWindow(new JFrameViewerCmdPanel(this, this.m_szHelpURL, false));
            }
            this.initVideoDecodePackets();
            this.m_windowAppliance.getPanelAppliance().setPPPConnection(this.isPPPConnection());
            this.setPriority(5);
            this.start();
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
            Message.show(null, (String)RES.getString("ApplianceSessionAVSP_appliance_session_cant_start"));
        }
        catch (NullPointerException nullPointerException) {
            Trace.logError((String)TRACE_CONTEXT, (String)nullPointerException.getMessage(), (Throwable)nullPointerException);
            Message.show(null, (String)RES.getString("ApplianceSessionAVSP_appliance_session_cant_start"));
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public ApplianceSessionAVSP(InterfaceViewWindow interfaceViewWindow, int n, int n2, int n3, InterfaceViewer3 interfaceViewer3, SessionStatus sessionStatus, DSPath dSPath, DataInputStreamEndian dataInputStreamEndian, DataOutputStreamEndian dataOutputStreamEndian, DataInputStreamEndian dataInputStreamEndian2, DataOutputStreamEndian dataOutputStreamEndian2, boolean bl, boolean bl2, String string, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n4, boolean bl7) {
        super(CNAME, interfaceViewer3, sessionStatus, dSPath, "", 2, n4, string);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("constructor szApplianceIP: " + dSPath.getIPAddress()));
        this.clearTotalVideoPacketsReceived();
        this.m_nVideoPacketThreshold = 48;
        this.m_nNumUnacknowledgedMousePacketsSent = 0;
        this.m_bEnableConnectedUserSupport = false;
        this.m_disApplianceKM = dataInputStreamEndian;
        this.m_dosApplianceKM = dataOutputStreamEndian;
        this.m_disApplianceVideo = dataInputStreamEndian2;
        this.m_dosApplianceVideo = dataOutputStreamEndian2;
        this.m_bDisplayUserNoticeOnNetworkError = bl;
        this.m_bDisplaySessionDisconnectNotice = bl2;
        this.m_bThumbnail = bl7;
        this.m_szHelpURL = string;
        this.setConnectionSharedAtLaunch(bl3);
        this.setScalingControlsEnabled(!bl3);
        this.setPPPConnection(bl4);
        this.setStealthConnection(bl5);
        this.setPassiveConnection(bl6);
        try {
            this.getPersistentDataReference().setPanedWidth((short)n, true);
            this.getPersistentDataReference().setPanedHeight((short)n2, true);
            this.getPersistentDataReference().setDecimationFactor(n3, true);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Failed to set width, height, decimation factor during init", (Throwable)exception);
        }
        try {
            this.initQueues();
            this.setApplianceWindow(interfaceViewWindow);
            if (this.m_windowAppliance.getPanelAppliance().getApplianceSession() == null) {
                this.m_windowAppliance.getPanelAppliance().setApplianceSession(this);
            }
            this.initVideoDecodePackets();
            this.setPriority(5);
            this.start();
        }
        catch (IOException iOException) {
            Message.show(null, (String)RES.getString("ApplianceSessionAVSP_appliance_session_cant_start"));
        }
    }

    public boolean useJavaKeyCodes() {
        return false;
    }

    public void videoConfigChanged(JPanelAppliance jPanelAppliance) {
        this.m_dsPacketVideoAVC.videoConfigChanged(jPanelAppliance);
        this.m_dsPacketVideoDVC7.videoConfigChanged(jPanelAppliance);
        this.m_dsPacketVideoDVC15.videoConfigChanged(jPanelAppliance);
    }

    private void initVideoDecodePackets() {
        this.m_dsPacketVideoAVC.setRenderPanel(this.m_windowAppliance.getPanelAppliance());
        this.m_dsPacketVideoDVC15.setRenderPanel(this.m_windowAppliance.getPanelAppliance());
        this.m_dsPacketVideoDVC7.setRenderPanel(this.m_windowAppliance.getPanelAppliance());
    }

    private void initQueues() throws IOException {
        int n;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"initQueues");
        this.m_queueInputKM = (ApplianceSession)this.new ApplianceSession.DSQueue(20);
        this.m_queueOutputKM = new DSQueueKMOutput(20);
        this.m_queueInputVideo = (ApplianceSession)this.new ApplianceSession.DSQueue(150);
        this.m_queueOutputVideo = (ApplianceSession)this.new ApplianceSession.DSQueue(10);
        this.m_queueAvailableKM = (ApplianceSession)this.new ApplianceSession.DSQueueAvailable(this.m_queueInputKM.getSize() + this.m_queueOutputKM.getSize() + 10);
        for (n = 0; n < this.m_queueAvailableKM.getSize(); ++n) {
            this.m_queueAvailableKM.put(new DSData(8, 6));
        }
        this.m_queueAvailableVideo = (ApplianceSession)this.new ApplianceSession.DSQueueAvailable(this.m_queueInputVideo.getSize() + this.m_queueOutputVideo.getSize() + 10);
        for (n = 0; n < this.m_queueAvailableVideo.getSize(); ++n) {
            this.m_queueAvailableVideo.put(new DSData(8, 6));
        }
        this.m_dsPacket = new PacketProtocolAVSP();
        this.m_dsPacketKeyboard = new PacketProtocolAVSP();
        this.m_dsPacketVideoControl = new PacketProtocolAVSP();
        this.m_dsPacketSessionControl = new PacketProtocolAVSP();
        this.m_dsPacketVideoConfirm = new PacketProtocolAVSP();
        this.m_dvcCommand15 = new DvcCommand15();
        this.m_dvcCommand7 = new DvcCommand7();
        this.m_dsPacketVideoAVC = new PacketVideoAVC(8, 16, 6, 2);
        if (OS.isLinux()) {
            this.m_dsPacketVideoDVC15 = new PacketVideoDvcNB(8, 16, 6, 2);
            this.m_dsPacketVideoDVC7 = new PacketVideoDvcNB(8, 16, 6, 2);
        } else {
            this.m_dsPacketVideoDVC15 = new PacketVideoDVC(8, 16, 6, 2);
            this.m_dsPacketVideoDVC7 = new PacketVideoDVC(8, 16, 6, 2);
        }
        this.setRunSession(true);
        this.setRunIOQueue(true);
    }

    public void setPersistentData(ApplianceSessionInfo applianceSessionInfo) {
        JPanelAppliance jPanelAppliance;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"ApplianceSessionAVSP.setPersistentData");
        if (applianceSessionInfo != null) {
            try {
                this.getPersistentDataReference().setAll(applianceSessionInfo);
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)exception.toString(), (Throwable)exception);
            }
        }
        if (this.m_windowAppliance != null && (jPanelAppliance = this.m_windowAppliance.getPanelAppliance()) != null) {
            jPanelAppliance.setSessionInfo(this.getPersistentDataReference());
        }
    }

    public void setVideoThrottleType(int n) {
        int n2;
        switch (n) {
            case 0: 
            case 4: {
                n2 = 48;
                break;
            }
            case 1: {
                n2 = 24;
                break;
            }
            case 2: {
                n2 = 7;
                break;
            }
            case 3: {
                n2 = 4;
                break;
            }
            default: {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("Unexpected video throttle (" + n + ") replaced with default value."));
                n2 = 48;
                n = 0;
            }
        }
        try {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Setting video ACK value to: " + n + ", (acknowledge every " + n2 + " packets)."));
            this.cmdThrottleVideo(n);
            this.m_nVideoPacketThreshold = n2;
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"Error while sendig video throttle command.", (Throwable)iOException);
            this.m_nVideoPacketThreshold = 3;
        }
    }

    public void setPersistentMacroData(ApplianceSessionInfo applianceSessionInfo) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"setPersistentMacroData");
        this.setPersistentData(applianceSessionInfo);
    }

    public void setGlobalMacroData(ApplianceSessionInfo applianceSessionInfo) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"setGlobalMacroData");
        JPanelAppliance jPanelAppliance = this.m_windowAppliance.getPanelAppliance();
        if (jPanelAppliance != null) {
            jPanelAppliance.setSessionInfo(this.getPersistentDataReference());
        }
    }

    public final void setApplianceWindow(InterfaceViewWindow interfaceViewWindow) {
        this.m_windowAppliance = interfaceViewWindow;
        this.m_ktKeyTranslator = new KeyTranslator(this.m_windowAppliance.getViewComponent());
    }

    public final InterfaceViewWindow getApplianceWindow() {
        return this.m_windowAppliance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.m_dsPacketIOKM = new DSPacketIO(this.m_disApplianceKM, this.m_dosApplianceKM, this.m_queueAvailableKM);
            this.m_dsPacketIOVideo = new DSPacketIO(this.m_disApplianceVideo, this.m_dosApplianceVideo, this.m_queueAvailableVideo);
            this.m_dsDataInputKM = new ThreadDSDataInput(this.m_queueInputKM, this.m_dsPacketIOKM);
            this.m_dsDataOutputKM = new ThreadDSDataOutput(this.m_queueOutputKM, this.m_dsPacketIOKM);
            this.m_dsDataInputVideo = new ThreadDSDataInput(this.m_queueInputVideo, this.m_dsPacketIOVideo);
            this.m_dsDataOutputVideo = new ThreadDSDataOutput(this.m_queueOutputVideo, this.m_dsPacketIOVideo);
            DSData dSData = this.m_queueAvailableKM.getData();
            this.m_dsPacketSessionControl.setCommand(dSData, (short)1024);
            this.m_queueOutputKM.put(this.m_dsPacketSessionControl.getData());
            this.m_sendHeartbeat = new ThreadDSSendHeartbeat();
            this.m_lLastVideoPacketReceivedTime = System.currentTimeMillis();
            this.m_lLastKMPacketSentTime = 0L;
            this.cmdKBStatusRequest();
            this.m_threadVideoProcess = new ThreadVideoProcess();
            while (this.isSessionRunning()) {
                block29: while (this.m_queueInputKM.hasData()) {
                    this.m_dsPacket.setData((DSData)this.m_queueInputKM.get());
                    switch (this.m_dsPacket.getPacketType()) {
                        case -32512: {
                            this.responseKBMouseStatus(this.m_dsPacket);
                            continue block29;
                        }
                        case -32511: {
                            this.responseMouseAck(this.m_dsPacket);
                            continue block29;
                        }
                        case -32510: {
                            this.responseMouseAcc(this.m_dsPacket);
                            continue block29;
                        }
                        case -32256: 
                        case -32250: {
                            boolean bl = this.m_dsPacket.getPacketType() == -32250;
                            this.responseVideoControlInputResolution(this.m_dsPacket, bl);
                            continue block29;
                        }
                        case -32255: {
                            this.responseVideoControlDisplayResolution(this.m_dsPacket);
                            continue block29;
                        }
                        case -32251: {
                            this.responseVideoControlDisplayResolutionNotAttained(this.m_dsPacket);
                            continue block29;
                        }
                        case -32254: {
                            this.responseVideoControl(this.m_dsPacket);
                            continue block29;
                        }
                        case -32253: {
                            this.responseVideoControlEnableScaling(this.m_dsPacket);
                            continue block29;
                        }
                        case -32252: {
                            this.responseVideoControlColorDepth(this.m_dsPacket);
                            continue block29;
                        }
                        case -31999: {
                            this.responseUserDisconnect(this.m_dsPacket);
                            continue block29;
                        }
                        case -31997: {
                            this.responseUserDisconnectWithTimeout(this.m_dsPacket);
                            continue block29;
                        }
                        case -31996: {
                            this.responseUserCancelDisconnect(this.m_dsPacket);
                            continue block29;
                        }
                        case -31744: {
                            this.responseUserShareRequest(this.m_dsPacket, false);
                            continue block29;
                        }
                        case -31743: {
                            this.responseUserShareRequest(this.m_dsPacket, true);
                            continue block29;
                        }
                        case -31998: {
                            this.responseProtcolVersion(this.m_dsPacket);
                            continue block29;
                        }
                        case -31728: {
                            this.responseSharedUsers(this.m_dsPacket);
                            continue block29;
                        }
                        case -31727: {
                            this.responseExclusiveMode(this.m_dsPacket);
                            continue block29;
                        }
                        case -31726: {
                            this.responseLocked(this.m_dsPacket);
                            continue block29;
                        }
                        case -31725: {
                            this.responseReserve(this.m_dsPacket);
                            continue block29;
                        }
                        case -31724: {
                            this.responseVmAvailable(this.m_dsPacket);
                            continue block29;
                        }
                        case -31712: {
                            this.responseUserPrivilegeParameters(this.m_dsPacket);
                            continue block29;
                        }
                    }
                    Trace.logError((String)TRACE_CONTEXT, (String)("run Unknown packet type: " + this.m_dsPacket.getPacketType() + " packet header len:" + this.m_dsPacket.getHeaderLength() + " packet len:" + this.m_dsPacket.getPacketLength()));
                    this.m_dsPacket.dumpPacketHeader();
                    this.m_queueAvailableKM.put(this.m_dsPacket.getData());
                }
                this.m_queueInputKM.waitForData();
            }
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)("run IOException: " + iOException.getMessage()), (Throwable)iOException);
        }
        finally {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"calling processFinally for KM queue");
            this.processFinally();
        }
    }

    private void processFinally() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"processFinally");
        if (!this.m_bProcessFinallyRun) {
            DSData dSData;
            this.m_bProcessFinallyRun = true;
            this.closeDlgManualVideoAdjust();
            try {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"run sending cmdStopVideo");
                this.cmdStopVideo();
                try {
                    ApplianceSessionAVSP.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                Trace.logInfo((String)TRACE_CONTEXT, (String)"run resetting the run queues flag");
                this.setRunIOQueue(false);
                this.m_dsPacketIOVideo.setRunPacketIO(false);
                this.m_dsPacketIOKM.setRunPacketIO(false);
                try {
                    this.m_dsDataInputKM.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_dsDataOutputKM.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_dsDataInputVideo.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_dsDataOutputVideo.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_threadVideoProcess.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_sendHeartbeat.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_threadInactivityTimeout.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.m_threadMousePacing.interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    ApplianceSessionAVSP.sleep(400L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (IOException iOException) {
                Trace.logError((String)TRACE_CONTEXT, (String)("run IOException: " + iOException.getMessage()), (Throwable)iOException);
            }
            try {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"run closing m_disApplianceKM.socket");
                this.m_disApplianceKM.getSocket().close();
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Closing m_disApplianceKM", (Throwable)exception);
            }
            try {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"run closing m_disApplianceKM");
                this.m_disApplianceKM.close();
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Closing m_disApplianceKM", (Throwable)exception);
            }
            try {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"run closing m_dosApplianceKM");
                this.m_dosApplianceKM.close();
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Closing m_dosApplianceKM", (Throwable)exception);
            }
            try {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"run closing m_disApplianceVideo.socket");
                this.m_disApplianceVideo.getSocket().close();
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Closing m_disApplianceVideo.socket", (Throwable)exception);
            }
            try {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"run closing m_disApplianceVideo");
                this.m_disApplianceVideo.close();
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Closing m_disApplianceVideo", (Throwable)exception);
            }
            try {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"run closing m_dosApplianceVideo");
                this.m_dosApplianceVideo.close();
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Closing m_dosApplianceVideo", (Throwable)exception);
            }
            this.allNotifyOnClosing();
            this.m_windowAppliance.terminate();
            try {
                ApplianceSessionAVSP.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.m_windowAppliance = null;
            this.m_dsDataInputKM = null;
            this.m_dsDataOutputKM = null;
            this.m_queueInputKM = null;
            this.m_queueOutputKM = null;
            this.m_dsDataInputVideo = null;
            this.m_dsDataOutputVideo = null;
            while (this.m_queueInputVideo.hasData()) {
                try {
                    dSData = this.m_queueInputVideo.getData();
                    dSData = null;
                }
                catch (Exception exception) {}
            }
            this.m_queueInputVideo = null;
            while (this.m_queueOutputVideo.hasData()) {
                try {
                    dSData = this.m_queueOutputVideo.getData();
                    dSData = null;
                }
                catch (Exception exception) {}
            }
            this.m_queueOutputVideo = null;
            while (this.m_queueAvailableKM.hasData()) {
                try {
                    dSData = this.m_queueAvailableKM.getData();
                    dSData = null;
                }
                catch (Exception exception) {}
            }
            this.m_queueAvailableKM = null;
            while (this.m_queueAvailableVideo.hasData()) {
                try {
                    dSData = this.m_queueAvailableVideo.getData();
                    dSData = null;
                }
                catch (Exception exception) {}
            }
            this.m_vConnectedUsersListeners.removeAllElements();
            this.m_queueAvailableVideo = null;
            this.m_dsPacketIOKM = null;
            this.m_dsPacketIOVideo = null;
            this.m_dsPacket = null;
            this.m_dsPacketKeyboard = null;
            this.m_dsPacketVideoControl = null;
            this.m_dsPacketSessionControl = null;
            this.m_dsPacketVideoConfirm = null;
            this.m_dsPacketVideoAVC = null;
            this.m_dsPacketVideoDVC15 = null;
            this.m_dsPacketVideoDVC7 = null;
            this.m_dvcCommand15 = null;
            this.m_dvcCommand7 = null;
            this.m_sendHeartbeat = null;
            this.getPersistentDataReference().terminate();
            this.setPersistentData(null);
            this.m_dosApplianceKM = null;
            this.m_disApplianceKM = null;
            this.m_dosApplianceVideo = null;
            this.m_disApplianceVideo = null;
            this.removeAllNotifyOnClosing();
            Trace.logInfo((String)TRACE_CONTEXT, (String)("About to leave processFinally m_bDisconnectMessageCleared=" + this.m_bDisconnectMessageCleared));
            while (!this.m_bDisconnectMessageCleared) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            try {
                SessionManager.removeSession(this);
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            }
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Leaving processFinally");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRunIOQueue(boolean bl) {
        Object object = this.m_syncRunIOQueue;
        synchronized (object) {
            this.m_bRunIOQueue = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRunIOQueueSet() {
        Object object = this.m_syncRunIOQueue;
        synchronized (object) {
            return this.m_bRunIOQueue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setRunSession(boolean bl) {
        Object object = this.m_syncRunSession;
        synchronized (object) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("setRunSession bRunSession: " + bl));
            this.m_bRunSession = bl;
            if (bl && !this.m_bThumbnail) {
                SessionManager.addSession(this);
            }
        }
    }

    public final void terminateSession() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"terminateSession");
        if (this.m_threadInactivityTimeout != null) {
            this.m_threadInactivityTimeout.interrupt();
            this.m_threadInactivityTimeout = null;
        }
        this.m_bDisplayUserNoticeOnNetworkError = false;
        this.setRunSession(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isSessionRunning() {
        Object object = this.m_syncRunSession;
        synchronized (object) {
            return this.m_bRunSession;
        }
    }

    public int getVideoEncodingType() {
        return this.m_nVideoEncodingType;
    }

    public int getColorDepth() {
        return this.m_nColorDepth;
    }

    public float getProtocolVersion() {
        float f = (float)this.m_nProtocolVersionMajor + (float)this.m_nProtocolVersionMinor / 10.0f;
        return f;
    }

    public String getProtocolType() {
        return "AVSP";
    }

    public void registerConnectedUsersListener(InterfaceConnectedUsersListener interfaceConnectedUsersListener) {
        this.m_vConnectedUsersListeners.add(interfaceConnectedUsersListener);
    }

    public void unregisterConnectedUsersListener(InterfaceConnectedUsersListener interfaceConnectedUsersListener) {
        this.m_vConnectedUsersListeners.remove(interfaceConnectedUsersListener);
    }

    public void setPowerOn() {
        if (this.getIFaceViewer() != null) {
            this.getIFaceViewer().powerOn(this.m_dsPath.getDeviceID());
        }
    }

    public void setPowerOff() {
        if (this.getIFaceViewer() != null) {
            this.getIFaceViewer().powerOff(this.m_dsPath.getDeviceID());
        }
    }

    public void setPowerCycle() {
        if (this.getIFaceViewer() != null) {
            this.getIFaceViewer().powerCycle(this.m_dsPath.getDeviceID());
        }
    }

    public int getPowerState() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("getPowerState m_iFaceViewer=" + this.getIFaceViewer() + " tdid=" + this.m_dsPath.getDeviceID()));
        if (this.getIFaceViewer() != null) {
            return this.getIFaceViewer().getPowerState(this.m_dsPath.getDeviceID());
        }
        return 0;
    }

    private void setFullScreenMode() {
        ApplianceSessionInfo applianceSessionInfo = this.getPersistentData();
        applianceSessionInfo.setFullScale(true);
        applianceSessionInfo.setAutoScale(false);
        applianceSessionInfo.setDecimationFactor(1);
        this.setPersistentData(applianceSessionInfo);
    }

    private synchronized void setInitialKBMouseStatusReceived() {
        this.m_bInitKBStatusReceived = true;
    }

    public final synchronized boolean isInitialKBMouseStatusReceived() {
        return this.m_bInitKBStatusReceived;
    }

    private final synchronized long getLastVideoPacketReceivedTime() {
        return this.m_lLastVideoPacketReceivedTime;
    }

    private final synchronized void setLastVideoPacketReceivedTime(long l) {
        this.m_lLastVideoPacketReceivedTime = l;
    }

    private final synchronized long getLastKMPacketSentTime() {
        return this.m_lLastKMPacketSentTime;
    }

    private final synchronized void setLastKMPacketSentTime(long l) {
        this.m_lLastKMPacketSentTime = l;
    }

    public void flushInputQueue() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"flushInputQueue");
        try {
            ApplianceSessionAVSP.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        boolean bl = false;
        while (!bl) {
            while (this.m_queueInputVideo.hasData()) {
                this.m_queueAvailableVideo.put(this.m_queueInputVideo.get());
            }
            try {
                ApplianceSessionAVSP.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bl = !this.m_queueInputVideo.hasData();
        }
    }

    private synchronized void displayNetworkErrorTerminationMessage() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"displayNetworkErrorTerminationMessage");
        if (this.m_bDisplayUserNoticeOnNetworkError) {
            this.m_bDisplayUserNoticeOnNetworkError = false;
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    Object[] objectArray = new Object[]{ApplianceSessionAVSP.this.getTitle()};
                    String string = MessageFormat.format(RES.getString("ApplianceSessionAVSP_Network_Error_Termination_Message"), objectArray);
                    ApplianceSessionAVSP.this.m_bDisconnectMessageCleared = false;
                    Message.show(null, (String)string);
                    ApplianceSessionAVSP.this.m_bDisconnectMessageCleared = true;
                }
            });
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementUnacknowledgedMousePacketCount() {
        Object object = this.m_syncNumUnacknowledgedMousePacketsSent;
        synchronized (object) {
            ++this.m_nNumUnacknowledgedMousePacketsSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getUnacknowledgeMousePacketCount() {
        Object object = this.m_syncNumUnacknowledgedMousePacketsSent;
        synchronized (object) {
            return this.m_nNumUnacknowledgedMousePacketsSent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementUnacknowledgedMousePacketCount(int n) {
        Object object = this.m_syncNumUnacknowledgedMousePacketsSent;
        synchronized (object) {
            this.m_nNumUnacknowledgedMousePacketsSent -= n;
            if (this.m_nNumUnacknowledgedMousePacketsSent < 0) {
                this.m_nNumUnacknowledgedMousePacketsSent = 0;
            }
        }
    }

    private void cmdMouse(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, int n2, int n3) throws IOException {
        if (!this.isRunIOQueueSet()) {
            return;
        }
        if (this.getUnacknowledgeMousePacketCount() >= 50) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdMouse UnacknowledgeMousePacketCount >= 50, ignoring cmdMouse");
            return;
        }
        int n4 = n;
        int n5 = n2;
        if (this.getPersistentDataReference().isPaneScaled()) {
            n4 = this.getPersistentDataReference().getVideoWidth() * n / this.getPersistentDataReference().getPanedWidth();
            n5 = this.getPersistentDataReference().getVideoHeight() * n2 / this.getPersistentDataReference().getPanedHeight();
        }
        if (this.m_nMouseThrottleTime > 0) {
            long l = System.currentTimeMillis();
            if (!(l - this.m_lTimeLastSentMouseEvent >= (long)this.m_nMouseThrottleTime || bl || bl2 || bl3 || bl4 || bl5 || bl6 || bl7 || n3 != 0)) {
                this.m_lTimeLastReceivedMouseEvent = l;
                this.m_nXLastReceivedMouseEvent = n4;
                this.m_nYLastReceivedMouseEvent = n5;
                if (this.m_threadMousePacing == null) {
                    this.m_threadMousePacing = new Thread(new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(ApplianceSessionAVSP.this.m_nMouseThrottleTime);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (ApplianceSessionAVSP.this.m_nXLastReceivedMouseEvent != ApplianceSessionAVSP.this.m_nXLastSentMouseEvent || ApplianceSessionAVSP.this.m_nYLastReceivedMouseEvent != ApplianceSessionAVSP.this.m_nYLastSentMouseEvent) {
                                try {
                                    DSData dSData = ApplianceSessionAVSP.this.m_queueAvailableKM.getData();
                                    PacketProtocolAVSP packetProtocolAVSP = new PacketProtocolAVSP(dSData);
                                    packetProtocolAVSP.setCmdMouseData(dSData, false, false, false, false, false, (short)0, (short)ApplianceSessionAVSP.this.m_nXLastReceivedMouseEvent, (short)ApplianceSessionAVSP.this.m_nYLastReceivedMouseEvent);
                                    ApplianceSessionAVSP.this.m_queueOutputKM.put(packetProtocolAVSP.getData());
                                    ApplianceSessionAVSP.this.incrementUnacknowledgedMousePacketCount();
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                                ApplianceSessionAVSP.this.m_lTimeLastSentMouseEvent = System.currentTimeMillis();
                                ApplianceSessionAVSP.this.m_nXLastSentMouseEvent = ApplianceSessionAVSP.this.m_nXLastReceivedMouseEvent;
                                ApplianceSessionAVSP.this.m_nYLastSentMouseEvent = ApplianceSessionAVSP.this.m_nYLastReceivedMouseEvent;
                            }
                            ApplianceSessionAVSP.this.m_threadMousePacing = null;
                        }
                    });
                    this.m_threadMousePacing.start();
                }
                return;
            }
            this.m_lTimeLastSentMouseEvent = l;
            this.m_nXLastSentMouseEvent = n4;
            this.m_nYLastSentMouseEvent = n5;
        }
        DSData dSData = this.m_queueAvailableKM.getData();
        PacketProtocolAVSP packetProtocolAVSP = new PacketProtocolAVSP(dSData);
        packetProtocolAVSP.setCmdMouseData(dSData, bl, bl2, bl3, bl4, bl5, (short)n3, (short)n4, (short)n5);
        this.m_queueOutputKM.put(packetProtocolAVSP.getData());
        this.incrementUnacknowledgedMousePacketCount();
    }

    private void cmdMouseRelative(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, int n2, int n3) throws IOException {
        long l;
        if (!this.isRunIOQueueSet()) {
            return;
        }
        if (this.getUnacknowledgeMousePacketCount() >= 50) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdMouseRelative UnacknowledgeMousePacketCount >= 50, ignoring cmdMouse");
            return;
        }
        if (!(this.m_nMouseThrottleTime <= 0 || (l = System.currentTimeMillis()) - this.m_lTimeLastSentMouseEvent >= (long)this.m_nMouseThrottleTime || bl || bl2 || bl3 || bl4 || bl5 || bl6 || bl7 || n3 != 0)) {
            this.m_lTimeLastReceivedMouseEvent = l;
            this.m_nXLastReceivedMouseEvent += n;
            this.m_nYLastReceivedMouseEvent += n2;
            if (this.m_threadMousePacing == null) {
                this.m_threadMousePacing = new Thread(new Runnable(){

                    public void run() {
                        try {
                            Thread.sleep(ApplianceSessionAVSP.this.m_nMouseThrottleTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (ApplianceSessionAVSP.this.m_nXLastReceivedMouseEvent != 0 || ApplianceSessionAVSP.this.m_nYLastReceivedMouseEvent != 0) {
                            try {
                                DSData dSData = ApplianceSessionAVSP.this.m_queueAvailableKM.getData();
                                PacketProtocolAVSP packetProtocolAVSP = new PacketProtocolAVSP(dSData);
                                packetProtocolAVSP.setCmdMouseDataRelative(dSData, false, false, false, false, false, (short)0, (short)ApplianceSessionAVSP.this.m_nXLastReceivedMouseEvent, (short)ApplianceSessionAVSP.this.m_nYLastReceivedMouseEvent);
                                ApplianceSessionAVSP.this.m_queueOutputKM.put(packetProtocolAVSP.getData());
                                ApplianceSessionAVSP.this.incrementUnacknowledgedMousePacketCount();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            ApplianceSessionAVSP.this.m_lTimeLastSentMouseEvent = System.currentTimeMillis();
                            ApplianceSessionAVSP.this.m_nXLastReceivedMouseEvent = 0;
                            ApplianceSessionAVSP.this.m_nYLastReceivedMouseEvent = 0;
                            ApplianceSessionAVSP.this.m_threadMousePacing = null;
                        }
                    }
                });
                this.m_threadMousePacing.start();
            }
            return;
        }
        DSData dSData = this.m_queueAvailableKM.getData();
        PacketProtocolAVSP packetProtocolAVSP = new PacketProtocolAVSP(dSData);
        packetProtocolAVSP.setCmdMouseDataRelative(dSData, bl, bl2, bl3, bl4, bl5, (short)n3, (short)n, (short)n2);
        this.m_queueOutputKM.put(packetProtocolAVSP.getData());
        this.incrementUnacknowledgedMousePacketCount();
    }

    public void cmdMouseMoved(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, int n2, char c) throws IOException {
        this.m_bActivityOccurred = true;
        this.cmdMouse(bl, bl2, bl3, bl4, bl5, bl6, bl7, n, n2, c);
    }

    public void cmdMouseMovedRelative(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, int n, int n2, char c) throws IOException {
        this.m_bActivityOccurred = true;
        this.cmdMouseRelative(bl, bl2, bl3, bl4, bl5, bl6, bl7, n, n2, c);
    }

    private void cmdKey(int n, boolean bl, boolean bl2) {
        Object object;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdKey nUsbKeyCode: " + n + " bKeyPressed:" + bl + " bMacroKey:" + bl2));
        if (!this.isRunIOQueueSet()) {
            return;
        }
        if (!bl2) {
            try {
                object = this.getPersistentDataReference().getMenuActivationKey();
                if (object != null && ((KeyStroke)object).getUsbCode() == n && bl) {
                    this.getApplianceWindow().activateSingleCursorMode(false);
                    if (this.getApplianceWindow().activateMenu()) {
                        return;
                    }
                }
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                // empty catch block
            }
        }
        try {
            object = this.m_queueAvailableKM.getData();
            this.m_dsPacketKeyboard.setKeyboardData((DSData)object);
            if (this.m_dsPacketKeyboard.setKeyboardCommand(bl, n)) {
                this.m_queueOutputKM.put(this.m_dsPacketKeyboard.getData());
                if (bl2) {
                    try {
                        ApplianceSessionAVSP.sleep(60L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                this.m_queueAvailableKM.put(object);
                Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdKey unknown keystroke nUsbKeyCode: " + n));
            }
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)("cmdKey IOException: " + iOException.getMessage()), (Throwable)iOException);
        }
    }

    public void cmdScanCodeKeyPressed(int n) {
        this.m_bActivityOccurred = true;
        int n2 = DSKeyTranslator.translateKeyScanCodeToUSB(n);
        if (n2 != -1) {
            this.cmdKey(n2, true, false);
        }
    }

    public void cmdKeyPressed(int n) {
        this.cmdKeyPressed(n, false);
    }

    public void cmdKeyPressed(int n, boolean bl) {
        this.m_bActivityOccurred = true;
        if (n != 0) {
            this.cmdKey(n, true, bl);
        }
    }

    public void cmdKeyPressed(int n, char c, int n2) {
        this.m_bActivityOccurred = true;
        int n3 = this.m_ktKeyTranslator.translateJavaKeyToUSB(n, c, n2);
        if (n3 != -1) {
            this.cmdKey(n3, true, false);
        }
    }

    public void cmdScanKeyReleased(int n) {
        this.m_bActivityOccurred = true;
        int n2 = DSKeyTranslator.translateKeyScanCodeToUSB(n);
        if (n2 != -1) {
            this.cmdKey(n2, false, false);
        }
    }

    public void cmdKeyReleased(int n) {
        this.cmdKeyReleased(n, false);
    }

    public void cmdKeyReleased(int n, boolean bl) {
        this.m_bActivityOccurred = true;
        if (n != 0) {
            this.cmdKey(n, false, bl);
        }
    }

    public void cmdKeyReleased(int n, char c, int n2) {
        this.m_bActivityOccurred = true;
        int n3 = this.m_ktKeyTranslator.translateJavaKeyToUSB(n, c, n2);
        if (n3 != -1) {
            this.cmdKey(n3, false, false);
        }
    }

    public void cmdSendKeystrokes(KeyStroke[] keyStrokeArray) {
        this.cmdSendKeystrokes(keyStrokeArray, false);
    }

    private void cmdSendKeystrokes(KeyStroke[] keyStrokeArray, boolean bl) {
        this.m_bActivityOccurred = true;
        for (int i = 0; i < keyStrokeArray.length; ++i) {
            if (keyStrokeArray[i].getStrokeType() == 0 || keyStrokeArray[i].getStrokeType() == 2) {
                this.cmdKeyPressed(keyStrokeArray[i].getUsbCode(), bl);
            }
            if (keyStrokeArray[i].getStrokeType() != 1 && keyStrokeArray[i].getStrokeType() != 2) continue;
            this.cmdKeyReleased(keyStrokeArray[i].getUsbCode(), bl);
        }
    }

    public void cmdSendMacroKeystrokes(KeyboardMacro keyboardMacro) {
        this.m_bActivityOccurred = true;
        this.cmdSendKeystrokes(keyboardMacro.getKeyStrokes(), true);
    }

    public void cmdNumLockSet(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdNumLockSet bLock:" + bl + " m_bNumLockAppliance:" + this.m_bNumLockAppliance));
        this.m_bActivityOccurred = true;
        if (bl != this.m_bNumLockAppliance) {
            this.cmdKeyPressed(83, true);
            this.cmdKeyReleased(83, true);
            this.m_bNumLockAppliance = bl;
        }
    }

    public void cmdScrollLockSet(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdScrollLockSet bLock:" + bl + " m_bScrollLockAppliance:" + this.m_bScrollLockAppliance));
        this.m_bActivityOccurred = true;
        if (bl != this.m_bScrollLockAppliance) {
            this.cmdKeyPressed(71, true);
            this.cmdKeyReleased(71, true);
            this.m_bScrollLockAppliance = bl;
        }
    }

    public void cmdCapsLockSet(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdCapsLockSet bLock:" + bl + " m_bCapsLockAppliance:" + this.m_bCapsLockAppliance));
        if (bl != this.m_bCapsLockAppliance) {
            this.cmdKeyPressed(57, true);
            this.cmdKeyReleased(57, true);
            this.m_bCapsLockAppliance = bl;
        }
        this.m_bActivityOccurred = true;
    }

    public void cmdKanaLockSet(boolean bl) {
        if (bl != this.m_bKanaLockAppliance) {
            this.cmdKeyPressed(146, true);
            this.cmdKeyReleased(146, true);
            this.m_bKanaLockAppliance = bl;
        }
    }

    public void cmdMouseAlign() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdMouseAlign");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdMouseAlign about to set m_bActivityOccurred true");
        this.m_bActivityOccurred = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdMouseAlign got DSData from m_queueAvailableKM");
        PacketProtocolAVSP packetProtocolAVSP = new PacketProtocolAVSP(dSData);
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdMouseAlign created a new PacketProtocolAVSP");
        packetProtocolAVSP.setCommand(dSData, (short)514);
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdMouseAlign set the command in dsPacketMouse");
        this.m_queueOutputKM.put(packetProtocolAVSP.getData());
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdMouseAlign output the command to m_queueOutputKM");
    }

    public void cmdMouseReenable(boolean bl) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdMouseReenable");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bActivityOccurred = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        PacketProtocolAVSP packetProtocolAVSP = new PacketProtocolAVSP(dSData);
        packetProtocolAVSP.setCommand(dSData, (short)518, bl ? (byte)1 : 0);
        this.m_queueOutputKM.put(packetProtocolAVSP.getData());
    }

    public void cmdPS2Reset() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdPS2Reset");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bActivityOccurred = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        PacketProtocolAVSP packetProtocolAVSP = new PacketProtocolAVSP(dSData);
        packetProtocolAVSP.setCommand(dSData, (short)515);
        this.m_queueOutputKM.put(packetProtocolAVSP.getData());
    }

    public void cmdKBStatusRequest() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdKBStatusRequest");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        DSData dSData = this.m_queueAvailableKM.getData();
        PacketProtocolAVSP packetProtocolAVSP = new PacketProtocolAVSP(dSData);
        packetProtocolAVSP.setCommand(dSData, (short)516);
        this.m_queueOutputKM.put(packetProtocolAVSP.getData());
    }

    public void cmdKBScanSet(int n) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdKBScanSet");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        DSData dSData = this.m_queueAvailableKM.getData();
        PacketProtocolAVSP packetProtocolAVSP = new PacketProtocolAVSP(dSData);
        packetProtocolAVSP.setCommand(dSData, (short)519, (byte)n);
        this.m_queueOutputKM.put(packetProtocolAVSP.getData());
    }

    public void cmdMouseAcceleration(int n) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdKBScanSet");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        DSData dSData = this.m_queueAvailableKM.getData();
        PacketProtocolAVSP packetProtocolAVSP = new PacketProtocolAVSP(dSData);
        switch (n) {
            case 0: {
                packetProtocolAVSP.setCommand(dSData, (short)522, (byte)0);
                break;
            }
            case 4: {
                packetProtocolAVSP.setCommand(dSData, (short)522, (byte)1);
                break;
            }
            case 5: {
                packetProtocolAVSP.setCommand(dSData, (short)522, (byte)2);
                break;
            }
            case 6: {
                packetProtocolAVSP.setCommand(dSData, (short)522, (byte)3);
            }
        }
        this.m_queueOutputKM.put(packetProtocolAVSP.getData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void cmdFocusControl(boolean bl) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdFocusControl");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        InterfaceNativeKeyEventListener interfaceNativeKeyEventListener = null;
        try {
            Object object;
            if (!bl && (LinuxLibrary.isLibraryLoaded() || SolarisLibrary.isLibraryLoaded()) && this.m_windowAppliance != null && (object = this.m_windowAppliance.getViewComponent()) instanceof InterfaceNativeKeyEventListener) {
                interfaceNativeKeyEventListener = (InterfaceNativeKeyEventListener)object;
                if (LinuxLibrary.isLibraryLoaded()) {
                    LinuxLibrary.stopKeyListener(interfaceNativeKeyEventListener);
                } else {
                    SolarisLibrary.stopKeyListener(interfaceNativeKeyEventListener);
                }
            }
            object = this.m_queueAvailableKM.getData();
            PacketProtocolAVSP packetProtocolAVSP = new PacketProtocolAVSP((DSData)object);
            packetProtocolAVSP.setCommand((DSData)object, (short)520, bl ? (byte)1 : 0);
            this.m_queueOutputKM.put(packetProtocolAVSP.getData());
            Object var6_5 = null;
            if (interfaceNativeKeyEventListener == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (interfaceNativeKeyEventListener == null) throw throwable;
            if (LinuxLibrary.isLibraryLoaded()) {
                LinuxLibrary.startKeyListener(interfaceNativeKeyEventListener);
                throw throwable;
            } else {
                SolarisLibrary.startKeyListener(interfaceNativeKeyEventListener);
            }
            throw throwable;
        }
        if (LinuxLibrary.isLibraryLoaded()) {
            LinuxLibrary.startKeyListener(interfaceNativeKeyEventListener);
            return;
        }
        SolarisLibrary.startKeyListener(interfaceNativeKeyEventListener);
    }

    public void cmdStopVideo() throws IOException {
        boolean bl = false;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdStopVideo");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCommand(dSData, (short)782, bl ? (byte)1 : 0);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdStartVideo() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdStartVideo PaneScaled Width:" + this.getPersistentDataReference().getPanedWidth() + " Height:" + this.getPersistentDataReference().getPanedHeight() + " DecimationFactor:" + this.getPersistentDataReference().getDecimationFactor()));
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bVideoStarted = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        if (this.m_nConnectionType != 5 && this.m_nConnectionType != 6) {
            this.m_dsPacketVideoControl.setCmdSetDisplayArea(dSData, this.getPersistentDataReference().getPanedWidth(), this.getPersistentDataReference().getPanedHeight());
        }
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdFullScale() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdFullScale");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bVideoStarted = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCommand(dSData, (short)772);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdVideoGetInputResolution() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdVideoGetInputResolution");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bActivityOccurred = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCommand(dSData, (short)771);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdRefreshPane() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdRefreshPane");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bActivityOccurred = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCommand(dSData, (short)769);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdAutoAdjustVideo() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdAutoAdjustVideo");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCommand(dSData, (short)774);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
        this.m_bActivityOccurred = true;
    }

    public void cmdThrottleVideo(int n) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdThrottleVideo nThrottleValue:" + n));
        if (!this.isRunIOQueueSet()) {
            return;
        }
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketSessionControl.setCommand(dSData, (short)1026, (byte)n);
        this.m_queueOutputKM.put(this.m_dsPacketSessionControl.getData());
    }

    public void cmdRejectPreemptionRequest() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdRejectPreemptionRequest");
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketSessionControl.setCmdPreemptionRejectionResponse(dSData);
        this.m_queueOutputKM.put(this.m_dsPacketSessionControl.getData());
    }

    public void cmdVideoGetColorDepth() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdVideoGetColorDepth");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bActivityOccurred = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketSessionControl.setCommand(dSData, (short)1027, (byte)1);
        this.m_queueOutputKM.put(this.m_dsPacketSessionControl.getData());
    }

    public void cmdVideoSetColorDepth(int n, boolean bl) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdVideoSetColorDepth");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bActivityOccurred = true;
        boolean bl2 = true;
        if (n == 3) {
            bl2 = false;
        }
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketSessionControl.setCmdSetColorDepth(dSData, (byte)n, (byte)(bl2 ? 1 : 0), bl ? (byte)1 : 0);
        this.m_queueOutputKM.put(this.m_dsPacketSessionControl.getData());
        this.m_nColorDepth = n;
        this.cmdVideoGetColorDepth();
    }

    public void cmdVideoTestPattern(boolean bl) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdVideoTestPattern bPatternOn:" + bl));
        if (!this.isRunIOQueueSet()) {
            return;
        }
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCommand(dSData, (short)775, bl ? (byte)1 : 0);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdVideoWidth(int n) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdVideoWidth nWidth:" + n));
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bActivityOccurred = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCmdVideoControl(dSData, (short)776, (short)n);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdVideoFine(int n) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdVideoFine nFine:" + n));
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bActivityOccurred = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCmdVideoControl(dSData, (short)777, (short)n);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdVideoHorzCapture(int n) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdVideoHorzCapture nCapture:" + n));
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bActivityOccurred = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCmdVideoControl(dSData, (short)779, (short)n);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdVideoVertCapture(int n) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdVideoVertCapture nCapture:" + n));
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bActivityOccurred = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCmdVideoControl(dSData, (short)778, (short)n);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdVideoContrast(int n) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdVideoContrast nContrast:" + n));
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bActivityOccurred = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCmdVideoControl(dSData, (short)781, (short)n);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdVideoParameters(int n, int n2, int n3, boolean bl, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, boolean bl2) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdVideoParameters nVideoMode=" + n + " nXResolution=" + n2 + " nYResolution=" + n3 + " bFullScaleMode=" + bl + " nNoiseThreshold=" + n4 + " nPriorityPixelThreshold=" + n5 + " nCaptureWidth=" + n6 + " nPixelFineAdjust=" + n7 + " nCaptureVertPosition=" + n8 + " nCaptureHorzPosition=" + n9 + " nBrightness=" + n10 + " nContrast=" + n11 + " nBitsPerPixel=" + n12 + " bColorEnable=" + bl2));
        if (!this.isRunIOQueueSet()) {
            return;
        }
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCmdVideoParameters(dSData, (short)n, (short)n2, (short)n3, bl, (short)n4, (short)n5, (short)n6, (short)n7, (short)n8, (short)n9, (short)n10, (short)n11, (byte)n12, bl2);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdVideoBrightness(int n) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdVideoBrightness nBrightness:" + n));
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bActivityOccurred = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCmdVideoControl(dSData, (short)780, (short)n);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdVideoNoiseThreshold(int n) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdVideoNoiseThreshold nThreshold:" + n));
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bActivityOccurred = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCmdVideoControl(dSData, (short)773, (short)n);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdVideoPriorityThreshold(int n) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdVideoPriorityThreshold nThreshold:" + n));
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bActivityOccurred = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCmdVideoControl(dSData, (short)783, (short)n);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdVideoSetup() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdVideoSetup");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCommand(dSData, (short)768);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    public void cmdGetConnectedUsers() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"cmdGetConnectedUsers");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        this.m_bActivityOccurred = true;
        DSData dSData = this.m_queueAvailableKM.getData();
        PacketProtocolAVSP packetProtocolAVSP = new PacketProtocolAVSP();
        packetProtocolAVSP.setCommand(dSData, (short)1041);
        this.m_queueOutputKM.put(packetProtocolAVSP.getData());
    }

    public void cmdExclusiveMode(boolean bl) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("cmdExclusiveMode bExclusiveMode=" + bl));
        if (!this.isRunIOQueueSet()) {
            return;
        }
        DSData dSData = this.m_queueAvailableKM.getData();
        this.m_dsPacketVideoControl.setCommand(dSData, (short)1044, bl ? (byte)1 : 0);
        this.m_queueOutputKM.put(this.m_dsPacketVideoControl.getData());
    }

    private void responseVideoAVC(PacketVideoAVC packetVideoAVC) {
        try {
            this.m_nVideoEncodingType = 1;
            packetVideoAVC.decodePixels(this.abyPixelBuffer);
            try {
                this.m_windowAppliance.getPanelAppliance().setPixels(packetVideoAVC.getXLocation(), packetVideoAVC.getYLocation(), 64, 16, this.abyPixelBuffer);
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            }
            this.incrementTotalVideoPacketsReceived();
            if (this.getTotalVideoPacketsReceivedSinceLastConfirm() >= this.m_nVideoPacketThreshold) {
                try {
                    DSData dSData = this.m_queueAvailableVideo.getData();
                    this.m_dsPacketVideoConfirm.setCmdVideoConfirm(dSData, (byte)this.getTotalVideoPacketsReceivedSinceLastConfirm());
                    this.m_queueOutputVideo.put(this.m_dsPacketVideoConfirm.getData());
                    this.clearTotalVideoPacketsReceivedSinceLastConfirm();
                }
                catch (IOException iOException) {
                    Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
                }
            }
            this.m_queueAvailableVideo.put(packetVideoAVC.getData());
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Exception in responseVideo: " + exception.getMessage()), (Throwable)exception);
        }
    }

    private void responseVideoDVC7(PacketVideoDVC packetVideoDVC) {
        int n;
        if (packetVideoDVC.isStartOfFrame()) {
            if (this.m_bProcessingDVCFrame) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"responseVideoDVC7 frame start received without an End of Frame");
            }
            this.m_nVideoEncodingType = 2;
            try {
                this.m_bProcessingDVCFrame = this.m_windowAppliance.getPanelAppliance().setDvcStartOfFrame(packetVideoDVC.getVideoXResolution(), packetVideoDVC.getVideoYResolution(), this.getPersistentDataReference().getDecimationFactor());
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                boolean bl = true;
                n = 10;
                while (bl && n-- > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        this.m_bProcessingDVCFrame = this.m_windowAppliance.getPanelAppliance().setDvcStartOfFrame(packetVideoDVC.getVideoXResolution(), packetVideoDVC.getVideoYResolution(), this.getPersistentDataReference().getDecimationFactor());
                        bl = false;
                    }
                    catch (Exception exception2) {
                        Trace.logError((String)TRACE_CONTEXT, (String)("looping to wait for appliance window " + exception2.getMessage()), (Throwable)exception2);
                    }
                }
            }
            this.setDvcCurrentPixel(0);
        }
        try {
            if (this.m_bProcessingDVCFrame) {
                do {
                    packetVideoDVC.getNextCommand(this.m_dvcCommand7, packetVideoDVC.isEndOfFrame());
                    if (this.m_dvcCommand7.getCommand() == 0) continue;
                    try {
                        this.m_dsPacketVideoDVC7.setDvcVideo(this.m_dvcCommand7);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        Trace.logError((String)TRACE_CONTEXT, (String)"responseVideoDVC7 ArrayIndexOutOfBoundsException", (Throwable)arrayIndexOutOfBoundsException);
                        this.m_bProcessingDVCFrame = false;
                        this.m_dvcCommand7.setCommand(0);
                    }
                } while (this.m_dvcCommand7.getCommand() != 0);
            }
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)"processCmdVideoDVC7 ExceptionRequestFailed in processing DVC command", (Throwable)exceptionRequestFailed);
            this.m_bProcessingDVCFrame = false;
        }
        this.incrementTotalVideoPacketsReceived();
        boolean bl = packetVideoDVC.isEndOfFrame();
        this.m_queueAvailableVideo.put(packetVideoDVC.getData());
        if (bl) {
            try {
                this.m_windowAppliance.getPanelAppliance().dvcEndOfFrame();
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                n = 1;
                int n2 = 10;
                while (n != 0 && n2-- > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        this.m_windowAppliance.getPanelAppliance().dvcEndOfFrame();
                        n = 0;
                    }
                    catch (Exception exception3) {
                        Trace.logError((String)TRACE_CONTEXT, (String)("looping to wait for appliance window " + exception3.getMessage()), (Throwable)exception3);
                    }
                }
            }
            this.m_bProcessingDVCFrame = false;
        }
        try {
            DSData dSData = this.m_queueAvailableVideo.getData();
            this.m_dsPacketVideoConfirm.setData(dSData);
            this.m_dsPacketVideoConfirm.setCmdVideoConfirm(dSData, (byte)this.getTotalVideoPacketsReceivedSinceLastConfirm());
            this.m_queueOutputVideo.put(this.m_dsPacketVideoConfirm.getData());
            this.clearTotalVideoPacketsReceivedSinceLastConfirm();
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
        }
    }

    private void responseVideoDVC15(PacketVideoDVC packetVideoDVC) {
        int n;
        if (packetVideoDVC.isStartOfFrame()) {
            this.m_bEnableConnectedUserSupport = true;
            if (this.m_bProcessingDVCFrame) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"responseVideoDVC15 frame start received without an End of Frame");
            }
            this.m_nVideoEncodingType = 2;
            try {
                this.m_bProcessingDVCFrame = this.m_windowAppliance.getPanelAppliance().setDvcStartOfFrame(packetVideoDVC.getVideoXResolution(), packetVideoDVC.getVideoYResolution(), this.getPersistentDataReference().getDecimationFactor());
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                boolean bl = true;
                n = 10;
                while (bl && n-- > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        this.m_bProcessingDVCFrame = this.m_windowAppliance.getPanelAppliance().setDvcStartOfFrame(packetVideoDVC.getVideoXResolution(), packetVideoDVC.getVideoYResolution(), this.getPersistentDataReference().getDecimationFactor());
                        bl = false;
                    }
                    catch (Exception exception2) {
                        Trace.logError((String)TRACE_CONTEXT, (String)("looping to wait for appliance window " + exception2.getMessage()), (Throwable)exception2);
                    }
                }
            }
            this.setDvcCurrentPixel(0);
        }
        try {
            if (this.m_bProcessingDVCFrame) {
                do {
                    packetVideoDVC.getNextCommand(this.m_dvcCommand15, packetVideoDVC.isEndOfFrame());
                    if (this.m_dvcCommand15.getCommand() == 0) continue;
                    try {
                        this.m_dsPacketVideoDVC15.setDvcVideo(this.m_dvcCommand15);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        Trace.logError((String)TRACE_CONTEXT, (String)"responseVideoDVC15 ArrayIndexOutOfBoundsException", (Throwable)arrayIndexOutOfBoundsException);
                        this.m_bProcessingDVCFrame = false;
                        this.m_dvcCommand15.setCommand(0);
                    }
                } while (this.m_dvcCommand15.getCommand() != 0);
            }
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)"processCmdVideoDVC15 ExceptionRequestFailed in processing DVC command", (Throwable)exceptionRequestFailed);
            this.m_bProcessingDVCFrame = false;
        }
        this.incrementTotalVideoPacketsReceived();
        boolean bl = packetVideoDVC.isEndOfFrame();
        this.m_queueAvailableVideo.put(packetVideoDVC.getData());
        if (bl) {
            try {
                this.m_windowAppliance.getPanelAppliance().dvcEndOfFrame();
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                n = 1;
                int n2 = 10;
                while (n != 0 && n2-- > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        this.m_windowAppliance.getPanelAppliance().dvcEndOfFrame();
                        n = 0;
                    }
                    catch (Exception exception3) {
                        Trace.logError((String)TRACE_CONTEXT, (String)("looping to wait for appliance window " + exception3.getMessage()), (Throwable)exception3);
                    }
                }
            }
            this.m_bProcessingDVCFrame = false;
        }
        try {
            DSData dSData = this.m_queueAvailableVideo.getData();
            this.m_dsPacketVideoConfirm.setData(dSData);
            this.m_dsPacketVideoConfirm.setCmdVideoConfirm(dSData, (byte)this.getTotalVideoPacketsReceivedSinceLastConfirm());
            this.m_queueOutputVideo.put(this.m_dsPacketVideoConfirm.getData());
            this.clearTotalVideoPacketsReceivedSinceLastConfirm();
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
        }
    }

    private void responseVideoTemporaryStop(PacketProtocolAVSP packetProtocolAVSP) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"responseVideoTemporaryStop");
        byte by = packetProtocolAVSP.getReason();
        this.m_queueAvailableVideo.put(packetProtocolAVSP.getData());
        this.getApplianceWindow().getPanelAppliance().videoTemporarilyStopped(by);
        this.incrementTotalVideoPacketsReceived();
        try {
            DSData dSData = this.m_queueAvailableVideo.getData();
            this.m_dsPacketVideoConfirm.setData(dSData);
            this.m_dsPacketVideoConfirm.setCmdVideoConfirm(dSData, (byte)this.getTotalVideoPacketsReceivedSinceLastConfirm());
            this.m_queueOutputVideo.put(this.m_dsPacketVideoConfirm.getData());
            this.clearTotalVideoPacketsReceivedSinceLastConfirm();
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
        }
    }

    private void responseKBMouseStatus(PacketProtocolAVSP packetProtocolAVSP) {
        try {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"responseKBMouseStatus");
            this.setInitialKBMouseStatusReceived();
            this.m_bScrollLockAppliance = packetProtocolAVSP.isLEDStatusScrollLock();
            this.m_bNumLockAppliance = packetProtocolAVSP.isLEDStatusNumLock();
            this.m_bCapsLockAppliance = packetProtocolAVSP.isLEDStatusCapsLock();
            this.m_bKanaLockAppliance = packetProtocolAVSP.isLEDStatusKanaLock();
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Exception in responseKBMouseStatus " + exception.getMessage()), (Throwable)exception);
        }
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
    }

    private void responseVideoControlInputResolution(PacketProtocolAVSP packetProtocolAVSP, boolean bl) {
        block12: {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"responseVideoControlInputResolution");
            try {
                if (packetProtocolAVSP.getXResolution() == this.getPersistentDataReference().getVideoWidth() && packetProtocolAVSP.getYResolution() == this.getPersistentDataReference().getVideoHeight() && packetProtocolAVSP.getVideoMode() == this.getPersistentDataReference().getVideoMode() && this.m_bVideoStarted) {
                    this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
                    return;
                }
                if (!packetProtocolAVSP.isVideoResolutionSane(2400, 2400)) break block12;
                ApplianceSessionInfo applianceSessionInfo = this.getPersistentData();
                short s = 0;
                short s2 = 0;
                try {
                    s = packetProtocolAVSP.getXResolution();
                    s2 = packetProtocolAVSP.getYResolution();
                    applianceSessionInfo.setVideoHeight(s2);
                    applianceSessionInfo.setVideoWidth(s);
                    if (bl) {
                        applianceSessionInfo.setVideoMode(packetProtocolAVSP.getVideoMode());
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("responseVideoControlInputResolution video mode:" + packetProtocolAVSP.getVideoMode()));
                    }
                    this.getApplianceWindow().getPanelAppliance().setVideoWidthAndHeight(packetProtocolAVSP.getXResolution(), packetProtocolAVSP.getYResolution());
                }
                catch (Exception exception) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exception.toString(), (Throwable)exception);
                }
                if (applianceSessionInfo.isFullScale() && !this.m_bThumbnail) {
                    try {
                        applianceSessionInfo.setPanedWidth(s);
                        applianceSessionInfo.setPanedHeight(s2);
                    }
                    catch (Exception exception) {
                        Trace.logError((String)TRACE_CONTEXT, (String)exception.toString(), (Throwable)exception);
                    }
                }
                Trace.logInfo((String)TRACE_CONTEXT, (String)(" responseVideoControlInputResolution m_sessionInfo m_sVideoHeight:" + this.getPersistentDataReference().getVideoHeight() + " m_sVideoWidth:" + this.getPersistentDataReference().getVideoWidth() + "m__sessionInfo m_sPanedHeight:" + this.getPersistentDataReference().getPanedHeight() + " m_sPanedWidth:" + this.getPersistentDataReference().getPanedWidth()));
                this.setPersistentData(applianceSessionInfo);
                this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
                if (this.m_bFirstResolutionNoticeReceived) {
                    this.cmdStartVideo();
                    this.cmdMouseAlign();
                } else if (!this.isConnectionSharedAtLaunch()) {
                    this.initVideo();
                }
            }
            catch (IOException iOException) {
                Trace.logError((String)TRACE_CONTEXT, (String)iOException.toString(), (Throwable)iOException);
            }
        }
    }

    private void responseVideoControlDisplayResolution(PacketProtocolAVSP packetProtocolAVSP) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"responseVideoControlDisplayResolution");
        try {
            if (packetProtocolAVSP.isMaxDisplayResponseSane(3200, 2400)) {
                try {
                    short s = packetProtocolAVSP.getXResolution();
                    short s2 = packetProtocolAVSP.getYResolution();
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("responseVideoControlDisplayResolution sX=" + s + " sY=" + s2));
                    this.getPersistentDataReference().setMaxOutputHeight(s2, true);
                    this.getPersistentDataReference().setMaxOutputWidth(s, true);
                    if (!this.m_bFirstResolutionNoticeReceived) {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"responseVideoControlDisplayResolution !m_bFirstResolutionNoticeReceived");
                        if (this.isConnectionSharedAtLaunch()) {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"responseVideoControlDisplayResolution shared connection at launch");
                            this.cmdStartVideo();
                            this.cmdVideoGetColorDepth();
                            this.cmdVideoSetup();
                        } else {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"responseVideoControlDisplayResolution no shared connection at launch");
                        }
                    } else if (this.getVideoEncodingType() == 1) {
                        this.getApplianceWindow().resizeVideoWindow(s, s2);
                        this.cmdRefreshPane();
                    } else if (this.getApplianceWindow() instanceof JFrameFullScreen) {
                        this.getApplianceWindow().resizeVideoWindow(s, s2);
                        this.cmdRefreshPane();
                    }
                    this.m_bFirstResolutionNoticeReceived = true;
                }
                catch (Exception exception) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exception.toString(), (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.toString(), (Throwable)exception);
        }
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
    }

    private void responseVideoControlDisplayResolutionNotAttained(PacketProtocolAVSP packetProtocolAVSP) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"responseVideoControlDisplayResolutionNotAttained");
        short s = this.getPersistentDataReference().getPanedWidth();
        short s2 = this.getPersistentDataReference().getPanedHeight();
        try {
            s = packetProtocolAVSP.getXResolution();
            s2 = packetProtocolAVSP.getYResolution();
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
        Dimension dimension = new Dimension(s, s2);
        Dimension dimension2 = JFrameViewer.getNextResolution(dimension);
        try {
            this.getPersistentDataReference().setPanedWidth((short)dimension2.width, true);
            this.getPersistentDataReference().setPanedHeight((short)dimension2.height, true);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
        try {
            this.cmdStartVideo();
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
        }
    }

    private void initVideo() throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"initVideo");
        int n = 15;
        boolean bl = false;
        if (this.getPersistentDataReference().wasColorDepthSaved()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"initVideo color depth was saved");
            n = this.getPersistentDataReference().getColorDepth();
            bl = this.getPersistentDataReference().isBackgroundRefresh();
        } else if (this.isPPPConnection()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"initVideo PPP connection, using 9 bit color depth");
            n = 9;
            this.getPersistentDataReference().setColorDepth((byte)n);
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"initVideo using default color depth");
            this.getPersistentDataReference().setColorDepth((byte)n);
        }
        this.m_nColorDepth = n;
        this.cmdVideoSetColorDepth(n, bl);
        if (this.getPersistentDataReference().wereVideoParametersSaved()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"initVideo video parameters were saved");
            if (this.getPersistentDataReference().getVideoMode() != 0) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"initVideo video mode != 0, calling cmdVideoParameters");
                int n2 = this.getPersistentDataReference().getPanedWidth() / this.getPersistentDataReference().getPanedHeight();
                if (n2 < 1 || n2 > 2) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"ApplianceSessionAVSP.initVideo the video with or height parameters are messed up,  probably as a result of scan closed and not having access to the database. Restoring default width, height and decimation factor of 1024x768, 1");
                    this.getPersistentDataReference().setPanedWidth((short)1024);
                    this.getPersistentDataReference().setPanedHeight((short)768);
                    this.getPersistentDataReference().setDecimationFactor(1);
                    try {
                        this.getPersistentDataReference().setAll();
                    }
                    catch (ExceptionRequestFailed exceptionRequestFailed) {
                        // empty catch block
                    }
                    this.getApplianceWindow().resizeVideoWindow(1024, 768);
                    this.cmdStartVideo();
                } else {
                    this.cmdVideoParameters(this.getPersistentDataReference().getVideoMode(), this.getPersistentDataReference().getPanedWidth(), this.getPersistentDataReference().getPanedHeight(), this.getPersistentDataReference().isFullScale() && !this.m_bThumbnail, this.getPersistentDataReference().getNoiseThreshold(), this.getPersistentDataReference().getPriorityPixelThreshold(), this.getPersistentDataReference().getCaptureWidth(), this.getPersistentDataReference().getPixelFineAdjust(), this.getPersistentDataReference().getCaptureVertPosition(), this.getPersistentDataReference().getCaptureHorzPosition(), this.getPersistentDataReference().getBrightness(), this.getPersistentDataReference().getContrast(), this.getPersistentDataReference().getColorDepth(), this.getPersistentDataReference().getColorDepth() != 3);
                }
            } else {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"initVideo video mode == 0, sending individual video parameters");
                this.cmdVideoBrightness(this.getPersistentDataReference().getBrightness());
                this.cmdVideoContrast(this.getPersistentDataReference().getContrast());
                this.cmdVideoHorzCapture(this.getPersistentDataReference().getCaptureHorzPosition());
                this.cmdVideoVertCapture(this.getPersistentDataReference().getCaptureVertPosition());
                this.cmdVideoWidth(this.getPersistentDataReference().getCaptureWidth());
                this.cmdVideoFine(this.getPersistentDataReference().getPixelFineAdjust());
                this.cmdVideoNoiseThreshold(this.getPersistentDataReference().getNoiseThreshold());
                this.cmdVideoPriorityThreshold(this.getPersistentDataReference().getPriorityPixelThreshold());
                this.getApplianceWindow().resizeVideoWindow(this.getPersistentDataReference().getPanedWidth(), this.getPersistentDataReference().getPanedHeight());
                this.cmdStartVideo();
            }
        } else {
            if (this.isPPPConnection()) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"initVideo video parameters not saved, is PPP connection setting resolution to 640x480");
                try {
                    this.getPersistentDataReference().setPanedWidth((short)640);
                    this.getPersistentDataReference().setPanedHeight((short)480);
                }
                catch (Exception exception) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                }
            }
            this.cmdVideoGetColorDepth();
            this.cmdVideoSetup();
            this.getApplianceWindow().resizeVideoWindow(this.getPersistentDataReference().getPanedWidth(), this.getPersistentDataReference().getPanedHeight());
            this.cmdStartVideo();
        }
        this.cmdThrottleVideo(this.getPersistentDataReference().getThrottleType());
        this.cmdMouseAlign();
    }

    private void responseVideoControl(PacketProtocolAVSP packetProtocolAVSP) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(responseVideoSetupResp)");
        ApplianceSessionInfo applianceSessionInfo = this.getPersistentData();
        short s = packetProtocolAVSP.getBrightness();
        short s2 = packetProtocolAVSP.getContrast();
        short s3 = packetProtocolAVSP.getHorizontalPosition();
        short s4 = packetProtocolAVSP.getVerticalPosition();
        short s5 = packetProtocolAVSP.getWidth();
        short s6 = packetProtocolAVSP.getFine();
        short s7 = packetProtocolAVSP.getNoiseThreshold();
        short s8 = packetProtocolAVSP.getPriorityThreshold();
        short s9 = packetProtocolAVSP.getHorizontalResolution();
        short s10 = packetProtocolAVSP.getVerticalResolution();
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
        applianceSessionInfo.setBrightness(s);
        applianceSessionInfo.setContrast(s2);
        applianceSessionInfo.setCaptureHorzPosition(s3);
        applianceSessionInfo.setCaptureVertPosition(s4);
        applianceSessionInfo.setCaptureWidth(s5);
        applianceSessionInfo.setPixelFineAdjust(s6);
        applianceSessionInfo.setNoiseThreshold(s7);
        applianceSessionInfo.setPriorityPixelThreshold(s8);
        applianceSessionInfo.setVideoParametersSaved(true);
        try {
            this.getPersistentDataReference().setAll(applianceSessionInfo);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
        if (this.isManualVideoAdjustDlgDisplayed()) {
            this.getManualVideoAdjustDlg().UpdateDisplay(s, s2, s3, s4, s5, s6, s9, s10, s7, s8);
        }
    }

    private void responseVideoControlEnableScaling(PacketProtocolAVSP packetProtocolAVSP) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(responseVideoControlEnableScaling)");
        boolean bl = packetProtocolAVSP.getEnableScaling();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(responseVideoControlEnableScaling)   bScalingEnabled=" + bl));
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
        this.setScalingControlsEnabled(bl);
        this.m_windowAppliance.enableScalingControls(bl);
        this.cmdGetConnectedUsers();
    }

    private void responseVideoControlColorDepth(PacketProtocolAVSP packetProtocolAVSP) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(responseVideoControlColorDepth)");
        this.m_nColorDepth = packetProtocolAVSP.getColorDepth();
        boolean bl = packetProtocolAVSP.getBackgroundRefresh();
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
        ApplianceSessionInfo applianceSessionInfo = this.getPersistentData();
        applianceSessionInfo.setColorDepth((byte)this.m_nColorDepth);
        applianceSessionInfo.setColorDepthSaved(true);
        applianceSessionInfo.setBackgroundRefresh(bl);
        try {
            this.getPersistentDataReference().setAll(applianceSessionInfo);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    private void responseUserDisconnect(PacketProtocolAVSP packetProtocolAVSP) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(responseUserDisconnect)");
        byte by = packetProtocolAVSP.getReason();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(responseUserDisconnect) nReason=" + by));
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
        this.getApplianceWindow().activateSingleCursorMode(false);
        this.m_bDisplayUserNoticeOnNetworkError = false;
        if (this.m_bDisplaySessionDisconnectNotice) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(responseUserDisconnect calling ThreadNotifyUserOfPendingDisconnect)");
            new ThreadNotifyUserOfPendingDisconnect(this.getApplianceName(), by);
        }
    }

    private void responseUserDisconnectWithTimeout(PacketProtocolAVSP packetProtocolAVSP) throws IOException {
        Component component;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(responseUserDisconnectWithTimeout)");
        boolean bl = packetProtocolAVSP.canUserRejectPreemption();
        String string = packetProtocolAVSP.getUserRequestingPreemption();
        int n = packetProtocolAVSP.getPreemptionTimeout();
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
        if (this.m_bThumbnail) {
            this.m_bDisplayUserNoticeOnNetworkError = false;
            this.terminateSession();
            return;
        }
        if (this.m_dlgPreemptWarning != null) {
            this.cmdRejectPreemptionRequest();
            return;
        }
        for (component = (Component)((Object)this.getApplianceWindow()); component != null && !(component instanceof Frame); component = component.getParent()) {
        }
        if (this.m_dlgPreemptionRequestCancelled != null) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(responseUserDisconnectWithTimeout m_dlgPreemptionRequestCancelled != null, setting it not visible)");
            this.m_dlgPreemptionRequestCancelled.setVisible(false);
        }
        if (LinuxLibrary.isLibraryLoaded() || SolarisLibrary.isLibraryLoaded()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(responseUserDisconnectWithTimeout) LinuxLibrary is loaded");
            if (component instanceof InterfaceNativeKeyEventListener) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(responseUserDisconnectWithTimeout) stopping Linux key listener");
                if (LinuxLibrary.isLibraryLoaded()) {
                    LinuxLibrary.stopKeyListener((InterfaceNativeKeyEventListener)((Object)component));
                } else {
                    SolarisLibrary.stopKeyListener((InterfaceNativeKeyEventListener)((Object)component));
                }
            }
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(responseUserDisconnectWithTimeout) bringing up preempt warning dialog");
        this.m_dlgPreemptWarning = new JDialogPreemptWarning((Frame)component, bl, string, n, this);
        this.m_dlgPreemptWarning.setVisible(true);
    }

    private void responseUserCancelDisconnect(PacketProtocolAVSP packetProtocolAVSP) throws IOException {
        byte by = packetProtocolAVSP.getCancelReason();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(responseUserCancelDisconnect) bCancelReason=" + by));
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
        if (this.m_bThumbnail) {
            return;
        }
        switch (by) {
            case 0: {
                if (this.m_dlgPreemptWarning != null) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"(responseUserCancelDisconnect) closing m_dlgPreemptWarning");
                    this.m_dlgPreemptWarning.setVisible(false);
                }
                if (this.m_dlgPreemptionRequestCancelled != null) break;
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)"(responseUserCancelDisconnect) about to show message box for Preemption Request Cancelled");
                        JOptionPane.showMessageDialog((Component)((Object)ApplianceSessionAVSP.this.m_windowAppliance), RES.getString("ApplianceSessionAVSP_PREEMPTION_REQUEST_CANCELED"));
                    }
                });
                thread.start();
                break;
            }
            case 1: {
                if (this.m_dlgPreemptWarning != null) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"(responseUserCancelDisconnect) closing m_dlgPreemptWarning");
                    this.m_dlgPreemptWarning.setVisible(false);
                }
                if (this.m_dlgPreemptionRequestCancelled != null) break;
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)"(responseUserCancelDisconnect) about to show message box for Preemption Request Cancelled");
                        JOptionPane.showMessageDialog((Component)((Object)ApplianceSessionAVSP.this.m_windowAppliance), RES.getString("ApplianceSessionAVSP_PREEMPTION_REQUEST_CANCELED_BY_PRIMARY"));
                    }
                });
                thread.start();
                break;
            }
            case 2: {
                if (this.m_dlgShareResponse == null) break;
                try {
                    this.m_dlgShareResponse.setVisible(false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_dlgShareResponse = null;
                this.m_bShareRequestPending = false;
                break;
            }
            case 3: {
                if (this.m_dlgShareResponse != null) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"(responseUserCancelDisconnect) closing m_dlgShareResponse");
                    try {
                        this.m_dlgShareResponse.setVisible(false);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.m_dlgShareResponse = null;
                    this.m_bShareRequestPending = false;
                }
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)"(responseUserCancelDisconnect) about to show message box for Share Request Cancelled");
                        JOptionPane.showMessageDialog((Component)((Object)ApplianceSessionAVSP.this.m_windowAppliance), RES.getString("ApplianceSessionAVSP_SHARE_REQUEST_CANCELED"));
                    }
                });
                thread.start();
            }
        }
    }

    public void closingPreemptWarningDlg() {
        this.m_dlgPreemptWarning = null;
    }

    private void responseUserShareRequest(PacketProtocolAVSP packetProtocolAVSP, final boolean bl) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"resopnseUserShareRequest");
        if (!this.isRunIOQueueSet()) {
            return;
        }
        final short s = packetProtocolAVSP.getShareRequestId();
        final byte by = packetProtocolAVSP.getShareRequestTimeout();
        final String string = packetProtocolAVSP.getShareRequestUsername();
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
        if (this.m_bShareRequestPending) {
            this.respondToShareRequest(bl, s, 1);
            return;
        }
        this.m_bShareRequestPending = true;
        this.getApplianceWindow().activateSingleCursorMode(false);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ApplianceSessionAVSP.this.getApplianceWindow().bringWindowToTop();
                if (bl) {
                    ApplianceSessionAVSP.this.m_dlgShareResponse = new JDialogShareResponse((Frame)((Object)ApplianceSessionAVSP.this.getApplianceWindow()), ApplianceSessionAVSP.this, s, by, string, ApplianceSessionAVSP.this.m_szHelpURL);
                } else {
                    ApplianceSessionAVSP.this.m_dlgShareResponse = new JDialogShareResponse((Frame)((Object)ApplianceSessionAVSP.this.getApplianceWindow()), ApplianceSessionAVSP.this, ApplianceSessionAVSP.this.m_szHelpURL);
                }
                ApplianceSessionAVSP.this.m_dlgShareResponse.setModal(true);
                ApplianceSessionAVSP.this.m_dlgShareResponse.setVisible(true);
                int n = 1;
                if (ApplianceSessionAVSP.this.m_dlgShareResponse != null) {
                    n = ApplianceSessionAVSP.this.m_dlgShareResponse.getShareResponse();
                }
                Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)("resopnseUserShareRequest returned from JDialogShareResponse nShare=" + n));
                if (n == 2 || n == 3) {
                    ApplianceSessionAVSP.this.setConnectionShared(true);
                    ApplianceSessionAVSP.this.setConnectionType(3);
                    if (ApplianceSessionAVSP.this.getPersistentDataReference().isAutoScale() && ApplianceSessionAVSP.this.getPersistentDataReference().getDecimationFactor() > 1) {
                        ApplianceSessionInfo applianceSessionInfo = null;
                        try {
                            applianceSessionInfo = ApplianceSessionAVSP.this.getPersistentData();
                            applianceSessionInfo.setDecimationFactor(1);
                            applianceSessionInfo.setPanedWidth((short)640);
                            applianceSessionInfo.setPanedHeight((short)480);
                            ApplianceSessionAVSP.this.getPersistentDataReference().setAll(applianceSessionInfo);
                            Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)"(processCmdShareResponse) calling cmdStartVideo to restore 640x480");
                            ApplianceSessionAVSP.this.cmdStartVideo();
                        }
                        catch (Exception exception) {
                            Trace.logError((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                        }
                    }
                }
                ApplianceSessionAVSP.this.respondToShareRequest(bl, s, n);
                ApplianceSessionAVSP.this.m_dlgShareResponse = null;
                ApplianceSessionAVSP.this.m_bShareRequestPending = false;
            }
        });
        thread.start();
    }

    private void respondToShareRequest(boolean bl, short s, int n) {
        try {
            DSData dSData = this.m_queueAvailableKM.getData();
            PacketProtocolAVSP packetProtocolAVSP = new PacketProtocolAVSP();
            if (bl) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("resopnseUserShareRequest sending CMD_USER_SHARE_REQUEST_WITH_ID nShare=" + n));
                packetProtocolAVSP.setCommand(dSData, (short)1043, (byte)n, (byte)0, s);
            } else {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("resopnseUserShareRequest sending CMD_USER_SHARE_REQUEST nShare=" + n));
                packetProtocolAVSP.setCommand(dSData, (short)1040, (byte)n);
            }
            this.m_queueOutputKM.put(packetProtocolAVSP.getData());
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
        }
    }

    private void responseSharedUsers(PacketProtocolAVSP packetProtocolAVSP) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(responseSharedUsers)");
        byte by = packetProtocolAVSP.getNumberOfUsers();
        String[] stringArray = packetProtocolAVSP.getUsers(this.m_nApplicationCode);
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
        for (int i = 0; i < this.m_vConnectedUsersListeners.size(); ++i) {
            InterfaceConnectedUsersListener interfaceConnectedUsersListener = (InterfaceConnectedUsersListener)this.m_vConnectedUsersListeners.get(i);
            interfaceConnectedUsersListener.connectedUsersResponse(by, stringArray);
        }
        this.setConnectionShared(by > 1);
        if (this.m_nConnectionType != 5 && this.m_nConnectionType != 6 && this.m_nConnectionType != 2) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"responseSharedUsers connection type not passive stealth or exclusive");
            if (this.areScalingControlsEnabled()) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("responseSharedUsers scaling controls enabled, number of users=" + by));
                this.setConnectionType(by > 1 ? 3 : 1);
            } else {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"responseSharedUsers scaling controls not enabled, still a secondary shared user");
                this.setConnectionType(4);
            }
        }
    }

    private void responseExclusiveMode(PacketProtocolAVSP packetProtocolAVSP) throws IOException {
        boolean bl = packetProtocolAVSP.isExclusiveModeActive();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(responseExclusiveMode bExclusiveMode=" + bl));
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
        if (bl) {
            this.setConnectionType(2);
            this.setConnectionShared(false);
        } else {
            this.setConnectionType(1);
        }
    }

    private void responseLocked(PacketProtocolAVSP packetProtocolAVSP) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"responseLocked");
        this.setLockedMode((packetProtocolAVSP.getLockedStatus() & 1) == 1);
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
        this.getApplianceWindow().notifyLockedModeChanged();
    }

    private void responseReserve(PacketProtocolAVSP packetProtocolAVSP) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"responseReserve");
        this.setReserveMode((packetProtocolAVSP.getReserveStatus() & 1) == 1);
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
        this.getApplianceWindow().notifyReserveModeChanged();
    }

    private void responseVmAvailable(PacketProtocolAVSP packetProtocolAVSP) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"responseVmAvailable");
        this.setVirtualMediaAvailableForTD((packetProtocolAVSP.getVmAvailableStatus() & 1) == 1);
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
        this.getApplianceWindow().notifyVmAvailableChanged();
    }

    private void responseUserPrivilegeParameters(PacketProtocolAVSP packetProtocolAVSP) throws IOException {
        Properties properties = packetProtocolAVSP.getUserPrivilegeProperties();
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Boolean bl;
            String string = (String)enumeration.nextElement();
            if (string.equalsIgnoreCase(new String("3"))) {
                bl = (Boolean)properties.get(string);
                this.setExclusiveModeAvailable(bl);
                continue;
            }
            if (string.equalsIgnoreCase(new String("2"))) {
                bl = (Boolean)properties.get(string);
                this.setReserveMode(bl);
                continue;
            }
            if (string.equalsIgnoreCase(new String("1"))) {
                bl = (Boolean)properties.get(string);
                this.setUserHasRightsToLaunchVirtualMedia(bl);
                continue;
            }
            if (!string.equalsIgnoreCase(new String("4"))) continue;
            bl = (Boolean)properties.get(string);
            this.setEncryptVirtualMedia(bl);
        }
        properties.clear();
    }

    private void responseProtcolVersion(PacketProtocolAVSP packetProtocolAVSP) throws IOException {
        this.m_nProtocolVersionMajor = packetProtocolAVSP.getProtocolMajorVersion();
        this.m_nProtocolVersionMinor = packetProtocolAVSP.getProtocolMinorVersion();
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
    }

    public void initPixelArray() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(initPixelArray) no parameters");
        this.initPixelArray(this.m_windowAppliance.getPanelAppliance().getCurrentBitmapWidth(), this.m_windowAppliance.getPanelAppliance().getCurrentImageType());
    }

    public void initPixelArray(int n, int n2) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(initPixelArray) nWidth=" + n));
        this.m_dsPacketVideoAVC.initPixelArray(n, n2);
        this.m_dsPacketVideoDVC15.initPixelArray(n, n2);
        this.m_dsPacketVideoDVC7.initPixelArray(n, n2);
        this.m_bPixelArrayInitDone = true;
    }

    public void setAVCPixels(int n, int n2, int n3, int n4, byte[] byArray) {
        if (!this.m_bPixelArrayInitDone) {
            this.initPixelArray();
        }
        this.m_dsPacketVideoAVC.setPixels(n, n2, n3, n4, byArray);
    }

    public int getDvcCurrentPixel() {
        if (this.m_dsPacketVideoType == -126) {
            return this.m_dsPacketVideoDVC7.getDvcCurrentPixel();
        }
        return this.m_dsPacketVideoDVC15.getDvcCurrentPixel();
    }

    public void setDvcCurrentPixel(int n) {
        if (this.m_dsPacketVideoType == -126) {
            this.m_dsPacketVideoDVC7.setDvcCurrentPixel(n);
        } else {
            this.m_dsPacketVideoDVC15.setDvcCurrentPixel(n);
        }
    }

    private void responseMouseAck(PacketProtocolAVSP packetProtocolAVSP) throws IOException {
        this.decrementUnacknowledgedMousePacketCount(packetProtocolAVSP.getAckCount());
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
    }

    private void responseMouseAcc(PacketProtocolAVSP packetProtocolAVSP) throws IOException {
        int n = packetProtocolAVSP.getAccSetting();
        int n2 = 4;
        switch (n) {
            case 0: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 5;
                break;
            }
            case 3: {
                n2 = 6;
                break;
            }
            default: {
                n2 = 4;
            }
        }
        this.m_queueAvailableKM.put(packetProtocolAVSP.getData());
        ((JFrameViewerCmdPanel)this.m_windowAppliance).updateMouseAcceleration(n2);
    }

    public void displayManualVideoAdjustDlg() {
        super.displayManualVideoAdjustDlg();
    }

    public void enableInactivityTimeout(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("enableInactivityTimeout nMinutes=" + n));
        this.m_bActivityOccurred = false;
        this.m_threadInactivityTimeout = new ThreadInactivityTimeout(n);
        this.m_threadInactivityTimeout.start();
    }

    public void setMouseThrottle(int n) {
        this.m_nMouseThrottleTime = n;
    }

    static /* synthetic */ boolean access$4200(ApplianceSessionAVSP applianceSessionAVSP) {
        return applianceSessionAVSP.m_bActivityOccurred;
    }

    static /* synthetic */ boolean access$4202(ApplianceSessionAVSP applianceSessionAVSP, boolean bl) {
        applianceSessionAVSP.m_bActivityOccurred = bl;
        return applianceSessionAVSP.m_bActivityOccurred;
    }

    class ThreadInactivityTimeout
    extends ThreadContinuous {
        int m_nMinutesElapsed = 0;
        int m_nSecondsElapsed = 0;
        int m_nMaxMinutesInactivity = 0;

        ThreadInactivityTimeout(int n) {
            super("Elapsed Time Dialog Counter", 1000L);
            this.m_nMaxMinutesInactivity = n;
        }

        protected void performTask() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ ThreadInactivityTimeout this$1;
                {
                    this.this$1 = threadInactivityTimeout;
                }

                public void run() {
                    try {
                        if (ApplianceSessionAVSP.access$4200(ThreadInactivityTimeout.access$4100(this.this$1))) {
                            this.this$1.m_nMinutesElapsed = 0;
                            this.this$1.m_nSecondsElapsed = 0;
                            ApplianceSessionAVSP.access$4202(ThreadInactivityTimeout.access$4100(this.this$1), false);
                        } else if (++this.this$1.m_nSecondsElapsed >= 60) {
                            ++this.this$1.m_nMinutesElapsed;
                            this.this$1.m_nSecondsElapsed = 0;
                            if (this.this$1.m_nMinutesElapsed >= this.this$1.m_nMaxMinutesInactivity) {
                                ThreadInactivityTimeout.access$4100(this.this$1).getApplianceWindow().activateSingleCursorMode(false);
                                ThreadInactivityTimeout.access$4100(this.this$1).getApplianceWindow().bringWindowToTop();
                                Frame frame = null;
                                if (ThreadInactivityTimeout.access$4100(this.this$1).getApplianceWindow() instanceof Frame) {
                                    frame = (Frame)((Object)ThreadInactivityTimeout.access$4100(this.this$1).getApplianceWindow());
                                }
                                JDialogInactivityTimeout jDialogInactivityTimeout = new JDialogInactivityTimeout(frame, ThreadInactivityTimeout.access$4100(this.this$1).getTitle(), this.this$1.m_nMaxMinutesInactivity);
                                jDialogInactivityTimeout.setModal(true);
                                jDialogInactivityTimeout.setVisible(true);
                                if (!jDialogInactivityTimeout.wasOKButtonPressed()) {
                                    Trace.logInfo((String)"VideoViewerTrace.ApplianceSessionAVSP", (String)"(ThreadInactivityTimeout) sesson timed out, calling terminateSession");
                                    ApplianceSessionAVSP.access$1600(ThreadInactivityTimeout.access$4100(this.this$1)).terminate();
                                }
                                this.this$1.m_nMinutesElapsed = 0;
                                this.this$1.m_nSecondsElapsed = 0;
                                ApplianceSessionAVSP.access$4202(ThreadInactivityTimeout.access$4100(this.this$1), false);
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }

        static /* synthetic */ ApplianceSessionAVSP access$4100(ThreadInactivityTimeout threadInactivityTimeout) {
            return threadInactivityTimeout.ApplianceSessionAVSP.this;
        }
    }

    private class DSPacketIO {
        private DataInputStreamEndian m_dis;
        private DataOutputStreamEndian m_dos;
        private ApplianceSession.DSQueue m_queueAvailable;
        private boolean m_bRunPacketIO;
        private Object m_syncPacketIO = new Object();

        private DSPacketIO(DataInputStreamEndian dataInputStreamEndian, DataOutputStreamEndian dataOutputStreamEndian, ApplianceSession.DSQueue dSQueue) throws IOException {
            this.m_dis = dataInputStreamEndian;
            this.m_dos = dataOutputStreamEndian;
            this.m_queueAvailable = dSQueue;
            this.m_bRunPacketIO = true;
        }

        protected DSData readDSData() throws IOException, Exception {
            DSData dSData = this.m_queueAvailable.getData();
            byte[] byArray = dSData.getData();
            int n = 0;
            while (this.isRunPacketIOSet()) {
                try {
                    int n2;
                    int n3 = 0;
                    for (n2 = 0; n2 < 8; n2 += n3) {
                        n3 = this.m_dis.read(byArray, n2, 8 - n2);
                        if (n3 >= 0) {
                            continue;
                        }
                        Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)("(readDSData) read error:" + n3));
                        this.m_queueAvailable.put(dSData);
                        return null;
                    }
                    debugPulse.writeParallelPort((byte)4);
                    n = dSData.getPacketLength() - 8;
                    for (n2 = 0; n2 < n; n2 += n3) {
                        n3 = this.m_dis.read(byArray, 8 + n2, n - n2);
                        if (n3 >= 0) {
                            continue;
                        }
                        Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)("(readDSData) read error:" + n3));
                        this.m_queueAvailable.put(dSData);
                        return null;
                    }
                    dSData.setUsedLength(8 + n);
                    return dSData;
                }
                catch (IOException iOException) {
                    if (!this.isRunPacketIOSet()) continue;
                    Trace.logError((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)("(DSData readDSData)IOException: " + iOException.getMessage() + " Packet data: " + byArray[0] + " " + byArray[1] + " " + byArray[2] + " " + byArray[3] + " " + byArray[4] + " " + byArray[5] + " " + byArray[6] + " " + byArray[7] + " Packet length: " + n + " Socket Port: " + this.m_dis.getSocket().getPort()), (Throwable)iOException);
                    throw iOException;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    Trace.logError((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)("(DSData readDSData)IndexOutOfBoundsException: " + indexOutOfBoundsException.getMessage() + " Packet data: " + byArray[0] + " " + byArray[1] + " " + byArray[2] + " " + byArray[3] + " " + byArray[4] + " " + byArray[5] + " " + byArray[6] + " " + byArray[7] + " Packet length: " + n + " Socket Port: " + this.m_dis.getSocket().getPort()), (Throwable)indexOutOfBoundsException);
                    throw indexOutOfBoundsException;
                }
                catch (Exception exception) {
                    if (!this.isRunPacketIOSet()) continue;
                    Trace.logError((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)("(DSData readDSData)Exception: " + exception.getMessage() + " Packet data: " + byArray[0] + " " + byArray[1] + " " + byArray[2] + " " + byArray[3] + " " + byArray[4] + " " + byArray[5] + " " + byArray[6] + " " + byArray[7] + " Packet length: " + n + " Socket Port: " + this.m_dis.getSocket().getPort()), (Throwable)exception);
                    throw exception;
                }
            }
            return null;
        }

        private void writeDSData(DSData dSData) throws IOException, SocketException {
            this.m_dos.write(dSData.getData(), 0, dSData.getUsedLength());
            this.m_dos.flush();
            debugPulse.writeParallelPort((byte)2);
            this.m_queueAvailable.put(dSData);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void setRunPacketIO(boolean bl) {
            Object object = this.m_syncPacketIO;
            synchronized (object) {
                this.m_bRunPacketIO = bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isRunPacketIOSet() {
            Object object = this.m_syncPacketIO;
            synchronized (object) {
                return this.m_bRunPacketIO;
            }
        }
    }

    private class DSQueueKMOutput
    extends ApplianceSession.DSQueue {
        private DSQueueKMOutput(int n) {
            super(n);
        }

        private DSQueueKMOutput(DSData[] dSDataArray) {
            super(dSDataArray);
        }

        public void put(Object object) {
            super.put(object);
            ApplianceSessionAVSP.this.setLastKMPacketSentTime(System.currentTimeMillis());
        }
    }

    private class ThreadNotifyUserOfPendingDisconnect
    extends Thread {
        int m_nDisconnectReason;
        String m_szServerName;

        private ThreadNotifyUserOfPendingDisconnect(String string, int n) {
            Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)"(ThreadNotifyUserOfPendingDisconnect constructor)");
            this.m_szServerName = string;
            this.m_nDisconnectReason = n;
            this.start();
        }

        public void run() {
            Object object;
            Object[] objectArray;
            Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)"(ThreadNotifyUserOfPendingDisconnect run)");
            String string = BrandNaming.getServerName(ApplianceSessionAVSP.this.wasStartedFromCommandLine(), true);
            String string2 = "";
            if (ApplianceSessionAVSP.this.isLockedMode() && !ApplianceSessionAVSP.this.isReserveModeActive()) {
                string2 = RES.getString("ApplianceSessionAVSP_VM_SESSION_CLOSED_DUE_TO_LOCK");
            }
            switch (this.m_nDisconnectReason) {
                case 0: {
                    Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)"(ThreadNotifyUserOfPendingDisconnect case 0)");
                    objectArray = new Object[]{string, this.m_szServerName, RES.getString("ApplianceSessionAVSP_Disconnect_Reason_Admin")};
                    ApplianceSessionAVSP.this.logEventSession(2, RES.getString("ApplianceSessionAVSP_Terminate_Reason_Admin_Terminated"));
                    break;
                }
                case 1: {
                    Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)"(ThreadNotifyUserOfPendingDisconnect case 1)");
                    objectArray = new Object[]{string, this.m_szServerName, RES.getString("ApplianceSessionAVSP_Disconnect_Reason_Idle_Timeout")};
                    ApplianceSessionAVSP.this.logEventSession(2, RES.getString("ApplianceSessionAVSP_Terminate_Reason_Idle_Timeout"));
                    break;
                }
                case 2: {
                    Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)"(ThreadNotifyUserOfPendingDisconnect case 2)");
                    object = new Object[]{BrandNaming.getApplianceName(ApplianceSessionAVSP.this.wasStartedFromCommandLine(), true)};
                    String string3 = MessageFormat.format(RES.getString("ApplianceSessionAVSP_Disconnect_Reason_Reboot"), object);
                    objectArray = new Object[]{string, this.m_szServerName, string3};
                    ApplianceSessionAVSP.this.logEventSession(2, RES.getString("ApplianceSessionAVSP_Terminate_Reason_Appliance_Reboot"));
                    break;
                }
                case 3: {
                    Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)"(ThreadNotifyUserOfPendingDisconnect case 3)");
                    Object[] objectArray2 = new Object[]{BrandNaming.getDsrIqName(ApplianceSessionAVSP.this.wasStartedFromCommandLine(), true)};
                    String string4 = MessageFormat.format(RES.getString("ApplianceSessionAVSP_Disconnect_Reason_RIP_Upgrading"), objectArray2);
                    objectArray = new Object[]{string, this.m_szServerName, string4};
                    ApplianceSessionAVSP.this.logEventSession(2, RES.getString("ApplianceSessionAVSP_Terminate_Reason_Dsriq_Upgrading"));
                    break;
                }
                case 4: {
                    Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)"(ThreadNotifyUserOfPendingDisconnect case 4)");
                    objectArray = new Object[]{string, this.m_szServerName, RES.getString("ApplianceSessionAVSP_Disconnect_Reason_Preempted_Other_User")};
                    ApplianceSessionAVSP.this.logEventSession(3, "Other User");
                    break;
                }
                case 5: {
                    Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)"(ThreadNotifyUserOfPendingDisconnect case 5)");
                    objectArray = new Object[]{string, this.m_szServerName, RES.getString("ApplianceSessionAVSP_Disconnect_Reason_Last_Non_Stealh_User_Has_Disconnected")};
                    ApplianceSessionAVSP.this.logEventSession(2, RES.getString("ApplianceSessionAVSP_Terminate_Reason_Last_Non_Stealth_User_Disconnected"));
                    break;
                }
                case 6: {
                    Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)"(ThreadNotifyUserOfPendingDisconnect case 6)");
                    objectArray = new Object[]{string, this.m_szServerName, RES.getString("ApplianceSessionAVSP_Disconnect_Reason_Primary_User_Has_Gone_Into_Exclusive_Mode")};
                    ApplianceSessionAVSP.this.logEventSession(2, RES.getString("ApplianceSessionAVSP_Terminate_Reason_User_Has_Gone_Into_Exclusive_Mode"));
                    break;
                }
                default: {
                    Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)"(ThreadNotifyUserOfPendingDisconnect case default)");
                    objectArray = new Object[]{string, this.m_szServerName, RES.getString("ApplianceSessionAVSP_Disconnect_Reason_Unknown")};
                    ApplianceSessionAVSP.this.logEventSession(2, RES.getString("ApplianceSessionAVSP_Terminate_Reason_Unknown"));
                }
            }
            ApplianceSessionAVSP.this.szMsg = MessageFormat.format(RES.getString("ApplianceSessionAVSP_Disconnect_Notice"), objectArray) + string2;
            ApplianceSessionAVSP.this.m_bDisconnectMessageCleared = false;
            if (LinuxLibrary.isLibraryLoaded() || SolarisLibrary.isLibraryLoaded()) {
                object = new JDialogMessage(null, ApplianceSessionAVSP.this.szMsg, false, RES.getString("JDialogPreemptionRequestCancelled_MESSAGE"));
                object.setModal(false);
                object.setFocusable(false);
                object.setFocusableWindowState(false);
            } else {
                Message.show(null, (String)ApplianceSessionAVSP.this.szMsg);
            }
            ApplianceSessionAVSP.this.m_bDisconnectMessageCleared = true;
        }
    }

    private class ThreadDSSendHeartbeat
    extends Thread {
        ThreadDSSendHeartbeat() {
            super("ThreadDSSendHeartbeat");
            this.setPriority(1);
            this.start();
        }

        public void run() {
            while (ApplianceSessionAVSP.this.isRunIOQueueSet()) {
                DSData dSData;
                long l = System.currentTimeMillis();
                if (l < ApplianceSessionAVSP.this.getLastVideoPacketReceivedTime() || l < ApplianceSessionAVSP.this.getLastKMPacketSentTime()) {
                    Trace.logError((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)("SYSTEM TIME BUG HAS OCCURRED CurrentSystemTime:" + l + " LastVideoPacketReceivedTime:" + ApplianceSessionAVSP.this.getLastVideoPacketReceivedTime() + " LastKMPacketSentTime:" + ApplianceSessionAVSP.this.getLastKMPacketSentTime()));
                    ApplianceSessionAVSP.this.setLastVideoPacketReceivedTime(l - 1001L);
                    ApplianceSessionAVSP.this.setLastKMPacketSentTime(l - 5001L);
                }
                if (l - ApplianceSessionAVSP.this.getLastVideoPacketReceivedTime() > 1000L && ApplianceSessionAVSP.this.getTotalVideoPacketsReceivedSinceLastConfirm() > 0) {
                    try {
                        dSData = ApplianceSessionAVSP.this.m_queueAvailableVideo.getData();
                        ApplianceSessionAVSP.this.m_dsPacketVideoConfirm.setCmdVideoConfirm(dSData, (byte)ApplianceSessionAVSP.this.getTotalVideoPacketsReceivedSinceLastConfirm());
                        ApplianceSessionAVSP.this.m_queueOutputVideo.put(ApplianceSessionAVSP.this.m_dsPacketVideoConfirm.getData());
                        ApplianceSessionAVSP.this.clearTotalVideoPacketsReceivedSinceLastConfirm();
                        ApplianceSessionAVSP.this.setLastVideoPacketReceivedTime(l);
                    }
                    catch (IOException iOException) {
                        Trace.logError((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)("(ThreadDSSendHeartbeat run) " + iOException.getMessage()), (Throwable)iOException);
                    }
                }
                if (l - ApplianceSessionAVSP.this.getLastKMPacketSentTime() > 5000L) {
                    try {
                        dSData = ApplianceSessionAVSP.this.m_queueAvailableKM.getData();
                        dSData.setUsedLength(16);
                        PacketProtocolAVSP packetProtocolAVSP = new PacketProtocolAVSP();
                        packetProtocolAVSP.setCommand(dSData, (short)1024);
                        ApplianceSessionAVSP.this.m_queueOutputKM.put(packetProtocolAVSP.getData());
                    }
                    catch (IOException iOException) {
                        Trace.logError((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)("(ThreadDSSendHeartbeat run) " + iOException.getMessage()), (Throwable)iOException);
                    }
                }
                try {
                    ThreadDSSendHeartbeat.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private class ThreadDSDataOutput
    extends Thread {
        ApplianceSession.DSQueue m_queueDataOutput;
        DSPacketIO m_dsDataPacketIO;

        ThreadDSDataOutput(ApplianceSession.DSQueue dSQueue, DSPacketIO dSPacketIO) {
            super("ThreadDSDataOutput");
            this.m_queueDataOutput = dSQueue;
            this.m_dsDataPacketIO = dSPacketIO;
            this.setPriority(5);
            this.start();
        }

        public void run() {
            boolean bl = false;
            while (ApplianceSessionAVSP.this.isRunIOQueueSet()) {
                try {
                    while (this.m_queueDataOutput.hasData()) {
                        DSData dSData = this.m_queueDataOutput.getData();
                        this.m_dsDataPacketIO.writeDSData(dSData);
                    }
                    this.m_queueDataOutput.waitForData();
                }
                catch (Exception exception) {
                    Trace.logError((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)("(ThreadDSDataOutput run) " + exception.getMessage()), (Throwable)exception);
                    if (ApplianceSessionAVSP.this.m_windowAppliance != null) {
                        ApplianceSessionAVSP.this.m_windowAppliance.terminate();
                    }
                    ApplianceSessionAVSP.this.setRunSession(false);
                    ApplianceSessionAVSP.this.displayNetworkErrorTerminationMessage();
                    break;
                }
            }
        }
    }

    private class ThreadDSDataInput
    extends Thread {
        ApplianceSession.DSQueue m_queueDataInput;
        DSPacketIO m_dsDataPacketIO;

        ThreadDSDataInput(ApplianceSession.DSQueue dSQueue, DSPacketIO dSPacketIO) {
            super("ThreadDSDataInput");
            this.m_queueDataInput = dSQueue;
            this.m_dsDataPacketIO = dSPacketIO;
            this.setPriority(5);
            this.start();
        }

        public void run() {
            while (ApplianceSessionAVSP.this.isRunIOQueueSet()) {
                try {
                    DSData dSData = this.m_dsDataPacketIO.readDSData();
                    if (dSData != null) {
                        this.m_queueDataInput.put(dSData);
                        continue;
                    }
                    try {
                        ThreadDSDataInput.sleep(10L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (Exception exception) {
                    if (ApplianceSessionAVSP.this.isRunIOQueueSet()) {
                        Trace.logError((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)("(ThreadDSDataInput run) " + exception.getMessage()), (Throwable)exception);
                    }
                    if (ApplianceSessionAVSP.this.m_windowAppliance != null) {
                        ApplianceSessionAVSP.this.m_windowAppliance.terminate();
                    } else {
                        ApplianceSessionAVSP.this.setRunSession(false);
                    }
                    ApplianceSessionAVSP.this.displayNetworkErrorTerminationMessage();
                    break;
                }
            }
        }
    }

    private class ThreadVideoProcess
    extends Thread {
        ThreadVideoProcess() {
            super("ThreadVideoProcess");
            this.setPriority(5);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            PacketProtocolAVSP packetProtocolAVSP = new PacketProtocolAVSP();
            try {
                while (ApplianceSessionAVSP.this.isSessionRunning()) {
                    boolean bl = false;
                    block12: while (ApplianceSessionAVSP.this.m_queueInputVideo.hasData()) {
                        packetProtocolAVSP.setData((DSData)ApplianceSessionAVSP.this.m_queueInputVideo.get());
                        switch (packetProtocolAVSP.getPacketTypeVideo()) {
                            case -128: {
                                bl = true;
                                ApplianceSessionAVSP.this.m_dsPacketVideoAVC.transferDataObject(packetProtocolAVSP);
                                ApplianceSessionAVSP.this.responseVideoAVC(ApplianceSessionAVSP.this.m_dsPacketVideoAVC);
                                continue block12;
                            }
                            case -127: {
                                bl = true;
                                ApplianceSessionAVSP.this.m_dsPacketVideoType = -127;
                                ApplianceSessionAVSP.this.m_dsPacketVideoDVC15.transferDataObject(packetProtocolAVSP);
                                ApplianceSessionAVSP.this.m_dsPacketVideoDVC15.checkDVCStartOfFrame();
                                ApplianceSessionAVSP.this.responseVideoDVC15(ApplianceSessionAVSP.this.m_dsPacketVideoDVC15);
                                continue block12;
                            }
                            case -126: {
                                bl = true;
                                ApplianceSessionAVSP.this.m_dsPacketVideoType = -126;
                                ApplianceSessionAVSP.this.m_dsPacketVideoDVC7.transferDataObject(packetProtocolAVSP);
                                ApplianceSessionAVSP.this.m_dsPacketVideoDVC7.checkDVCStartOfFrame();
                                ApplianceSessionAVSP.this.responseVideoDVC7(ApplianceSessionAVSP.this.m_dsPacketVideoDVC7);
                                continue block12;
                            }
                            case -123: {
                                ApplianceSessionAVSP.this.responseVideoTemporaryStop(packetProtocolAVSP);
                                continue block12;
                            }
                        }
                        Trace.logError((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)("run Unknown packet type: " + ApplianceSessionAVSP.this.m_dsPacket.getPacketType() + " packet header len:" + ApplianceSessionAVSP.this.m_dsPacket.getHeaderLength() + " packet len:" + ApplianceSessionAVSP.this.m_dsPacket.getPacketLength()));
                        ApplianceSessionAVSP.this.m_dsPacket.dumpPacketHeader();
                        ApplianceSessionAVSP.this.m_queueAvailableVideo.put(packetProtocolAVSP.getData());
                    }
                    if (bl) {
                        ApplianceSessionAVSP.this.setLastVideoPacketReceivedTime(System.currentTimeMillis());
                    }
                    ApplianceSessionAVSP.this.m_queueInputVideo.waitForData();
                }
            }
            catch (Exception exception) {
                Trace.logError((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            }
            finally {
                Trace.logInfo((String)ApplianceSessionAVSP.TRACE_CONTEXT, (String)"video queue hit its finally section, calling setRunSession(false)");
                ApplianceSessionAVSP.this.setRunSession(false);
            }
        }
    }
}

