/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionNotSupported;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.interfaces.InterfaceViewer3;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.KeyStroke;
import com.avocent.video.KeyboardMacro;
import com.avocent.video.KeyboardMacroGroup;
import com.avocent.video.MajorFunction;
import com.avocent.video.ManualVideoParameters;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class ApplianceSessionInfo
implements Serializable {
    public static final String CNAME = "ApplianceSessionInfo";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    public static final int EVENT_SESSON_STARTED = 0;
    public static final int EVENT_SESSON_STOPPED = 1;
    public static final int EVENT_SESSON_TERMINATED = 2;
    public static final int EVENT_SESSON_PREEMPTED = 3;
    public static final int EVENT_SESSON_FAILED_START = 4;
    public static final int EVENT_SESSON_SHARED = 5;
    public static final int EVENT_SESSON_SHARE_REFUSED = 6;
    public static final int EVENT_SESSON_SHARE_TIMED_OUT = 7;
    public static final int EVENT_SCAN_STARTED = 8;
    public static final int EVENT_SCAN_STOPPED = 9;
    public static final int EVENT_GLOBAL_MACRO_ADDED = 32;
    public static final int EVENT_GLOBAL_MACRO_MODIFIED = 33;
    public static final int EVENT_GLOBAL_MACRO_DELETED = 34;
    public static final int EVENT_GLOBAL_MACRO_GROUP_ADDED = 48;
    public static final int EVENT_GLOBAL_MACRO_GROUP_MODIFIED = 49;
    public static final int EVENT_GLOBAL_MACRO_GROUP_DELETED = 50;
    private static final byte DEFAULT_KVM_CHANNEL = 0;
    private static final byte DEFAULT_CASCADE_CHANNEL = 0;
    private static final byte DEFAULT_APPLIANCE_PORT = 0;
    private static final short DEFAULT_VIDEO_MODE = 0;
    private static final short DEFAULT_VIDEO_WIDTH = 1024;
    private static final short DEFAULT_VIDEO_HEIGHT = 768;
    private static final byte DEFAULT_COLOR_DEPTH = 9;
    private static final int DEFAULT_DECIMATION_FACTOR = 1;
    private static final int DEFAULT_MOUSE_SCALE_TYPE = 0;
    private static final double DEFAULT_MOUSE_GAIN = 1.0;
    private static final int DEFAULT_THROTTLE_TYPE = 0;
    private static final int DEFAULT_LOCAL_CURSOR_TYPE = 2;
    private static final int DEFAULT_HOST_SCAN_SET = 2;
    private static final int DEFAULT_SINGLE_CURSOR_TERMINATE_KEY = 121;
    private static final int DEFAULT_MENUACTIVATIONKEY = 44;
    private static final String DEFAULT_SELECTED_MACRO_GROUP = "";
    private static final int DEFAULT_THUMBNAIL_VIEW_TIME_PER_SERVER = 10;
    private static final int DEFAULT_THUMBNAIL_TIME_BETWEEN_SERVERS = 30;
    private static final int DEFAULT_TOOLBAR_HIDE_DELAY = 3;
    private static final String KEY_KVMCHANNEL = "KvmChannel";
    private static final String KEY_CASCADE1 = "Cascade1";
    private static final String KEY_APPLIANCEPORT = "AppliancePort";
    private static final String KEY_CONNECTED = "Connected";
    private static final String KEY_VIDEOMODE = "VideoMode";
    private static final String KEY_VIDEOWIDTH = "VideoWidth";
    private static final String KEY_VIDEOHEIGHT = "VideoHeight";
    private static final String KEY_MAXOUTPUTHEIGHT = "MaxOutputHeight";
    private static final String KEY_MAXOUTPUTWIDTH = "MaxOutputWidth";
    private static final String KEY_PANESCALED = "PaneScaled";
    private static final String KEY_AUTOSCALE = "AutoScale";
    private static final String KEY_FULLSCALE = "FullScale";
    private static final String KEY_DECIMATIONFACTOR = "DecimationFactor";
    private static final String KEY_MOUSESCALETYPE = "MouseScaleType";
    private static final String KEY_MOUSEXGAIN = "MouseXGain";
    private static final String KEY_MOUSEYGAIN = "MouseYGain";
    private static final String KEY_MOUSECUSTOMXGAIN = "MouseCustomXGain";
    private static final String KEY_MOUSECUSTOMYGAIN = "MouseCustomYGain";
    private static final String KEY_KEYBOARDPASSTHROUGH_NONFULLSCREEN = "KeyboardPassthroughMode";
    private static final String KEY_BACKGROUND_REFRESH = "BackgroundRefresh";
    private static final String KEY_MAINTAINASPECTRATIO = "MaintainAspectRatio";
    private static final String KEY_THROTTLETYPE = "ThrottleType";
    private static final String KEY_LOCALCURSORTYPE = "LocalCursorType";
    private static final String KEY_HOSTSCANSET = "HostScanSet";
    private static final String KEY_MACROSPREVIOUSLYSAVED = "MacrosPreviouslySaved";
    private static final String KEY_SELECTEDMACROGROUPID = "DEFAULTMACROGROUP";
    private static final String KEY_THUMBNAILVIEWTIMEPERSERVER = "ViewTimePerServer";
    private static final String KEY_THUMBNAILTIMEBETWEENSERVERS = "TimeBetweenServers";
    private static final String KEY_MACROGROUPNAMESNUMBER = "MACROGROUPNAMES_NUMBER";
    private static final String KEY_MACROGROUPNAMES = "MACROGROUPNAMES";
    public static final String KEY_MACROGROUPPREFIX = "GROUP_";
    private static final String KEY_MACRONAMESNUMBER = "MACRONAMES_NUMBER";
    private static final String KEY_MACRONAMES = "MACRONAMES";
    public static final String KEY_MACROPREFIX = "MACRO_";
    private static final String KEY_MACROICONINDEXPREFIX = "MACROICONINDEX_";
    private static final String KEY_MACROONTOOLBARRREFIX = "MACROONTOOLBAR_";
    private static final String KEY_SINGLECURSORTERMINATEKEY = "SingleCursorTerminateKey";
    private static final String KEY_MENUACTIVATIONKEY = "MenuActivationKey";
    private static final String KEY_PANEDWIDTH = "VideoWidth";
    private static final String KEY_PANEDHEIGHT = "VideoHeight";
    private static final String KEY_COLOR_DEPTH_SAVED = "ColorDepthSaved";
    private static final String KEY_COLOR_DEPTH = "DvcColorDepth";
    private static final String KEY_VIDEO_PARAMETERS_SAVED = "VideoParametersSaved";
    private static final String KEY_MANUAL_VIDEO_ADJUSTMENTS = "ManualVideoAdjustments";
    private static final String KEY_MANUAL_VIDEO_ADJUST = "ManualVideoAdjust";
    private static final String KEY_BRIGHTNESS = "Brightness";
    private static final String KEY_CONTRAST = "Contrast";
    private static final String KEY_CAPTURE_HORZ_POSITION = "CaptureHorzPosition";
    private static final String KEY_CAPTURE_VERT_POSITION = "CaptureVertPosition";
    private static final String KEY_CAPTURE_WIDTH = "CaptureWidth";
    private static final String KEY_PIXEL_FINE_ADJUST = "PixelFineAdjust";
    private static final String KEY_NOISE_THRESHOLD = "NoiseThreshold";
    private static final String KEY_PRIORITY_PIXEL_THRESHOLD = "Priority-PixelThreshold";
    private static final String KEY_TOOLBAR_FUNCTIONS = "Toolbar";
    public static final String KEY_FUNCTIONPREFIX = "FUNCTION_";
    private static final String KEY_FUNCTIONSPREVIOUSLYSAVED = "FunctionsPreviouslySaved";
    private static final String KEY_31FUNCTIONSPREVIOUSLYSAVED = "3_1_FunctionsPreviouslySaved";
    private static final String KEY_TOOLBARHIDEDELAY = "ToolbarHideDelay";
    private static final String KEY_PUSHPINSTATE = "PushPinState";
    private static final String KEY_LOCKTOOLBARSINGLECURSORFULLSCREEN = "LockToolbarSingleCursorFullScreen";
    private static final String KEY_DONTSHOWDLGSINGLECURSORFULLSCREEN = "DontShowDlgSingleCursorFullScreen";
    private static final String KEY_DONT_SHOW_MOUSE_SYNC_NOTIFICATION = "DontShowMouseSyncNotification";
    private Properties m_propGlobal = null;
    private Properties m_propUserDevice = null;
    private Properties m_propUser = null;
    private Object m_syncGlobal = new Object();
    private Object m_syncUser = new Object();
    private Object m_syncUserDevice = new Object();
    private InterfaceViewer3 m_interfaceViewer;
    private String m_szDeviceID;
    private ManualVideoParameters m_manualVideoParameters;
    private int m_nApplicationCode = 0;

    public ApplianceSessionInfo() {
    }

    public ApplianceSessionInfo(InterfaceViewer3 interfaceViewer3, String string, int n) {
        Object object;
        KeyboardMacroGroup keyboardMacroGroup;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"ApplianceSessionInfo constructor");
        this.m_interfaceViewer = interfaceViewer3;
        this.m_szDeviceID = string;
        this.m_nApplicationCode = n;
        this.getGlobalPreferences();
        this.getUserDevicePreferences();
        this.getUserPreferences();
        if (!this.wereMacrosPreviouslySaved()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"ApplianceSessionInfo constructor macros not previously saved, creating them");
            keyboardMacroGroup = new KeyboardMacroGroup(KEY_MACROGROUPPREFIX + RES.getString("ApplianceSessionInfo_Macro_Group_Windows") + System.currentTimeMillis(), RES.getString("ApplianceSessionInfo_Macro_Group_Windows"), 0);
            object = new KeyboardMacroGroup(KEY_MACROGROUPPREFIX + RES.getString("ApplianceSessionInfo_Macro_Group_Sun") + System.currentTimeMillis(), RES.getString("ApplianceSessionInfo_Macro_Group_Sun"), 0);
            KeyboardMacroGroup keyboardMacroGroup2 = new KeyboardMacroGroup(KEY_MACROGROUPPREFIX + RES.getString("ApplianceSessionInfo_Macro_Group_Novell") + System.currentTimeMillis(), RES.getString("ApplianceSessionInfo_Macro_Group_Novell"), 0);
            KeyboardMacroGroup keyboardMacroGroup3 = new KeyboardMacroGroup(KEY_MACROGROUPPREFIX + RES.getString("ApplianceSessionInfo_Macro_Group_MacIntosh") + System.currentTimeMillis(), RES.getString("ApplianceSessionInfo_Macro_Group_MacIntosh"), 0);
            KeyboardMacro[] keyboardMacroArray = KeyboardMacro.createStandardMacros(keyboardMacroGroup, (KeyboardMacroGroup)object, keyboardMacroGroup2, keyboardMacroGroup3);
            for (int i = 0; i < keyboardMacroArray.length; ++i) {
                try {
                    this.setGlobalProperty(keyboardMacroArray[i].getID(), keyboardMacroArray[i].getStorageString());
                    continue;
                }
                catch (Exception exception) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                }
            }
            this.setGlobalProperty(keyboardMacroGroup.getID(), keyboardMacroGroup.getStorageString());
            this.setGlobalProperty(((KeyboardMacroGroup)object).getID(), ((KeyboardMacroGroup)object).getStorageString());
            this.m_propGlobal.setProperty(KEY_SELECTEDMACROGROUPID, keyboardMacroGroup.getID());
            this.setMacrosPreviouslySaved(true);
            this.setGlobalPreferences(this.m_propGlobal);
        }
        if (!this.wereFunctionsPreviouslySaved()) {
            try {
                this.setToolbarMajorFunctions(MajorFunction.getDefaultMajorFunctions(n));
                this.setFunctionsPreviouslySaved(true);
                this.set31FunctionsPreviouslySaved(true);
                this.setUserPreferences(this.m_propUser);
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
            }
        } else if (!this.were31FunctionsPreviouslySaved()) {
            try {
                this.setToolbarMajorFunctions(MajorFunction.get31MajorFunctions());
                this.set31FunctionsPreviouslySaved(true);
                this.setUserPreferences(this.m_propUser);
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
            }
        }
        this.m_manualVideoParameters = new ManualVideoParameters(this.getUserDeviceProperty(KEY_MANUAL_VIDEO_ADJUSTMENTS));
        this.m_manualVideoParameters.setHorzResolution(this.getUserDeviceValue("VideoWidth", 1024));
        this.m_manualVideoParameters.setVertResolution(this.getUserDeviceValue("VideoHeight", 768));
        try {
            keyboardMacroGroup = this.getSelectedMacroGroup();
            if (keyboardMacroGroup == null && (object = this.getMacroGroups(true, true)) != null && ((KeyboardMacroGroup[])object).length > 0) {
                this.setSelectedMacroGroup(object[0]);
            }
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
        }
    }

    private void setUserPreferences(final Properties properties) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Properties properties2 = properties;
                synchronized (properties2) {
                    Trace.logInfo((String)ApplianceSessionInfo.TRACE_CONTEXT, (String)"ApplianceSessionInfo m_interfaceViewer.setUserPreferences");
                    ApplianceSessionInfo.this.m_interfaceViewer.setUserPreferences(properties);
                }
            }
        });
        thread.start();
    }

    private void getUserPreferences() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"ApplianceSessionInfo m_interfaceViewer.getUserPreferences");
        this.m_propUser = this.m_interfaceViewer.getUserPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserProperty(String string, String string2) {
        Object object = this.m_syncUser;
        synchronized (object) {
            this.m_propUser.setProperty(string, string2);
        }
    }

    private void setUserPreference(final String string, final String string2) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ApplianceSessionInfo.this.m_syncUser;
                synchronized (object) {
                    if (string2 == null) {
                        Trace.logInfo((String)ApplianceSessionInfo.TRACE_CONTEXT, (String)("ApplianceSessionInfo m_interfaceViewer.setUserPreference szKey=" + string + " szPreference=null, deleting object from database"));
                    } else {
                        Trace.logInfo((String)ApplianceSessionInfo.TRACE_CONTEXT, (String)("ApplianceSessionInfo m_interfaceViewer.setUserPreference szKey=" + string + " szPreference=" + string2));
                    }
                    ApplianceSessionInfo.this.m_interfaceViewer.setUserPreference(string, string2);
                    ApplianceSessionInfo.this.m_propUser.notifyAll();
                }
            }
        });
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserProperty(String string) {
        String string2 = DEFAULT_SELECTED_MACRO_GROUP;
        Object object = this.m_syncUser;
        synchronized (object) {
            string2 = this.m_propUser.getProperty(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeUserProperty(String string) {
        boolean bl = false;
        Object object = this.m_syncUser;
        synchronized (object) {
            if (this.m_propUser.containsKey(string)) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSessionInfo removeUserProperty szKey=" + string));
                this.m_propUser.remove(string);
                bl = true;
            } else {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSessionInfo removeUserProperty m_propUser does not contain szKey=" + string));
            }
        }
        return bl;
    }

    private void setUserDevicePreferences(final Properties properties) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Properties properties2 = properties;
                synchronized (properties2) {
                    Trace.logInfo((String)ApplianceSessionInfo.TRACE_CONTEXT, (String)"ApplianceSessionInfo m_interfaceViewer.setUserDevicePreferences");
                    ApplianceSessionInfo.this.m_interfaceViewer.setUserDevicePreferences(ApplianceSessionInfo.this.m_szDeviceID, properties);
                }
            }
        });
        thread.start();
    }

    private void setUserDevicePreference(final String string, final String string2) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ApplianceSessionInfo.this.m_syncUserDevice;
                synchronized (object) {
                    Trace.logInfo((String)ApplianceSessionInfo.TRACE_CONTEXT, (String)("ApplianceSessionInfo.setUserDevicePreference szKey=" + string + " szPreference=" + string2));
                    ApplianceSessionInfo.this.m_interfaceViewer.setUserDevicePreference(ApplianceSessionInfo.this.m_szDeviceID, string, string2);
                }
            }
        });
        thread.start();
    }

    private void getUserDevicePreferences() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"ApplianceSessionInfo m_interfaceViewer.getUserDevicePreferences");
        this.m_propUserDevice = this.m_interfaceViewer.getUserDevicePreferences(this.m_szDeviceID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setUserDeviceProperty(String string, String string2) {
        Object object = this.m_syncUserDevice;
        synchronized (object) {
            this.m_propUserDevice.setProperty(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUserDeviceProperty(String string) {
        String string2 = DEFAULT_SELECTED_MACRO_GROUP;
        Object object = this.m_syncUserDevice;
        synchronized (object) {
            string2 = this.m_propUserDevice.getProperty(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeGlobalDeviceProperty(String string) {
        boolean bl = false;
        Object object = this.m_syncUserDevice;
        synchronized (object) {
            if (this.m_propUserDevice.containsKey(string)) {
                this.m_propUserDevice.remove(string);
                bl = true;
            }
        }
        return bl;
    }

    private void setGlobalPreferences(final Properties properties) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Properties properties2 = properties;
                synchronized (properties2) {
                    Trace.logInfo((String)ApplianceSessionInfo.TRACE_CONTEXT, (String)"ApplianceSessionInfo m_interfaceViewer.setGlobalPreferences");
                    ApplianceSessionInfo.this.m_interfaceViewer.setGlobalPreferences(properties);
                }
            }
        });
        thread.start();
    }

    private void getGlobalPreferences() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"ApplianceSessionInfo m_interfaceViewer.getGlobalPreferences");
        this.m_propGlobal = this.m_interfaceViewer.getGlobalPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setGlobalProperty(String string, String string2) {
        Object object = this.m_syncGlobal;
        synchronized (object) {
            this.m_propGlobal.setProperty(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeGlobalProperty(String string) {
        boolean bl = false;
        Object object = this.m_syncGlobal;
        synchronized (object) {
            if (this.m_propGlobal.containsKey(string)) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSessionInfo removeGlobalProperty szKey=" + string));
                this.m_propGlobal.remove(string);
                bl = true;
            } else {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSessionInfo removeGlobalProperty m_propGlobal does not contain szKey=" + string));
            }
        }
        return bl;
    }

    private void setGlobalPreference(final String string, final String string2) {
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = ApplianceSessionInfo.this.m_syncGlobal;
                synchronized (object) {
                    if (string2 == null) {
                        Trace.logInfo((String)ApplianceSessionInfo.TRACE_CONTEXT, (String)("ApplianceSessionInfo m_interfaceViewer.setGlobalPreference szKey=" + string + " szPreference==null, deleting object from database"));
                    } else {
                        Trace.logInfo((String)ApplianceSessionInfo.TRACE_CONTEXT, (String)("ApplianceSessionInfo m_interfaceViewer.setGlobalPreference szKey=" + string + " szPreference=" + string2));
                    }
                    ApplianceSessionInfo.this.m_interfaceViewer.setGlobalPreference(string, string2);
                    ApplianceSessionInfo.this.m_propGlobal.notifyAll();
                }
            }
        });
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getGlobalProperty(String string) {
        String string2 = DEFAULT_SELECTED_MACRO_GROUP;
        Object object = this.m_syncGlobal;
        synchronized (object) {
            string2 = this.m_propGlobal.getProperty(string);
        }
        return string2;
    }

    public ApplianceSessionInfo(InterfaceViewer3 interfaceViewer3) {
        this.m_interfaceViewer = interfaceViewer3;
        this.m_szDeviceID = DEFAULT_SELECTED_MACRO_GROUP;
        this.getGlobalPreferences();
        this.getUserPreferences();
    }

    public ApplianceSessionInfo(ApplianceSessionInfo applianceSessionInfo) {
        this.m_interfaceViewer = applianceSessionInfo.m_interfaceViewer;
        this.m_szDeviceID = applianceSessionInfo.m_szDeviceID;
        if (this.m_propGlobal != null) {
            this.m_propGlobal.clear();
        }
        this.m_propGlobal = (Properties)applianceSessionInfo.m_propGlobal.clone();
        if (this.m_propUserDevice != null) {
            this.m_propUserDevice.clear();
        }
        this.m_propUserDevice = (Properties)applianceSessionInfo.m_propUserDevice.clone();
        if (this.m_propUser != null) {
            this.m_propUser.clear();
        }
        this.m_propUser = (Properties)applianceSessionInfo.m_propUser.clone();
        this.m_manualVideoParameters = applianceSessionInfo.m_manualVideoParameters;
    }

    public void terminate() {
        this.m_propGlobal.clear();
        this.m_propUserDevice.clear();
        this.m_propUser.clear();
    }

    void setAll() throws ExceptionRequestFailed {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"ApplianceSessionInfo.setAll enter");
        this.setGlobalPreferences(this.m_propGlobal);
        this.setUserDeviceProperty(KEY_MANUAL_VIDEO_ADJUSTMENTS, this.m_manualVideoParameters.getStorageString());
        this.setUserDevicePreferences(this.m_propUserDevice);
        this.setUserPreferences(this.m_propUser);
        Trace.logInfo((String)TRACE_CONTEXT, (String)"ApplianceSessionInfo.setAll exit");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAll(ApplianceSessionInfo applianceSessionInfo) throws ExceptionRequestFailed {
        String string;
        String string2;
        String string3;
        Enumeration<Object> enumeration;
        Properties properties;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"ApplianceSessionInfo.setAll enter");
        Object object = this.m_syncGlobal;
        synchronized (object) {
            if (this.m_propGlobal == null) {
                this.m_propGlobal = applianceSessionInfo.m_propGlobal;
                this.setGlobalPreferences(this.m_propGlobal);
            } else {
                properties = new Properties();
                enumeration = applianceSessionInfo.m_propGlobal.keys();
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    string2 = this.m_propGlobal.getProperty(string3);
                    string = applianceSessionInfo.m_propGlobal.getProperty(string3);
                    if (string2 != null && string2.equalsIgnoreCase(string)) continue;
                    this.m_propGlobal.setProperty(string3, string);
                    properties.setProperty(string3, string);
                }
                if (properties.size() > 0) {
                    this.setGlobalPreferences(properties);
                }
            }
        }
        object = this.m_syncUser;
        synchronized (object) {
            if (this.m_propUser == null) {
                this.m_propUser = applianceSessionInfo.m_propUser;
                this.setUserPreferences(this.m_propUser);
            } else {
                properties = new Properties();
                enumeration = applianceSessionInfo.m_propUser.keys();
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    string2 = this.m_propUser.getProperty(string3);
                    string = applianceSessionInfo.m_propUser.getProperty(string3);
                    if (string2 != null && string2.equalsIgnoreCase(string)) continue;
                    this.m_propUser.setProperty(string3, string);
                    properties.setProperty(string3, string);
                }
                if (properties.size() > 0) {
                    this.setUserPreferences(properties);
                }
            }
        }
        object = this.m_syncUserDevice;
        synchronized (object) {
            if (this.m_propUserDevice == null) {
                this.m_propUserDevice = applianceSessionInfo.m_propUserDevice;
                this.setUserDevicePreferences(this.m_propUserDevice);
            } else {
                properties = new Properties();
                enumeration = applianceSessionInfo.m_propUserDevice.keys();
                while (enumeration.hasMoreElements()) {
                    string3 = (String)enumeration.nextElement();
                    string2 = this.m_propUserDevice.getProperty(string3);
                    string = applianceSessionInfo.m_propUserDevice.getProperty(string3);
                    if (string2 != null && string2.equalsIgnoreCase(string)) continue;
                    this.m_propUserDevice.setProperty(string3, string);
                    properties.setProperty(string3, string);
                }
                if (properties.size() > 0) {
                    this.setUserDevicePreferences(properties);
                }
            }
        }
    }

    private byte getUserDeviceValue(String string, byte by) {
        byte by2 = by;
        try {
            by2 = Byte.valueOf(this.getUserDeviceProperty(string));
        }
        catch (Exception exception) {
            by2 = by;
        }
        return by2;
    }

    private int getUserDeviceValue(String string, int n) {
        int n2 = n;
        try {
            n2 = Integer.valueOf(this.getUserDeviceProperty(string));
        }
        catch (Exception exception) {
            n2 = n;
        }
        return n2;
    }

    private short getUserDeviceValue(String string, short s) {
        short s2 = s;
        try {
            s2 = Short.valueOf(this.getUserDeviceProperty(string));
        }
        catch (Exception exception) {
            s2 = s;
        }
        return s2;
    }

    private double getUserDeviceValue(String string, double d) {
        double d2 = d;
        try {
            d2 = Double.valueOf(this.getUserDeviceProperty(string));
        }
        catch (Exception exception) {
            d2 = d;
        }
        return d2;
    }

    private String getUserDeviceValue(String string, String string2) {
        String string3 = string2;
        try {
            string3 = this.getUserDeviceProperty(string);
            if (string3 == null) {
                string3 = string2;
            }
        }
        catch (Exception exception) {
            string3 = string2;
        }
        return string3;
    }

    private int getUserValue(String string, int n) {
        int n2 = n;
        try {
            n2 = Integer.valueOf(this.getUserProperty(string));
        }
        catch (Exception exception) {
            n2 = n;
        }
        return n2;
    }

    private String getUserValue(String string, String string2) {
        String string3 = string2;
        try {
            string3 = this.getUserProperty(string);
            if (string3 == null) {
                string3 = string2;
            }
        }
        catch (Exception exception) {
            string3 = string2;
        }
        return string3;
    }

    private int getGlobalValue(String string, int n) {
        int n2 = n;
        try {
            n2 = Integer.valueOf(this.getGlobalProperty(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    private String getGlobalValue(String string, String string2) {
        String string3 = string2;
        try {
            string3 = this.getGlobalProperty(string);
            if (string3 == null) {
                string3 = string2;
            }
        }
        catch (Exception exception) {
            string3 = string2;
        }
        return string3;
    }

    final boolean wereMacrosPreviouslySaved() {
        int n = this.getGlobalValue(KEY_MACROSPREVIOUSLYSAVED, 0);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("wereMacrosPreviouslySaved value=" + n));
        return n == 1;
    }

    final void setMacrosPreviouslySaved(boolean bl) {
        this.setGlobalProperty(KEY_MACROSPREVIOUSLYSAVED, Integer.toString(bl ? 1 : 0));
    }

    final boolean wereFunctionsPreviouslySaved() {
        return this.getUserValue(KEY_FUNCTIONSPREVIOUSLYSAVED, 0) == 1;
    }

    final boolean were31FunctionsPreviouslySaved() {
        return this.getUserValue(KEY_31FUNCTIONSPREVIOUSLYSAVED, 0) == 1;
    }

    final void setFunctionsPreviouslySaved(boolean bl) {
        this.setUserProperty(KEY_FUNCTIONSPREVIOUSLYSAVED, Integer.toString(bl ? 1 : 0));
    }

    final void set31FunctionsPreviouslySaved(boolean bl) {
        this.setUserProperty(KEY_31FUNCTIONSPREVIOUSLYSAVED, Integer.toString(bl ? 1 : 0));
    }

    final byte getKvmChannel() {
        return this.getUserDeviceValue(KEY_KVMCHANNEL, (byte)0);
    }

    void setKvmChannel(byte by) {
        this.setUserDeviceProperty(KEY_KVMCHANNEL, Byte.toString(by));
    }

    final byte getCascadeChannel1() {
        return this.getUserDeviceValue(KEY_CASCADE1, (byte)0);
    }

    void setCascadeChannel1(byte by) {
        this.setUserDeviceProperty(KEY_CASCADE1, Byte.toString(by));
    }

    final byte getAppliancePort() {
        return this.getUserDeviceValue(KEY_APPLIANCEPORT, (byte)0);
    }

    void setAppliancePort(byte by) {
        this.setUserDeviceProperty(KEY_APPLIANCEPORT, Byte.toString(by));
    }

    final int getLocalCursorType() {
        return this.getUserDeviceValue(KEY_LOCALCURSORTYPE, 2);
    }

    void setLocalCursorType(int n) {
        this.setUserDeviceProperty(KEY_LOCALCURSORTYPE, Integer.toString(n));
    }

    final KeyStroke getSingleCursorTerminateKey() throws ExceptionRequestFailed {
        return KeyStroke.getStandardSelectionKeyStrokeFromScanCode(this.getUserValue(KEY_SINGLECURSORTERMINATEKEY, 121));
    }

    void setSingleCursorTerminateKey(KeyStroke keyStroke) {
        this.setUserProperty(KEY_SINGLECURSORTERMINATEKEY, DEFAULT_SELECTED_MACRO_GROUP + KeyStroke.getScanCodeForStandardSelectionKeyStroke(keyStroke));
    }

    final int getToolbarHideDelay() {
        return this.getUserValue(KEY_TOOLBARHIDEDELAY, 3);
    }

    void setToolbarHideDelay(int n) {
        this.setUserProperty(KEY_TOOLBARHIDEDELAY, DEFAULT_SELECTED_MACRO_GROUP + n);
    }

    final boolean isLockToolbarSingleCursorFullScreen() {
        int n = this.getUserValue(KEY_LOCKTOOLBARSINGLECURSORFULLSCREEN, 1);
        return n == 1;
    }

    void setLockToolbarSingleCursorFullScreen(boolean bl) {
        this.setUserProperty(KEY_LOCKTOOLBARSINGLECURSORFULLSCREEN, DEFAULT_SELECTED_MACRO_GROUP + (bl ? "1" : "0"));
    }

    final boolean isDontShowDlgSingleCursorFullScreen() {
        int n = this.getUserValue(KEY_DONTSHOWDLGSINGLECURSORFULLSCREEN, 0);
        return n == 1;
    }

    void setDontShowDlgSingleCursorFullScreen(boolean bl) {
        this.setUserProperty(KEY_DONTSHOWDLGSINGLECURSORFULLSCREEN, DEFAULT_SELECTED_MACRO_GROUP + (bl ? "1" : "0"));
    }

    final KeyStroke getMenuActivationKey() throws ExceptionRequestFailed {
        return KeyStroke.getStandardSelectionKeyStrokeFromScanCode(this.getUserValue(KEY_MENUACTIVATIONKEY, 44));
    }

    void setMenuActivationKey(KeyStroke keyStroke) {
        this.setUserProperty(KEY_MENUACTIVATIONKEY, DEFAULT_SELECTED_MACRO_GROUP + KeyStroke.getScanCodeForStandardSelectionKeyStroke(keyStroke));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final MajorFunction[] getMajorFunctions(boolean bl) {
        Vector<MajorFunction> vector = new Vector<MajorFunction>();
        MajorFunction[] majorFunctionArray = this.m_syncUser;
        synchronized (this.m_syncUser) {
            Enumeration<Object> enumeration = this.m_propUser.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith(KEY_FUNCTIONPREFIX)) continue;
                MajorFunction majorFunction = new MajorFunction(string, this.m_propUser.getProperty(string));
                if (bl) {
                    if (!majorFunction.isOnToolbar()) continue;
                    vector.add(majorFunction);
                    continue;
                }
                vector.add(majorFunction);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            majorFunctionArray = new MajorFunction[vector.size()];
            vector.toArray(majorFunctionArray);
            return majorFunctionArray;
        }
    }

    void setToolbarMajorFunctions(MajorFunction[] majorFunctionArray) throws ExceptionRequestFailed {
        for (int i = 0; i < majorFunctionArray.length; ++i) {
            this.setToolbarMajorFunction(majorFunctionArray[i]);
        }
    }

    void setToolbarMajorFunction(MajorFunction majorFunction) throws ExceptionRequestFailed {
        this.setUserProperty(majorFunction.getID(), majorFunction.getStorageString());
    }

    final double getMouseXGain() {
        return this.getUserDeviceValue(KEY_MOUSEXGAIN, 1.0);
    }

    void setMouseXGain(double d) {
        this.setUserDeviceProperty(KEY_MOUSEXGAIN, Double.toString(d));
    }

    final double getMouseYGain() {
        return this.getUserDeviceValue(KEY_MOUSEYGAIN, 1.0);
    }

    void setMouseYGain(double d) {
        this.setUserDeviceProperty(KEY_MOUSEYGAIN, Double.toString(d));
    }

    final double getMouseCustomXGain() {
        return this.getUserDeviceValue(KEY_MOUSECUSTOMXGAIN, 1.0);
    }

    void setMouseCustomXGain(double d) {
        this.setUserDeviceProperty(KEY_MOUSECUSTOMXGAIN, Double.toString(d));
    }

    final double getMouseCustomYGain() {
        return this.getUserDeviceValue(KEY_MOUSECUSTOMYGAIN, 1.0);
    }

    void setMouseCustomYGain(double d) {
        this.setUserDeviceProperty(KEY_MOUSECUSTOMYGAIN, Double.toString(d));
    }

    final int getMouseScaleType() {
        return this.getUserDeviceValue(KEY_MOUSESCALETYPE, 0);
    }

    void setMouseScaleType(int n) {
        this.setUserDeviceProperty(KEY_MOUSESCALETYPE, Integer.toString(n));
    }

    final short getVideoMode() {
        return this.getUserDeviceValue(KEY_VIDEOMODE, (short)0);
    }

    void setVideoMode(short s) {
        this.setUserDeviceProperty(KEY_VIDEOMODE, Short.toString(s));
    }

    final short getVideoWidth() {
        return (short)this.m_manualVideoParameters.getHorzResolution();
    }

    void setVideoWidth(short s) {
        this.m_manualVideoParameters.setHorzResolution(s);
    }

    final short getVideoHeight() {
        return (short)this.m_manualVideoParameters.getVertResolution();
    }

    void setVideoHeight(short s) {
        this.m_manualVideoParameters.setVertResolution(s);
    }

    final short getPanedWidth() {
        return this.getUserDeviceValue("VideoWidth", (short)1024);
    }

    void setPanedWidth(short s) {
        this.setPanedWidth(s, false);
    }

    void setPanedWidth(short s, boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("setPanedHeight:setPanedWidth=" + s));
        this.setUserDeviceProperty("VideoWidth", Short.toString(s));
        if (bl) {
            this.setUserDevicePreference("VideoWidth", Short.toString(s));
        }
    }

    final short getPanedHeight() {
        return this.getUserDeviceValue("VideoHeight", (short)768);
    }

    void setPanedHeight(short s) {
        this.setPanedHeight(s, false);
    }

    void setPanedHeight(short s, boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("setPanedHeight:sPanedHeight=" + s));
        this.setUserDeviceProperty("VideoHeight", Short.toString(s));
        if (bl) {
            this.setUserDevicePreference("VideoHeight", Short.toString(s));
        }
    }

    final int getDecimationFactor() {
        return this.getUserDeviceValue(KEY_DECIMATIONFACTOR, 1);
    }

    void setDecimationFactor(int n) {
        this.setDecimationFactor(n, false);
    }

    void setDecimationFactor(int n, boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("setDecimationFactor:nDecimationFactor=" + n));
        this.setUserDeviceProperty(KEY_DECIMATIONFACTOR, Integer.toString(n));
        if (bl) {
            this.setUserDevicePreference(KEY_DECIMATIONFACTOR, Integer.toString(n));
        }
    }

    final boolean isPaneScaled() {
        return this.getUserDeviceValue(KEY_PANESCALED, 0) == 1;
    }

    void setPaneScaled(boolean bl) {
        this.setUserDeviceProperty(KEY_PANESCALED, bl ? "1" : "0");
    }

    final boolean isAutoScale() {
        boolean bl = false;
        bl = this.m_nApplicationCode == 1 ? this.getUserDeviceValue(KEY_AUTOSCALE, "true").equalsIgnoreCase("true") : this.getUserDeviceValue(KEY_AUTOSCALE, "false").equalsIgnoreCase("true");
        return bl;
    }

    void setAutoScale(boolean bl) {
        this.setUserDeviceProperty(KEY_AUTOSCALE, bl ? "true" : "false");
    }

    final boolean isFullScale() {
        return this.getUserDeviceValue(KEY_FULLSCALE, "false").equalsIgnoreCase("true");
    }

    void setFullScale(boolean bl) {
        this.setUserDeviceProperty(KEY_FULLSCALE, bl ? "true" : "false");
    }

    final boolean isKeyboardPassthroughNonFullScreen() {
        return this.getUserDeviceValue(KEY_KEYBOARDPASSTHROUGH_NONFULLSCREEN, 0) == 1;
    }

    void setKeyboardPassthroughNonFullScreen(boolean bl) {
        this.setUserDeviceProperty(KEY_KEYBOARDPASSTHROUGH_NONFULLSCREEN, bl ? "1" : "0");
    }

    final boolean isBackgroundRefresh() {
        return this.getUserDeviceValue(KEY_BACKGROUND_REFRESH, 0) == 1;
    }

    void setBackgroundRefresh(boolean bl) {
        this.setUserDeviceProperty(KEY_BACKGROUND_REFRESH, bl ? "1" : "0");
    }

    final boolean isPinPushed() {
        return this.getUserDeviceValue(KEY_PUSHPINSTATE, 0) == 1;
    }

    void setPinPushed(boolean bl) {
        this.setUserDeviceProperty(KEY_PUSHPINSTATE, bl ? "1" : "0");
    }

    final boolean isDontShowMouseSyncNotification() {
        return this.getUserDeviceValue(KEY_DONT_SHOW_MOUSE_SYNC_NOTIFICATION, 0) == 1;
    }

    void setDontShowMouseSyncNotification(boolean bl) {
        this.setUserDeviceProperty(KEY_DONT_SHOW_MOUSE_SYNC_NOTIFICATION, bl ? "1" : "0");
    }

    final int getThrottleType() {
        return this.getUserDeviceValue(KEY_THROTTLETYPE, 0);
    }

    void setThrottleType(int n) throws ExceptionRequestFailed, ExceptionNotSupported {
        this.setUserDeviceProperty(KEY_THROTTLETYPE, Integer.toString(n));
    }

    final short getMaxOutputHeight() {
        return this.getUserDeviceValue(KEY_MAXOUTPUTHEIGHT, (short)768);
    }

    void setMaxOutputHeight(short s) throws ExceptionRequestFailed, ExceptionNotSupported {
        this.setUserDeviceProperty(KEY_MAXOUTPUTHEIGHT, Short.toString(s));
    }

    void setMaxOutputHeight(short s, boolean bl) throws ExceptionRequestFailed, ExceptionNotSupported {
        this.setUserDeviceProperty(KEY_MAXOUTPUTHEIGHT, Short.toString(s));
        if (bl) {
            this.setUserDevicePreference(KEY_MAXOUTPUTHEIGHT, Short.toString(s));
        }
    }

    final short getMaxOutputWidth() {
        return this.getUserDeviceValue(KEY_MAXOUTPUTWIDTH, (short)1024);
    }

    void setMaxOutputWidth(short s) throws ExceptionRequestFailed, ExceptionNotSupported {
        this.setUserDeviceProperty(KEY_MAXOUTPUTWIDTH, Short.toString(s));
    }

    void setMaxOutputWidth(short s, boolean bl) throws ExceptionRequestFailed, ExceptionNotSupported {
        this.setUserDeviceProperty(KEY_MAXOUTPUTWIDTH, Short.toString(s));
        if (bl) {
            this.setUserDevicePreference(KEY_MAXOUTPUTWIDTH, Short.toString(s));
        }
    }

    final int getThumbnailViewTimePerServer() {
        return this.getUserValue(KEY_THUMBNAILVIEWTIMEPERSERVER, 10);
    }

    void setThumbnailViewTimePerServer(int n) {
        this.setUserProperty(KEY_THUMBNAILVIEWTIMEPERSERVER, Integer.toString(n));
        this.setUserPreference(KEY_THUMBNAILVIEWTIMEPERSERVER, Integer.toString(n));
    }

    final int getThumbnailTimeBetweenServers() {
        return this.getUserValue(KEY_THUMBNAILTIMEBETWEENSERVERS, 30);
    }

    void setThumbnailTimeBetweenServers(int n) throws ExceptionRequestFailed {
        this.setUserProperty(KEY_THUMBNAILTIMEBETWEENSERVERS, Integer.toString(n));
        this.setUserPreference(KEY_THUMBNAILTIMEBETWEENSERVERS, Integer.toString(n));
    }

    final boolean wasColorDepthSaved() {
        return this.getUserDeviceValue(KEY_COLOR_DEPTH_SAVED, 0) == 1;
    }

    void setColorDepthSaved(boolean bl) {
        this.setUserDeviceProperty(KEY_COLOR_DEPTH_SAVED, bl ? "1" : "0");
    }

    final byte getColorDepth() {
        return this.getUserDeviceValue(KEY_COLOR_DEPTH, (byte)9);
    }

    void setColorDepth(byte by) {
        this.setUserDeviceProperty(KEY_COLOR_DEPTH, Byte.toString(by));
    }

    final boolean wereVideoParametersSaved() {
        return this.getUserDeviceValue(KEY_VIDEO_PARAMETERS_SAVED, 0) == 1;
    }

    void setVideoParametersSaved(boolean bl) {
        if (bl) {
            this.setUserDeviceProperty(KEY_MANUAL_VIDEO_ADJUSTMENTS, this.m_manualVideoParameters.getStorageString());
        }
        this.setUserDeviceProperty(KEY_VIDEO_PARAMETERS_SAVED, bl ? "1" : "0");
    }

    final short getBrightness() {
        return (short)this.m_manualVideoParameters.getBrightness();
    }

    void setBrightness(short s) {
        this.m_manualVideoParameters.setBrightness(s);
    }

    final short getContrast() {
        return (short)this.m_manualVideoParameters.getContrast();
    }

    void setContrast(short s) {
        this.m_manualVideoParameters.setContrast(s);
    }

    final short getCaptureHorzPosition() {
        return (short)this.m_manualVideoParameters.getCaptureHorzPosition();
    }

    void setCaptureHorzPosition(short s) {
        this.m_manualVideoParameters.setCaptureHorzPosition(s);
    }

    final short getCaptureVertPosition() {
        return (short)this.m_manualVideoParameters.getCaptureVertPosition();
    }

    void setCaptureVertPosition(short s) {
        this.m_manualVideoParameters.setCaptureVertPosition(s);
    }

    final short getCaptureWidth() {
        return (short)this.m_manualVideoParameters.getCaptureWidth();
    }

    void setCaptureWidth(short s) {
        this.m_manualVideoParameters.setCaptureWidth(s);
    }

    final short getPixelFineAdjust() {
        return (short)this.m_manualVideoParameters.getPixelFineAdjust();
    }

    void setPixelFineAdjust(short s) {
        this.m_manualVideoParameters.setPixelFineAdjust(s);
    }

    final short getNoiseThreshold() {
        return (short)this.m_manualVideoParameters.getNoiseThreshold();
    }

    void setNoiseThreshold(short s) {
        this.m_manualVideoParameters.setNoiseThreshold(s);
    }

    final short getPriorityPixelThreshold() {
        return (short)this.m_manualVideoParameters.getPriorityThreshold();
    }

    void setPriorityPixelThreshold(short s) {
        this.m_manualVideoParameters.setPriorityThreshold(s);
    }

    final KeyboardMacroGroup getSelectedMacroGroup() {
        String string = this.getUserDeviceValue(KEY_SELECTEDMACROGROUPID, DEFAULT_SELECTED_MACRO_GROUP);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSessionInfo.getSelectedMacroGroup from UserDevice szID=" + string));
        if (string != null && string.length() > 0) {
            String string2;
            if (string.indexOf(KEY_MACROGROUPPREFIX) < 0) {
                string = KEY_MACROGROUPPREFIX + string;
            }
            if ((string2 = this.getGlobalValue(string, DEFAULT_SELECTED_MACRO_GROUP)) == null || string2.length() == 0) {
                string2 = this.getUserValue(string, DEFAULT_SELECTED_MACRO_GROUP);
            }
            if (string2 != null && string2.length() > 0) {
                KeyboardMacroGroup keyboardMacroGroup = null;
                try {
                    keyboardMacroGroup = new KeyboardMacroGroup(string, string2, true);
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                }
                return keyboardMacroGroup;
            }
        } else {
            string = this.getGlobalValue(KEY_SELECTEDMACROGROUPID, DEFAULT_SELECTED_MACRO_GROUP);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("ApplianceSessionInfo.getSelectedMacroGroup from Global szID=" + string));
            if (string != null && string.length() > 0) {
                String string3;
                if (string.indexOf(KEY_MACROGROUPPREFIX) < 0) {
                    string = KEY_MACROGROUPPREFIX + string;
                }
                if ((string3 = this.getGlobalValue(string, DEFAULT_SELECTED_MACRO_GROUP)) == null || string3.length() == 0) {
                    string3 = this.getUserValue(string, DEFAULT_SELECTED_MACRO_GROUP);
                }
                if (string3 != null && string3.length() > 0) {
                    KeyboardMacroGroup keyboardMacroGroup = null;
                    try {
                        keyboardMacroGroup = new KeyboardMacroGroup(string, string3, true);
                    }
                    catch (ExceptionRequestFailed exceptionRequestFailed) {
                        Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                    }
                    return keyboardMacroGroup;
                }
            }
        }
        return null;
    }

    void setSelectedMacroGroup(KeyboardMacroGroup keyboardMacroGroup) throws ExceptionRequestFailed {
        String string = keyboardMacroGroup.getID();
        int n = string.indexOf(KEY_MACROGROUPPREFIX);
        if (n >= 0) {
            string = string.substring(n + KEY_MACROGROUPPREFIX.length());
        }
        this.setUserDeviceProperty(KEY_SELECTEDMACROGROUPID, string);
    }

    void saveMacroGroup(KeyboardMacroGroup keyboardMacroGroup) throws ExceptionRequestFailed {
        if (keyboardMacroGroup.isGlobalGroup()) {
            this.setGlobalProperty(keyboardMacroGroup.getID(), keyboardMacroGroup.getStorageString());
            this.setGlobalPreference(keyboardMacroGroup.getID(), keyboardMacroGroup.getStorageString());
        } else {
            this.setUserProperty(keyboardMacroGroup.getID(), keyboardMacroGroup.getStorageString());
            this.setUserPreference(keyboardMacroGroup.getID(), keyboardMacroGroup.getStorageString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyboardMacroGroup retrieveMacroGroup(String string) throws ExceptionRequestFailed {
        String string2 = DEFAULT_SELECTED_MACRO_GROUP;
        Object object = this.m_syncUser;
        synchronized (object) {
            string2 = this.m_propUser.getProperty(string);
        }
        object = new KeyboardMacroGroup(string, string2, false);
        return object;
    }

    void removeMacroGroup(KeyboardMacroGroup keyboardMacroGroup) {
        if (this.removeUserProperty(keyboardMacroGroup.getID())) {
            this.setUserPreference(keyboardMacroGroup.getID(), null);
        } else if (this.removeGlobalProperty(keyboardMacroGroup.getID())) {
            this.setGlobalPreference(keyboardMacroGroup.getID(), null);
        }
    }

    void renameMacroGroup(String string, String string2) throws ExceptionRequestFailed {
        KeyboardMacroGroup keyboardMacroGroup = this.retrieveMacroGroup(string);
        keyboardMacroGroup.setName(string2);
        this.saveMacroGroup(keyboardMacroGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public KeyboardMacro[] getMacros(boolean bl, boolean bl2) {
        KeyboardMacro keyboardMacro;
        String string;
        String string2;
        Enumeration<Object> enumeration;
        KeyboardMacro[] keyboardMacroArray;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"ApplianceSessionInfo.getMacros");
        Vector<KeyboardMacro> vector = new Vector<KeyboardMacro>();
        if (bl) {
            keyboardMacroArray = this.m_syncUser;
            // MONITORENTER : this.m_syncUser
            enumeration = this.m_propUser.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(KEY_MACROPREFIX)) continue;
                string = this.m_propUser.getProperty(string2);
                try {
                    keyboardMacro = new KeyboardMacro(string2, string, false);
                    vector.add(keyboardMacro);
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                }
            }
            // MONITOREXIT : keyboardMacroArray
        }
        if (bl2) {
            keyboardMacroArray = this.m_syncGlobal;
            // MONITORENTER : keyboardMacroArray
            enumeration = this.m_propGlobal.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(KEY_MACROPREFIX)) continue;
                string = this.m_propGlobal.getProperty(string2);
                try {
                    keyboardMacro = new KeyboardMacro(string2, string, true);
                    vector.add(keyboardMacro);
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                }
            }
            // MONITOREXIT : keyboardMacroArray
        }
        keyboardMacroArray = new KeyboardMacro[vector.size()];
        vector.toArray(keyboardMacroArray);
        return keyboardMacroArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KeyboardMacro[] getMacros(String[] stringArray) {
        Vector<KeyboardMacro> vector = new Vector<KeyboardMacro>();
        KeyboardMacro[] keyboardMacroArray = this.m_syncUser;
        synchronized (this.m_syncUser) {
            KeyboardMacro keyboardMacro;
            String string;
            int n;
            String string2;
            Enumeration<Object> enumeration = this.m_propUser.keys();
            block10: while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(KEY_MACROPREFIX)) continue;
                for (n = 0; n < stringArray.length; ++n) {
                    if (string2.compareTo(stringArray[n]) != 0) continue;
                    string = this.m_propUser.getProperty(string2);
                    try {
                        keyboardMacro = new KeyboardMacro(string2, string, false);
                        vector.add(keyboardMacro);
                    }
                    catch (ExceptionRequestFailed exceptionRequestFailed) {
                        Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                    }
                    continue block10;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            keyboardMacroArray = this.m_syncGlobal;
            synchronized (keyboardMacroArray) {
                enumeration = this.m_propGlobal.keys();
                block12: while (enumeration.hasMoreElements()) {
                    string2 = (String)enumeration.nextElement();
                    if (!string2.startsWith(KEY_MACROPREFIX)) continue;
                    for (n = 0; n < stringArray.length; ++n) {
                        if (string2.compareTo(stringArray[n]) != 0) continue;
                        string = this.m_propGlobal.getProperty(string2);
                        try {
                            keyboardMacro = new KeyboardMacro(string2, string, true);
                            vector.add(keyboardMacro);
                        }
                        catch (ExceptionRequestFailed exceptionRequestFailed) {
                            Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                        }
                        continue block12;
                    }
                }
            }
            keyboardMacroArray = new KeyboardMacro[vector.size()];
            vector.toArray(keyboardMacroArray);
            vector = null;
            return keyboardMacroArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    KeyboardMacro[] getMacrosNotInGroup(String[] var1_1, boolean var2_2, boolean var3_3) {
        var4_4 = new Vector<KeyboardMacro>();
        if (!var2_2) ** GOTO lbl15
        var5_5 = this.m_syncUser;
        synchronized (this.m_syncUser) {
            var6_6 = this.m_propUser.keys();
            while (true) {
                block14: {
                    block15: {
                        block13: {
                            if (!var6_6.hasMoreElements()) break block13;
                            var7_7 = (String)var6_6.nextElement();
                            if (!var7_7.startsWith("MACRO_")) continue;
                            var8_8 = false;
                            if (var1_1 == null) break block14;
                            break block15;
                        }
                        // ** MonitorExit[var5_5] (shouldn't be in output)
lbl15:
                        // 2 sources

                        if (var3_3) {
                            var5_5 = this.m_syncGlobal;
                            synchronized (var5_5) {
                                break;
                            }
                        }
                        ** GOTO lbl46
                    }
                    for (var9_9 = 0; var9_9 < var1_1.length; ++var9_9) {
                        if (var7_7.compareTo(var1_1[var9_9]) != 0) continue;
                        var8_8 = true;
                        break;
                    }
                }
                if (var8_8) continue;
                var9_10 = this.m_propUser.getProperty(var7_7);
                try {
                    var10_13 = new KeyboardMacro(var7_7, var9_10, false);
                    var4_4.add(var10_13);
                }
                catch (ExceptionRequestFailed var10_14) {
                    Trace.logError((String)"VideoViewerTrace", (String)var10_14.getMessage(), (Throwable)var10_14);
                }
            }
            {
                var6_6 = this.m_propGlobal.keys();
                while (true) {
                    block17: {
                        block18: {
                            block16: {
                                if (!var6_6.hasMoreElements()) break block16;
                                var7_7 = (String)var6_6.nextElement();
                                if (!var7_7.startsWith("MACRO_")) continue;
                                var8_8 = false;
                                if (var1_1 == null) break block17;
                                break block18;
                            }
                            // MONITOREXIT @DISABLED, blocks:[4, 5, 10] lbl41 : MonitorExitStatement: MONITOREXIT : var5_5
lbl46:
                            // 2 sources

                            var5_5 = new KeyboardMacro[var4_4.size()];
                            var4_4.toArray(var5_5);
                            return var5_5;
                        }
                        for (var9_11 = 0; var9_11 < var1_1.length; ++var9_11) {
                            if (var7_7.compareTo(var1_1[var9_11]) != 0) continue;
                            var8_8 = true;
                            break;
                        }
                    }
                    if (var8_8) continue;
                    var9_12 = this.m_propGlobal.getProperty(var7_7);
                    try {
                        var10_13 = new KeyboardMacro(var7_7, var9_12, true);
                        var4_4.add(var10_13);
                    }
                    catch (ExceptionRequestFailed var10_15) {
                        Trace.logError((String)"VideoViewerTrace", (String)var10_15.getMessage(), (Throwable)var10_15);
                        continue;
                    }
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    KeyboardMacroGroup[] getMacroGroups(boolean bl, boolean bl2) {
        KeyboardMacroGroup keyboardMacroGroup;
        String string;
        String string2;
        Enumeration<Object> enumeration;
        KeyboardMacroGroup[] keyboardMacroGroupArray;
        Vector<KeyboardMacroGroup> vector = new Vector<KeyboardMacroGroup>();
        if (bl) {
            keyboardMacroGroupArray = this.m_syncUser;
            // MONITORENTER : this.m_syncUser
            enumeration = this.m_propUser.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(KEY_MACROGROUPPREFIX)) continue;
                string = this.m_propUser.getProperty(string2);
                try {
                    keyboardMacroGroup = new KeyboardMacroGroup(string2, string, false);
                    vector.add(keyboardMacroGroup);
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                }
            }
            // MONITOREXIT : keyboardMacroGroupArray
        }
        if (bl2) {
            keyboardMacroGroupArray = this.m_syncGlobal;
            // MONITORENTER : keyboardMacroGroupArray
            enumeration = this.m_propGlobal.keys();
            while (enumeration.hasMoreElements()) {
                string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(KEY_MACROGROUPPREFIX)) continue;
                string = this.m_propGlobal.getProperty(string2);
                try {
                    keyboardMacroGroup = new KeyboardMacroGroup(string2, string, true);
                    vector.add(keyboardMacroGroup);
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                }
            }
            // MONITOREXIT : keyboardMacroGroupArray
        }
        keyboardMacroGroupArray = new KeyboardMacroGroup[vector.size()];
        vector.toArray(keyboardMacroGroupArray);
        return keyboardMacroGroupArray;
    }

    KeyboardMacro getMacro(String string) {
        KeyboardMacro keyboardMacro = null;
        String string2 = this.getUserValue(string, DEFAULT_SELECTED_MACRO_GROUP);
        if (string2.length() == 0) {
            string2 = this.getGlobalValue(string, DEFAULT_SELECTED_MACRO_GROUP);
            if (string2.length() > 0) {
                try {
                    keyboardMacro = new KeyboardMacro(string, string2, true);
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                }
            }
        } else if (string2.length() > 0) {
            try {
                keyboardMacro = new KeyboardMacro(string, string2, false);
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
            }
        }
        return keyboardMacro;
    }

    public boolean doesMacroNameExist(String string) {
        KeyboardMacro[] keyboardMacroArray = this.getMacros(true, true);
        string.trim();
        for (int i = 0; i < keyboardMacroArray.length; ++i) {
            if (!string.equalsIgnoreCase(keyboardMacroArray[i].getName().trim())) continue;
            return true;
        }
        return false;
    }

    public boolean doesMacroGroupNameExist(String string) {
        KeyboardMacroGroup[] keyboardMacroGroupArray = this.getMacroGroups(true, true);
        string.trim();
        for (int i = 0; i < keyboardMacroGroupArray.length; ++i) {
            if (!string.equalsIgnoreCase(keyboardMacroGroupArray[i].getName().trim())) continue;
            return true;
        }
        return false;
    }

    public void setMacro(KeyboardMacro keyboardMacro) {
        if (keyboardMacro.isGlobalMacro()) {
            this.m_propGlobal.setProperty(keyboardMacro.getID(), keyboardMacro.getStorageString());
        } else {
            this.setUserProperty(keyboardMacro.getID(), keyboardMacro.getStorageString());
        }
    }

    void removeMacro(KeyboardMacro keyboardMacro) {
        if (this.removeUserProperty(keyboardMacro.getID())) {
            this.setUserPreference(keyboardMacro.getID(), null);
        } else if (this.removeGlobalProperty(keyboardMacro.getID())) {
            this.setGlobalPreference(keyboardMacro.getID(), null);
        }
        KeyboardMacroGroup[] keyboardMacroGroupArray = this.getMacroGroups(true, true);
        for (int i = 0; i < keyboardMacroGroupArray.length; ++i) {
            keyboardMacroGroupArray[i].removeMacroFromGroup(keyboardMacro);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfMacros() {
        String string;
        Enumeration<Object> enumeration;
        int n = 0;
        Object object = this.m_syncUser;
        synchronized (object) {
            enumeration = this.m_propUser.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!string.startsWith(KEY_MACROPREFIX)) continue;
                ++n;
            }
        }
        object = this.m_syncGlobal;
        synchronized (object) {
            enumeration = this.m_propGlobal.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                if (!string.startsWith(KEY_MACROPREFIX)) continue;
                ++n;
            }
        }
        return n;
    }
}

