/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.video.AVSPStatus;
import com.avocent.video.DSEncryptValues;
import com.avocent.video.DSPath;
import com.avocent.video.DataInputStreamEndian;
import com.avocent.video.DataOutputStreamEndian;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.SSLException;

public class DSConnect {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    public static final int CONNECTION_MODE_NORMAL = 0;
    public static final int CONNECTION_MODE_SHARE = 1;
    public static final int CONNECTION_MODE_STEALTH = 2;
    public static final int CONNECTION_MODE_EXCLUSIVE = 5;
    public static final int CONNECTION_MODE_PREEMPT = 6;
    public static final int CONNECTION_MODE_SCAN = 7;
    private String m_strError = "";

    public DSEncryptValues dsConnectApplet(DataInputStreamEndian dataInputStreamEndian, String string, String string2, String string3, URL uRL) throws IOException {
        Object object;
        Object object2;
        int n = dataInputStreamEndian.readIntEndian();
        int n2 = dataInputStreamEndian.readIntEndian();
        dataInputStreamEndian.readIntEndian();
        byte[] byArray = new byte[16];
        dataInputStreamEndian.read(byArray);
        int n3 = dataInputStreamEndian.readIntEndian();
        int n4 = dataInputStreamEndian.readIntEndian();
        byte[] byArray2 = new byte[]{113, -46, -6, -91, 78, -92, 101, 70};
        int n5 = (int)System.currentTimeMillis();
        int n6 = (int)(1000000.0 * Math.random());
        try {
            URL uRL2 = uRL.getProtocol().compareTo("http") == 0 ? new URL("http://" + string + "/dsConnection.asp?LocalComputerName='" + string3 + "'&ApplianceIP='" + string2 + "'&RandNum=" + n6 + "&ApplianceRandNum=" + n3) : new URL("https://" + string + "/dsConnection.asp?LocalComputerName='" + string3 + "'&ApplianceIP='" + string2 + "'&RandNum=" + n6 + "&ApplianceRandNum=" + n3);
            object2 = uRL2.openConnection();
            ((URLConnection)object2).setUseCaches(false);
            ((URLConnection)object2).setDoOutput(true);
            ((URLConnection)object2).setDoInput(true);
            ((URLConnection)object2).getOutputStream().flush();
            ((URLConnection)object2).getOutputStream().close();
            object = new BufferedReader(new InputStreamReader(((URLConnection)object2).getInputStream()));
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(DSConnect dsConnectApplet) unknown protocol", (Throwable)exception);
        }
        n = dataInputStreamEndian.readIntEndian();
        object2 = null;
        try {
            n2 = dataInputStreamEndian.readIntEndian() - 12;
            object = new byte[n2];
            dataInputStreamEndian.read((byte[])object);
            n4 = dataInputStreamEndian.readIntEndian();
            object2 = new DSEncryptValues();
            ((DSEncryptValues)object2).baSessionKey = byArray2;
            ((DSEncryptValues)object2).nConsoleRandomNum = n6;
            ((DSEncryptValues)object2).nApplianceRandomNum = n3;
            ((DSEncryptValues)object2).nTimeStamp = n5;
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(DSConnect dsConnectApplet) negative length value", (Throwable)negativeArraySizeException);
        }
        return object2;
    }

    public final String getLastError() {
        return this.m_strError;
    }

    public static void dsConnectApplianceAVSP(DataOutputStreamEndian dataOutputStreamEndian, DataInputStreamEndian dataInputStreamEndian, DSPath dSPath, String string, String string2, boolean bl, AVSPStatus aVSPStatus) throws IOException, SSLException {
        int n;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(DSConnect DSConnectApplianceAVSP) connecting to port " + dSPath.getPortNumber() + " channel " + dSPath.getCascadeChannel() + " RIP ID: " + dSPath.getRIPId() + ", Login Timeout: " + dSPath.getLoginTimeOut()));
        byte[] byArray = string.getBytes("UTF-8");
        byte[] byArray2 = string2.getBytes("UTF-8");
        byte[] byArray3 = new byte[8];
        if (dSPath.getRIPId().length() > 0) {
            byArray3 = DSConnect.packRipID(dSPath.getRIPId());
        }
        dataOutputStreamEndian.writeBytes("BEEF");
        if (bl) {
            dataOutputStreamEndian.writeShort(257);
        } else {
            dataOutputStreamEndian.writeShort(256);
        }
        int n2 = 202 + byArray3.length + 1 + 1 + 4;
        dataOutputStreamEndian.writeShort(n2);
        dataOutputStreamEndian.writeByte(byArray.length);
        dataOutputStreamEndian.write(byArray);
        for (n = 0; n < 96 - byArray.length; ++n) {
            dataOutputStreamEndian.writeByte(0);
        }
        dataOutputStreamEndian.writeByte(byArray2.length);
        dataOutputStreamEndian.write(byArray2);
        for (n = 0; n < 96 - byArray2.length; ++n) {
            dataOutputStreamEndian.writeByte(0);
        }
        dataOutputStreamEndian.write(byArray3);
        dataOutputStreamEndian.writeByte(dSPath.getPortNumber());
        dataOutputStreamEndian.writeByte(dSPath.getCascadeChannel());
        dataOutputStreamEndian.writeInt(aVSPStatus.getClientRandom());
        dataOutputStreamEndian.flush();
        Socket socket = dataInputStreamEndian.getSocket();
        socket.setSoTimeout(1925);
        int n3 = dSPath.getLoginTimeOut() / 2;
        if (dSPath.getLoginTimeOut() < 50) {
            socket.setSoTimeout(950);
            n3 = dSPath.getLoginTimeOut() - 1;
        }
        int n4 = 0;
        do {
            try {
                n4 = dataInputStreamEndian.readInt();
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (SocketException socketException) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(DSConnect DSConnectApplianceAVSP) socket closed at time " + n3));
                throw new SocketException(socketException.getMessage());
            }
        } while (n4 == 0 && --n3 > 0);
        if (n3 == 0) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(DSConnect DSConnectApplianceAVSP) socket timed out");
            aVSPStatus.setLoginStatus((byte)-2);
        } else {
            int n5 = dataInputStreamEndian.readShort() & 0xFFFF;
            if (n5 == 33536) {
                int n6;
                dataInputStreamEndian.readShort();
                aVSPStatus.setLoginStatus(dataInputStreamEndian.readByte());
                for (n6 = 0; n6 < 2; ++n6) {
                    dataInputStreamEndian.readByte();
                }
                n6 = dataInputStreamEndian.readByte();
                aVSPStatus.setVideoSocketUsed((n6 & 1) == 0);
                aVSPStatus.setVideoEncrypted((n6 & 2) != 0);
                aVSPStatus.setApplianceRandom(dataInputStreamEndian.readInt());
                byte by = dataInputStreamEndian.readByte();
                byte[] byArray4 = new byte[96];
                dataInputStreamEndian.read(byArray4);
                String string3 = new String(byArray4, 0, (int)by, "UTF-8");
                int n7 = string3.indexOf(0);
                if (n7 >= 0) {
                    string3 = string3.substring(0, n7);
                }
                aVSPStatus.setUserName(string3);
            } else {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(DSConnect DSConnectApplianceAVSP) bad login status response: " + Integer.toHexString(n5)));
                aVSPStatus.setLoginStatus((byte)-1);
            }
        }
        socket.setSoTimeout(0);
    }

    public static void dsConnectApplianceAVSP(DataOutputStreamEndian dataOutputStreamEndian, DataInputStreamEndian dataInputStreamEndian, DSPath dSPath, String string, String string2, byte by, AVSPStatus aVSPStatus) throws IOException, SSLException {
        int n;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(DSConnect DSConnectApplianceAVSP) connecting to port " + dSPath.getPortNumber() + " channel " + dSPath.getCascadeChannel() + " RIP ID: " + dSPath.getRIPId() + ", Login Timeout: " + dSPath.getLoginTimeOut()));
        byte[] byArray = string.getBytes("UTF-8");
        byte[] byArray2 = string2.getBytes("UTF-8");
        byte[] byArray3 = new byte[8];
        if (dSPath.getRIPId().length() > 0) {
            byArray3 = DSConnect.packRipID(dSPath.getRIPId());
        }
        dataOutputStreamEndian.writeBytes("BEEF");
        dataOutputStreamEndian.writeShort(258);
        int n2 = 202 + byArray3.length + 1 + 1 + 4 + 1;
        dataOutputStreamEndian.writeShort(n2);
        dataOutputStreamEndian.writeByte(byArray.length);
        dataOutputStreamEndian.write(byArray);
        for (n = 0; n < 96 - byArray.length; ++n) {
            dataOutputStreamEndian.writeByte(0);
        }
        dataOutputStreamEndian.writeByte(byArray2.length);
        dataOutputStreamEndian.write(byArray2);
        for (n = 0; n < 96 - byArray2.length; ++n) {
            dataOutputStreamEndian.writeByte(0);
        }
        dataOutputStreamEndian.write(byArray3);
        dataOutputStreamEndian.writeByte(dSPath.getPortNumber());
        dataOutputStreamEndian.writeByte(dSPath.getCascadeChannel());
        dataOutputStreamEndian.writeInt(aVSPStatus.getClientRandom());
        dataOutputStreamEndian.writeByte(by);
        dataOutputStreamEndian.flush();
        Socket socket = dataInputStreamEndian.getSocket();
        socket.setSoTimeout(1925);
        int n3 = dSPath.getLoginTimeOut() / 2;
        if (dSPath.getLoginTimeOut() < 50) {
            socket.setSoTimeout(950);
            n3 = dSPath.getLoginTimeOut() - 1;
        }
        int n4 = 0;
        do {
            try {
                n4 = dataInputStreamEndian.readInt();
            }
            catch (SocketTimeoutException socketTimeoutException) {
            }
            catch (SocketException socketException) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(DSConnect DSConnectApplianceAVSP) socket closed at time " + n3));
                throw new SocketException(socketException.getMessage());
            }
        } while (n4 == 0 && --n3 > 0);
        if (n3 == 0) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(DSConnect DSConnectApplianceAVSP) socket timed out");
            aVSPStatus.setLoginStatus((byte)-2);
        } else {
            int n5 = dataInputStreamEndian.readShort() & 0xFFFF;
            if (n5 == 33541) {
                dataInputStreamEndian.readShort();
                aVSPStatus.setLoginStatus(dataInputStreamEndian.readByte());
                aVSPStatus.setSharePreemptionMode(dataInputStreamEndian.readByte());
                aVSPStatus.setPreemptionTimeout(dataInputStreamEndian.readByte());
                aVSPStatus.setShareRequestTimeout(dataInputStreamEndian.readByte());
                aVSPStatus.setApplianceRandom(dataInputStreamEndian.readInt());
                short s = dataInputStreamEndian.readShort();
                Trace.logInfo((String)TRACE_CONTEXT, (String)("DSConnect sMisc=" + Integer.toHexString(s)));
                aVSPStatus.setVideoSocketUsed((s & 1) == 0);
                aVSPStatus.setVideoEncrypted((s & 2) != 0);
                aVSPStatus.setVideoEncodingType((byte)(s & 0x1C));
                aVSPStatus.setVideoSessionType(s);
                int n6 = dataInputStreamEndian.readByte() & 0xFF;
                byte[] byArray4 = new byte[96];
                dataInputStreamEndian.read(byArray4);
                String string3 = new String(byArray4, 0, n6, "UTF-8");
                int n7 = string3.indexOf(0);
                if (n7 >= 0) {
                    string3 = string3.substring(0, n7);
                }
                aVSPStatus.setUserName(string3);
            } else {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(DSConnect DSConnectApplianceAVSP) bad login status response: " + Integer.toHexString(n5)));
                aVSPStatus.setLoginStatus((byte)-1);
            }
        }
        socket.setSoTimeout(0);
    }

    public static void dsConnectApplianceAVSP(DataOutputStreamEndian dataOutputStreamEndian, DataInputStreamEndian dataInputStreamEndian, AVSPStatus aVSPStatus) throws IOException, SSLException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(DSConnect DSConnectApplianceAVSP)");
        dataOutputStreamEndian.writeBytes("BEEF");
        dataOutputStreamEndian.writeShort(272);
        int n = 12;
        dataOutputStreamEndian.writeShort(n);
        dataOutputStreamEndian.writeInt(aVSPStatus.getClientRandom());
        dataOutputStreamEndian.flush();
        Socket socket = dataInputStreamEndian.getSocket();
        socket.setSoTimeout(2000);
        int n2 = 90;
        int n3 = 0;
        do {
            try {
                n3 = dataInputStreamEndian.readInt();
            }
            catch (SocketTimeoutException socketTimeoutException) {
                // empty catch block
            }
        } while (n3 == 0 && --n2 > 0);
        if (n2 == 0) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(DSConnect DSConnectApplianceAVSP) socket timed out");
            aVSPStatus.setLoginStatus((byte)-1);
        } else {
            int n4 = dataInputStreamEndian.readShort() & 0xFFFF;
            if (n4 == 33536) {
                int n5;
                dataInputStreamEndian.readShort();
                aVSPStatus.setLoginStatus(dataInputStreamEndian.readByte());
                for (n5 = 0; n5 < 2; ++n5) {
                    dataInputStreamEndian.readByte();
                }
                n5 = dataInputStreamEndian.readByte();
                aVSPStatus.setVideoSocketUsed((n5 & 1) == 0);
                aVSPStatus.setVideoEncrypted((n5 & 2) != 0);
                aVSPStatus.setApplianceRandom(dataInputStreamEndian.readInt());
                byte by = dataInputStreamEndian.readByte();
                byte[] byArray = new byte[96];
                dataInputStreamEndian.read(byArray);
                String string = new String(byArray, 0, (int)by, "UTF-8");
                int n6 = string.indexOf(0);
                if (n6 >= 0) {
                    string = string.substring(0, n6);
                }
                aVSPStatus.setUserName(string);
            } else {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(DSConnect DSConnectApplianceAVSP) bad login status response: " + Integer.toHexString(n4)));
                aVSPStatus.setLoginStatus((byte)-1);
            }
        }
        socket.setSoTimeout(0);
    }

    public static boolean dsConnectVideoAVSP(DataOutputStream dataOutputStream, DataInputStream dataInputStream, int n, int n2) throws IOException {
        int n3;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(DSConnect DSConnectVideoAVSP) nClientRandom: " + n + " nApplianceRandom: " + n2));
        for (n3 = 0; n3 < 4; ++n3) {
            dataOutputStream.writeByte(0);
        }
        dataOutputStream.writeByte(1);
        dataOutputStream.writeByte(1);
        n3 = 16;
        dataOutputStream.writeShort(n3);
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(n2);
        dataOutputStream.flush();
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(DSConnect DSConnectVideoAVSP) sent the video connect message");
        dataInputStream.readInt();
        short s = dataInputStream.readShort();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(DSConnect DSConnectVideoAVSP) read the message type=" + s));
        boolean bl = false;
        if (s == 132) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(DSConnect DSConnectVideoAVSP) messagetype = AVSPStatus.VIDEO_CONNECT_STATUS");
            short s2 = dataInputStream.readShort();
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(DSConnect DSConnectVideoAVSP) read the message length=" + s2));
            byte by = dataInputStream.readByte();
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(DSConnect DSConnectVideoAVSP) read the connect status=" + by));
            for (int i = 0; i < 7; ++i) {
                dataInputStream.readByte();
            }
            bl = by == 0;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(DSConnect DSConnectVideoAVSP) returning bReturn=" + bl));
        return bl;
    }

    public void dsConnectEmbedded(DatagramSocket datagramSocket, String string, int n) throws IOException {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("DSConnect dsConnectEmbedded) UDP: Address= " + string + " Port= " + n));
        byte[] byArray = new byte[10];
        DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length, InetAddress.getByName(string), n);
        for (int i = 0; i < 6; ++i) {
            datagramSocket.send(datagramPacket);
            try {
                Thread.sleep(60L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static byte[] packRipID(String string) throws IOException {
        if (string.indexOf(45) >= 0) {
            int n = string.indexOf(45);
            string = string.substring(0, n) + string.substring(n + 1);
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[8];
        for (int i = 0; i < byArray.length / 2; ++i) {
            byte by;
            byte by2;
            if (byArray[i * 2] >= 48 && byArray[i * 2] <= 57) {
                by2 = (byte)(byArray[i * 2] - 48);
            } else if (byArray[i * 2] >= 65 && byArray[i * 2] <= 70) {
                by2 = (byte)(byArray[i * 2] - 65 + 10);
            } else if (byArray[i * 2] >= 97 && byArray[i * 2] <= 102) {
                by2 = (byte)(byArray[i * 2] - 97 + 10);
            } else {
                throw new IOException("RIP ID contains non-hex characters");
            }
            if (byArray[i * 2 + 1] >= 48 && byArray[i * 2 + 1] <= 57) {
                by = (byte)(byArray[i * 2 + 1] - 48);
            } else if (byArray[i * 2 + 1] >= 65 && byArray[i * 2 + 1] <= 70) {
                by = (byte)(byArray[i * 2 + 1] - 65 + 10);
            } else if (byArray[i * 2 + 1] >= 97 && byArray[i * 2 + 1] <= 102) {
                by = (byte)(byArray[i * 2 + 1] - 97 + 10);
            } else {
                throw new IOException("RIP ID contains non-hex characters");
            }
            byArray2[i] = (byte)(by2 << 4 | by);
        }
        return byArray2;
    }
}

