/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import java.util.Arrays;

class DSData {
    private static final int MAX_DATA_SIZE = 8220;
    private static final int VSP_PACKET_HEADER_LENGTH = 8;
    protected static final int VSP_PACKET_LENGTH_OFFSET = 6;
    protected static final int VSP_NUM_BYTES_PACKET_LENGTH = 2;
    protected static final int AERP_NUM_BYTES_PACKET_LENGTH = 4;
    private byte[] m_data = new byte[8220];
    private int m_nUsedLength = 0;
    private int m_nDataID;
    private int m_nPacketHeaderLength;
    private int m_nPacketLengthOffset;
    private int m_nNumBytesPacketLength;

    public DSData(int n, int n2) {
        this.m_nPacketHeaderLength = n;
        this.m_nPacketLengthOffset = n2;
        this.m_nNumBytesPacketLength = this.m_nPacketLengthOffset == 6 ? 2 : 4;
    }

    public DSData(int n, int n2, int n3) {
        this.m_nDataID = n;
        this.m_nPacketHeaderLength = n2;
        this.m_nPacketLengthOffset = n3;
        this.m_nNumBytesPacketLength = this.m_nPacketLengthOffset == 6 ? 2 : 4;
    }

    public void setUsedLength(int n) {
        this.m_nUsedLength = n <= this.m_data.length ? n : this.m_data.length;
    }

    public int getUsedLength() {
        return this.m_nUsedLength;
    }

    public byte[] getData() {
        return this.m_data;
    }

    public void setData(byte[] byArray) {
        this.m_data = byArray;
    }

    public void setData(byte by, byte by2) {
        this.m_data[by] = by2;
    }

    public short getPacketLength() {
        if (this.m_nNumBytesPacketLength == 2) {
            return (short)(this.m_data[this.m_nPacketLengthOffset] << 8 & 0xFF00 | this.m_data[this.m_nPacketLengthOffset + 1] & 0xFF);
        }
        if (this.m_nNumBytesPacketLength == 4) {
            return (short)(this.m_data[this.m_nPacketLengthOffset + 2] << 8 & 0xFF00 | this.m_data[this.m_nPacketLengthOffset + 3] & 0xFF);
        }
        return 0;
    }

    public void clearHeaderAndCommand() {
        for (int i = 0; i < this.m_nPacketHeaderLength + 8; ++i) {
            this.m_data[i] = 0;
        }
    }

    public int getSize() {
        return this.m_data.length;
    }

    private void clearAll() {
        Arrays.fill(this.m_data, (byte)0);
    }

    public byte getInfo(int n) {
        return this.m_data[n];
    }
}

