/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.video.ApplianceSession;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;

public class DSKeyListener
extends KeyAdapter {
    private ApplianceSession m_applianceSession;
    private boolean m_bAltKeyPressed = false;
    private boolean m_bAltKeyReleaseOnTabOrEscSent = false;
    private boolean m_bCtrlKeyPressed = false;
    private boolean m_bCtrlKeyReleaseOnEscSent = false;
    private boolean m_bCapLockKeyPressed = false;
    public static final String TRACE_CONTEXT = "Video Viewer";
    protected Vector m_vKeyPressedList = new Vector();
    boolean m_bProcessingGeneratedKeyPress = false;
    protected boolean m_bIsRunningOnSolaris = false;
    protected boolean m_bIsRunningOnMacintosh = false;

    public DSKeyListener(ApplianceSession applianceSession) {
        this.m_applianceSession = applianceSession;
        String string = System.getProperty("os.name").toLowerCase();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("OS name: " + string));
        if (string.indexOf("solaris") != -1 || string.indexOf("sunos") != -1) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)" Detected Solaris OS.");
            this.m_bIsRunningOnSolaris = true;
        }
        if (string.indexOf("mac") != -1) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)" Detected Macintosh.");
            this.m_bIsRunningOnMacintosh = true;
        }
    }

    public void keyPressed(KeyEvent keyEvent) throws NullPointerException {
        int n = keyEvent.getKeyCode();
        if (!this.m_bProcessingGeneratedKeyPress && (!this.m_bIsRunningOnSolaris || n != 144 && n != 20)) {
            this.m_vKeyPressedList.addElement(keyEvent);
        }
        if (n == 18) {
            Trace.logInfo((String)"VideoViewerTrace", (String)"DSKeyListener.keyPressed ALT key pressed");
            this.m_bAltKeyPressed = true;
            this.m_bAltKeyReleaseOnTabOrEscSent = false;
        } else if (n == 17) {
            Trace.logInfo((String)"VideoViewerTrace", (String)"DSKeyListener.keyPressed CTRL key pressed");
            this.m_bCtrlKeyPressed = true;
            this.m_bCtrlKeyReleaseOnEscSent = false;
        }
        this.m_applianceSession.cmdKeyPressed(n, keyEvent.getKeyChar(), keyEvent.getKeyLocation());
        if (this.m_bIsRunningOnMacintosh && n == 20) {
            this.m_bCapLockKeyPressed = true;
            this.m_applianceSession.cmdKeyReleased(n, keyEvent.getKeyChar(), keyEvent.getKeyLocation());
        }
        if (this.m_bIsRunningOnSolaris && (n == 144 || n == 20)) {
            this.m_applianceSession.cmdKeyReleased(n, keyEvent.getKeyChar(), keyEvent.getKeyLocation());
        }
        keyEvent.consume();
    }

    public void keyReleased(KeyEvent keyEvent) throws NullPointerException {
        int n = keyEvent.getKeyCode();
        if (!this.m_bIsRunningOnMacintosh) {
            KeyEvent keyEvent2 = this.getKeyPressEvent(keyEvent);
            if (keyEvent2 == null && n != 10 && n != 32 && n != 27) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("Generating missing key press for Java Key:" + n + "(" + keyEvent.getKeyChar() + ")"));
                this.m_bProcessingGeneratedKeyPress = true;
                this.keyPressed(keyEvent);
                this.m_bProcessingGeneratedKeyPress = false;
            } else {
                this.m_vKeyPressedList.removeElement(keyEvent2);
            }
        }
        if (this.m_bIsRunningOnMacintosh && !this.m_bCapLockKeyPressed && n == 20) {
            this.m_applianceSession.cmdKeyPressed(n, keyEvent.getKeyChar(), keyEvent.getKeyLocation());
        }
        this.m_bCapLockKeyPressed = false;
        if (n == 18) {
            this.m_bAltKeyPressed = false;
            Trace.logInfo((String)"VideoViewerTrace", (String)"DSKeyListener.keyReleased ALT key released");
            this.m_bAltKeyReleaseOnTabOrEscSent = false;
        } else if (n == 17) {
            this.m_bCtrlKeyPressed = false;
            Trace.logInfo((String)"VideoViewerTrace", (String)"DSKeyListener.keyReleased CTRL key released");
            this.m_bCtrlKeyReleaseOnEscSent = false;
        }
        if (this.m_bAltKeyPressed && (n == 9 || n == 27)) {
            Trace.logInfo((String)"VideoViewerTrace", (String)"DSKeyListener.keyReleased TAB or ESC key released with ALT down");
            keyEvent.consume();
            if (!this.m_bAltKeyReleaseOnTabOrEscSent) {
                Trace.logInfo((String)"VideoViewerTrace", (String)"DSKeyListener.keyReleased sending ALT key released then pressed/released pair");
                this.m_applianceSession.cmdKeyReleased(18);
                this.m_applianceSession.cmdKeyPressed(18);
                this.m_applianceSession.cmdKeyReleased(18);
                this.m_bAltKeyReleaseOnTabOrEscSent = true;
            }
            return;
        }
        if (this.m_bCtrlKeyPressed && n == 27) {
            Trace.logInfo((String)"VideoViewerTrace", (String)"DSKeyListener.keyReleased ESC key released with CTRL down");
            keyEvent.consume();
            if (!this.m_bCtrlKeyReleaseOnEscSent) {
                Trace.logInfo((String)"VideoViewerTrace", (String)"DSKeyListener.keyReleased sending CTRL key released");
                this.m_applianceSession.cmdKeyReleased(17);
                this.m_bCtrlKeyReleaseOnEscSent = true;
            }
            return;
        }
        this.m_applianceSession.cmdKeyReleased(keyEvent.getKeyCode(), keyEvent.getKeyChar(), keyEvent.getKeyLocation());
        keyEvent.consume();
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void listeningWindowDeactivated() {
        Trace.logInfo((String)"VideoViewerTrace", (String)"DSKeyListener.listeningWindowDeactivated");
        if (this.m_bAltKeyPressed) {
            this.m_bAltKeyPressed = false;
            if (!this.m_bAltKeyReleaseOnTabOrEscSent) {
                Trace.logInfo((String)"VideoViewerTrace", (String)"DSKeyListener.listeningWindowDeactivated sending ALT key released then pressed/released pair");
                this.m_applianceSession.cmdKeyReleased(18);
                this.m_applianceSession.cmdKeyPressed(18);
                this.m_applianceSession.cmdKeyReleased(18);
                this.m_bAltKeyReleaseOnTabOrEscSent = true;
            }
        }
    }

    KeyEvent getKeyPressEvent(KeyEvent keyEvent) {
        KeyEvent keyEvent2 = null;
        int n = keyEvent.getKeyCode();
        for (int i = 0; i < this.m_vKeyPressedList.size(); ++i) {
            KeyEvent keyEvent3 = (KeyEvent)this.m_vKeyPressedList.elementAt(i);
            if (n != 0) {
                if (keyEvent3.getKeyCode() != n) continue;
                keyEvent2 = keyEvent3;
                break;
            }
            if (keyEvent3.getKeyChar() != keyEvent.getKeyChar()) continue;
            keyEvent2 = keyEvent3;
            break;
        }
        return keyEvent2;
    }
}

