/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.video.Win32Library;
import com.avocent.video.WindowsKey;

class DSKeyTranslator {
    private Win32Library m_libWin32;
    private boolean m_bWin32LibraryLoaded = false;
    private boolean m_bLinuxLibraryLoaded = false;
    private boolean m_bSolarisLibraryLoaded = false;
    public static final int SCAN_CODE_ALT_LEFT = 56;
    public static final int SCAN_CODE_ALT_RIGHT = 105;
    public static final int SCAN_CODE_CTRL_LEFT = 29;
    public static final int SCAN_CODE_CTRL_RIGHT = 101;
    public static final int SCAN_CODE_SHIFT_RIGHT = 54;
    public static final int SCAN_CODE_SHIFT_LEFT = 42;
    public static final int SCAN_CODE_TAB = 15;
    public static final int SCAN_CODE_ESCAPE = 1;
    public static final int SCAN_CODE_HENKEN = 121;
    public static final int SCAN_CODE_MUHENKAN = 123;
    public static final int SCAN_CODE_YEN = 125;
    public static final int SCAN_CODE_WINDOWS_KEY_LEFT = 107;
    public static final int SCAN_CODE_WINDOWS_KEY_RIGHT = 108;
    public static final int SCAN_CODE_WINDOWS_APP = 109;
    public static final int SCAN_CODE_F10 = 68;
    public static final int SCAN_CODE_WINDOWS_START_MENU = 57435;
    public static final int SCAN_CODE_WINDOWS_APP_MENU = 57437;
    public static final int SCAN_CODE_OEM_5 = 61441;
    public static final int SCAN_CODE_SUN_STOP = 200;
    public static final int SCAN_CODE_SUN_FRONT = 201;
    public static final int SCAN_CODE_SUN_OPEN_EXECUTE = 202;
    public static final int SCAN_CODE_SUN_MUTE = 203;
    public static final int SCAN_CODE_SUN_POWER_SLEEP = 204;
    public static final int SCAN_CODE_SUN_VOL_PLUS = 205;
    public static final int SCAN_CODE_SUN_VOL_MINUS = 206;
    public static final int SCAN_CODE_SUN_AGAIN = 207;
    public static final int SCAN_CODE_SUN_CUT = 208;
    public static final int SCAN_CODE_SUN_COPY = 209;
    public static final int SCAN_CODE_SUN_PASTE = 210;
    public static final int SCAN_CODE_SUN_FIND = 211;
    public static final int SCAN_CODE_SUN_HELP = 212;
    public static final int SCAN_CODE_SUN_PROPS_MENU = 213;
    public static final int SCAN_CODE_SUN_UNDO = 214;
    public static final int SCAN_CODE_ALT_LEFT_RELEASE = 61457;
    public static final int SCAN_CODE_ALT_RIGHT_RELEASE = 14741521;
    public static final int SCAN_CODE_CTRL_LEFT_RELEASE = 61460;
    public static final int SCAN_CODE_CTRL_RIGHT_RELEASE = 14741524;
    public static final int SCAN_CODE_SHIFT_RIGHT_RELEASE = 61529;
    public static final int SCAN_CODE_SHIFT_LEFT_RELEASE = 61458;
    public static final int SCAN_CODE_TAB_RELEASE = 61453;
    public static final int SCAN_CODE_ESCAPE_RELEASE = 61558;
    public static final int SCAN_CODE_HENKEN_RELEASE = 61540;
    public static final int SCAN_CODE_MUHENKAN_RELEASE = 61543;
    public static final int SCAN_CODE_YEN_RELEASE = 61546;
    public static final int SCAN_CODE_WINDOWS_KEY_LEFT_RELEASE = 14741535;
    public static final int SCAN_CODE_WINDOWS_KEY_RIGHT_RELEASE = 14741543;
    public static final int SCAN_CODE_WINDOWS_APP_RELEASE = 14741551;
    public static final int SCAN_CODE_F10_RELEASE = 61449;
    public static final int SCAN_CODE_WINDOWS_START_MENU_RELEASE = 14741595;
    public static final int SCAN_CODE_WINDOWS_APP_MENU_RELEASE = 14741597;
    public static final int SCAN_CODE_OEM_5_RELEASE = 0xF0F001;
    public static final int SCAN_CODE_SUN_STOP_RELEASE = -1014990848;
    public static final int SCAN_CODE_SUN_FRONT_RELEASE = -1014991104;
    public static final int SCAN_CODE_SUN_OPEN_EXECUTE_RELEASE = -1014991872;
    public static final int SCAN_CODE_SUN_MUTE_RELEASE = 14741539;
    public static final int SCAN_CODE_SUN_POWER_SLEEP_RELEASE = -1014995456;
    public static final int SCAN_CODE_SUN_VOL_PLUS_RELEASE = 14741554;
    public static final int SCAN_CODE_SUN_VOL_MINUS_RELEASE = 14741537;
    public static final int SCAN_CODE_SUN_AGAIN_RELEASE = -1014990592;
    public static final int SCAN_CODE_SUN_CUT_RELEASE = -1014990080;
    public static final int SCAN_CODE_SUN_COPY_RELEASE = -1014989824;
    public static final int SCAN_CODE_SUN_PASTE_RELEASE = -1014989568;
    public static final int SCAN_CODE_SUN_FIND_RELEASE = -1014989312;
    public static final int SCAN_CODE_SUN_HELP_RELEASE = -1014991616;
    public static final int SCAN_CODE_SUN_PROPS_MENU_RELEASE = -1014991360;
    public static final int SCAN_CODE_SUN_UNDO_RELEASE = -1014990336;
    private static final int[] ARRAY_TRANSLATE_UNICODE_USB = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 42, 43, 40, 0, 0, 0, 0, 0, 225, 224, 226, 72, 57, 0, 0, 0, 0, 0, 0, 41, 0, 0, 0, 0, 44, 75, 78, 77, 74, 80, 82, 79, 81, 0, 0, 0, 54, 45, 55, 56, 39, 30, 31, 32, 33, 34, 35, 36, 37, 38, 0, 51, 0, 46, 0, 0, 0, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 47, 49, 48, 0, 0, 98, 89, 90, 91, 92, 93, 94, 95, 96, 97, 85, 87, 0, 86, 99, 84, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 0, 0, 0, 76, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 71, 0, 0, 0, 0, 0, 0, 0, 0, 70, 73};
    private static final int[][] WindowsKeyMap = new int[][]{{10, 13}, {8, 8}, {9, 9}, {3, 3}, {12, 12}, {16, 16}, {17, 17}, {18, 18}, {19, 19}, {20, 20}, {27, 27}, {32, 32}, {33, 33}, {34, 34}, {35, 35}, {36, 36}, {37, 37}, {38, 38}, {39, 39}, {40, 40}, {44, 188}, {45, 189}, {46, 190}, {47, 191}, {48, 48}, {49, 49}, {50, 50}, {51, 51}, {52, 52}, {53, 53}, {54, 54}, {55, 55}, {56, 56}, {57, 57}, {59, 186}, {61, 187}, {65, 65}, {66, 66}, {67, 67}, {68, 68}, {69, 69}, {70, 70}, {71, 71}, {72, 72}, {73, 73}, {74, 74}, {75, 75}, {76, 76}, {77, 77}, {78, 78}, {79, 79}, {80, 80}, {81, 81}, {82, 82}, {83, 83}, {84, 84}, {85, 85}, {86, 86}, {87, 87}, {88, 88}, {89, 89}, {90, 90}, {91, 219}, {92, 220}, {93, 221}, {96, 96}, {97, 97}, {98, 98}, {99, 99}, {100, 100}, {101, 101}, {102, 102}, {103, 103}, {104, 104}, {105, 105}, {106, 106}, {107, 107}, {108, 108}, {109, 109}, {110, 110}, {111, 111}, {127, 46}, {144, 144}, {145, 145}, {112, 112}, {113, 113}, {114, 114}, {115, 115}, {116, 116}, {117, 117}, {118, 118}, {119, 119}, {120, 120}, {121, 121}, {122, 122}, {123, 123}, {61440, 124}, {61441, 125}, {61442, 126}, {61443, 127}, {61444, 128}, {61445, 129}, {61446, 130}, {61447, 131}, {61448, 132}, {61449, 133}, {61450, 134}, {61451, 135}, {154, 44}, {155, 45}, {156, 47}, {192, 192}, {222, 222}, {28, 28}, {29, 29}, {263, 25}, {240, 240}, {241, 241}, {242, 242}, {243, 244}, {244, 243}, {245, 245}, {0, 0}};
    private static final int[] ARRAY_TRANSLATE_SCANCODE_USB = new int[]{0, 41, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 45, 46, 42, 43, 20, 26, 8, 21, 23, 28, 24, 12, 18, 19, 47, 48, 40, 224, 4, 22, 7, 9, 10, 11, 13, 14, 15, 51, 52, 53, 225, 49, 29, 27, 6, 25, 5, 17, 16, 54, 55, 56, 229, 85, 226, 44, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 83, 71, 95, 96, 97, 86, 92, 93, 94, 87, 89, 90, 91, 98, 99, 70, 0, 100, 68, 69, 74, 82, 75, 80, 0, 79, 77, 81, 78, 73, 76, 88, 228, 72, 70, 84, 230, 0, 227, 231, 101, 0, 0, 136, 0, 0, 135, 0, 0, 148, 147, 146, 138, 0, 139, 104, 137, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 117, 122, 227, 231, 101, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 50, 145, 144};
    private static final long[] ARRAY_TRANSLATE_SCANCODEKEY_SCANCODESET2 = new long[]{0L, 118L, 22L, 30L, 38L, 37L, 46L, 54L, 61L, 62L, 70L, 69L, 78L, 85L, 102L, 13L, 21L, 29L, 36L, 45L, 44L, 53L, 60L, 67L, 68L, 77L, 84L, 91L, 90L, 20L, 28L, 27L, 35L, 43L, 52L, 51L, 59L, 66L, 75L, 76L, 82L, 14L, 18L, 93L, 26L, 34L, 33L, 42L, 50L, 49L, 58L, 65L, 73L, 74L, 89L, 124L, 17L, 41L, 88L, 5L, 6L, 4L, 12L, 3L, 11L, 131L, 10L, 1L, 9L, 119L, 126L, 108L, 117L, 125L, 123L, 107L, 115L, 116L, 121L, 105L, 114L, 122L, 112L, 113L, 57468L, 0L, 97L, 120L, 7L, 57452L, 57461L, 57469L, 57451L, 0L, 57460L, 57449L, 57458L, 57466L, 57456L, 57457L, 57434L, 57364L, 57620L, 57468L, 57418L, 57361L, 0L, 57375L, 57383L, 57391L, 0L, 0L, 19L, 0L, 0L, 81L, 0L, 0L, 95L, 98L, 99L, 100L, 0L, 103L, 47L, 106L, 63L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 3271587840L, 3271587584L, 3271586816L, 0L, 3271583232L, 0L, 0L, 3271588096L, 3271588608L, 3271588864L, 3271589120L, 3271589376L, 3271587072L, 3271587328L, 3271588352L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 93L, 241L, 242L};
    private static final long[] ARRAY_TRANSLATE_SCANCODEKEY_SCANCODESET2_RELEASED = new long[]{0L, 61558L, 61462L, 61470L, 61478L, 61477L, 61486L, 61494L, 61501L, 61502L, 61510L, 61509L, 61518L, 61525L, 61542L, 61453L, 61461L, 61469L, 61476L, 61485L, 61484L, 61493L, 61500L, 61507L, 61508L, 61517L, 61524L, 61531L, 61530L, 61460L, 61468L, 61467L, 61475L, 61483L, 61492L, 61491L, 61499L, 61506L, 61515L, 61516L, 61522L, 61454L, 61458L, 61533L, 61466L, 61474L, 61473L, 61482L, 61490L, 61489L, 61498L, 61505L, 61513L, 61514L, 61529L, 61564L, 61457L, 61481L, 61528L, 61445L, 61446L, 61444L, 61452L, 61443L, 61451L, 61571L, 61450L, 61441L, 61449L, 61559L, 61566L, 61548L, 61557L, 61565L, 61563L, 61547L, 61555L, 61556L, 61561L, 61545L, 61554L, 61562L, 61552L, 61553L, 14741628L, 0L, 61537L, 61560L, 61447L, 14741612L, 14741621L, 14741629L, 14741611L, 0L, 14741620L, 14741609L, 14741618L, 14741626L, 14741616L, 14741617L, 14741594L, 14741524L, 14807060L, 14741628L, 14741578L, 14741521L, 0L, 14741535L, 14741543L, 14741551L, 0L, 0L, 61459L, 0L, 0L, 61521L, 0L, 0L, 61535L, 61538L, 61539L, 61540L, 0L, 61543L, 61487L, 61546L, 61503L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 3279976448L, 3279976192L, 3279975424L, 0L, 3279971840L, 0L, 0L, 3279976704L, 3279977216L, 3279977472L, 3279977728L, 3279977984L, 3279975680L, 3279975936L, 3279976960L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 61533L, 61681L, 61682L};
    private static final int[] ARRAY_TRANSLATE_UNICODE_PS2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 102, 13, 90, 0, 119, 0, 0, 0, 18, 20, 17, 126, 88, 0, 0, 0, 0, 0, 0, 118, 0, 0, 0, 0, 41, 57469, 57466, 57449, 57452, 57451, 57461, 57460, 57458, 0, 0, 0, 65, 78, 73, 74, 69, 22, 30, 38, 37, 46, 54, 61, 62, 70, 0, 76, 0, 85, 0, 0, 0, 28, 50, 33, 35, 36, 43, 52, 51, 67, 59, 66, 75, 58, 49, 68, 77, 21, 45, 27, 44, 60, 42, 29, 34, 53, 26, 84, 93, 91, 0, 0, 112, 105, 114, 122, 107, 115, 116, 108, 117, 125, 124, 121, 0, 123, 113, 57418, 5, 6, 4, 12, 3, 11, 131, 10, 1, 9, 120, 7, 0, 0, 0, 57457, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 119, 126, 0, 0, 0, 0, 0, 0, 0, 0, 57584, 0, 0xE00070, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 14, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 82, 0, 117, 114, 107, 116};
    private static final int[] ARRAY_TRANSLATE_UNICODE_PS2_RELEASED = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 61542, 61453, 61530, 0, 61559, 0, 0, 0, 61458, 61460, 61457, 61566, 61528, 0, 0, 0, 0, 0, 0, 61558, 0, 0, 0, 0, 61481, 14741629, 14741626, 14741609, 14741612, 14741611, 14741621, 14741620, 14741618, 0, 0, 0, 61505, 61518, 61513, 61514, 61509, 61462, 61470, 61478, 61477, 61486, 61494, 61501, 61502, 61510, 0, 61516, 0, 61525, 0, 0, 0, 61468, 61490, 61473, 61475, 61476, 61483, 61492, 61491, 61507, 61499, 61506, 61515, 61498, 61489, 61508, 61517, 61461, 61485, 61467, 61484, 61500, 61482, 61469, 61474, 61493, 61466, 61524, 61533, 61531, 0, 0, 61552, 61545, 61554, 61562, 61547, 61555, 61556, 61548, 61557, 61565, 61564, 61561, 0, 61563, 61553, 14741578, 61445, 61446, 61444, 61452, 61443, 61451, 61571, 61450, 61441, 61449, 61560, 61447, 0, 0, 0, 14741617, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61559, 61566, 0, 0, 0, 0, 0, 0, 0, 0, 0xE0F0F0, 0, 14741616, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61454, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 61522, 0, 61557, 61554, 61547, 61556};

    public DSKeyTranslator() {
        try {
            this.m_libWin32 = new Win32Library();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Trace.logError((String)"VideoViewerTrace", (String)unsatisfiedLinkError.getMessage(), (Throwable)unsatisfiedLinkError);
        }
        DSKeyTranslator dSKeyTranslator = this;
        this.m_bWin32LibraryLoaded = dSKeyTranslator.m_libWin32.isWin32LibLoaded();
    }

    public static WindowsKey JavaKeyToWindowsKey(int n) {
        WindowsKey windowsKey = new WindowsKey();
        switch (n) {
            case 256: {
                windowsKey.m_nWindowsKey = 28;
                windowsKey.m_nModifiers = 8;
                return windowsKey;
            }
            case 257: {
                windowsKey.m_nWindowsKey = 28;
                windowsKey.m_nModifiers = 1;
                return windowsKey;
            }
            case 258: {
                windowsKey.m_nWindowsKey = 240;
                windowsKey.m_nModifiers = 8;
                return windowsKey;
            }
            case 262: {
                windowsKey.m_nWindowsKey = 21;
                windowsKey.m_nModifiers = 2;
                return windowsKey;
            }
        }
        for (int i = 0; i < WindowsKeyMap.length; ++i) {
            if (WindowsKeyMap[i][0] != n) continue;
            windowsKey.m_nWindowsKey = WindowsKeyMap[i][1];
            windowsKey.m_nModifiers = 0;
            return windowsKey;
        }
        return windowsKey;
    }

    public static int windowsKeyToJavaKey(int n, int n2) {
        Trace.logInfo((String)"VideoViewerTrace", (String)("DSKeyTranslator.windowsKeyToJavaKey nWindowsKey:" + n));
        switch (n) {
            case 28: {
                if ((n2 & 8) != 0) {
                    return 256;
                }
                if ((n2 & 1) == 0) break;
                return 257;
            }
            case 240: {
                if ((n2 & 8) == 0) break;
                return 258;
            }
            case 21: {
                return 262;
            }
        }
        for (int i = 0; i < WindowsKeyMap.length; ++i) {
            if (WindowsKeyMap[i][1] != n) continue;
            return WindowsKeyMap[i][0];
        }
        return 0;
    }

    public static int translateKeyScanCodeToUSB(int n) {
        int n2 = 0;
        if (n < ARRAY_TRANSLATE_SCANCODE_USB.length) {
            n2 = ARRAY_TRANSLATE_SCANCODE_USB[n];
        }
        return n2;
    }

    public static long translateKeyScanCodeToScanCodeSet2(int n) {
        long l = 0L;
        if (n < ARRAY_TRANSLATE_SCANCODEKEY_SCANCODESET2.length) {
            l = ARRAY_TRANSLATE_SCANCODEKEY_SCANCODESET2[n];
        }
        return l;
    }

    public static long translateKeyScanCodeToScanCodeSet2Released(int n) {
        long l = 0L;
        if (n < ARRAY_TRANSLATE_SCANCODEKEY_SCANCODESET2_RELEASED.length) {
            l = ARRAY_TRANSLATE_SCANCODEKEY_SCANCODESET2_RELEASED[n];
        }
        return l;
    }

    public static int translateKey(int n) {
        return 0;
    }
}

