/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.UserNotification;
import java.text.MessageFormat;

public class DSPath {
    public static final String CNAME = "DSPath";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    static final String TRACE_CONTEXT = "VideoViewerTrace";
    private static final int RIP_ID_EXPECTED_LENGTH = 13;
    private static final String ENCRYPT_VIDEO = "video";
    private static final String PPP_CONNECTION = "ppp";
    private String m_szIPAddress = "";
    private int m_nPortNumber = 0;
    private String m_szRIPId = "";
    private int m_nChannel = 0;
    private String m_szDeviceID = "";
    private String m_szServerName = "";
    private boolean m_bUseCommandLineCredentials = true;
    private boolean m_bAPCP = false;
    private String m_szConnection = "avsp-ssl";
    public static final String AVSP_SSL = "avsp-ssl";
    public static final String AVSP_CLEAR = "avsp-clear";
    public static final String AERP_TCP = "tcp";
    public static final String AERP_UDP = "udp";
    public static final String AERP_TCP_UDP = "tcpudp";
    private String m_szDeviceType = "avsp";
    private int m_nLoginTimeOut = 30;
    public static final String TYPE_AVSP = "avsp";
    public static final String TYPE_PHASE6 = "phase6";
    public static final String TYPE_EXODUS = "exodus";
    public static final String TYPE_JALAPENO = "jalapeno";
    public static final String TYPE_EMBEDDED_V1 = "embeddedV1";
    public static final String TYPE_EMBEDDED_V2 = "embeddedV2";
    private boolean m_bEnablePPP = false;
    private boolean m_bVideoEncryptEnable = false;
    public static final String TOOLBAR_DISABLE = "disable";
    private boolean m_bShowToolbar = true;

    public DSPath(String string, String string2) throws ExceptionRequestFailed {
        int n;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("DSpath constructor szPath=" + string + " szIFaceViewer=" + string2));
        int n2 = string.indexOf("a:");
        if (n2 < 0) {
            UserNotification.InvalidParameterMessageBox(RES.getString("DSPath_Address_not_found_in_path"));
            throw new ExceptionRequestFailed("Address not found in path");
        }
        this.m_szIPAddress = this.getStringParam(string.substring(n2 + 2));
        Trace.logInfo((String)TRACE_CONTEXT, (String)("DSpath constructor m_szIPAddress=" + this.m_szIPAddress));
        n2 = string.indexOf("t:");
        if (n2 >= 0) {
            this.m_szDeviceType = this.getStringParam(string.substring(n2 + 2));
        }
        if ((n2 = string.indexOf("i:")) >= 0) {
            this.m_szConnection = this.getStringParam(string.substring(n2 + 2));
        }
        if ((n2 = string.indexOf("p:")) >= 0) {
            try {
                this.m_nPortNumber = this.getIntParam(string.substring(n2 + 2));
                Trace.logInfo((String)TRACE_CONTEXT, (String)("DSpath constructor m_nPortNumber=" + this.m_nPortNumber));
            }
            catch (NumberFormatException numberFormatException) {
                UserNotification.InvalidParameterMessageBox("Invalid port number found in path");
                throw new ExceptionRequestFailed("Invalid port number found in path");
            }
        }
        if ((n2 = string.indexOf("r:")) >= 0) {
            this.m_szRIPId = this.getStringParam(string.substring(n2 + 2));
            Trace.logInfo((String)TRACE_CONTEXT, (String)("DSpath constructor m_szRIPId=" + this.m_szRIPId));
            if (this.m_szRIPId.length() > 13) {
                UserNotification.InvalidParameterMessageBox(RES.getString("DSPath_RIPID_Wrong_Length") + this.m_szRIPId.length());
                throw new ExceptionRequestFailed("RIP ID wrong length");
            }
        }
        if (this.m_nPortNumber != 0 && this.m_szRIPId.length() > 0) {
            UserNotification.InvalidParameterMessageBox(RES.getString("DSPath_RIP_ID_and_Input_Port_Mutually_Exclusive") + RES.getString("DSPath_cannot_both_be_specified"));
            throw new ExceptionRequestFailed("Both RIP ID and port number specified in path");
        }
        if (this.m_nPortNumber == 0 && this.m_szRIPId.length() == 0 && this.m_szDeviceType.compareToIgnoreCase(TYPE_AVSP) == 0) {
            UserNotification.InvalidParameterMessageBox(RES.getString("DSPath_RIP_ID_or_Input_Port_Not_Specified"));
            throw new ExceptionRequestFailed("Neither RIP ID or port number specified in path");
        }
        n2 = string.indexOf("c:");
        if (n2 >= 0) {
            n = 1;
            if (n2 >= 1 && string.charAt(n2 - 1) == 'c') {
                n = 0;
            }
            if (n != 0) {
                try {
                    this.m_nChannel = this.getIntParam(string.substring(n2 + 2));
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("DSpath constructor m_nChannel=" + this.m_nChannel));
                }
                catch (NumberFormatException numberFormatException) {
                    UserNotification.InvalidParameterMessageBox(RES.getString("DSPath_Invalid_channel"));
                    throw new ExceptionRequestFailed("Invalid cascade channel number found in path");
                }
            }
        }
        if ((n2 = string.indexOf("d:")) >= 0) {
            this.m_szDeviceID = this.getStringParam(string.substring(n2 + 2));
            Trace.logInfo((String)TRACE_CONTEXT, (String)("DSpath constructor m_szDeviceID=" + this.m_szDeviceID));
        }
        if (string2.length() > 0 && this.m_szDeviceID.length() == 0) {
            UserNotification.InvalidParameterMessageBox(RES.getString("DSPath_Viewer_Interface_No_Device_ID"));
            throw new ExceptionRequestFailed("Viewer interface specified but no device ID in path");
        }
        n2 = string.indexOf("e:");
        if (n2 >= 0) {
            try {
                this.m_bAPCP = this.getIntParam(string.substring(n2 + 2)) == 1;
            }
            catch (NumberFormatException numberFormatException) {
                UserNotification.InvalidParameterMessageBox("Invalid APCP parameter found in path");
                throw new ExceptionRequestFailed("Invalid APCP parameter found in path");
            }
        }
        if ((n2 = string.indexOf("s:")) >= 0) {
            this.m_szServerName = string.substring(n2 + 2);
            if (this.m_szServerName.length() > 0 && this.m_szServerName.charAt(0) == '\"') {
                this.m_szServerName = this.m_szServerName.substring(1);
                n = this.m_szServerName.lastIndexOf(34);
                if (n >= 0) {
                    this.m_szServerName = this.m_szServerName.substring(0, n);
                }
            }
            Trace.logInfo((String)TRACE_CONTEXT, (String)("DSpath constructor m_szServerName=" + this.m_szServerName));
        }
        if ((n2 = string.indexOf("f:")) >= 0) {
            String string3 = string.substring(n2 + 2);
            this.m_bVideoEncryptEnable = string3.compareToIgnoreCase(ENCRYPT_VIDEO) == 0;
        }
        if ((n2 = string.indexOf("m:")) >= 0) {
            String string4 = string.substring(n2 + 2);
            this.m_bEnablePPP = string4.compareToIgnoreCase(PPP_CONNECTION) == 0;
        }
        if ((n2 = string.indexOf("b:")) >= 0) {
            String string5 = string.substring(n2 + 2);
            this.m_bShowToolbar = string5.compareToIgnoreCase(TOOLBAR_DISABLE) != 0;
        }
        if ((n2 = string.indexOf("l:")) >= 0) {
            String string6 = this.getStringParam(string.substring(n2 + 2));
            try {
                this.m_nLoginTimeOut = Integer.valueOf(string6);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public DSPath(String string, String string2, String string3, boolean bl) {
        this.m_szIPAddress = string;
        this.m_szDeviceID = string2;
        this.m_szServerName = string3;
        this.m_bAPCP = bl;
    }

    public final String getIPAddress() {
        return this.m_szIPAddress;
    }

    public final int getPortNumber() {
        return this.m_nPortNumber;
    }

    public final String getRIPId() {
        return this.m_szRIPId;
    }

    public final int getCascadeChannel() {
        return this.m_nChannel;
    }

    public final String getDeviceID() {
        return this.m_szDeviceID;
    }

    public final String getConnectionType() {
        return this.m_szConnection;
    }

    public final String getDeviceType() {
        return this.m_szDeviceType;
    }

    public final boolean isPPPEnabled() {
        return this.m_bEnablePPP;
    }

    public final boolean isEmbeddedAppliance() {
        return this.m_szDeviceType.compareToIgnoreCase(TYPE_EMBEDDED_V1) == 0 || this.m_szDeviceType.compareToIgnoreCase(TYPE_EMBEDDED_V2) == 0;
    }

    public final boolean isConnectionTCP() {
        return this.m_szDeviceType.compareToIgnoreCase(TYPE_EMBEDDED_V1) == 0 || this.m_szDeviceType.compareToIgnoreCase(TYPE_EMBEDDED_V2) == 0;
    }

    public final boolean isVideoEncryptionEnabled() {
        return this.m_bVideoEncryptEnable;
    }

    public final String getServerName() {
        return this.getDisplayName();
    }

    public final boolean showToolbar() {
        return this.m_bShowToolbar;
    }

    public final int getLoginTimeOut() {
        return this.m_nLoginTimeOut;
    }

    private String getStringParam(String string) {
        int n = 0;
        int n2 = string.indexOf(",");
        int n3 = string.indexOf(" ");
        n = n2 >= 0 && n3 >= 0 ? (n2 > n3 ? n3 : n2) : (n2 >= 0 ? n2 : (n3 >= 0 ? n3 : string.length()));
        return string.substring(0, n);
    }

    private int getIntParam(String string) throws NumberFormatException {
        int n = 0;
        int n2 = string.indexOf(",");
        int n3 = string.indexOf(" ");
        n = n2 >= 0 && n3 >= 0 ? (n2 > n3 ? n3 : n2) : (n2 >= 0 ? n2 : (n3 >= 0 ? n3 : string.length()));
        return new Integer(string.substring(0, n));
    }

    public String getDisplayName() {
        String string = this.m_szServerName;
        if (string.length() == 0) {
            if (this.m_szRIPId.length() > 0) {
                if (this.m_nChannel > 0) {
                    Object[] objectArray = new Object[]{this.m_szRIPId, Integer.toString(this.m_nChannel)};
                    string = MessageFormat.format(RES.getString("DSPath_DisplayName_RIP"), objectArray);
                } else {
                    string = this.m_szRIPId;
                }
            } else if (this.m_nPortNumber > 0) {
                if (this.m_nChannel > 0) {
                    Object[] objectArray = new Object[]{Integer.toString(this.m_nChannel), Integer.toString(this.m_nChannel)};
                    string = MessageFormat.format(RES.getString("DSPath_DisplayName_Port"), objectArray);
                } else {
                    string = Integer.toString(this.m_nChannel);
                }
            } else {
                string = RES.getString("DSPath_DisplayName_Default");
            }
        }
        return string;
    }

    public boolean getUCC() {
        return this.m_bUseCommandLineCredentials;
    }

    public boolean hasApcp() {
        return this.m_bAPCP;
    }

    public String toString() {
        return this.m_szServerName + "_" + this.m_szIPAddress + "_" + this.m_szDeviceID + "_" + this.m_szRIPId + "_" + Integer.toString(this.m_nPortNumber) + "_" + Integer.toString(this.m_nChannel);
    }
}

