/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.video.DvcCommand;

public class DvcCommand7
extends DvcCommand {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    private final int[] colorMap = new int[]{0, 70, 127, 191, 255};
    private final byte[] hardwareMap = new byte[]{0, 25, 50, 75, 5, 30, 55, 80, 10, 35, 60, 85, 15, 40, 65, 90, 1, 26, 51, 76, 6, 31, 56, 81, 11, 36, 61, 86, 16, 41, 66, 91, 2, 27, 52, 77, 7, 32, 57, 82, 12, 37, 62, 87, 17, 42, 67, 92, 3, 28, 53, 78, 8, 33, 58, 83, 13, 38, 63, 88, 18, 43, 68, 93, 100, 101, 102, 103, 105, 106, 107, 108, 110, 111, 112, 113, 115, 116, 117, 118, 20, 45, 70, 95, 21, 46, 71, 96, 22, 47, 72, 97, 23, 48, 73, 98, 4, 29, 54, 79, 9, 34, 59, 84, 14, 39, 64, 89, 19, 44, 69, 94, 120, 121, 122, 123, 104, 109, 114, 119, 24, 49, 74, 99, 124, 125, 126, 127};
    private short m_sPixel;
    private int[] m_nJavaColors;
    private int[] m_nHardwareColors;
    private short[] m_s15BitColors;
    private boolean[] m_bMSPixel = new boolean[7];
    private int m_nNumColorBits = 0;

    public DvcCommand7() {
        int n;
        this.m_nJavaColors = new int[128];
        this.m_nHardwareColors = new int[128];
        this.m_s15BitColors = new short[128];
        for (int i = 0; i < 125; i += 25) {
            for (int j = 0; j < 25; j += 5) {
                for (int k = 0; k < 5; ++k) {
                    this.m_nJavaColors[i + j + k] = 0xFF000000 | this.colorMap[i / 25] << 0 | this.colorMap[j / 5] << 8 | this.colorMap[k] << 16;
                }
            }
        }
        this.m_nJavaColors[125] = -10526881;
        this.m_nJavaColors[126] = -6316129;
        this.m_nJavaColors[127] = -2105377;
        for (n = 0; n < 128; ++n) {
            this.m_nHardwareColors[n] = this.m_nJavaColors[this.hardwareMap[n]];
        }
        for (int i = 0; i < 128; ++i) {
            n = (byte)((this.m_nHardwareColors[i] & 0xFF0000) >> 16);
            byte by = (byte)((this.m_nHardwareColors[i] & 0xFF00) >> 8);
            byte by2 = (byte)(this.m_nHardwareColors[i] & 0xFF);
            n = (byte)(n >> 3 & 0x1F);
            by = (byte)(by >> 3 & 0x1F);
            by2 = (byte)(by2 >> 3 & 0x1F);
            this.m_s15BitColors[i] = (short)(n << 10 | by << 5 | by2);
        }
    }

    public void setPixel(byte by) {
        if (by <= 127) {
            this.m_sPixel = this.m_s15BitColors[by];
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(DvcCommand7 setPixel) Index OUT OF RANGE" + by));
            this.m_sPixel = 0;
        }
    }

    public void setMSPixel(int n, boolean bl) {
        if (n <= 7) {
            this.m_bMSPixel[n] = bl;
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(DvcCommand7 setMSPixel) OUT OF RANGE Pixel value" + bl + " or index value " + n));
            this.m_bMSPixel[n % 8] = false;
        }
    }

    public boolean isLastColorPixel(int n) {
        if (n <= 7) {
            return this.m_bMSPixel[n];
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(DvcCommand7 isLastColor) Index OUT OF RANGE" + n));
        return this.m_bMSPixel[0];
    }

    public short getPixel() {
        return this.m_sPixel;
    }

    public void setCommandAndPixel(int n, byte by) {
        this.setPixel(by);
        super.setCommand(n);
    }

    public void setCommandAndPixel(int n, short s) {
        this.m_sPixel = s;
        super.setCommand(n);
    }

    public void setCommandAndRepeatCount(int n, int n2) {
        super.setCommandAndRepeatCount(n, n2 += 2);
    }

    public void setNumMSBits(int n) {
        this.m_nNumColorBits = n;
    }

    public int getNumMSBits() {
        return this.m_nNumColorBits;
    }

    private void printColorPalette() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(DvcCommand7 printColorArray) Graphical Console Server Custom 128 Color Palette");
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(DvcCommand7 printColorArray) Index   Red     Green   Blue");
        for (int i = 0; i < this.m_nHardwareColors.length; ++i) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(DvcCommand7 printColorArray)  " + i + "    " + ((this.m_nHardwareColors[i] & 0xFF0000) >> 16) + "     " + ((this.m_nHardwareColors[i] & 0xFF00) >> 8) + "     " + (this.m_nHardwareColors[i] & 0xFF)));
        }
    }

    private void print15bitColorPalette() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(DvcCommand7 print15bitColorArray) Graphical Console Server Custom 128 Color Palette");
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(DvcCommand7 print15bitColorArray) Index   Red     Green   Blue");
        for (int i = 0; i < this.m_s15BitColors.length; ++i) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(DvcCommand7 print15bitColorArray)  " + i + "    " + ((this.m_s15BitColors[i] & 0x7C00) >> 10) + "     " + ((this.m_s15BitColors[i] & 0x3E0) >> 5) + "     " + (this.m_s15BitColors[i] & 0x1F)));
        }
    }
}

