/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;

public class EndianXForm {
    private static final String TRACE_CONTEXT = "VideoViewer";

    private EndianXForm() {
    }

    public static short transForm(short s) {
        short s2 = (short)(s & 0xFF);
        short s3 = (short)(s & 0xFF00);
        short s4 = (short)(s2 << 8);
        short s5 = (short)(s3 >> 8 & 0xFF);
        return (short)(s4 | s5);
    }

    public static int transForm(int n) {
        short s = (short)n;
        short s2 = (short)(n >> 16);
        return EndianXForm.transForm(s) << 16 | EndianXForm.transForm(s2) & 0xFFFF;
    }

    public static long transForm(long l) {
        int n = (int)l;
        int n2 = (int)(l >> 32);
        return (long)EndianXForm.transForm(n) << 32 | (long)EndianXForm.transForm(n2) & 0xFFFFFFFFFFFFFFFFL;
    }

    public static byte[] transForm(byte[] byArray) {
        byte[] byArray2 = null;
        try {
            byArray2 = new byte[byArray.length];
            int n = 0;
            int n2 = byArray.length - 1;
            while (n < byArray.length) {
                byArray2[n] = byArray[n2];
                ++n;
                --n2;
            }
        }
        catch (NullPointerException nullPointerException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(EndianXForm transform) abyValues null", (Throwable)nullPointerException);
        }
        return byArray2;
    }

    public static short transFormShort(byte[] byArray, int n) throws ArrayIndexOutOfBoundsException {
        short s = 0;
        short s2 = 0;
        try {
            s = (short)(byArray[n] & 0xFF);
            s2 = (short)(byArray[n + 1] << 8 & 0xFF00);
        }
        catch (NullPointerException nullPointerException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(EndiaXForm transFormShort) abyValues null", (Throwable)nullPointerException);
        }
        return (short)(s2 | s);
    }

    public static byte[] transFormArray(int n) {
        byte[] byArray = new byte[]{(byte)(n & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 24 & 0xFF)};
        return byArray;
    }

    public static byte[] transFormArray(short s) {
        byte[] byArray = new byte[]{(byte)(s & 0xFF), (byte)(s >> 8 & 0xFF)};
        return byArray;
    }
}

