/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.OS;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.JPanelAppliance;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class GuiUtils {
    public static final String CNAME = "GuiUtils";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");

    public void captureToFile(JPanelAppliance jPanelAppliance) {
        String string;
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilterJPEG());
        int n = jFileChooser.showSaveDialog(jPanelAppliance);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        if (n == 0 && (string = jFileChooser.getSelectedFile().getAbsolutePath()) != null) {
            Object object;
            Object[] objectArray;
            File file;
            if (!string.endsWith(".jpg") && !string.endsWith(".jpeg")) {
                string = OS.isWindows() ? string + ".jpg" : string + ".jpeg";
            }
            if ((file = new File(string)).exists()) {
                objectArray = new Object[]{string};
                object = MessageFormat.format(RES.getString("GuiUtils_Overwrite_File"), objectArray);
                int n2 = JOptionPane.showConfirmDialog(jPanelAppliance, object, RES.getString("GuiUtils_File_Exists"), 0, 3);
                if (n2 == 0) {
                    file.delete();
                } else {
                    return;
                }
            }
            try {
                objectArray = new FileOutputStream(string);
                object = new BufferedOutputStream((OutputStream)objectArray);
                JPEGEncodeParam jPEGEncodeParam = JPEGCodec.getDefaultJPEGEncodeParam((BufferedImage)jPanelAppliance.getBufferedImage());
                jPEGEncodeParam.setQuality(5.0f, false);
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)object);
                jPEGImageEncoder.encode(jPanelAppliance.getBufferedImage());
                ((BufferedOutputStream)object).flush();
                ((FilterOutputStream)object).close();
            }
            catch (IOException iOException) {
                Message.showReasonMessage((Component)jPanelAppliance, (String)RES.getString("GuiUtils_JPEGFileWriteError_Title"), (String)RES.getString("GuiUtils_JPEGFileWriteError"));
            }
        }
    }

    public void captureToClipboard(JPanelAppliance jPanelAppliance) {
        BufferedImage bufferedImage = jPanelAppliance.getBufferedImage();
        if (bufferedImage != null) {
            Trace.logInfo((String)"VideoViewerTrace", (String)("GuiUtils.captureToClipboard image width=" + bufferedImage.getWidth() + " height=" + bufferedImage.getHeight() + " type=" + bufferedImage.getType()));
            BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
            bufferedImage2.setData(bufferedImage.getData(new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight())));
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new TransferableVideo(bufferedImage2), new ClipboardOwnerVideo());
        } else {
            Trace.logInfo((String)"VideoViewerTrace", (String)"GuiUtils.captureToClipboard image = null");
        }
    }

    public void setScaling(ApplianceSession applianceSession, boolean bl, int n, int n2) {
        ApplianceSessionInfo applianceSessionInfo = applianceSession.getPersistentDataReference();
        if (!applianceSessionInfo.isFullScale() || applianceSessionInfo.getPanedHeight() != n2 || applianceSessionInfo.getPanedWidth() != n) {
            // empty if block
        }
        this.setPersistentDataForAutoScale(applianceSession, bl, n, n2);
        try {
            applianceSession.cmdStartVideo();
        }
        catch (IOException iOException) {
            Trace.logError((String)"VideoViewerTrace", (String)iOException.getMessage(), (Throwable)iOException);
        }
    }

    public void setPersistentDataForAutoScale(ApplianceSession applianceSession, boolean bl, int n, int n2) {
        ApplianceSessionInfo applianceSessionInfo = null;
        try {
            applianceSessionInfo = applianceSession.getPersistentData();
            applianceSessionInfo.setAutoScale(bl);
            applianceSessionInfo.setFullScale(false);
            applianceSessionInfo.setPanedWidth((short)n);
            applianceSessionInfo.setPanedHeight((short)n2);
            if (!bl) {
                applianceSessionInfo.setDecimationFactor(1);
            }
            applianceSession.setPersistentData(applianceSessionInfo);
        }
        catch (Exception exception) {
            Trace.logError((String)"VideoViewerTrace", (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public class ClipboardOwnerVideo
    implements ClipboardOwner {
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    public class TransferableVideo
    implements Transferable {
        private Image m_image;

        public TransferableVideo(Image image) {
            this.m_image = image;
        }

        public Object getTransferData(DataFlavor dataFlavor) {
            if (dataFlavor.equals(DataFlavor.imageFlavor)) {
                Trace.logInfo((String)"VideoViewerTrace", (String)"GuiUtils.TransferableVideo.getTransferData flavor equals DataFlavor.imageFlavor");
                return this.m_image;
            }
            Trace.logInfo((String)"VideoViewerTrace", (String)"GuiUtils.TransferableVideo.getTransferData flavor DOES NOT equal DataFlavor.imageFlavor");
            return null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.imageFlavor};
            return dataFlavorArray;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(DataFlavor.imageFlavor);
        }
    }

    public class FileFilterJPEG
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isHidden()) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return string.endsWith(".jpg") || string.endsWith(".jpeg");
        }

        public String getDescription() {
            return RES.getString("GuiUtils_CaptureFileDescription");
        }
    }
}

