/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.Help;
import com.avocent.video.KeyboardMacro;
import com.avocent.video.KeyboardMacroGroup;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class JDialogCopy
extends JDialogCentered {
    public static final String CNAME = "JDialogCopy";
    static ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    static String TRACE_CONTEXT = "VideoViewerTrace";
    JPanel panel1 = new JPanel();
    JPanel jPanelName = new JPanel();
    JPanel jPanelLocalGlobal = new JPanel();
    JPanel jPanelDefaultButtons = new JPanel();
    JLabel jLabelName = new JLabel();
    JTextField jTextFieldName = new JTextField();
    TitledBorder titledBorder1;
    TitledBorder titledBorder2;
    JButton jButtonOK = new JButton();
    JButton jButtonCancel = new JButton();
    JButton jButtonHelp = new JButton();
    JRadioButton jRadioButtonLocal = new JRadioButton();
    JRadioButton jRadioButtonGlobal = new JRadioButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    ButtonGroup buttonGroupType = new ButtonGroup();
    private ApplianceSession m_applianceSession;
    private boolean m_bMacro = false;
    private KeyboardMacro m_macro = null;
    private KeyboardMacroGroup m_macroGroup = null;
    private boolean m_bOKPressed = false;
    private String m_szHelpURL = null;

    public JDialogCopy(Frame frame, KeyboardMacro keyboardMacro, ApplianceSession applianceSession, String string) {
        super(frame, "", false);
        this.m_applianceSession = applianceSession;
        this.m_szHelpURL = string;
        this.m_bMacro = true;
        this.m_macro = keyboardMacro;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public JDialogCopy(Frame frame, KeyboardMacroGroup keyboardMacroGroup, ApplianceSession applianceSession, String string) {
        super(frame, "", false);
        this.m_applianceSession = applianceSession;
        this.m_szHelpURL = string;
        this.m_bMacro = false;
        this.m_macroGroup = keyboardMacroGroup;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    public JDialogCopy() {
        this(null, (KeyboardMacro)null, null, "");
    }

    private void jbInit() throws Exception {
        this.titledBorder1 = new TitledBorder("");
        this.titledBorder2 = new TitledBorder("");
        this.panel1.setLayout(this.gridBagLayout4);
        this.jPanelName.setLayout(this.gridBagLayout3);
        this.jPanelLocalGlobal.setBorder(this.titledBorder2);
        this.jPanelLocalGlobal.setLayout(this.gridBagLayout1);
        this.jPanelDefaultButtons.setLayout(this.gridBagLayout2);
        if (this.m_bMacro) {
            this.jLabelName.setText(RES.getString("JDialogCopy_Name_Copied_Macro"));
            this.titledBorder2.setTitle(RES.getString("JDialogCopy_MacroType"));
            this.setTitle(RES.getString("JDialogCopy_Copy_Macro_Title"));
        } else {
            this.jLabelName.setText(RES.getString("JDialogCopy_Name_Copied_Macro_Group"));
            this.titledBorder2.setTitle(RES.getString("JDialogCopy_Group_Type"));
            this.setTitle(RES.getString("JDialogCopy_Copy_Macro_Group_Title"));
        }
        this.jButtonOK.setText(RES.getString("JDialogCopy_OK"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogCopy.this.jButtonOK_actionPerformed(actionEvent);
            }
        });
        this.jButtonCancel.setText(RES.getString("JDialogCopy_Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogCopy.this.jButtonCancel_actionPerformed(actionEvent);
            }
        });
        if (this.m_szHelpURL != null && this.m_szHelpURL.length() > 0) {
            this.jButtonHelp.setText(RES.getString("JDialogCopy_Help"));
            this.jButtonHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JDialogCopy.this.jButtonHelp_actionPerformed(actionEvent);
                }
            });
        }
        this.buttonGroupType.add(this.jRadioButtonLocal);
        this.buttonGroupType.add(this.jRadioButtonGlobal);
        this.jRadioButtonLocal.setText(RES.getString("JDialogCopy_Local"));
        this.jRadioButtonGlobal.setText(RES.getString("JDialogCopy_Global"));
        if (!this.m_applianceSession.canUserEditGlobals()) {
            this.jRadioButtonLocal.setSelected(true);
            this.jRadioButtonLocal.setEnabled(false);
            this.jRadioButtonGlobal.setEnabled(false);
        } else if (!this.m_bMacro) {
            boolean bl = false;
            if (!this.m_macroGroup.isGlobalGroup()) {
                String[] stringArray = this.m_macroGroup.getMacrosIDsInGroup();
                ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
                for (int i = 0; i < stringArray.length; ++i) {
                    KeyboardMacro keyboardMacro = applianceSessionInfo.getMacro(stringArray[i]);
                    if (keyboardMacro.isGlobalMacro()) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.jRadioButtonLocal.setSelected(true);
                this.jRadioButtonLocal.setEnabled(false);
                this.jRadioButtonGlobal.setEnabled(false);
            } else {
                this.jRadioButtonLocal.setSelected(!this.m_macroGroup.isGlobalGroup());
                this.jRadioButtonGlobal.setSelected(this.m_macroGroup.isGlobalGroup());
            }
        } else {
            this.jRadioButtonLocal.setSelected(!this.m_macro.isGlobalMacro());
            this.jRadioButtonGlobal.setSelected(this.m_macro.isGlobalMacro());
        }
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanelName, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 5, 0, 5), 0, 3));
        this.jPanelName.add((Component)this.jLabelName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 21, 0, 154), 100, 4));
        this.jPanelName.add((Component)this.jTextFieldName, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 21, 5, 40), 316, -2));
        if (this.m_szHelpURL != null && this.m_szHelpURL.length() > 0) {
            this.jPanelDefaultButtons.add((Component)this.jButtonHelp, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 33, 9, 53), 18, 5));
        }
        this.jPanelDefaultButtons.add((Component)this.jButtonCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 10, 9, 0), 6, 5));
        this.jPanelDefaultButtons.add((Component)this.jButtonOK, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 9, 10), 24, 5));
        if (this.m_applianceSession.getApplication() == 2) {
            this.jPanelLocalGlobal.add((Component)this.jRadioButtonGlobal, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(-2, 7, 7, 12), 14, 0));
            this.jPanelLocalGlobal.add((Component)this.jRadioButtonLocal, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(-2, 18, 7, 0), 8, 0));
            this.panel1.add((Component)this.jPanelLocalGlobal, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 111, 0, 112), 0, 0));
        }
        this.panel1.add((Component)this.jPanelDefaultButtons, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(20, 0, 14, 0), 0, 0));
    }

    void jButtonOK_actionPerformed(ActionEvent actionEvent) {
        this.m_bOKPressed = true;
        if (this.jTextFieldName.getText().length() == 0) {
            if (this.m_bMacro) {
                Message.show(null, (String)RES.getString("JDialogCopy_No_Macro_Name"));
            } else {
                Message.show(null, (String)RES.getString("JDialogCopy_Macro_Group_Enter_Name"));
            }
            return;
        }
        if (this.m_bMacro) {
            ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
            if (applianceSessionInfo.doesMacroNameExist(this.jTextFieldName.getText())) {
                Object[] objectArray = new Object[]{this.jTextFieldName.getText()};
                String string = MessageFormat.format(RES.getString("JDialogCopy_Duplicate_macro_name"), objectArray);
                Message.show(null, (String)string);
                return;
            }
            ApplianceSessionInfo applianceSessionInfo2 = this.m_applianceSession.getPersistentData();
            KeyboardMacro keyboardMacro = new KeyboardMacro(this.m_macro, true);
            keyboardMacro.setName(this.jTextFieldName.getText());
            keyboardMacro.setGlobalMacro(this.jRadioButtonGlobal.isSelected());
            applianceSessionInfo2.setMacro(keyboardMacro);
            this.m_applianceSession.setPersistentData(applianceSessionInfo2);
        } else {
            ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
            if (applianceSessionInfo.doesMacroGroupNameExist(this.jTextFieldName.getText())) {
                Object[] objectArray = new Object[]{this.jTextFieldName.getText()};
                String string = MessageFormat.format(RES.getString("JDialogCopy_Macro_Group_Exists"), objectArray);
                Message.show(null, (String)string);
                return;
            }
            ApplianceSessionInfo applianceSessionInfo3 = this.m_applianceSession.getPersistentData();
            KeyboardMacroGroup keyboardMacroGroup = new KeyboardMacroGroup(this.m_macroGroup, true);
            keyboardMacroGroup.setName(this.jTextFieldName.getText());
            keyboardMacroGroup.setGlobalGroup(this.jRadioButtonGlobal.isSelected());
            try {
                applianceSessionInfo3.saveMacroGroup(keyboardMacroGroup);
                this.m_applianceSession.setPersistentData(applianceSessionInfo3);
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                // empty catch block
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    void jButtonHelp_actionPerformed(ActionEvent actionEvent) {
        String string = this.m_bMacro ? "IDH_COPY_MACRO" : "IDH_COPY_MACRO_GROUP";
        Help.launchHelp(this.m_szHelpURL, string);
    }

    public boolean wasOkPressed() {
        return this.m_bOKPressed;
    }
}

