/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.Help;
import com.avocent.video.Icons;
import com.avocent.video.KeyStroke;
import com.avocent.video.KeyboardMacro;
import com.avocent.video.MacroKeyboardLocalization;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class JDialogCreateEditMacro
extends JDialogCentered {
    public static final String CNAME = "JDialogCreateEditMacro";
    static ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    private static final String ENGLISH_KEYBOARD = "macro_keyboard_english.properties";
    private static MacroKeyboardLocalization m_mkl = null;
    private JPanel panel1 = new JPanel();
    private JPanel jPanelMacroName = new JPanel();
    private JLabel jLabelMacroName = new JLabel();
    private JPanelMacroKeyboard m_panelMacroKeyboard;
    private JTextField jTextFieldMacroName = new JTextField();
    private TitledBorder titledBorder1;
    private TitledBorder titledBorder2;
    private ButtonGroup buttonGroup1 = new ButtonGroup();
    private DefaultListModel m_listModelKeyStrokes = new DefaultListModel();
    private DefaultComboBoxModel m_comboBoxModelKeyboardTypes = new DefaultComboBoxModel();
    private DefaultComboBoxModel m_comboBoxModelIcons = new DefaultComboBoxModel();
    private ApplianceSession m_applianceSession;
    private KeyboardMacro m_km;
    private String m_szHelpURL;
    private Vector m_vKeyboards;
    private boolean m_bChanged = false;
    private boolean m_bOKPressed = false;
    private JComboBoxSunKeys m_comboBoxSunKeys = null;
    private Icons m_icons = new Icons();
    JPanel jPanelType = new JPanel();
    JPanel jPanelKeyStrokes = new JPanel();
    JPanel jPanelDefaultButtons = new JPanel();
    JPanel jPanelMacroType = new JPanel();
    JRadioButton jRadioButtonLocal = new JRadioButton();
    JRadioButton jRadioButtonGlobal = new JRadioButton();
    JPanel jPanelKeyboard = new JPanel();
    JScrollPane jScrollPaneKeyStrokes = new JScrollPane();
    JLabel jLabelKeyStrokes = new JLabel();
    JList jListKeyStrokes = new JList();
    JButton jButtonMoveDown = new JButton();
    JButton jButtonRemove = new JButton();
    JButton jButtonMoveUp = new JButton();
    JButton jButtonReset = new JButton();
    JLabel jLabelKeyboardType = new JLabel();
    JComboBox jComboBoxKeyboardType = new JComboBox();
    JLabel jLabelIcon = new JLabel();
    JComboBox jComboBoxIcons = new JComboBox();
    JButton jButtonCancel = new JButton();
    JButton jButtonHelp = new JButton();
    JButton jButtonOK = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    static /* synthetic */ Class class$com$avocent$video$JDialogCreateEditMacro;

    public JDialogCreateEditMacro(Frame frame, ApplianceSession applianceSession, KeyboardMacro keyboardMacro, String string) {
        super(frame, "", false);
        this.m_applianceSession = applianceSession;
        this.m_km = keyboardMacro;
        this.m_szHelpURL = string;
        m_mkl = MacroKeyboardLocalization.getInstance("keyboard/macro_keyboard_english.properties");
        try {
            this.jbInit();
            this.getMacroKeyboards();
            String string2 = ENGLISH_KEYBOARD;
            String string3 = "en";
            if (this.m_km != null) {
                KeyboardType keyboardType;
                int n;
                for (n = 0; n < this.m_vKeyboards.size(); ++n) {
                    keyboardType = (KeyboardType)this.m_vKeyboards.get(n);
                    if (keyboardType.getLanguageCode().compareToIgnoreCase(this.m_km.getKeyboardLanguage()) != 0) continue;
                    string2 = keyboardType.getFilename();
                    string3 = keyboardType.getLanguageCode();
                    break;
                }
                if (this.loadMacroKeyboard(string2, string3)) {
                    for (n = 0; n < this.m_comboBoxModelKeyboardTypes.getSize(); ++n) {
                        keyboardType = (KeyboardType)this.m_comboBoxModelKeyboardTypes.getElementAt(n);
                        if (keyboardType.getLanguageCode().compareToIgnoreCase(this.m_km.getKeyboardLanguage()) != 0) continue;
                        this.jComboBoxKeyboardType.setSelectedIndex(n);
                        this.jComboBoxKeyboardType.setEnabled(false);
                        break;
                    }
                } else {
                    this.loadMacroKeyboard(ENGLISH_KEYBOARD, "en");
                }
            } else {
                this.loadMacroKeyboard(ENGLISH_KEYBOARD, "en");
            }
            this.setSize(800, 337);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.jComboBoxIcons.setRenderer(new RendererComboBoxIcon());
        this.m_comboBoxModelIcons.addElement(new JLabel(RES.getString("JDialogCreateEditMacro_None")));
        for (int i = 0; i < this.m_icons.getIconCount(); ++i) {
            this.m_comboBoxModelIcons.addElement(new JLabel("", this.m_icons.getIcon(i), 0));
        }
        if (this.m_km != null) {
            this.setTitle(RES.getString("JDialogCreateEditMacro_Edit_Macro"));
            this.jTextFieldMacroName.setText(this.m_km.getName());
            KeyStroke[] keyStrokeArray = this.m_km.getKeyStrokes();
            for (int i = 0; i < keyStrokeArray.length; ++i) {
                this.m_listModelKeyStrokes.addElement(keyStrokeArray[i]);
            }
            if (this.m_km.isGlobalMacro()) {
                this.jRadioButtonGlobal.setSelected(true);
            } else {
                this.jRadioButtonLocal.setSelected(true);
            }
            this.jRadioButtonGlobal.setEnabled(false);
            this.jRadioButtonLocal.setEnabled(false);
            this.jComboBoxIcons.setSelectedIndex(this.m_km.getIconIndex() + 1);
        } else {
            this.setTitle(RES.getString("JDialogCreateEditMacro_Create_Macro"));
            this.jRadioButtonLocal.setSelected(true);
        }
        this.jButtonMoveDown.setEnabled(false);
        this.jButtonMoveUp.setEnabled(false);
        this.jButtonRemove.setEnabled(false);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.jTextFieldMacroName.requestFocus();
        this.setResizable(false);
    }

    public JDialogCreateEditMacro() {
        this(null, null, null, "");
    }

    private void jbInit() throws Exception {
        this.jListKeyStrokes.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JDialogCreateEditMacro.this.jListKeyStrokes_valueChanged(listSelectionEvent);
            }
        });
        this.jButtonReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogCreateEditMacro.this.jButtonReset_actionPerformed(actionEvent);
            }
        });
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogCreateEditMacro.this.jButtonRemove_actionPerformed(actionEvent);
            }
        });
        this.jButtonMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogCreateEditMacro.this.jButtonMoveUp_actionPerformed(actionEvent);
            }
        });
        this.jButtonMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogCreateEditMacro.this.jButtonMoveDown_actionPerformed(actionEvent);
            }
        });
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogCreateEditMacro.this.jButtonOK_actionPerformed(actionEvent);
            }
        });
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogCreateEditMacro.this.jButtonCancel_actionPerformed(actionEvent);
            }
        });
        if (this.m_szHelpURL != null && this.m_szHelpURL.length() > 0) {
            this.jButtonHelp.setText(RES.getString("JDialogCreateEditMacro_Help"));
            String string = RES.getString("JDialogCreateEditMacro_Help_Mnemonic");
            if (string != null && string.length() > 0) {
                this.jButtonHelp.setMnemonic(string.charAt(0));
            }
            this.jButtonHelp.setText(RES.getString("JDialogCreateEditMacro_Help"));
            this.jButtonHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JDialogCreateEditMacro.this.jButtonHelp_actionPerformed(actionEvent);
                }
            });
        } else {
            this.jButtonHelp.setVisible(false);
        }
        this.jRadioButtonLocal.setText(RES.getString("JDialogCreateEditMacro_Local"));
        this.jRadioButtonLocal.setBounds(new Rectangle(13, 19, 76, 28));
        this.jRadioButtonGlobal.setText(RES.getString("JDialogCreateEditMacro_Global"));
        this.jRadioButtonGlobal.setBounds(new Rectangle(89, 19, 66, 28));
        this.jPanelKeyboard.setLayout(null);
        this.jButtonCancel.setBounds(new Rectangle(0, 34, 90, 21));
        this.jButtonCancel.setText(RES.getString("JDialogCreateEditMacro_Cancel"));
        this.jButtonOK.setBounds(new Rectangle(0, 5, 90, 21));
        this.jButtonOK.setText(RES.getString("JDialogCreateEditMacro_OK"));
        this.jButtonReset.setBounds(new Rectangle(114, 21, 78, 23));
        this.jButtonReset.setMargin(new Insets(2, 2, 2, 2));
        this.jButtonRemove.setBounds(new Rectangle(114, 52, 78, 23));
        this.jButtonRemove.setMargin(new Insets(2, 2, 2, 2));
        this.jTextFieldMacroName.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                JDialogCreateEditMacro.this.jTextFieldMacroName_keyTyped(keyEvent);
            }
        });
        this.jComboBoxKeyboardType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JDialogCreateEditMacro.this.jComboBoxKeyboardType_itemStateChanged(itemEvent);
            }
        });
        this.jComboBoxIcons.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JDialogCreateEditMacro.this.jComboBoxIcons_itemStateChanged(itemEvent);
            }
        });
        this.jPanelKeyboard.setBounds(new Rectangle(210, 153, 580, 145));
        this.jPanelKeyStrokes.setBounds(new Rectangle(11, 132, 191, 170));
        this.jPanelType.setBounds(new Rectangle(194, 73, 243, 45));
        this.jPanelMacroType.setBounds(new Rectangle(8, 64, 168, 57));
        this.jPanelDefaultButtons.setBounds(new Rectangle(680, 5, 91, 98));
        this.jPanelMacroName.setBounds(new Rectangle(10, 3, 349, 59));
        this.jButtonHelp.setBounds(new Rectangle(0, 70, 90, 21));
        this.jComboBoxIcons.setBounds(new Rectangle(159, 17, 69, 22));
        this.jComboBoxKeyboardType.setBounds(new Rectangle(1, 17, 140, 22));
        this.jLabelIcon.setBounds(new Rectangle(159, 0, 85, 19));
        this.jLabelKeyboardType.setBounds(new Rectangle(1, 0, 101, 19));
        this.jButtonMoveDown.setBounds(new Rectangle(114, 135, 78, 26));
        this.jButtonMoveUp.setBounds(new Rectangle(114, 102, 78, 26));
        this.jScrollPaneKeyStrokes.setBounds(new Rectangle(1, 21, 110, 140));
        this.jLabelKeyStrokes.setBounds(new Rectangle(1, 0, 109, 21));
        this.jTextFieldMacroName.setBounds(new Rectangle(0, 26, 340, 23));
        this.jLabelMacroName.setBounds(new Rectangle(0, 1, 120, 25));
        this.buttonGroup1.add(this.jRadioButtonGlobal);
        this.buttonGroup1.add(this.jRadioButtonLocal);
        this.titledBorder2 = new TitledBorder(RES.getString("JDialogCreateEditMacro_MacroType"));
        this.jPanelMacroType.setBorder(this.titledBorder2);
        this.jLabelMacroName.setText(RES.getString("JDialogCreateEditMacro_Macro_Name"));
        this.jLabelKeyStrokes.setText(RES.getString("JDialogCreateEditMacro_Keystrokes"));
        this.jButtonReset.setText(RES.getString("JDialogCreateEditMacro_Reset"));
        this.jButtonRemove.setText(RES.getString("JDialogCreateEditMacro_Remove"));
        this.jButtonMoveUp.setIcon(new ImageIcon((class$com$avocent$video$JDialogCreateEditMacro == null ? (class$com$avocent$video$JDialogCreateEditMacro = JDialogCreateEditMacro.class$("com.avocent.video.JDialogCreateEditMacro")) : class$com$avocent$video$JDialogCreateEditMacro).getResource("images/moveup16.gif")));
        this.jButtonMoveUp.setText(RES.getString("JDialogCreateEditMacro_Move_Up"));
        this.jButtonMoveUp.setMargin(new Insets(3, 1, 3, 0));
        this.jButtonMoveUp.setIconTextGap(3);
        this.jButtonMoveUp.setHorizontalAlignment(2);
        this.jButtonMoveDown.setIcon(new ImageIcon((class$com$avocent$video$JDialogCreateEditMacro == null ? (class$com$avocent$video$JDialogCreateEditMacro = JDialogCreateEditMacro.class$("com.avocent.video.JDialogCreateEditMacro")) : class$com$avocent$video$JDialogCreateEditMacro).getResource("images/movedown16.gif")));
        this.jButtonMoveDown.setText(RES.getString("JDialogCreateEditMacro_Move_Down"));
        this.jButtonMoveDown.setMargin(new Insets(3, 1, 3, 0));
        this.jButtonMoveDown.setIconTextGap(3);
        this.jButtonMoveDown.setHorizontalAlignment(2);
        this.jLabelKeyboardType.setText(RES.getString("JDialogCreateEditMacro_KeyboardType"));
        this.jLabelIcon.setText(RES.getString("JDialogCreateEditMacro_MacroIcons_Name"));
        this.jComboBoxIcons.setModel(this.m_comboBoxModelIcons);
        this.jComboBoxKeyboardType.setModel(this.m_comboBoxModelKeyboardTypes);
        this.jListKeyStrokes.setModel(this.m_listModelKeyStrokes);
        this.panel1.setLayout(null);
        this.jPanelMacroName.setLayout(null);
        this.jPanelType.setLayout(null);
        this.jPanelKeyStrokes.setLayout(null);
        this.jPanelDefaultButtons.setLayout(null);
        this.jPanelMacroType.setLayout(null);
        this.getContentPane().add(this.panel1);
        this.jPanelMacroName.add((Component)this.jLabelMacroName, null);
        this.jPanelMacroName.add((Component)this.jTextFieldMacroName, null);
        this.jPanelKeyStrokes.add((Component)this.jScrollPaneKeyStrokes, null);
        this.jScrollPaneKeyStrokes.getViewport().add((Component)this.jListKeyStrokes, null);
        this.jPanelKeyStrokes.add((Component)this.jLabelKeyStrokes, null);
        this.jPanelKeyStrokes.add((Component)this.jButtonRemove, null);
        this.jPanelKeyStrokes.add((Component)this.jButtonReset, null);
        this.jPanelKeyStrokes.add((Component)this.jButtonMoveUp, null);
        this.jPanelKeyStrokes.add((Component)this.jButtonMoveDown, null);
        this.jPanelDefaultButtons.add((Component)this.jButtonOK, null);
        this.jPanelDefaultButtons.add((Component)this.jButtonCancel, null);
        this.jPanelDefaultButtons.add((Component)this.jButtonHelp, null);
        this.panel1.add((Component)this.jPanelKeyboard, null);
        this.panel1.add((Component)this.jPanelDefaultButtons, null);
        this.panel1.add((Component)this.jPanelType, null);
        this.panel1.add((Component)this.jPanelKeyStrokes, null);
        this.panel1.add((Component)this.jPanelMacroName, null);
        this.jPanelType.add((Component)this.jLabelKeyboardType, null);
        this.jPanelType.add((Component)this.jLabelIcon, null);
        this.jPanelType.add((Component)this.jComboBoxIcons, null);
        this.jPanelType.add((Component)this.jComboBoxKeyboardType, null);
        if (this.m_applianceSession.getApplication() == 2) {
            this.jPanelMacroType.add((Component)this.jRadioButtonLocal, null);
            this.jPanelMacroType.add((Component)this.jRadioButtonGlobal, null);
            this.panel1.add((Component)this.jPanelMacroType, null);
        }
    }

    private void jListKeyStrokes_valueChanged(ListSelectionEvent listSelectionEvent) {
        int[] nArray = this.jListKeyStrokes.getSelectedIndices();
        if (nArray.length == 1) {
            this.jButtonRemove.setEnabled(true);
            if (nArray[0] != 0) {
                this.jButtonMoveUp.setEnabled(true);
            } else {
                this.jButtonMoveUp.setEnabled(false);
            }
            if (nArray[0] != this.m_listModelKeyStrokes.size() - 1) {
                this.jButtonMoveDown.setEnabled(true);
            } else {
                this.jButtonMoveDown.setEnabled(false);
            }
        } else if (nArray.length > 1) {
            this.jButtonMoveUp.setEnabled(false);
            this.jButtonMoveDown.setEnabled(false);
            this.jButtonRemove.setEnabled(true);
        } else {
            this.jButtonMoveUp.setEnabled(false);
            this.jButtonMoveDown.setEnabled(false);
            this.jButtonRemove.setEnabled(false);
        }
    }

    private void jButtonReset_actionPerformed(ActionEvent actionEvent) {
        this.m_listModelKeyStrokes.clear();
        this.jButtonMoveUp.setEnabled(false);
        this.jButtonMoveDown.setEnabled(false);
        this.jButtonRemove.setEnabled(false);
        this.jComboBoxKeyboardType.setEnabled(this.m_listModelKeyStrokes.isEmpty());
        this.m_bChanged = true;
    }

    private void jButtonRemove_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.jListKeyStrokes.getSelectedIndices();
        Object var3_3 = null;
        try {
            var3_3 = this.m_listModelKeyStrokes.get(nArray[nArray.length - 1] + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.m_listModelKeyStrokes.remove(nArray[i]);
        }
        if (var3_3 != null) {
            this.jListKeyStrokes.setSelectedValue(var3_3, true);
        }
        this.jComboBoxKeyboardType.setEnabled(this.m_listModelKeyStrokes.isEmpty());
        this.m_bChanged = true;
    }

    private void jButtonMoveUp_actionPerformed(ActionEvent actionEvent) {
        int n = this.jListKeyStrokes.getSelectedIndex();
        Object e = this.m_listModelKeyStrokes.remove(n);
        this.m_listModelKeyStrokes.add(n - 1, e);
        this.jListKeyStrokes.setSelectedIndex(n - 1);
        this.m_bChanged = true;
    }

    private void jButtonMoveDown_actionPerformed(ActionEvent actionEvent) {
        int n = this.jListKeyStrokes.getSelectedIndex();
        Object e = this.m_listModelKeyStrokes.remove(n);
        this.m_listModelKeyStrokes.add(n + 1, e);
        this.jListKeyStrokes.setSelectedIndex(n + 1);
        this.m_bChanged = true;
    }

    private void jButtonOK_actionPerformed(ActionEvent actionEvent) {
        String string = this.jTextFieldMacroName.getText().trim();
        this.jTextFieldMacroName.setText(string);
        if (string.length() > 0) {
            if (this.m_bChanged) {
                if (string.length() > 32) {
                    Message.show((Component)((Object)this), (String)RES.getString("JDialogCreateEditMacro_Macro_name_too_long"));
                    this.jTextFieldMacroName.requestFocus();
                    this.jTextFieldMacroName.setCaretPosition(string.length());
                    return;
                }
                if (this.m_listModelKeyStrokes.size() == 0) {
                    Message.show((Component)((Object)this), (String)RES.getString("JDialogCreateEditMacro_One_keystroke_in_macro"));
                    return;
                }
                if (this.m_km != null) {
                    int n;
                    ApplianceSessionInfo applianceSessionInfo;
                    if (!this.m_km.getName().equalsIgnoreCase(string) && (applianceSessionInfo = this.m_applianceSession.getPersistentDataReference()).doesMacroNameExist(string)) {
                        Object[] objectArray = new Object[]{string};
                        String string2 = MessageFormat.format(RES.getString("JDialogCreateEditMacro_Duplicate_macro_name"), objectArray);
                        Message.show((Component)((Object)this), (String)string2);
                        this.jTextFieldMacroName.requestFocus();
                        this.jTextFieldMacroName.setSelectionStart(0);
                        this.jTextFieldMacroName.setSelectionEnd(string.length());
                        return;
                    }
                    applianceSessionInfo = this.m_applianceSession.getPersistentData();
                    Vector vector = new Vector();
                    for (n = 0; n < this.m_listModelKeyStrokes.size(); ++n) {
                        vector.add(this.m_listModelKeyStrokes.get(n));
                    }
                    n = this.jComboBoxKeyboardType.getSelectedIndex();
                    KeyboardType keyboardType = (KeyboardType)this.m_comboBoxModelKeyboardTypes.getElementAt(n);
                    KeyboardMacro keyboardMacro = new KeyboardMacro(this.m_km.getID(), string, vector, this.jComboBoxIcons.getSelectedIndex() - 1, this.m_km.isMacroOnToolbar(), this.jRadioButtonGlobal.isSelected(), keyboardType.getLanguageCode());
                    try {
                        applianceSessionInfo.setMacro(keyboardMacro);
                        this.m_applianceSession.setPersistentData(applianceSessionInfo);
                    }
                    catch (Exception exception) {
                        Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                    }
                } else {
                    ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
                    if (applianceSessionInfo.doesMacroNameExist(string)) {
                        Object[] objectArray = new Object[]{string};
                        String string3 = MessageFormat.format(RES.getString("JDialogCreateEditMacro_Duplicate_macro_name"), objectArray);
                        Message.show((Component)((Object)this), (String)string3);
                        this.jTextFieldMacroName.requestFocus();
                        this.jTextFieldMacroName.setSelectionStart(0);
                        this.jTextFieldMacroName.setSelectionEnd(string.length());
                        return;
                    }
                    ApplianceSessionInfo applianceSessionInfo2 = this.m_applianceSession.getPersistentData();
                    Vector vector = new Vector();
                    for (int i = 0; i < this.m_listModelKeyStrokes.size(); ++i) {
                        vector.add(this.m_listModelKeyStrokes.get(i));
                    }
                    this.m_km = new KeyboardMacro("MACRO_" + System.currentTimeMillis(), string, vector, this.jComboBoxIcons.getSelectedIndex(), false, this.jRadioButtonGlobal.isSelected(), "en");
                    try {
                        applianceSessionInfo2.setMacro(this.m_km);
                        this.m_applianceSession.setPersistentData(applianceSessionInfo2);
                    }
                    catch (Exception exception) {
                        Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                    }
                }
                this.m_bOKPressed = true;
            }
            this.setVisible(false);
            this.dispose();
        } else {
            Message.show((Component)((Object)this), (String)RES.getString("JDialogCreateEditMacro_No_Macro_Name"));
            this.jTextFieldMacroName.requestFocus();
        }
    }

    private void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void jButtonHelp_actionPerformed(ActionEvent actionEvent) {
        Help.launchHelp(this.m_szHelpURL, "IDH_CREATE_EDIT_MACRO");
    }

    public boolean wasOkPressed() {
        return this.m_bOKPressed;
    }

    public KeyboardMacro getMacro() {
        return this.m_km;
    }

    private void addKeyStrokeToList(KeyStroke keyStroke) {
        this.m_listModelKeyStrokes.addElement(keyStroke);
        int n = this.jListKeyStrokes.getLastVisibleIndex() - this.jListKeyStrokes.getFirstVisibleIndex();
        Rectangle rectangle = this.jListKeyStrokes.getCellBounds(this.m_listModelKeyStrokes.size() - n, this.m_listModelKeyStrokes.size() - 1);
        this.jListKeyStrokes.scrollRectToVisible(rectangle);
        this.jComboBoxKeyboardType.setEnabled(this.m_listModelKeyStrokes.isEmpty());
    }

    private void getMacroKeyboards() {
        try {
            InputStream inputStream = (class$com$avocent$video$JDialogCreateEditMacro == null ? (class$com$avocent$video$JDialogCreateEditMacro = JDialogCreateEditMacro.class$("com.avocent.video.JDialogCreateEditMacro")) : class$com$avocent$video$JDialogCreateEditMacro).getResourceAsStream("keyboard/macro_keyboards.properties");
            Properties properties = new Properties();
            properties.load(inputStream);
            Enumeration<Object> enumeration = properties.keys();
            this.m_vKeyboards = new Vector();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                System.out.println("Key: " + string + " Property: " + string2);
                String[] stringArray = string2.split(",");
                String string3 = null;
                String string4 = null;
                String string5 = null;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].startsWith("languageCode:")) {
                        string3 = stringArray[i].substring(13);
                        continue;
                    }
                    if (stringArray[i].startsWith("filename:")) {
                        string5 = stringArray[i].substring(9);
                        continue;
                    }
                    if (!stringArray[i].startsWith("userLanguage:")) continue;
                    string4 = stringArray[i].substring(13);
                    string4 = RES.getString(string4);
                }
                if (string4 == null || string5 == null || string3 == null) continue;
                Trace.logInfo((String)TRACE_CONTEXT, (String)("JDialogCreateEditMacro keyboard file determined language=" + string4 + " languageCode=" + string3 + " file=" + string5));
                KeyboardType keyboardType = new KeyboardType(string3, string4, string5);
                this.m_vKeyboards.add(keyboardType);
                this.m_comboBoxModelKeyboardTypes.addElement(keyboardType);
            }
            inputStream.close();
            properties.clear();
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    private boolean loadMacroKeyboard(String string, String string2) {
        Component[] componentArray;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JDialogCreateEditMacro loadMacroKeyboard file=" + string));
        String string3 = "keyboard/" + string;
        try {
            componentArray = (class$com$avocent$video$JDialogCreateEditMacro == null ? (class$com$avocent$video$JDialogCreateEditMacro = JDialogCreateEditMacro.class$("com.avocent.video.JDialogCreateEditMacro")) : class$com$avocent$video$JDialogCreateEditMacro).getResourceAsStream(string3);
            Properties properties = new Properties();
            properties.load((InputStream)componentArray);
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                Object object2 = properties.get(object);
                Trace.logInfo((String)TRACE_CONTEXT, (String)("JDialogCreateEditMacro loadMacroKeyboard Key: " + object + " Property: " + object2));
            }
            componentArray.close();
            m_mkl = MacroKeyboardLocalization.getInstance(string3);
            this.m_panelMacroKeyboard = new JPanelMacroKeyboard(properties);
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
            return false;
        }
        catch (ExceptionRequestFailed exceptionRequestFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
            return false;
        }
        componentArray = this.jPanelKeyboard.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JPanelMacroKeyboard)) continue;
            this.jPanelKeyboard.remove(componentArray[i]);
            break;
        }
        this.jPanelKeyboard.add(this.m_panelMacroKeyboard);
        this.jPanelKeyboard.updateUI();
        this.jPanelKeyboard.repaint();
        return true;
    }

    void jTextFieldMacroName_keyTyped(KeyEvent keyEvent) {
        this.m_bChanged = true;
    }

    void jComboBoxKeyboardType_itemStateChanged(ItemEvent itemEvent) {
        KeyboardType keyboardType;
        this.m_bChanged = true;
        int n = this.jComboBoxKeyboardType.getSelectedIndex();
        if (n >= 0 && !this.loadMacroKeyboard((keyboardType = (KeyboardType)this.jComboBoxKeyboardType.getModel().getSelectedItem()).getFilename(), keyboardType.getLanguageCode())) {
            this.loadMacroKeyboard(ENGLISH_KEYBOARD, "en");
        }
    }

    void jComboBoxIcons_itemStateChanged(ItemEvent itemEvent) {
        this.m_bChanged = true;
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            return;
        }
        JDialogCreateEditMacro jDialogCreateEditMacro = new JDialogCreateEditMacro(null, null, null, "");
        jDialogCreateEditMacro.setVisible(true);
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ boolean access$1602(JDialogCreateEditMacro jDialogCreateEditMacro, boolean bl) {
        jDialogCreateEditMacro.m_bChanged = bl;
        return jDialogCreateEditMacro.m_bChanged;
    }

    static /* synthetic */ void access$1700(JDialogCreateEditMacro jDialogCreateEditMacro, KeyStroke keyStroke) {
        jDialogCreateEditMacro.addKeyStrokeToList(keyStroke);
    }

    static /* synthetic */ JPanelMacroKeyboard access$1800(JDialogCreateEditMacro jDialogCreateEditMacro) {
        return jDialogCreateEditMacro.m_panelMacroKeyboard;
    }

    private class JComboBoxSunKeys
    extends JComboBox {
        int m_nX = 0;
        int m_nY = 0;
        int m_nWidth = 70;
        int m_nHeight = 20;
        DefaultComboBoxModel m_comboBoxModel = new DefaultComboBoxModel();

        private JComboBoxSunKeys(String string) throws ExceptionRequestFailed {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                KeyStroke keyStroke;
                String string2;
                if (stringArray[i].startsWith("x:")) {
                    string2 = stringArray[i].substring(2);
                    try {
                        this.m_nX = new Integer(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionRequestFailed("Incorrect X value");
                    }
                }
                if (stringArray[i].startsWith("y:")) {
                    string2 = stringArray[i].substring(2);
                    try {
                        this.m_nY = new Integer(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionRequestFailed("Incorrect Y value");
                    }
                }
                if (stringArray[i].startsWith("width:")) {
                    string2 = stringArray[i].substring(6);
                    try {
                        this.m_nWidth = new Integer(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionRequestFailed("Incorrect Width value");
                    }
                }
                if (stringArray[i].startsWith("height:")) {
                    string2 = stringArray[i].substring(7);
                    try {
                        this.m_nHeight = new Integer(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionRequestFailed("Incorrect Height value");
                    }
                }
                if (stringArray[i].startsWith("sunkeyExecute:")) {
                    string2 = stringArray[i].substring(14).trim();
                    if (string2.startsWith("KEY_")) {
                        string2 = m_mkl.getProperty(string2);
                    }
                    keyStroke = new KeyStroke(2, 116, string2);
                    this.m_comboBoxModel.addElement(keyStroke);
                    continue;
                }
                if (stringArray[i].startsWith("sunkeyHelp:")) {
                    string2 = stringArray[i].substring(11).trim();
                    if (string2.startsWith("KEY_")) {
                        string2 = m_mkl.getProperty(string2);
                    }
                    keyStroke = new KeyStroke(2, 117, string2);
                    this.m_comboBoxModel.addElement(keyStroke);
                    continue;
                }
                if (stringArray[i].startsWith("sunkeyMenu:")) {
                    string2 = stringArray[i].substring(11).trim();
                    if (string2.startsWith("KEY_")) {
                        string2 = m_mkl.getProperty(string2);
                    }
                    keyStroke = new KeyStroke(2, 118, string2);
                    this.m_comboBoxModel.addElement(keyStroke);
                    continue;
                }
                if (stringArray[i].startsWith("sunkeySelect:")) {
                    string2 = stringArray[i].substring(13).trim();
                    if (string2.startsWith("KEY_")) {
                        string2 = m_mkl.getProperty(string2);
                    }
                    keyStroke = new KeyStroke(2, 119, string2);
                    this.m_comboBoxModel.addElement(keyStroke);
                    continue;
                }
                if (stringArray[i].startsWith("sunkeyStopPress:")) {
                    string2 = stringArray[i].substring(16).trim();
                    if (string2.startsWith("KEY_")) {
                        string2 = m_mkl.getProperty(string2);
                    }
                    keyStroke = new KeyStroke(0, 120, string2);
                    this.m_comboBoxModel.addElement(keyStroke);
                    continue;
                }
                if (stringArray[i].startsWith("sunkeyStopRelease:")) {
                    string2 = stringArray[i].substring(18).trim();
                    if (string2.startsWith("KEY_")) {
                        string2 = m_mkl.getProperty(string2);
                    }
                    keyStroke = new KeyStroke(1, 120, string2);
                    this.m_comboBoxModel.addElement(keyStroke);
                    continue;
                }
                if (stringArray[i].startsWith("sunkeyAgain:")) {
                    string2 = stringArray[i].substring(12).trim();
                    if (string2.startsWith("KEY_")) {
                        string2 = m_mkl.getProperty(string2);
                    }
                    keyStroke = new KeyStroke(2, 121, string2);
                    this.m_comboBoxModel.addElement(keyStroke);
                    continue;
                }
                if (stringArray[i].startsWith("sunkeyUndo:")) {
                    string2 = stringArray[i].substring(11).trim();
                    if (string2.startsWith("KEY_")) {
                        string2 = m_mkl.getProperty(string2);
                    }
                    keyStroke = new KeyStroke(2, 122, string2);
                    this.m_comboBoxModel.addElement(keyStroke);
                    continue;
                }
                if (stringArray[i].startsWith("sunkeyCut:")) {
                    string2 = stringArray[i].substring(10).trim();
                    if (string2.startsWith("KEY_")) {
                        string2 = m_mkl.getProperty(string2);
                    }
                    keyStroke = new KeyStroke(2, 123, string2);
                    this.m_comboBoxModel.addElement(keyStroke);
                    continue;
                }
                if (stringArray[i].startsWith("sunkeyCopy:")) {
                    string2 = stringArray[i].substring(11).trim();
                    if (string2.startsWith("KEY_")) {
                        string2 = m_mkl.getProperty(string2);
                    }
                    keyStroke = new KeyStroke(2, 124, string2);
                    this.m_comboBoxModel.addElement(keyStroke);
                    continue;
                }
                if (stringArray[i].startsWith("sunkeyPaste:")) {
                    string2 = stringArray[i].substring(12).trim();
                    if (string2.startsWith("KEY_")) {
                        string2 = m_mkl.getProperty(string2);
                    }
                    keyStroke = new KeyStroke(2, 125, string2);
                    this.m_comboBoxModel.addElement(keyStroke);
                    continue;
                }
                if (stringArray[i].startsWith("sunkeyFind:")) {
                    string2 = stringArray[i].substring(11).trim();
                    if (string2.startsWith("KEY_")) {
                        string2 = m_mkl.getProperty(string2);
                    }
                    keyStroke = new KeyStroke(2, 126, string2);
                    this.m_comboBoxModel.addElement(keyStroke);
                    continue;
                }
                if (stringArray[i].startsWith("sunkeyMute:")) {
                    string2 = stringArray[i].substring(11).trim();
                    if (string2.startsWith("KEY_")) {
                        string2 = m_mkl.getProperty(string2);
                    }
                    keyStroke = new KeyStroke(2, 127, string2);
                    this.m_comboBoxModel.addElement(keyStroke);
                    continue;
                }
                if (stringArray[i].startsWith("sunkeyVolumeUp:")) {
                    string2 = stringArray[i].substring(15).trim();
                    if (string2.startsWith("KEY_")) {
                        string2 = m_mkl.getProperty(string2);
                    }
                    keyStroke = new KeyStroke(2, 128, string2);
                    this.m_comboBoxModel.addElement(keyStroke);
                    continue;
                }
                if (stringArray[i].startsWith("sunkeyVolumeDown:")) {
                    string2 = stringArray[i].substring(17).trim();
                    if (string2.startsWith("KEY_")) {
                        string2 = m_mkl.getProperty(string2);
                    }
                    keyStroke = new KeyStroke(2, 129, string2);
                    this.m_comboBoxModel.addElement(keyStroke);
                    continue;
                }
                if (!stringArray[i].startsWith("sunkeyPower:")) continue;
                string2 = stringArray[i].substring(12).trim();
                if (string2.startsWith("KEY_")) {
                    string2 = m_mkl.getProperty(string2);
                }
                keyStroke = new KeyStroke(2, 102, string2);
                this.m_comboBoxModel.addElement(keyStroke);
            }
            this.setModel(this.m_comboBoxModel);
            this.setBounds(this.m_nX, this.m_nY, this.m_nWidth, this.m_nHeight);
            this.setVisible(true);
            this.setFocusable(false);
            this.repaint();
            this.addPopupMenuListener(new PopupMenuListener(this){
                private final /* synthetic */ JComboBoxSunKeys this$1;
                {
                    this.this$1 = jComboBoxSunKeys;
                }

                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    this.this$1.PopupMenuWillBecomeVisible(popupMenuEvent);
                }

                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                }

                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                }
            });
        }

        public void PopupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JComboBox jComboBox = (JComboBox)popupMenuEvent.getSource();
            Accessible accessible = jComboBox.getUI().getAccessibleChild(jComboBox, 0);
            if (!(accessible instanceof JPopupMenu)) {
                return;
            }
            JComponent jComponent = (JComponent)((JPopupMenu)accessible).getComponent(0);
            Dimension dimension = new Dimension();
            dimension.width = jComboBox.getPreferredSize().width;
            dimension.height = jComponent.getPreferredSize().height;
            jComponent.setPreferredSize(dimension);
            jComponent.setMinimumSize(dimension);
            jComponent.setMaximumSize(dimension);
            if (jComponent instanceof JScrollPane) {
                ((JScrollPane)jComponent).setHorizontalScrollBarPolicy(31);
                ((JScrollPane)jComponent).setVerticalScrollBarPolicy(20);
            }
        }
    }

    private class KeyboardType {
        private String m_szLanguageCode;
        private String m_szFilename;
        private String m_szLanguage;

        private KeyboardType(String string, String string2, String string3) {
            this.m_szLanguageCode = string;
            this.m_szLanguage = string2;
            this.m_szFilename = string3;
        }

        private String getLanguageCode() {
            return this.m_szLanguageCode;
        }

        private String getFilename() {
            return this.m_szFilename;
        }

        private String getLanguage() {
            return this.m_szLanguage;
        }

        public String toString() {
            return this.m_szLanguage;
        }
    }

    private class JButtonMacroKey
    extends JButton {
        private static final int KEY_TYPE_NORMAL = 0;
        private static final int KEY_TYPE_LEFT_SHIFT = 1;
        private static final int KEY_TYPE_RIGHT_SHIFT = 2;
        private static final int KEY_TYPE_CTRL = 3;
        private static final int KEY_TYPE_ALT = 4;
        private static final int KEY_TYPE_CAPS_LOCK = 5;
        private static final int KEY_TYPE_NUM_LOCK = 6;
        private static final int KEY_TYPE_NUM_PAD = 7;
        private static final int KEY_TYPE_ALT_GR = 8;
        private static final int KEY_TYPE_HAN_ZEN = 9;
        private static final int KEY_TYPE_SUN_KEYS = 10;
        private static final int NORMAL_KEY_STATE_NORMAL = 0;
        private static final int NORMAL_KEY_STATE_LEFT_SHIFTED = 1;
        private static final int NORMAL_KEY_STATE_RIGHT_SHIFTED = 2;
        private static final int NORMAL_KEY_STATE_CAPSLOCK = 4;
        private static final int NORMAL_KEY_STATE_ALT_GR = 8;
        private static final int NORMAL_KEY_STATE_HAN_ZEN = 16;
        private static final int NORMAL_KEY_STATE_DOWN = 32;
        private static final int NUMPAD_KEY_STATE_NORMAL = 0;
        private static final int NUMPAD_KEY_STATE_NUM_LOCK = 64;
        int m_nKeyType = 0;
        int m_nUSB = 0;
        int m_nX = 0;
        int m_nY = 0;
        int m_nWidth = 20;
        int m_nHeight = 20;
        int m_nState = 0;
        String m_szTextNormal = "";
        String m_szTextNormalExtended = "";
        String m_szTextShift = "";
        String m_szTextShiftExtended = "";
        String m_szTextCapsLock = "";
        String m_szTextCapsLockExtended = "";
        String m_szTextNumLock = "";
        String m_szTextNumLockExtended = "";
        String m_szTextAltGr = "";
        String m_szTextHanZen = "";
        String m_szTextShiftAltGr = "";
        ImageIcon m_iconNormal = null;
        ImageIcon m_iconShift = null;
        ImageIcon m_iconNumLock = null;
        ImageIcon m_iconAltGr = null;
        ImageIcon m_iconHanZen = null;

        private JButtonMacroKey(String string) throws ExceptionRequestFailed {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2;
                if (stringArray[i].startsWith("type:")) {
                    string2 = stringArray[i].substring(5);
                    if (string2.compareToIgnoreCase("NORMAL") == 0) {
                        this.m_nKeyType = 0;
                        continue;
                    }
                    if (string2.compareToIgnoreCase("LSHIFT") == 0) {
                        this.m_nKeyType = 1;
                        continue;
                    }
                    if (string2.compareToIgnoreCase("RSHIFT") == 0) {
                        this.m_nKeyType = 2;
                        continue;
                    }
                    if (string2.compareToIgnoreCase("CTRL") == 0) {
                        this.m_nKeyType = 3;
                        continue;
                    }
                    if (string2.compareToIgnoreCase("ALT") == 0) {
                        this.m_nKeyType = 4;
                        continue;
                    }
                    if (string2.compareToIgnoreCase("CAPS-LOCK") == 0) {
                        this.m_nKeyType = 5;
                        continue;
                    }
                    if (string2.compareToIgnoreCase("NUM-LOCK") == 0) {
                        this.m_nKeyType = 6;
                        continue;
                    }
                    if (string2.compareToIgnoreCase("NUMPAD") == 0) {
                        this.m_nKeyType = 7;
                        continue;
                    }
                    if (string2.compareToIgnoreCase("ALT-GR") == 0) {
                        this.m_nKeyType = 8;
                        continue;
                    }
                    if (string2.compareToIgnoreCase("HAN-ZEN") == 0) {
                        this.m_nKeyType = 9;
                        continue;
                    }
                    if (string2.compareToIgnoreCase("SUN-KEYS") == 0) {
                        this.m_nKeyType = 10;
                        continue;
                    }
                    throw new ExceptionRequestFailed("Unrecognized key type");
                }
                if (stringArray[i].startsWith("usb:")) {
                    string2 = stringArray[i].substring(4);
                    try {
                        this.m_nUSB = new Integer(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionRequestFailed("Incorrect USB value");
                    }
                }
                if (stringArray[i].startsWith("x:")) {
                    string2 = stringArray[i].substring(2);
                    try {
                        this.m_nX = new Integer(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionRequestFailed("Incorrect X value");
                    }
                }
                if (stringArray[i].startsWith("y:")) {
                    string2 = stringArray[i].substring(2);
                    try {
                        this.m_nY = new Integer(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionRequestFailed("Incorrect Y value");
                    }
                }
                if (stringArray[i].startsWith("width:")) {
                    string2 = stringArray[i].substring(6);
                    try {
                        this.m_nWidth = new Integer(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionRequestFailed("Incorrect Width value");
                    }
                }
                if (stringArray[i].startsWith("height:")) {
                    string2 = stringArray[i].substring(7);
                    try {
                        this.m_nHeight = new Integer(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ExceptionRequestFailed("Incorrect Height value");
                    }
                }
                if (stringArray[i].startsWith("textNormal:")) {
                    this.m_szTextNormal = stringArray[i].substring(11).trim();
                    if (this.m_szTextNormal.compareToIgnoreCase("COMMA") == 0) {
                        this.m_szTextNormal = ",";
                    }
                    if (!this.m_szTextNormal.startsWith("KEY_")) continue;
                    this.m_szTextNormal = m_mkl.getProperty(this.m_szTextNormal);
                    continue;
                }
                if (stringArray[i].startsWith("textNormalExt:")) {
                    this.m_szTextNormalExtended = stringArray[i].substring(14).trim();
                    if (!this.m_szTextNormalExtended.startsWith("KEY_")) continue;
                    this.m_szTextNormalExtended = m_mkl.getProperty(this.m_szTextNormalExtended);
                    continue;
                }
                if (stringArray[i].startsWith("textShift:")) {
                    this.m_szTextShift = stringArray[i].substring(10).trim();
                    if (!this.m_szTextShift.startsWith("KEY_")) continue;
                    this.m_szTextShift = m_mkl.getProperty(this.m_szTextShift);
                    continue;
                }
                if (stringArray[i].startsWith("textShiftExt:")) {
                    this.m_szTextShiftExtended = stringArray[i].substring(13).trim();
                    if (!this.m_szTextShiftExtended.startsWith("KEY_")) continue;
                    this.m_szTextShiftExtended = m_mkl.getProperty(this.m_szTextShiftExtended);
                    continue;
                }
                if (stringArray[i].startsWith("textCapsLock:")) {
                    this.m_szTextCapsLock = stringArray[i].substring(13).trim();
                    if (this.m_szTextCapsLock.compareToIgnoreCase("COMMA") == 0) {
                        this.m_szTextCapsLock = ",";
                    }
                    if (!this.m_szTextCapsLock.startsWith("KEY_")) continue;
                    this.m_szTextCapsLock = m_mkl.getProperty(this.m_szTextCapsLock);
                    continue;
                }
                if (stringArray[i].startsWith("textCapsLockExt:")) {
                    this.m_szTextCapsLockExtended = stringArray[i].substring(16).trim();
                    if (!this.m_szTextCapsLockExtended.startsWith("KEY_")) continue;
                    this.m_szTextCapsLockExtended = m_mkl.getProperty(this.m_szTextCapsLockExtended);
                    continue;
                }
                if (stringArray[i].startsWith("textAltGr:")) {
                    this.m_szTextAltGr = stringArray[i].substring(10).trim();
                    if (!this.m_szTextAltGr.startsWith("KEY_")) continue;
                    this.m_szTextAltGr = m_mkl.getProperty(this.m_szTextAltGr);
                    continue;
                }
                if (stringArray[i].startsWith("textHanZen:")) {
                    this.m_szTextHanZen = stringArray[i].substring(11).trim();
                    continue;
                }
                if (stringArray[i].startsWith("textShiftAltGr:")) {
                    this.m_szTextShiftAltGr = stringArray[i].substring(15).trim();
                    if (!this.m_szTextShiftAltGr.startsWith("KEY_")) continue;
                    this.m_szTextShiftAltGr = m_mkl.getProperty(this.m_szTextShiftAltGr);
                    continue;
                }
                if (stringArray[i].startsWith("textNumLock:")) {
                    this.m_szTextNumLock = stringArray[i].substring(12).trim();
                    if (!this.m_szTextNumLock.startsWith("KEY_")) continue;
                    this.m_szTextNumLock = m_mkl.getProperty(this.m_szTextNumLock);
                    continue;
                }
                if (stringArray[i].startsWith("textNumLockExt:")) {
                    this.m_szTextNumLockExtended = stringArray[i].substring(15).trim();
                    if (!this.m_szTextNumLockExtended.startsWith("KEY_")) continue;
                    this.m_szTextNumLockExtended = m_mkl.getProperty(this.m_szTextNumLockExtended);
                    continue;
                }
                if (stringArray[i].startsWith("iconNormal:")) {
                    string2 = "images/" + stringArray[i].substring(11).trim();
                    this.m_iconNormal = new ImageIcon((class$com$avocent$video$JDialogCreateEditMacro == null ? JDialogCreateEditMacro.class$("com.avocent.video.JDialogCreateEditMacro") : class$com$avocent$video$JDialogCreateEditMacro).getResource(string2));
                    continue;
                }
                if (stringArray[i].startsWith("iconShift:")) {
                    string2 = "images/" + stringArray[i].substring(10).trim();
                    this.m_iconShift = new ImageIcon((class$com$avocent$video$JDialogCreateEditMacro == null ? JDialogCreateEditMacro.class$("com.avocent.video.JDialogCreateEditMacro") : class$com$avocent$video$JDialogCreateEditMacro).getResource(string2));
                    continue;
                }
                if (stringArray[i].startsWith("iconNumLock:")) {
                    string2 = "images/" + stringArray[i].substring(12).trim();
                    this.m_iconNumLock = new ImageIcon((class$com$avocent$video$JDialogCreateEditMacro == null ? JDialogCreateEditMacro.class$("com.avocent.video.JDialogCreateEditMacro") : class$com$avocent$video$JDialogCreateEditMacro).getResource(string2));
                    continue;
                }
                if (stringArray[i].startsWith("iconAltGr:")) {
                    string2 = "images/" + stringArray[i].substring(10).trim();
                    this.m_iconAltGr = new ImageIcon((class$com$avocent$video$JDialogCreateEditMacro == null ? JDialogCreateEditMacro.class$("com.avocent.video.JDialogCreateEditMacro") : class$com$avocent$video$JDialogCreateEditMacro).getResource(string2));
                    continue;
                }
                if (!stringArray[i].startsWith("iconHanZen:")) continue;
                string2 = "images/" + stringArray[i].substring(11).trim();
                this.m_iconHanZen = new ImageIcon((class$com$avocent$video$JDialogCreateEditMacro == null ? JDialogCreateEditMacro.class$("com.avocent.video.JDialogCreateEditMacro") : class$com$avocent$video$JDialogCreateEditMacro).getResource(string2));
            }
            this.setFont(new Font("Tahoma", 0, 9));
            this.setMargin(new Insets(0, 0, 0, 0));
            if (this.m_iconNormal == null) {
                this.setText(this.m_szTextNormal);
            } else {
                this.setIcon(this.m_iconNormal);
            }
            this.setBounds(this.m_nX, this.m_nY, this.m_nWidth, this.m_nHeight);
            this.setVisible(true);
            this.setFocusable(false);
            this.repaint();
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ JButtonMacroKey this$1;
                {
                    this.this$1 = jButtonMacroKey;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    JButtonMacroKey jButtonMacroKey = (JButtonMacroKey)actionEvent.getSource();
                    JDialogCreateEditMacro.access$1602(JButtonMacroKey.access$1500(this.this$1), true);
                    switch (jButtonMacroKey.m_nKeyType) {
                        case 0: {
                            if (jButtonMacroKey.m_nState == 0) {
                                KeyStroke keyStroke = jButtonMacroKey.m_szTextNormalExtended.length() > 0 ? new KeyStroke(2, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormalExtended) : new KeyStroke(2, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormal);
                                JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                                break;
                            }
                            if (jButtonMacroKey.m_nState == 1 || jButtonMacroKey.m_nState == 2) {
                                if (jButtonMacroKey.m_szTextShift.length() <= 0) break;
                                KeyStroke keyStroke = jButtonMacroKey.m_szTextShiftExtended.length() > 0 ? new KeyStroke(2, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextShift) : new KeyStroke(2, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextShift);
                                JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                                break;
                            }
                            if (jButtonMacroKey.m_nState == 4) {
                                if (jButtonMacroKey.m_szTextCapsLock.length() > 0) {
                                    KeyStroke keyStroke = jButtonMacroKey.m_szTextCapsLockExtended.length() > 0 ? new KeyStroke(2, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextCapsLockExtended) : new KeyStroke(2, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextCapsLock);
                                    JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                                    break;
                                }
                                if (jButtonMacroKey.m_szTextShift.length() <= 0) break;
                                KeyStroke keyStroke = jButtonMacroKey.m_szTextShiftExtended.length() > 0 ? new KeyStroke(2, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextShift) : new KeyStroke(2, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextShift);
                                JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                                break;
                            }
                            if (jButtonMacroKey.m_nState == 8) {
                                if (jButtonMacroKey.m_szTextAltGr.length() <= 0) break;
                                KeyStroke keyStroke = new KeyStroke(2, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextAltGr);
                                JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                                break;
                            }
                            if (jButtonMacroKey.m_nState == 16) {
                                if (jButtonMacroKey.m_szTextHanZen.length() <= 0) break;
                                KeyStroke keyStroke = new KeyStroke(2, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextHanZen);
                                JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                                break;
                            }
                            if (jButtonMacroKey.m_nState != 9 || jButtonMacroKey.m_szTextShiftAltGr.length() <= 0) break;
                            KeyStroke keyStroke = new KeyStroke(2, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextShiftAltGr);
                            JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                            break;
                        }
                        case 1: 
                        case 2: {
                            if (this.this$1.m_nState == 0) {
                                if (jButtonMacroKey.m_nKeyType == 1) {
                                    JPanelMacroKeyboard.access$1900(JDialogCreateEditMacro.access$1800(JButtonMacroKey.access$1500(this.this$1)), true, 1, 1);
                                } else {
                                    JPanelMacroKeyboard.access$1900(JDialogCreateEditMacro.access$1800(JButtonMacroKey.access$1500(this.this$1)), true, 2, 2);
                                }
                                KeyStroke keyStroke = jButtonMacroKey.m_szTextNormalExtended.length() > 0 ? new KeyStroke(0, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormalExtended) : new KeyStroke(0, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormal);
                                JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                                this.this$1.setBackground(UIManager.getColor("Button.shadow"));
                                this.this$1.setForeground(UIManager.getColor("Button.highlight"));
                                if (jButtonMacroKey.m_nKeyType == 1) {
                                    this.this$1.m_nState = 1;
                                    break;
                                }
                                this.this$1.m_nState = 2;
                                break;
                            }
                            if (jButtonMacroKey.m_nKeyType == 1) {
                                JPanelMacroKeyboard.access$1900(JDialogCreateEditMacro.access$1800(JButtonMacroKey.access$1500(this.this$1)), false, 1, 1);
                            } else {
                                JPanelMacroKeyboard.access$1900(JDialogCreateEditMacro.access$1800(JButtonMacroKey.access$1500(this.this$1)), false, 2, 2);
                            }
                            KeyStroke keyStroke = jButtonMacroKey.m_szTextNormalExtended.length() > 0 ? new KeyStroke(1, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormalExtended) : new KeyStroke(1, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormal);
                            JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                            this.this$1.setBackground(null);
                            this.this$1.setForeground(null);
                            this.this$1.m_nState = 0;
                            break;
                        }
                        case 5: {
                            if (this.this$1.m_nState == 0) {
                                JPanelMacroKeyboard.access$1900(JDialogCreateEditMacro.access$1800(JButtonMacroKey.access$1500(this.this$1)), true, 4, 5);
                                KeyStroke keyStroke = jButtonMacroKey.m_szTextNormalExtended.length() > 0 ? new KeyStroke(0, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormalExtended) : new KeyStroke(0, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormal);
                                JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                                this.this$1.setBackground(UIManager.getColor("Button.shadow"));
                                this.this$1.setForeground(UIManager.getColor("Button.highlight"));
                                this.this$1.m_nState = 4;
                                break;
                            }
                            JPanelMacroKeyboard.access$1900(JDialogCreateEditMacro.access$1800(JButtonMacroKey.access$1500(this.this$1)), false, 4, 5);
                            KeyStroke keyStroke = jButtonMacroKey.m_szTextNormalExtended.length() > 0 ? new KeyStroke(1, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormalExtended) : new KeyStroke(1, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormal);
                            JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                            this.this$1.setBackground(null);
                            this.this$1.setForeground(null);
                            this.this$1.m_nState = 0;
                            break;
                        }
                        case 6: {
                            if (this.this$1.m_nState == 0) {
                                JPanelMacroKeyboard.access$1900(JDialogCreateEditMacro.access$1800(JButtonMacroKey.access$1500(this.this$1)), true, 64, 6);
                                KeyStroke keyStroke = jButtonMacroKey.m_szTextNormalExtended.length() > 0 ? new KeyStroke(0, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormalExtended) : new KeyStroke(0, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormal);
                                JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                                this.this$1.setBackground(UIManager.getColor("Button.shadow"));
                                this.this$1.setForeground(UIManager.getColor("Button.highlight"));
                                this.this$1.m_nState = 64;
                                break;
                            }
                            JPanelMacroKeyboard.access$1900(JDialogCreateEditMacro.access$1800(JButtonMacroKey.access$1500(this.this$1)), false, 64, 6);
                            KeyStroke keyStroke = jButtonMacroKey.m_szTextNormalExtended.length() > 0 ? new KeyStroke(1, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormalExtended) : new KeyStroke(1, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormal);
                            JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                            this.this$1.setBackground(null);
                            this.this$1.setForeground(null);
                            this.this$1.m_nState = 0;
                            break;
                        }
                        case 7: {
                            if (this.this$1.m_nState == 0) {
                                KeyStroke keyStroke = jButtonMacroKey.m_szTextNormalExtended.length() > 0 ? new KeyStroke(2, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormalExtended) : new KeyStroke(2, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormal);
                                JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                                break;
                            }
                            KeyStroke keyStroke = jButtonMacroKey.m_szTextNumLockExtended.length() > 0 ? new KeyStroke(2, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNumLockExtended) : new KeyStroke(2, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNumLock);
                            JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                            break;
                        }
                        case 8: {
                            if (this.this$1.m_nState == 0) {
                                JPanelMacroKeyboard.access$1900(JDialogCreateEditMacro.access$1800(JButtonMacroKey.access$1500(this.this$1)), true, 8, 8);
                                KeyStroke keyStroke = jButtonMacroKey.m_szTextNormalExtended.length() > 0 ? new KeyStroke(0, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormalExtended) : new KeyStroke(0, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormal);
                                JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                                this.this$1.setBackground(UIManager.getColor("Button.shadow"));
                                this.this$1.setForeground(UIManager.getColor("Button.highlight"));
                                this.this$1.m_nState = 8;
                                break;
                            }
                            JPanelMacroKeyboard.access$1900(JDialogCreateEditMacro.access$1800(JButtonMacroKey.access$1500(this.this$1)), false, 8, 8);
                            KeyStroke keyStroke = jButtonMacroKey.m_szTextNormalExtended.length() > 0 ? new KeyStroke(1, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormalExtended) : new KeyStroke(1, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormal);
                            JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                            this.this$1.setBackground(null);
                            this.this$1.setForeground(null);
                            this.this$1.m_nState = 0;
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 9: {
                            if (this.this$1.m_nState == 0) {
                                KeyStroke keyStroke = jButtonMacroKey.m_szTextNormalExtended.length() > 0 ? new KeyStroke(0, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormalExtended) : new KeyStroke(0, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormal);
                                JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                                this.this$1.setBackground(UIManager.getColor("Button.shadow"));
                                this.this$1.setForeground(UIManager.getColor("Button.highlight"));
                                this.this$1.m_nState = 32;
                                break;
                            }
                            KeyStroke keyStroke = jButtonMacroKey.m_szTextNormalExtended.length() > 0 ? new KeyStroke(1, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormalExtended) : new KeyStroke(1, jButtonMacroKey.m_nUSB, jButtonMacroKey.m_szTextNormal);
                            JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                            this.this$1.setBackground(null);
                            this.this$1.setForeground(null);
                            this.this$1.m_nState = 0;
                            break;
                        }
                        case 10: {
                            int n;
                            if (this.this$1.m_nState != 0 || (n = JDialogCreateEditMacro.access$1100(JButtonMacroKey.access$1500(this.this$1)).getSelectedIndex()) < 0) break;
                            KeyStroke keyStroke = (KeyStroke)JDialogCreateEditMacro.access$1100(JButtonMacroKey.access$1500(this.this$1)).getModel().getElementAt(n);
                            JDialogCreateEditMacro.access$1700(JButtonMacroKey.access$1500(this.this$1), keyStroke);
                            break;
                        }
                    }
                }
            });
        }

        private int getUsbCode() {
            return this.m_nUSB;
        }

        private void setState(boolean bl, int n, int n2) {
            block0 : switch (this.m_nKeyType) {
                case 0: {
                    if (n2 != 4 && n2 != 3 && n2 != 8 && n2 != 9 && n2 != 1 && n2 != 2 && n2 != 5) break;
                    this.m_nState = bl ? (this.m_nState |= n) : (this.m_nState &= ~n);
                    switch (this.m_nState) {
                        case 0: {
                            if (this.m_iconNormal == null) {
                                this.setText(this.m_szTextNormal);
                                this.setIcon(null);
                                break;
                            }
                            this.setIcon(this.m_iconNormal);
                            this.setText("");
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: {
                            if (this.m_iconShift == null) {
                                this.setText(this.m_szTextShift);
                                this.setIcon(null);
                                break;
                            }
                            this.setIcon(this.m_iconShift);
                            this.setText("");
                            break;
                        }
                        case 4: {
                            if (this.m_iconShift == null) {
                                if (this.m_szTextCapsLock.length() > 0) {
                                    this.setText(this.m_szTextCapsLock);
                                } else {
                                    this.setText(this.m_szTextShift);
                                }
                                this.setIcon(null);
                                break;
                            }
                            this.setIcon(this.m_iconShift);
                            this.setText("");
                            break;
                        }
                        case 8: {
                            if (this.m_iconAltGr == null) {
                                this.setText(this.m_szTextAltGr);
                                this.setIcon(null);
                                break;
                            }
                            this.setIcon(this.m_iconAltGr);
                            this.setText("");
                            break;
                        }
                        case 16: {
                            if (this.m_iconHanZen == null) {
                                this.setText(this.m_szTextHanZen);
                                this.setIcon(null);
                                break;
                            }
                            this.setIcon(this.m_iconHanZen);
                            this.setText("");
                            break;
                        }
                        case 9: 
                        case 10: 
                        case 11: {
                            this.setText(this.m_szTextShiftAltGr);
                            this.setIcon(null);
                        }
                    }
                    break;
                }
                case 7: {
                    if (n2 == 6) {
                        this.m_nState = bl ? (this.m_nState |= n) : (this.m_nState &= ~n);
                        switch (this.m_nState) {
                            case 0: {
                                if (this.m_iconNormal == null) {
                                    this.setText(this.m_szTextNormal);
                                    this.setIcon(null);
                                    break;
                                }
                                this.setIcon(this.m_iconNormal);
                                this.setText("");
                                break;
                            }
                            case 64: {
                                if (this.m_iconNumLock == null) {
                                    this.setText(this.m_szTextNumLock);
                                    this.setIcon(null);
                                    break;
                                }
                                this.setIcon(this.m_iconNumLock);
                                this.setText("");
                            }
                        }
                        break;
                    }
                    if (n2 != 8) break;
                    this.m_nState = bl ? (this.m_nState |= n) : (this.m_nState &= ~n);
                    if ((this.m_nState & 8) != 0) {
                        this.setText("");
                        this.setIcon(null);
                        break;
                    }
                    switch (this.m_nState) {
                        case 0: {
                            if (this.m_iconNormal == null) {
                                this.setText(this.m_szTextNormal);
                                this.setIcon(null);
                                break block0;
                            }
                            this.setIcon(this.m_iconNormal);
                            this.setText("");
                            break block0;
                        }
                        case 64: {
                            if (this.m_iconNumLock == null) {
                                this.setText(this.m_szTextNumLock);
                                this.setIcon(null);
                                break block0;
                            }
                            this.setIcon(this.m_iconNumLock);
                            this.setText("");
                        }
                    }
                }
            }
        }

        static /* synthetic */ JDialogCreateEditMacro access$1500(JButtonMacroKey jButtonMacroKey) {
            return jButtonMacroKey.JDialogCreateEditMacro.this;
        }
    }

    private class JPanelMacroKeyboard
    extends JPanel {
        private String m_szLanguage = "";
        private Vector m_vKeys = new Vector();

        private JPanelMacroKeyboard(Properties properties) throws ExceptionRequestFailed {
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                if (string.compareToIgnoreCase("language") == 0) {
                    this.m_szLanguage = string2.trim();
                    continue;
                }
                if (string.startsWith("key")) {
                    JButtonMacroKey jButtonMacroKey = new JButtonMacroKey(string2);
                    this.m_vKeys.add(jButtonMacroKey);
                    this.add(jButtonMacroKey);
                    continue;
                }
                if (!string.startsWith("SUNKEYSCOMBO")) continue;
                JDialogCreateEditMacro.this.m_comboBoxSunKeys = new JComboBoxSunKeys(string2);
                this.add(JDialogCreateEditMacro.this.m_comboBoxSunKeys);
            }
            this.setLayout(null);
            this.setVisible(true);
            this.setBounds(0, 0, 577, 143);
            this.setBorder(new EtchedBorder());
            properties.clear();
        }

        private void keyStateChange(boolean bl, int n, int n2) {
            for (int i = 0; i < this.m_vKeys.size(); ++i) {
                ((JButtonMacroKey)this.m_vKeys.get(i)).setState(bl, n, n2);
            }
        }

        static /* synthetic */ void access$1900(JPanelMacroKeyboard jPanelMacroKeyboard, boolean bl, int n, int n2) {
            jPanelMacroKeyboard.keyStateChange(bl, n, n2);
        }
    }

    public class RendererComboBoxIcon
    extends JLabel
    implements ListCellRenderer {
        public RendererComboBoxIcon() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof JLabel) {
                JLabel jLabel = (JLabel)object;
                this.setText(jLabel.getText());
                this.setIcon(jLabel.getIcon());
                this.setBackground(bl ? Color.blue : Color.white);
                this.setForeground(bl ? Color.white : Color.black);
                this.repaint();
            }
            return this;
        }
    }
}

