/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.Help;
import com.avocent.video.JDialogCopy;
import com.avocent.video.JDialogCreateEditMacro;
import com.avocent.video.KeyboardMacro;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JDialogMacros
extends JDialogCentered {
    public static final String CNAME = "JDialogMacros";
    static ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    static String TRACE_CONTEXT = "VideoViewerTrace";
    JPanel panel1 = new JPanel();
    JPanel jPanelDefaultButtons = new JPanel();
    JPanel jPanelComponents = new JPanel();
    JButton jButtonClose = new JButton();
    JButton jButtonHelp = new JButton();
    JPanel jPanelList = new JPanel();
    JPanel jPanelButtons = new JPanel();
    JButton jButtonRun = new JButton();
    JButton jButtonCreate = new JButton();
    JButton jButtonEdit = new JButton();
    JButton jButtonDelete = new JButton();
    JButton jButtonCopy = new JButton();
    JScrollPane jScrollPaneList = new JScrollPane();
    JList jListMacros = new JList();
    DefaultListModel defaultListModelMacros = new DefaultListModel();
    ApplianceSession m_applianceSession;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    JPanel jPanelTopLabel = new JPanel();
    JLabel jLabelDefinedMacros = new JLabel();
    GridBagLayout gridBagLayout6 = new GridBagLayout();
    JPanel jPanel1 = new JPanel();
    boolean m_bChangingListInSeparateThread = false;
    String m_szHelpURL;
    JPanel jPanelView = new JPanel();
    JRadioButton jRadioButtonViewLocal = new JRadioButton();
    JRadioButton jRadioButtonViewAll = new JRadioButton();
    JRadioButton jRadioButtonViewGlobal = new JRadioButton();
    GridBagLayout gridBagLayout7 = new GridBagLayout();
    ButtonGroup buttonGroupView = new ButtonGroup();
    TitledBorder titledBorder2;
    static /* synthetic */ Class class$com$avocent$video$JDialogSessionOptions;

    public JDialogMacros(Frame frame, ApplianceSession applianceSession, String string) {
        super(frame, "", false);
        this.m_applianceSession = applianceSession;
        this.m_szHelpURL = string;
        try {
            this.setResizable(true);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.FillListBoxWithMacros(true, true);
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.jListMacros.requestFocus();
        this.setResizable(false);
    }

    public JDialogMacros(Frame frame, ApplianceSession applianceSession, boolean bl) {
        super(frame, "", false);
        this.m_applianceSession = applianceSession;
        try {
            this.setResizable(true);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.fillMacrosInList();
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.jListMacros.requestFocus();
        this.setResizable(false);
    }

    public JDialogMacros() {
        this(null, null, null);
    }

    void jbInit() throws Exception {
        String string;
        this.titledBorder2 = new TitledBorder(RES.getString("JDialogMacros_View"));
        this.setDefaultCloseOperation(2);
        this.panel1.setLayout(this.gridBagLayout4);
        this.setTitle(RES.getString("JDialogMacros_Macros"));
        this.panel1.setMinimumSize(new Dimension(348, 405));
        this.panel1.setPreferredSize(new Dimension(348, 405));
        this.jPanelDefaultButtons.setLayout(this.gridBagLayout3);
        this.jPanelComponents.setLayout(this.gridBagLayout5);
        this.jButtonClose.setText(RES.getString("JDialogMacros_Close"));
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogMacros.this.jButtonClose_actionPerformed(actionEvent);
            }
        });
        if (this.m_szHelpURL != null && this.m_szHelpURL.length() > 0) {
            string = RES.getString("JDialogMacros_Help_Mnemonic");
            if (string != null && string.length() > 0) {
                this.jButtonHelp.setMnemonic(string.charAt(0));
            }
            this.jButtonHelp.setText(RES.getString("JDialogMacros_Help"));
            this.jButtonHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JDialogMacros.this.jButtonHelp_actionPerformed(actionEvent);
                }
            });
        }
        this.jPanelList.setLayout(this.gridBagLayout1);
        this.jPanelButtons.setLayout(this.gridBagLayout2);
        this.jButtonRun.setEnabled(false);
        string = RES.getString("JDialogMacros_Run_Mnemonic");
        if (string != null && string.length() > 0) {
            this.jButtonRun.setMnemonic(string.charAt(0));
        }
        this.jButtonRun.setText(RES.getString("JDialogMacros_Run"));
        this.jButtonRun.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogMacros.this.jButtonRun_actionPerformed(actionEvent);
            }
        });
        string = RES.getString("JDialogMacros_Create_Mnemonic");
        if (string != null && string.length() > 0) {
            this.jButtonCreate.setMnemonic(string.charAt(0));
        }
        this.jButtonCreate.setText(RES.getString("JDialogMacros_Create_"));
        this.jButtonCreate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogMacros.this.jButtonCreate_actionPerformed(actionEvent);
            }
        });
        this.jButtonEdit.setEnabled(false);
        string = RES.getString("JDialogMacros_Edit_Mnemonic");
        if (string != null && string.length() > 0) {
            this.jButtonEdit.setMnemonic(string.charAt(0));
        }
        this.jButtonEdit.setText(RES.getString("JDialogMacros_Edit"));
        this.jButtonEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogMacros.this.jButtonEdit_actionPerformed(actionEvent);
            }
        });
        this.jButtonDelete.setEnabled(false);
        string = RES.getString("JDialogMacros_Delete_Mnemonic");
        if (string != null && string.length() > 0) {
            this.jButtonDelete.setMnemonic(string.charAt(0));
        }
        this.jButtonDelete.setText(RES.getString("JDialogMacros_Delete"));
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogMacros.this.jButtonDelete_actionPerformed(actionEvent);
            }
        });
        this.jButtonCopy.setEnabled(false);
        string = RES.getString("JDialogMacros_Copy_Mnemonic");
        if (string != null && string.length() > 0) {
            this.jButtonCopy.setMnemonic(string.charAt(0));
        }
        this.jButtonCopy.setText(RES.getString("JDialogMacros_Copy_"));
        this.jButtonCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogMacros.this.jButtonCopy_actionPerformed(actionEvent);
            }
        });
        this.jScrollPaneList.setMinimumSize(new Dimension(100, 160));
        this.jScrollPaneList.setPreferredSize(new Dimension(100, 210));
        this.jListMacros.setModel(this.defaultListModelMacros);
        this.jListMacros.setSelectionMode(0);
        this.jListMacros.setCellRenderer(new RendererListBoxIcon());
        this.jListMacros.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                JDialogMacros.this.jListMacros_valueChanged(listSelectionEvent);
            }
        });
        this.jLabelDefinedMacros.setText(RES.getString("JDialogMacros_Defined_Macros"));
        this.jPanelTopLabel.setLayout(this.gridBagLayout6);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setMinimumSize(new Dimension(14, 2));
        this.jPanel1.setPreferredSize(new Dimension(14, 2));
        this.jPanelView.setLayout(this.gridBagLayout7);
        this.jRadioButtonViewAll.setSelected(true);
        if (this.m_applianceSession.getApplication() == 2) {
            this.jRadioButtonViewAll.setText(RES.getString("JDialogMacros_All_Macros"));
            this.jRadioButtonViewAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JDialogMacros.this.jRadioButtonViewAll_actionPerformed(actionEvent);
                }
            });
            this.jRadioButtonViewLocal.setText(RES.getString("JDialogMacros_Local_Macros"));
            this.jRadioButtonViewLocal.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JDialogMacros.this.jRadioButtonViewLocal_actionPerformed(actionEvent);
                }
            });
            this.jRadioButtonViewGlobal.setText(RES.getString("JDialogMacros_Global_Macros"));
            this.jRadioButtonViewGlobal.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JDialogMacros.this.jRadioButtonViewGlobal_actionPerformed(actionEvent);
                }
            });
            this.jPanelView.setBorder(this.titledBorder2);
        }
        this.getContentPane().add((Component)this.panel1, "Center");
        this.panel1.add((Component)this.jPanelComponents, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this.m_szHelpURL != null && this.m_szHelpURL.length() > 0) {
            this.jPanelDefaultButtons.add((Component)this.jButtonHelp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 12, 11, 11), 0, 0));
            this.jPanelDefaultButtons.add((Component)this.jButtonClose, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 13, 0, new Insets(12, 12, 11, 0), 0, 0));
        } else {
            this.jPanelDefaultButtons.add((Component)this.jButtonClose, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 13, 0, new Insets(12, 12, 11, 11), 0, 0));
        }
        this.panel1.add((Component)this.jPanel1, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 12, 0, 11), 0, 0));
        this.jPanelComponents.add((Component)this.jPanelList, new GridBagConstraints(1, 1, 1, 2, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonCopy, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 0, 0, 0), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonDelete, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 0, 0, 0), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonEdit, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 0, 0, 0), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonCreate, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 0, 0, 0), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonRun, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelComponents.add((Component)this.jPanelView, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(6, 0, 0, 0), 0, 0));
        if (this.m_applianceSession.getApplication() == 2) {
            this.jPanelView.add((Component)this.jRadioButtonViewAll, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 1, 0, 0), 0, 0));
            this.jPanelView.add((Component)this.jRadioButtonViewLocal, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 1, 0, 0), 0, 0));
            this.jPanelView.add((Component)this.jRadioButtonViewGlobal, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 1, 0, 0), 0, 0));
        }
        this.jPanelComponents.add((Component)this.jPanelTopLabel, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelTopLabel.add((Component)this.jLabelDefinedMacros, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(12, 12, 0, 0), 0, 0));
        this.panel1.add((Component)this.jPanelDefaultButtons, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelList.add((Component)this.jScrollPaneList, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 12, 0, 0), 0, 0));
        this.jScrollPaneList.getViewport().add((Component)this.jListMacros, null);
        this.jPanelComponents.add((Component)this.jPanelButtons, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 12, 0, 11), 0, 0));
        this.buttonGroupView.add(this.jRadioButtonViewAll);
        this.buttonGroupView.add(this.jRadioButtonViewLocal);
        this.buttonGroupView.add(this.jRadioButtonViewGlobal);
    }

    void jButtonRun_actionPerformed(ActionEvent actionEvent) {
        KeyboardMacro keyboardMacro;
        int n = this.jListMacros.getSelectedIndex();
        if (n >= 0 && (keyboardMacro = (KeyboardMacro)this.defaultListModelMacros.get(n)) != null) {
            this.m_applianceSession.cmdSendMacroKeystrokes(keyboardMacro);
        }
    }

    void jButtonCreate_actionPerformed(ActionEvent actionEvent) {
        JDialogCreateEditMacro jDialogCreateEditMacro = new JDialogCreateEditMacro((Frame)this.getParent(), this.m_applianceSession, null, this.m_szHelpURL);
        jDialogCreateEditMacro.setModal(true);
        jDialogCreateEditMacro.setVisible(true);
        if (jDialogCreateEditMacro.wasOkPressed()) {
            this.defaultListModelMacros.addElement(jDialogCreateEditMacro.getMacro());
            if (jDialogCreateEditMacro.getMacro().isGlobalMacro()) {
                this.m_applianceSession.logEventMacro(32, jDialogCreateEditMacro.getMacro().getName(), jDialogCreateEditMacro.getMacro().getID());
            }
        }
    }

    void jButtonEdit_actionPerformed(ActionEvent actionEvent) {
        int n = this.jListMacros.getSelectedIndex();
        if (n >= 0) {
            KeyboardMacro keyboardMacro = (KeyboardMacro)this.defaultListModelMacros.get(n);
            JDialogCreateEditMacro jDialogCreateEditMacro = new JDialogCreateEditMacro((Frame)this.getParent(), this.m_applianceSession, keyboardMacro, this.m_szHelpURL);
            jDialogCreateEditMacro.setModal(true);
            jDialogCreateEditMacro.setVisible(true);
            if (jDialogCreateEditMacro.wasOkPressed()) {
                ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
                KeyboardMacro keyboardMacro2 = (KeyboardMacro)this.defaultListModelMacros.get(n);
                this.defaultListModelMacros.remove(n);
                keyboardMacro2 = applianceSessionInfo.getMacro(keyboardMacro2.getID());
                this.defaultListModelMacros.add(n, keyboardMacro2);
                this.jListMacros.setSelectedIndex(n);
                if (keyboardMacro2.isGlobalMacro()) {
                    this.m_applianceSession.logEventMacro(33, keyboardMacro2.getName(), keyboardMacro2.getID());
                }
            }
        }
    }

    void jButtonCopy_actionPerformed(ActionEvent actionEvent) {
        int n = this.jListMacros.getSelectedIndex();
        if (n >= 0) {
            KeyboardMacro keyboardMacro = (KeyboardMacro)this.jListMacros.getSelectedValue();
            JDialogCopy jDialogCopy = new JDialogCopy((Frame)this.getParent(), keyboardMacro, this.m_applianceSession, this.m_szHelpURL);
            jDialogCopy.setModal(true);
            jDialogCopy.setVisible(true);
            if (jDialogCopy.wasOkPressed()) {
                this.fillMacrosInList();
            }
        }
    }

    void jButtonDelete_actionPerformed(ActionEvent actionEvent) {
        final int n = this.jListMacros.getSelectedIndex();
        if (n >= 0) {
            Object[] objectArray = new Object[]{((KeyboardMacro)this.defaultListModelMacros.get(n)).getName()};
            String string = MessageFormat.format(RES.getString("JDialogMacros_Delete_Confirm"), objectArray);
            int n2 = JOptionPane.showConfirmDialog((Component)((Object)this), string, RES.getString("JDialogMacros_Delete_Macro_Title"), 0, 3);
            if (n2 == 0) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.setButtonState();
                this.m_bChangingListInSeparateThread = true;
                Thread thread = new Thread(new Runnable(){

                    public void run() {
                        ApplianceSessionInfo applianceSessionInfo = JDialogMacros.this.m_applianceSession.getPersistentDataReference();
                        KeyboardMacro keyboardMacro = (KeyboardMacro)JDialogMacros.this.defaultListModelMacros.get(n);
                        applianceSessionInfo.removeMacro(keyboardMacro);
                        JDialogMacros.this.defaultListModelMacros.remove(n);
                        JDialogMacros.this.jListMacros.setSelectedIndex(n);
                        JDialogMacros.this.m_applianceSession.setPersistentData(applianceSessionInfo);
                        if (keyboardMacro.isGlobalMacro()) {
                            JDialogMacros.this.m_applianceSession.logEventMacro(34, keyboardMacro.getName(), keyboardMacro.getID());
                        }
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 12 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                12.access$000(this.this$1).setButtonState();
                                12.access$000(this.this$1).m_bChangingListInSeparateThread = false;
                                12.access$000(this.this$1).setCursor(Cursor.getPredefinedCursor(0));
                            }
                        });
                    }

                    static /* synthetic */ JDialogMacros access$000(12 var0) {
                        return var0.JDialogMacros.this;
                    }
                });
                thread.start();
            }
        }
    }

    void jButtonClose_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    void jButtonHelp_actionPerformed(ActionEvent actionEvent) {
        Help.launchHelp(this.m_szHelpURL, "IDH_MACROS");
    }

    void jListMacros_valueChanged(ListSelectionEvent listSelectionEvent) {
        if (!this.m_bChangingListInSeparateThread) {
            this.setButtonState();
        }
    }

    void jRadioButtonViewLocal_actionPerformed(ActionEvent actionEvent) {
        this.FillListBoxWithMacros(true, false);
    }

    void jRadioButtonViewAll_actionPerformed(ActionEvent actionEvent) {
        this.FillListBoxWithMacros(true, true);
    }

    void jRadioButtonViewGlobal_actionPerformed(ActionEvent actionEvent) {
        this.FillListBoxWithMacros(false, true);
    }

    private void FillListBoxWithMacros(boolean bl, boolean bl2) {
        this.defaultListModelMacros.clear();
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        KeyboardMacro[] keyboardMacroArray = applianceSessionInfo.getMacros(bl, bl2);
        for (int i = 0; i < keyboardMacroArray.length; ++i) {
            this.defaultListModelMacros.addElement(keyboardMacroArray[i]);
        }
    }

    void setButtonState() {
        if (this.jListMacros.getSelectedIndex() >= 0 && this.jListMacros.getSelectedIndex() < this.defaultListModelMacros.size()) {
            KeyboardMacro keyboardMacro = (KeyboardMacro)this.defaultListModelMacros.get(this.jListMacros.getSelectedIndex());
            if (!keyboardMacro.isGlobalMacro()) {
                this.jButtonRun.setEnabled(!this.m_applianceSession.isStealthConnection() && !this.m_applianceSession.isPassiveConnection());
                this.jButtonEdit.setEnabled(true);
                this.jButtonDelete.setEnabled(true);
                this.jButtonCopy.setEnabled(true);
            } else {
                this.jButtonRun.setEnabled(!this.m_applianceSession.isStealthConnection() && !this.m_applianceSession.isPassiveConnection());
                this.jButtonEdit.setEnabled(this.m_applianceSession.canUserEditGlobals());
                this.jButtonDelete.setEnabled(this.m_applianceSession.canUserEditGlobals());
                this.jButtonCopy.setEnabled(true);
            }
        } else {
            this.jButtonRun.setEnabled(false);
            this.jButtonEdit.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
            this.jButtonCopy.setEnabled(false);
        }
    }

    private void fillMacrosInList() {
        this.defaultListModelMacros.removeAllElements();
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
        KeyboardMacro[] keyboardMacroArray = applianceSessionInfo.getMacros(true, true);
        for (int i = 0; i < keyboardMacroArray.length; ++i) {
            this.defaultListModelMacros.addElement(keyboardMacroArray[i]);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class RendererListBoxIcon
    extends JLabel
    implements ListCellRenderer {
        public RendererListBoxIcon() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof KeyboardMacro) {
                JLabel jLabel;
                KeyboardMacro keyboardMacro = (KeyboardMacro)object;
                if (JDialogMacros.this.m_applianceSession.getApplication() != 1) {
                    ImageIcon imageIcon = null;
                    if (keyboardMacro.isGlobalMacro()) {
                        try {
                            imageIcon = new ImageIcon((class$com$avocent$video$JDialogSessionOptions == null ? (class$com$avocent$video$JDialogSessionOptions = JDialogMacros.class$("com.avocent.video.JDialogSessionOptions")) : class$com$avocent$video$JDialogSessionOptions).getResource("images/global.gif"));
                        }
                        catch (NullPointerException nullPointerException) {
                            Trace.logError((String)TRACE_CONTEXT, (String)nullPointerException.getMessage(), (Throwable)nullPointerException);
                        }
                    } else {
                        try {
                            imageIcon = new ImageIcon((class$com$avocent$video$JDialogSessionOptions == null ? (class$com$avocent$video$JDialogSessionOptions = JDialogMacros.class$("com.avocent.video.JDialogSessionOptions")) : class$com$avocent$video$JDialogSessionOptions).getResource("images/personal.gif"));
                        }
                        catch (NullPointerException nullPointerException) {
                            Trace.logError((String)TRACE_CONTEXT, (String)nullPointerException.getMessage(), (Throwable)nullPointerException);
                        }
                    }
                    jLabel = new JLabel(keyboardMacro.getName(), imageIcon, 2);
                } else {
                    jLabel = new JLabel(keyboardMacro.getName());
                }
                jLabel.setOpaque(true);
                jLabel.setBackground(bl ? Color.blue : Color.white);
                jLabel.setForeground(bl ? Color.white : Color.black);
                return jLabel;
            }
            return null;
        }
    }
}

