/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.ApplianceSession;
import com.avocent.video.Help;
import com.avocent.video.Win32Library;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicSliderUI;
import javax.swing.plaf.metal.MetalSliderUI;

public class JDialogManualVideoAdjust
extends JDialogCentered
implements WindowListener {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    private static int HORIZONTAL_POSITION_OFFSET = 3700;
    private static int VERTICAL_POSITION_OFFSET = 10;
    private static int FINE_DIVISOR = 8;
    public static final String CNAME = "JDialogManualVideoAdjust";
    static ResourceManager res = ResourceManager.getManager((String)"com.avocent.video.Res");
    ApplianceSession m_applianceSession;
    JPanel panel1 = new JPanel();
    JPanel jPanelImageAdjust = new JPanel();
    JPanel jPanelImageUpdate = new JPanel();
    JPanel jPanelPerformance = new JPanel();
    JPanel jPanelDefaultButtons = new JPanel();
    JToggleButton jButtonImageCaptureWidth = new JToggleButton();
    JToggleButton jButtonImageFine = new JToggleButton();
    JToggleButton jButtonImageCaptureHorz = new JToggleButton();
    JToggleButton jButtonImageCaptureVert = new JToggleButton();
    JToggleButton jButtonContrast = new JToggleButton();
    JToggleButton jButtonBrightness = new JToggleButton();
    JToggleButton jButtonNoiseThreshold = new JToggleButton();
    JToggleButton jButtonPriorityThreshold = new JToggleButton();
    JSlider jSliderVideo = new JSlider();
    JLabel jLabelSliderTop = new JLabel();
    JLabel jLabelSliderRight = new JLabel();
    JLabel jLabelSliderLeft = new JLabel();
    JPanel jPanelSlider = new JPanel();
    JButton jButtonAutoVideoAdjust = new JButton();
    JButton jButtonRefreshImage = new JButton();
    JToggleButton jToggleButtonVideoTestPattern = new JToggleButton();
    JProgressBar jProgressBarPerformanceMonitor = new JProgressBar();
    JLabel jLabelPerformanceValue = new JLabel();
    JLabel jLabelPerforamnceUnits = new JLabel();
    JLabel jLabelPerformanceMonitor = new JLabel();
    JButton jButtonHelp = new JButton();
    JButton jButtonClose = new JButton();
    JLabel jLabelSliderValue = new JLabel();
    JToggleButton jButtonSelected = new JToggleButton();
    int m_nBrightness = 0;
    int m_nContrast = 0;
    int m_nHorzPosition = 0;
    int m_nVertPosition = 0;
    int m_nWidth = 0;
    int m_nFine = 0;
    int m_nHorzResolution = 0;
    int m_nVertResolution = 0;
    int m_nNoiseThreshold = 0;
    int m_nPriorityThreshold = 0;
    boolean m_bVideoSetupDataReceived = false;
    boolean m_bChangingSliderParameters = false;
    boolean m_bSliderValueChanged = false;
    VideoAdjustSliderUI m_videoAdjustSliderUI;
    JButton jButtonIncrement = new JButton();
    JButton jButtonDecrement = new JButton();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    GridBagLayout gridBagLayout6 = new GridBagLayout();
    String m_szHelpURL;
    private Win32Library m_libWin32;
    static /* synthetic */ Class class$com$avocent$video$JDialogManualVideoAdjust;

    public JDialogManualVideoAdjust(Frame frame, ApplianceSession applianceSession, String string) {
        super(frame, "", false);
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JDialogManualVideoAdjust constructor)");
        try {
            this.m_libWin32 = new Win32Library();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        this.m_applianceSession = applianceSession;
        this.m_szHelpURL = string;
        try {
            this.setResizable(true);
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.jProgressBarPerformanceMonitor.setMinimum(0);
        this.jProgressBarPerformanceMonitor.setMaximum(this.m_applianceSession.getVideoEncodingType() == 2 ? 250 : 5000);
        this.jLabelPerformanceValue.setText("0");
        this.setDefaultCloseOperation(1);
        this.addWindowListener(this);
        this.getRootPane().setDefaultButton(this.jButtonClose);
        this.jSliderVideo.requestFocus();
        this.setResizable(false);
    }

    public JDialogManualVideoAdjust() {
        this(null, null, null);
    }

    void initDialogManualVideoAdjust() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JDialogManualVideoAdjust initDialogManualVideoAdjust)");
        this.m_bVideoSetupDataReceived = false;
        try {
            this.m_applianceSession.cmdVideoSetup();
            int n = 0;
            while (!this.m_bVideoSetupDataReceived && n++ < 50) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.jButtonContrast.setSelected(true);
        this.jButtonContrast_actionPerformed(null);
        new PerformanceMonitorThread(this.m_applianceSession.getTotalVideoPacketsReceived());
        new ThreadChangeVideoValue();
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout6);
        this.setTitle(res.getString("JDialogManualVideoAdjust_Manual_Video_Adjust"));
        this.jPanelImageAdjust.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelImageAdjust.setLayout(this.gridBagLayout5);
        this.jPanelImageUpdate.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelImageUpdate.setLayout(this.gridBagLayout2);
        this.jPanelPerformance.setBorder(BorderFactory.createEtchedBorder());
        this.jPanelPerformance.setLayout(this.gridBagLayout3);
        this.jPanelDefaultButtons.setLayout(this.gridBagLayout1);
        this.jButtonImageCaptureWidth.setToolTipText(res.getString("JDialogManualVideoAdjust_Image_Capture_Width"));
        this.jButtonImageCaptureWidth.setIcon(new ImageIcon((class$com$avocent$video$JDialogManualVideoAdjust == null ? (class$com$avocent$video$JDialogManualVideoAdjust = JDialogManualVideoAdjust.class$("com.avocent.video.JDialogManualVideoAdjust")) : class$com$avocent$video$JDialogManualVideoAdjust).getResource("images/capturewidth24.gif")));
        this.jButtonImageCaptureWidth.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonImageCaptureWidth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonImageCaptureWidth_actionPerformed(actionEvent);
            }
        });
        this.jButtonImageCaptureWidth.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonImageCaptureWidth_actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.jButtonImageFine.setToolTipText(res.getString("JDialogManualVideoAdjust_Image_Capture_Fine"));
        this.jButtonImageFine.setIcon(new ImageIcon((class$com$avocent$video$JDialogManualVideoAdjust == null ? (class$com$avocent$video$JDialogManualVideoAdjust = JDialogManualVideoAdjust.class$("com.avocent.video.JDialogManualVideoAdjust")) : class$com$avocent$video$JDialogManualVideoAdjust).getResource("images/fineadjust24.gif")));
        this.jButtonImageFine.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonImageFine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonImageFine_actionPerformed(actionEvent);
            }
        });
        this.jButtonImageFine.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonImageFine_actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.jButtonImageCaptureHorz.setToolTipText(res.getString("JDialogManualVideoAdjust_Image_Capture_Horz"));
        this.jButtonImageCaptureHorz.setIcon(new ImageIcon((class$com$avocent$video$JDialogManualVideoAdjust == null ? (class$com$avocent$video$JDialogManualVideoAdjust = JDialogManualVideoAdjust.class$("com.avocent.video.JDialogManualVideoAdjust")) : class$com$avocent$video$JDialogManualVideoAdjust).getResource("images/horizontalposition24.gif")));
        this.jButtonImageCaptureHorz.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonImageCaptureHorz.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonImageCaptureHorz_actionPerformed(actionEvent);
            }
        });
        this.jButtonImageCaptureHorz.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonImageCaptureHorz_actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.jButtonImageCaptureVert.setToolTipText(res.getString("JDialogManualVideoAdjust_Image_Capture_Vert"));
        this.jButtonImageCaptureVert.setIcon(new ImageIcon((class$com$avocent$video$JDialogManualVideoAdjust == null ? (class$com$avocent$video$JDialogManualVideoAdjust = JDialogManualVideoAdjust.class$("com.avocent.video.JDialogManualVideoAdjust")) : class$com$avocent$video$JDialogManualVideoAdjust).getResource("images/verticalposition24.gif")));
        this.jButtonImageCaptureVert.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonImageCaptureVert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonImageCaptureVert_actionPerformed(actionEvent);
            }
        });
        this.jButtonImageCaptureVert.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonImageCaptureVert_actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.jButtonContrast.setToolTipText(res.getString("JDialogManualVideoAdjust_Contrast"));
        this.jButtonContrast.setIcon(new ImageIcon((class$com$avocent$video$JDialogManualVideoAdjust == null ? (class$com$avocent$video$JDialogManualVideoAdjust = JDialogManualVideoAdjust.class$("com.avocent.video.JDialogManualVideoAdjust")) : class$com$avocent$video$JDialogManualVideoAdjust).getResource("images/contrast24.gif")));
        this.jButtonContrast.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonContrast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonContrast_actionPerformed(actionEvent);
            }
        });
        this.jButtonContrast.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonContrast_actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.jButtonBrightness.setToolTipText(res.getString("JDialogManualVideoAdjust_Brightness"));
        this.jButtonBrightness.setIcon(new ImageIcon((class$com$avocent$video$JDialogManualVideoAdjust == null ? (class$com$avocent$video$JDialogManualVideoAdjust = JDialogManualVideoAdjust.class$("com.avocent.video.JDialogManualVideoAdjust")) : class$com$avocent$video$JDialogManualVideoAdjust).getResource("images/brightness24.gif")));
        this.jButtonBrightness.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonBrightness.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonBrightness_actionPerformed(actionEvent);
            }
        });
        this.jButtonBrightness.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonBrightness_actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        if (this.m_applianceSession.getVideoEncodingType() == 1) {
            this.jButtonNoiseThreshold.setToolTipText(res.getString("JDialogManualVideoAdjust_Noise_Threshold"));
        } else {
            this.jButtonNoiseThreshold.setToolTipText(res.getString("JDialogManualVideoAdjust_Block_Noise_Threshold"));
        }
        this.jButtonNoiseThreshold.setIcon(new ImageIcon((class$com$avocent$video$JDialogManualVideoAdjust == null ? (class$com$avocent$video$JDialogManualVideoAdjust = JDialogManualVideoAdjust.class$("com.avocent.video.JDialogManualVideoAdjust")) : class$com$avocent$video$JDialogManualVideoAdjust).getResource("images/noisethreshold24.gif")));
        this.jButtonNoiseThreshold.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonNoiseThreshold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonNoiseThreshold_actionPerformed(actionEvent);
            }
        });
        this.jButtonNoiseThreshold.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonNoiseThreshold_actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        if (this.m_applianceSession.getVideoEncodingType() == 1) {
            this.jButtonPriorityThreshold.setToolTipText(res.getString("JDialogManualVideoAdjust_Priority_Threshold"));
        } else {
            this.jButtonPriorityThreshold.setToolTipText(res.getString("JDialogManualVideoAdjust_Pixel_Noise_Threshold"));
        }
        this.jButtonPriorityThreshold.setIcon(new ImageIcon((class$com$avocent$video$JDialogManualVideoAdjust == null ? (class$com$avocent$video$JDialogManualVideoAdjust = JDialogManualVideoAdjust.class$("com.avocent.video.JDialogManualVideoAdjust")) : class$com$avocent$video$JDialogManualVideoAdjust).getResource("images/prioritythreshold24.gif")));
        this.jButtonPriorityThreshold.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonPriorityThreshold.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonPriorityThreshold_actionPerformed(actionEvent);
            }
        });
        this.jButtonPriorityThreshold.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonPriorityThreshold_actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("SliderUI:" + this.jSliderVideo.getUI()));
        if (this.jSliderVideo.getUI() instanceof MetalSliderUI) {
            this.m_videoAdjustSliderUI = new VideoAdjustSliderUI(this.jSliderVideo);
            this.m_videoAdjustSliderUI.installUI(this.jSliderVideo);
        }
        this.jSliderVideo.setMajorTickSpacing(10);
        this.jSliderVideo.setMinorTickSpacing(5);
        this.jSliderVideo.setPaintTicks(true);
        this.jSliderVideo.setPaintLabels(false);
        this.jSliderVideo.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JDialogManualVideoAdjust.this.jSliderVideo_stateChanged(changeEvent);
            }
        });
        this.jLabelSliderValue.setHorizontalAlignment(0);
        this.jLabelSliderValue.setHorizontalTextPosition(0);
        this.jLabelSliderValue.setText("jLabel1");
        this.jLabelSliderValue.setVerticalAlignment(1);
        this.jLabelSliderValue.setVerticalTextPosition(1);
        this.jLabelSliderTop.setHorizontalAlignment(0);
        this.jLabelSliderTop.setHorizontalTextPosition(0);
        this.jLabelSliderTop.setText("jLabel1");
        this.jLabelSliderRight.setHorizontalTextPosition(2);
        this.jLabelSliderRight.setText("jLabel2");
        this.jLabelSliderLeft.setHorizontalAlignment(4);
        this.jLabelSliderLeft.setHorizontalTextPosition(4);
        this.jLabelSliderLeft.setText("jLabel3");
        this.jPanelSlider.setLayout(this.gridBagLayout4);
        this.jButtonAutoVideoAdjust.setToolTipText(res.getString("JDialogManualVideoAdjust_Automatic_Video_Adjustment"));
        this.jButtonAutoVideoAdjust.setIcon(new ImageIcon((class$com$avocent$video$JDialogManualVideoAdjust == null ? (class$com$avocent$video$JDialogManualVideoAdjust = JDialogManualVideoAdjust.class$("com.avocent.video.JDialogManualVideoAdjust")) : class$com$avocent$video$JDialogManualVideoAdjust).getResource("images/autoadjust24.gif")));
        this.jButtonAutoVideoAdjust.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonAutoVideoAdjust.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonAutoVideoAdjust_actionPerformed(actionEvent);
            }
        });
        this.jButtonRefreshImage.setToolTipText(res.getString("JDialogManualVideoAdjust_Refresh_Image"));
        this.jButtonRefreshImage.setIcon(new ImageIcon((class$com$avocent$video$JDialogManualVideoAdjust == null ? (class$com$avocent$video$JDialogManualVideoAdjust = JDialogManualVideoAdjust.class$("com.avocent.video.JDialogManualVideoAdjust")) : class$com$avocent$video$JDialogManualVideoAdjust).getResource("images/refreshscreen24.gif")));
        this.jButtonRefreshImage.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonRefreshImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonRefreshImage_actionPerformed(actionEvent);
            }
        });
        this.jToggleButtonVideoTestPattern.setToolTipText(res.getString("JDialogManualVideoAdjust_Video_Test_Pattern"));
        this.jToggleButtonVideoTestPattern.setIcon(new ImageIcon((class$com$avocent$video$JDialogManualVideoAdjust == null ? (class$com$avocent$video$JDialogManualVideoAdjust = JDialogManualVideoAdjust.class$("com.avocent.video.JDialogManualVideoAdjust")) : class$com$avocent$video$JDialogManualVideoAdjust).getResource("images/testpattern24.gif")));
        this.jToggleButtonVideoTestPattern.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButtonVideoTestPattern.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jToggleButtonVideoTestPattern_actionPerformed(actionEvent);
            }
        });
        this.jToggleButtonVideoTestPattern.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jToggleButtonVideoTestPattern_actionPerformed_byKeystroke(actionEvent);
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        this.jLabelPerformanceMonitor.setHorizontalAlignment(0);
        this.jLabelPerformanceMonitor.setHorizontalTextPosition(0);
        this.jLabelPerformanceMonitor.setText(res.getString("JDialogManualVideoAdjust_Performance_Monitor"));
        this.jLabelPerformanceValue.setMinimumSize(new Dimension(30, 20));
        this.jLabelPerformanceValue.setMaximumSize(new Dimension(30, 20));
        this.jLabelPerformanceValue.setPreferredSize(new Dimension(30, 20));
        this.jLabelPerformanceValue.setVerticalAlignment(0);
        this.jLabelPerformanceValue.setHorizontalTextPosition(4);
        this.jLabelPerformanceValue.setHorizontalAlignment(4);
        this.jLabelPerforamnceUnits.setText(res.getString("JDialogManualVideoAdjust_Performance_Monitor_Units"));
        this.jLabelPerforamnceUnits.setVerticalAlignment(0);
        if (this.m_szHelpURL != null && this.m_szHelpURL.length() > 0) {
            String string = res.getString("JDialogManualVideoAdjust_Help_Mnemonic");
            if (string != null && string.length() > 0) {
                this.jButtonHelp.setMnemonic(string.charAt(0));
            }
            this.jButtonHelp.setText(res.getString("JDialogManualVideoAdjust_Help"));
            this.jButtonHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JDialogManualVideoAdjust.this.jButtonHelp_actionPerformed(actionEvent);
                }
            });
        }
        this.jButtonClose.setText(res.getString("JDialogManualVideoAdjust_Close"));
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonClose_actionPerformed(actionEvent);
            }
        });
        this.panel1.setBounds(new Rectangle(-1, 1, 502, 295));
        this.jButtonIncrement.setToolTipText(res.getString("JDialogManualVideoAdjust_Increment_Button_Tooltip"));
        this.jButtonIncrement.setMargin(new Insets(0, 2, 0, 2));
        this.jButtonIncrement.setText(res.getString("JDialogManualVideoAdjust_Increment_Button_Symbol"));
        this.jButtonIncrement.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonIncrement_actionPerformed(actionEvent);
            }
        });
        this.jButtonDecrement.setToolTipText(res.getString("JDialogManualVideoAdjust_Decrement_Button_Tooltip"));
        this.jButtonDecrement.setMargin(new Insets(0, 2, 0, 2));
        this.jButtonDecrement.setText(res.getString("JDialogManualVideoAdjust_Decrement_Button_Symbol"));
        this.jButtonDecrement.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogManualVideoAdjust.this.jButtonDecrement_actionPerformed(actionEvent);
            }
        });
        this.jPanelSlider.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add((Component)this.panel1, "Center");
        this.panel1.add((Component)this.jPanelImageAdjust, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(12, 12, 0, 0), 0, 0));
        this.panel1.add((Component)this.jPanelImageUpdate, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(12, 12, 0, 11), 0, 0));
        this.panel1.add((Component)this.jPanelDefaultButtons, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(12, 12, 11, 11), 0, 0));
        this.jPanelDefaultButtons.add((Component)this.jButtonClose, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 0, 0, 0), 0, 0));
        if (this.m_szHelpURL != null && this.m_szHelpURL.length() > 0) {
            this.jPanelDefaultButtons.add((Component)this.jButtonHelp, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.panel1.add((Component)this.jPanelPerformance, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(12, 12, 11, 0), 0, 0));
        this.jPanelImageAdjust.add((Component)this.jPanelSlider, new GridBagConstraints(0, 1, 8, 1, 0.0, 0.5, 11, 1, new Insets(12, 12, 11, 11), 0, 0));
        this.jPanelSlider.add((Component)this.jSliderVideo, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.5, 11, 1, new Insets(0, 11, 0, 11), 0, 0));
        this.jPanelSlider.add((Component)this.jLabelSliderValue, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelSlider.add((Component)this.jLabelSliderTop, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.jPanelSlider.add((Component)this.jLabelSliderRight, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelSlider.add((Component)this.jButtonIncrement, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 11, 11), 0, 0));
        this.jPanelSlider.add((Component)this.jLabelSliderLeft, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelSlider.add((Component)this.jButtonDecrement, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 12, 0, new Insets(0, 10, 10, 0), 0, 0));
        this.jPanelImageAdjust.add((Component)this.jButtonPriorityThreshold, new GridBagConstraints(7, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.jPanelImageAdjust.add((Component)this.jButtonNoiseThreshold, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanelImageAdjust.add((Component)this.jButtonBrightness, new GridBagConstraints(5, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanelImageAdjust.add((Component)this.jButtonContrast, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanelImageAdjust.add((Component)this.jButtonImageCaptureVert, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanelImageAdjust.add((Component)this.jButtonImageCaptureHorz, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanelImageAdjust.add((Component)this.jButtonImageFine, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanelImageAdjust.add((Component)this.jButtonImageCaptureWidth, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 13, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.jPanelImageUpdate.add((Component)this.jButtonAutoVideoAdjust, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelImageUpdate.add((Component)this.jButtonRefreshImage, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelImageUpdate.add((Component)this.jToggleButtonVideoTestPattern, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.5, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelPerformance.add((Component)this.jLabelPerformanceMonitor, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelPerformance.add((Component)this.jProgressBarPerformanceMonitor, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(0, 12, 0, 11), 0, 0));
        this.jPanelPerformance.add((Component)this.jLabelPerformanceValue, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(0, 5, 1, 3), 0, 0));
        this.jPanelPerformance.add((Component)this.jLabelPerforamnceUnits, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 3, 0, 0), 0, 0));
    }

    void jButtonImageCaptureWidth_actionPerformed(ActionEvent actionEvent) {
        this.changingSliderParameters(true);
        this.waitForPendingSliderValueChangeToClear();
        this.jButtonImageCaptureWidth.setSelected(true);
        this.jButtonSelected = this.jButtonImageCaptureWidth;
        this.jButtonImageFine.setSelected(false);
        this.jButtonImageCaptureHorz.setSelected(false);
        this.jButtonImageCaptureVert.setSelected(false);
        this.jButtonContrast.setSelected(false);
        this.jButtonBrightness.setSelected(false);
        this.jButtonNoiseThreshold.setSelected(false);
        this.jButtonPriorityThreshold.setSelected(false);
        this.jLabelSliderLeft.setText(res.getString("JDialogManualVideoAdjust_Narrower"));
        this.jLabelSliderRight.setText(res.getString("JDialogManualVideoAdjust_Width"));
        this.jLabelSliderTop.setText(res.getString("JDialogManualVideoAdjust_Image_Capture_Width"));
        this.setSliderParams(0, 4095, 409, 409, this.m_nWidth);
        this.changingSliderParameters(false);
    }

    void jButtonImageFine_actionPerformed(ActionEvent actionEvent) {
        this.changingSliderParameters(true);
        this.waitForPendingSliderValueChangeToClear();
        this.jButtonImageCaptureWidth.setSelected(false);
        this.jButtonImageFine.setSelected(true);
        this.jButtonSelected = this.jButtonImageFine;
        this.jButtonImageCaptureHorz.setSelected(false);
        this.jButtonImageCaptureVert.setSelected(false);
        this.jButtonContrast.setSelected(false);
        this.jButtonBrightness.setSelected(false);
        this.jButtonNoiseThreshold.setSelected(false);
        this.jButtonPriorityThreshold.setSelected(false);
        this.jLabelSliderLeft.setText(res.getString("JDialogManualVideoAdjust_Earlier"));
        this.jLabelSliderRight.setText(res.getString("JDialogManualVideoAdjust_Later"));
        this.jLabelSliderTop.setText(res.getString("JDialogManualVideoAdjust_Image_Capture_Fine"));
        this.setSliderParams(0, 30, 3, 3, this.m_nFine / FINE_DIVISOR);
        this.changingSliderParameters(false);
    }

    void jButtonImageCaptureHorz_actionPerformed(ActionEvent actionEvent) {
        this.changingSliderParameters(true);
        this.waitForPendingSliderValueChangeToClear();
        this.jButtonImageCaptureWidth.setSelected(false);
        this.jButtonImageFine.setSelected(false);
        this.jButtonImageCaptureHorz.setSelected(true);
        this.jButtonSelected = this.jButtonImageCaptureHorz;
        this.jButtonImageCaptureVert.setSelected(false);
        this.jButtonContrast.setSelected(false);
        this.jButtonBrightness.setSelected(false);
        this.jButtonNoiseThreshold.setSelected(false);
        this.jButtonPriorityThreshold.setSelected(false);
        this.jLabelSliderLeft.setText(res.getString("JDialogManualVideoAdjust_Left"));
        this.jLabelSliderRight.setText(res.getString("JDialogManualVideoAdjust_Right"));
        this.jLabelSliderTop.setText(res.getString("JDialogManualVideoAdjust_Image_Capture_Horz"));
        this.setSliderParams(0, 400, 40, 40, this.m_nHorzPosition - HORIZONTAL_POSITION_OFFSET);
        this.changingSliderParameters(false);
    }

    void jButtonImageCaptureVert_actionPerformed(ActionEvent actionEvent) {
        this.changingSliderParameters(true);
        this.waitForPendingSliderValueChangeToClear();
        this.jButtonImageCaptureWidth.setSelected(false);
        this.jButtonImageFine.setSelected(false);
        this.jButtonImageCaptureHorz.setSelected(false);
        this.jButtonImageCaptureVert.setSelected(true);
        this.jButtonSelected = this.jButtonImageCaptureVert;
        this.jButtonContrast.setSelected(false);
        this.jButtonBrightness.setSelected(false);
        this.jButtonNoiseThreshold.setSelected(false);
        this.jButtonPriorityThreshold.setSelected(false);
        this.jLabelSliderLeft.setText(res.getString("JDialogManualVideoAdjust_Down"));
        this.jLabelSliderRight.setText(res.getString("JDialogManualVideoAdjust_Up"));
        this.jLabelSliderTop.setText(res.getString("JDialogManualVideoAdjust_Image_Capture_Vert"));
        this.setSliderParams(0, 40, 4, 4, this.m_nVertPosition - VERTICAL_POSITION_OFFSET);
        this.changingSliderParameters(false);
    }

    void jButtonContrast_actionPerformed(ActionEvent actionEvent) {
        this.changingSliderParameters(true);
        this.waitForPendingSliderValueChangeToClear();
        this.jButtonImageCaptureWidth.setSelected(false);
        this.jButtonImageFine.setSelected(false);
        this.jButtonImageCaptureHorz.setSelected(false);
        this.jButtonImageCaptureVert.setSelected(false);
        this.jButtonContrast.setSelected(true);
        this.jButtonSelected = this.jButtonContrast;
        this.jButtonBrightness.setSelected(false);
        this.jButtonNoiseThreshold.setSelected(false);
        this.jButtonPriorityThreshold.setSelected(false);
        this.jLabelSliderLeft.setText(res.getString("JDialogManualVideoAdjust_Min"));
        this.jLabelSliderRight.setText(res.getString("JDialogManualVideoAdjust_Max"));
        this.jLabelSliderTop.setText(res.getString("JDialogManualVideoAdjust_Contrast"));
        this.setSliderParams(0, 255, 25, 25, this.m_nContrast);
        this.changingSliderParameters(false);
    }

    void jButtonBrightness_actionPerformed(ActionEvent actionEvent) {
        this.changingSliderParameters(true);
        this.waitForPendingSliderValueChangeToClear();
        this.jButtonImageCaptureWidth.setSelected(false);
        this.jButtonImageFine.setSelected(false);
        this.jButtonImageCaptureHorz.setSelected(false);
        this.jButtonImageCaptureVert.setSelected(false);
        this.jButtonContrast.setSelected(false);
        this.jButtonBrightness.setSelected(true);
        this.jButtonSelected = this.jButtonBrightness;
        this.jButtonNoiseThreshold.setSelected(false);
        this.jButtonPriorityThreshold.setSelected(false);
        this.jLabelSliderLeft.setText(res.getString("JDialogManualVideoAdjust_Min"));
        this.jLabelSliderRight.setText(res.getString("JDialogManualVideoAdjust_Max"));
        this.jLabelSliderTop.setText(res.getString("JDialogManualVideoAdjust_Brightness"));
        this.setSliderParams(0, 255, 25, 25, this.m_nBrightness);
        this.changingSliderParameters(false);
    }

    void jButtonNoiseThreshold_actionPerformed(ActionEvent actionEvent) {
        this.changingSliderParameters(false);
        this.waitForPendingSliderValueChangeToClear();
        this.jButtonImageCaptureWidth.setSelected(false);
        this.jButtonImageFine.setSelected(false);
        this.jButtonImageCaptureHorz.setSelected(false);
        this.jButtonImageCaptureVert.setSelected(false);
        this.jButtonContrast.setSelected(false);
        this.jButtonBrightness.setSelected(false);
        this.jButtonNoiseThreshold.setSelected(true);
        this.jButtonSelected = this.jButtonNoiseThreshold;
        this.jButtonPriorityThreshold.setSelected(false);
        this.jLabelSliderLeft.setText(res.getString("JDialogManualVideoAdjust_Min"));
        this.jLabelSliderRight.setText(res.getString("JDialogManualVideoAdjust_Max"));
        if (this.m_applianceSession.getVideoEncodingType() == 1) {
            this.jLabelSliderTop.setText(res.getString("JDialogManualVideoAdjust_Noise_Threshold"));
            this.setSliderParams(0, 200, 20, 20, this.m_nNoiseThreshold);
        } else {
            this.jLabelSliderTop.setText(res.getString("JDialogManualVideoAdjust_Block_Noise_Threshold"));
            this.setSliderParams(0, 250, 25, 25, this.m_nNoiseThreshold);
        }
        this.changingSliderParameters(false);
    }

    void jButtonPriorityThreshold_actionPerformed(ActionEvent actionEvent) {
        this.changingSliderParameters(true);
        this.waitForPendingSliderValueChangeToClear();
        this.jButtonImageCaptureWidth.setSelected(false);
        this.jButtonImageFine.setSelected(false);
        this.jButtonImageCaptureHorz.setSelected(false);
        this.jButtonImageCaptureVert.setSelected(false);
        this.jButtonContrast.setSelected(false);
        this.jButtonBrightness.setSelected(false);
        this.jButtonNoiseThreshold.setSelected(false);
        this.jButtonPriorityThreshold.setSelected(true);
        this.jButtonSelected = this.jButtonPriorityThreshold;
        this.jLabelSliderLeft.setText(res.getString("JDialogManualVideoAdjust_Min"));
        this.jLabelSliderRight.setText(res.getString("JDialogManualVideoAdjust_Max"));
        if (this.m_applianceSession.getVideoEncodingType() == 1) {
            this.jLabelSliderTop.setText(res.getString("JDialogManualVideoAdjust_Priority_Threshold"));
            this.setSliderParams(0, 200, 20, 20, this.m_nPriorityThreshold);
        } else {
            this.jLabelSliderTop.setText(res.getString("JDialogManualVideoAdjust_Pixel_Noise_Threshold"));
            this.setSliderParams(0, 15, 2, 2, this.m_nPriorityThreshold);
        }
        this.changingSliderParameters(false);
    }

    void jButtonAutoVideoAdjust_actionPerformed(ActionEvent actionEvent) {
        if (this.jToggleButtonVideoTestPattern.isSelected()) {
            this.jToggleButtonVideoTestPattern.setSelected(false);
        }
        new ThreadWaitForAutoVideoAdjust();
    }

    void jButtonRefreshImage_actionPerformed(ActionEvent actionEvent) {
        try {
            this.m_applianceSession.cmdRefreshPane();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void jToggleButtonVideoTestPattern_actionPerformed(ActionEvent actionEvent) {
        try {
            this.m_applianceSession.cmdVideoTestPattern(this.jToggleButtonVideoTestPattern.isSelected());
            this.m_applianceSession.cmdVideoSetup();
            this.jButtonAutoVideoAdjust.setEnabled(!this.jButtonAutoVideoAdjust.isEnabled());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void jToggleButtonVideoTestPattern_actionPerformed_byKeystroke(ActionEvent actionEvent) {
        try {
            this.m_applianceSession.cmdVideoTestPattern(!this.jToggleButtonVideoTestPattern.isSelected());
            this.jToggleButtonVideoTestPattern.setSelected(!this.jToggleButtonVideoTestPattern.isSelected());
            this.m_applianceSession.cmdVideoSetup();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void jButtonHelp_actionPerformed(ActionEvent actionEvent) {
        Help.launchHelp(this.m_szHelpURL, "IDH_MANUAL_VIDEO_ADJUST");
    }

    void jButtonClose_actionPerformed(ActionEvent actionEvent) {
        this.closeTestPattern();
        this.setVisible(false);
        this.dispose();
    }

    void jSliderVideo_stateChanged(ChangeEvent changeEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JDialogManualVideoAdjust jSliderVideo_stateChanged) jSliderVideo.getValue:" + this.jSliderVideo.getValue() + " minorTick:" + this.jSliderVideo.getMinorTickSpacing() + " majorTick:" + this.jSliderVideo.getMajorTickSpacing() + " maximum:" + this.jSliderVideo.getMaximum() + " minimum:" + this.jSliderVideo.getMinimum()));
        this.jLabelSliderValue.setText(Integer.toString(this.jSliderVideo.getValue()));
        if (!this.areSliderParametersChanging()) {
            this.sliderValueChanged(true);
        }
    }

    void UpdateDisplay(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JDialogManualVideoAdjust UpdateDisplay) nBrightness:" + n + " nContrast:" + n2 + " nHorzPosition:" + n3 + " nVertPosition:" + n4 + " nRGBFrequency:" + n5 + " nRGBPhase:" + n6 + " nRGBHorzResolution:" + n7 + " nRGBVertResolution:" + n8 + " nNoiseThreshold:" + n9 + " nPriorityThreshold:" + n10));
        this.m_nBrightness = n;
        this.m_nContrast = n2;
        this.m_nHorzPosition = n3;
        this.m_nVertPosition = n4;
        this.m_nWidth = n5;
        this.m_nFine = n6;
        this.m_nHorzResolution = n7;
        this.m_nVertResolution = n8;
        this.m_nNoiseThreshold = n9;
        this.m_nPriorityThreshold = n10;
        this.m_bVideoSetupDataReceived = true;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        this.m_applianceSession.closingManualVideoAdjustDlg();
    }

    public void windowClosing(WindowEvent windowEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JDialogManualVideoAdjust windowClosing)");
        this.closeTestPattern();
        this.dispose();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    private synchronized void changingSliderParameters(boolean bl) {
        this.m_bChangingSliderParameters = bl;
    }

    private synchronized boolean areSliderParametersChanging() {
        return this.m_bChangingSliderParameters;
    }

    private synchronized void sliderValueChanged(boolean bl) {
        this.m_bSliderValueChanged = bl;
    }

    private synchronized boolean hasSliderValueChanged() {
        return this.m_bSliderValueChanged;
    }

    void waitForPendingSliderValueChangeToClear() {
        if (this.hasSliderValueChanged()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JDialogManualVideoAdjust waitForPendingSliderChangeToClear) m_bSliderParameterChanged, waiting for it to clear");
            for (int i = 20; this.hasSliderValueChanged() && i > 0; --i) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    void setSliderParams(int n, int n2, int n3, int n4, int n5) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JDialogManualVideoAdjust setSliderParams)");
        this.jSliderVideo.setMinimum(n);
        this.jSliderVideo.setMaximum(n2);
        this.jSliderVideo.setMajorTickSpacing(n3);
        this.jSliderVideo.setMinorTickSpacing(n4);
        this.jSliderVideo.setValue(n5);
    }

    void setPerformanceMonitor(int n) {
        this.jProgressBarPerformanceMonitor.setValue(n);
        this.jLabelPerformanceValue.setText("" + n * 10);
    }

    void jButtonIncrement_actionPerformed(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JDialogManualVideoAdjust jButtonIncrement_actionPerformed)");
        this.jSliderVideo.setValue(this.jSliderVideo.getValue() + 1);
    }

    void jButtonDecrement_actionPerformed(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JDialogManualVideoAdjust jButtonDecrement_actionPerformed)");
        this.jSliderVideo.setValue(this.jSliderVideo.getValue() - 1);
    }

    private void enableAllControls(boolean bl) {
        try {
            this.jButtonImageCaptureWidth.setEnabled(bl);
            this.jButtonImageFine.setEnabled(bl);
            this.jButtonImageCaptureHorz.setEnabled(bl);
            this.jButtonImageCaptureVert.setEnabled(bl);
            this.jButtonContrast.setEnabled(bl);
            this.jButtonBrightness.setEnabled(bl);
            this.jButtonNoiseThreshold.setEnabled(bl);
            this.jButtonPriorityThreshold.setEnabled(bl);
            this.jSliderVideo.setEnabled(bl);
            this.jButtonAutoVideoAdjust.setEnabled(bl);
            this.jButtonRefreshImage.setEnabled(bl);
            this.jToggleButtonVideoTestPattern.setEnabled(bl);
            this.jButtonIncrement.setEnabled(bl);
            this.jButtonDecrement.setEnabled(bl);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void closeTestPattern() {
        if (this.jToggleButtonVideoTestPattern.isSelected()) {
            try {
                this.m_applianceSession.cmdVideoTestPattern(false);
            }
            catch (IOException iOException) {
                Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
            }
        }
    }

    public boolean doEscape() {
        this.closeTestPattern();
        return false;
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (Win32Library.isWin32LibLoaded()) {
                try {
                    this.m_libWin32.alwaysOnTop((Window)((Object)this));
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {}
            } else {
                this.toFront();
            }
        }
        super.setVisible(bl);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$800(JDialogManualVideoAdjust jDialogManualVideoAdjust, boolean bl) {
        jDialogManualVideoAdjust.enableAllControls(bl);
    }

    class VideoAdjustSliderUI
    extends BasicSliderUI {
        public VideoAdjustSliderUI(JSlider jSlider) {
            super(jSlider);
        }
    }

    private class ThreadWaitForAutoVideoAdjust
    extends Thread {
        private ThreadWaitForAutoVideoAdjust() {
            this.start();
        }

        public void run() {
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ ThreadWaitForAutoVideoAdjust this$1;
                {
                    this.this$1 = threadWaitForAutoVideoAdjust;
                }

                public void run() {
                    JDialogManualVideoAdjust.access$800(ThreadWaitForAutoVideoAdjust.access$700(this.this$1), false);
                }
            });
            try {
                JDialogManualVideoAdjust.this.m_applianceSession.cmdAutoAdjustVideo();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            JDialogManualVideoAdjust.this.m_bVideoSetupDataReceived = false;
            int n = 60;
            while (!JDialogManualVideoAdjust.this.m_bVideoSetupDataReceived && n-- >= 0) {
                try {
                    ThreadWaitForAutoVideoAdjust.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (!JDialogManualVideoAdjust.this.m_bVideoSetupDataReceived) {
                try {
                    JDialogManualVideoAdjust.this.m_applianceSession.cmdVideoSetup();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                int n2 = 0;
                while (!JDialogManualVideoAdjust.this.m_bVideoSetupDataReceived && n2++ < 50) {
                    try {
                        ThreadWaitForAutoVideoAdjust.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            SwingUtilities.invokeLater(new Runnable(this){
                private final /* synthetic */ ThreadWaitForAutoVideoAdjust this$1;
                {
                    this.this$1 = threadWaitForAutoVideoAdjust;
                }

                public void run() {
                    if (ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jButtonImageCaptureWidth.isSelected()) {
                        ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jSliderVideo.setValue(ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).m_nWidth);
                    } else if (ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jButtonImageFine.isSelected()) {
                        ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jSliderVideo.setValue(ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).m_nFine / JDialogManualVideoAdjust.access$200());
                    } else if (ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jButtonImageCaptureHorz.isSelected()) {
                        ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jSliderVideo.setValue(ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).m_nHorzPosition - JDialogManualVideoAdjust.access$300());
                    } else if (ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jButtonImageCaptureVert.isSelected()) {
                        ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jSliderVideo.setValue(ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).m_nVertPosition - JDialogManualVideoAdjust.access$400());
                    } else if (ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jButtonContrast.isSelected()) {
                        ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jSliderVideo.setValue(ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).m_nContrast);
                    } else if (ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jButtonBrightness.isSelected()) {
                        ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jSliderVideo.setValue(ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).m_nBrightness);
                    } else if (ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jButtonNoiseThreshold.isSelected()) {
                        ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jSliderVideo.setValue(ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).m_nNoiseThreshold);
                    } else if (ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jButtonPriorityThreshold.isSelected()) {
                        ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).jSliderVideo.setValue(ThreadWaitForAutoVideoAdjust.access$700((ThreadWaitForAutoVideoAdjust)this.this$1).m_nPriorityThreshold);
                    }
                    JDialogManualVideoAdjust.access$800(ThreadWaitForAutoVideoAdjust.access$700(this.this$1), true);
                }
            });
        }

        static /* synthetic */ JDialogManualVideoAdjust access$700(ThreadWaitForAutoVideoAdjust threadWaitForAutoVideoAdjust) {
            return threadWaitForAutoVideoAdjust.JDialogManualVideoAdjust.this;
        }
    }

    class PerformanceMonitorThread
    extends Thread {
        int m_nLastPacketCount = 0;

        public PerformanceMonitorThread(int n) {
            Trace.logInfo((String)JDialogManualVideoAdjust.TRACE_CONTEXT, (String)"(JDialogManualVideoAdjust PerformanceMonitorThread constructor)");
            this.m_nLastPacketCount = n;
            this.start();
        }

        public void run() {
            Trace.logInfo((String)JDialogManualVideoAdjust.TRACE_CONTEXT, (String)"(JDialogManualVideoAdjust PerformanceMonitorThread run)");
            while (JDialogManualVideoAdjust.this.isDisplayable()) {
                int n = JDialogManualVideoAdjust.this.m_applianceSession.getTotalVideoPacketsReceived();
                SwingUtilities.invokeLater(new Runnable(this, n){
                    private final /* synthetic */ int val$nPacketCount;
                    private final /* synthetic */ PerformanceMonitorThread this$1;
                    {
                        this.this$1 = performanceMonitorThread;
                        this.val$nPacketCount = n;
                    }

                    public void run() {
                        int n = this.val$nPacketCount - this.this$1.m_nLastPacketCount;
                        PerformanceMonitorThread.access$600((PerformanceMonitorThread)this.this$1).jProgressBarPerformanceMonitor.setValue(n);
                        PerformanceMonitorThread.access$600((PerformanceMonitorThread)this.this$1).jLabelPerformanceValue.setText("" + n);
                        this.this$1.m_nLastPacketCount = this.val$nPacketCount;
                    }
                });
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        static /* synthetic */ JDialogManualVideoAdjust access$600(PerformanceMonitorThread performanceMonitorThread) {
            return performanceMonitorThread.JDialogManualVideoAdjust.this;
        }
    }

    class ThreadChangeVideoValue
    extends Thread {
        ThreadChangeVideoValue() {
            this.start();
        }

        public void run() {
            int n = -1;
            while (JDialogManualVideoAdjust.this.isDisplayable()) {
                if (JDialogManualVideoAdjust.this.hasSliderValueChanged()) {
                    int n2 = JDialogManualVideoAdjust.this.jSliderVideo.getValue();
                    try {
                        ThreadChangeVideoValue.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    int n3 = JDialogManualVideoAdjust.this.jSliderVideo.getValue();
                    if (n2 != n3) {
                        try {
                            ThreadChangeVideoValue.sleep(100L);
                            continue;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (n3 != n) {
                        try {
                            if (JDialogManualVideoAdjust.this.jButtonSelected == JDialogManualVideoAdjust.this.jButtonImageCaptureWidth) {
                                JDialogManualVideoAdjust.this.m_applianceSession.cmdVideoWidth(n3);
                            } else if (JDialogManualVideoAdjust.this.jButtonSelected == JDialogManualVideoAdjust.this.jButtonImageFine) {
                                JDialogManualVideoAdjust.this.m_applianceSession.cmdVideoFine(n3 * FINE_DIVISOR);
                            } else if (JDialogManualVideoAdjust.this.jButtonSelected == JDialogManualVideoAdjust.this.jButtonImageCaptureHorz) {
                                JDialogManualVideoAdjust.this.m_applianceSession.cmdVideoHorzCapture(n3 + HORIZONTAL_POSITION_OFFSET);
                            } else if (JDialogManualVideoAdjust.this.jButtonSelected == JDialogManualVideoAdjust.this.jButtonImageCaptureVert) {
                                JDialogManualVideoAdjust.this.m_applianceSession.cmdVideoVertCapture(n3 + VERTICAL_POSITION_OFFSET);
                            } else if (JDialogManualVideoAdjust.this.jButtonSelected == JDialogManualVideoAdjust.this.jButtonContrast) {
                                JDialogManualVideoAdjust.this.m_applianceSession.cmdVideoContrast(n3);
                            } else if (JDialogManualVideoAdjust.this.jButtonSelected == JDialogManualVideoAdjust.this.jButtonBrightness) {
                                JDialogManualVideoAdjust.this.m_applianceSession.cmdVideoBrightness(n3);
                            } else if (JDialogManualVideoAdjust.this.jButtonSelected == JDialogManualVideoAdjust.this.jButtonNoiseThreshold) {
                                JDialogManualVideoAdjust.this.m_applianceSession.cmdVideoNoiseThreshold(n3);
                            } else if (JDialogManualVideoAdjust.this.jButtonSelected == JDialogManualVideoAdjust.this.jButtonPriorityThreshold) {
                                JDialogManualVideoAdjust.this.m_applianceSession.cmdVideoPriorityThreshold(n3);
                            }
                            JDialogManualVideoAdjust.this.m_applianceSession.cmdVideoSetup();
                            JDialogManualVideoAdjust.this.m_applianceSession.cmdRefreshPane();
                        }
                        catch (IOException iOException) {
                            Trace.logError((String)JDialogManualVideoAdjust.TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
                        }
                        n = n3;
                    }
                    JDialogManualVideoAdjust.this.sliderValueChanged(false);
                }
                try {
                    ThreadChangeVideoValue.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

