/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.gui.dialogs.JDialogCentered;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.util.Patch;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.BrandNaming;
import com.avocent.video.Help;
import com.avocent.video.JFrameThumbnail;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JDialogThumbnailOptions
extends JDialogCentered {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    public static final String CNAME = "JDialogThumbnailOptions";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    JPanel panel1 = new JPanel();
    JPanel jPanelComponents = new JPanel();
    JPanel jPanelButtons = new JPanel();
    JLabel jLabelViewTimePerServer = new JLabel();
    JTextField jTextFieldViewTimePerServer = new JTextField();
    JLabel jLabelTimeBetweenServers = new JLabel();
    JTextField jTextFieldTimeBetweenServers = new JTextField();
    JLabel jLabelSeconds1 = new JLabel();
    JLabel jLabelSeconds2 = new JLabel();
    JButton jButtonOK = new JButton();
    JButton jButtonCancel = new JButton();
    ApplianceSessionInfo m_sessionInfo;
    boolean m_bOKPressed = false;
    int m_nViewTimePerServer = 0;
    int m_nTimeBetweenServers = 0;
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    GridBagLayout gridBagLayout4 = new GridBagLayout();
    JButton jButtonHelp = new JButton();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    String m_szHelpURL;

    public JDialogThumbnailOptions(Frame frame, String string, boolean bl, ApplianceSessionInfo applianceSessionInfo, String string2) {
        super(frame, string, bl);
        this.m_szHelpURL = string2;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_sessionInfo = applianceSessionInfo;
        this.m_nViewTimePerServer = ((JFrameThumbnail)frame).getViewTimePerServer();
        this.jTextFieldViewTimePerServer.setText(Integer.toString(this.m_nViewTimePerServer));
        this.m_nTimeBetweenServers = ((JFrameThumbnail)frame).getTimeBetweenServers();
        this.jTextFieldTimeBetweenServers.setText(Integer.toString(this.m_nTimeBetweenServers));
        this.jTextFieldViewTimePerServer.requestFocus();
        this.getRootPane().setDefaultButton(this.jButtonOK);
        new Patch().fixNonResizableDlg((JDialog)((Object)this));
    }

    public JDialogThumbnailOptions() {
        this(null, "", false, null, null);
    }

    void jbInit() throws Exception {
        this.panel1.setLayout(this.gridBagLayout3);
        this.getContentPane().setLayout(this.gridBagLayout5);
        this.setResizable(false);
        this.jPanelComponents.setLayout(this.gridBagLayout4);
        this.jPanelButtons.setLayout(this.gridBagLayout2);
        this.jLabelViewTimePerServer.setHorizontalAlignment(4);
        this.jLabelViewTimePerServer.setLabelFor(this.jTextFieldViewTimePerServer);
        Object[] objectArray = new Object[]{new String(BrandNaming.getServerName(false, true))};
        String string = MessageFormat.format(RES.getString("JDialogThumbnailOptions_Thumbnail_Preferences_View_Time_Per_Server"), objectArray);
        this.jLabelViewTimePerServer.setText(string);
        this.jTextFieldViewTimePerServer.setColumns(2);
        this.jTextFieldTimeBetweenServers.setColumns(2);
        this.jLabelTimeBetweenServers.setHorizontalAlignment(4);
        this.jLabelTimeBetweenServers.setLabelFor(this.jTextFieldTimeBetweenServers);
        Object[] objectArray2 = new Object[]{new String(BrandNaming.getServerName(false, false))};
        String string2 = MessageFormat.format(RES.getString("JDialogThumbnailOptions_Thumbnail_Preferences_Time_Between_Servers"), objectArray2);
        this.jLabelTimeBetweenServers.setText(string2);
        this.jLabelSeconds1.setLabelFor(this.jTextFieldViewTimePerServer);
        this.jLabelSeconds1.setText(RES.getString("JDialogThumbnailOptions_Seconds"));
        this.jLabelSeconds2.setLabelFor(this.jTextFieldTimeBetweenServers);
        this.jLabelSeconds2.setText(RES.getString("JDialogThumbnailOptions_Seconds"));
        this.jButtonOK.setText(RES.getString("JDialogThumbnailOptions_OK"));
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogThumbnailOptions.this.jButtonOK_actionPerformed(actionEvent);
            }
        });
        this.jButtonCancel.setText(RES.getString("JDialogThumbnailOptions_Cancel"));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialogThumbnailOptions.this.jButtonCancel_actionPerformed(actionEvent);
            }
        });
        this.setTitle(RES.getString("JDialogThumbnailOptions_Thumbnail_Preferences_Title"));
        if (this.m_szHelpURL != null && this.m_szHelpURL.length() > 0) {
            this.jButtonHelp.setText(RES.getString("JDialogThumbnailOptions_Help"));
            String string3 = RES.getString("JDialogThumbnailOptions_Help_Mnemonic");
            if (string3 != null && string3.length() > 0) {
                this.jButtonHelp.setMnemonic(string3.charAt(0));
            }
            this.jButtonHelp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JDialogThumbnailOptions.this.jButtonHelp_actionPerformed(actionEvent);
                }
            });
        }
        this.getContentPane().add((Component)this.panel1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.jPanelComponents, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.panel1.add((Component)this.jPanelButtons, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 11, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonOK, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 12, 12), 0, 0));
        this.jPanelButtons.add((Component)this.jButtonCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(12, 6, 12, 6), 0, 0));
        if (this.m_szHelpURL != null && this.m_szHelpURL.length() > 0) {
            this.jPanelButtons.add((Component)this.jButtonHelp, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(12, 12, 12, 12), 0, 0));
        }
        this.jPanelComponents.add((Component)this.jLabelViewTimePerServer, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 12, 0), 0, 0));
        this.jPanelComponents.add((Component)this.jTextFieldViewTimePerServer, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 12, 12, 0), 10, 0));
        this.jPanelComponents.add((Component)this.jLabelSeconds1, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 17, 0, new Insets(12, 4, 12, 11), 0, 0));
        this.jPanelComponents.add((Component)this.jLabelTimeBetweenServers, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(12, 12, 12, 0), 0, 0));
        this.jPanelComponents.add((Component)this.jTextFieldTimeBetweenServers, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(12, 12, 12, 0), 10, 0));
        this.jPanelComponents.add((Component)this.jLabelSeconds2, new GridBagConstraints(2, 1, 1, 1, 0.5, 0.0, 17, 0, new Insets(12, 4, 12, 11), 0, 0));
    }

    void jButtonOK_actionPerformed(ActionEvent actionEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JDialogThumbnailOptions jButtonOK_actionPerformed)");
        try {
            this.m_nViewTimePerServer = this.getViewTimePerServer();
            if (this.m_nViewTimePerServer < 10 || this.m_nViewTimePerServer > 60) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            Message.show((Component)((Object)this), (String)RES.getString("JDialogThumbnailOptions_Thumbnail_Preferences_View_Time_Warning"));
            this.jTextFieldViewTimePerServer.requestFocus();
            return;
        }
        try {
            this.m_nTimeBetweenServers = this.getTimeBetweenServers();
            if (this.m_nTimeBetweenServers < 5 || this.m_nTimeBetweenServers > 60) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            Message.show((Component)((Object)this), (String)RES.getString("JDialogThumbnailOptions_Thumbnail_Preferences_Time_Between_Servers_Warning"));
            this.jTextFieldTimeBetweenServers.requestFocus();
            return;
        }
        this.m_bOKPressed = true;
        this.setVisible(false);
        this.dispose();
        this.m_sessionInfo = null;
    }

    void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
        this.m_sessionInfo = null;
    }

    public boolean wasOKPressed() {
        return this.m_bOKPressed;
    }

    public int getViewTimePerServer() {
        return new Integer(this.jTextFieldViewTimePerServer.getText().trim());
    }

    public int getTimeBetweenServers() {
        return new Integer(this.jTextFieldTimeBetweenServers.getText().trim());
    }

    void jButtonHelp_actionPerformed(ActionEvent actionEvent) {
        Help.launchHelp(this.m_szHelpURL, "IDH_SCAN_PREFERENCES");
    }
}

