/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.InterfaceWindowManager;
import com.avocent.lib.util.OS;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.DSKeyListener;
import com.avocent.video.InterfaceNativeKeyEventListener;
import com.avocent.video.InterfaceViewWindow;
import com.avocent.video.JDialogSingleCursorFullScreen;
import com.avocent.video.JFrameViewer;
import com.avocent.video.JPanelAppliance;
import com.avocent.video.KeyStroke;
import com.avocent.video.LinuxLibrary;
import com.avocent.video.PanelToolbarNormal;
import com.avocent.video.SolarisLibrary;
import com.avocent.video.Win32Library;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class JFrameFullScreen
extends JFrame
implements InterfaceViewWindow,
InterfaceNativeKeyEventListener,
InterfaceWindowManager {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    public static final String CNAME = "JFrameFullScreen";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    private ApplianceSession m_applianceSession;
    private JPanelAppliance m_appliancePanel;
    JPanel m_panelColorFiller;
    private JLayeredPane m_layeredPane;
    private DSKeyListener m_dsKeyListener;
    private Win32Library m_libWin32;
    private boolean m_bWin32LibraryLoaded;
    private int m_nHWND;
    private boolean m_bAltKeyPressed;
    private boolean m_bAltKeyReleaseOnTabOrEscSent;
    private boolean m_bCtrlKeyPressed;
    private boolean m_bCtrlKeyReleaseOnEscSent;
    private boolean m_bWindowNotActiveCheckAltKey;
    private int m_nOrigPanelWidth;
    private int m_nOrigPanelHeight;
    private int m_nOrigPanelDecimationFactor;
    private Point m_ptOrigLocation;
    private Dimension m_sizeOrigFrame;
    private GraphicsConfiguration m_gcOrig;
    private boolean m_bOrigFullScale;
    private boolean m_bOrigAutoScale;
    private boolean m_bSingleCursorModeCurrentlyActive;
    protected Vector m_vKeyPressedList;
    boolean m_bProcessingGeneratedKeyPress;
    private PanelToolbarNormal m_toolbar;
    boolean m_bSingleCursorModeActive;
    private boolean m_bKeyboardHooked;
    private boolean m_bUseNativeJavaKeyCodes;
    private JFrameViewer m_frameViewer;
    private boolean b_KeyboardPassThruDeactivate;
    private boolean b_KeyListenerActivated;
    private boolean m_bTerminated;
    private boolean b_ignorekey;
    static /* synthetic */ Class class$com$avocent$video$JFrameFullScreen;

    public JFrameFullScreen() {
        this.m_bWin32LibraryLoaded = false;
        this.m_nHWND = 0;
        this.m_bAltKeyPressed = false;
        this.m_bAltKeyReleaseOnTabOrEscSent = false;
        this.m_bCtrlKeyPressed = false;
        this.m_bCtrlKeyReleaseOnEscSent = false;
        this.m_bWindowNotActiveCheckAltKey = false;
        this.m_bOrigFullScale = false;
        this.m_bOrigAutoScale = false;
        this.m_bSingleCursorModeCurrentlyActive = false;
        this.m_vKeyPressedList = new Vector();
        this.m_bProcessingGeneratedKeyPress = false;
        this.m_bSingleCursorModeActive = false;
        this.m_bKeyboardHooked = false;
        this.m_bUseNativeJavaKeyCodes = false;
        this.b_KeyboardPassThruDeactivate = false;
        this.b_KeyListenerActivated = false;
        this.m_bTerminated = false;
        this.b_ignorekey = false;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public JFrameFullScreen(ApplianceSession applianceSession, Point point, Dimension dimension) {
        block38: {
            this.m_bWin32LibraryLoaded = false;
            this.m_nHWND = 0;
            this.m_bAltKeyPressed = false;
            this.m_bAltKeyReleaseOnTabOrEscSent = false;
            this.m_bCtrlKeyPressed = false;
            this.m_bCtrlKeyReleaseOnEscSent = false;
            this.m_bWindowNotActiveCheckAltKey = false;
            this.m_bOrigFullScale = false;
            this.m_bOrigAutoScale = false;
            this.m_bSingleCursorModeCurrentlyActive = false;
            this.m_vKeyPressedList = new Vector();
            this.m_bProcessingGeneratedKeyPress = false;
            this.m_bSingleCursorModeActive = false;
            this.m_bKeyboardHooked = false;
            this.m_bUseNativeJavaKeyCodes = false;
            this.b_KeyboardPassThruDeactivate = false;
            this.b_KeyListenerActivated = false;
            this.m_bTerminated = false;
            this.b_ignorekey = false;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JFrameFullScreen constructor) ");
            try {
                this.m_libWin32 = new Win32Library();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Trace.logError((String)TRACE_CONTEXT, (String)unsatisfiedLinkError.getMessage(), (Throwable)unsatisfiedLinkError);
                if (OS.isLinux()) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("Was Linux native library loaded? " + (LinuxLibrary.isLibraryLoaded() ? "YES" : "NO")));
                }
                if (!OS.isSolaris()) break block38;
                Trace.logInfo((String)TRACE_CONTEXT, (String)("Was Solaris native library loaded? " + (SolarisLibrary.isLibraryLoaded() ? "YES" : "NO")));
            }
        }
        JFrameFullScreen jFrameFullScreen = this;
        this.m_bWin32LibraryLoaded = jFrameFullScreen.m_libWin32.isWin32LibLoaded();
        this.m_applianceSession = applianceSession;
        this.m_frameViewer = (JFrameViewer)this.m_applianceSession.getApplianceWindow();
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        this.m_nOrigPanelWidth = applianceSessionInfo.getPanedWidth();
        this.m_nOrigPanelHeight = applianceSessionInfo.getPanedHeight();
        this.m_nOrigPanelDecimationFactor = applianceSessionInfo.getDecimationFactor();
        this.m_gcOrig = this.m_frameViewer.getGraphicsConfiguration();
        this.m_ptOrigLocation = point;
        this.m_sizeOrigFrame = dimension;
        this.m_bOrigFullScale = applianceSessionInfo.isFullScale();
        this.m_bOrigAutoScale = applianceSessionInfo.isAutoScale();
        this.m_appliancePanel = this.m_applianceSession.getApplianceWindow().getPanelAppliance();
        this.m_applianceSession.setApplianceWindow(this);
        this.m_applianceSession.registerWindow(this);
        if (this.m_applianceSession.getTitle() == null || this.m_applianceSession.getTitle().length() == 0) {
            this.setTitle(RES.getString("JFrameFullScreen_Video_Session_Viewer"));
        } else {
            this.setTitle(this.m_applianceSession.getTitle());
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getContentPane().setLayout(null);
        this.m_layeredPane = new JLayeredPane();
        this.getContentPane().add(this.m_layeredPane);
        this.m_layeredPane.setLayer(this.m_appliancePanel, 1);
        this.m_layeredPane.add(this.m_appliancePanel);
        this.m_dsKeyListener = new DSKeyListener(this.m_applianceSession);
        if (!(this.m_bWin32LibraryLoaded || LinuxLibrary.isLibraryLoaded() || SolarisLibrary.isLibraryLoaded())) {
            this.addKeyListener(this.m_dsKeyListener);
        }
        this.addWindowListener(new ApplianceWindowListener());
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent focusEvent) {
                if (JFrameFullScreen.this.m_applianceSession != null) {
                    try {
                        JFrameFullScreen.this.m_applianceSession.cmdFocusControl(true);
                    }
                    catch (IOException iOException) {
                        Trace.logError((String)JFrameFullScreen.TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
                    }
                }
            }

            public void focusLost(FocusEvent focusEvent) {
                if (JFrameFullScreen.this.m_applianceSession != null) {
                    try {
                        JFrameFullScreen.this.m_applianceSession.cmdFocusControl(false);
                    }
                    catch (IOException iOException) {
                        Trace.logError((String)JFrameFullScreen.TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
                    }
                }
            }
        });
        Rectangle rectangle = this.m_gcOrig.getBounds();
        Dimension dimension2 = new Dimension(rectangle.width, rectangle.height);
        this.setSize(dimension2);
        this.setLocation(rectangle.x, rectangle.y);
        this.setBackground(Color.black);
        this.setForeground(Color.black);
        this.m_layeredPane.setSize(dimension2);
        this.m_layeredPane.setLocation(0, 0);
        this.m_layeredPane.setBackground(Color.black);
        this.m_layeredPane.setVisible(true);
        if (dimension2.getWidth() > 1024.0 || dimension2.getHeight() > 768.0) {
            this.m_panelColorFiller = new JPanel();
            this.m_panelColorFiller.setSize(dimension2);
            this.m_panelColorFiller.setBackground(Color.black);
            this.m_layeredPane.setLayer(this.m_panelColorFiller, 0);
            this.m_layeredPane.add(this.m_panelColorFiller);
            this.m_panelColorFiller.setVisible(true);
        }
        this.m_appliancePanel.setVisible(false);
        this.setVisible(true);
        this.toFront();
        int n = applianceSessionInfo.getVideoWidth();
        int n2 = applianceSessionInfo.getVideoHeight();
        if (dimension2.getWidth() >= 1024.0 || dimension2.getHeight() >= 768.0) {
            n = 1024;
            n2 = 768;
        } else if (dimension2.getWidth() >= 960.0 || dimension2.getHeight() >= 720.0) {
            n = 960;
            n2 = 720;
        } else if (dimension2.getWidth() >= 896.0 || dimension2.getHeight() >= 672.0) {
            n = 896;
            n2 = 672;
        } else if (dimension2.getWidth() >= 832.0 || dimension2.getHeight() >= 624.0) {
            n = 832;
            n2 = 624;
        } else if (dimension2.getWidth() >= 768.0 || dimension2.getHeight() >= 576.0) {
            n = 768;
            n2 = 576;
        } else if (dimension2.getWidth() >= 704.0 || dimension2.getHeight() >= 528.0) {
            n = 704;
            n2 = 528;
        } else {
            n = 640;
            n2 = 480;
        }
        try {
            applianceSessionInfo.setPanedWidth((short)n);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(JFrameFullScreen constructor) setPanedWidth error", (Throwable)exception);
        }
        try {
            applianceSessionInfo.setPanedHeight((short)n2);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(JFrameFullScreen constructor) setPanedHeight error", (Throwable)exception);
        }
        try {
            applianceSessionInfo.setDecimationFactor(1);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(JFrameFullScreen constructor) decimationFactor error", (Throwable)exception);
        }
        try {
            applianceSessionInfo.setAutoScale(false);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
        try {
            applianceSessionInfo.setFullScale(false);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
        this.m_applianceSession.setPersistentData(applianceSessionInfo);
        if (this.m_appliancePanel.getBitmapWidth() == n && this.m_appliancePanel.getBitmapHeight() == n2 && this.m_appliancePanel.getDecimationFactor() == 1) {
            this.resizeVideoWindow(n, n2);
            try {
                this.m_applianceSession.cmdRefreshPane();
            }
            catch (IOException iOException) {
                Trace.logError((String)TRACE_CONTEXT, (String)"(JFrameFullScreen constructor) cmdStartVideo error", (Throwable)iOException);
            }
        } else {
            if (rectangle.height != n2 || rectangle.width != n) {
                this.m_appliancePanel.m_bInitRun = false;
            }
            try {
                this.m_applianceSession.cmdStartVideo();
            }
            catch (IOException iOException) {
                Trace.logError((String)TRACE_CONTEXT, (String)"(JFrameFullScreen constructor) cmdStartVideo error", (Throwable)iOException);
            }
        }
    }

    private void jbInit() throws Exception {
        ImageIcon imageIcon = new ImageIcon((class$com$avocent$video$JFrameFullScreen == null ? (class$com$avocent$video$JFrameFullScreen = JFrameFullScreen.class$("com.avocent.video.JFrameFullScreen")) : class$com$avocent$video$JFrameFullScreen).getResource("images/connectvideo16.gif"));
        this.setIconImage(imageIcon.getImage());
        this.setUndecorated(true);
    }

    public void initWindow(ApplianceSession applianceSession, int n, int n2, short s, short s2, short s3, short s4, int n3) {
        this.initWindow(applianceSession, n, n2, s, s2, s3, s4, n3, true);
    }

    public void initWindow(ApplianceSession applianceSession, int n, int n2, short s, short s2, short s3, short s4, int n3, boolean bl) {
        this.m_applianceSession = applianceSession;
        Dimension dimension = this.getSize();
        this.m_appliancePanel.initPanelAppliance(this.m_applianceSession, (int)(dimension.getWidth() / 2.0 - (double)(s / 2)), (int)(dimension.getHeight() / 2.0 - (double)(s2 / 2)), s, s2, s3, s4, n3, true, bl);
        this.m_appliancePanel.setLocation((int)(dimension.getWidth() / 2.0 - (double)(s / 2)), (int)(dimension.getHeight() / 2.0 - (double)(s2 / 2)));
        this.m_appliancePanel.setVisible(true);
        this.initToolbar(this.m_applianceSession);
        this.setVisible(true);
        this.toFront();
    }

    public void enableScalingControls(boolean bl) {
    }

    public boolean isSingleCursorActive() {
        return this.m_bSingleCursorModeActive;
    }

    public void activateSingleCursorMode(boolean bl) {
        if (Win32Library.isWin32LibLoaded()) {
            if (bl) {
                Object object;
                ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
                Dimension dimension = this.getSize();
                if (dimension.getWidth() <= 1024.0 && dimension.getHeight() <= 768.0 && !applianceSessionInfo.isDontShowDlgSingleCursorFullScreen()) {
                    object = new JDialogSingleCursorFullScreen(this, this.m_applianceSession);
                    object.setModal(true);
                    object.setVisible(true);
                }
                object = this.m_appliancePanel.getBounds();
                Point point = ((Rectangle)object).getLocation();
                SwingUtilities.convertPointToScreen(point, this.m_appliancePanel);
                int n = 67;
                try {
                    n = KeyStroke.getScanCodeForStandardSelectionKeyStroke(applianceSessionInfo.getSingleCursorTerminateKey());
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                }
                this.m_libWin32.setSingleMouseMode(n, this, point.x, point.y, (int)((Rectangle)object).getWidth() / applianceSessionInfo.getDecimationFactor(), (int)((Rectangle)object).getHeight() / applianceSessionInfo.getDecimationFactor());
                this.m_appliancePanel.initSingleCursor();
                try {
                    this.m_applianceSession.cmdMouseAlign();
                }
                catch (IOException iOException) {
                    Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
                }
                this.m_bSingleCursorModeActive = true;
                if (applianceSessionInfo.isLockToolbarSingleCursorFullScreen()) {
                    this.initToolbar(this.m_applianceSession);
                }
            } else if (this.m_bSingleCursorModeActive) {
                this.m_libWin32.resetSingleMouseMode();
                this.notifySingleCursorDeactivated();
            }
        }
    }

    public void initToolbar(ApplianceSession applianceSession) {
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
        if (this.m_toolbar != null) {
            this.m_layeredPane.remove(this.m_toolbar);
            applianceSession.getApplianceWindow().getPanelAppliance().repaint();
        }
        Rectangle rectangle = this.m_gcOrig.getBounds();
        this.m_toolbar = new PanelToolbarNormal(rectangle.width / 2, 0, rectangle.width, this, this.m_nHWND, this.m_appliancePanel, "", applianceSession, applianceSessionInfo.isPinPushed(), rectangle.width > 1024 || this.m_applianceSession.getApplianceWindow().isSingleCursorActive() && applianceSessionInfo.isLockToolbarSingleCursorFullScreen(), true, applianceSessionInfo.getToolbarHideDelay());
        this.m_layeredPane.setLayer(this.m_toolbar, 2);
        this.m_layeredPane.add(this.m_toolbar);
        this.m_toolbar.initToolbar(applianceSession);
    }

    public final JPanelAppliance getPanelAppliance() {
        return this.m_appliancePanel;
    }

    public int getBitmapWidth() {
        return this.m_appliancePanel.getBitmapWidth();
    }

    public int getBitmapHeight() {
        return this.m_appliancePanel.getBitmapHeight();
    }

    public int getPixelArrayWidth() {
        return this.m_appliancePanel.getPixelArrayWidth();
    }

    public void mouseAlign() {
        try {
            this.m_applianceSession.cmdMouseAlign();
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"cmdMouseAlign IOException", (Throwable)iOException);
        }
        catch (NullPointerException nullPointerException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"mouseAlign m_applianceSession null", (Throwable)nullPointerException);
        }
    }

    public void setConnectionType(int n) {
        try {
            this.m_toolbar.setConnectionStatus(n);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void notifyLockedModeChanged() {
        try {
            this.m_toolbar.notifyLockedOrReserveModeChanged();
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void notifyReserveModeChanged() {
        try {
            this.m_toolbar.notifyLockedOrReserveModeChanged();
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void notifyManualVideoAdjustDialogClosed() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer notifyManualVideoAdjustDialogClosed");
        try {
            this.m_toolbar.notifyManualVideoAdjustDialogClosed();
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void notifyVmAvailableChanged() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer notifyManualVideoAdjustDialogClosed");
        try {
            this.m_toolbar.notifyVmAvailableChanged();
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void terminate() {
        this.setVisible(false);
        this.dispose();
        try {
            if (this.m_frameViewer != null) {
                this.m_frameViewer.dispose();
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"", (String)("exception when closing sesssion Message=" + exception.getMessage()));
        }
    }

    public void terminateSession() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JWindowFullScreen.terminate) m_bTerminated=" + this.m_bTerminated));
        if (this.m_bTerminated) {
            return;
        }
        this.m_bTerminated = true;
        this.activateSingleCursorMode(false);
        try {
            this.m_applianceSession.terminateSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_appliancePanel != null) {
            try {
                this.m_appliancePanel.terminatePanelAppliance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.m_toolbar != null) {
            this.m_toolbar.terminate();
        }
        this.m_toolbar = null;
        this.setVisible(false);
        this.removeAll();
        this.dispose();
        this.m_appliancePanel = null;
        try {
            if (this.m_frameViewer != null) {
                this.m_frameViewer.dispose();
            }
        }
        catch (Exception exception) {
            Trace.logError((String)"", (String)("exception when closing sesssion Message=" + exception.getMessage()));
        }
    }

    public void repaintAppliance() {
        this.repaint();
    }

    public void bringWindowToTop() {
        this.toFront();
        this.requestFocus();
    }

    public void fullScreenToggle() {
        if (this.m_applianceSession != null) {
            this.m_applianceSession.closeDlgManualVideoAdjust();
        }
        if (LinuxLibrary.isLibraryLoaded() || SolarisLibrary.isLibraryLoaded()) {
            if (LinuxLibrary.isLibraryLoaded()) {
                LinuxLibrary.stopKeyListener(this);
            } else {
                SolarisLibrary.stopKeyListener(this);
            }
            try {
                this.m_applianceSession.cmdFocusControl(false);
            }
            catch (IOException iOException) {
                Trace.logError((String)TRACE_CONTEXT, (String)"JToolbarDSViewer.jButtonFullScreen_actionPerformed", (Throwable)iOException);
            }
        }
        this.m_bSingleCursorModeCurrentlyActive = this.m_applianceSession.getApplianceWindow().isSingleCursorActive();
        if (OS.isLinux() || OS.isSolaris()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameFullScreen.fullScreenToggle OS is Linux");
            this.setLinuxKeyboardPassThru(false, this);
            this.b_KeyboardPassThruDeactivate = true;
            this.m_appliancePanel.ignoreVideoData(true);
            boolean bl = false;
            try {
                ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
                if (applianceSessionInfo.getPanedWidth() != this.m_nOrigPanelWidth || applianceSessionInfo.getPanedHeight() != this.m_nOrigPanelHeight || applianceSessionInfo.getDecimationFactor() != this.m_nOrigPanelDecimationFactor) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameFullScreen.fullScreenToggle going to set OrigPanelWidth=" + this.m_nOrigPanelWidth + " OrigPanelHeight=" + this.m_nOrigPanelHeight + " OrigPanelDecimationFactor=" + this.m_nOrigPanelDecimationFactor));
                    applianceSessionInfo.setPanedWidth((short)this.m_nOrigPanelWidth);
                    applianceSessionInfo.setPanedHeight((short)this.m_nOrigPanelHeight);
                    applianceSessionInfo.setDecimationFactor(this.m_nOrigPanelDecimationFactor);
                    bl = true;
                }
                applianceSessionInfo.setFullScale(this.m_bOrigFullScale);
                applianceSessionInfo.setAutoScale(this.m_bOrigAutoScale);
                this.m_applianceSession.setPersistentData(applianceSessionInfo);
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            }
            new JFrameViewer(this.m_appliancePanel, this.m_applianceSession, this.m_gcOrig, this.m_ptOrigLocation, this.m_sizeOrigFrame, this.m_bUseNativeJavaKeyCodes, bl, this.m_bSingleCursorModeCurrentlyActive);
        } else {
            this.m_frameViewer.restoreNormalWindowMode();
        }
        this.setVisible(false);
        if (this.m_toolbar != null) {
            this.m_toolbar.setVisible(false);
            this.m_layeredPane.remove(this.m_toolbar);
            this.m_toolbar.terminate();
            this.m_toolbar = null;
        }
        this.m_applianceSession = null;
        this.m_appliancePanel = null;
        this.dispose();
    }

    public boolean activateMenu() {
        boolean bl = false;
        try {
            if (!this.m_bAltKeyPressed && !this.m_bKeyboardHooked) {
                if (LinuxLibrary.isLibraryLoaded()) {
                    this.setLinuxKeyboardPassThru(false, this);
                } else if (SolarisLibrary.isLibraryLoaded()) {
                    this.setSolarisKeyboardPassThru(false, this);
                }
                this.m_toolbar.activateMenu();
                bl = true;
            }
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
        return bl;
    }

    public void resizeVideoWindow(int n, int n2) {
        this.resizeVideoWindow(n, n2, true);
    }

    public void resizeVideoWindow(int n, int n2, boolean bl) {
        if (this.m_applianceSession == null) {
            return;
        }
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        this.initWindow(this.m_applianceSession, 0, 0, (short)n, (short)n2, applianceSessionInfo.getVideoWidth(), applianceSessionInfo.getVideoHeight(), 1, bl);
        try {
            applianceSessionInfo.setPanedWidth((short)n);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"persistent data error", (Throwable)exception);
        }
        try {
            applianceSessionInfo.setPanedHeight((short)n2);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"persistent data error", (Throwable)exception);
        }
        if (this.m_applianceSession != null) {
            this.m_applianceSession.setPersistentData(applianceSessionInfo);
        } else {
            applianceSessionInfo.terminate();
        }
    }

    public Frame getFrameWindow() {
        return this;
    }

    void setKeyboardLocks() {
        if (this.m_bWin32LibraryLoaded) {
            try {
                this.m_applianceSession.cmdCapsLockSet(this.m_libWin32.isCapsLockSet());
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)TRACE_CONTEXT, (String)("(JWindowFullScreen setKeyboardLocks)" + exceptionRequestFailed.getMessage()), (Throwable)exceptionRequestFailed);
            }
        } else if (!OS.isLinux() && !OS.isSolaris()) {
            try {
                this.m_applianceSession.cmdCapsLockSet(Toolkit.getDefaultToolkit().getLockingKeyState(20));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Trace.logError((String)TRACE_CONTEXT, (String)"getLockingKeyState caps lock error", (Throwable)unsupportedOperationException);
            }
        }
        if (this.m_bWin32LibraryLoaded) {
            try {
                this.m_applianceSession.cmdNumLockSet(this.m_libWin32.isNumLockSet());
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)TRACE_CONTEXT, (String)("(JWindowFullScreen setKeyboardLocks)" + exceptionRequestFailed.getMessage()), (Throwable)exceptionRequestFailed);
            }
        } else if (!OS.isLinux() && !OS.isSolaris()) {
            try {
                this.m_applianceSession.cmdNumLockSet(Toolkit.getDefaultToolkit().getLockingKeyState(144));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Trace.logError((String)TRACE_CONTEXT, (String)"getLockingKeyState num-lock error", (Throwable)unsupportedOperationException);
            }
        }
        if (this.m_bWin32LibraryLoaded) {
            try {
                this.m_applianceSession.cmdScrollLockSet(this.m_libWin32.isScrollLockSet());
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)TRACE_CONTEXT, (String)("(JWindowFullScreen setKeyboardLocks)" + exceptionRequestFailed.getMessage()), (Throwable)exceptionRequestFailed);
            }
        } else if (!OS.isLinux() && !OS.isSolaris()) {
            try {
                this.m_applianceSession.cmdScrollLockSet(Toolkit.getDefaultToolkit().getLockingKeyState(145));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                Trace.logError((String)TRACE_CONTEXT, (String)"getLockingKeyState scroll lock error", (Throwable)unsupportedOperationException);
            }
        }
        if (this.m_bWin32LibraryLoaded) {
            try {
                this.m_applianceSession.cmdKanaLockSet(this.m_libWin32.isKanaLockSet());
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)TRACE_CONTEXT, (String)("(JWindowFullScreen setKeyboardLocks)" + exceptionRequestFailed.getMessage()), (Throwable)exceptionRequestFailed);
            }
        } else if (!OS.isLinux() && !OS.isSolaris()) {
            try {
                this.m_applianceSession.cmdKanaLockSet(Toolkit.getDefaultToolkit().getLockingKeyState(262));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    public void notifyMouseWheel(short s, short s2, long l, long l2) {
        if (this.m_appliancePanel != null) {
            this.m_appliancePanel.mouseScrollNotify(s, s2, l, l2);
        }
    }

    public void notifyKeyPressedLinux(short s, int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameFullScreen.notifyKeyPressedLinux sScanCode:" + s + " nKeyState=" + n));
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        this.m_applianceSession.cmdNumLockSet(bl);
        this.m_applianceSession.cmdCapsLockSet(bl2);
        this.notifyKeyPressed(s);
    }

    public void notifyKeyPressed(short s) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JWindowFullScreen.notifyKeyPressed sScanCode:" + s));
        if (this.b_ignorekey) {
            return;
        }
        if (SolarisLibrary.isLibraryLoaded()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JWindowFullScreen.notifyKeyPressed Solaris KeyPress sScanCode:" + s));
            this.m_applianceSession.cmdKeyPressed(s + 1);
            if (s + 1 == 83 || s + 1 == 57) {
                this.m_applianceSession.cmdKeyReleased(s + 1);
            }
            return;
        }
        if (LinuxLibrary.isLibraryLoaded() && !this.m_bProcessingGeneratedKeyPress) {
            this.m_vKeyPressedList.addElement(new Short(s));
        }
        if (!this.m_bKeyboardHooked) {
            if (s == 56 || s == 105) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JWindowFullScreen.notifyKeyPressed ALT key pressed");
                this.m_bAltKeyPressed = true;
                this.m_bAltKeyReleaseOnTabOrEscSent = false;
            } else if (s == 29 || s == 101) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JWindowFullScreen.notifyKeyPressed CTRL key pressed");
                this.m_bCtrlKeyPressed = true;
                this.m_bCtrlKeyReleaseOnEscSent = false;
            }
        }
        this.m_applianceSession.cmdScanCodeKeyPressed(s);
    }

    public void notifyKeyReleased(short s) {
        Object object;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JWindowFullScreen.notifyKeyReleased sScanCode:" + s));
        this.m_bWindowNotActiveCheckAltKey = false;
        if (SolarisLibrary.isLibraryLoaded()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JWindowFullScreen.notifyKeyReleased Solaris KeyRelease sScanCode:" + s));
            if (s + 1 == 83 || s + 1 == 57) {
                this.m_applianceSession.cmdKeyPressed(s + 1);
            }
            this.m_applianceSession.cmdKeyReleased(s + 1);
            return;
        }
        if (LinuxLibrary.isLibraryLoaded()) {
            object = this.getKeyPressForScanCode(s);
            if (object == null && s != 28 && s != 57 && s != 1) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("Generating missing key press for sScanCode:" + s));
                this.m_bProcessingGeneratedKeyPress = true;
                this.notifyKeyPressed(s);
                this.m_bProcessingGeneratedKeyPress = false;
            } else {
                this.m_vKeyPressedList.removeElement(object);
            }
        }
        if (!this.m_bKeyboardHooked) {
            if (s == 56 || s == 105) {
                if (!this.m_bAltKeyReleaseOnTabOrEscSent) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased sending ALT key released then pressed/released pair");
                    object = new Thread(new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            Trace.logInfo((String)JFrameFullScreen.TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased Check if window deactivated recently.");
                            if (JFrameFullScreen.this.m_bWindowNotActiveCheckAltKey && !SolarisLibrary.isLibraryLoaded() && !LinuxLibrary.isLibraryLoaded() && !JFrameFullScreen.this.m_bWin32LibraryLoaded) {
                                JFrameFullScreen.this.m_applianceSession.cmdKeyPressed(226, true);
                                JFrameFullScreen.this.m_applianceSession.cmdKeyPressed(226, true);
                                JFrameFullScreen.this.m_applianceSession.cmdKeyReleased(226, true);
                            }
                            JFrameFullScreen.this.m_bWindowNotActiveCheckAltKey = false;
                        }
                    });
                    ((Thread)object).start();
                }
                this.m_bAltKeyPressed = false;
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JWindowFullScreen.notifyKeyReleased ALT key released");
                this.m_bAltKeyReleaseOnTabOrEscSent = false;
            } else if (s == 29 || s == 101) {
                this.m_bCtrlKeyPressed = false;
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JWindowFullScreen.notifyKeyReleased CTRL key released");
                this.m_bCtrlKeyReleaseOnEscSent = false;
            }
            object = this.m_applianceSession.getPersistentDataReference();
            boolean bl = true;
            if (OS.isLinux()) {
                if (!LinuxLibrary.isLibraryLoaded()) {
                    bl = false;
                }
            } else if (OS.isSolaris() && !SolarisLibrary.isLibraryLoaded()) {
                bl = false;
            }
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JWindowFullScreen.notifyKeyReleased m_bKeyboardPassThruActive=" + bl));
            if (!bl && this.m_bAltKeyPressed && (s == 15 || s == 1)) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JWindowFullScreen.notifyKeyReleased TAB or ESC key released with ALT down");
                if (!this.m_bAltKeyReleaseOnTabOrEscSent) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"JWindowFullScreen.notifyKeyReleased sending ALT key released then pressed/released pair");
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            JFrameFullScreen.this.m_applianceSession.cmdKeyReleased(226, true);
                            JFrameFullScreen.this.m_applianceSession.cmdKeyPressed(226, true);
                            JFrameFullScreen.this.m_applianceSession.cmdKeyReleased(226, true);
                        }
                    });
                    thread.start();
                    this.m_bAltKeyReleaseOnTabOrEscSent = true;
                }
                return;
            }
            if (this.m_bCtrlKeyPressed && s == 1) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JWindowFullScreen.notifyKeyReleased ESC key released with CTRL down");
                if (!this.m_bCtrlKeyReleaseOnEscSent) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"JWindowFullScreen.notifyKeyReleased sending CTRL key released");
                    this.m_applianceSession.cmdKeyReleased(224, true);
                    this.m_bCtrlKeyReleaseOnEscSent = true;
                }
                return;
            }
        }
        this.m_applianceSession.cmdScanKeyReleased(s);
    }

    public void notifySingleCursorMouseMoved(short s, int n, int n2, short s2) {
        this.m_appliancePanel.singleCursorModeMouseNotify(s, s2, n, n2);
    }

    public void notifySingleCursorDeactivated() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameFullScreen.notifySingleCursorDeactivated");
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ApplianceSessionInfo applianceSessionInfo = JFrameFullScreen.this.m_applianceSession.getPersistentDataReference();
                JFrameFullScreen.this.m_appliancePanel.setLocalCursorType(applianceSessionInfo.getLocalCursorType());
                try {
                    JFrameFullScreen.this.m_applianceSession.cmdMouseAlign();
                }
                catch (IOException iOException) {
                    Trace.logError((String)JFrameFullScreen.TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
                }
                JFrameFullScreen.this.m_bSingleCursorModeActive = false;
                JFrameFullScreen.this.initToolbar(JFrameFullScreen.this.m_applianceSession);
                if (JFrameFullScreen.this.m_panelColorFiller != null) {
                    JFrameFullScreen.this.m_panelColorFiller.repaint();
                }
                JFrameFullScreen.this.m_appliancePanel.repaint();
            }
        });
        thread.start();
    }

    public void notifyMouseXButtonPressed(short s, int n, int n2) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameFullScreen.notifyMouseXButtonPressed");
        this.m_appliancePanel.mouseXButtonNotify(s, (short)0, n, n2);
    }

    public void listeningWindowDeactivated() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JWindowFullScreen.listeningWindowDeactivated");
        if (this.m_bAltKeyPressed) {
            this.m_bAltKeyPressed = false;
            if (!this.m_bAltKeyReleaseOnTabOrEscSent) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JWindowFullScreen.listeningWindowDeactivated sending ALT key released then pressed/released pair");
                this.m_applianceSession.cmdKeyReleased(226, true);
                this.m_applianceSession.cmdKeyPressed(226, true);
                this.m_applianceSession.cmdKeyReleased(226, true);
                this.m_bAltKeyReleaseOnTabOrEscSent = true;
            }
        }
    }

    public void setLinuxKeyboardPassThru(boolean bl, Component component) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("LinuxLibrary.setKeyboardPassThru:" + bl));
        if (this.b_KeyListenerActivated) {
            try {
                LinuxLibrary.setKeyboardPassThru(bl, component);
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)("Exception:" + exception.getMessage()), (Throwable)exception);
            }
        }
    }

    public void setSolarisKeyboardPassThru(boolean bl, Component component) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("SolarisLibrary.setKeyboardPassThru:" + bl));
        if (this.b_KeyListenerActivated) {
            try {
                SolarisLibrary.setKeyboardPassThru(bl, component);
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)("Exception:" + exception.getMessage()), (Throwable)exception);
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.m_bWin32LibraryLoaded) {
            try {
                this.m_nHWND = this.m_libWin32.getHWND(this);
                this.setMouseWheelHook(this.m_nHWND, this);
                this.m_libWin32.processWindowsMessages(true);
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)("JWindowFullScreen.addNotify exception on setMouseWheelHook " + exception.getMessage()), (Throwable)exception);
            }
        } else if (LinuxLibrary.isLibraryLoaded()) {
            this.setVisible(true);
            LinuxLibrary.registerNativeKeyListener(this, this);
            this.b_KeyListenerActivated = true;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.setLinuxKeyboardPassThru(true, this);
        } else if (SolarisLibrary.isLibraryLoaded()) {
            this.setVisible(true);
            SolarisLibrary.registerNativeKeyListener(this, this);
            this.b_KeyListenerActivated = true;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.setSolarisKeyboardPassThru(true, this);
        }
    }

    public void removeNotify() {
        if (this.m_bWin32LibraryLoaded) {
            try {
                this.resetMouseWheelHook(this.m_nHWND, this);
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)("JWindowFullScreen.removeNotify exception on removeMouseWheelHook " + exception.getMessage()), (Throwable)exception);
            }
        } else if (LinuxLibrary.isLibraryLoaded()) {
            if (!this.b_KeyboardPassThruDeactivate) {
                this.setLinuxKeyboardPassThru(false, this);
            }
            this.b_KeyListenerActivated = false;
            LinuxLibrary.unregisterNativeKeyListener(this, this);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        } else if (SolarisLibrary.isLibraryLoaded()) {
            if (!this.b_KeyboardPassThruDeactivate) {
                this.setSolarisKeyboardPassThru(false, this);
            }
            this.b_KeyListenerActivated = false;
            SolarisLibrary.unregisterNativeKeyListener(this, this);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        super.removeNotify();
    }

    public Dimension inquireNewSize(Dimension dimension) {
        return dimension;
    }

    public void setNewSize(Rectangle rectangle) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JWindowFullScreen setNewSize) rNewBounds:" + rectangle.getLocation().getX() + " " + rectangle.getLocation().getY() + " " + rectangle.getWidth() + " " + rectangle.getHeight()));
    }

    private void resetMouseWheelHook(int n, Window window) {
        if (!this.m_bUseNativeJavaKeyCodes) {
            this.m_libWin32.resetMouseWheelHook(n, window);
        }
    }

    private void setMouseWheelHook(int n, Window window) {
        if (!this.m_bUseNativeJavaKeyCodes) {
            this.m_libWin32.setMouseWheelHook(n, window);
        }
    }

    public boolean closeWindow() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JWindowFullScreen.closeWindow");
        if (this.m_applianceSession.getApplianceWindow() == this) {
            int n;
            if (this.m_applianceSession.isLockedMode() && !this.m_applianceSession.isReserveModeActive() && (n = JOptionPane.showConfirmDialog(this, RES.getString("JFrameFullScreen_DO_YOU_WANT_TO_CLOSE_THIS_SESSION_LOCK_WARNING"), RES.getString("JFrameFullScreen_CLOSE_SESSION_REQUESTED"), 0, 3)) != 0) {
                return false;
            }
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JWindowFullScreen.closeWindow m_applianceSession.getApplianceWindow == this");
            this.terminateSession();
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JWindowFullScreen.closeWindow m_applianceSession.getApplianceWindow != this");
        }
        return true;
    }

    private boolean didUserConfirmOnClose() {
        int n;
        boolean bl = true;
        if (this.m_applianceSession.isLockedMode() && !this.m_applianceSession.isReserveModeActive() && (n = JOptionPane.showConfirmDialog(this, RES.getString("JFrameFullScreen_DO_YOU_WANT_TO_CLOSE_THIS_SESSION_LOCK_WARNING"), RES.getString("JFrameFullScreen_CLOSE_SESSION_REQUESTED"), 0, 3)) != 0) {
            bl = false;
        }
        return bl;
    }

    Short getKeyPressForScanCode(short s) {
        Short s2 = null;
        for (int i = 0; i < this.m_vKeyPressedList.size(); ++i) {
            Short s3 = (Short)this.m_vKeyPressedList.elementAt(i);
            if (s3 != s) continue;
            s2 = s3;
            break;
        }
        return s2;
    }

    public Component getViewComponent() {
        return this;
    }

    public void suspendNativeKeyListeners() {
        if (this.m_bWin32LibraryLoaded) {
            try {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"Macros combo box selected, resetting Win32 mouse wheel hook");
                if (!this.m_bUseNativeJavaKeyCodes) {
                    this.m_libWin32.processWindowsMessages(false);
                }
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)("Exception on removeMouseWheelHook " + exception.getMessage()), (Throwable)exception);
            }
        } else if (LinuxLibrary.isLibraryLoaded()) {
            LinuxLibrary.stopKeyListener(this);
        } else if (SolarisLibrary.isLibraryLoaded()) {
            SolarisLibrary.stopKeyListener(this);
        }
        try {
            this.m_applianceSession.cmdFocusControl(false);
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
        }
    }

    public void resumeNativeKeyListeners() {
        try {
            this.m_applianceSession.cmdFocusControl(true);
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
        }
        if (this.m_bWin32LibraryLoaded) {
            try {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"Macros combo box closed, setting Win32 mouse wheel hook");
                if (!this.m_bUseNativeJavaKeyCodes) {
                    this.m_libWin32.processWindowsMessages(true);
                }
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)("Exception on setMouseWheelHook " + exception.getMessage()), (Throwable)exception);
            }
        } else if (LinuxLibrary.isLibraryLoaded()) {
            LinuxLibrary.startKeyListener(this);
        } else if (SolarisLibrary.isLibraryLoaded()) {
            SolarisLibrary.startKeyListener(this);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int access$800(JFrameFullScreen jFrameFullScreen) {
        return jFrameFullScreen.m_nHWND;
    }

    static /* synthetic */ Win32Library access$900(JFrameFullScreen jFrameFullScreen) {
        return jFrameFullScreen.m_libWin32;
    }

    private class ApplianceWindowListener
    implements WindowListener {
        private ApplianceWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Trace.logInfo((String)JFrameFullScreen.TRACE_CONTEXT, (String)"JWindowFullScreen.windowClosing");
            if (JFrameFullScreen.this.m_applianceSession != null) {
                if (JFrameFullScreen.this.m_applianceSession.getApplianceWindow() == JFrameFullScreen.this) {
                    Trace.logInfo((String)JFrameFullScreen.TRACE_CONTEXT, (String)"JWindowFullScreen.windowClosing m_applianceSession.getApplianceWindow == this");
                    if (JFrameFullScreen.this.didUserConfirmOnClose()) {
                        JFrameFullScreen.this.terminateSession();
                    }
                } else {
                    Trace.logInfo((String)JFrameFullScreen.TRACE_CONTEXT, (String)"JWindowFullScreen.windowClosing m_applianceSession.getApplianceWindow != this");
                }
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
            Trace.logInfo((String)JFrameFullScreen.TRACE_CONTEXT, (String)"(JWindowFullScreen windowActivated)");
            if (JFrameFullScreen.this.m_appliancePanel != null) {
                JFrameFullScreen.this.m_appliancePanel.setVideoQueueSleepTimeActivated();
                JFrameFullScreen.this.setKeyboardLocks();
                if (LinuxLibrary.isLibraryLoaded()) {
                    JFrameFullScreen.this.setLinuxKeyboardPassThru(true, JFrameFullScreen.this);
                } else if (SolarisLibrary.isLibraryLoaded()) {
                    JFrameFullScreen.this.setSolarisKeyboardPassThru(true, JFrameFullScreen.this);
                }
                JFrameFullScreen.this.b_ignorekey = false;
                if (Win32Library.isWin32LibLoaded()) {
                    Thread thread = new Thread(new Runnable(this){
                        private final /* synthetic */ ApplianceWindowListener this$1;
                        {
                            this.this$1 = applianceWindowListener;
                        }

                        public void run() {
                            JFrameFullScreen.access$900(ApplianceWindowListener.access$700(this.this$1)).setLowLevelKeyboardHook(JFrameFullScreen.access$800(ApplianceWindowListener.access$700(this.this$1)), false);
                            JFrameFullScreen.access$1002(ApplianceWindowListener.access$700(this.this$1), true);
                        }
                    });
                    thread.start();
                    int n = 50;
                    while (!JFrameFullScreen.this.m_bKeyboardHooked && n-- > 0) {
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (!JFrameFullScreen.this.m_bKeyboardHooked) {
                        Trace.logError((String)JFrameFullScreen.TRACE_CONTEXT, (String)"m_libWin32.setLowLevelKeyboardHook never returned");
                    }
                }
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            Trace.logInfo((String)JFrameFullScreen.TRACE_CONTEXT, (String)"(JWindowFullScreen ApplianceWindowListener windowClosed)");
            if (JFrameFullScreen.this.m_bKeyboardHooked) {
                Thread thread = new Thread(new Runnable(this){
                    private final /* synthetic */ ApplianceWindowListener this$1;
                    {
                        this.this$1 = applianceWindowListener;
                    }

                    public void run() {
                        JFrameFullScreen.access$900(ApplianceWindowListener.access$700(this.this$1)).resetLowLevelKeyboardHook();
                    }
                });
                thread.start();
                JFrameFullScreen.this.m_bKeyboardHooked = false;
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            Trace.logInfo((String)JFrameFullScreen.TRACE_CONTEXT, (String)"(JWindowFullScreen windowDeactivated)");
            JFrameFullScreen.this.m_bWindowNotActiveCheckAltKey = true;
            if (JFrameFullScreen.this.m_bKeyboardHooked) {
                Thread thread = new Thread(new Runnable(this){
                    private final /* synthetic */ ApplianceWindowListener this$1;
                    {
                        this.this$1 = applianceWindowListener;
                    }

                    public void run() {
                        JFrameFullScreen.access$900(ApplianceWindowListener.access$700(this.this$1)).resetLowLevelKeyboardHook();
                        JFrameFullScreen.access$1002(ApplianceWindowListener.access$700(this.this$1), false);
                    }
                });
                thread.start();
                int n = 50;
                while (JFrameFullScreen.this.m_bKeyboardHooked && n-- > 0) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (JFrameFullScreen.this.m_bKeyboardHooked) {
                    Trace.logError((String)JFrameFullScreen.TRACE_CONTEXT, (String)"m_libWin32.resetLowLevelKeyboardHook never returned");
                }
                JFrameFullScreen.this.m_bKeyboardHooked = false;
            }
            if (LinuxLibrary.isLibraryLoaded()) {
                JFrameFullScreen.this.setLinuxKeyboardPassThru(false, JFrameFullScreen.this);
            } else if (SolarisLibrary.isLibraryLoaded()) {
                JFrameFullScreen.this.setSolarisKeyboardPassThru(false, JFrameFullScreen.this);
            }
            JFrameFullScreen.this.b_ignorekey = true;
            JFrameFullScreen.this.activateSingleCursorMode(false);
            JFrameFullScreen.this.m_frameViewer.activateSingleCursorMode(JFrameFullScreen.this.m_bSingleCursorModeCurrentlyActive);
            JFrameFullScreen.this.m_bSingleCursorModeCurrentlyActive = false;
            if (JFrameFullScreen.this.m_appliancePanel != null) {
                JFrameFullScreen.this.m_appliancePanel.setVideoQueueSleepTimeDeactivated();
            }
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        static /* synthetic */ JFrameFullScreen access$700(ApplianceWindowListener applianceWindowListener) {
            return applianceWindowListener.JFrameFullScreen.this;
        }
    }
}

