/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.JDialogLogin;
import com.avocent.lib.gui.dialogs.JOptionPaneFixedSize;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.interfaces.InterfaceViewer3;
import com.avocent.lib.util.CachedCredentials;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.UsernamePassword;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.DSPath;
import com.avocent.video.JDialogThumbnailOptions;
import com.avocent.video.JPanelApplianceThumbnailTitle;
import com.avocent.video.LinuxLibrary;
import com.avocent.video.PanelToolbarThumbnail;
import com.avocent.video.PersistentStorage;
import com.avocent.video.SessionManager;
import com.avocent.video.SolarisLibrary;
import com.avocent.video.ThreadScan;
import com.avocent.video.Win32Library;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.util.Properties;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;

public class JFrameThumbnail
extends JFrame {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    public static final String CNAME = "JFrameThumbnail";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    private static final int SPACING_LEFT = 2;
    private static final int SPACING_TOP = 2;
    private static final int SPACING_HORZ = 10;
    private static final int SPACING_VERT = 10;
    JPanel jPanelThumbnails = new JPanel();
    PanelToolbarThumbnail m_toolbar;
    boolean m_bIsAlive = true;
    boolean m_bClosing = false;
    JPanelApplianceThumbnailTitle[] m_appliancePanels;
    ThreadScan m_threadScan;
    int m_nSecondsPerServer = 0;
    int m_nSecondsBetweenServers = 0;
    InterfaceViewer3 m_iFaceViewer;
    UsernamePassword m_userCredentials;
    private boolean m_bScanPaused = false;
    private int m_nCurrentPanel = 0;
    private int m_nThumbnailSize = 0;
    private Win32Library m_libWin32;
    private boolean m_bWin32LibraryLoaded = false;
    static Boolean m_bModalDlgRequest = new Boolean(false);
    public static Vector m_vJFrameThumbnailList = new Vector();
    private String m_szServerMenuToDisable = null;
    private String m_szHelpURL;
    private JLayeredPane m_layeredPane;
    private ApplianceSessionInfo m_sessionInfo;
    private int m_nApplication = 0;
    private Properties m_propertiesLaunchArgs;
    private JScrollPane m_scrollPane;
    static /* synthetic */ Class class$com$avocent$video$JFrameViewer;

    public JFrameThumbnail(String string, String string2, String string3, String string4, Vector vector, int n, Properties properties, String string5) {
        this(null, string, string2, string3, string4, vector, n, properties, string5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JFrameThumbnail(Frame frame, String string, String string2, String string3, String string4, Vector vector, int n, Properties properties, String string5) {
        Vector vector2;
        int n2;
        Object object;
        SessionManager.addSession(this);
        try {
            this.m_libWin32 = new Win32Library();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Trace.logError((String)TRACE_CONTEXT, (String)unsatisfiedLinkError.getMessage(), (Throwable)unsatisfiedLinkError);
        }
        JFrameThumbnail jFrameThumbnail = this;
        this.m_bWin32LibraryLoaded = jFrameThumbnail.m_libWin32.isWin32LibLoaded();
        Vector vector3 = new Vector(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            vector3.add(vector.get(i));
        }
        Vector vector4 = this.separatePathsByServerName(vector3);
        this.m_nApplication = n;
        this.m_propertiesLaunchArgs = properties;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail constructor m_nApplication=" + this.m_nApplication));
        this.m_szHelpURL = string5;
        if (vector4.size() > 16) {
            Message.show((Component)this, (String)RES.getString("JFrameThumbnail_Too_Many_Thumbnails"));
            while (vector4.size() > 16) {
                vector4.remove(16);
            }
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (string4.length() == 0) {
            object = new PersistentStorage();
            this.m_iFaceViewer = object;
        } else {
            try {
                object = Class.forName(string4);
                this.m_iFaceViewer = (InterfaceViewer3)((Class)object).newInstance();
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Bad szIFaceViewer", (Throwable)exception);
            }
        }
        this.m_sessionInfo = new ApplianceSessionInfo(this.m_iFaceViewer);
        this.m_nSecondsPerServer = this.m_sessionInfo.getThumbnailViewTimePerServer();
        this.m_nSecondsBetweenServers = this.m_sessionInfo.getThumbnailTimeBetweenServers();
        if (this.m_nSecondsPerServer < 10) {
            this.m_nSecondsPerServer = 10;
        }
        if (this.m_nSecondsBetweenServers < 5) {
            this.m_nSecondsBetweenServers = 5;
        }
        object = new ImageIcon((class$com$avocent$video$JFrameViewer == null ? (class$com$avocent$video$JFrameViewer = JFrameThumbnail.class$("com.avocent.video.JFrameViewer")) : class$com$avocent$video$JFrameViewer).getResource("images/connectvideo16.gif"));
        this.setIconImage(((ImageIcon)object).getImage());
        boolean bl = false;
        switch (vector4.size()) {
            case 0: {
                Message.show((Component)this, (String)RES.getString("JFrameThumbnail_No_Thumbnail_Paths"));
                this.dispose();
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.m_nThumbnailSize = 11;
                bl = true;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.m_nThumbnailSize = 8;
                bl = true;
                break;
            }
            default: {
                this.m_nThumbnailSize = 8;
                bl = true;
            }
        }
        this.m_userCredentials = new UsernamePassword(string2, string3);
        boolean bl2 = false;
        block20: for (n2 = 0; n2 < vector4.size(); ++n2) {
            if (bl2) continue;
            vector2 = (Vector)vector4.get(n2);
            for (int i = 0; i < vector2.size(); ++i) {
                DSPath dSPath = (DSPath)vector2.get(i);
                Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail constructor path=" + dSPath.toString() + " path.getUCC=" + dSPath.getUCC()));
                if (!dSPath.getUCC()) continue;
                Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail constructor path.getUCC true, path=" + dSPath.toString()));
                bl2 = true;
                continue block20;
            }
        }
        if (string2.length() == 0 || !bl2) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail constructor szUser.length=" + string2.length() + " bUCC=" + bl2));
            try {
                Boolean bl3 = m_bModalDlgRequest;
                synchronized (bl3) {
                    vector2 = new JDialogLogin(frame, RES.getString("JFrameThumbnail_Login"), this.m_userCredentials);
                    vector2.setModal(true);
                    vector2.setVisible(true);
                    if (vector2.wasOkPressed()) {
                        if (bl2) {
                            CachedCredentials.setCredentials((UsernamePassword)this.m_userCredentials);
                        }
                    } else {
                        this.dispose();
                        return;
                    }
                }
            }
            catch (ExceptionConstructorFailed exceptionConstructorFailed) {
                Trace.logError((String)TRACE_CONTEXT, (String)exceptionConstructorFailed.getMessage(), (Throwable)exceptionConstructorFailed);
            }
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail constructor vvDSPaths.size=" + vector4.size()));
        this.m_appliancePanels = new JPanelApplianceThumbnailTitle[vector4.size()];
        for (n2 = 0; n2 < vector4.size(); ++n2) {
            this.m_appliancePanels[n2] = new JPanelApplianceThumbnailTitle((Vector)vector4.get(n2), string4, this.m_userCredentials, bl, this.m_nThumbnailSize, this.m_nSecondsPerServer, this, this.m_nApplication, this.m_propertiesLaunchArgs, this.m_szHelpURL);
            this.jPanelThumbnails.add(this.m_appliancePanels[n2]);
            this.m_appliancePanels[n2].init();
        }
        this.setVisible(true);
        this.setSizeAndLocationOfPanels(vector4.size());
        this.m_threadScan = new ThreadScan(this);
        if (string == null || string.length() == 0) {
            this.setTitle(RES.getString("JFrameThumbnail_SCANVIEW_TITLE"));
        } else {
            this.setTitle(string);
        }
        try {
            this.m_iFaceViewer.registerWindow((Window)this, this.getTitle(), 8);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
        this.setVisible(true);
        m_vJFrameThumbnailList.addElement(this);
        this.logEventStartScan();
    }

    public JFrameThumbnail(Frame frame, String string, InterfaceViewer3 interfaceViewer3, Vector vector, int n, Properties properties, String string2) {
        this.m_iFaceViewer = interfaceViewer3;
        SessionManager.addSession(this);
        try {
            this.m_libWin32 = new Win32Library();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Trace.logError((String)TRACE_CONTEXT, (String)unsatisfiedLinkError.getMessage(), (Throwable)unsatisfiedLinkError);
        }
        JFrameThumbnail jFrameThumbnail = this;
        this.m_bWin32LibraryLoaded = jFrameThumbnail.m_libWin32.isWin32LibLoaded();
        this.m_nApplication = n;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail constructor m_nApplication=" + this.m_nApplication));
        this.m_propertiesLaunchArgs = properties;
        this.m_szHelpURL = string2;
        if (vector.size() > 16) {
            Message.show((Component)this, (String)RES.getString("JFrameThumbnail_Too_Many_Thumbnails"));
            while (vector.size() > 16) {
                vector.remove(16);
            }
        }
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_sessionInfo = new ApplianceSessionInfo(this.m_iFaceViewer);
        this.m_nSecondsPerServer = this.m_sessionInfo.getThumbnailViewTimePerServer();
        this.m_nSecondsBetweenServers = this.m_sessionInfo.getThumbnailTimeBetweenServers();
        if (this.m_nSecondsPerServer < 10) {
            this.m_nSecondsPerServer = 10;
        }
        if (this.m_nSecondsBetweenServers < 5) {
            this.m_nSecondsBetweenServers = 5;
        }
        ImageIcon imageIcon = new ImageIcon((class$com$avocent$video$JFrameViewer == null ? (class$com$avocent$video$JFrameViewer = JFrameThumbnail.class$("com.avocent.video.JFrameViewer")) : class$com$avocent$video$JFrameViewer).getResource("images/connectvideo16.gif"));
        this.setIconImage(imageIcon.getImage());
        boolean bl = false;
        switch (vector.size()) {
            case 0: {
                Message.show((Component)this, (String)RES.getString("JFrameThumbnail_No_Thumbnail_Paths"));
                this.dispose();
                return;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.m_nThumbnailSize = 11;
                bl = true;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.m_nThumbnailSize = 8;
                bl = true;
                break;
            }
            default: {
                this.m_nThumbnailSize = 8;
                bl = true;
            }
        }
        this.m_appliancePanels = new JPanelApplianceThumbnailTitle[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.m_appliancePanels[i] = new JPanelApplianceThumbnailTitle((DSPath)vector.get(i), this.m_iFaceViewer, bl, this.m_nThumbnailSize, this.m_nSecondsPerServer, this, this.m_nApplication, this.m_propertiesLaunchArgs, this.m_szHelpURL);
            this.jPanelThumbnails.add(this.m_appliancePanels[i]);
            this.m_appliancePanels[i].init();
        }
        this.setVisible(true);
        this.setSizeAndLocationOfPanels(vector.size());
        this.m_threadScan = new ThreadScan(this);
        if (string == null || string.length() == 0) {
            this.setTitle(RES.getString("JFrameThumbnail_SCANVIEW_TITLE"));
        } else {
            this.setTitle(string);
        }
        this.setVisible(true);
        m_vJFrameThumbnailList.addElement(this);
        this.logEventStartScan();
    }

    public int getThumbnailSize() {
        return this.m_nThumbnailSize;
    }

    public Dimension inquireNewSize(Dimension dimension) {
        Insets insets = this.getInsets();
        Insets insets2 = this.m_scrollPane.getInsets();
        int n = (int)dimension.getWidth() - insets.left - insets.right - insets2.left - insets2.right;
        int n2 = (int)dimension.getHeight() - insets.top - insets.bottom - insets2.top - insets2.bottom;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("inquireNewSize(): nX:" + n + " nY:" + n2));
        Dimension dimension2 = new Dimension(n + insets.left + insets.right + insets2.left + insets2.right, n2 + insets.top + insets.bottom + insets2.top + insets2.bottom);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("inquireNewSize() returning X: " + dimension2.getWidth() + " Y:" + dimension2.getHeight()));
        this.pack();
        return dimension2;
    }

    public void setNewSize(Rectangle rectangle) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("setNewSize(): rNewBounds:" + rectangle.getLocation().getX() + " " + rectangle.getLocation().getY() + " " + rectangle.getWidth() + " " + rectangle.getHeight()));
        if (LinuxLibrary.isLibraryLoaded() || SolarisLibrary.isLibraryLoaded()) {
            this.setVisible(false);
        }
        Insets insets = this.getInsets();
        Insets insets2 = this.m_scrollPane.getInsets();
        int n = (int)rectangle.getWidth() - insets.left - insets.right - insets2.left - insets2.right;
        int n2 = (int)rectangle.getHeight() - insets.top - insets.bottom - insets2.top - insets2.bottom;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("setNewSize(): nX:" + n + " nY:" + n2));
        this.m_scrollPane.setBounds(0, 0, (int)(rectangle.getWidth() - (double)insets.left - (double)insets.right), (int)(rectangle.getHeight() - (double)insets.top - (double)insets.bottom));
        this.setBounds(rectangle);
        if (LinuxLibrary.isLibraryLoaded() || SolarisLibrary.isLibraryLoaded()) {
            this.setVisible(true);
        }
        if (this.getState() == 1) {
            this.setState(0);
        }
        this.pack();
        this.toFront();
    }

    public static Vector getJFrameThumbnailList() {
        return m_vJFrameThumbnailList;
    }

    public JPanelApplianceThumbnailTitle getCurrentConnectingThumbnail() {
        for (int i = 0; i < this.m_appliancePanels.length; ++i) {
            if (!this.m_appliancePanels[i].isConnecting()) continue;
            return this.m_appliancePanels[i];
        }
        return null;
    }

    public JPanelApplianceThumbnailTitle[] getThumbnailList() {
        return this.m_appliancePanels;
    }

    public Vector separatePathsByServerID(Vector vector) {
        Vector vector2 = new Vector();
        while (vector.size() > 0) {
            DSPath dSPath = (DSPath)vector.get(0);
            vector.remove(0);
            boolean bl = false;
            for (int i = 0; i < vector2.size(); ++i) {
                Vector vector3 = (Vector)vector2.get(i);
                DSPath dSPath2 = (DSPath)vector3.get(0);
                if (dSPath.getDeviceID().compareTo(dSPath2.getDeviceID()) != 0) continue;
                vector3.add(dSPath);
                bl = true;
                break;
            }
            if (bl) continue;
            Vector<DSPath> vector4 = new Vector<DSPath>(1);
            vector4.add(dSPath);
            vector2.add(vector4);
        }
        return vector2;
    }

    public Vector separatePathsByServerName(Vector vector) {
        Vector vector2 = new Vector();
        while (vector.size() > 0) {
            DSPath dSPath = (DSPath)vector.get(0);
            vector.remove(0);
            boolean bl = false;
            for (int i = 0; i < vector2.size(); ++i) {
                Vector vector3 = (Vector)vector2.get(i);
                DSPath dSPath2 = (DSPath)vector3.get(0);
                if (dSPath.getServerName().compareTo(dSPath2.getServerName()) != 0) continue;
                vector3.add(dSPath);
                bl = true;
                break;
            }
            if (bl) continue;
            Vector<DSPath> vector4 = new Vector<DSPath>(1);
            vector4.add(dSPath);
            vector2.add(vector4);
        }
        return vector2;
    }

    public void setSizeAndLocationOfPanels(int n) {
        Object object;
        Rectangle rectangle;
        Dimension dimension;
        Dimension dimension2 = this.m_appliancePanels[0].getSize();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail.setSizeAndLocationOfPanels appliancePanel Width:" + dimension2.getWidth() + "Height:" + dimension2.getHeight()));
        Insets insets = this.jPanelThumbnails.getInsets();
        switch (n) {
            case 1: {
                this.m_appliancePanels[0].setLocation(insets.left + 2, insets.top + 2);
                dimension = new Dimension(5 + (int)dimension2.getWidth() + insets.left + insets.right, 5 + (int)dimension2.getHeight() + insets.top + insets.bottom);
                break;
            }
            case 2: {
                this.m_appliancePanels[0].setLocation(insets.left + 2, insets.top + 2);
                this.m_appliancePanels[1].setLocation(insets.left + (int)dimension2.getWidth() + 2 + 10, insets.top + 2);
                dimension = new Dimension(5 + (int)dimension2.getWidth() * 2 + 10 + insets.left + insets.right, 5 + (int)dimension2.getHeight() + insets.top + insets.bottom);
                break;
            }
            case 3: 
            case 4: {
                int n2;
                int n3;
                for (n3 = 0; n3 < 2; ++n3) {
                    for (n2 = 0; n2 < 2; ++n2) {
                        if (n2 + n3 * 2 >= n) continue;
                        this.m_appliancePanels[n2 + n3 * 2].setLocation(insets.left + (int)dimension2.getWidth() * n2 + 2 + 10 * n2, insets.top + (int)dimension2.getHeight() * n3 + 2 + 10 * n3);
                    }
                }
                dimension = new Dimension(5 + (int)dimension2.getWidth() * 2 + 10 + insets.left + insets.right, 5 + (int)dimension2.getHeight() * 2 + 10 + insets.top + insets.bottom);
                break;
            }
            case 5: 
            case 6: {
                int n2;
                int n3;
                for (n3 = 0; n3 < 2; ++n3) {
                    for (n2 = 0; n2 < 3; ++n2) {
                        if (n2 + n3 * 3 >= n) continue;
                        this.m_appliancePanels[n2 + n3 * 3].setLocation(insets.left + (int)dimension2.getWidth() * n2 + 2 + 10 * n2, insets.top + (int)dimension2.getHeight() * n3 + 2 + 10 * n3);
                    }
                }
                dimension = new Dimension(5 + (int)dimension2.getWidth() * 3 + 20 + insets.left + insets.right, 5 + (int)dimension2.getHeight() * 2 + 10 + insets.top + insets.bottom);
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                int n2;
                int n3;
                for (n3 = 0; n3 < 3; ++n3) {
                    for (n2 = 0; n2 < 3; ++n2) {
                        if (n2 + n3 * 3 >= n) continue;
                        this.m_appliancePanels[n2 + n3 * 3].setLocation(insets.left + (int)dimension2.getWidth() * n2 + 2 + 10 * n2, insets.top + (int)dimension2.getHeight() * n3 + 2 + 10 * n3);
                    }
                }
                dimension = new Dimension(5 + (int)dimension2.getWidth() * 3 + 20 + insets.left + insets.right, 5 + (int)dimension2.getHeight() * 3 + 20 + insets.top + insets.bottom);
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                int n2;
                int n3;
                for (n3 = 0; n3 < 3; ++n3) {
                    for (n2 = 0; n2 < 4; ++n2) {
                        if (n2 + n3 * 4 >= n) continue;
                        this.m_appliancePanels[n2 + n3 * 4].setLocation(insets.left + (int)dimension2.getWidth() * n2 + 2 + 10 * n2, insets.top + (int)dimension2.getHeight() * n3 + 2 + 10 * n3);
                    }
                }
                dimension = new Dimension(5 + (int)dimension2.getWidth() * 4 + 30 + insets.left + insets.right, 5 + (int)dimension2.getHeight() * 3 + 20 + insets.top + insets.bottom);
                break;
            }
            default: {
                int n2;
                int n3;
                for (n3 = 0; n3 < 4; ++n3) {
                    for (n2 = 0; n2 < 4; ++n2) {
                        if (n2 + n3 * 4 >= n) continue;
                        this.m_appliancePanels[n2 + n3 * 4].setLocation(insets.left + (int)dimension2.getWidth() * n2 + 2 + 10 * n2, insets.top + (int)dimension2.getHeight() * n3 + 2 + 10 * n3);
                    }
                }
                dimension = new Dimension(5 + (int)dimension2.getWidth() * 4 + 30 + insets.left + insets.right, 5 + (int)dimension2.getHeight() * 4 + 30 + insets.top + insets.bottom);
            }
        }
        this.jPanelThumbnails.setSize(dimension);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail.setSizeAndLocationOfPanels sizePanelThumbnails Width:" + dimension.getWidth() + "Height:" + dimension.getHeight()));
        Insets insets2 = this.getInsets();
        Dimension dimension3 = new Dimension(4 + (int)dimension.getWidth() + insets2.left + insets2.right, 4 + (int)dimension.getHeight() + insets2.top + insets2.bottom);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail.setSizeAndLocationOfPanels sizeFrame Width:" + dimension3.getWidth() + "Height:" + dimension3.getHeight()));
        if (this.m_bWin32LibraryLoaded) {
            try {
                rectangle = this.m_libWin32.getDesktopWorkArea();
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                rectangle = new Rectangle(0, 0, (int)toolkit.getScreenSize().getWidth(), (int)toolkit.getScreenSize().getHeight());
            }
        } else {
            object = Toolkit.getDefaultToolkit();
            rectangle = new Rectangle(0, 0, (int)((Toolkit)object).getScreenSize().getWidth(), (int)((Toolkit)object).getScreenSize().getHeight());
        }
        object = dimension3;
        if (dimension3.getWidth() > rectangle.getWidth() && dimension3.getHeight() > rectangle.getHeight()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameThumbnail.setSizeAndLocationOfPanels sizeFrame > rScreen width and height");
            this.m_scrollPane.setHorizontalScrollBarPolicy(32);
            this.m_scrollPane.setVerticalScrollBarPolicy(22);
            object = new Dimension((int)rectangle.getWidth(), (int)rectangle.getHeight());
        } else if (dimension3.getWidth() > rectangle.getWidth()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameThumbnail.setSizeAndLocationOfPanels sizeFrame width > rScreen width");
            this.m_scrollPane.setHorizontalScrollBarPolicy(32);
            this.m_scrollPane.setVerticalScrollBarPolicy(21);
            object = new Dimension((int)rectangle.getWidth(), (int)rectangle.getHeight());
        } else if (dimension3.getHeight() > rectangle.getHeight()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameThumbnail.setSizeAndLocationOfPanels sizeFrame height > rScreen height");
            this.m_scrollPane.setHorizontalScrollBarPolicy(31);
            this.m_scrollPane.setVerticalScrollBarPolicy(22);
            object = new Dimension((int)dimension3.getWidth(), (int)rectangle.getWidth());
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameThumbnail.setSizeAndLocationOfPanels setting frame to sizeFrame");
            this.m_scrollPane.setHorizontalScrollBarPolicy(31);
            this.m_scrollPane.setVerticalScrollBarPolicy(21);
        }
        this.setSize((Dimension)object);
        this.validate();
        this.jPanelThumbnails.setPreferredSize(dimension);
        this.jPanelThumbnails.revalidate();
        this.m_scrollPane.setSize(this.m_layeredPane.getSize());
        this.m_scrollPane.validate();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail.setSizeAndLocationOfPanels sizePanelThumbnails Width:" + dimension.getWidth() + "Height:" + dimension.getHeight()));
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail.setSizeAndLocationOfPanels jPanelThumbnails Width:" + this.jPanelThumbnails.getSize().getWidth() + "Height:" + this.jPanelThumbnails.getSize().getHeight()));
        boolean bl = false;
        if (this.m_toolbar != null) {
            bl = this.m_toolbar.isToolbarLockedInPlace();
            this.m_layeredPane.remove(this.m_toolbar);
        }
        this.m_toolbar = new PanelToolbarThumbnail(((Dimension)object).width / 2, 0, ((Dimension)object).width, this, this.m_appliancePanels, "", bl, false, this.m_sessionInfo.getToolbarHideDelay(), this.m_nApplication);
        this.m_layeredPane.setLayer(this.m_toolbar, 4);
        this.m_layeredPane.add(this.m_toolbar);
        this.m_toolbar.initToolbar(null);
        if (this.m_threadScan != null) {
            this.m_threadScan.m_bConnectionChanged = true;
        }
    }

    private void jbInit() throws Exception {
        this.setResizable(false);
        this.jPanelThumbnails.setBorder(BorderFactory.createLoweredBevelBorder());
        this.jPanelThumbnails.setLocation(2, 2);
        this.jPanelThumbnails.setLayout(null);
        this.jPanelThumbnails.setVisible(true);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Trace.logInfo((String)JFrameThumbnail.TRACE_CONTEXT, (String)"JFrameThumbnail.WindowAdapter.windowClosing");
                JFrameThumbnail.this.this_windowClosing(windowEvent);
            }

            public void windowClosed(WindowEvent windowEvent) {
                Trace.logInfo((String)JFrameThumbnail.TRACE_CONTEXT, (String)"JFrameThumbnail.WindowAdapter.windowClosed");
            }

            public void windowActivated(WindowEvent windowEvent) {
                Trace.logInfo((String)JFrameThumbnail.TRACE_CONTEXT, (String)"JFrameThumbnail.WindowAdapter.windowActivated");
                MenuSelectionManager.defaultManager().clearSelectedPath();
                JFrameThumbnail.this.this_windowActivated(windowEvent);
            }

            public void windowDeactivated(WindowEvent windowEvent) {
                JFrameThumbnail.this.m_toolbar.closeAllMenus();
            }
        });
        this.m_scrollPane = new JScrollPane(this.jPanelThumbnails, 20, 30);
        this.m_layeredPane = this.getLayeredPane();
        this.m_layeredPane.setLayer(this.m_scrollPane, 1);
        this.m_layeredPane.add(this.m_scrollPane);
        this.m_scrollPane.setVisible(true);
        this.getGlassPane().addMouseListener(new MouseAdapter(){});
        this.getGlassPane().addKeyListener(new KeyAdapter(){});
    }

    public synchronized void disableServerMenuItem(String string) {
        this.m_szServerMenuToDisable = string;
    }

    public boolean activateMenu() {
        this.m_toolbar.activateMenu();
        return true;
    }

    public void sizeThumbnails(int n) {
        if (this.m_nThumbnailSize == n) {
            return;
        }
        this.m_nThumbnailSize = n;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                JFrameThumbnail.this.setCursor(Cursor.getPredefinedCursor(3));
                for (int i = 0; i < JFrameThumbnail.this.m_appliancePanels.length; ++i) {
                    JFrameThumbnail.this.m_appliancePanels[i].disconnect();
                    JFrameThumbnail.this.m_appliancePanels[i].sizeThumbnail(JFrameThumbnail.this.m_nThumbnailSize);
                }
                JFrameThumbnail.this.setVisible(false);
                JFrameThumbnail.this.setSizeAndLocationOfPanels(JFrameThumbnail.this.m_appliancePanels.length);
                JFrameThumbnail.this.setVisible(true);
                if (!JFrameThumbnail.this.m_bWin32LibraryLoaded) {
                    JFrameThumbnail.this.setState(0);
                }
                JFrameThumbnail.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        thread.start();
    }

    public synchronized boolean isAlive() {
        return this.m_bIsAlive;
    }

    private synchronized void setAlive(boolean bl) {
        this.m_bIsAlive = bl;
    }

    public synchronized boolean isClosing() {
        return this.m_bClosing;
    }

    public synchronized void setClosing(boolean bl) {
        this.m_bClosing = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void this_windowClosing(WindowEvent windowEvent) {
        try {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameThumbnail.this_windowClosing");
            this.setClosing(true);
            SessionManager.removeSession(this);
            for (int i = 0; i < this.m_appliancePanels.length; ++i) {
                this.m_appliancePanels[i].disconnectAll();
            }
            this.setAlive(false);
            this.setVisible(false);
            m_vJFrameThumbnailList.removeElement(this);
            this.m_propertiesLaunchArgs.clear();
        }
        catch (Throwable throwable) {
            Trace.logError((String)TRACE_CONTEXT, (String)("Exception: " + throwable.getMessage()), (Throwable)throwable);
        }
        finally {
            this.dispose();
            Trace.logInfo((String)TRACE_CONTEXT, (String)"Thumbnail Frame dispose() called.");
        }
    }

    void this_windowActivated(WindowEvent windowEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameThumbnail.this_windowActivated");
        for (int i = 0; i < this.m_appliancePanels.length; ++i) {
            this.m_appliancePanels[i].repaint();
        }
    }

    public synchronized int getViewTimePerServer() {
        return this.m_nSecondsPerServer;
    }

    public synchronized int getTimeBetweenServers() {
        return this.m_nSecondsBetweenServers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPreferences() {
        Boolean bl = m_bModalDlgRequest;
        synchronized (bl) {
            JDialogThumbnailOptions jDialogThumbnailOptions = new JDialogThumbnailOptions(this, "", true, this.m_sessionInfo, this.m_szHelpURL);
            jDialogThumbnailOptions.setModal(true);
            jDialogThumbnailOptions.setVisible(true);
            if (jDialogThumbnailOptions.wasOKPressed()) {
                this.m_nSecondsPerServer = jDialogThumbnailOptions.getViewTimePerServer();
                this.m_nSecondsBetweenServers = jDialogThumbnailOptions.getTimeBetweenServers();
                try {
                    this.m_sessionInfo.setThumbnailViewTimePerServer(this.m_nSecondsPerServer);
                    this.m_sessionInfo.setThumbnailTimeBetweenServers(this.m_nSecondsBetweenServers);
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    // empty catch block
                }
            }
        }
    }

    public synchronized void pauseScan(boolean bl) {
        this.m_bScanPaused = bl;
    }

    void jCheckBoxMenuItemPauseScan_actionPerformed(ActionEvent actionEvent) {
        this.m_bScanPaused = !this.m_bScanPaused;
    }

    public synchronized boolean isScanPaused() {
        return this.m_bScanPaused;
    }

    public synchronized void disableJFrameThumbnail() {
        final Component component = this.getGlassPane();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.setVisible(true);
            }
        });
    }

    public synchronized void enableJFrameThumbnail() {
        final Component component = this.getGlassPane();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                component.setVisible(false);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jMenuItemCredentials_actionPerformed(ActionEvent actionEvent) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < this.m_appliancePanels.length; ++n) {
            if (!this.m_appliancePanels[n].haveUserCredentialsBeenSet()) continue;
            bl = true;
            bl2 = this.m_appliancePanels[n].getFirstDSPath().getUCC();
            break;
        }
        if (bl && (n = JOptionPaneFixedSize.showConfirmDialog((Component)this, (Object)"Setting the credentials in this manner will not set the credentials for those thumbnails which have already had their credentials set individually.\n\nDo you want to continue to set the credentials for all the other thumbnails?", (String)"Setting Credentials", (int)0, (int)3)) != 0) {
            return;
        }
        try {
            Boolean bl3 = m_bModalDlgRequest;
            synchronized (bl3) {
                JDialogLogin jDialogLogin = new JDialogLogin((Frame)this, RES.getString("JFrameThumbnail_Thumbnail_Credentials_Title"), this.m_userCredentials);
                jDialogLogin.setModal(true);
                jDialogLogin.setVisible(true);
                if (jDialogLogin.wasOkPressed()) {
                    if (bl2) {
                        CachedCredentials.setCredentials((UsernamePassword)this.m_userCredentials);
                    }
                    for (int i = 0; i < this.m_appliancePanels.length; ++i) {
                        if (this.m_appliancePanels[i].haveUserCredentialsBeenSet()) continue;
                        this.m_appliancePanels[i].setUserCredentials(this.m_userCredentials, false);
                    }
                }
            }
        }
        catch (ExceptionConstructorFailed exceptionConstructorFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)exceptionConstructorFailed.getMessage(), (Throwable)exceptionConstructorFailed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jMenuItemSetCredentials_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        for (int i = 0; i < this.m_appliancePanels.length; ++i) {
            if (this.m_appliancePanels[i].getServerName().compareTo(string) != 0) continue;
            UsernamePassword usernamePassword = new UsernamePassword(this.m_appliancePanels[i].getUserCredentials());
            try {
                Object[] objectArray = new Object[]{string};
                String string2 = MessageFormat.format(RES.getString("JFrameThumbnail_Thumbnail_Server_Credentials"), objectArray);
                Boolean bl = m_bModalDlgRequest;
                synchronized (bl) {
                    JDialogLogin jDialogLogin = new JDialogLogin((Frame)this, string2, usernamePassword);
                    jDialogLogin.setModal(true);
                    jDialogLogin.setVisible(true);
                    if (jDialogLogin.wasOkPressed()) {
                        this.m_userCredentials = usernamePassword;
                        this.m_appliancePanels[i].setUserCredentials(usernamePassword, true);
                    }
                    continue;
                }
            }
            catch (ExceptionConstructorFailed exceptionConstructorFailed) {
                Trace.logError((String)TRACE_CONTEXT, (String)exceptionConstructorFailed.getMessage(), (Throwable)exceptionConstructorFailed);
            }
        }
    }

    private boolean logEventStartScan() {
        String string = this.getTdIds();
        String[] stringArray = new String[]{string};
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail.logEventStartScan szTdIds=" + string));
        return this.logEvent(8, stringArray);
    }

    private boolean logEventStopScan() {
        String string = this.getTdIds();
        String[] stringArray = new String[]{string};
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameThumbnail.logEventStopScan szTdIds=" + string));
        return this.logEvent(9, stringArray);
    }

    private String getTdIds() {
        String string = "";
        for (int i = 0; i < this.m_appliancePanels.length; ++i) {
            string = string + this.m_appliancePanels[i].getFirstDSPath().getDeviceID();
            if (i >= this.m_appliancePanels.length - 1) continue;
            string = string + ",";
        }
        return string;
    }

    private boolean logEvent(int n, String[] stringArray) {
        if (this.m_iFaceViewer != null) {
            int n2 = this.m_iFaceViewer.logEvent(n, stringArray);
            return n2 == 0;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

