/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.InterfaceWindowManager;
import com.avocent.lib.interfaces.SessionStatus;
import com.avocent.lib.util.OS;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.DSKeyListener;
import com.avocent.video.GuiUtils;
import com.avocent.video.InterfaceNativeKeyEventListener;
import com.avocent.video.InterfaceViewWindow;
import com.avocent.video.JFrameFullScreen;
import com.avocent.video.JPanelAppliance;
import com.avocent.video.JPanelApplianceNonBuffered;
import com.avocent.video.KeyStroke;
import com.avocent.video.LinuxLibrary;
import com.avocent.video.NativeAvocentLibrary;
import com.avocent.video.PanelToolbarNormal;
import com.avocent.video.SolarisLibrary;
import com.avocent.video.Win32Library;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;

public class JFrameViewer
extends JFrame
implements InterfaceViewWindow,
InterfaceWindowManager,
InterfaceNativeKeyEventListener {
    private static final String TRACE_CONTEXT = "VideoViewerTrace.JFrameViewer";
    public static final String CNAME = "JFrameViewer";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    private ApplianceSession m_applianceSession;
    private SessionStatus m_sessionStatus;
    private JPanelAppliance m_appliancePanel;
    private JScrollPane m_applianceScrollPane;
    private JLayeredPane m_layeredPane;
    private Dimension m_sizeFrame;
    private PanelToolbarNormal m_toolbar;
    private boolean m_bWaitingForInitialKBMouseStatus = true;
    private Win32Library m_libWin32;
    private boolean m_bWin32LibraryLoaded = false;
    private int m_nHWND = 0;
    private boolean m_bInitRun = false;
    private boolean m_bAltKeyPressed = false;
    private boolean m_bAltKeyReleaseOnTabOrEscSent = false;
    private boolean m_bCtrlKeyPressed = false;
    private boolean m_bCtrlKeyReleaseOnEscSent = false;
    private boolean m_bWindowNotActiveCheckAltKey = false;
    private boolean m_bFromFullScreenMode = false;
    protected Vector m_vKeyPressedList = new Vector();
    boolean m_bProcessingGeneratedKeyPress = false;
    private String m_szHelpURL;
    private boolean m_bEnableScalingControls = true;
    private boolean m_bInInitWindow = false;
    private boolean m_bResizingVideoWindow = false;
    private String m_szTitleOrig;
    private boolean m_bThrottleScalingActive = false;
    private boolean m_bInitWindowCalledSinceScaling = false;
    private boolean m_bWaitCursorActive = false;
    private boolean m_bSingleCursorModeActive = false;
    private boolean m_bTerminated = false;
    private boolean m_bKeyboardHooked = false;
    protected boolean m_bCloseSession = false;
    private boolean m_bFullScreen = false;
    private boolean m_bUseNativeJavaKeyCodes = false;
    private GraphicsConfiguration m_gc;
    private short m_sOrigBitmapWidth;
    private short m_sOrigBitmapHeight;
    private int m_nOrigDecimationFactor;
    private boolean m_bOrigAutoScale;
    private boolean m_bOrigFullScale;
    private Point m_ptLocation = new Point(0, 0);
    private boolean m_bAlreadySizing = false;
    private boolean m_bVideoStopped = false;
    private int nCurrentCursorType = -1;
    private boolean b_KeyListenerActivated = false;
    private boolean b_ignorekey = false;
    static /* synthetic */ Class class$com$avocent$video$JFrameViewer;

    public JFrameViewer(ApplianceSession applianceSession, String string, boolean bl) {
        Object object;
        Object object2;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JFrameViewer constructor)");
        Locale locale = Locale.getDefault();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewer constructor) locale country=" + locale.getCountry() + " variant=" + locale.getVariant() + " language=" + locale.getLanguage()));
        this.m_bUseNativeJavaKeyCodes = bl;
        if (OS.isWindows()) {
            try {
                this.m_libWin32 = new Win32Library();
                JFrameViewer jFrameViewer = this;
                jFrameViewer.m_libWin32.initLib();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Trace.logError((String)TRACE_CONTEXT, (String)unsatisfiedLinkError.getMessage(), (Throwable)unsatisfiedLinkError);
            }
            JFrameViewer jFrameViewer = this;
            this.m_bWin32LibraryLoaded = jFrameViewer.m_libWin32.isWin32LibLoaded();
        } else if (OS.isLinux()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Was Linux native library loaded? " + (LinuxLibrary.isLibraryLoaded() ? "YES" : "NO")));
        } else if (OS.isSolaris()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("Was Solaris native library loaded? " + (SolarisLibrary.isLibraryLoaded() ? "YES" : "NO")));
        }
        this.m_applianceSession = applianceSession;
        this.m_szHelpURL = string;
        this.m_applianceSession.registerWindow(this);
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JFrameViewer constructor) after registerWindow");
        if (this.m_applianceSession.getTitle() == null || this.m_applianceSession.getTitle().length() == 0) {
            this.setTitle(RES.getString("JFrameViewer_Video_Session_Viewer"));
        } else {
            this.setTitle(this.m_applianceSession.getTitle());
        }
        this.setupPanes(null);
        if (!(this.m_bWin32LibraryLoaded || LinuxLibrary.isLibraryLoaded() || SolarisLibrary.isLibraryLoaded())) {
            object2 = new DSKeyListener(this.m_applianceSession);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewer constructor) adding key listener:" + object2));
            this.m_appliancePanel.addKeyListener((KeyListener)object2);
            this.m_appliancePanel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    JFrameViewer.this.m_appliancePanel.requestFocusInWindow();
                }
            });
        }
        object2 = this.m_applianceSession.getPersistentDataReference();
        this.nCurrentCursorType = ((ApplianceSessionInfo)object2).getLocalCursorType();
        this.initWindow(this.m_applianceSession, 0, 0, ((ApplianceSessionInfo)object2).getPanedWidth(), ((ApplianceSessionInfo)object2).getPanedHeight(), ((ApplianceSessionInfo)object2).getVideoWidth(), ((ApplianceSessionInfo)object2).getVideoHeight(), ((ApplianceSessionInfo)object2).getDecimationFactor());
        if (!((ApplianceSessionInfo)object2).isAutoScale() && !((ApplianceSessionInfo)object2).isFullScale() && this.m_appliancePanel.getBitmapWidth() <= 640 && this.m_appliancePanel.getBitmapHeight() <= 480) {
            object = new Thread(new Runnable(){

                public void run() {
                    JFrameViewer.this.showBusyCursor(true);
                    ApplianceSessionInfo applianceSessionInfo = JFrameViewer.this.m_applianceSession.getPersistentData();
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"Resetting the Frame to the Minimum size that it can be outside of Auto and Full");
                    GuiUtils guiUtils = new GuiUtils();
                    guiUtils.setScaling(JFrameViewer.this.m_applianceSession, false, 640, 480);
                    JFrameViewer.this.showBusyCursor(false);
                }
            });
            ((Thread)object).start();
        }
        this.m_bWaitingForInitialKBMouseStatus = false;
        this.setKeyboardLocks();
        object = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.m_gc = this.getGraphicsConfiguration();
        new ThreadWaitForInitialKBMouseStatus();
    }

    public JFrameViewer(JPanelAppliance jPanelAppliance, ApplianceSession applianceSession, GraphicsConfiguration graphicsConfiguration, Point point, Dimension dimension, boolean bl, boolean bl2, boolean bl3) {
        super(graphicsConfiguration);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewer constructor) original location x=" + point.x + " y=" + point.y + " original size width=" + dimension.width + " height=" + dimension.height + " bResolutionChanged=" + bl2));
        this.m_bFromFullScreenMode = true;
        this.m_gc = graphicsConfiguration;
        this.m_bUseNativeJavaKeyCodes = bl;
        try {
            this.m_libWin32 = new Win32Library();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            Trace.logError((String)TRACE_CONTEXT, (String)unsatisfiedLinkError.getMessage(), (Throwable)unsatisfiedLinkError);
        }
        JFrameViewer jFrameViewer = this;
        this.m_bWin32LibraryLoaded = jFrameViewer.m_libWin32.isWin32LibLoaded();
        this.m_appliancePanel = jPanelAppliance;
        this.m_applianceSession = applianceSession;
        this.m_appliancePanel.ignoreVideoData(true);
        if (this.m_applianceSession.getTitle() == null || this.m_applianceSession.getTitle().length() == 0) {
            this.setTitle(RES.getString("JFrameViewer_Video_Session_Viewer"));
        } else {
            this.setTitle(this.m_applianceSession.getTitle());
        }
        this.setupPanes(this.m_appliancePanel);
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
        this.nCurrentCursorType = applianceSessionInfo.getLocalCursorType();
        this.setVisible(true);
        this.setLocation(point);
        this.setSize(dimension);
        this.m_applianceSession.setApplianceWindow(this);
        this.m_applianceSession.registerWindow(this);
        this.m_appliancePanel.ignoreVideoData(false);
        if (bl2 && !applianceSessionInfo.isFullScale() & !applianceSessionInfo.isAutoScale()) {
            try {
                this.m_applianceSession.cmdStartVideo();
            }
            catch (IOException iOException) {
                Trace.logError((String)"VideoViewerTrace", (String)iOException.getMessage(), (Throwable)iOException);
            }
        } else if (applianceSessionInfo.isFullScale()) {
            try {
                this.m_applianceSession.cmdFullScale();
            }
            catch (IOException iOException) {
                Trace.logError((String)"VideoViewerTrace", (String)iOException.getMessage(), (Throwable)iOException);
            }
        } else {
            try {
                this.m_applianceSession.cmdRefreshPane();
            }
            catch (IOException iOException) {
                Trace.logError((String)"VideoViewerTrace", (String)iOException.getMessage(), (Throwable)iOException);
            }
        }
        if (!applianceSessionInfo.isAutoScale()) {
            this.initToolbar(this.m_applianceSession);
        }
        this.m_appliancePanel.repaint();
        this.activateSingleCursorMode(bl3);
    }

    protected void initialize() {
    }

    public void setLinuxKeyboardPassThru(boolean bl, Component component) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("setLinuxKeyboardPassThru:" + bl + " KeyListener Activated:" + this.b_KeyListenerActivated));
        if (this.b_KeyListenerActivated) {
            try {
                LinuxLibrary.setKeyboardPassThru(bl, component);
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)("Exception:" + exception.getMessage()), (Throwable)exception);
            }
        }
    }

    public void setSolarisKeyboardPassThru(boolean bl, Component component) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("setSolarisKeyboardPassThru:" + bl + " KeyListener Activated:" + this.b_KeyListenerActivated));
        if (this.b_KeyListenerActivated) {
            try {
                SolarisLibrary.setKeyboardPassThru(bl, component);
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)("Exception:" + exception.getMessage()), (Throwable)exception);
            }
        }
    }

    private void setupPanes(JPanelAppliance jPanelAppliance) {
        try {
            ImageIcon imageIcon = new ImageIcon((class$com$avocent$video$JFrameViewer == null ? (class$com$avocent$video$JFrameViewer = JFrameViewer.class$("com.avocent.video.JFrameViewer")) : class$com$avocent$video$JFrameViewer).getResource("images/connectvideo16.gif"));
            this.setIconImage(imageIcon.getImage());
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
        this.m_layeredPane = this.getLayeredPane();
        if (jPanelAppliance == null) {
            this.m_appliancePanel = OS.isLinux() ? new JPanelApplianceNonBuffered(this.m_applianceSession) : new JPanelAppliance(this.m_applianceSession);
        }
        this.m_applianceScrollPane = new JScrollPane(this.m_appliancePanel, 20, 30);
        this.m_layeredPane.setLayer(this.m_applianceScrollPane, 1);
        this.m_layeredPane.add(this.m_applianceScrollPane);
        this.m_applianceScrollPane.setBounds(0, 0, this.getSize().width, this.getSize().height);
        this.m_applianceScrollPane.setVisible(true);
        this.addWindowListener(new ApplianceWindowListener());
        this.addComponentListener(new ApplianceComponentListener());
        this.m_sizeFrame = new Dimension(this.getSize());
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"jbInit error", (Throwable)exception);
        }
        this.initialize();
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(0);
        this.m_applianceScrollPane.setBorder(null);
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(this.getGraphicsConfiguration());
        this.setLocation(insets.left, insets.top);
    }

    private Dimension getFrameSize(int n, int n2, int n3) {
        Insets insets = this.getInsets();
        Insets insets2 = this.m_applianceScrollPane.getInsets();
        Dimension dimension = new Dimension(n / n3 + insets.left + insets.right + insets2.left + insets2.right, n2 / n3 + insets.top + insets.bottom + insets2.top + insets2.bottom);
        return dimension;
    }

    public void initWindow(ApplianceSession applianceSession, int n, int n2, short s, short s2, short s3, short s4, int n3) {
        this.initWindow(applianceSession, n, n2, s, s2, s3, s4, n3, true);
    }

    private void showBusyCursor(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("showBusyCursor bCursorBusy=" + bl));
        if (bl) {
            this.setCursor(3);
            this.m_appliancePanel.setLocalCursorType(7);
        } else {
            this.m_appliancePanel.setLocalCursorType(this.nCurrentCursorType);
            this.setCursor(0);
        }
    }

    public void initWindow(ApplianceSession applianceSession, int n, int n2, short s, short s2, short s3, short s4, int n3, boolean bl) {
        if (this.m_bInInitWindow) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewer initWindow) already in initWindow not using these parameters, nBitmapWidth:" + s + " nBitmapHeight:" + s2 + " nDecimationFactor:" + n3));
            return;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewer initWindow) nBitmapWidth:" + s + " nBitmapHeight:" + s2 + " nDecimationFactor:" + n3 + " bEraseImage:" + bl));
        boolean bl2 = false;
        this.m_bInInitWindow = true;
        boolean bl3 = this.isVisible();
        if (!bl3) {
            this.pack();
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewer initWindow) isVisible: " + this.isVisible()));
        this.m_sizeFrame = this.getFrameSize(s, s2, n3);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Insets insets = toolkit.getScreenInsets(this.getGraphicsConfiguration());
        dimension = new Dimension(dimension.width - insets.left - insets.right, dimension.height - insets.top - insets.bottom);
        boolean bl4 = true;
        if (this.m_sizeFrame.getWidth() > dimension.getWidth()) {
            this.m_sizeFrame = new Dimension((int)dimension.getWidth(), (int)this.m_sizeFrame.getHeight());
            bl4 = false;
        }
        if (this.m_sizeFrame.getHeight() > dimension.getHeight()) {
            this.m_sizeFrame = new Dimension((int)this.m_sizeFrame.getWidth(), (int)dimension.getHeight());
            bl4 = false;
        }
        boolean bl5 = true;
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        if (!bl4 && applianceSessionInfo.isAutoScale() && this.m_applianceSession.areScalingControlsEnabled()) {
            try {
                this.m_applianceSession.cmdStopVideo();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Dimension dimension2 = new Dimension(s, s2);
            do {
                dimension2 = JFrameViewer.getNextSmallerResolution(dimension2);
                s = (short)dimension2.getWidth();
                s2 = (short)dimension2.getHeight();
                this.m_sizeFrame = this.getFrameSize(s, s2, n3);
            } while (this.m_sizeFrame.getWidth() > dimension.getWidth() || this.m_sizeFrame.getHeight() > dimension.getHeight());
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewer initWindow) frame will not fit on desktop, next smallest resolution: " + dimension2.getWidth() + " x " + dimension2.getHeight()));
            try {
                applianceSessionInfo.setPanedWidth((short)dimension2.getWidth());
                applianceSessionInfo.setPanedHeight((short)dimension2.getHeight());
                bl5 = false;
                this.m_applianceSession.setPersistentData(applianceSessionInfo);
                bl2 = true;
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            }
        }
        if (n3 > 1 || applianceSessionInfo.isAutoScale()) {
            this.m_applianceScrollPane.setHorizontalScrollBarPolicy(31);
            this.m_applianceScrollPane.setVerticalScrollBarPolicy(21);
        } else {
            this.m_applianceScrollPane.setHorizontalScrollBarPolicy(30);
            this.m_applianceScrollPane.setVerticalScrollBarPolicy(20);
        }
        this.setSize((int)this.m_sizeFrame.getWidth(), (int)this.m_sizeFrame.getHeight());
        this.validate();
        this.m_appliancePanel.initPanelAppliance(this.m_applianceSession, n, n2, s, s2, s3, s4, n3, true, bl);
        this.m_appliancePanel.setPreferredSize(new Dimension(s, s2));
        this.m_appliancePanel.revalidate();
        this.m_applianceScrollPane.setSize(this.m_layeredPane.getSize());
        this.m_applianceScrollPane.setVisible(true);
        this.m_appliancePanel.setVisible(true);
        this.m_applianceScrollPane.validate();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewer initWindow) m_sizeFrame width:" + this.m_sizeFrame.getWidth() + " Height:" + this.m_sizeFrame.getHeight() + " appliance panel width:" + this.m_appliancePanel.getWidth() + " Height:" + this.m_appliancePanel.getHeight() + " scroll pane width:" + this.m_applianceScrollPane.getWidth() + " Height:" + this.m_applianceScrollPane.getHeight()));
        if (!bl3) {
            this.setVisible(true);
        }
        this.initToolbar(this.m_applianceSession);
        this.m_bInitRun = true;
        this.m_bInInitWindow = false;
        this.m_bInitWindowCalledSinceScaling = true;
        if (!OS.isWindows() && this.m_applianceScrollPane.isEnabled()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewer initWindow) (int) m_sizeFrame.getWidth()=" + (int)this.m_sizeFrame.getWidth() + " m_applianceScrollPane.getVerticalScrollBar().getWidth()=" + this.m_applianceScrollPane.getVerticalScrollBar().getWidth()));
            this.m_toolbar.setLocationOnParentResize((int)(this.m_sizeFrame.getWidth() - (double)this.m_applianceScrollPane.getVerticalScrollBar().getWidth()));
        }
        this.showBusyCursor(false);
        if (bl5) {
            applianceSessionInfo.terminate();
        }
    }

    public static Dimension getNextSmallerResolution(Dimension dimension) {
        int n = (int)dimension.getWidth();
        Dimension dimension2 = null;
        dimension2 = n > 1024 ? new Dimension(1024, 768) : (n > 960 ? new Dimension(960, 720) : (n > 896 ? new Dimension(896, 672) : (n > 832 ? new Dimension(832, 624) : (n > 768 ? new Dimension(768, 576) : (n > 704 ? new Dimension(704, 528) : new Dimension(640, 480))))));
        return dimension2;
    }

    public static Dimension getNextLargerResolution(Dimension dimension) {
        int n = (int)dimension.getWidth();
        Dimension dimension2 = null;
        dimension2 = n < 640 ? new Dimension(640, 480) : (n < 704 ? new Dimension(704, 528) : (n < 768 ? new Dimension(768, 576) : (n < 832 ? new Dimension(832, 624) : (n < 896 ? new Dimension(896, 672) : (n < 960 ? new Dimension(960, 720) : new Dimension(1024, 768))))));
        return dimension2;
    }

    public static Dimension getNextResolution(Dimension dimension) {
        int n = (int)dimension.getWidth();
        if (n < 832) {
            return JFrameViewer.getNextLargerResolution(dimension);
        }
        return JFrameViewer.getNextSmallerResolution(dimension);
    }

    public void enableScalingControls(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewer enableScalingControls) bEnable=" + bl));
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
        if (applianceSessionInfo.isAutoScale()) {
            this.setResizable(this.m_bEnableScalingControls);
        }
        this.m_toolbar.notifyEnableScalingChanged();
    }

    public boolean isSingleCursorActive() {
        return this.m_bSingleCursorModeActive;
    }

    public void activateSingleCursorMode(boolean bl) {
        if (Win32Library.isWin32LibLoaded()) {
            if (bl) {
                ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
                this.m_szTitleOrig = this.getTitle();
                KeyStroke keyStroke = new KeyStroke(2, 67, RES.getString("JFrameViewer_KEYCAP_F10"));
                try {
                    keyStroke = applianceSessionInfo.getSingleCursorTerminateKey();
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                }
                Object[] objectArray = new Object[]{keyStroke.toString()};
                String string = MessageFormat.format(RES.getString("JFrameViewer_Single_Mouse_Caption_Addition"), objectArray);
                this.setTitle(this.m_szTitleOrig + string);
                Rectangle rectangle = this.m_appliancePanel.getBounds();
                Point point = rectangle.getLocation();
                SwingUtilities.convertPointToScreen(point, this.m_appliancePanel);
                this.m_libWin32.setSingleMouseMode(KeyStroke.getScanCodeForStandardSelectionKeyStroke(keyStroke), this, point.x, point.y, (int)rectangle.getWidth() / applianceSessionInfo.getDecimationFactor(), (int)rectangle.getHeight() / applianceSessionInfo.getDecimationFactor());
                this.m_appliancePanel.initSingleCursor();
                try {
                    this.m_applianceSession.cmdMouseAlign();
                }
                catch (IOException iOException) {
                    Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
                }
                this.m_bSingleCursorModeActive = true;
            } else if (this.m_bSingleCursorModeActive) {
                this.m_libWin32.resetSingleMouseMode();
                this.notifySingleCursorDeactivated();
            }
        }
    }

    public void initToolbar(ApplianceSession applianceSession) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"initToolbar");
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
        if (this.m_toolbar != null) {
            try {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"initToolbar m_toolbar != null");
                this.m_layeredPane.remove(this.m_toolbar);
                Trace.logInfo((String)TRACE_CONTEXT, (String)"initToolbar terminating toolbar");
                this.m_toolbar.terminate();
                Trace.logInfo((String)TRACE_CONTEXT, (String)"initToolbar setting m_toolbar null so garbage collector finds it");
                this.m_toolbar = null;
                Trace.logInfo((String)TRACE_CONTEXT, (String)"initToolbar repainting window");
                applianceSession.getApplianceWindow().getPanelAppliance().repaint();
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            }
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("initToolbar creating new toolbar width=" + applianceSessionInfo.getPanedWidth() + " decimation factor=" + applianceSessionInfo.getDecimationFactor() + "info.isPinPushed()=" + applianceSessionInfo.isPinPushed()));
        this.m_toolbar = new PanelToolbarNormal(applianceSessionInfo.getPanedWidth() / applianceSessionInfo.getDecimationFactor() / 2, 0, applianceSessionInfo.getPanedWidth() / applianceSessionInfo.getDecimationFactor(), this, this.m_nHWND, this.m_appliancePanel, this.m_szHelpURL, applianceSession, applianceSessionInfo.isPinPushed(), false, applianceSessionInfo.getToolbarHideDelay());
        this.m_layeredPane.setLayer(this.m_toolbar, 2);
        this.m_layeredPane.add(this.m_toolbar);
        this.m_toolbar.initToolbar(applianceSession);
    }

    public final JPanelAppliance getPanelAppliance() {
        return this.m_appliancePanel;
    }

    public int getBitmapWidth() {
        return this.m_appliancePanel.getBitmapWidth();
    }

    public int getBitmapHeight() {
        return this.m_appliancePanel.getBitmapHeight();
    }

    public int getPixelArrayWidth() {
        return this.m_appliancePanel.getPixelArrayWidth();
    }

    public void mouseAlign() {
        try {
            this.m_applianceSession.cmdMouseAlign();
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"mouseAlign error", (Throwable)iOException);
        }
    }

    public void setConnectionType(int n) {
        try {
            this.m_toolbar.setConnectionStatus(n);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void notifyLockedModeChanged() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer notifyLockedModeChanged");
        try {
            this.m_toolbar.notifyLockedOrReserveModeChanged();
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void notifyReserveModeChanged() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer notifyReserveModeChanged");
        try {
            this.m_toolbar.notifyLockedOrReserveModeChanged();
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void notifyManualVideoAdjustDialogClosed() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer notifyManualVideoAdjustDialogClosed");
        try {
            this.m_toolbar.notifyManualVideoAdjustDialogClosed();
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void notifyVmAvailableChanged() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer notifyManualVideoAdjustDialogClosed");
        try {
            this.m_toolbar.notifyVmAvailableChanged();
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void terminate() {
        this.setVisible(false);
        this.dispose();
        this.m_bCloseSession = true;
    }

    private void terminateSession() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JFrameViewer.terminate)");
        if (this.m_bTerminated) {
            return;
        }
        this.m_bTerminated = true;
        this.activateSingleCursorMode(false);
        try {
            this.m_applianceSession.terminateSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_appliancePanel != null) {
            try {
                this.m_appliancePanel.terminatePanelAppliance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.m_toolbar != null) {
            this.m_toolbar.terminate();
        }
        if (this.isVisible()) {
            this.setVisible(false);
        }
        this.removeAll();
        this.dispose();
        this.m_appliancePanel = null;
        this.m_applianceScrollPane = null;
        this.m_sizeFrame = null;
        this.m_toolbar = null;
        this.m_ptLocation = null;
    }

    public void repaintAppliance() {
        this.repaint();
    }

    public void bringWindowToTop() {
        if (this.getState() == 1) {
            this.setState(0);
        }
        this.toFront();
        this.m_appliancePanel.setVideoQueueSleepTimeActivated();
    }

    public void fullScreenToggle() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JFrameViewer fullScreenToggle)");
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
        if (this.m_applianceSession != null) {
            this.m_applianceSession.closeDlgManualVideoAdjust();
        }
        if (LinuxLibrary.isLibraryLoaded() || SolarisLibrary.isLibraryLoaded()) {
            if (LinuxLibrary.isLibraryLoaded()) {
                this.setLinuxKeyboardPassThru(false, this);
            } else {
                this.setSolarisKeyboardPassThru(false, this);
            }
            try {
                this.m_applianceSession.cmdFocusControl(false);
            }
            catch (IOException iOException) {
                Trace.logError((String)"VideoViewerTrace", (String)iOException.getMessage(), (Throwable)iOException);
            }
        }
        this.m_appliancePanel.setVisible(false);
        this.m_sOrigBitmapWidth = applianceSessionInfo.getPanedWidth();
        this.m_sOrigBitmapHeight = applianceSessionInfo.getPanedHeight();
        this.m_nOrigDecimationFactor = applianceSessionInfo.getDecimationFactor();
        this.m_bOrigAutoScale = applianceSessionInfo.isAutoScale();
        this.m_bOrigFullScale = applianceSessionInfo.isFullScale();
        this.m_sizeFrame = this.getSize();
        int n = applianceSessionInfo.getLocalCursorType();
        boolean bl = this.m_applianceSession.getApplianceWindow().isSingleCursorActive();
        if (bl) {
            applianceSessionInfo.setLocalCursorType(0);
        }
        JFrameFullScreen jFrameFullScreen = new JFrameFullScreen(this.m_applianceSession, this.m_ptLocation, this.m_sizeFrame);
        this.setVisible(false);
        if (bl) {
            applianceSessionInfo.setLocalCursorType(n);
        }
        jFrameFullScreen.activateSingleCursorMode(bl);
        if (OS.isLinux()) {
            if (this.m_toolbar != null) {
                this.m_toolbar.terminate();
            }
            this.m_appliancePanel = null;
            this.m_applianceScrollPane = null;
            this.m_sizeFrame = null;
            this.m_toolbar = null;
            this.m_ptLocation = null;
            this.dispose();
        }
    }

    public void restoreNormalWindowMode() {
        this.m_appliancePanel.setVisible(false);
        this.m_applianceSession.setApplianceWindow(this);
        this.m_appliancePanel.setLocation(0, 0);
        this.m_applianceScrollPane.getViewport().add(this.m_appliancePanel);
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        try {
            applianceSessionInfo.setPanedWidth(this.m_sOrigBitmapWidth);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(JFrameViewer.restoreNormalWindowMode) setPanedWidth error", (Throwable)exception);
        }
        try {
            applianceSessionInfo.setPanedHeight(this.m_sOrigBitmapHeight);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(JFrameViewer.restoreNormalWindowMode) setPanedHeight error", (Throwable)exception);
        }
        try {
            applianceSessionInfo.setDecimationFactor(this.m_nOrigDecimationFactor);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(JFrameViewer.restoreNormalWindowMode) decimationFactor error", (Throwable)exception);
        }
        try {
            applianceSessionInfo.setAutoScale(this.m_bOrigAutoScale);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(JFrameViewer.restoreNormalWindowMode) autoscale error", (Throwable)exception);
        }
        try {
            applianceSessionInfo.setFullScale(this.m_bOrigFullScale);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(JFrameViewer.restoreNormalWindowMode) fullscale error", (Throwable)exception);
        }
        this.m_applianceSession.setPersistentData(applianceSessionInfo);
        this.setExtendedState(0);
        if (this.m_appliancePanel.getBitmapWidth() != this.m_sOrigBitmapWidth || this.m_appliancePanel.getBitmapHeight() != this.m_sOrigBitmapHeight || this.m_appliancePanel.getDecimationFactor() != this.m_nOrigDecimationFactor) {
            try {
                this.m_applianceSession.cmdStartVideo();
            }
            catch (IOException iOException) {
                Trace.logError((String)TRACE_CONTEXT, (String)"(JFrameFullScreen constructor) cmdStartVideo error", (Throwable)iOException);
            }
        }
        this.m_appliancePanel.setVisible(true);
        this.setVisible(true);
        if (this.m_applianceSession.getPersistentDataReference().isPinPushed()) {
            this.m_toolbar.restorePinPush();
        } else {
            this.m_toolbar.hideToolbar();
        }
    }

    public boolean activateMenu() {
        boolean bl = false;
        try {
            if (!this.m_bAltKeyPressed && !this.m_bKeyboardHooked) {
                if (LinuxLibrary.isLibraryLoaded()) {
                    this.setLinuxKeyboardPassThru(false, this);
                } else if (SolarisLibrary.isLibraryLoaded()) {
                    this.setSolarisKeyboardPassThru(false, this);
                }
                this.m_toolbar.activateMenu();
                bl = true;
            }
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
        return bl;
    }

    void setPersistentDataForAutoScale(boolean bl) {
        try {
            ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
            applianceSessionInfo.setAutoScale(bl);
            applianceSessionInfo.setFullScale(false);
            this.m_applianceSession.setPersistentData(applianceSessionInfo);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    void setPersistentDataForAutoScale(boolean bl, int n, int n2) {
        try {
            ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
            applianceSessionInfo.setAutoScale(bl);
            applianceSessionInfo.setFullScale(false);
            applianceSessionInfo.setPanedWidth((short)n);
            applianceSessionInfo.setPanedHeight((short)n2);
            if (!bl) {
                applianceSessionInfo.setDecimationFactor(1);
            }
            this.m_applianceSession.setPersistentData(applianceSessionInfo);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    private void throttleScaling(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JFrameViewer.throttleScaling)");
        if (this.m_bThrottleScalingActive) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JFrameViewer.throttleScaling) exiting because throttle scaling already active");
            return;
        }
        this.m_bThrottleScalingActive = true;
        this.m_appliancePanel.ignoreVideoData(true);
        if (bl) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JFrameViewer.throttleScaling) bAutoScale true, disabling resizing");
        }
        this.m_bInitWindowCalledSinceScaling = false;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                int n = 20;
                if (OS.isLinux() || OS.isSolaris()) {
                    n = 30;
                }
                while (!JFrameViewer.this.m_bInitWindowCalledSinceScaling && n-- > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer.throttleScaling) out of loop");
                JFrameViewer.this.m_bThrottleScalingActive = false;
                Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer.throttleScaling) m_bThrottleScalingActive = false");
                JFrameViewer.this.m_appliancePanel.ignoreVideoData(false);
                try {
                    Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer throttleScaling) calling cmdRefreshPane");
                    JFrameViewer.this.m_applianceSession.cmdRefreshPane();
                    JFrameViewer.this.showBusyCursor(false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        thread.start();
        if (bl) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JFrameViewer.throttleScaling) bAutoScale true, enabling resizing");
        }
    }

    public void resizeVideoWindow(int n, int n2) {
        this.resizeVideoWindow(n, n2, true);
    }

    public void resizeVideoWindow(int n, int n2, boolean bl) {
        this.m_bResizingVideoWindow = true;
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
        int n3 = applianceSessionInfo.getLocalCursorType();
        boolean bl2 = this.m_applianceSession.getApplianceWindow().isSingleCursorActive();
        if (bl2) {
            applianceSessionInfo.setLocalCursorType(0);
            this.activateSingleCursorMode(false);
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameAppliance resizeVideoWindow) nWidth:" + n + " nHeight:" + n2));
        ApplianceSessionInfo applianceSessionInfo2 = this.m_applianceSession.getPersistentData();
        try {
            applianceSessionInfo2.setPanedWidth((short)n);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(JFrameAppliance rescaleVideo) setPanedWidth error", (Throwable)exception);
        }
        try {
            applianceSessionInfo2.setPanedHeight((short)n2);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(JFrameAppliance rescaleVideo) setPanedHeight error", (Throwable)exception);
        }
        this.m_applianceSession.setPersistentData(applianceSessionInfo2);
        this.initWindow(this.m_applianceSession, 0, 0, (short)n, (short)n2, applianceSessionInfo2.getVideoWidth(), applianceSessionInfo2.getVideoHeight(), applianceSessionInfo2.getDecimationFactor(), bl);
        this.m_bResizingVideoWindow = false;
        if (bl2) {
            applianceSessionInfo.setLocalCursorType(n3);
            this.activateSingleCursorMode(bl2);
        }
    }

    public Frame getFrameWindow() {
        return this;
    }

    public void setSize(int n, int n2) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewer.setSize with nWidth and nHeightwidth=" + n + " height=" + n2));
        this.setExtendedState(0);
        super.setSize(n, n2);
    }

    public void setSize(Dimension dimension) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewer.setSize with dimension width=" + dimension.width + " height=" + dimension.height));
        super.setSize(dimension);
    }

    public boolean closeWindow() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.closeWindow");
        boolean bl = false;
        if (this.m_applianceSession.getApplianceWindow() == this) {
            if (this.didUserConfirmOnClose()) {
                this.m_applianceSession.logEventSession(1);
                this.terminateSession();
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean didUserConfirmOnClose() {
        int n;
        boolean bl = true;
        if (this.m_applianceSession.isLockedMode() && !this.m_applianceSession.isReserveModeActive() && (n = JOptionPane.showConfirmDialog(this, RES.getString("JFrameViewer_DO_YOU_WANT_TO_CLOSE_THIS_SESSION_LOCK_WARNING"), RES.getString("JFrameViewer_CLOSE_SESSION_REQUESTED"), 0, 3)) != 0) {
            bl = false;
        }
        return bl;
    }

    void setKeyboardLocks() {
        if (!this.m_bWaitingForInitialKBMouseStatus) {
            if (this.m_bWin32LibraryLoaded) {
                try {
                    this.m_applianceSession.cmdCapsLockSet(this.m_libWin32.isCapsLockSet());
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)("(JFrameViewer setKeyboardLocks)" + exceptionRequestFailed.getMessage()), (Throwable)exceptionRequestFailed);
                }
            } else if (!OS.isLinux() && !OS.isSolaris()) {
                try {
                    boolean bl = Toolkit.getDefaultToolkit().getLockingKeyState(20);
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewer.setKeyboardLocks caps-lock bLock=" + bl));
                    this.m_applianceSession.cmdCapsLockSet(bl);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"getLockingKeyState caps lock error", (Throwable)unsupportedOperationException);
                }
            }
            if (this.m_bWin32LibraryLoaded) {
                try {
                    this.m_applianceSession.cmdNumLockSet(this.m_libWin32.isNumLockSet());
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)("(JFrameViewer setKeyboardLocks)" + exceptionRequestFailed.getMessage()), (Throwable)exceptionRequestFailed);
                }
            } else if (!OS.isLinux() && !OS.isSolaris()) {
                try {
                    boolean bl = Toolkit.getDefaultToolkit().getLockingKeyState(144);
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewer.setKeyboardLocks num lock bLock=" + bl));
                    this.m_applianceSession.cmdNumLockSet(bl);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"getLockingKeyState num-lock error", (Throwable)unsupportedOperationException);
                }
            }
            if (this.m_bWin32LibraryLoaded) {
                try {
                    this.m_applianceSession.cmdScrollLockSet(this.m_libWin32.isScrollLockSet());
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)("(JFrameViewer setKeyboardLocks)" + exceptionRequestFailed.getMessage()), (Throwable)exceptionRequestFailed);
                }
            } else if (!OS.isLinux() && !OS.isSolaris()) {
                try {
                    boolean bl = Toolkit.getDefaultToolkit().getLockingKeyState(145);
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewer.setKeyboardLocks scroll lock bLock=" + bl));
                    this.m_applianceSession.cmdScrollLockSet(bl);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"getLockingKeyState scroll lock error", (Throwable)unsupportedOperationException);
                }
            }
            if (this.m_bWin32LibraryLoaded) {
                try {
                    this.m_applianceSession.cmdKanaLockSet(this.m_libWin32.isKanaLockSet());
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)("(JFrameViewer setKeyboardLocks)" + exceptionRequestFailed.getMessage()), (Throwable)exceptionRequestFailed);
                }
            } else if (!OS.isLinux() && !OS.isSolaris()) {
                try {
                    boolean bl = Toolkit.getDefaultToolkit().getLockingKeyState(262);
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewer.setKeyboardLocks scroll lock bLock=" + bl));
                    this.m_applianceSession.cmdKanaLockSet(bl);
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"getLockingKeyState kana lock error");
                }
            }
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"setKeyboardLocks: m_bWaitingForInitialKBMouseStatus true");
        }
    }

    public void notifyMouseWheel(short s, short s2, long l, long l2) {
        if (this.m_appliancePanel != null) {
            this.m_appliancePanel.mouseScrollNotify(s, s2, l, l2);
        }
    }

    public void notifyKeyPressedLinux(short s, int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewer.notifyKeyPressedLinux sScanCode:" + s + " nKeyState=" + n));
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        this.m_applianceSession.cmdNumLockSet(bl);
        this.m_applianceSession.cmdCapsLockSet(bl2);
        this.notifyKeyPressed(s);
    }

    public void notifyKeyPressed(short s) {
        if (SolarisLibrary.isLibraryLoaded()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewer.notifyKeyPressed Solaris KeyPress sScanCode:" + s));
            this.m_applianceSession.cmdKeyPressed(s + 1);
            if (s + 1 == 83 || s + 1 == 57) {
                this.m_applianceSession.cmdKeyReleased(s + 1);
            }
            return;
        }
        if (this.b_ignorekey) {
            return;
        }
        if (!this.m_bKeyboardHooked && (s == 107 || s == 108) && OS.isWindows()) {
            return;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewer.notifyKeyPressed sScanCode:" + s));
        if (LinuxLibrary.isLibraryLoaded() && !this.m_bProcessingGeneratedKeyPress) {
            this.m_vKeyPressedList.addElement(new Short(s));
        }
        if (!this.m_bKeyboardHooked) {
            if (s == 56 || s == 105) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyPressed ALT key pressed");
                this.m_bAltKeyPressed = true;
                this.m_bAltKeyReleaseOnTabOrEscSent = false;
            } else if (s == 29 || s == 101) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyPressed CTRL key pressed");
                this.m_bCtrlKeyPressed = true;
                this.m_bCtrlKeyReleaseOnEscSent = false;
            }
        }
        this.m_applianceSession.cmdScanCodeKeyPressed(s);
    }

    public void notifyKeyReleased(short s) {
        Object object;
        if (SolarisLibrary.isLibraryLoaded()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewer.notifyKeyReleased Solaris KeyRelease sScanCode:" + s));
            if (s + 1 == 83 || s + 1 == 57) {
                this.m_applianceSession.cmdKeyPressed(s + 1);
            }
            this.m_applianceSession.cmdKeyReleased(s + 1);
            return;
        }
        this.m_bWindowNotActiveCheckAltKey = false;
        if (!this.m_bKeyboardHooked && (s == 107 || s == 108) && OS.isWindows()) {
            return;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewer.notifyKeyReleased sScanCode:" + s));
        if (LinuxLibrary.isLibraryLoaded()) {
            object = this.getKeyPressForScanCode(s);
            if (object == null && s != 28 && s != 57 && s != 1) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("Generating missing key press for sScanCode:" + s));
                this.m_bProcessingGeneratedKeyPress = true;
                this.notifyKeyPressed(s);
                this.m_bProcessingGeneratedKeyPress = false;
            } else {
                this.m_vKeyPressedList.removeElement(object);
            }
        }
        if (!this.m_bKeyboardHooked) {
            if (s == 56 || s == 105) {
                if (!this.m_bAltKeyReleaseOnTabOrEscSent) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased sending ALT key released then pressed/released pair");
                    object = new Thread(new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased Check if window deactivated recently.");
                            if (JFrameViewer.this.m_bWindowNotActiveCheckAltKey) {
                                JFrameViewer.this.m_applianceSession.cmdKeyPressed(226, true);
                                JFrameViewer.this.m_applianceSession.cmdKeyPressed(226, true);
                                JFrameViewer.this.m_applianceSession.cmdKeyReleased(226, true);
                            }
                            JFrameViewer.this.m_bWindowNotActiveCheckAltKey = false;
                        }
                    });
                    ((Thread)object).start();
                }
                this.m_bAltKeyPressed = false;
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased ALT key released");
                this.m_bAltKeyReleaseOnTabOrEscSent = false;
            } else if (s == 29 || s == 101) {
                this.m_bCtrlKeyPressed = false;
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased CTRL key released");
                this.m_bCtrlKeyReleaseOnEscSent = false;
            }
            object = this.m_applianceSession.getPersistentDataReference();
            if (!((ApplianceSessionInfo)object).isKeyboardPassthroughNonFullScreen() && this.m_bAltKeyPressed && (s == 15 || s == 1)) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased TAB or ESC key released with ALT down");
                if (!this.m_bAltKeyReleaseOnTabOrEscSent) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased sending ALT key released then pressed/released pair");
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            JFrameViewer.this.m_applianceSession.cmdKeyPressed(226, true);
                            JFrameViewer.this.m_applianceSession.cmdKeyPressed(226, true);
                            JFrameViewer.this.m_applianceSession.cmdKeyReleased(226, true);
                        }
                    });
                    thread.start();
                    this.m_bAltKeyReleaseOnTabOrEscSent = true;
                }
                return;
            }
            if (this.m_bCtrlKeyPressed && s == 1) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased ESC key released with CTRL down");
                if (!this.m_bCtrlKeyReleaseOnEscSent) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyKeyReleased sending CTRL key released");
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            JFrameViewer.this.m_applianceSession.cmdKeyReleased(224, true);
                        }
                    });
                    thread.start();
                    this.m_bCtrlKeyReleaseOnEscSent = true;
                }
                return;
            }
        }
        this.m_applianceSession.cmdScanKeyReleased(s);
    }

    public void notifySingleCursorMouseMoved(short s, int n, int n2, short s2) {
        this.m_appliancePanel.singleCursorModeMouseNotify(s, s2, n, n2);
    }

    public void notifySingleCursorDeactivated() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifySingleCursorDeactivated");
        Thread thread = new Thread(new Runnable(){

            public void run() {
                ApplianceSessionInfo applianceSessionInfo = JFrameViewer.this.m_applianceSession.getPersistentDataReference();
                JFrameViewer.this.m_appliancePanel.setLocalCursorType(applianceSessionInfo.getLocalCursorType());
                JFrameViewer.this.setTitle(JFrameViewer.this.m_szTitleOrig);
                try {
                    JFrameViewer.this.m_applianceSession.cmdMouseAlign();
                }
                catch (IOException iOException) {
                    Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
                }
                Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"JFrameViewer.notifySingleCursorDeactivated returned from cmdMouseAlign");
                JFrameViewer.this.m_bSingleCursorModeActive = false;
            }
        });
        thread.start();
    }

    public void notifyMouseXButtonPressed(short s, int n, int n2) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyMouseXButtonPressed");
        this.m_appliancePanel.mouseXButtonNotify(s, (short)0, n, n2);
    }

    public void notifyMaximizeButtonPressed() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyMaximizeButtonPressed");
        int n = this.m_applianceSession.getConnectionType();
        if (n == 4 || n == 5 || n == 6) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.notifyMaximizeButtonPressed not maximizing because connection type of user does not allow it");
            return;
        }
        Thread thread = new Thread(new Runnable(){

            public void run() {
                JFrameViewer.this.fullScreenToggle();
            }
        });
        thread.start();
    }

    public void listeningWindowDeactivated() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.listeningWindowDeactivated");
        if (this.m_bAltKeyPressed) {
            this.m_bAltKeyPressed = false;
            if (!this.m_bAltKeyReleaseOnTabOrEscSent) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer.listeningWindowDeactivated sending ALT key released then pressed/released pair");
                this.m_applianceSession.cmdKeyReleased(226, true);
                this.m_applianceSession.cmdKeyPressed(226, true);
                this.m_applianceSession.cmdKeyReleased(226, true);
                this.m_bAltKeyReleaseOnTabOrEscSent = true;
            }
        }
    }

    public void addNotify() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer addNotify");
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentDataReference();
        super.addNotify();
        if (this.m_bWin32LibraryLoaded) {
            try {
                this.m_nHWND = this.m_libWin32.getHWND(this);
                this.setMouseWheelHook(this.m_nHWND, this);
                if (!this.m_bUseNativeJavaKeyCodes) {
                    this.m_libWin32.processWindowsMessages(true);
                }
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)("JFrameViewer.addNotify exception on setMouseWheelHook " + exception.getMessage()), (Throwable)exception);
            }
        } else if (LinuxLibrary.isLibraryLoaded()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer addNotify LinuxLibrary is loaded, calling registerNativeKeyListener");
            this.setVisible(true);
            NativeAvocentLibrary.registerNativeKeyListener(this, this);
            this.b_KeyListenerActivated = true;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (applianceSessionInfo.isKeyboardPassthroughNonFullScreen()) {
                this.setLinuxKeyboardPassThru(true, this);
            }
        } else if (SolarisLibrary.isLibraryLoaded()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewer addNotify SolarisLibrary is loaded, calling registerNativeKeyListener");
            this.setVisible(true);
            NativeAvocentLibrary.registerNativeKeyListener(this, this);
            this.b_KeyListenerActivated = true;
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (applianceSessionInfo.isKeyboardPassthroughNonFullScreen()) {
                this.setSolarisKeyboardPassThru(true, this);
            }
        }
    }

    public void removeNotify() {
        if (this.m_bWin32LibraryLoaded) {
            try {
                this.resetMouseWheelHook(this.m_nHWND, this);
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)("JFrameViewer.removeNotify exception on removeMouseWheelHook " + exception.getMessage()), (Throwable)exception);
            }
        } else if (LinuxLibrary.isLibraryLoaded()) {
            this.setLinuxKeyboardPassThru(false, this);
            this.b_KeyListenerActivated = false;
            LinuxLibrary.unregisterNativeKeyListener(this, this);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {}
        } else if (SolarisLibrary.isLibraryLoaded()) {
            this.setSolarisKeyboardPassThru(false, this);
            this.b_KeyListenerActivated = false;
            SolarisLibrary.unregisterNativeKeyListener(this, this);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        super.removeNotify();
    }

    public Dimension inquireNewSize(Dimension dimension) {
        Insets insets = this.getInsets();
        Insets insets2 = this.m_applianceScrollPane.getInsets();
        int n = (int)dimension.getWidth() - insets.left - insets.right - insets2.left - insets2.right;
        int n2 = (int)dimension.getHeight() - insets.top - insets.bottom - insets2.top - insets2.bottom;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewer inquireNewSize) nX:" + n + " nY:" + n2));
        Dimension dimension2 = new Dimension(n + insets.left + insets.right + insets2.left + insets2.right, n2 + insets.top + insets.bottom + insets2.top + insets2.bottom);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewer inquireNewSize) returning X: " + dimension2.getWidth() + " Y:" + dimension2.getHeight()));
        return dimension2;
    }

    public void setNewSize(Rectangle rectangle) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewer setNewSize) rNewBounds:" + rectangle.getLocation().getX() + " " + rectangle.getLocation().getY() + " " + rectangle.getWidth() + " " + rectangle.getHeight()));
        if (OS.isLinux() || OS.isSolaris()) {
            this.setVisible(false);
        }
        Insets insets = this.getInsets();
        Insets insets2 = this.m_applianceScrollPane.getInsets();
        int n = (int)rectangle.getWidth() - insets.left - insets.right - insets2.left - insets2.right;
        int n2 = (int)rectangle.getHeight() - insets.top - insets.bottom - insets2.top - insets2.bottom;
        boolean bl = true;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewer setNewSize) nX:" + n + " nY:" + n2));
        this.setBounds(rectangle);
        if (OS.isLinux() || OS.isSolaris()) {
            this.setVisible(true);
        }
        if (this.getState() == 1) {
            this.setState(0);
        }
        this.toFront();
    }

    private void resetMouseWheelHook(int n, JFrameViewer jFrameViewer) {
        if (!this.m_bUseNativeJavaKeyCodes) {
            this.m_libWin32.resetMouseWheelHook(n, jFrameViewer);
        }
    }

    private void setMouseWheelHook(int n, JFrameViewer jFrameViewer) {
        if (!this.m_bUseNativeJavaKeyCodes) {
            this.m_libWin32.setMouseWheelHook(n, jFrameViewer);
        }
    }

    Short getKeyPressForScanCode(short s) {
        Short s2 = null;
        for (int i = 0; i < this.m_vKeyPressedList.size(); ++i) {
            Short s3 = (Short)this.m_vKeyPressedList.elementAt(i);
            if (s3 != s) continue;
            s2 = s3;
            break;
        }
        return s2;
    }

    public void modalDialogActivated() {
        Trace.logInfo((String)"VideoViewerTrace", (String)"JFrameViewer:modalDialogActivated");
        if (this.m_applianceSession != null) {
            if (LinuxLibrary.isLibraryLoaded()) {
                LinuxLibrary.stopKeyListener(this);
            } else if (SolarisLibrary.isLibraryLoaded()) {
                SolarisLibrary.stopKeyListener(this);
            }
            try {
                this.m_applianceSession.cmdFocusControl(false);
            }
            catch (IOException iOException) {
                Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
            }
            if (LinuxLibrary.isLibraryLoaded()) {
                LinuxLibrary.startKeyListener(this);
            } else if (SolarisLibrary.isLibraryLoaded()) {
                SolarisLibrary.startKeyListener(this);
            }
        }
    }

    public Component getViewComponent() {
        return this;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ int access$1500(JFrameViewer jFrameViewer) {
        return jFrameViewer.m_nHWND;
    }

    public class FileFilterJPEG
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isHidden()) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return string.endsWith(".jpg") || string.endsWith(".jpeg");
        }

        public String getDescription() {
            return RES.getString("JFrameViewer_CaptureFileDescription");
        }
    }

    public class TransferableVideo
    implements Transferable {
        private Image m_image;

        public TransferableVideo(Image image) {
            this.m_image = image;
        }

        public Object getTransferData(DataFlavor dataFlavor) {
            if (dataFlavor.equals(DataFlavor.imageFlavor)) {
                return this.m_image;
            }
            return null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.imageFlavor};
            return dataFlavorArray;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(DataFlavor.imageFlavor);
        }
    }

    public class ClipboardOwnerVideo
    implements ClipboardOwner {
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    private class ThreadWaitForInitialKBMouseStatus
    extends Thread {
        private ThreadWaitForInitialKBMouseStatus() {
            this.start();
        }

        public void run() {
            int n = 20;
            try {
                ThreadWaitForInitialKBMouseStatus.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            JFrameViewer.this.m_bWaitingForInitialKBMouseStatus = !JFrameViewer.this.m_applianceSession.isInitialKBMouseStatusReceived();
            while (JFrameViewer.this.m_bWaitingForInitialKBMouseStatus && JFrameViewer.this.m_applianceSession.isSessionRunning()) {
                if (JFrameViewer.this.m_bWaitingForInitialKBMouseStatus) {
                    try {
                        ThreadWaitForInitialKBMouseStatus.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (n-- <= 0) {
                    try {
                        JFrameViewer.this.m_applianceSession.cmdKBStatusRequest();
                    }
                    catch (IOException iOException) {
                        Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
                    }
                    n = 20;
                }
                JFrameViewer.this.m_bWaitingForInitialKBMouseStatus = !JFrameViewer.this.m_applianceSession.isInitialKBMouseStatusReceived();
            }
            if (JFrameViewer.this.m_applianceSession.isSessionRunning()) {
                JFrameViewer.this.setKeyboardLocks();
            }
        }
    }

    private class ApplianceComponentListener
    implements ComponentListener {
        private ApplianceComponentListener() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"JFrameViewer.componentHidded");
        }

        public void componentMoved(ComponentEvent componentEvent) {
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"JFrameViewer.componentMoved");
            GraphicsConfiguration graphicsConfiguration = JFrameViewer.this.getGraphicsConfiguration();
            if (graphicsConfiguration != null && JFrameViewer.this.m_gc != null && graphicsConfiguration != JFrameViewer.this.m_gc) {
                JFrameViewer.this.m_appliancePanel.transferImage();
                JFrameViewer.this.m_gc = graphicsConfiguration;
            }
            JFrameViewer.this.m_ptLocation = JFrameViewer.this.getLocation();
        }

        public void componentResizedNonAutoScale() {
            Cloneable cloneable;
            Cloneable cloneable2;
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer componentResizedNonAutoScale) not in auto-scale mode");
            if (OS.isLinux() || OS.isSolaris()) {
                if (JFrameViewer.this.m_bAlreadySizing) {
                    Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer componentResizedNonAutoScale) already sizing, returning");
                    return;
                }
                JFrameViewer.this.m_bAlreadySizing = true;
                do {
                    cloneable2 = JFrameViewer.this.getSize();
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    cloneable = JFrameViewer.this.getSize();
                } while (((Dimension)cloneable2).width != ((Dimension)cloneable).width || ((Dimension)cloneable2).height != ((Dimension)cloneable).height);
                JFrameViewer.this.m_bAlreadySizing = false;
                cloneable2 = cloneable;
            } else {
                cloneable2 = JFrameViewer.this.getSize();
            }
            cloneable = JFrameViewer.this.getInsets();
            Insets insets = JFrameViewer.this.m_applianceScrollPane.getInsets();
            int n = (int)((Dimension)cloneable2).getWidth() - cloneable.left - cloneable.right - insets.left - insets.right;
            int n2 = (int)((Dimension)cloneable2).getHeight() - cloneable.top - cloneable.bottom - insets.top - insets.bottom;
            ApplianceSessionInfo applianceSessionInfo = JFrameViewer.this.m_applianceSession.getPersistentDataReference();
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("(JFrameViewer componentResizedNonAutoScale) nX:" + n + " nY:" + n2 + " sessionInfo.getPanedWidth:" + applianceSessionInfo.getPanedWidth() + " sessionInfo.getPanedHeight:" + applianceSessionInfo.getPanedHeight()));
            int n3 = (int)((Dimension)cloneable2).getWidth();
            int n4 = (int)((Dimension)cloneable2).getHeight();
            boolean bl = false;
            if (n > applianceSessionInfo.getPanedWidth()) {
                Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("(JFrameViewer componentResizedNonAutoScale) nX > sessionInfo.getPanedWidth() " + applianceSessionInfo.getPanedWidth()));
                n3 = applianceSessionInfo.getPanedWidth() + cloneable.left + cloneable.right + insets.left + insets.right;
                bl = true;
            }
            if (n2 > applianceSessionInfo.getPanedHeight()) {
                Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("(JFrameViewer componentResizedNonAutoScale) nY > sessionInfo.getPanedHeight() " + applianceSessionInfo.getPanedHeight()));
                n4 = applianceSessionInfo.getPanedHeight() + cloneable.top + cloneable.bottom + insets.top + insets.bottom;
                bl = true;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            Insets insets2 = toolkit.getScreenInsets(JFrameViewer.this.getGraphicsConfiguration());
            dimension = new Dimension(dimension.width - insets2.left - insets2.right, dimension.height - insets2.top - insets2.bottom);
            if (dimension.height < n4) {
                n4 = dimension.height;
                bl = true;
            }
            if (dimension.width < n3) {
                n3 = dimension.width;
                bl = true;
            }
            if (bl) {
                Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("(JFrameViewer componentResizedNonAutoScale) calling setSize, nNewX:" + n3 + " nNewY:" + n4));
                JFrameViewer.this.setSize(n3, n4);
                JFrameViewer.this.m_toolbar.setLocationOnParentResize(n3 - insets.right);
            } else {
                Dimension dimension2 = JFrameViewer.this.m_layeredPane.getSize();
                Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("(JFrameViewer componentResizedNonAutoScale) sizeLayeredPane width=" + dimension2.width + "sizeLayeredPane height=" + dimension2.height));
                JFrameViewer.this.m_applianceScrollPane.setSize(dimension2);
                JFrameViewer.this.m_applianceScrollPane.validate();
                JFrameViewer.this.m_toolbar.setLocationOnParentResize(dimension2.width);
            }
            JFrameViewer.this.m_applianceScrollPane.setHorizontalScrollBarPolicy(30);
            JFrameViewer.this.m_applianceScrollPane.setVerticalScrollBarPolicy(20);
            JFrameViewer.this.m_appliancePanel.repaint();
            JFrameViewer.this.showBusyCursor(false);
        }

        public void componentResizedAutoScale() {
            int n;
            Cloneable cloneable;
            Cloneable cloneable2;
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer componentResizedAutoScale) in auto scale mode");
            ApplianceSessionInfo applianceSessionInfo = JFrameViewer.this.m_applianceSession.getPersistentData();
            if (JFrameViewer.this.m_bThrottleScalingActive) {
                Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer componentResizedAutoScale) in auto scale mode, doing nothing because thottle scaling is active");
                JFrameViewer.this.showBusyCursor(false);
                return;
            }
            if (OS.isLinux() || OS.isSolaris()) {
                if (JFrameViewer.this.m_bAlreadySizing) {
                    Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer componentResizedNonAutoScale) already sizing, returning");
                    JFrameViewer.this.showBusyCursor(false);
                    return;
                }
                JFrameViewer.this.m_bAlreadySizing = true;
                do {
                    cloneable2 = JFrameViewer.this.getSize();
                    Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("(JFrameViewer componentResizedNonAutoScale) OS.isLinux, size.width=" + ((Dimension)cloneable2).width + " size.height=" + ((Dimension)cloneable2).height));
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    cloneable = JFrameViewer.this.getSize();
                } while (((Dimension)cloneable2).width != ((Dimension)cloneable).width || ((Dimension)cloneable2).height != ((Dimension)cloneable).height);
                JFrameViewer.this.m_bAlreadySizing = false;
                if (JFrameViewer.this.m_bFromFullScreenMode) {
                    Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("sessionInfo.getPanedWidth()=" + applianceSessionInfo.getPanedWidth() + " sessionInfo.getPanedHeight()=" + applianceSessionInfo.getPanedHeight()));
                    Dimension dimension = new Dimension(applianceSessionInfo.getPanedWidth(), applianceSessionInfo.getPanedHeight());
                    cloneable = dimension;
                    JFrameViewer.this.m_bFromFullScreenMode = false;
                }
                cloneable2 = cloneable;
                Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("(JFrameViewer componentResizedNonAutoScale) OS.isLinux, waited for frame size to settle down size.width=" + ((Dimension)cloneable2).width + " size.height=" + ((Dimension)cloneable2).height));
            } else {
                cloneable2 = JFrameViewer.this.getSize();
            }
            cloneable = JFrameViewer.this.getInsets();
            Insets insets = JFrameViewer.this.m_applianceScrollPane.getInsets();
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("(JFrameViewer componentResizedNonAutoScale) insets.left=" + cloneable.left + " insets.right=" + cloneable.right + " insets.top=" + cloneable.top + " insets.bottom=" + cloneable.bottom));
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("(JFrameViewer componentResizedNonAutoScale) insetsScrollPane.left=" + insets.left + " insetsScrollPane.right=" + insets.right + " insetsScrollPane.top=" + insets.top + " insetsScrollPane.bottom=" + insets.bottom));
            int n2 = (int)((Dimension)cloneable2).getWidth() - cloneable.left - cloneable.right - insets.left - insets.right;
            int n3 = (int)((Dimension)cloneable2).getHeight() - cloneable.top - cloneable.bottom - insets.top - insets.bottom;
            boolean bl = true;
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("(JFrameViewer componentResizedAutoScale) nX:" + n2 + " nY:" + n3 + " sessionInfo.getPanedWidth:" + applianceSessionInfo.getPanedWidth() + " sessionInfo.getPanedHeight:" + applianceSessionInfo.getPanedHeight()));
            if (n2 > 1024 || n3 > 768) {
                int n4 = 1024 + cloneable.left + cloneable.right + insets.left + insets.right;
                int n5 = 768 + cloneable.top + cloneable.bottom + insets.top + insets.bottom;
                Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("(JFrameViewer componentResizedAutoScale) size of panel is larger than permissible size, calling setSize, nNewX:" + n4 + " nNewY:" + n5));
                JFrameViewer.this.setSize(n4, n5);
                if (LinuxLibrary.isLibraryLoaded() || SolarisLibrary.isLibraryLoaded()) {
                    JFrameViewer.this.validate();
                }
                if (bl) {
                    applianceSessionInfo.terminate();
                }
                JFrameViewer.this.showBusyCursor(false);
                return;
            }
            if (n2 == applianceSessionInfo.getPanedWidth() && n3 == applianceSessionInfo.getPanedHeight() && applianceSessionInfo.getDecimationFactor() == 1) {
                Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer componentResizedAutoScale) no panel resize necessary");
                int n6 = applianceSessionInfo.getPanedWidth() + cloneable.left + cloneable.right + insets.left + insets.right;
                int n7 = applianceSessionInfo.getPanedHeight() + cloneable.top + cloneable.bottom + insets.top + insets.bottom;
                if (((Dimension)cloneable2).width != n6 || ((Dimension)cloneable2).height != n7) {
                    Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("(JFrameViewer componentResizedAutoScale) size of panel didn't change, but window size doesn't match calculated new size, calling setSize, nNewX:" + n6 + " nNewY:" + n7));
                    JFrameViewer.this.setSize(n6, n7);
                    if (LinuxLibrary.isLibraryLoaded() || SolarisLibrary.isLibraryLoaded()) {
                        JFrameViewer.this.validate();
                    }
                }
                try {
                    JFrameViewer.this.m_applianceSession.cmdStartVideo();
                }
                catch (Exception exception) {
                    Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                }
                if (bl) {
                    applianceSessionInfo.terminate();
                }
                JFrameViewer.this.showBusyCursor(false);
                return;
            }
            JFrameViewer.this.throttleScaling(true);
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (((Dimension)cloneable2).getWidth() > JFrameViewer.this.m_sizeFrame.getWidth() || ((Dimension)cloneable2).getHeight() > JFrameViewer.this.m_sizeFrame.getHeight()) {
                bl2 = true;
            }
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("(JFrameViewer componentResizedAutoScale) bMakingLarger=" + bl2));
            int n8 = 0;
            int n9 = 0;
            int n10 = 1;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Dimension dimension = toolkit.getScreenSize();
            Insets insets2 = toolkit.getScreenInsets(JFrameViewer.this.getGraphicsConfiguration());
            dimension = new Dimension(dimension.width - insets2.left - insets2.right, dimension.height - insets2.top - insets2.bottom);
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("(JFrameViewer componentResizedAutoScale) m_sizeScreen:" + dimension.getWidth() + "x" + dimension.getHeight() + " bMakingLarger:" + bl2 + " bWidthChanging:" + bl3));
            if (bl2) {
                if ((n2 > 960 || n3 > 720) && dimension.getWidth() > 1024.0 && dimension.getHeight() > 768.0) {
                    n8 = 1024;
                    n9 = 768;
                    bl4 = true;
                } else if ((n2 > 896 || n3 > 672) && dimension.getWidth() > 1024.0 && dimension.getHeight() > 768.0) {
                    n8 = 960;
                    n9 = 720;
                    bl4 = dimension.getWidth() >= 1024.0;
                } else if ((n2 > 832 || n3 > 624) && dimension.getWidth() > 960.0 && dimension.getHeight() > 720.0) {
                    n8 = 896;
                    n9 = 672;
                } else if ((n2 > 768 || n3 > 576) && dimension.getWidth() > 896.0 && dimension.getHeight() > 672.0) {
                    n8 = 832;
                    n9 = 624;
                } else if ((n2 > 704 || n3 > 528) && dimension.getWidth() > 832.0 && dimension.getHeight() > 624.0) {
                    n8 = 768;
                    n9 = 576;
                } else if ((n2 > 640 || n3 > 480) && dimension.getWidth() > 768.0 && dimension.getHeight() > 576.0) {
                    n8 = 704;
                    n9 = 528;
                    bl4 = dimension.getWidth() >= 800.0;
                } else if ((n2 > 512 || n3 > 384) && dimension.getWidth() > 704.0 && dimension.getHeight() > 528.0) {
                    n8 = 640;
                    n9 = 480;
                } else if (!JFrameViewer.this.m_applianceSession.isConnectionShared()) {
                    if (n2 > 416 || n3 > 312) {
                        n8 = 1024;
                        n9 = 768;
                        n10 = 2;
                        bl4 = dimension.getWidth() >= 640.0;
                    } else if (n2 > 320 || n3 > 240) {
                        n8 = 832;
                        n9 = 624;
                        n10 = 2;
                    } else if (n2 > 213 || n3 > 160) {
                        n8 = 640;
                        n9 = 480;
                        n10 = 2;
                    } else if (n2 > 160 || n3 > 120) {
                        n8 = 640;
                        n9 = 480;
                        n10 = 3;
                    } else if (n2 > 128 || n3 > 96) {
                        n8 = 640;
                        n9 = 480;
                        n10 = 4;
                    } else {
                        Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer componentResizedAutoScale) bMakingLarger true, bWidthChanging true, 640x480 which should never occur");
                        n8 = 640;
                        n9 = 480;
                        n10 = 5;
                    }
                } else {
                    n8 = 640;
                    n9 = 480;
                    n10 = 1;
                }
            } else {
                n = 0;
                if (!JFrameViewer.this.m_applianceSession.isConnectionShared()) {
                    if (n2 < 160 || n3 < 120) {
                        n8 = 640;
                        n9 = 480;
                        n10 = 5;
                        n = 1;
                    } else if (n2 < 213 || n3 < 160) {
                        n8 = 640;
                        n9 = 480;
                        n10 = 4;
                        n = 1;
                    } else if (n2 < 320 || n3 < 240) {
                        n8 = 640;
                        n9 = 480;
                        n10 = 3;
                        n = 1;
                    } else if (n2 < 416 || n3 < 312) {
                        n8 = 640;
                        n9 = 480;
                        n10 = 2;
                        n = 1;
                    } else if (n2 < 512 || n3 < 384) {
                        n8 = 832;
                        n9 = 624;
                        n10 = 2;
                        n = 1;
                    } else if (n2 < 640 || n3 < 480) {
                        n8 = 1024;
                        n9 = 768;
                        n10 = 2;
                        n = 1;
                    }
                }
                if (n == 0) {
                    if (n2 < 704 || n3 < 528) {
                        n8 = 640;
                        n9 = 480;
                    } else if (n2 < 768 || n3 < 576) {
                        n8 = 704;
                        n9 = 528;
                    } else if (n2 < 832 || n3 < 624) {
                        n8 = 768;
                        n9 = 576;
                    } else if (n2 < 896 || n3 < 672) {
                        n8 = 832;
                        n9 = 624;
                    } else if (n2 < 960 || n3 < 720) {
                        n8 = 896;
                        n9 = 672;
                    } else if (n2 < 1024 || n3 < 768) {
                        n8 = 960;
                        n9 = 720;
                    } else {
                        Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer componentResizedAutoScale) bMakingLarger false, bWidthChanging true, 1024x768 which should never occur");
                        n8 = 1024;
                        n9 = 768;
                        bl4 = true;
                    }
                }
            }
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("(JFrameViewer componentResizedAutoScale) nNewX=" + n8 + " nNewY=" + n9));
            try {
                n = applianceSessionInfo.getDecimationFactor();
                int n11 = applianceSessionInfo.getPanedWidth();
                int n12 = applianceSessionInfo.getPanedHeight();
                applianceSessionInfo.setPanedWidth((short)n8);
                applianceSessionInfo.setPanedHeight((short)n9);
                applianceSessionInfo.setDecimationFactor(n10);
                bl = false;
                JFrameViewer.this.m_applianceSession.setPersistentData(applianceSessionInfo);
                if (n != n10 && n11 == n8 && n12 == n9) {
                    Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer componentResizedAutoScale) calling cmdRefreshPane");
                    JFrameViewer.this.m_applianceSession.cmdRefreshPane();
                    JFrameViewer.this.showBusyCursor(false);
                } else if (n11 == n8 && n12 == n9) {
                    JFrameViewer.this.resizeVideoWindow(n8, n9);
                    JFrameViewer.this.showBusyCursor(false);
                } else {
                    Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer componentResizedAutoScale) calling cmdStartVideo");
                    JFrameViewer.this.m_applianceSession.cmdStartVideo();
                }
            }
            catch (Exception exception) {
                Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            }
            if (bl) {
                applianceSessionInfo.terminate();
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)("JFrameViewer.componentResized getExtendedState=" + JFrameViewer.this.getExtendedState()));
            if (JFrameViewer.this.m_bInInitWindow || JFrameViewer.this.m_bResizingVideoWindow) {
                return;
            }
            if ((JFrameViewer.this.getExtendedState() & 6) == 6) {
                int n = JFrameViewer.this.m_applianceSession.getConnectionType();
                if (n == 4 || n == 5 || n == 6) {
                    Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"JFrameViewer.componentResized getExtendedState == MAXIMIZED_BOTH not maximizing because connection type of user does not allow it");
                    JFrameViewer.this.setExtendedState(0);
                    return;
                }
                JFrameViewer.this.fullScreenToggle();
                return;
            }
            ApplianceSessionInfo applianceSessionInfo = JFrameViewer.this.m_applianceSession.getPersistentDataReference();
            JFrameViewer.this.showBusyCursor(true);
            if (!applianceSessionInfo.isAutoScale()) {
                this.componentResizedNonAutoScale();
            } else {
                this.componentResizedAutoScale();
            }
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }

    private class ApplianceWindowListener
    implements WindowListener {
        private ApplianceWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer windowClosing)");
            if (JFrameViewer.this.didUserConfirmOnClose()) {
                JFrameViewer.this.m_applianceSession.logEventSession(1);
                JFrameViewer.this.terminateSession();
            }
        }

        public void windowActivated(WindowEvent windowEvent) {
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameAppliance windowActivated)");
            try {
                JFrameViewer.this.m_appliancePanel.setVideoQueueSleepTimeActivated();
                try {
                    JFrameViewer.this.m_applianceSession.cmdFocusControl(false);
                    JFrameViewer.this.m_applianceSession.cmdFocusControl(true);
                }
                catch (IOException iOException) {
                    Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
                }
                JFrameViewer.this.setKeyboardLocks();
                MenuSelectionManager.defaultManager().clearSelectedPath();
                ApplianceSessionInfo applianceSessionInfo = JFrameViewer.this.m_applianceSession.getPersistentDataReference();
                if (applianceSessionInfo.isKeyboardPassthroughNonFullScreen()) {
                    if (Win32Library.isWin32LibLoaded()) {
                        Thread thread = new Thread(new Runnable(this){
                            private final /* synthetic */ ApplianceWindowListener this$1;
                            {
                                this.this$1 = applianceWindowListener;
                            }

                            public void run() {
                                Trace.logInfo((String)"VideoViewerTrace.JFrameViewer", (String)"JFrameViewer.windowActivated about to setLowLevelKeyboardHook");
                                JFrameViewer.access$1402(ApplianceWindowListener.access$1300(this.this$1), JFrameViewer.access$800(ApplianceWindowListener.access$1300(this.this$1)).setLowLevelKeyboardHook(JFrameViewer.access$1500(ApplianceWindowListener.access$1300(this.this$1)), false));
                                Trace.logInfo((String)"VideoViewerTrace.JFrameViewer", (String)"JFrameViewer.windowActivated returned from setLowLevelKeyboardHook");
                            }
                        });
                        thread.start();
                        int n = 100;
                        while (!JFrameViewer.this.m_bKeyboardHooked && n-- > 0) {
                            try {
                                Thread.sleep(20L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (!JFrameViewer.this.m_bKeyboardHooked) {
                            Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)"m_libWin32.setLowLevelKeyboardHook never returned");
                        }
                    } else if (LinuxLibrary.isLibraryLoaded()) {
                        JFrameViewer.this.setLinuxKeyboardPassThru(true, JFrameViewer.this);
                    } else if (SolarisLibrary.isLibraryLoaded()) {
                        JFrameViewer.this.setSolarisKeyboardPassThru(true, JFrameViewer.this);
                    }
                    JFrameViewer.this.b_ignorekey = false;
                } else {
                    if (LinuxLibrary.isLibraryLoaded()) {
                        JFrameViewer.this.setLinuxKeyboardPassThru(false, JFrameViewer.this);
                    } else if (SolarisLibrary.isLibraryLoaded()) {
                        JFrameViewer.this.setSolarisKeyboardPassThru(false, JFrameViewer.this);
                    }
                    String string = System.getProperty("com.avocent.video.locale");
                    if (string != null && string.equalsIgnoreCase("ja") && Win32Library.isWin32LibLoaded()) {
                        Thread thread = new Thread(new Runnable(this){
                            private final /* synthetic */ ApplianceWindowListener this$1;
                            {
                                this.this$1 = applianceWindowListener;
                            }

                            public void run() {
                                Trace.logInfo((String)"VideoViewerTrace.JFrameViewer", (String)"JFrameViewer.windowActivated about to setLowLevelKeyboardHook");
                                JFrameViewer.access$1402(ApplianceWindowListener.access$1300(this.this$1), JFrameViewer.access$800(ApplianceWindowListener.access$1300(this.this$1)).setLowLevelKeyboardHook(JFrameViewer.access$1500(ApplianceWindowListener.access$1300(this.this$1)), true));
                                Trace.logInfo((String)"VideoViewerTrace.JFrameViewer", (String)"JFrameViewer.windowActivated about to setLowLevelKeyboardHook");
                            }
                        });
                        thread.start();
                        int n = 100;
                        while (!JFrameViewer.this.m_bKeyboardHooked && n-- > 0) {
                            try {
                                Thread.sleep(20L);
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (!JFrameViewer.this.m_bKeyboardHooked) {
                            Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)"m_libWin32.setLowLevelKeyboardHook never returned");
                        }
                    }
                }
            }
            catch (Exception exception) {
                Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer ApplianceWindowListener windowClosed)");
            if (JFrameViewer.this.m_bKeyboardHooked) {
                Thread thread = new Thread(new Runnable(this){
                    private final /* synthetic */ ApplianceWindowListener this$1;
                    {
                        this.this$1 = applianceWindowListener;
                    }

                    public void run() {
                        JFrameViewer.access$800(ApplianceWindowListener.access$1300(this.this$1)).resetLowLevelKeyboardHook();
                    }
                });
                thread.start();
                JFrameViewer.this.m_bKeyboardHooked = false;
            }
            try {
                if (JFrameViewer.this.m_bCloseSession) {
                    JFrameViewer.this.terminateSession();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameAppliance windowDeactivated)");
            ApplianceSessionInfo applianceSessionInfo = JFrameViewer.this.m_applianceSession.getPersistentDataReference();
            JFrameViewer.this.m_bWindowNotActiveCheckAltKey = true;
            if (JFrameViewer.this.m_bKeyboardHooked) {
                Thread thread = new Thread(new Runnable(this){
                    private final /* synthetic */ ApplianceWindowListener this$1;
                    {
                        this.this$1 = applianceWindowListener;
                    }

                    public void run() {
                        Trace.logInfo((String)"VideoViewerTrace.JFrameViewer", (String)"JFrameViewer.windowDeactivated about to resetLowLevelKeyboardHook");
                        JFrameViewer.access$800(ApplianceWindowListener.access$1300(this.this$1)).resetLowLevelKeyboardHook();
                        Trace.logInfo((String)"VideoViewerTrace.JFrameViewer", (String)"JFrameViewer.windowDeactivated returned from resetLowLevelKeyboardHook");
                        JFrameViewer.access$1402(ApplianceWindowListener.access$1300(this.this$1), false);
                    }
                });
                thread.start();
                int n = 100;
                while (JFrameViewer.this.m_bKeyboardHooked && n-- > 0) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (JFrameViewer.this.m_bKeyboardHooked) {
                    Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)"m_libWin32.resetLowLevelKeyboardHook never returned");
                }
                JFrameViewer.this.m_bKeyboardHooked = false;
            }
            JFrameViewer.this.activateSingleCursorMode(false);
            if (applianceSessionInfo.isKeyboardPassthroughNonFullScreen()) {
                if (LinuxLibrary.isLibraryLoaded()) {
                    JFrameViewer.this.setLinuxKeyboardPassThru(false, JFrameViewer.this);
                } else if (SolarisLibrary.isLibraryLoaded()) {
                    JFrameViewer.this.setSolarisKeyboardPassThru(false, JFrameViewer.this);
                }
                JFrameViewer.this.b_ignorekey = true;
            }
            if (JFrameViewer.this.m_appliancePanel != null) {
                JFrameViewer.this.m_appliancePanel.setVideoQueueSleepTimeDeactivated();
            }
            try {
                JFrameViewer.this.m_applianceSession.cmdFocusControl(false);
            }
            catch (Exception exception) {
                Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            }
        }

        public void windowDeiconified(WindowEvent windowEvent) {
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"JFrameViewer.windowDeiconified");
            if (OS.isLinux() || OS.isSolaris()) {
                Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"JFrameViewer.windowIconified RegisterNativeKeyListener");
                NativeAvocentLibrary.registerNativeKeyListener(JFrameViewer.this, JFrameViewer.this);
                JFrameViewer.this.b_KeyListenerActivated = true;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (JFrameViewer.this.m_bVideoStopped) {
                Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"JFrameViewer.windowDeiconified, video was stopped, starting video");
                try {
                    JFrameViewer.this.m_applianceSession.cmdStartVideo();
                    JFrameViewer.this.m_bVideoStopped = false;
                }
                catch (IOException iOException) {
                    Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
                }
            }
        }

        public void windowIconified(WindowEvent windowEvent) {
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"JFrameViewer.windowIconified");
            if (OS.isLinux() || OS.isSolaris()) {
                Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"JFrameViewer.windowIconified UnregisterNativeKeyListener");
                NativeAvocentLibrary.unregisterNativeKeyListener(JFrameViewer.this, JFrameViewer.this);
                JFrameViewer.this.b_KeyListenerActivated = false;
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (JFrameViewer.this.m_applianceSession.areScalingControlsEnabled() && !JFrameViewer.this.m_applianceSession.isConnectionShared()) {
                try {
                    Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"JFrameViewer.windowIconified, no shared users, stopping video");
                    JFrameViewer.this.m_applianceSession.cmdStopVideo();
                    JFrameViewer.this.m_bVideoStopped = true;
                    return;
                }
                catch (IOException iOException) {
                    Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
                }
            }
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        static /* synthetic */ JFrameViewer access$1300(ApplianceWindowListener applianceWindowListener) {
            return applianceWindowListener.JFrameViewer.this;
        }
    }

    private class MenuListenerReceiveKeys
    implements MenuListener {
        private MenuListenerReceiveKeys() {
        }

        public void menuCanceled(MenuEvent menuEvent) {
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer menuCanceled)");
            try {
                JFrameViewer.this.m_applianceSession.cmdFocusControl(true);
            }
            catch (IOException iOException) {
                Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
            }
            if (JFrameViewer.this.m_bWin32LibraryLoaded) {
                try {
                    Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"JFrameViewer.menuCanceled, setting Win32 mouse wheel hook");
                    if (!JFrameViewer.this.m_bUseNativeJavaKeyCodes) {
                        JFrameViewer.this.m_libWin32.processWindowsMessages(true);
                    }
                }
                catch (Exception exception) {
                    Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)("JFrameViewer.menuCanceled exception on setMouseWheelHook " + exception.getMessage()), (Throwable)exception);
                }
            } else if (LinuxLibrary.isLibraryLoaded()) {
                LinuxLibrary.startKeyListener(JFrameViewer.this);
            } else if (SolarisLibrary.isLibraryLoaded()) {
                SolarisLibrary.startKeyListener(JFrameViewer.this);
            }
        }

        public void menuDeselected(MenuEvent menuEvent) {
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer menuDeselected)");
            try {
                JFrameViewer.this.m_applianceSession.cmdFocusControl(true);
            }
            catch (IOException iOException) {
                Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
            }
            if (JFrameViewer.this.m_bWin32LibraryLoaded) {
                try {
                    Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"JFrameViewer.menuDeselected, setting Win32 mouse wheel hook");
                    if (!JFrameViewer.this.m_bUseNativeJavaKeyCodes) {
                        JFrameViewer.this.m_libWin32.processWindowsMessages(true);
                    }
                }
                catch (Exception exception) {
                    Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)("JFrameViewer.menuDeselected exception on setMouseWheelHook " + exception.getMessage()), (Throwable)exception);
                }
            } else if (LinuxLibrary.isLibraryLoaded()) {
                LinuxLibrary.startKeyListener(JFrameViewer.this);
            } else if (SolarisLibrary.isLibraryLoaded()) {
                SolarisLibrary.startKeyListener(JFrameViewer.this);
            }
        }

        public void menuSelected(MenuEvent menuEvent) {
            Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"(JFrameViewer menuSelected)");
            if (JFrameViewer.this.m_bWin32LibraryLoaded) {
                try {
                    Trace.logInfo((String)JFrameViewer.TRACE_CONTEXT, (String)"JFrameViewer.menuSelected, resetting Win32 mouse wheel hook");
                    if (!JFrameViewer.this.m_bUseNativeJavaKeyCodes) {
                        JFrameViewer.this.m_libWin32.processWindowsMessages(false);
                    }
                }
                catch (Exception exception) {
                    Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)("JFrameViewer.menuSelected exception on removeMouseWheelHook " + exception.getMessage()), (Throwable)exception);
                }
            } else if (LinuxLibrary.isLibraryLoaded()) {
                LinuxLibrary.stopKeyListener(JFrameViewer.this);
            } else if (SolarisLibrary.isLibraryLoaded()) {
                SolarisLibrary.stopKeyListener(JFrameViewer.this);
            }
            try {
                JFrameViewer.this.m_applianceSession.cmdFocusControl(false);
            }
            catch (IOException iOException) {
                Trace.logError((String)JFrameViewer.TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
            }
        }
    }
}

