/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.interfaces.SessionStatus;
import com.avocent.lib.util.OS;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.DSKeyListener;
import com.avocent.video.InterfaceNativeKeyEventListener;
import com.avocent.video.InterfaceViewWindow;
import com.avocent.video.JPanelAppliance;
import com.avocent.video.JPanelApplianceNonBuffered;
import com.avocent.video.KeyStroke;
import com.avocent.video.LinuxLibrary;
import com.avocent.video.NativeAvocentLibrary;
import com.avocent.video.PanelCommandButtons;
import com.avocent.video.SolarisLibrary;
import com.avocent.video.Win32Library;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;

public class JFrameViewerCmdPanel
extends JFrame
implements InterfaceViewWindow,
InterfaceNativeKeyEventListener {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    public static final String CNAME = "JFrameViewerCmdPanel";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    private ApplianceSession m_applianceSession;
    private SessionStatus m_sessionStatus;
    private JPanelAppliance m_appliancePanel;
    private JScrollPane m_applianceScrollPane;
    private Dimension m_sizeFrame;
    JPanel m_panelContainer;
    private PanelCommandButtons m_panelCommandButtons;
    JPanel m_panelCommandButtonsContainer;
    private int m_nCmdButtonHeight;
    private int m_nCmdButtonWidth;
    private boolean m_bWaitingForInitialKBMouseStatus;
    private Win32Library m_libWin32;
    private boolean m_bWin32LibraryLoaded;
    private int m_nHWND;
    private boolean m_bInitRun;
    private boolean m_bAltKeyPressed;
    private boolean m_bAltKeyReleaseOnTabOrEscSent;
    private boolean m_bCtrlKeyPressed;
    private boolean m_bCtrlKeyReleaseOnEscSent;
    private boolean m_bCtrlButtonState;
    private boolean m_bAltButtonState;
    private boolean m_bSysReqButtonState;
    private short m_sLastScanCode;
    protected Vector m_vKeyPressedList;
    boolean m_bProcessingGeneratedKeyPress;
    private String m_szHelpURL;
    private boolean m_bEnableScalingControls;
    private boolean m_bInInitWindow;
    private boolean m_bResizingVideoWindow;
    private String m_szTitleOrig;
    private boolean m_bThrottleScalingActive;
    private boolean m_bInitWindowCalledSinceScaling;
    private boolean m_bWaitCursorActive;
    private boolean m_bSingleCursorModeActive;
    private boolean m_bTerminated;
    private boolean m_bKeyboardHooked;
    protected boolean m_bCloseSession;
    private boolean m_bFullScreen;
    private int m_nOrigWidth;
    private int m_nOrigHeight;
    private int m_nOrigDecimationFactor;
    private boolean m_bUseNativeJavaKeyCodes;
    private GraphicsConfiguration m_gc;
    private JPanel m_panelBlack;
    static /* synthetic */ Class class$com$avocent$video$JFrameViewerCmdPanel;

    public JFrameViewerCmdPanel(ApplianceSession applianceSession, String string, boolean bl) {
        Object object;
        block6: {
            this.m_panelContainer = new JPanel();
            this.m_panelCommandButtonsContainer = new JPanel();
            this.m_nCmdButtonHeight = 0;
            this.m_nCmdButtonWidth = 0;
            this.m_bWaitingForInitialKBMouseStatus = true;
            this.m_bWin32LibraryLoaded = false;
            this.m_nHWND = 0;
            this.m_bInitRun = false;
            this.m_bAltKeyPressed = false;
            this.m_bAltKeyReleaseOnTabOrEscSent = false;
            this.m_bCtrlKeyPressed = false;
            this.m_bCtrlKeyReleaseOnEscSent = false;
            this.m_bCtrlButtonState = false;
            this.m_bAltButtonState = false;
            this.m_bSysReqButtonState = false;
            this.m_sLastScanCode = 0;
            this.m_vKeyPressedList = new Vector();
            this.m_bProcessingGeneratedKeyPress = false;
            this.m_bEnableScalingControls = true;
            this.m_bInInitWindow = false;
            this.m_bResizingVideoWindow = false;
            this.m_bThrottleScalingActive = false;
            this.m_bInitWindowCalledSinceScaling = false;
            this.m_bWaitCursorActive = false;
            this.m_bSingleCursorModeActive = false;
            this.m_bTerminated = false;
            this.m_bKeyboardHooked = false;
            this.m_bCloseSession = false;
            this.m_bFullScreen = false;
            this.m_bUseNativeJavaKeyCodes = false;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JFrameViewerCmdPanel constructor)");
            this.m_bUseNativeJavaKeyCodes = bl;
            try {
                this.m_libWin32 = new Win32Library();
                JFrameViewerCmdPanel jFrameViewerCmdPanel = this;
                jFrameViewerCmdPanel.m_libWin32.initLib();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Trace.logError((String)TRACE_CONTEXT, (String)unsatisfiedLinkError.getMessage(), (Throwable)unsatisfiedLinkError);
                if (OS.isLinux()) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("Was Linux native library loaded? " + (LinuxLibrary.isLibraryLoaded() ? "YES" : "NO")));
                }
                if (!OS.isSolaris()) break block6;
                Trace.logInfo((String)TRACE_CONTEXT, (String)("Was Solaris native library loaded? " + (SolarisLibrary.isLibraryLoaded() ? "YES" : "NO")));
            }
        }
        JFrameViewerCmdPanel jFrameViewerCmdPanel = this;
        this.m_bWin32LibraryLoaded = jFrameViewerCmdPanel.m_libWin32.isWin32LibLoaded();
        this.m_applianceSession = applianceSession;
        this.m_szHelpURL = string;
        this.m_applianceSession.registerWindow(this);
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JFrameViewerCmdPanel constructor) after registerWindow");
        if (this.m_applianceSession.getTitle() == null || this.m_applianceSession.getTitle().length() == 0) {
            this.setTitle(RES.getString("JFrameViewerCmdPanel_Video_Session_Viewer"));
        } else {
            this.setTitle(this.m_applianceSession.getTitle());
        }
        this.setupPanes();
        if (!(this.m_bWin32LibraryLoaded || LinuxLibrary.isLibraryLoaded() || SolarisLibrary.isLibraryLoaded())) {
            object = new DSKeyListener(this.m_applianceSession);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel constructor) adding key listener:" + object));
            this.m_appliancePanel.addKeyListener((KeyListener)object);
            this.m_appliancePanel.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    JFrameViewerCmdPanel.this.m_appliancePanel.requestFocusInWindow();
                }
            });
        }
        object = this.m_applianceSession.getPersistentData();
        this.initWindow(this.m_applianceSession, 0, 0, ((ApplianceSessionInfo)object).getPanedWidth(), ((ApplianceSessionInfo)object).getPanedHeight(), ((ApplianceSessionInfo)object).getVideoWidth(), ((ApplianceSessionInfo)object).getVideoHeight(), ((ApplianceSessionInfo)object).getDecimationFactor());
        this.m_bWaitingForInitialKBMouseStatus = false;
        this.setKeyboardLocks();
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        };
        this.m_gc = this.getGraphicsConfiguration();
        new ThreadWaitForInitialKBMouseStatus();
    }

    protected void initialize() {
    }

    private void setupPanes() {
        Serializable serializable;
        try {
            serializable = new ImageIcon((class$com$avocent$video$JFrameViewerCmdPanel == null ? (class$com$avocent$video$JFrameViewerCmdPanel = JFrameViewerCmdPanel.class$("com.avocent.video.JFrameViewerCmdPanel")) : class$com$avocent$video$JFrameViewerCmdPanel).getResource("images/connectvideo16.gif"));
            this.setIconImage(serializable.getImage());
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
        this.m_appliancePanel = OS.isLinux() ? new JPanelApplianceNonBuffered(this.m_applianceSession) : new JPanelAppliance(this.m_applianceSession);
        this.m_panelCommandButtons = new PanelCommandButtons(this, this.m_nHWND, this.m_appliancePanel, this.m_applianceSession, this.m_szHelpURL);
        serializable = new GridBagLayout();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.m_panelCommandButtonsContainer.setBorder(BorderFactory.createEtchedBorder());
        this.m_panelCommandButtonsContainer.setLayout((LayoutManager)((Object)serializable));
        this.m_panelCommandButtonsContainer.add((Component)this.m_panelCommandButtons, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.01, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_panelContainer.setLayout(gridBagLayout);
        this.m_panelContainer.add((Component)this.m_panelCommandButtonsContainer, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.01, 15, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.m_nCmdButtonHeight = this.m_panelCommandButtons.getPanelHeight();
        this.m_nCmdButtonWidth = this.m_panelCommandButtons.getPanelWidth();
        this.m_applianceScrollPane = new JScrollPane(this.m_appliancePanel, 20, 30);
        this.getContentPane().add("Center", this.m_applianceScrollPane);
        this.getContentPane().add("South", this.m_panelContainer);
        this.m_applianceScrollPane.setVisible(true);
        this.addWindowListener(new ApplianceWindowListener());
        this.addComponentListener(new ApplianceComponentListener());
        this.m_sizeFrame = new Dimension(this.getSize());
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"jbInit error", (Throwable)exception);
        }
        this.initialize();
    }

    private void jbInit() throws Exception {
        Serializable serializable;
        this.m_applianceScrollPane.setBorder(null);
        if (this.m_bWin32LibraryLoaded) {
            try {
                serializable = this.m_libWin32.getDesktopWorkArea().getLocation();
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel jbInit) windows client location:" + ((Point)serializable).getX() + ", " + ((Point)serializable).getY()));
                this.setLocation((Point)serializable);
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
            }
        }
        serializable = this.m_applianceSession.getPersistentData();
        this.m_panelCommandButtons.setMouseAcceleration(((ApplianceSessionInfo)serializable).getMouseScaleType());
        this.m_applianceSession.cmdMouseAcceleration(((ApplianceSessionInfo)serializable).getMouseScaleType());
    }

    public void initWindow(ApplianceSession applianceSession, int n, int n2, short s, short s2, short s3, short s4, int n3) {
        this.initWindow(applianceSession, n, n2, s, s2, s3, s4, n3, true);
    }

    public void initWindow(ApplianceSession applianceSession, int n, int n2, short s, short s2, short s3, short s4, int n3, boolean bl) {
        if (this.m_bInInitWindow) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel initWindow) already in initWindow not using these parameters, nBitmapWidth:" + s + " nBitmapHeight:" + s2 + " nDecimationFactor:" + n3));
            return;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel initWindow) nBitmapWidth:" + s + " nBitmapHeight:" + s2 + " nDecimationFactor:" + n3));
        boolean bl2 = false;
        this.m_bInInitWindow = true;
        boolean bl3 = this.isVisible();
        if (!bl3) {
            this.pack();
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel initWindow) isVisible: " + this.isVisible()));
        Insets insets = this.getInsets();
        Insets insets2 = this.m_applianceScrollPane.getInsets();
        this.m_sizeFrame = new Dimension(s / n3 + insets.left + insets.right + insets2.left + insets2.right, s2 / n3 + insets.top + insets.bottom + insets2.top + insets2.bottom + this.m_nCmdButtonHeight);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        if (this.m_bWin32LibraryLoaded) {
            try {
                Rectangle rectangle = this.m_libWin32.getDesktopWorkArea();
                dimension = new Dimension((int)rectangle.getWidth(), (int)rectangle.getHeight());
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel initWindow) windows client size:" + dimension.getWidth() + ", " + dimension.getHeight()));
            }
            catch (ExceptionRequestFailed exceptionRequestFailed) {
                Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
            }
        }
        boolean bl4 = true;
        if (this.m_sizeFrame.getWidth() > dimension.getWidth()) {
            this.m_sizeFrame = new Dimension((int)dimension.getWidth(), (int)this.m_sizeFrame.getHeight());
            bl4 = false;
        }
        if (this.m_sizeFrame.getHeight() > dimension.getHeight()) {
            this.m_sizeFrame = new Dimension((int)this.m_sizeFrame.getWidth(), (int)dimension.getHeight());
            bl4 = false;
        }
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        if (!bl4 && applianceSessionInfo.isAutoScale()) {
            Dimension dimension2 = new Dimension(s, s2);
            do {
                dimension2 = JFrameViewerCmdPanel.getNextSmallerResolution(dimension2);
                s = (short)dimension2.getWidth();
                s2 = (short)dimension2.getHeight();
                this.m_sizeFrame = new Dimension(s / n3 + insets.left + insets.right + insets2.left + insets2.right, s2 / n3 + insets.top + insets.bottom + insets2.top + insets2.bottom + this.m_nCmdButtonHeight);
            } while (this.m_sizeFrame.getWidth() > dimension.getWidth() || this.m_sizeFrame.getHeight() > dimension.getHeight());
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel initWindow) frame will not fit on desktop, next smallest resolution: " + dimension2.getWidth() + " x " + dimension2.getHeight()));
            try {
                applianceSessionInfo.setPanedWidth((short)dimension2.getWidth());
                applianceSessionInfo.setPanedHeight((short)dimension2.getHeight());
                this.m_applianceSession.setPersistentData(applianceSessionInfo);
                bl2 = true;
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            }
        }
        this.setSize((int)this.m_sizeFrame.getWidth(), (int)this.m_sizeFrame.getHeight());
        this.validate();
        this.m_appliancePanel.initPanelAppliance(this.m_applianceSession, n, n2, s, s2, s3, s4, n3, true, bl);
        this.m_appliancePanel.setPreferredSize(new Dimension(s, s2));
        this.m_appliancePanel.revalidate();
        this.m_applianceScrollPane.setVisible(true);
        this.m_appliancePanel.setVisible(true);
        this.m_panelCommandButtonsContainer.setPreferredSize(new Dimension(this.m_nCmdButtonWidth, this.m_nCmdButtonHeight));
        this.m_panelCommandButtonsContainer.revalidate();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel initWindow) m_sizeFrame width:" + this.m_sizeFrame.getWidth() + " Height:" + this.m_sizeFrame.getHeight() + " appliance panel width:" + this.m_appliancePanel.getWidth() + " Height:" + this.m_appliancePanel.getHeight() + " scroll pane width:" + this.m_applianceScrollPane.getWidth() + " Height:" + this.m_applianceScrollPane.getHeight()));
        if (!bl3) {
            this.setVisible(true);
        }
        this.m_bInitRun = true;
        this.m_bInInitWindow = false;
        this.m_bInitWindowCalledSinceScaling = true;
        this.toFront();
        if (bl2) {
            try {
                this.m_applianceSession.cmdStartVideo();
            }
            catch (IOException iOException) {}
        } else {
            try {
                this.m_applianceSession.cmdRefreshPane();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static Dimension getNextSmallerResolution(Dimension dimension) {
        int n = (int)dimension.getWidth();
        Dimension dimension2 = null;
        dimension2 = n > 1024 ? new Dimension(1024, 768) : (n > 960 ? new Dimension(960, 720) : (n > 896 ? new Dimension(896, 672) : (n > 832 ? new Dimension(832, 624) : (n > 768 ? new Dimension(768, 576) : (n > 704 ? new Dimension(704, 528) : new Dimension(640, 480))))));
        return dimension2;
    }

    public static Dimension getNextLargerResolution(Dimension dimension) {
        int n = (int)dimension.getWidth();
        Dimension dimension2 = null;
        dimension2 = n < 640 ? new Dimension(640, 480) : (n < 704 ? new Dimension(704, 528) : (n < 768 ? new Dimension(768, 576) : (n < 832 ? new Dimension(832, 624) : (n < 896 ? new Dimension(896, 672) : (n < 960 ? new Dimension(960, 720) : new Dimension(1024, 768))))));
        return dimension2;
    }

    public static Dimension getNextResolution(Dimension dimension) {
        int n = (int)dimension.getWidth();
        if (n < 832) {
            return JFrameViewerCmdPanel.getNextLargerResolution(dimension);
        }
        return JFrameViewerCmdPanel.getNextSmallerResolution(dimension);
    }

    public void enableScalingControls(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel enableScalingControls) bEnable=" + bl));
        this.m_bEnableScalingControls = bl;
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        if (applianceSessionInfo.isAutoScale()) {
            this.setResizable(this.m_bEnableScalingControls);
        }
    }

    public boolean isSingleCursorActive() {
        return this.m_bSingleCursorModeActive;
    }

    public void activateSingleCursorMode(boolean bl) {
        if (Win32Library.isWin32LibLoaded()) {
            if (bl) {
                ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
                this.m_szTitleOrig = this.getTitle();
                KeyStroke keyStroke = new KeyStroke(2, 67, RES.getString("JFrameViewerCmdPanel_KEYCAP_F10"));
                try {
                    keyStroke = applianceSessionInfo.getSingleCursorTerminateKey();
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exceptionRequestFailed.getMessage(), (Throwable)exceptionRequestFailed);
                }
                Object[] objectArray = new Object[]{keyStroke.toString()};
                String string = MessageFormat.format(RES.getString("JFrameViewerCmdPanel_Single_Mouse_Caption_Addition"), objectArray);
                this.setTitle(this.m_szTitleOrig + string);
                Rectangle rectangle = this.m_appliancePanel.getBounds();
                Point point = rectangle.getLocation();
                SwingUtilities.convertPointToScreen(point, this.m_appliancePanel);
                this.m_libWin32.setSingleMouseMode(KeyStroke.getScanCodeForStandardSelectionKeyStroke(keyStroke), this, point.x, point.y, (int)rectangle.getWidth() / applianceSessionInfo.getDecimationFactor(), (int)rectangle.getHeight() / applianceSessionInfo.getDecimationFactor());
                this.m_appliancePanel.initSingleCursor();
                try {
                    this.m_applianceSession.cmdMouseAlign();
                }
                catch (IOException iOException) {
                    Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
                }
                this.m_bSingleCursorModeActive = true;
            } else if (this.m_bSingleCursorModeActive) {
                this.m_libWin32.resetSingleMouseMode();
                this.notifySingleCursorDeactivated();
            }
        }
    }

    public void activateAltButtonState(boolean bl) {
        this.m_bAltButtonState = bl;
    }

    public void activateCtrlButtonState(boolean bl) {
        this.m_bCtrlButtonState = bl;
    }

    public void activateSysReqButtonState(boolean bl) {
        this.m_bSysReqButtonState = bl;
    }

    public void initToolbar(ApplianceSession applianceSession) {
    }

    public final JPanelAppliance getPanelAppliance() {
        return this.m_appliancePanel;
    }

    public int getBitmapWidth() {
        return this.m_appliancePanel.getBitmapWidth();
    }

    public int getBitmapHeight() {
        return this.m_appliancePanel.getBitmapHeight();
    }

    public int getPixelArrayWidth() {
        return this.m_appliancePanel.getPixelArrayWidth();
    }

    public void mouseAlign() {
        try {
            this.m_applianceSession.cmdMouseAlign();
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"mouseAlign error", (Throwable)iOException);
        }
    }

    public void setConnectionType(int n) {
    }

    public void notifyLockedModeChanged() {
    }

    public void notifyReserveModeChanged() {
    }

    public void notifyManualVideoAdjustDialogClosed() {
    }

    public void notifyVmAvailableChanged() {
    }

    public void updateMouseAcceleration(int n) {
        this.m_panelCommandButtons.setMouseAcceleration(n);
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        applianceSessionInfo.setMouseScaleType(n);
        applianceSessionInfo.setMouseXGain(1.0);
        applianceSessionInfo.setMouseYGain(1.0);
        this.m_applianceSession.setPersistentData(applianceSessionInfo);
    }

    public void terminate() {
        this.setVisible(false);
        this.dispose();
        this.m_bCloseSession = true;
    }

    private void terminateSession() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JFrameViewerCmdPanel.terminate)");
        if (this.m_bTerminated) {
            return;
        }
        this.m_bTerminated = true;
        this.activateSingleCursorMode(false);
        try {
            this.m_applianceSession.terminateSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.m_appliancePanel != null) {
            try {
                this.m_appliancePanel.terminatePanelAppliance();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.isVisible()) {
            this.setVisible(false);
        }
        this.m_appliancePanel = null;
        this.m_applianceScrollPane = null;
        this.m_sizeFrame = null;
    }

    public void repaintAppliance() {
        this.repaint();
    }

    public void bringWindowToTop() {
        if (this.getState() == 1) {
            this.setState(0);
        }
        this.toFront();
        this.m_appliancePanel.setVideoQueueSleepTimeActivated();
    }

    public void fullScreenToggle() {
    }

    public boolean activateMenu() {
        return true;
    }

    void setPersistentDataForAutoScale(boolean bl) {
        try {
            ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
            applianceSessionInfo.setAutoScale(bl);
            applianceSessionInfo.setFullScale(false);
            this.m_applianceSession.setPersistentData(applianceSessionInfo);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    void setMouseAcceleration(int n) {
        try {
            this.m_applianceSession.cmdMouseAcceleration(n);
            ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
            applianceSessionInfo.setMouseScaleType(n);
            applianceSessionInfo.setMouseXGain(1.0);
            applianceSessionInfo.setMouseYGain(1.0);
            this.m_applianceSession.setPersistentData(applianceSessionInfo);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    void setPersistentDataForAutoScale(boolean bl, int n, int n2) {
        try {
            ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
            applianceSessionInfo.setAutoScale(bl);
            applianceSessionInfo.setFullScale(false);
            applianceSessionInfo.setPanedWidth((short)n);
            applianceSessionInfo.setPanedHeight((short)n2);
            if (!bl) {
                applianceSessionInfo.setDecimationFactor(1);
            }
            this.m_applianceSession.setPersistentData(applianceSessionInfo);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    private void throttleScaling(final boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JFrameViewerCmdPanel.throttleScaling)");
        if (this.m_bThrottleScalingActive) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JFrameViewerCmdPanel.throttleScaling) exiting because throttle scaling already active");
            return;
        }
        this.m_bThrottleScalingActive = true;
        if (this.m_applianceSession.getVideoEncodingType() == 1) {
            this.m_appliancePanel.ignoreVideoData(true);
        }
        if (bl) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JFrameViewerCmdPanel.throttleScaling) bAutoScale true, disabling resizing");
            this.setResizable(false);
        }
        this.m_bInitWindowCalledSinceScaling = false;
        Thread thread = new Thread(new Runnable(){

            public void run() {
                int n = 100;
                while (!JFrameViewerCmdPanel.this.m_bInitWindowCalledSinceScaling && n-- > 0) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                Trace.logInfo((String)JFrameViewerCmdPanel.TRACE_CONTEXT, (String)"(JFrameViewerCmdPanel.throttleScaling) out of loop");
                if (bl) {
                    Trace.logInfo((String)JFrameViewerCmdPanel.TRACE_CONTEXT, (String)"(JFrameViewerCmdPanel.throttleScaling) bAutoScale true, enabling resizing");
                    JFrameViewerCmdPanel.this.setResizable(JFrameViewerCmdPanel.this.m_applianceSession.areScalingControlsEnabled());
                }
                JFrameViewerCmdPanel.this.m_bThrottleScalingActive = false;
                Trace.logInfo((String)JFrameViewerCmdPanel.TRACE_CONTEXT, (String)"(JFrameViewerCmdPanel.throttleScaling) m_bThrottleScalingActive = false");
                if (JFrameViewerCmdPanel.this.m_applianceSession.getVideoEncodingType() == 1) {
                    JFrameViewerCmdPanel.this.m_appliancePanel.ignoreVideoData(false);
                    try {
                        Trace.logInfo((String)JFrameViewerCmdPanel.TRACE_CONTEXT, (String)"(JFrameViewerCmdPanel throttleScaling) calling cmdRefreshPane");
                        JFrameViewerCmdPanel.this.m_applianceSession.cmdRefreshPane();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
        thread.start();
    }

    private void setScaling(boolean bl, int n, int n2) {
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        if (!applianceSessionInfo.isFullScale() || applianceSessionInfo.getPanedHeight() != n2 || applianceSessionInfo.getPanedWidth() != n) {
            this.throttleScaling(bl);
        }
        this.setPersistentDataForAutoScale(bl, n, n2);
        try {
            this.m_applianceSession.cmdStartVideo();
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
        }
    }

    public void resizeVideoWindow(int n, int n2) {
        this.resizeVideoWindow(n, n2, true);
    }

    public void resizeVideoWindow(int n, int n2, boolean bl) {
        this.m_bResizingVideoWindow = true;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPane resizeVideoWindow) nWidth:" + n + " nHeight:" + n2));
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        if (LinuxLibrary.isLibraryLoaded() || SolarisLibrary.isLibraryLoaded()) {
            this.pack();
        }
        try {
            applianceSessionInfo.setPanedWidth((short)n);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(JFrameViewerCmdPane rescaleVideo) setPanedWidth error", (Throwable)exception);
        }
        try {
            applianceSessionInfo.setPanedHeight((short)n2);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(JFrameViewerCmdPane rescaleVideo) setPanedHeight error", (Throwable)exception);
        }
        this.m_applianceSession.setPersistentData(applianceSessionInfo);
        this.initWindow(this.m_applianceSession, 0, 0, (short)n, (short)n2, applianceSessionInfo.getVideoWidth(), applianceSessionInfo.getVideoHeight(), applianceSessionInfo.getDecimationFactor(), bl);
        this.m_bResizingVideoWindow = false;
    }

    public Frame getFrameWindow() {
        return this;
    }

    public void setSize(int n, int n2) {
        this.setExtendedState(0);
        super.setSize(n, n2);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPane setSize() ) width:" + n + " height:" + n2));
    }

    void setKeyboardLocks() {
        if (!this.m_bWaitingForInitialKBMouseStatus) {
            if (this.m_bWin32LibraryLoaded) {
                try {
                    this.m_applianceSession.cmdCapsLockSet(this.m_libWin32.isCapsLockSet());
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel setKeyboardLocks)" + exceptionRequestFailed.getMessage()), (Throwable)exceptionRequestFailed);
                }
            } else if (!OS.isLinux() && !OS.isSolaris()) {
                try {
                    this.m_applianceSession.cmdCapsLockSet(Toolkit.getDefaultToolkit().getLockingKeyState(20));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"getLockingKeyState caps lock error", (Throwable)unsupportedOperationException);
                }
            }
            if (this.m_bWin32LibraryLoaded) {
                try {
                    this.m_applianceSession.cmdNumLockSet(this.m_libWin32.isNumLockSet());
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel setKeyboardLocks)" + exceptionRequestFailed.getMessage()), (Throwable)exceptionRequestFailed);
                }
            } else if (!OS.isLinux() && !OS.isSolaris()) {
                try {
                    this.m_applianceSession.cmdNumLockSet(Toolkit.getDefaultToolkit().getLockingKeyState(144));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"getLockingKeyState num-lock error", (Throwable)unsupportedOperationException);
                }
            }
            if (this.m_bWin32LibraryLoaded) {
                try {
                    this.m_applianceSession.cmdScrollLockSet(this.m_libWin32.isScrollLockSet());
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel setKeyboardLocks)" + exceptionRequestFailed.getMessage()), (Throwable)exceptionRequestFailed);
                }
            } else if (!OS.isLinux() && !OS.isSolaris()) {
                try {
                    this.m_applianceSession.cmdScrollLockSet(Toolkit.getDefaultToolkit().getLockingKeyState(145));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"getLockingKeyState scroll lock error", (Throwable)unsupportedOperationException);
                }
            }
            if (this.m_bWin32LibraryLoaded) {
                try {
                    this.m_applianceSession.cmdKanaLockSet(this.m_libWin32.isKanaLockSet());
                }
                catch (ExceptionRequestFailed exceptionRequestFailed) {
                    Trace.logError((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel setKeyboardLocks)" + exceptionRequestFailed.getMessage()), (Throwable)exceptionRequestFailed);
                }
            } else if (!OS.isLinux() && !OS.isSolaris()) {
                try {
                    this.m_applianceSession.cmdKanaLockSet(Toolkit.getDefaultToolkit().getLockingKeyState(262));
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"getLockingKeyState kana lock error");
                }
            }
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"setKeyboardLocks: m_bWaitingForInitialKBMouseStatus true");
        }
    }

    public void notifyMouseWheel(short s, short s2, long l, long l2) {
        if (this.m_appliancePanel != null) {
            this.m_appliancePanel.mouseScrollNotify(s, s2, l, l2);
        }
    }

    public void notifyKeyPressedLinux(short s, int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameCmdPanel.notifyKeyPressedLinux sScanCode:" + s + " nKeyState=" + n));
        boolean bl = (n & 1) != 0;
        boolean bl2 = (n & 2) != 0;
        this.m_applianceSession.cmdNumLockSet(bl);
        this.m_applianceSession.cmdCapsLockSet(bl2);
        this.notifyKeyPressed(s);
    }

    public void notifyKeyPressed(short s) {
        if (SolarisLibrary.isLibraryLoaded()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewerCmdPanel.notifyKeyPressed Solaris KeyPress sScanCode:" + s));
            this.m_applianceSession.cmdKeyPressed(s + 1);
            if (s + 1 == 83 || s + 1 == 57) {
                this.m_applianceSession.cmdKeyReleased(s + 1);
            }
            return;
        }
        if (!this.m_bKeyboardHooked && (s == 107 || s == 108) && OS.isWindows()) {
            return;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewerCmdPanel.notifyKeyPressed sScanCode:" + s));
        if (LinuxLibrary.isLibraryLoaded() && !this.m_bProcessingGeneratedKeyPress) {
            this.m_vKeyPressedList.addElement(new Short(s));
        }
        if (!this.m_bKeyboardHooked) {
            if (s == 56 || s == 105) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewerCmdPanel.notifyKeyPressed ALT key pressed");
                this.m_bAltKeyPressed = true;
                this.m_bAltKeyReleaseOnTabOrEscSent = false;
            } else if (s == 29 || s == 101) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewerCmdPanel.notifyKeyPressed CTRL key pressed");
                this.m_bCtrlKeyPressed = true;
                this.m_bCtrlKeyReleaseOnEscSent = false;
            }
        }
        if (this.m_bCtrlButtonState && !this.m_bCtrlKeyPressed && !this.m_bAltKeyPressed) {
            this.m_applianceSession.cmdKeyPressed(17, '\uffff', 2);
            this.m_sLastScanCode = s;
        }
        if (this.m_bAltButtonState && !this.m_bCtrlKeyPressed && !this.m_bAltKeyPressed) {
            this.m_applianceSession.cmdKeyPressed(18, '\uffff', 2);
            this.m_sLastScanCode = s;
        }
        if (this.m_bSysReqButtonState) {
            this.m_applianceSession.cmdKeyPressed(154, '\uffff', 2);
            this.m_sLastScanCode = s;
        }
        this.m_applianceSession.cmdScanCodeKeyPressed(s);
    }

    public void notifyKeyReleased(short s) {
        Object object;
        if (SolarisLibrary.isLibraryLoaded()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewerCmdPanel.notifyKeyReleased Solaris KeyRelease sScanCode:" + s));
            if (s + 1 == 83 || s + 1 == 57) {
                this.m_applianceSession.cmdKeyPressed(s + 1);
            }
            this.m_applianceSession.cmdKeyReleased(s + 1);
            return;
        }
        if (!this.m_bKeyboardHooked && (s == 107 || s == 108) && OS.isWindows()) {
            return;
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JFrameViewerCmdPanel.notifyKeyReleased sScanCode:" + s));
        if (LinuxLibrary.isLibraryLoaded()) {
            object = this.getKeyPressForScanCode(s);
            if (object == null) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("Generating missing key press for sScanCode:" + s));
                this.m_bProcessingGeneratedKeyPress = true;
                this.notifyKeyPressed(s);
                this.m_bProcessingGeneratedKeyPress = false;
            } else {
                this.m_vKeyPressedList.removeElement(object);
            }
        }
        if (!this.m_bKeyboardHooked) {
            if (s == 56 || s == 105) {
                this.m_bAltKeyPressed = false;
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewerCmdPanel.notifyKeyReleased ALT key released");
                this.m_bAltKeyReleaseOnTabOrEscSent = false;
            } else if (s == 29 || s == 101) {
                this.m_bCtrlKeyPressed = false;
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewerCmdPanel.notifyKeyReleased CTRL key released");
                this.m_bCtrlKeyReleaseOnEscSent = false;
            }
            if (this.m_bAltKeyPressed && (s == 15 || s == 1)) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewerCmdPanel.notifyKeyReleased TAB or ESC key released with ALT down");
                if (!this.m_bAltKeyReleaseOnTabOrEscSent) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewerCmdPanel.notifyKeyReleased sending ALT key released then pressed/released pair");
                    object = new Thread(new Runnable(){

                        public void run() {
                            JFrameViewerCmdPanel.this.m_applianceSession.cmdKeyReleased(18);
                            JFrameViewerCmdPanel.this.m_applianceSession.cmdKeyPressed(18);
                            JFrameViewerCmdPanel.this.m_applianceSession.cmdKeyReleased(18);
                        }
                    });
                    ((Thread)object).start();
                    this.m_bAltKeyReleaseOnTabOrEscSent = true;
                }
                return;
            }
            if (this.m_bCtrlKeyPressed && s == 1) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewerCmdPanel.notifyKeyReleased ESC key released with CTRL down");
                if (!this.m_bCtrlKeyReleaseOnEscSent) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewerCmdPanel.notifyKeyReleased sending CTRL key released");
                    object = new Thread(new Runnable(){

                        public void run() {
                            JFrameViewerCmdPanel.this.m_applianceSession.cmdKeyReleased(17);
                        }
                    });
                    ((Thread)object).start();
                    this.m_bCtrlKeyReleaseOnEscSent = true;
                }
                return;
            }
        }
        this.m_applianceSession.cmdScanKeyReleased(s);
        if (this.m_bSysReqButtonState && s == this.m_sLastScanCode) {
            this.m_applianceSession.cmdKeyReleased(154, '\uffff', 2);
            if (!this.m_bAltButtonState && !this.m_bCtrlButtonState) {
                this.m_sLastScanCode = 0;
            }
        }
        if (this.m_bCtrlButtonState && s == this.m_sLastScanCode) {
            this.m_applianceSession.cmdKeyReleased(17, '\uffff', 2);
            if (!this.m_bAltButtonState) {
                this.m_sLastScanCode = 0;
            }
        }
        if (this.m_bAltButtonState && s == this.m_sLastScanCode) {
            this.m_applianceSession.cmdKeyReleased(18, '\uffff', 2);
            this.m_sLastScanCode = 0;
        }
    }

    public void notifySingleCursorMouseMoved(short s, int n, int n2, short s2) {
        this.m_appliancePanel.singleCursorModeMouseNotify(s, s2, n, n2);
    }

    public void notifySingleCursorDeactivated() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewerCmdPanel.notifySingleCursorDeactivated");
        ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
        this.m_appliancePanel.setLocalCursorType(applianceSessionInfo.getLocalCursorType());
        this.setTitle(this.m_szTitleOrig);
        try {
            this.m_applianceSession.cmdMouseAlign();
        }
        catch (IOException iOException) {
            Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
        }
        this.m_bSingleCursorModeActive = false;
    }

    public void notifyMouseXButtonPressed(short s, int n, int n2) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewerCmdPanel.notifyMouseXButtonPressed");
        this.m_appliancePanel.mouseXButtonNotify(s, (short)0, n, n2);
    }

    public void notifyMaximizeButtonPressed() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewerCmdPanel.notifyMaximizeButtonPressed");
        if (this.getExtendedState() == 6) {
            this.setExtendedState(0);
        } else {
            this.setExtendedState(6);
        }
    }

    public void listeningWindowDeactivated() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewerCmdPanel.listeningWindowDeactivated");
        if (this.m_bAltKeyPressed) {
            this.m_bAltKeyPressed = false;
            if (!this.m_bAltKeyReleaseOnTabOrEscSent) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewerCmdPanel.listeningWindowDeactivated sending ALT key released then pressed/released pair");
                this.m_applianceSession.cmdKeyReleased(18);
                this.m_applianceSession.cmdKeyPressed(18);
                this.m_applianceSession.cmdKeyReleased(18);
                this.m_bAltKeyReleaseOnTabOrEscSent = true;
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.m_bWin32LibraryLoaded) {
            try {
                this.m_nHWND = this.m_libWin32.getHWND(this);
                this.setMouseWheelHook(this.m_nHWND, this);
                if (!this.m_bUseNativeJavaKeyCodes) {
                    this.m_libWin32.processWindowsMessages(true);
                }
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)("JFrameViewerCmdPanel.addNotify exception on setMouseWheelHook " + exception.getMessage()), (Throwable)exception);
            }
        } else if (LinuxLibrary.isLibraryLoaded() || SolarisLibrary.isLibraryLoaded()) {
            this.setVisible(true);
            NativeAvocentLibrary.registerNativeKeyListener(this, this);
        }
    }

    public void removeNotify() {
        if (this.m_bWin32LibraryLoaded) {
            try {
                this.resetMouseWheelHook(this.m_nHWND, this);
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)("JFrameViewerCmdPanel.removeNotify exception on removeMouseWheelHook " + exception.getMessage()), (Throwable)exception);
            }
        } else if (LinuxLibrary.isLibraryLoaded()) {
            LinuxLibrary.unregisterNativeKeyListener(this, this);
        } else if (SolarisLibrary.isLibraryLoaded()) {
            SolarisLibrary.unregisterNativeKeyListener(this, this);
        }
        super.removeNotify();
    }

    public Dimension inquireNewSize(Dimension dimension) {
        Insets insets = this.getInsets();
        Insets insets2 = this.m_applianceScrollPane.getInsets();
        int n = (int)dimension.getWidth() - insets.left - insets.right - insets2.left - insets2.right;
        int n2 = (int)dimension.getHeight() - insets.top - insets.bottom - insets2.top - insets2.bottom - this.m_nCmdButtonHeight;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel inquireNewSize) nX:" + n + " nY:" + n2));
        Dimension dimension2 = new Dimension(n + insets.left + insets.right + insets2.left + insets2.right, n2 + insets.top + insets.bottom + insets2.top + insets2.bottom + this.m_nCmdButtonHeight);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel inquireNewSize) returning X: " + dimension2.getWidth() + " Y:" + dimension2.getHeight()));
        return dimension2;
    }

    public void setNewSize(Rectangle rectangle) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel setNewSize) rNewBounds:" + rectangle.getLocation().getX() + " " + rectangle.getLocation().getY() + " " + rectangle.getWidth() + " " + rectangle.getHeight()));
        Insets insets = this.getInsets();
        Insets insets2 = this.m_applianceScrollPane.getInsets();
        int n = (int)rectangle.getWidth() - insets.left - insets.right - insets2.left - insets2.right;
        int n2 = (int)rectangle.getHeight() - insets.top - insets.bottom - insets2.top - insets2.bottom - this.m_nCmdButtonHeight;
        boolean bl = true;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JFrameViewerCmdPanel setNewSize) nX:" + n + " nY:" + n2));
        this.setBounds(rectangle);
        if (this.getState() == 1) {
            this.setState(0);
        }
        this.toFront();
    }

    private void resetMouseWheelHook(int n, JFrameViewerCmdPanel jFrameViewerCmdPanel) {
        if (!this.m_bUseNativeJavaKeyCodes) {
            this.m_libWin32.resetMouseWheelHook(n, jFrameViewerCmdPanel);
        }
    }

    private void setMouseWheelHook(int n, JFrameViewerCmdPanel jFrameViewerCmdPanel) {
        if (!this.m_bUseNativeJavaKeyCodes) {
            this.m_libWin32.setMouseWheelHook(n, jFrameViewerCmdPanel);
        }
    }

    Short getKeyPressForScanCode(short s) {
        Short s2 = null;
        for (int i = 0; i < this.m_vKeyPressedList.size(); ++i) {
            Short s3 = (Short)this.m_vKeyPressedList.elementAt(i);
            if (s3 != s) continue;
            s2 = s3;
            break;
        }
        return s2;
    }

    public void modalDialogActivated() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JFrameViewerCmdPanel:modalDialogActivated");
        if (this.m_applianceSession != null) {
            if (LinuxLibrary.isLibraryLoaded()) {
                LinuxLibrary.stopKeyListener(this);
            } else if (SolarisLibrary.isLibraryLoaded()) {
                SolarisLibrary.stopKeyListener(this);
            }
            try {
                this.m_applianceSession.cmdFocusControl(false);
            }
            catch (IOException iOException) {
                Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
            }
            if (LinuxLibrary.isLibraryLoaded()) {
                LinuxLibrary.startKeyListener(this);
            } else if (SolarisLibrary.isLibraryLoaded()) {
                SolarisLibrary.startKeyListener(this);
            }
        }
    }

    public Component getViewComponent() {
        return this;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class FileFilterJPEG
    extends FileFilter {
        public boolean accept(File file) {
            if (file.isHidden()) {
                return false;
            }
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName();
            return string.endsWith(".jpg") || string.endsWith(".jpeg");
        }

        public String getDescription() {
            return RES.getString("JFrameViewerCmdPanel_CaptureFileDescription");
        }
    }

    public class TransferableVideo
    implements Transferable {
        private Image m_image;

        public TransferableVideo(Image image) {
            this.m_image = image;
        }

        public Object getTransferData(DataFlavor dataFlavor) {
            if (dataFlavor.equals(DataFlavor.imageFlavor)) {
                return this.m_image;
            }
            return null;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[]{DataFlavor.imageFlavor};
            return dataFlavorArray;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return dataFlavor.equals(DataFlavor.imageFlavor);
        }
    }

    public class ClipboardOwnerVideo
    implements ClipboardOwner {
        public void lostOwnership(Clipboard clipboard, Transferable transferable) {
        }
    }

    private class ThreadWaitForInitialKBMouseStatus
    extends Thread {
        private ThreadWaitForInitialKBMouseStatus() {
            this.start();
        }

        public void run() {
            int n = 20;
            do {
                JFrameViewerCmdPanel.this.m_bWaitingForInitialKBMouseStatus = !JFrameViewerCmdPanel.this.m_applianceSession.isInitialKBMouseStatusReceived();
                if (JFrameViewerCmdPanel.this.m_bWaitingForInitialKBMouseStatus) {
                    try {
                        ThreadWaitForInitialKBMouseStatus.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (n-- > 0) continue;
                try {
                    JFrameViewerCmdPanel.this.m_applianceSession.cmdKBStatusRequest();
                }
                catch (IOException iOException) {
                    Trace.logError((String)JFrameViewerCmdPanel.TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
                }
                n = 20;
            } while (JFrameViewerCmdPanel.this.m_bWaitingForInitialKBMouseStatus && JFrameViewerCmdPanel.this.m_applianceSession.isSessionRunning());
            if (JFrameViewerCmdPanel.this.m_applianceSession.isSessionRunning()) {
                JFrameViewerCmdPanel.this.setKeyboardLocks();
            }
        }
    }

    private class ApplianceComponentListener
    implements ComponentListener {
        private ApplianceComponentListener() {
        }

        public void componentHidden(ComponentEvent componentEvent) {
        }

        public void componentMoved(ComponentEvent componentEvent) {
            GraphicsConfiguration graphicsConfiguration = JFrameViewerCmdPanel.this.getGraphicsConfiguration();
            if (graphicsConfiguration != JFrameViewerCmdPanel.this.m_gc) {
                JFrameViewerCmdPanel.this.m_appliancePanel.transferImage();
                JFrameViewerCmdPanel.this.m_gc = graphicsConfiguration;
            }
        }

        public void componentResizedNonAutoScale() {
            Trace.logInfo((String)JFrameViewerCmdPanel.TRACE_CONTEXT, (String)"(JFrameViewerCmdPanel componentResizedNonAutoScale) not in auto-scale mode view ");
            Dimension dimension = JFrameViewerCmdPanel.this.m_applianceScrollPane.getSize();
            boolean bl = false;
            if (JFrameViewerCmdPanel.this.m_appliancePanel.getBitmapWidth() < dimension.width) {
                bl = true;
            }
            if (JFrameViewerCmdPanel.this.m_appliancePanel.getBitmapHeight() < dimension.height) {
                bl = true;
            }
            if (bl && JFrameViewerCmdPanel.this.m_panelBlack == null) {
                JFrameViewerCmdPanel.this.m_applianceScrollPane.getViewport().remove(JFrameViewerCmdPanel.this.m_appliancePanel);
                JFrameViewerCmdPanel.this.m_panelBlack = new JPanel(new GridBagLayout());
                JFrameViewerCmdPanel.this.m_panelBlack.add(JFrameViewerCmdPanel.this.m_appliancePanel);
                JFrameViewerCmdPanel.this.m_panelBlack.setBackground(Color.black);
                JFrameViewerCmdPanel.this.m_panelBlack.setVisible(true);
                JFrameViewerCmdPanel.this.m_applianceScrollPane.getViewport().add(JFrameViewerCmdPanel.this.m_panelBlack);
            } else if (!bl && JFrameViewerCmdPanel.this.m_panelBlack != null) {
                JFrameViewerCmdPanel.this.m_applianceScrollPane.getViewport().remove(JFrameViewerCmdPanel.this.m_panelBlack);
                JFrameViewerCmdPanel.this.m_applianceScrollPane.getViewport().add(JFrameViewerCmdPanel.this.m_appliancePanel);
                JFrameViewerCmdPanel.this.m_panelBlack = null;
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            if (JFrameViewerCmdPanel.this.m_bInInitWindow || JFrameViewerCmdPanel.this.m_bResizingVideoWindow) {
                return;
            }
            this.componentResizedNonAutoScale();
        }

        public void componentShown(ComponentEvent componentEvent) {
        }
    }

    private class ApplianceWindowListener
    implements WindowListener {
        private ApplianceWindowListener() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Trace.logInfo((String)JFrameViewerCmdPanel.TRACE_CONTEXT, (String)"(JFrameViewerCmdPanel windowClosing)");
            JFrameViewerCmdPanel.this.terminateSession();
        }

        public void windowActivated(WindowEvent windowEvent) {
            Trace.logInfo((String)JFrameViewerCmdPanel.TRACE_CONTEXT, (String)"(JFrameViewerCmdPane windowActivated)");
            try {
                JFrameViewerCmdPanel.this.m_appliancePanel.setVideoQueueSleepTimeActivated();
                try {
                    JFrameViewerCmdPanel.this.m_applianceSession.cmdFocusControl(false);
                    JFrameViewerCmdPanel.this.m_applianceSession.cmdFocusControl(true);
                }
                catch (IOException iOException) {
                    Trace.logError((String)JFrameViewerCmdPanel.TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
                }
                JFrameViewerCmdPanel.this.setKeyboardLocks();
                MenuSelectionManager.defaultManager().clearSelectedPath();
                ApplianceSessionInfo applianceSessionInfo = JFrameViewerCmdPanel.this.m_applianceSession.getPersistentData();
                if (applianceSessionInfo.isKeyboardPassthroughNonFullScreen()) {
                    if (Win32Library.isWin32LibLoaded()) {
                        JFrameViewerCmdPanel.this.m_bKeyboardHooked = true;
                        JFrameViewerCmdPanel.this.m_libWin32.setLowLevelKeyboardHook(JFrameViewerCmdPanel.this.m_nHWND, false);
                    }
                } else {
                    String string = System.getProperty("com.avocent.video.locale");
                    if (string != null && string.equalsIgnoreCase("ja") && Win32Library.isWin32LibLoaded()) {
                        JFrameViewerCmdPanel.this.m_bKeyboardHooked = true;
                        JFrameViewerCmdPanel.this.m_libWin32.setLowLevelKeyboardHook(JFrameViewerCmdPanel.this.m_nHWND, true);
                    }
                }
            }
            catch (Exception exception) {
                Trace.logError((String)JFrameViewerCmdPanel.TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            }
        }

        public void windowClosed(WindowEvent windowEvent) {
            Trace.logInfo((String)JFrameViewerCmdPanel.TRACE_CONTEXT, (String)"(JFrameViewerCmdPanel ApplianceWindowListener windowClosed)");
            if (JFrameViewerCmdPanel.this.m_bKeyboardHooked) {
                JFrameViewerCmdPanel.this.m_libWin32.resetLowLevelKeyboardHook();
                JFrameViewerCmdPanel.this.m_bKeyboardHooked = false;
            }
            try {
                if (JFrameViewerCmdPanel.this.m_bCloseSession) {
                    JFrameViewerCmdPanel.this.m_applianceSession.terminateSession();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            Trace.logInfo((String)JFrameViewerCmdPanel.TRACE_CONTEXT, (String)"(JFrameViewerCmdPane windowDeactivated)");
            if (JFrameViewerCmdPanel.this.m_bKeyboardHooked) {
                JFrameViewerCmdPanel.this.m_libWin32.resetLowLevelKeyboardHook();
                JFrameViewerCmdPanel.this.m_bKeyboardHooked = false;
            }
            JFrameViewerCmdPanel.this.activateSingleCursorMode(false);
            if (JFrameViewerCmdPanel.this.m_appliancePanel != null) {
                JFrameViewerCmdPanel.this.m_appliancePanel.setVideoQueueSleepTimeDeactivated();
            }
            try {
                JFrameViewerCmdPanel.this.m_applianceSession.cmdFocusControl(false);
            }
            catch (IOException iOException) {
                Trace.logError((String)JFrameViewerCmdPanel.TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
            }
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowOpened(WindowEvent windowEvent) {
        }
    }
}

