/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.DSIndexColorModel;
import com.avocent.video.Win32Library;
import com.avocent.video.debugPulse;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

class JPanelAppliance
extends JPanel
implements FocusListener {
    public static final String CNAME = "JPanelAppliance";
    static final ResourceManager res = ResourceManager.getManager((String)"com.avocent.video.Res");
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    private static final int INVOKE_LATER_SLEEP_TIME_FOCUS = 5;
    private static final int INVOKE_LATER_SLEEP_TIME_NOFOCUS = 400;
    protected static final int MAX_REGION_VALUE = Short.MAX_VALUE;
    protected static final int MIN_REGION_VALUE = 0;
    private static final int MK_LBUTTON = 1;
    private static final int MK_RBUTTON = 2;
    private static final int MK_SHIFT = 4;
    private static final int MK_CONTROL = 8;
    private static final int MK_MBUTTON = 16;
    private static final int MK_BUTTON4 = 32;
    private static final int MK_BUTTON5 = 64;
    protected static final int VIDEO_STOPPED_PROGRAM_STARTUP = 1000;
    protected ApplianceSession m_applianceSession;
    protected ApplianceSessionInfo m_sessionInfo;
    private static final int VIDEO_PACKET_VIDEO_WIDTH = 64;
    private static final int VIDEO_PACKET_VIDEO_HEIGHT = 16;
    private BufferedImage m_image;
    private VolatileImage m_vimage;
    private WritableRaster m_raster;
    protected int m_nBitmapWidth;
    protected int m_nBitmapHeight;
    protected int m_nVideoWidth;
    protected int m_nVideoHeight;
    protected int m_nPixelArrayWidth;
    protected int m_nPixelArrayHeight;
    protected DSMouseListener m_dsMouseListener;
    private Object[] m_aoColorLUT = null;
    private byte[] m_aby15BitTo8BitLUT = null;
    protected boolean m_bInitRun = false;
    protected Cursor m_cursorSelected;
    protected int m_nLocalCursorType;
    int m_nDecimationFactor = 1;
    protected boolean m_bIsPanelForThumbnail = false;
    protected Win32Library m_libWin32;
    protected boolean m_bWin32LibraryLoaded = false;
    protected Rectangle m_rectDirtyRegion = new Rectangle();
    protected boolean m_bNewVideoData;
    private int m_nImageTypeCurrent;
    private int m_nXSingleCursor;
    private int m_nYSingleCursor;
    protected boolean m_bIgnoreDvcData = false;
    protected boolean m_bIgnoreVideoData = false;
    protected ThreadDrawDvc m_threadDrawDvc = null;
    protected ThreadDrawDvcNotFocus m_threadDrawDvcNotFocus = null;
    protected boolean m_bPPPConnection = false;
    protected boolean m_bFirstDvcStartOfFrameMatchingSavedParametersReceived = false;
    protected boolean m_bHaveFocus = false;
    private boolean m_bRelativeSingleCursor = false;
    protected int m_nVideoTemporarilyStopped = -1;
    protected int m_nProgramStartupSecondCnt = 0;
    protected ThreadProgramStartup m_threadStartup;
    static /* synthetic */ Class class$com$avocent$video$JPanelAppliance;

    public JPanelAppliance(ApplianceSession applianceSession) {
        super(false);
        this.m_applianceSession = applianceSession;
        this.m_bInitRun = false;
        this.setFocusTraversalKeysEnabled(false);
        try {
            this.m_libWin32 = new Win32Library();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        JPanelAppliance jPanelAppliance = this;
        this.m_bWin32LibraryLoaded = jPanelAppliance.m_libWin32.isWin32LibLoaded();
    }

    public JPanelAppliance(boolean bl) {
        super(false);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance constructor bIsPanelForThumbnail=" + bl));
        this.m_bIsPanelForThumbnail = bl;
        this.m_bInitRun = false;
        try {
            this.m_libWin32 = new Win32Library();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
        JPanelAppliance jPanelAppliance = this;
        this.m_bWin32LibraryLoaded = jPanelAppliance.m_libWin32.isWin32LibLoaded();
    }

    public void initPanelAppliance(ApplianceSession applianceSession, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        boolean bl2 = true;
        if (this.m_bInitRun && this.m_bIsPanelForThumbnail) {
            bl2 = false;
        }
        this.initPanelAppliance(applianceSession, n, n2, n3, n4, n5, n6, n7, bl, bl2);
    }

    public void initPanelAppliance(ApplianceSession applianceSession, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        Object object;
        Container container;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance) m_bInitRun:" + this.m_bInitRun + " nBitmapX:" + n + " nBitmapY:" + n2 + " nBitmapWidth:" + n3 + " nBitmapHeight:" + n4 + " nVideoWidth:" + n5 + " nVideoHeight:" + n6 + " nDecimationFactor:" + n7 + " bEraseImage:" + bl2));
        this.m_applianceSession = applianceSession;
        if (bl) {
            this.m_sessionInfo = this.m_applianceSession.getPersistentData();
            this.setLocalCursorType(this.m_sessionInfo.getLocalCursorType());
        }
        this.m_nPixelArrayWidth = ((n3 - 1) / 64 + 1) * 64;
        this.m_nPixelArrayHeight = ((n4 - 1) / 16 + 1) * 16;
        for (container = this; container != null && !(container instanceof Window); container = container.getParent()) {
        }
        if (!(container == null || this.m_bInitRun && this.m_nBitmapWidth == n3 && this.m_nBitmapHeight == n4 && this.m_nDecimationFactor == n7)) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance) freememory=" + Runtime.getRuntime().freeMemory() + " totalmemory=" + Runtime.getRuntime().totalMemory() + " maxmemory=" + Runtime.getRuntime().maxMemory()));
            if (bl2 || this.m_image == null) {
                this.m_image = null;
                this.m_image = ((Window)container).getGraphicsConfiguration().createCompatibleImage(n3, n4);
                this.m_vimage = null;
                this.m_vimage = ((Window)container).getGraphicsConfiguration().createCompatibleVolatileImage(n3, n4);
                this.m_raster = null;
                this.m_raster = this.m_image.getRaster();
                object = new DSIndexColorModel();
                if (this.m_aoColorLUT != null) {
                    for (int i = 0; i < this.m_aoColorLUT.length; ++i) {
                        this.m_aoColorLUT[i] = null;
                    }
                }
                this.m_aoColorLUT = null;
                this.m_aoColorLUT = new Object[256];
                ColorModel colorModel = this.m_image.getColorModel();
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance) ColorModel.getTransferType:" + colorModel.getTransferType()));
                for (int i = 0; i < this.m_aoColorLUT.length; ++i) {
                    this.m_aoColorLUT[i] = colorModel.getDataElements(((DSIndexColorModel)object).getIndexColorModel().getRGB(i), null);
                }
                this.m_nImageTypeCurrent = this.m_image.getType();
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance) imageType=" + this.m_nImageTypeCurrent));
                this.m_nBitmapWidth = n3;
                this.m_nBitmapHeight = n4;
                this.m_nDecimationFactor = n7;
                if (this.m_nImageTypeCurrent == 13) {
                    this.init15BitTo8BitLUT(colorModel);
                }
            } else {
                this.m_nBitmapWidth = n3;
                this.m_nBitmapHeight = n4;
                this.m_nDecimationFactor = n7;
                this.transferImage();
            }
            if (this.m_applianceSession != null) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance - initializing pixel array - width)" + n3));
                this.m_applianceSession.initPixelArray(n3, this.m_nImageTypeCurrent);
            }
            if (this.m_applianceSession != null) {
                this.m_applianceSession.videoConfigChanged(this);
            }
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance) freememory=" + Runtime.getRuntime().freeMemory() + " totalmemory=" + Runtime.getRuntime().totalMemory() + " maxmemory=" + Runtime.getRuntime().maxMemory()));
        }
        if (bl2) {
            if (this.m_vimage == null) {
                this.m_vimage = ((Window)container).getGraphicsConfiguration().createCompatibleVolatileImage(n3, n4);
            }
            if ((object = this.m_vimage.getGraphics()) != null) {
                ((Graphics)object).setColor(Color.black);
                ((Graphics)object).fillRect(0, 0, this.m_nBitmapWidth, this.m_nBitmapHeight);
                ((Graphics)object).dispose();
                this.updateDirtyRegion(0, 0, this.m_nBitmapWidth, this.m_nBitmapHeight);
                this.repaint();
            }
        }
        this.initDirtyRegion();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance) nBitmapX:" + n + " nBitmapY:" + n2 + " nBitmapWidth:" + n3 + " nBitmapHeight:" + n4 + " nDecimationFactor:" + n7));
        this.setBounds(n, n2, n3 / this.m_nDecimationFactor, n4 / this.m_nDecimationFactor);
        this.validate();
        object = this.getSize();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance) sizePanel X:" + ((Dimension)object).getWidth() + " Y:" + ((Dimension)object).getHeight()));
        this.m_nVideoWidth = n5;
        this.m_nVideoHeight = n6;
        this.setVisible(true);
        if (!this.m_bInitRun) {
            this.m_dsMouseListener = new DSMouseListener(this);
            if (bl) {
                this.addMouseListener(this.m_dsMouseListener);
                this.addMouseMotionListener(this.m_dsMouseListener);
                this.addMouseWheelListener(this.m_dsMouseListener);
            }
        }
        this.m_bInitRun = true;
    }

    public void initPanelAppliance(ApplianceSession applianceSession, Rectangle rectangle, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        Object object;
        Container container;
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance) m_bInitRun:" + this.m_bInitRun + " rBounds.x=" + rectangle.x + " y=" + rectangle.y + " width=" + rectangle.width + " height=" + rectangle.height + " nBitmapWidth:" + n + " nBitmapHeight:" + n2 + " nVideoWidth:" + n3 + " nVideoHeight:" + n4 + " nDecimationFactor:" + n5 + " bEraseImage:" + bl2));
        this.m_applianceSession = applianceSession;
        if (bl) {
            this.m_sessionInfo = this.m_applianceSession.getPersistentData();
            this.setLocalCursorType(this.m_sessionInfo.getLocalCursorType());
        }
        this.m_nPixelArrayWidth = ((n - 1) / 64 + 1) * 64;
        this.m_nPixelArrayHeight = ((n2 - 1) / 16 + 1) * 16;
        for (container = this; container != null && !(container instanceof Window); container = container.getParent()) {
        }
        if (!(container == null || this.m_bInitRun && this.m_nBitmapWidth == n && this.m_nBitmapHeight == n2 && this.m_nDecimationFactor == n5)) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance) freememory=" + Runtime.getRuntime().freeMemory() + " totalmemory=" + Runtime.getRuntime().totalMemory() + " maxmemory=" + Runtime.getRuntime().maxMemory()));
            if (bl2 || this.m_image == null) {
                this.m_image = null;
                this.m_image = ((Window)container).getGraphicsConfiguration().createCompatibleImage(n, n2);
                this.m_vimage = null;
                this.m_vimage = ((Window)container).getGraphicsConfiguration().createCompatibleVolatileImage(n, n2);
                this.m_raster = null;
                this.m_raster = this.m_image.getRaster();
                object = new DSIndexColorModel();
                if (this.m_aoColorLUT != null) {
                    for (int i = 0; i < this.m_aoColorLUT.length; ++i) {
                        this.m_aoColorLUT[i] = null;
                    }
                }
                this.m_aoColorLUT = null;
                this.m_aoColorLUT = new Object[256];
                ColorModel colorModel = this.m_image.getColorModel();
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance) ColorModel.getTransferType:" + colorModel.getTransferType()));
                for (int i = 0; i < this.m_aoColorLUT.length; ++i) {
                    this.m_aoColorLUT[i] = colorModel.getDataElements(((DSIndexColorModel)object).getIndexColorModel().getRGB(i), null);
                }
                this.m_nImageTypeCurrent = this.m_image.getType();
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance) imageType=" + this.m_nImageTypeCurrent));
                this.m_nBitmapWidth = n;
                this.m_nBitmapHeight = n2;
                this.m_nDecimationFactor = n5;
                if (this.m_nImageTypeCurrent == 13) {
                    this.init15BitTo8BitLUT(colorModel);
                }
            } else {
                this.m_nBitmapWidth = n;
                this.m_nBitmapHeight = n2;
                this.m_nDecimationFactor = n5;
                this.transferImage();
            }
            if (this.m_applianceSession != null) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance - initializing pixel array - width)" + n));
                this.m_applianceSession.initPixelArray(n, this.m_nImageTypeCurrent);
            }
            if (this.m_applianceSession != null) {
                this.m_applianceSession.videoConfigChanged(this);
            }
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance) freememory=" + Runtime.getRuntime().freeMemory() + " totalmemory=" + Runtime.getRuntime().totalMemory() + " maxmemory=" + Runtime.getRuntime().maxMemory()));
        }
        if (bl2) {
            if (this.m_vimage == null) {
                this.m_vimage = ((Window)container).getGraphicsConfiguration().createCompatibleVolatileImage(n, n2);
            }
            if ((object = this.m_vimage.getGraphics()) != null) {
                ((Graphics)object).setColor(Color.black);
                ((Graphics)object).fillRect(0, 0, this.m_nBitmapWidth, this.m_nBitmapHeight);
                ((Graphics)object).dispose();
                this.updateDirtyRegion(0, 0, this.m_nBitmapWidth, this.m_nBitmapHeight);
                this.repaint();
            }
        }
        this.initDirtyRegion();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance)  nBitmapWidth:" + n + " nBitmapHeight:" + n2 + " nDecimationFactor:" + n5));
        this.setBounds(rectangle);
        this.validate();
        object = this.getSize();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance initPanelAppliance) sizePanel X:" + ((Dimension)object).getWidth() + " Y:" + ((Dimension)object).getHeight()));
        this.m_nVideoWidth = n3;
        this.m_nVideoHeight = n4;
        this.setVisible(true);
        if (!this.m_bInitRun) {
            this.m_dsMouseListener = new DSMouseListener(this);
            if (bl) {
                this.addMouseListener(this.m_dsMouseListener);
                this.addMouseMotionListener(this.m_dsMouseListener);
                this.addMouseWheelListener(this.m_dsMouseListener);
            }
        }
        this.m_bInitRun = true;
    }

    public void setSessionInfo(ApplianceSessionInfo applianceSessionInfo) {
        this.m_sessionInfo = applianceSessionInfo;
    }

    public void setVideoWidthAndHeight(int n, int n2) {
        this.m_nVideoWidth = n;
        this.m_nVideoHeight = n2;
    }

    public void terminatePanelAppliance() {
        this.setRunVideoQueue(false);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (JPanelAppliance.this.m_aoColorLUT != null) {
                    for (int i = 0; i < JPanelAppliance.this.m_aoColorLUT.length; ++i) {
                        ((JPanelAppliance)JPanelAppliance.this).m_aoColorLUT[i] = null;
                    }
                    JPanelAppliance.access$002(JPanelAppliance.this, null);
                }
                JPanelAppliance.access$102(JPanelAppliance.this, null);
                JPanelAppliance.this.m_vimage = null;
                JPanelAppliance.this.m_image = null;
                JPanelAppliance.this.m_dsMouseListener = null;
                JPanelAppliance.this.m_cursorSelected = null;
                JPanelAppliance.this.m_sessionInfo = null;
                JPanelAppliance.this.m_applianceSession = null;
            }
        });
        thread.start();
    }

    public void ignoreVideoData(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance ignoreVideoData) bIgnore=" + bl));
        this.m_bIgnoreVideoData = bl;
        if (bl) {
            this.m_bIgnoreDvcData = true;
            this.m_bFirstDvcStartOfFrameMatchingSavedParametersReceived = false;
        }
    }

    public void ignoreVideoData(boolean bl, boolean bl2) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance ignoreVideoData) bIgnore=" + bl + " bIgnoreDVC=" + bl2));
        this.m_bIgnoreVideoData = bl;
        this.m_bIgnoreDvcData = bl2;
        this.m_bFirstDvcStartOfFrameMatchingSavedParametersReceived = false;
    }

    public void focusGained(FocusEvent focusEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JPanelAppliance focusGained)");
        this.m_bHaveFocus = true;
        if (this.m_threadDrawDvcNotFocus != null) {
            this.drawDvc();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JPanelAppliance focusLost)");
    }

    public void setVideoQueueSleepTimeActivated() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JPanelAppliance setVideoQueueSleepTimeActivated");
        this.m_bHaveFocus = true;
        if (this.m_threadDrawDvcNotFocus != null) {
            this.drawDvc();
        }
    }

    public void setVideoQueueSleepTimeDeactivated() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JPanelAppliance setVideoQueueSleepTimeDeactivated");
        this.m_bHaveFocus = false;
    }

    public void resetCreateVideoQueueFlag() {
    }

    public void setPixels(int n, int n2, int n3, int n4, byte[] byArray) {
        this.m_nVideoTemporarilyStopped = -1;
        if (this.m_bIgnoreVideoData) {
            return;
        }
        if (this.m_applianceSession == null) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JPanelAppliance setPixels NULL appliance session");
            return;
        }
        this.m_bIgnoreDvcData = false;
        if (this.m_nBitmapWidth > n && this.m_nBitmapHeight > n2) {
            this.m_applianceSession.setAVCPixels(n, n2, n3, n4, byArray);
            Graphics graphics = this.m_vimage.getGraphics();
            graphics.drawImage(this.m_image, n, n2, n + n3, n2 + n4, n, n2, n + n3, n2 + n4, this);
            graphics.dispose();
            if (this.m_nDecimationFactor != 1) {
                this.repaint(0L, n / this.m_nDecimationFactor, n2 / this.m_nDecimationFactor, (n3 + this.m_nDecimationFactor - 1) / this.m_nDecimationFactor, (n4 + this.m_nDecimationFactor - 1) / this.m_nDecimationFactor);
            } else {
                this.repaint(n, n2, n3, n4);
            }
        }
    }

    private void init15BitTo8BitLUT(ColorModel colorModel) {
        this.m_aby15BitTo8BitLUT = new byte[32768];
        int[] nArray = new int[4];
        nArray[3] = 65535;
        for (int i = 0; i < 32; ++i) {
            nArray[0] = i << 3;
            for (int j = 0; j < 32; ++j) {
                nArray[1] = j << 3;
                for (int k = 0; k < 32; ++k) {
                    nArray[2] = k << 3;
                    this.m_aby15BitTo8BitLUT[k + j * 32 + i * 32 * 32] = (byte)colorModel.getDataElement(nArray, 0);
                }
            }
        }
    }

    public boolean setDvcStartOfFrame(int n, int n2, int n3) {
        this.m_nVideoTemporarilyStopped = -1;
        if (this.m_bIgnoreVideoData) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JPanelAppliance setDvcStartOfFrame) ignoring video data");
            return false;
        }
        if (this.m_nBitmapHeight != n2 || this.m_nBitmapWidth != n || this.m_nDecimationFactor != n3) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance setDvcStartOfFrame) size of frame or decimation changed m_nBitmapHeight=" + this.m_nBitmapHeight + " nHeight=" + n2 + " m_nBitmapWidth=" + this.m_nBitmapWidth + " nWidth=" + n + " m_nDecimationFactor=" + this.m_nDecimationFactor + " nDecimationFactor=" + n3));
            this.m_nDecimationFactor = n3;
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JPanelAppliance setDvcStartOfFrame) calling initPixelArray");
            this.m_applianceSession.initPixelArray(n, this.m_nImageTypeCurrent);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance setDvcStartOfFrame) resizing video window erase image based on m_bIsPanelForThumbnail=" + this.m_bIsPanelForThumbnail));
            this.m_applianceSession.getApplianceWindow().resizeVideoWindow(n, n2, !this.m_bIsPanelForThumbnail);
        } else if (!this.m_bFirstDvcStartOfFrameMatchingSavedParametersReceived) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JPanelAppliance setDvcStartOfFrame) m_bFirstDvcStartOfFrameMatchingSavedParametersReceived set true");
            this.m_bFirstDvcStartOfFrameMatchingSavedParametersReceived = true;
        }
        if (this.m_bPPPConnection) {
            this.m_threadDrawDvc = new ThreadDrawDvc();
            this.m_threadDrawDvc.start();
        }
        this.m_bIgnoreDvcData = false;
        return true;
    }

    public synchronized void updateDirtyRegion(int n, int n2, int n3, int n4) {
        if (n < this.m_rectDirtyRegion.x) {
            this.m_rectDirtyRegion.x = n;
        }
        if (n3 > this.m_rectDirtyRegion.width) {
            this.m_rectDirtyRegion.width = n3;
        }
        if (n4 > this.m_rectDirtyRegion.height) {
            this.m_rectDirtyRegion.height = n4;
        }
        if (n2 < this.m_rectDirtyRegion.y) {
            this.m_rectDirtyRegion.y = n2;
        }
        this.m_bNewVideoData = this.m_rectDirtyRegion.height - this.m_rectDirtyRegion.y > 1;
    }

    protected void initDirtyRegion() {
        this.m_rectDirtyRegion.x = Short.MAX_VALUE;
        this.m_rectDirtyRegion.width = 0;
        this.m_rectDirtyRegion.y = Short.MAX_VALUE;
        this.m_rectDirtyRegion.height = 0;
        this.m_bNewVideoData = false;
    }

    public void dvcEndOfFrame() {
        this.drawDvc();
        if (this.m_threadDrawDvc != null) {
            this.m_threadDrawDvc.m_bEndOfFrame = true;
        }
    }

    public void transferImage() {
        int n;
        Object object;
        Container container;
        if (this.m_nBitmapWidth <= 0 || this.m_nBitmapHeight <= 0) {
            return;
        }
        for (container = this; container != null && !(container instanceof Window); container = container.getParent()) {
        }
        int n2 = 0;
        boolean bl = true;
        do {
            this.m_vimage = null;
            this.m_vimage = ((Window)container).getGraphicsConfiguration().createCompatibleVolatileImage(this.m_nBitmapWidth, this.m_nBitmapHeight);
            object = this.m_vimage.createGraphics();
            ((Graphics)object).dispose();
            n2 = this.m_vimage.validate(this.getGraphicsConfiguration());
            bl = this.m_vimage.contentsLost();
            Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance transferImage) nValidateResult=" + n2 + " bContentsLost=" + bl));
        } while (n2 == 2 || bl);
        object = ((Window)container).getGraphicsConfiguration().createCompatibleImage(this.m_nBitmapWidth, this.m_nBitmapHeight);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance transferImage) imageType current=" + this.m_nImageTypeCurrent + " new image type=" + ((BufferedImage)object).getType()));
        Graphics graphics = ((BufferedImage)object).getGraphics();
        graphics.drawImage(this.m_image, 0, 0, this.m_nBitmapWidth, this.m_nBitmapHeight, this);
        graphics.dispose();
        graphics = this.m_vimage.getGraphics();
        graphics.drawImage((Image)object, 0, 0, this.m_nBitmapWidth, this.m_nBitmapHeight, this);
        graphics.dispose();
        this.m_raster = null;
        this.m_raster = ((BufferedImage)object).getRaster();
        this.m_image = null;
        this.m_image = object;
        this.m_nImageTypeCurrent = ((BufferedImage)object).getType();
        DSIndexColorModel dSIndexColorModel = new DSIndexColorModel();
        ColorModel colorModel = this.m_image.getColorModel();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelAppliance transferImage) ColorModel.getTransferType:" + colorModel.getTransferType()));
        for (n = 0; n < this.m_aoColorLUT.length; ++n) {
            this.m_aoColorLUT[n] = null;
        }
        for (n = 0; n < this.m_aoColorLUT.length; ++n) {
            this.m_aoColorLUT[n] = colorModel.getDataElements(dSIndexColorModel.getIndexColorModel().getRGB(n), null);
        }
        if (this.m_nImageTypeCurrent == 13) {
            this.init15BitTo8BitLUT(colorModel);
        }
        this.repaint();
        if (this.m_applianceSession != null) {
            this.m_applianceSession.videoConfigChanged(this);
        }
    }

    protected synchronized void drawDvc() {
        if (this.m_bNewVideoData) {
            Graphics graphics;
            if (this.m_vimage != null && (graphics = this.m_vimage.getGraphics()) != null) {
                graphics.drawImage(this.m_image, this.m_rectDirtyRegion.x, this.m_rectDirtyRegion.y, this.m_rectDirtyRegion.width, this.m_rectDirtyRegion.height, this.m_rectDirtyRegion.x, this.m_rectDirtyRegion.y, this.m_rectDirtyRegion.width, this.m_rectDirtyRegion.height, this);
                graphics.dispose();
                if (this.m_nDecimationFactor != 1) {
                    this.repaint(this.m_rectDirtyRegion.x / this.m_nDecimationFactor, this.m_rectDirtyRegion.y / this.m_nDecimationFactor, (this.m_rectDirtyRegion.width - this.m_rectDirtyRegion.x + this.m_nDecimationFactor - 1) / this.m_nDecimationFactor, (this.m_rectDirtyRegion.height - this.m_rectDirtyRegion.y + this.m_nDecimationFactor - 1) / this.m_nDecimationFactor);
                } else {
                    this.repaint(this.m_rectDirtyRegion.x, this.m_rectDirtyRegion.y, this.m_rectDirtyRegion.width - this.m_rectDirtyRegion.x, this.m_rectDirtyRegion.height - this.m_rectDirtyRegion.y);
                }
            }
            this.initDirtyRegion();
        }
    }

    public void setPPPConnection(boolean bl) {
        this.m_bPPPConnection = bl;
    }

    public void videoTemporarilyStopped(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JPanelAppliance videoTemporarilyStopped");
        this.m_nVideoTemporarilyStopped = n;
        this.updateDirtyRegion(0, 0, this.m_nBitmapWidth, this.m_nBitmapHeight);
        this.repaint();
    }

    public int[] getPixelArray() {
        return null;
    }

    public int getPixelArrayWidth() {
        return this.m_nPixelArrayWidth;
    }

    public int getPixelArrayHeight() {
        return this.m_nPixelArrayHeight;
    }

    public BufferedImage getBufferedImage() {
        return this.m_image;
    }

    public int getBitmapWidth() {
        return this.m_nBitmapWidth;
    }

    public int getBitmapHeight() {
        return this.m_nBitmapHeight;
    }

    public Dimension getBitmapSize() {
        return new Dimension(this.m_nBitmapWidth, this.m_nBitmapHeight);
    }

    public int getDecimationFactor() {
        return this.m_nDecimationFactor;
    }

    public int getCurrentImageType() {
        return this.m_nImageTypeCurrent;
    }

    public int getCurrentBitmapWidth() {
        return this.m_nBitmapWidth;
    }

    public void mouseAlign() {
        this.m_dsMouseListener.setMouseAlignFlag(true, this.getLocationOnScreen());
    }

    public int getLocalCursorType() {
        return this.m_nLocalCursorType;
    }

    public void setLocalCursorType(int n) {
        this.m_nLocalCursorType = n;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getBestCursorSize(32, 32);
        switch (this.m_nLocalCursorType) {
            case 0: {
                try {
                    ImageIcon imageIcon = new ImageIcon((class$com$avocent$video$JPanelAppliance == null ? (class$com$avocent$video$JPanelAppliance = JPanelAppliance.class$("com.avocent.video.JPanelAppliance")) : class$com$avocent$video$JPanelAppliance).getResource("images/clear.gif"));
                    this.m_cursorSelected = toolkit.createCustomCursor(imageIcon.getImage(), new Point(0, 0), res.getString("JPanelAppliance_Clear_cursor"));
                }
                catch (Exception exception) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                }
                break;
            }
            case 1: {
                this.m_cursorSelected = Cursor.getPredefinedCursor(0);
                break;
            }
            case 2: {
                try {
                    ImageIcon imageIcon = dimension.getWidth() < 64.0 ? new ImageIcon((class$com$avocent$video$JPanelAppliance == null ? (class$com$avocent$video$JPanelAppliance = JPanelAppliance.class$("com.avocent.video.JPanelAppliance")) : class$com$avocent$video$JPanelAppliance).getResource("images/cursor_small_hollow.gif")) : new ImageIcon((class$com$avocent$video$JPanelAppliance == null ? (class$com$avocent$video$JPanelAppliance = JPanelAppliance.class$("com.avocent.video.JPanelAppliance")) : class$com$avocent$video$JPanelAppliance).getResource("images/cursor_small_hollow_64.gif"));
                    this.m_cursorSelected = toolkit.createCustomCursor(imageIcon.getImage(), new Point(0, 0), res.getString("JPanelAppliance_Small_hollow_arrow"));
                }
                catch (Exception exception) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                }
                break;
            }
            case 3: {
                try {
                    ImageIcon imageIcon = dimension.getWidth() < 64.0 ? new ImageIcon((class$com$avocent$video$JPanelAppliance == null ? (class$com$avocent$video$JPanelAppliance = JPanelAppliance.class$("com.avocent.video.JPanelAppliance")) : class$com$avocent$video$JPanelAppliance).getResource("images/cursor_small_filled.gif")) : new ImageIcon((class$com$avocent$video$JPanelAppliance == null ? (class$com$avocent$video$JPanelAppliance = JPanelAppliance.class$("com.avocent.video.JPanelAppliance")) : class$com$avocent$video$JPanelAppliance).getResource("images/cursor_small_filled_64.gif"));
                    this.m_cursorSelected = toolkit.createCustomCursor(imageIcon.getImage(), new Point(0, 0), res.getString("JPanelAppliance_Small_filled_arrow"));
                }
                catch (Exception exception) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                }
                break;
            }
            case 4: {
                try {
                    ImageIcon imageIcon = dimension.getWidth() < 64.0 ? new ImageIcon((class$com$avocent$video$JPanelAppliance == null ? (class$com$avocent$video$JPanelAppliance = JPanelAppliance.class$("com.avocent.video.JPanelAppliance")) : class$com$avocent$video$JPanelAppliance).getResource("images/cursor_big_hollow.gif")) : new ImageIcon((class$com$avocent$video$JPanelAppliance == null ? (class$com$avocent$video$JPanelAppliance = JPanelAppliance.class$("com.avocent.video.JPanelAppliance")) : class$com$avocent$video$JPanelAppliance).getResource("images/cursor_big_hollow_64.gif"));
                    this.m_cursorSelected = toolkit.createCustomCursor(imageIcon.getImage(), new Point(0, 0), res.getString("JPanelAppliance_Big_hollow_arrow"));
                }
                catch (Exception exception) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                }
                break;
            }
            case 5: {
                try {
                    ImageIcon imageIcon = dimension.getWidth() < 64.0 ? new ImageIcon((class$com$avocent$video$JPanelAppliance == null ? (class$com$avocent$video$JPanelAppliance = JPanelAppliance.class$("com.avocent.video.JPanelAppliance")) : class$com$avocent$video$JPanelAppliance).getResource("images/cursor_small_cross.gif")) : new ImageIcon((class$com$avocent$video$JPanelAppliance == null ? (class$com$avocent$video$JPanelAppliance = JPanelAppliance.class$("com.avocent.video.JPanelAppliance")) : class$com$avocent$video$JPanelAppliance).getResource("images/cursor_small_cross_64.gif"));
                    this.m_cursorSelected = toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), res.getString("JPanelAppliance_Small_cross_cursor"));
                }
                catch (Exception exception) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                }
                break;
            }
            case 6: {
                try {
                    ImageIcon imageIcon = dimension.getWidth() < 64.0 ? new ImageIcon((class$com$avocent$video$JPanelAppliance == null ? (class$com$avocent$video$JPanelAppliance = JPanelAppliance.class$("com.avocent.video.JPanelAppliance")) : class$com$avocent$video$JPanelAppliance).getResource("images/cursor_big_cross.gif")) : new ImageIcon((class$com$avocent$video$JPanelAppliance == null ? (class$com$avocent$video$JPanelAppliance = JPanelAppliance.class$("com.avocent.video.JPanelAppliance")) : class$com$avocent$video$JPanelAppliance).getResource("images/cursor_big_cross_64.gif"));
                    this.m_cursorSelected = toolkit.createCustomCursor(imageIcon.getImage(), new Point(15, 15), res.getString("JPanelAppliance_Big_cross_cursor"));
                }
                catch (Exception exception) {
                    Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
                }
                break;
            }
            case 7: {
                this.m_cursorSelected = Cursor.getPredefinedCursor(3);
            }
        }
        this.setCursor(this.m_cursorSelected);
    }

    public ApplianceSession getApplianceSession() {
        return this.m_applianceSession;
    }

    public void setApplianceSession(ApplianceSession applianceSession) {
        this.m_applianceSession = applianceSession;
    }

    public synchronized void setRunVideoQueue(boolean bl) {
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void repaint() {
        if (this.m_rectDirtyRegion != null) {
            this.updateDirtyRegion(0, 0, this.m_nBitmapWidth, this.m_nBitmapHeight);
        }
        super.repaint();
    }

    public void paintComponent(Graphics graphics) {
        boolean bl = false;
        if (this.m_nVideoTemporarilyStopped >= 0) {
            this.drawVideoStoppedScreen(graphics);
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle == null) {
            rectangle = new Rectangle(0, 0, this.m_nBitmapWidth, this.m_nBitmapHeight);
        }
        if (this.m_vimage == null) {
            return;
        }
        if (this.m_vimage.contentsLost()) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JPanelAppliance paint) m_vimage contentsLost");
            this.transferImage();
            bl = true;
        }
        if (this.m_nDecimationFactor != 1) {
            graphics.drawImage(this.m_vimage, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x * this.m_nDecimationFactor, rectangle.y * this.m_nDecimationFactor, (rectangle.x + rectangle.width) * this.m_nDecimationFactor, (rectangle.y + rectangle.height) * this.m_nDecimationFactor, this);
        } else {
            graphics.drawImage(this.m_vimage, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, this);
        }
        if (bl) {
            try {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(JPanelAppliance paint) calling cmdRefreshPane because contents lost");
                this.m_applianceSession.cmdRefreshPane();
            }
            catch (IOException iOException) {
                Trace.logError((String)TRACE_CONTEXT, (String)iOException.getMessage(), (Throwable)iOException);
            }
        }
        debugPulse.writeParallelPort((byte)8);
    }

    protected void drawVideoStoppedScreen(Graphics graphics) {
        try {
            Color color;
            Color color2;
            String string;
            Font font = new Font("Dialog", 1, 24);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JPanelAppliance.drawVideoStoppedScreen font=" + font.toString()));
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = 0;
            switch (this.m_nVideoTemporarilyStopped) {
                case 1000: {
                    string = res.getString("JPanelAppliance_Getting_video_information");
                    n = fontMetrics.charsWidth(string.toCharArray(), 0, string.toCharArray().length);
                    for (int i = 0; i < this.m_nProgramStartupSecondCnt; ++i) {
                        string = string + ".";
                    }
                    color2 = Color.white;
                    color = Color.blue;
                    break;
                }
                case 0: {
                    string = res.getString("JPanelAppliance_STOPPAGE_REASON_CALIBRATING");
                    n = fontMetrics.charsWidth(string.toCharArray(), 0, string.toCharArray().length);
                    color2 = new Color(36864);
                    color = Color.yellow;
                    break;
                }
                default: {
                    string = res.getString("JPanelAppliance_STOPPAGE_REASON_NO_SIGNAL");
                    n = fontMetrics.charsWidth(string.toCharArray(), 0, string.toCharArray().length);
                    color2 = new Color(36864);
                    color = Color.yellow;
                }
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.scale(1.0 / (double)this.m_nDecimationFactor, 1.0 / (double)this.m_nDecimationFactor);
            graphics2D.setColor(color2);
            graphics2D.fillRect(0, 0, this.m_nBitmapWidth, this.m_nBitmapHeight);
            graphics2D.setColor(color);
            graphics2D.drawString(string, this.m_nBitmapWidth / 2 - n / 2, this.m_nBitmapHeight / 2 - fontMetrics.getHeight() / 2);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public int getImageType() {
        return this.m_nImageTypeCurrent;
    }

    public byte[] get15BitTo8BitLUT() {
        return this.m_aby15BitTo8BitLUT;
    }

    public Object[] getColorLUT() {
        return this.m_aoColorLUT;
    }

    public WritableRaster getRaster() {
        return this.m_raster;
    }

    public Rectangle getDirtyRegion() {
        return this.m_rectDirtyRegion;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (image == this.m_image) {
            return true;
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    public void mouseScrollNotify(short s, short s2, long l, long l2) {
        Point point = new Point((int)l, (int)l2);
        SwingUtilities.convertPointFromScreen(point, this);
        int n = (int)((double)(point.x * this.m_nVideoWidth * this.m_nDecimationFactor / this.m_nBitmapWidth) * this.m_sessionInfo.getMouseXGain());
        int n2 = (int)((double)(point.y * this.m_nVideoHeight * this.m_nDecimationFactor / this.m_nBitmapHeight) * this.m_sessionInfo.getMouseYGain());
        try {
            this.m_applianceSession.cmdMouseMoved((s & 1) != 0, (s & 0x10) != 0, (s & 2) != 0, false, false, (s & 8) != 0, (s & 4) != 0, n, n2, (char)(s2 / 120));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void mouseXButtonNotify(short s, short s2, int n, int n2) {
        int n3 = (int)((double)(n * this.m_nVideoWidth * this.m_nDecimationFactor / this.m_nBitmapWidth) * this.m_sessionInfo.getMouseXGain());
        int n4 = (int)((double)(n2 * this.m_nVideoHeight * this.m_nDecimationFactor / this.m_nBitmapHeight) * this.m_sessionInfo.getMouseYGain());
        try {
            this.m_applianceSession.cmdMouseMoved((s & 1) != 0, (s & 0x10) != 0, (s & 2) != 0, (s & 0x20) != 0, (s & 0x40) != 0, (s & 8) != 0, (s & 4) != 0, n3, n4, (char)(s2 / 120));
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.m_applianceSession.cmdMouseMoved((s & 1) != 0, (s & 0x10) != 0, (s & 2) != 0, false, false, (s & 8) != 0, (s & 4) != 0, n3, n4, (char)(s2 / 120));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void initSingleCursor() {
        this.setLocalCursorType(0);
        this.m_bRelativeSingleCursor = this.m_applianceSession.isSingleCursorMouseRelative();
        this.m_nXSingleCursor = 0;
        this.m_nYSingleCursor = 0;
    }

    public void singleCursorModeMouseNotify(short s, short s2, int n, int n2) {
        if (this.m_bRelativeSingleCursor) {
            try {
                this.m_applianceSession.cmdMouseMovedRelative((s & 1) != 0, (s & 0x10) != 0, (s & 2) != 0, (s & 0x20) != 0, (s & 0x40) != 0, (s & 8) != 0, (s & 4) != 0, n, n2, (char)(s2 / 120));
            }
            catch (IOException iOException) {}
        } else {
            this.m_nXSingleCursor += n;
            if (this.m_nXSingleCursor < 0) {
                this.m_nXSingleCursor = 0;
            }
            this.m_nYSingleCursor += n2;
            if (this.m_nYSingleCursor < 0) {
                this.m_nYSingleCursor = 0;
            }
            try {
                this.m_applianceSession.cmdMouseMoved((s & 1) != 0, (s & 0x10) != 0, (s & 2) != 0, false, false, (s & 8) != 0, (s & 4) != 0, this.m_nXSingleCursor, this.m_nYSingleCursor, (char)(s2 / 120));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void endThumbnailSession() {
        this.m_vimage = null;
    }

    static /* synthetic */ Object[] access$002(JPanelAppliance jPanelAppliance, Object[] objectArray) {
        jPanelAppliance.m_aoColorLUT = objectArray;
        return objectArray;
    }

    static /* synthetic */ byte[] access$102(JPanelAppliance jPanelAppliance, byte[] byArray) {
        jPanelAppliance.m_aby15BitTo8BitLUT = byArray;
        return byArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DSMouseListener
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener {
        private Component m_component;
        private boolean m_bMouseAlign;
        private Point m_ptAlign;
        private boolean m_bMouseButtonLeftDown = false;
        private boolean m_bMouseButtonMiddleDown = false;
        private boolean m_bMouseButtonRightDown = false;

        public DSMouseListener(Component component) {
            this.m_component = component;
            this.m_bMouseAlign = false;
            this.m_ptAlign = new Point();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.m_component.setCursor(JPanelAppliance.this.m_cursorSelected);
            if (this.m_bMouseAlign) {
                Trace.logInfo((String)JPanelAppliance.TRACE_CONTEXT, (String)"(JPanelAppliance DSMouseListener mouseEntered) m_bMouseAlign true");
                this.m_bMouseAlign = false;
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.m_component.setCursor(Cursor.getPredefinedCursor(0));
        }

        private void mouseEventProcessing(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            if (n < 0) {
                n = 0;
            } else if (n > JPanelAppliance.this.m_nBitmapWidth / JPanelAppliance.this.m_nDecimationFactor) {
                n = JPanelAppliance.this.m_nBitmapWidth / JPanelAppliance.this.m_nDecimationFactor;
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > JPanelAppliance.this.m_nBitmapHeight / JPanelAppliance.this.m_nDecimationFactor) {
                n2 = JPanelAppliance.this.m_nBitmapHeight / JPanelAppliance.this.m_nDecimationFactor;
            }
            n = (int)((double)(n * JPanelAppliance.this.m_nVideoWidth * JPanelAppliance.this.m_nDecimationFactor / JPanelAppliance.this.m_nBitmapWidth) * JPanelAppliance.this.m_sessionInfo.getMouseXGain());
            n2 = (int)((double)(n2 * JPanelAppliance.this.m_nVideoHeight * JPanelAppliance.this.m_nDecimationFactor / JPanelAppliance.this.m_nBitmapHeight) * JPanelAppliance.this.m_sessionInfo.getMouseYGain());
            try {
                char c = '\u0000';
                if (mouseEvent instanceof MouseWheelEvent) {
                    c = (char)(((MouseWheelEvent)mouseEvent).getWheelRotation() * -1);
                }
                JPanelAppliance.this.m_applianceSession.cmdMouseMoved(this.m_bMouseButtonLeftDown, this.m_bMouseButtonMiddleDown, this.m_bMouseButtonRightDown, false, false, mouseEvent.isControlDown(), mouseEvent.isShiftDown(), n, n2, c);
            }
            catch (IOException iOException) {
                Trace.logError((String)JPanelAppliance.TRACE_CONTEXT, (String)("(JPanelAppliance mousePressed) IOException: " + iOException.getMessage()), (Throwable)iOException);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.m_bMouseButtonLeftDown = (mouseEvent.getModifiers() & 0x10) != 0;
            this.m_bMouseButtonMiddleDown = (mouseEvent.getModifiers() & 8) != 0;
            this.m_bMouseButtonRightDown = (mouseEvent.getModifiers() & 4) != 0;
            this.mouseEventProcessing(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if ((mouseEvent.getModifiers() & 0x10) != 0) {
                this.m_bMouseButtonLeftDown = false;
            }
            if ((mouseEvent.getModifiers() & 8) != 0) {
                this.m_bMouseButtonMiddleDown = false;
            }
            if ((mouseEvent.getModifiers() & 4) != 0) {
                this.m_bMouseButtonRightDown = false;
            }
            this.mouseEventProcessing(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            debugPulse.writeParallelPort((byte)0);
            debugPulse.writeParallelPort((byte)1);
            this.mouseEventProcessing(mouseEvent);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.mouseEventProcessing(mouseEvent);
        }

        public void setMouseAlignFlag(boolean bl, Point point) {
            this.m_bMouseAlign = bl;
            this.m_ptAlign = point;
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.mouseEventProcessing(mouseWheelEvent);
        }
    }

    private class ThreadDrawDvcNotFocus
    extends Thread {
        public void run() {
            try {
                Thread.sleep(400L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            JPanelAppliance.this.m_threadDrawDvcNotFocus = null;
            JPanelAppliance.this.drawDvc();
        }
    }

    protected class ThreadDrawDvc
    extends Thread {
        boolean m_bEndOfFrame = false;

        public void run() {
            while (!this.m_bEndOfFrame) {
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.m_bEndOfFrame) continue;
                JPanelAppliance.this.drawDvc();
            }
        }
    }

    protected class ThreadProgramStartup
    extends Thread {
        public ThreadProgramStartup() {
            this.start();
        }

        public void run() {
            while (JPanelAppliance.this.m_applianceSession.isSessionRunning() && JPanelAppliance.this.m_nProgramStartupSecondCnt < 20 && JPanelAppliance.this.m_nVideoTemporarilyStopped == 1000) {
                ++JPanelAppliance.this.m_nProgramStartupSecondCnt;
                JPanelAppliance.this.updateDirtyRegion(0, 0, JPanelAppliance.this.m_nBitmapWidth, JPanelAppliance.this.m_nBitmapHeight);
                JPanelAppliance.this.repaint();
                try {
                    ThreadProgramStartup.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            JPanelAppliance.this.m_threadStartup = null;
        }
    }
}

