/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.ApplianceSession;
import com.avocent.video.DSIndexColorModel;
import com.avocent.video.JPanelAppliance;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.MemoryImageSource;

public class JPanelApplianceNonBuffered
extends JPanelAppliance {
    public static final String CNAME = "JPanelApplianceNonBuffered";
    static final ResourceManager res = ResourceManager.getManager((String)"com.avocent.video.Res");
    private static final int INVOKE_LATER_SLEEP_TIME_FOCUS = 5;
    private static final int INVOKE_LATER_SLEEP_TIME_NOFOCUS = 400;
    private static final int MAX_VIDEO_WIDTH = 1600;
    private static final int MAX_VIDEO_HEIGHT = 1200;
    private static final String szTraceContext = "VideoViewerTrace";
    private int m_nInvokeLaterSleepTime = 5;
    private byte[] m_abPixels = new byte[0];
    private MemoryImageSource m_mis;
    private Image m_image;
    private DSIndexColorModel m_icm;
    private checkVideo m_checkVideo = null;
    private boolean m_bRunVideoCheck = true;
    protected boolean m_bPaintPending;
    private boolean m_bEraseImage = false;
    private boolean m_bReinitMIS = false;
    private int[] m_anPixels = new int[0];

    public JPanelApplianceNonBuffered(ApplianceSession applianceSession) {
        super(applianceSession);
    }

    public JPanelApplianceNonBuffered(boolean bl) {
        super(bl);
    }

    public void initPanelAppliance(ApplianceSession applianceSession, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2) {
        Trace.logInfo((String)szTraceContext, (String)("(JPanelApplianceNonBuffered initPanelAppliance) m_bInitRun:" + this.m_bInitRun));
        this.m_applianceSession = applianceSession;
        this.m_nBitmapWidth = n3;
        this.m_nBitmapHeight = n4;
        this.m_nVideoWidth = n5;
        this.m_nVideoHeight = n6;
        this.m_bEraseImage = bl2;
        this.initDirtyRegion();
        this.m_bNewVideoData = false;
        this.m_nDecimationFactor = n7;
        if (bl) {
            this.m_sessionInfo = this.m_applianceSession.getPersistentData();
            this.setLocalCursorType(this.m_sessionInfo.getLocalCursorType());
        }
        this.m_nPixelArrayWidth = n3;
        this.m_nPixelArrayHeight = n4;
        Trace.logInfo((String)szTraceContext, (String)("(JPanelApplianceNonBuffered initPanelAppliance) nBitmapX:" + n + " nBitmapY:" + n2 + " nBitmapWidth:" + n3 + " nBitmapHeight:" + n4 + " nDecimationFactor:" + n7));
        this.setBounds(n, n2, n3 / this.m_nDecimationFactor, n4 / this.m_nDecimationFactor);
        this.validate();
        Dimension dimension = this.getSize();
        Trace.logInfo((String)szTraceContext, (String)("(JPanelApplianceNonBuffered initPanelAppliance) sizePanel X:" + dimension.getWidth() + " Y:" + dimension.getHeight()));
        Rectangle rectangle = this.getBounds();
        Trace.logInfo((String)szTraceContext, (String)("(JPanelApplianceNonBuffered initPanelAppliance) Bounds Panel left:" + rectangle.getX() + " top:" + rectangle.getY() + " width:" + rectangle.getWidth() + " height:" + rectangle.getHeight()));
        this.m_bReinitMIS = true;
        this.setVisible(true);
        if (bl2) {
            this.repaint();
        }
        if (!this.m_bInitRun) {
            this.m_dsMouseListener = new JPanelAppliance.DSMouseListener(this);
            if (bl) {
                this.addMouseListener(this.m_dsMouseListener);
                this.addMouseMotionListener(this.m_dsMouseListener);
                this.addMouseWheelListener(this.m_dsMouseListener);
            }
        }
        this.m_bInitRun = true;
    }

    public void initPanelAppliance(ApplianceSession applianceSession, Rectangle rectangle, int n, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        Trace.logInfo((String)szTraceContext, (String)("(JPanelApplianceNonBuffered initPanelAppliance) m_bInitRun:" + this.m_bInitRun));
        this.m_applianceSession = applianceSession;
        this.m_nBitmapWidth = n;
        this.m_nBitmapHeight = n2;
        this.m_nVideoWidth = n3;
        this.m_nVideoHeight = n4;
        this.m_bEraseImage = bl2;
        this.initDirtyRegion();
        this.m_bNewVideoData = false;
        this.m_nDecimationFactor = n5;
        if (bl) {
            this.m_sessionInfo = this.m_applianceSession.getPersistentData();
            this.setLocalCursorType(this.m_sessionInfo.getLocalCursorType());
        }
        this.m_nPixelArrayWidth = n;
        this.m_nPixelArrayHeight = n2;
        Trace.logInfo((String)szTraceContext, (String)("(JPanelApplianceNonBuffered initPanelAppliance) nBitmapWidth:" + n + " nBitmapHeight:" + n2 + " nDecimationFactor:" + n5));
        this.setBounds(rectangle);
        this.validate();
        Dimension dimension = this.getSize();
        Trace.logInfo((String)szTraceContext, (String)("(JPanelApplianceNonBuffered initPanelAppliance) sizePanel X:" + dimension.getWidth() + " Y:" + dimension.getHeight()));
        Rectangle rectangle2 = this.getBounds();
        Trace.logInfo((String)szTraceContext, (String)("(JPanelApplianceNonBuffered initPanelAppliance) Bounds Panel left:" + rectangle2.getX() + " top:" + rectangle2.getY() + " width:" + rectangle2.getWidth() + " height:" + rectangle2.getHeight()));
        this.m_bReinitMIS = true;
        this.setVisible(true);
        if (bl2) {
            this.repaint();
        }
        if (!this.m_bInitRun) {
            this.m_dsMouseListener = new JPanelAppliance.DSMouseListener(this);
            if (bl) {
                this.addMouseListener(this.m_dsMouseListener);
                this.addMouseMotionListener(this.m_dsMouseListener);
                this.addMouseWheelListener(this.m_dsMouseListener);
            }
        }
        this.m_bInitRun = true;
    }

    private void initImage() {
        Trace.logInfo((String)szTraceContext, (String)"(JPanelApplianceNonBuffered initImage)");
        this.m_mis.setAnimated(true);
        this.m_mis.setFullBufferUpdates(false);
        if (this.m_image != null) {
            this.m_image = null;
        }
        this.m_image = this.createImage(this.m_mis);
        this.m_mis.newPixels();
        this.m_mis.requestTopDownLeftRightResend(null);
        this.m_bPaintPending = false;
        this.m_applianceSession.videoConfigChanged(this);
    }

    private void initMISWithICM(boolean bl) {
        Trace.logInfo((String)szTraceContext, (String)"(JPanelApplianceNonBuffered initMISWithICM)");
        if (this.m_abPixels.length < 1920000) {
            try {
                Trace.logInfo((String)szTraceContext, (String)"(JPanelApplianceNonBuffered initPanelAppliance) Allocating new pixel array of MAX_VIDEO_WIDTH * MAX_VIDEO_HEIGHT");
                this.m_abPixels = new byte[1920000];
            }
            catch (OutOfMemoryError outOfMemoryError) {
                Trace.logError((String)szTraceContext, (String)("Exception: " + outOfMemoryError.getMessage()), (Throwable)outOfMemoryError);
                this.m_bRunVideoCheck = false;
                throw outOfMemoryError;
            }
        }
        if (bl) {
            for (int i = 0; i < this.m_abPixels.length; ++i) {
                this.m_abPixels[i] = -1;
            }
        }
        if (this.m_icm != null) {
            this.m_icm = null;
        }
        this.m_icm = new DSIndexColorModel();
        if (this.m_mis != null) {
            this.m_mis = null;
        }
        this.m_mis = new MemoryImageSource(this.m_nBitmapWidth, this.m_nBitmapHeight, (ColorModel)this.m_icm.getIndexColorModel(), this.m_abPixels, 0, this.m_nPixelArrayWidth);
    }

    private void initMISNoICM(boolean bl) {
        Trace.logInfo((String)szTraceContext, (String)"(JPanelApplianceNonBuffered initMISNoICM)");
        if (this.m_anPixels.length < 1920000) {
            this.m_anPixels = new int[1920000];
            Trace.logInfo((String)szTraceContext, (String)"(JPanelApplianceNonBuffered initPanelAppliance) Allocating new pixel array of MAX_VIDEO_WIDTH x MAX_VIDEO_HEIGHT");
        }
        if (bl) {
            for (int i = 0; i < this.m_anPixels.length; ++i) {
                this.m_anPixels[i] = 0;
            }
        }
        if (this.m_mis != null) {
            this.m_mis = null;
        }
        this.m_mis = new MemoryImageSource(this.m_nBitmapWidth, this.m_nBitmapHeight, this.m_anPixels, 0, this.m_nPixelArrayWidth);
    }

    public void focusGained(FocusEvent focusEvent) {
        Trace.logInfo((String)szTraceContext, (String)"(JPanelApplianceNonBuffered focusGained)");
        this.m_nInvokeLaterSleepTime = 5;
    }

    public void focusLost(FocusEvent focusEvent) {
        Trace.logInfo((String)szTraceContext, (String)"(JPanelApplianceNonBuffered focusLost)");
        this.m_nInvokeLaterSleepTime = 400;
    }

    public void setVideoQueueSleepTimeActivated() {
        this.m_nInvokeLaterSleepTime = 5;
    }

    public void setVideoQueueSleepTimeDeactivated() {
        this.m_nInvokeLaterSleepTime = 400;
    }

    public synchronized void setRunVideoQueue(boolean bl) {
        this.m_bRunVideoCheck = bl;
    }

    private synchronized boolean isNewVideoDataAvailable() {
        return this.m_bNewVideoData;
    }

    public synchronized void setPixels(int n, int n2, int n3, int n4, byte[] byArray) {
        this.m_nVideoTemporarilyStopped = -1;
        if (this.m_mis == null || this.m_bReinitMIS) {
            Trace.logInfo((String)szTraceContext, (String)("JPanelApplianceNonBuffered.setPixels calling initMISWithICM and initImage m_bReinitMIS=" + this.m_bReinitMIS));
            this.initMISWithICM(this.m_bEraseImage);
            this.initImage();
            this.m_bReinitMIS = false;
        }
        if (this.m_checkVideo == null) {
            this.m_checkVideo = new checkVideo();
            this.m_checkVideo.start();
        }
        for (int i = 0; i < n4; ++i) {
            System.arraycopy(byArray, i * n3, this.m_abPixels, (n2 + i) * this.m_nBitmapWidth + n, n3);
        }
        this.updateDirtyRegion(n, n2, n + n3, n2 + n4);
    }

    private synchronized void setNewPixelsAndResetBitmapDirtyRegion() {
        this.m_bPaintPending = true;
        this.m_mis.newPixels(this.m_rectDirtyRegion.x, this.m_rectDirtyRegion.y, this.m_rectDirtyRegion.width - this.m_rectDirtyRegion.x, this.m_rectDirtyRegion.height - this.m_rectDirtyRegion.y);
        if (this.m_nDecimationFactor != 1) {
            this.repaint(0L, this.m_rectDirtyRegion.x / this.m_nDecimationFactor, this.m_rectDirtyRegion.y / this.m_nDecimationFactor, (this.m_rectDirtyRegion.width - this.m_rectDirtyRegion.x + this.m_nDecimationFactor - 1) / this.m_nDecimationFactor, (this.m_rectDirtyRegion.height - this.m_rectDirtyRegion.y + this.m_nDecimationFactor - 1) / this.m_nDecimationFactor);
        } else {
            this.repaint(this.m_rectDirtyRegion.x, this.m_rectDirtyRegion.y, this.m_rectDirtyRegion.width - this.m_rectDirtyRegion.x, this.m_rectDirtyRegion.height - this.m_rectDirtyRegion.y);
        }
        this.initDirtyRegion();
        this.m_bNewVideoData = false;
    }

    public boolean setDvcStartOfFrame(int n, int n2, int n3) {
        this.m_nVideoTemporarilyStopped = -1;
        if (this.m_mis == null || this.m_bReinitMIS) {
            Trace.logInfo((String)szTraceContext, (String)("JPanelApplianceNonBuffered.setDvcStartOfFrame calling initMISWithICM and initImage m_bReinitMIS=" + this.m_bReinitMIS));
            this.initMISNoICM(this.m_bEraseImage);
            this.initImage();
            this.m_bReinitMIS = false;
        }
        if (this.m_nBitmapHeight != n2 || this.m_nBitmapWidth != n || this.m_nDecimationFactor != n3) {
            Trace.logInfo((String)szTraceContext, (String)("(JPanelApplianceNonBuffered setDvcStartOfFrame) size of frame or decimation changed m_nBitmapHeight=" + this.m_nBitmapHeight + " nHeight=" + n2 + " m_nBitmapWidth=" + this.m_nBitmapWidth + " nWidth=" + n + " m_nDecimationFactor=" + this.m_nDecimationFactor + " nDecimationFactor=" + n3));
            Trace.logInfo((String)szTraceContext, (String)"(JPanelApplianceNonBuffered setDvcStartOfFrame) resizing video window ");
            this.m_applianceSession.getApplianceWindow().resizeVideoWindow(n, n2, !this.m_bIsPanelForThumbnail);
            if (this.m_mis == null || this.m_bReinitMIS) {
                Trace.logInfo((String)szTraceContext, (String)("JPanelApplianceNonBuffered.setDvcStartOfFrame calling initMISWithICM and initImage m_bReinitMIS=" + this.m_bReinitMIS));
                this.initMISNoICM(this.m_bEraseImage);
                this.initImage();
                this.m_bReinitMIS = false;
            }
        } else if (!this.m_bFirstDvcStartOfFrameMatchingSavedParametersReceived) {
            Trace.logInfo((String)szTraceContext, (String)"(JPanelApplianceNonBuffered setDvcStartOfFrame) m_bFirstDvcStartOfFrameMatchingSavedParametersReceived set true");
            this.m_bFirstDvcStartOfFrameMatchingSavedParametersReceived = true;
        }
        if (this.m_bPPPConnection) {
            this.m_threadDrawDvc = new JPanelAppliance.ThreadDrawDvc();
            this.m_threadDrawDvc.start();
        }
        this.m_bIgnoreDvcData = false;
        return true;
    }

    protected synchronized void drawDvc() {
        if (this.m_checkVideo == null) {
            this.m_checkVideo = new checkVideo();
            this.m_checkVideo.start();
        }
    }

    public void dvcEndOfFrame() {
        this.drawDvc();
    }

    public void paint(Graphics graphics) {
        if (this.m_nVideoTemporarilyStopped >= 0) {
            this.drawVideoStoppedScreen(graphics);
        } else if (this.m_image != null) {
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle == null) {
                rectangle = new Rectangle(0, 0, this.m_nBitmapWidth, this.m_nBitmapHeight);
            }
            if (this.m_nDecimationFactor != 1) {
                graphics.drawImage(this.m_image, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x * this.m_nDecimationFactor, rectangle.y * this.m_nDecimationFactor, (rectangle.x + rectangle.width) * this.m_nDecimationFactor, (rectangle.y + rectangle.height) * this.m_nDecimationFactor, this);
            } else {
                graphics.drawImage(this.m_image, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height, this);
            }
        } else {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, this.m_nBitmapWidth, this.m_nBitmapHeight);
        }
        this.setPaintPending(false);
    }

    protected synchronized boolean isPaintPending() {
        return this.m_bPaintPending;
    }

    protected synchronized void setPaintPending(boolean bl) {
        this.m_bPaintPending = bl;
    }

    public BufferedImage getBufferedImage() {
        Trace.logInfo((String)szTraceContext, (String)"JPanelApplianceNonBuffered.getBufferedImage");
        BufferedImage bufferedImage = new BufferedImage(this.m_nBitmapWidth, this.m_nBitmapHeight, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.drawImage(this.m_image, 0, 0, null);
        graphics.dispose();
        return bufferedImage;
    }

    public int[] getPixelArray() {
        return this.m_anPixels;
    }

    class checkVideo
    extends Thread {
        checkVideo() {
            super("Check Video");
        }

        public void run() {
            Trace.logInfo((String)JPanelApplianceNonBuffered.szTraceContext, (String)"(JPanelApplianceNonBuffered checkVideoQueue run)");
            while (JPanelApplianceNonBuffered.this.m_bRunVideoCheck) {
                if (JPanelApplianceNonBuffered.this.isNewVideoDataAvailable() && !JPanelApplianceNonBuffered.this.isPaintPending()) {
                    JPanelApplianceNonBuffered.this.setNewPixelsAndResetBitmapDirtyRegion();
                }
                try {
                    checkVideo.sleep(JPanelApplianceNonBuffered.this.m_nInvokeLaterSleepTime);
                }
                catch (InterruptedException interruptedException) {}
            }
            Trace.logInfo((String)JPanelApplianceNonBuffered.szTraceContext, (String)("(JPanelApplianceNonBuffered checkVideoQueue run) m_bRunVideoQueue: " + JPanelApplianceNonBuffered.this.m_bRunVideoCheck));
            JPanelApplianceNonBuffered.this.m_checkVideo = null;
        }
    }
}

