/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionConstructorFailed;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.gui.dialogs.JDialogLogin;
import com.avocent.lib.gui.dialogs.JOptionPaneFixedSize;
import com.avocent.lib.gui.dialogs.Message;
import com.avocent.lib.interfaces.InterfaceViewer3;
import com.avocent.lib.interfaces.SessionStatus;
import com.avocent.lib.util.OS;
import com.avocent.lib.util.ResourceManager;
import com.avocent.lib.util.UsernamePassword;
import com.avocent.protocols.socket.SSLHelper;
import com.avocent.video.AVSPStatus;
import com.avocent.video.ApplianceSession;
import com.avocent.video.ApplianceSessionAERP;
import com.avocent.video.ApplianceSessionAVSP;
import com.avocent.video.ApplianceSessionInfo;
import com.avocent.video.BrandNaming;
import com.avocent.video.DSConnect;
import com.avocent.video.DSPath;
import com.avocent.video.DataInputStreamEndian;
import com.avocent.video.DataOutputStreamEndian;
import com.avocent.video.InterfaceElapsedTimeDialog;
import com.avocent.video.InterfaceNotifyOnClosing;
import com.avocent.video.InterfaceViewWindow;
import com.avocent.video.JDialogConnectionMode;
import com.avocent.video.JDialogWaitingForPreemption;
import com.avocent.video.JFrameThumbnail;
import com.avocent.video.JPanelAppliance;
import com.avocent.video.JPanelApplianceNonBuffered;
import com.avocent.video.PersistentStorage;
import com.avocent.video.SessionManager;
import com.avocent.video.UserNotification;
import com.avocent.video.videoViewer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.BevelBorder;

public class JPanelApplianceThumbnailTitle
extends JPanel
implements InterfaceViewWindow,
InterfaceNotifyOnClosing {
    public static final String CNAME = "JPanelApplianceThumbnailTitle";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    public static final int THUMBNAILSIZE_32x24 = 1;
    public static final int THUMBNAILSIZE_40x30 = 2;
    public static final int THUMBNAILSIZE_60x45 = 3;
    public static final int THUMBNAILSIZE_64x48 = 4;
    public static final int THUMBNAILSIZE_80x60 = 5;
    public static final int THUMBNAILSIZE_120x90 = 6;
    public static final int THUMBNAILSIZE_128x96 = 7;
    public static final int THUMBNAILSIZE_160x120 = 8;
    public static final int THUMBNAILSIZE_213x160 = 9;
    public static final int THUMBNAILSIZE_240x180 = 10;
    public static final int THUMBNAILSIZE_320x240 = 11;
    public static final int THUMBNAILSIZE_416x312 = 12;
    public static final int THUMBNAILSIZE_512x384 = 13;
    public static final int THUMBNAILSIZE_640x480 = 14;
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    private static final int PORT_NUMBER_AVSP_SSL = 2068;
    private static final int PORT_NUMBER_AVSP_VIDEO = 8192;
    private static final int PORT_NUMBER_EMBEDDED_TCP = 2000;
    private static final int PORT_NUMBER_EMBEDDED_UDP = 623;
    private static final int INPUT_BUFFER_SIZE = 32768;
    private static final int LED_HEIGHT = 20;
    private static final int APPLIANCE_DISCONNECT_TIME = 3;
    private static final int UPDATE_VIDEO_IMG_TIME = 3;
    private static final int CASCADE_SWITCH_DISCONNECT_TIME = 15;
    private int m_nBitmapWidth;
    private int m_nBitmapHeight;
    private int m_nDecimationFactor;
    private Vector m_vDSPaths;
    private JPanelAppliance m_appliancePanel;
    private ApplianceSession m_applianceSession;
    private boolean m_bConnectingSession = false;
    private InterfaceViewer3 m_iFaceViewer;
    private boolean m_bFrameActive = false;
    private boolean m_bDisplayTitle = false;
    private JLabel m_labelName;
    private Color m_colorForegroundLabel;
    private UsernamePassword m_userCredentials;
    private boolean m_bUserCredentialsSet = false;
    private JLed m_led;
    private int m_nScanTime;
    private boolean m_bScanEnabled = true;
    private boolean m_bConnectedForThumbnail = false;
    private boolean m_bEnableMouseClicks = true;
    private JFrameThumbnail m_frameThumbnail;
    boolean m_bLocalUserUsingChannelWeArePreempting = false;
    private InterfaceElapsedTimeDialog m_dlgElapsed = null;
    private boolean m_bUserCancelled = false;
    private String m_szHelpURL;
    private int m_nApplication;
    private boolean m_bUseCert = false;
    private boolean m_bDisconnectCurrentUser = false;
    private boolean m_bLoginWithNewCredentials = false;
    private byte m_bConnectionMode = 0;
    private DataOutputStreamEndian m_dosAppliance = null;
    private DataInputStreamEndian m_disAppliance = null;
    private DataOutputStreamEndian m_dosApplianceVideo = null;
    private DataInputStreamEndian m_disApplianceVideo = null;
    private Properties m_propertiesLaunchArgs;
    DatagramSocket udpConnection = null;
    static /* synthetic */ Class class$com$avocent$video$JPanelApplianceThumbnailTitle;

    public JPanelApplianceThumbnailTitle(Vector vector, String string, UsernamePassword usernamePassword, boolean bl, int n, int n2, JFrameThumbnail jFrameThumbnail, int n3, Properties properties, String string2) {
        Object object;
        Object object2;
        this.m_vDSPaths = vector;
        boolean bl2 = true;
        for (int i = 0; i < this.m_vDSPaths.size(); ++i) {
            object2 = (DSPath)this.m_vDSPaths.get(i);
            if (((DSPath)object2).getUCC()) continue;
            bl2 = false;
            break;
        }
        this.m_userCredentials = bl2 ? new UsernamePassword(usernamePassword) : new UsernamePassword("", "");
        this.m_bDisplayTitle = bl;
        this.m_nScanTime = n2;
        this.m_frameThumbnail = jFrameThumbnail;
        this.m_nApplication = n3;
        this.m_propertiesLaunchArgs = properties;
        this.m_szHelpURL = string2;
        if (string.length() == 0) {
            object = new PersistentStorage();
            this.m_iFaceViewer = object;
        } else {
            try {
                object = Class.forName(string);
                this.m_iFaceViewer = (InterfaceViewer3)((Class)object).newInstance();
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)"Bad szIFaceViewer", (Throwable)exception);
            }
        }
        switch (n) {
            default: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 7;
                break;
            }
            case 2: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 16;
                break;
            }
            case 3: {
                this.m_nBitmapWidth = 960;
                this.m_nBitmapHeight = 720;
                this.m_nDecimationFactor = 8;
                break;
            }
            case 4: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 6;
                break;
            }
            case 5: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 8;
                break;
            }
            case 6: {
                this.m_nBitmapWidth = 960;
                this.m_nBitmapHeight = 720;
                this.m_nDecimationFactor = 7;
                break;
            }
            case 7: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 5;
                break;
            }
            case 8: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 4;
                break;
            }
            case 9: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 3;
                break;
            }
            case 10: {
                this.m_nBitmapWidth = 960;
                this.m_nBitmapHeight = 720;
                this.m_nDecimationFactor = 6;
                break;
            }
            case 11: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 2;
                break;
            }
            case 12: {
                this.m_nBitmapWidth = 832;
                this.m_nBitmapHeight = 624;
                this.m_nDecimationFactor = 2;
                break;
            }
            case 13: {
                this.m_nBitmapWidth = 1024;
                this.m_nBitmapHeight = 768;
                this.m_nDecimationFactor = 2;
                break;
            }
            case 14: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 1;
            }
        }
        this.m_appliancePanel = OS.isLinux() ? new JPanelApplianceNonBuffered(true) : new JPanelAppliance(true);
        this.setLayout(null);
        this.add(this.m_appliancePanel);
        this.m_appliancePanel.setLocation(0, 0);
        this.m_led = new JLed(0, this.m_nBitmapHeight / this.m_nDecimationFactor + 5);
        this.add(this.m_led);
        this.m_led.validate();
        if (this.m_bDisplayTitle) {
            this.m_labelName = new JLabel(this.getServerName());
            this.add(this.m_labelName);
            int n4 = this.m_nBitmapWidth / this.m_nDecimationFactor - this.m_led.getWidth();
            this.m_labelName.setBounds(this.m_led.getWidth() + (this.m_nBitmapWidth / this.m_nDecimationFactor - this.m_led.getWidth() - n4) / 2, this.m_nBitmapHeight / this.m_nDecimationFactor, n4, 20);
            this.m_labelName.setHorizontalAlignment(0);
            this.m_labelName.setVerticalAlignment(1);
            this.m_labelName.setVisible(true);
            object2 = this.m_labelName.getBounds();
            this.m_colorForegroundLabel = this.m_labelName.getForeground();
            Dimension dimension = new Dimension(this.m_nBitmapWidth / this.m_nDecimationFactor, this.m_nBitmapHeight / this.m_nDecimationFactor + 20);
            this.setSize(dimension);
        } else {
            this.setSize(this.m_nBitmapWidth / this.m_nDecimationFactor, this.m_nBitmapHeight / this.m_nDecimationFactor);
        }
        this.setOpaque(false);
        this.validate();
        this.m_appliancePanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                JPanelApplianceThumbnailTitle.this.appliancePanel_mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                JPanelApplianceThumbnailTitle.this.appliancePanel_mouseReleased(mouseEvent);
            }
        });
    }

    public JPanelApplianceThumbnailTitle(DSPath dSPath, InterfaceViewer3 interfaceViewer3, boolean bl, int n, int n2, JFrameThumbnail jFrameThumbnail, int n3, Properties properties, String string) {
        this.m_bUseCert = true;
        this.m_vDSPaths = new Vector(1);
        this.m_vDSPaths.add(dSPath);
        this.m_iFaceViewer = interfaceViewer3;
        this.m_bDisplayTitle = bl;
        this.m_nScanTime = n2;
        this.m_frameThumbnail = jFrameThumbnail;
        this.m_nApplication = n3;
        this.m_propertiesLaunchArgs = properties;
        this.m_szHelpURL = string;
        switch (n) {
            default: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 7;
                break;
            }
            case 2: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 16;
                break;
            }
            case 3: {
                this.m_nBitmapWidth = 960;
                this.m_nBitmapHeight = 720;
                this.m_nDecimationFactor = 8;
                break;
            }
            case 4: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 6;
                break;
            }
            case 5: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 8;
                break;
            }
            case 6: {
                this.m_nBitmapWidth = 960;
                this.m_nBitmapHeight = 720;
                this.m_nDecimationFactor = 7;
                break;
            }
            case 7: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 5;
                break;
            }
            case 8: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 4;
                break;
            }
            case 9: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 3;
                break;
            }
            case 10: {
                this.m_nBitmapWidth = 960;
                this.m_nBitmapHeight = 720;
                this.m_nDecimationFactor = 6;
                break;
            }
            case 11: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 2;
                break;
            }
            case 12: {
                this.m_nBitmapWidth = 832;
                this.m_nBitmapHeight = 624;
                this.m_nDecimationFactor = 2;
                break;
            }
            case 13: {
                this.m_nBitmapWidth = 1024;
                this.m_nBitmapHeight = 768;
                this.m_nDecimationFactor = 2;
                break;
            }
            case 14: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 1;
            }
        }
        this.m_appliancePanel = OS.isLinux() ? new JPanelApplianceNonBuffered(true) : new JPanelAppliance(true);
        this.setLayout(null);
        this.add(this.m_appliancePanel);
        this.m_appliancePanel.setLocation(0, 0);
        this.m_led = new JLed(0, this.m_nBitmapHeight / this.m_nDecimationFactor + 5);
        this.add(this.m_led);
        this.m_led.validate();
        if (this.m_bDisplayTitle) {
            this.m_labelName = new JLabel(this.getServerName());
            this.add(this.m_labelName);
            int n4 = this.m_nBitmapWidth / this.m_nDecimationFactor - this.m_led.getWidth();
            this.m_labelName.setBounds(this.m_led.getWidth() + (this.m_nBitmapWidth / this.m_nDecimationFactor - this.m_led.getWidth() - n4) / 2, this.m_nBitmapHeight / this.m_nDecimationFactor, n4, 20);
            this.m_labelName.setHorizontalAlignment(0);
            this.m_labelName.setVerticalAlignment(1);
            this.m_labelName.setVisible(true);
            Rectangle rectangle = this.m_labelName.getBounds();
            this.m_colorForegroundLabel = this.m_labelName.getForeground();
            Dimension dimension = new Dimension(this.m_nBitmapWidth / this.m_nDecimationFactor, this.m_nBitmapHeight / this.m_nDecimationFactor + 20);
            this.setSize(dimension);
            this.setPreferredSize(dimension);
        } else {
            this.setSize(this.m_nBitmapWidth / this.m_nDecimationFactor, this.m_nBitmapHeight / this.m_nDecimationFactor);
        }
        this.setOpaque(false);
        this.validate();
        this.m_appliancePanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                JPanelApplianceThumbnailTitle.this.appliancePanel_mousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                JPanelApplianceThumbnailTitle.this.appliancePanel_mouseReleased(mouseEvent);
            }
        });
    }

    public void init() {
        this.m_appliancePanel.initPanelAppliance(null, 0, 0, this.m_nBitmapWidth, this.m_nBitmapHeight, 1024, 768, this.m_nDecimationFactor, false);
        this.m_appliancePanel.setVisible(true);
        this.setVisible(true);
        Object[] objectArray = new Object[]{this.getServerName()};
        String string = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_Thumbnail_Tooltip"), objectArray);
        this.m_appliancePanel.setToolTipText(string);
    }

    public void setScanEnabled(boolean bl) {
        this.m_bScanEnabled = bl;
    }

    public boolean isScanEnabled() {
        return this.m_bScanEnabled;
    }

    public ApplianceSession getApplianceSession() {
        return this.m_applianceSession;
    }

    public boolean connectAppliance(boolean bl, AVSPStatus aVSPStatus) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JPanelApplianceThumbnailTitle.connectAppliance bConnectForThumbnail=" + bl));
        boolean bl2 = false;
        for (int i = 0; i < this.m_vDSPaths.size(); ++i) {
            DSPath dSPath = (DSPath)this.m_vDSPaths.get(i);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JPanelApplianceThumbnailTitle.connectAppliance connecting to path deviceID=" + dSPath.getDeviceID()));
            if (dSPath.isEmbeddedAppliance()) {
                if (!this.embeddedConnect(bl, dSPath, i == this.m_vDSPaths.size() - 1)) continue;
                bl2 = true;
                break;
            }
            if (!this.avspConnect(bl, dSPath, aVSPStatus, i == this.m_vDSPaths.size() - 1)) continue;
            bl2 = true;
            break;
        }
        return bl2;
    }

    public boolean avspConnect(boolean bl, DSPath dSPath, AVSPStatus aVSPStatus, boolean bl2) {
        Object object;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle avspConnect");
        if (bl && !this.m_bScanEnabled) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JPanelApplianceThumbnailTitle.avspConnect bConnectForThumbnail:" + bl + " m_bScanEnabled:" + this.m_bScanEnabled + " returning without attempting connect"));
            return false;
        }
        FilterOutputStream filterOutputStream = null;
        FilterInputStream filterInputStream = null;
        FilterOutputStream filterOutputStream2 = null;
        FilterInputStream filterInputStream2 = null;
        if (this.m_applianceSession != null) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.avspConnect m_applianceSession != null returning without attempting connect");
            if (!bl) {
                this.m_applianceSession.getApplianceWindow().bringWindowToTop();
            }
            return false;
        }
        this.m_applianceSession = null;
        this.m_bConnectingSession = true;
        if (bl && this.m_bDisplayTitle) {
            this.m_led.setLedState(2);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        this.m_bConnectionMode = 0;
        do {
            try {
                Object object2;
                Closeable closeable;
                if (this.m_bUserCancelled) {
                    if (this.m_dlgElapsed != null) {
                        this.m_dlgElapsed.setVisible(false);
                        this.m_dlgElapsed = null;
                    }
                    bl3 = false;
                    throw new ExceptionRequestFailed("User Cancelled");
                }
                object = null;
                SessionAuth sessionAuth = null;
                if (this.m_bUseCert) {
                    sessionAuth = this.handleSessionAuth(bl, dSPath.getServerName(), dSPath.getDeviceID());
                    object = sessionAuth.socketSSL;
                } else {
                    closeable = null;
                    if (dSPath.hasApcp()) {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.avspConnect dsPath.hasApcp");
                        closeable = videoViewer.doApcp(dSPath.getIPAddress(), null, 4, false);
                    } else {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.avspConnect dsPath does not have Apcp");
                        closeable = new Socket(dSPath.getIPAddress(), 2068);
                    }
                    object = SSLHelper.createSSLSocket((Socket)closeable, (String)dSPath.getIPAddress(), (int)2068, (int)30000, null, null, null);
                }
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelApplianceThumbnailTitle avspConnect) Socket connected to: " + ((Socket)object).getInetAddress().getHostAddress().toString() + " port=" + ((Socket)object).getPort()));
                closeable = new BufferedOutputStream(((Socket)object).getOutputStream());
                BufferedInputStream bufferedInputStream = new BufferedInputStream(((Socket)object).getInputStream(), 32768);
                filterOutputStream = new DataOutputStreamEndian((OutputStream)closeable);
                filterInputStream = new DataInputStreamEndian(bufferedInputStream, (Socket)object);
                ((Socket)object).setSoTimeout(30000);
                if (this.m_bUseCert) {
                    DSConnect.dsConnectApplianceAVSP((DataOutputStreamEndian)filterOutputStream, (DataInputStreamEndian)filterInputStream, aVSPStatus);
                } else if (this.m_nApplication == 1 && dSPath.hasApcp()) {
                    DSConnect.dsConnectApplianceAVSP((DataOutputStreamEndian)filterOutputStream, (DataInputStreamEndian)filterInputStream, dSPath, this.m_userCredentials.getUsername(), this.m_userCredentials.getPassword(), bl ? (byte)7 : (byte)this.m_bConnectionMode, aVSPStatus);
                } else {
                    DSConnect.dsConnectApplianceAVSP((DataOutputStreamEndian)filterOutputStream, (DataInputStreamEndian)filterInputStream, dSPath, this.m_userCredentials.getUsername(), this.m_userCredentials.getPassword(), this.m_bDisconnectCurrentUser, aVSPStatus);
                }
                Trace.logInfo((String)TRACE_CONTEXT, (String)("JPanelApplianceThumbnailTitle.avspConnect avspStatus.getLoginStatus: " + aVSPStatus.getLoginStatus()));
                ((Socket)object).setSoTimeout(0);
                this.m_bDisconnectCurrentUser = false;
                this.m_bLoginWithNewCredentials = false;
                if (this.m_dlgElapsed != null) {
                    this.m_dlgElapsed.setVisible(false);
                    this.m_dlgElapsed = null;
                }
                if (this.m_bUserCancelled) {
                    bl3 = false;
                    throw new ExceptionRequestFailed("User Cancelled");
                }
                if (aVSPStatus.getLoginStatus() == 0) {
                    Closeable closeable2;
                    object2 = null;
                    if (aVSPStatus.isVideoEncrypted()) {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect video is to be encrypted");
                        closeable2 = null;
                        if (sessionAuth != null) {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect video is to be encrypted sessionAuth != null");
                            if (sessionAuth.sessionStatus.hasApcp()) {
                                Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect video is to be encrypted sessionAuth != null, has APCP");
                                closeable2 = videoViewer.doApcp(sessionAuth.sessionStatus.getIpAddress().getHostAddress(), sessionAuth.sessionStatus, 8, true);
                            }
                        } else if (dSPath.hasApcp()) {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect video is to be encrypted sessionAuth == null, hasAPCP");
                            closeable2 = videoViewer.doApcp(dSPath.getIPAddress(), null, 4, true);
                        }
                        if (sessionAuth != null && sessionAuth.sessionStatus != null) {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect video is to be encrypted sessionAuth != null, calling connectSSLSession");
                            object2 = videoViewer.connectSSLSession(closeable2, sessionAuth.sessionStatus, true, sessionAuth.sessionStatus.hasApcp());
                        } else {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect video is to be encrypted sessionAuth == null, checking socketPrime");
                            if (closeable2 == null) {
                                Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect video is to be encrypted sessionAuth == null, socketPrime == null");
                                closeable2 = new Socket(dSPath.getIPAddress(), 8192);
                            }
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"videoViewer.avspConnect video is to be encrypted sessionAuth == null, calling createSSLSocket");
                            object2 = SSLHelper.createSSLSocket((Socket)closeable2, (String)dSPath.getIPAddress(), (int)8192, (int)30000, null, null, null);
                        }
                    } else if (sessionAuth != null) {
                        Trace.logInfo((String)TRACE_CONTEXT, (String)"(JPanelApplianceThumbnailTitle sessionAuth != null");
                        if (sessionAuth.sessionStatus.hasApcp()) {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JPanelApplianceThumbnailTitle sessionAuth.sessionStatus.hasApcp=true");
                            object2 = videoViewer.doApcp(sessionAuth.sessionStatus.getIpAddress().getHostAddress(), sessionAuth.sessionStatus, 1, true);
                        } else {
                            Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelApplianceThumbnailTitle sessionAuth.sessionStatus.hasApcp=false IP Address=" + sessionAuth.sessionStatus.getIpAddress().getHostAddress() + " port=" + sessionAuth.sessionStatus.getPortVideo()));
                            object2 = new Socket(sessionAuth.sessionStatus.getIpAddress().getHostAddress(), sessionAuth.sessionStatus.getPortVideo());
                        }
                    } else {
                        object2 = dSPath.hasApcp() ? videoViewer.doApcp(dSPath.getIPAddress(), null, 1, true) : new Socket(dSPath.getIPAddress(), 8192);
                    }
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelApplianceThumbnailTitle avspConnect)Video Socket connected to: " + ((Socket)object2).getInetAddress().getHostAddress().toString()));
                    ((Socket)object2).setSoTimeout(30000);
                    closeable2 = new BufferedOutputStream(((Socket)object2).getOutputStream());
                    BufferedInputStream bufferedInputStream2 = new BufferedInputStream(((Socket)object2).getInputStream(), 32768);
                    filterOutputStream2 = new DataOutputStreamEndian((OutputStream)closeable2);
                    filterInputStream2 = new DataInputStreamEndian(bufferedInputStream2, (Socket)object2);
                    if (DSConnect.dsConnectVideoAVSP((DataOutputStream)filterOutputStream2, (DataInputStream)filterInputStream2, aVSPStatus.getClientRandom(), aVSPStatus.getApplianceRandom())) {
                        ((Socket)object2).setSoTimeout(0);
                        if (bl) {
                            this.m_led.setLedState(3);
                            this.m_applianceSession = new ApplianceSessionAVSP(this, this.m_nBitmapWidth, this.m_nBitmapHeight, this.m_nDecimationFactor, this.m_iFaceViewer, null, dSPath, (DataInputStreamEndian)filterInputStream, (DataOutputStreamEndian)filterOutputStream, (DataInputStreamEndian)filterInputStream2, (DataOutputStreamEndian)filterOutputStream2, false, false, this.m_szHelpURL, false, false, false, true, this.m_nApplication, true);
                            if (this.m_applianceSession == null) continue;
                            this.m_applianceSession.videoConfigChanged(this.m_appliancePanel);
                            this.connectedForThumbnail(true);
                            this.m_applianceSession.setNotifyOnClosing(this);
                            this.m_applianceSession.setLaunchProperties(this.m_propertiesLaunchArgs);
                            continue;
                        }
                        Object[] objectArray = new Object[]{dSPath.getServerName()};
                        String string = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_Video_Viewer_Session"), objectArray);
                        this.m_applianceSession = new ApplianceSessionAVSP(this.m_iFaceViewer, null, dSPath, string, (DataInputStreamEndian)filterInputStream, (DataOutputStreamEndian)filterOutputStream, (DataInputStreamEndian)filterInputStream2, (DataOutputStreamEndian)filterOutputStream2, this.m_szHelpURL, aVSPStatus.isSharedSession() || aVSPStatus.isPassiveSession() || aVSPStatus.isStealthSession(), false, aVSPStatus.isStealthSession(), aVSPStatus.isPassiveSession() || aVSPStatus.isStealthSession(), this.m_nApplication, aVSPStatus.getClientRandom(), aVSPStatus.getApplianceRandom());
                        if (this.m_applianceSession == null) continue;
                        this.m_applianceSession.setNotifyOnClosing(this);
                        this.m_bFrameActive = true;
                        this.m_applianceSession.setLaunchProperties(this.m_propertiesLaunchArgs);
                        int n = 1;
                        if (aVSPStatus.isStealthSession()) {
                            n = 6;
                        } else if (aVSPStatus.isPassiveSession()) {
                            n = 5;
                        } else if (aVSPStatus.isSharedSession()) {
                            n = 4;
                        }
                        this.m_applianceSession.setConnectionType(n);
                        continue;
                    }
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        filterInputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        filterOutputStream2.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        filterInputStream2.close();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.avspConnect login failed");
                if (bl) {
                    object2 = this.getDSPathInteractiveSession();
                    if (object2 != null) {
                        this.m_led.setLedState(5, this.getLoginFailureReason(aVSPStatus));
                        continue;
                    }
                    this.m_led.setLedState(4, this.getLoginFailureReason(aVSPStatus));
                    continue;
                }
                if (!bl2) {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.avspConnect the login failed and bDisplayErrorMessage false");
                    break;
                }
                this.m_bDisconnectCurrentUser = this.handleLoginFailure(aVSPStatus, dSPath);
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)("JPanelApplianceThumbnailTitle.avspConnect Exception= " + exception.getMessage()), (Throwable)exception);
                aVSPStatus.setLoginStatus((byte)100);
                this.m_led.setLedState(4, this.getLoginFailureReason(aVSPStatus));
                try {
                    filterOutputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                try {
                    filterInputStream.close();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                try {
                    filterOutputStream2.close();
                }
                catch (Exception exception4) {
                    // empty catch block
                }
                try {
                    filterInputStream2.close();
                }
                catch (Exception exception5) {
                    // empty catch block
                }
            }
        } while (this.m_bDisconnectCurrentUser || this.m_bLoginWithNewCredentials);
        this.m_bConnectingSession = false;
        if (this.m_applianceSession == null) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.avspConnect checking to see if an interactive session exists");
            object = this.getDSPathInteractiveSession();
        } else if (!bl) {
            this.m_led.setLedState(5);
        }
        return this.m_applianceSession != null;
    }

    public boolean embeddedConnect(boolean bl, DSPath dSPath, boolean bl2) {
        Object object;
        int n;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (bl && !this.m_bScanEnabled) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JPanelApplianceThumbnailTitle.embeddedConnect bConnectForThumbnail:" + bl + " m_bScanEnabled:" + this.m_bScanEnabled + " returning without attempting connect"));
            return false;
        }
        if (this.m_applianceSession != null) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.embeddedConnect m_applianceSession != null returning without attempting connect");
            if (!bl) {
                this.m_applianceSession.getApplianceWindow().bringWindowToTop();
            }
            return false;
        }
        this.m_applianceSession = null;
        this.m_bConnectingSession = true;
        if (bl && this.m_bDisplayTitle) {
            this.m_led.setLedState(2);
        }
        String string = dSPath.getConnectionType();
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelApplianceThumbnailTitle embeddedConnect) Connection type: " + string + " IPAddress=" + dSPath.getIPAddress()));
        if (string.compareToIgnoreCase("tcpudp") == 0) {
            bl5 = true;
        } else if (string.compareToIgnoreCase("udp") == 0) {
            bl4 = true;
            bl5 = true;
        }
        String string2 = dSPath.getDeviceType();
        if (string2.compareToIgnoreCase("embeddedV1") == 0) {
            n = 3;
            if (bl5) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelApplianceThumbnailTitle embeddedConnect) Connection type: " + string + " invalid for V1 appliance. Resetting to TCP"));
                bl5 = false;
                bl4 = false;
            }
        } else {
            n = 4;
        }
        try {
            Object object2;
            if (!bl4) {
                object = new Socket(InetAddress.getByName(dSPath.getIPAddress()), 2000);
                ((Socket)object).setTcpNoDelay(true);
                ((Socket)object).setReceiveBufferSize(32768);
                Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelApplianceThumbnailTitle embeddedConnect)Socket connected to: " + ((Socket)object).getInetAddress().getHostAddress().toString()));
                object2 = new BufferedOutputStream(((Socket)object).getOutputStream());
                BufferedInputStream bufferedInputStream = new BufferedInputStream(((Socket)object).getInputStream());
                this.m_dosAppliance = new DataOutputStreamEndian((OutputStream)object2);
                this.m_disAppliance = new DataInputStreamEndian(bufferedInputStream, (Socket)object);
            }
            if (bl4 || bl5) {
                this.udpConnection = new DatagramSocket();
                int n2 = 4;
                int n3 = 8;
                int n4 = 16;
                this.udpConnection.setTrafficClass(n2 | n3 | n4);
                this.udpConnection.setSendBufferSize(1500);
                this.udpConnection.setReceiveBufferSize(131072);
            }
            if (!bl4 && bl5) {
                object = new DSConnect();
                ((DSConnect)object).dsConnectEmbedded(this.udpConnection, dSPath.getIPAddress(), 2000);
            }
            if (bl) {
                this.m_led.setLedState(3);
                this.m_applianceSession = new ApplianceSessionAERP(this, this.m_nBitmapWidth, this.m_nBitmapHeight, this.m_nDecimationFactor, this.m_iFaceViewer, null, dSPath, n, this.m_disAppliance, this.m_dosAppliance, this.udpConnection, this.m_szHelpURL, dSPath.isPPPEnabled(), bl4, bl5, dSPath.isVideoEncryptionEnabled(), this.m_nApplication);
                if (this.m_applianceSession != null) {
                    this.connectedForThumbnail(true);
                    this.m_applianceSession.setNotifyOnClosing(this);
                }
            } else {
                object = new Object[]{dSPath.getServerName()};
                object2 = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_Video_Viewer_Session"), (Object[])object);
                this.m_applianceSession = new ApplianceSessionAERP(this.m_iFaceViewer, null, dSPath, (String)object2, dSPath.getServerName(), n, this.m_disAppliance, this.m_dosAppliance, this.udpConnection, this.m_szHelpURL, dSPath.isPPPEnabled(), bl4, bl5, dSPath.isVideoEncryptionEnabled(), this.m_nApplication);
                if (this.m_applianceSession != null) {
                    this.m_applianceSession.setNotifyOnClosing(this);
                    this.m_bFrameActive = true;
                }
            }
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(JPanelApplianceThumbnailTitle embeddedConnect) error", (Throwable)exception);
            try {
                if (!bl4) {
                    this.m_dosAppliance.close();
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            try {
                if (!bl4) {
                    this.m_disAppliance.close();
                }
            }
            catch (Exception exception3) {
                // empty catch block
            }
            try {
                if (bl4 || bl5) {
                    this.udpConnection.close();
                }
            }
            catch (Exception exception4) {
                // empty catch block
            }
        }
        this.m_bConnectingSession = false;
        if (this.m_applianceSession == null) {
            object = this.getDSPathInteractiveSession();
            if (this.m_bDisplayTitle && bl && object == null) {
                this.m_labelName.setForeground(this.m_colorForegroundLabel);
                this.m_led.setLedState(4);
            }
        } else if (!bl) {
            this.m_led.setLedState(5);
        }
        return this.m_applianceSession != null;
    }

    private SessionAuth handleSessionAuth(boolean bl, String string, String string2) throws ExceptionRequestFailed, IOException, UnknownHostException {
        SessionAuth sessionAuth = new SessionAuth();
        int n = bl ? 7 : 0;
        do {
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JPanelApplianceThumbnailTitle.handleSessionAuth using cert, calling m_iFaceViewer.startSession for deviceID=" + string2 + " m_iFaceViewer=" + this.m_iFaceViewer));
            sessionAuth.sessionStatus = this.m_iFaceViewer.startSession(string2, n);
            if (sessionAuth.sessionStatus == null) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.handleSessionAuth startSession failed");
                throw new ExceptionRequestFailed("startSession failed");
            }
            int n2 = sessionAuth.sessionStatus.getSessionStatusCode();
            switch (n2) {
                case 0: {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.handleSessionAuth sessionStatus STATUS_CONNECTED");
                    Socket socket = null;
                    if (sessionAuth.sessionStatus.hasApcp()) {
                        socket = videoViewer.doApcp(sessionAuth.sessionStatus.getIpAddress().getHostAddress(), sessionAuth.sessionStatus, 8, false);
                    }
                    sessionAuth.socketSSL = videoViewer.connectSSLSession(socket, sessionAuth.sessionStatus, false, sessionAuth.sessionStatus.hasApcp());
                    break;
                }
                case 1: 
                case 2: {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)("JPanelApplianceThumbnailTitle.handleSessionAuth sessionstatus=" + n2));
                    if (!bl) {
                        byte by = sessionAuth.sessionStatus.getConnectPossibilities();
                        boolean bl2 = (by & 1) == 1;
                        boolean bl3 = (by & 2) == 2;
                        boolean bl4 = (by & 4) == 4;
                        Trace.logInfo((String)TRACE_CONTEXT, (String)("JPanelApplianceThumbnailTitle.handleSessionAuth sessionstatus.STATUS_CHECK_MODE bModesAvailable=" + Integer.toHexString(by) + " bPreempt=" + bl2 + " bShare=" + bl3 + " bStealth=" + bl4));
                        if (!(bl2 || bl3 || bl4)) {
                            Message.show(null, (String)RES.getString("JPanelApplianceThumbnailTitle_Server_Not_Available"));
                            throw new ExceptionRequestFailed("sessionstatus.STATUS_BLOCKED");
                        }
                        JDialogConnectionMode jDialogConnectionMode = new JDialogConnectionMode(null, bl3, bl2, bl4, string, sessionAuth.sessionStatus.getConnectedUserName(), this.m_szHelpURL);
                        jDialogConnectionMode.setModal(true);
                        jDialogConnectionMode.setVisible(true);
                        if (jDialogConnectionMode.wasOkPressed()) {
                            if (jDialogConnectionMode.getConnectionMode() == 2) {
                                n = 2;
                                break;
                            }
                            if (jDialogConnectionMode.getConnectionMode() == 1) {
                                if (jDialogConnectionMode.wasPassiveShareSet()) {
                                    n = 6;
                                    break;
                                }
                                n = 5;
                                break;
                            }
                            if (jDialogConnectionMode.getConnectionMode() == 3) {
                                n = 4;
                                break;
                            }
                            throw new ExceptionRequestFailed("unknown connection type from connection mode dialog");
                        }
                        throw new ExceptionRequestFailed("user cancelled from connection mode dialog");
                    }
                    this.m_led.setLedState(4, this.getAuthFailureReason(n2));
                    throw new ExceptionRequestFailed("could not connect in thumbnail mode");
                }
                case 7: {
                    if (!bl) {
                        Message.show(null, (String)RES.getString("JPanelApplianceThumbnailTitle_TOO_MANY_SESSIONS"));
                    } else {
                        this.m_led.setLedState(4, this.getAuthFailureReason(n2));
                    }
                    throw new ExceptionRequestFailed("too many sessions");
                }
                case 5: {
                    if (!bl) {
                        Message.show(null, (String)RES.getString("JPanelApplianceThumbnailTitle_AUTHORIZATION_ERROR"));
                    } else {
                        this.m_led.setLedState(4, this.getAuthFailureReason(n2));
                    }
                    throw new ExceptionRequestFailed("authorization error");
                }
                case 3: {
                    if (!bl) {
                        Message.show(null, (String)RES.getString("JPanelApplianceThumbnailTitle_UNAUTHORIZED_ERROR"));
                    } else {
                        this.m_led.setLedState(4, this.getAuthFailureReason(n2));
                    }
                    throw new ExceptionRequestFailed("unauthorized error");
                }
                case 6: {
                    if (!bl) {
                        Message.show(null, (String)RES.getString("JPanelApplianceThumbnailTitle_UNAVAILABLE_ERROR"));
                    } else {
                        this.m_led.setLedState(4, this.getAuthFailureReason(n2));
                    }
                    throw new ExceptionRequestFailed("unavailable error");
                }
                case 4: {
                    if (!bl) {
                        Message.show(null, (String)RES.getString("JPanelApplianceThumbnailTitle_UNGRADING_ERROR"));
                    } else {
                        this.m_led.setLedState(4, this.getAuthFailureReason(n2));
                    }
                    throw new ExceptionRequestFailed("upgrading error");
                }
                default: {
                    Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.handleSessionAuth unknown session status, throwing ExceptionRequestFailed");
                    this.m_led.setLedState(4, this.getAuthFailureReason(n2));
                    throw new ExceptionRequestFailed("unknown session status result");
                }
            }
        } while (sessionAuth.socketSSL == null);
        return sessionAuth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean handleLoginFailure(AVSPStatus aVSPStatus, DSPath dSPath) throws ExceptionConstructorFailed {
        boolean bl = true;
        switch (aVSPStatus.getLoginStatus()) {
            case 1: {
                this.m_bDisconnectCurrentUser = false;
                Boolean bl2 = JFrameThumbnail.m_bModalDlgRequest;
                synchronized (bl2) {
                    Message.show((Component)this.getParentFrame(), (String)RES.getString("JPanelApplianceThumbnailTitle_Invalid_UserName"));
                    JDialogLogin jDialogLogin = new JDialogLogin(this.getParentFrame(), RES.getString("JPanelApplianceThumbnailTitle_Invalid_UserName"), this.m_userCredentials);
                    jDialogLogin.setModal(true);
                    jDialogLogin.setVisible(true);
                    if (jDialogLogin.wasOkPressed()) {
                        this.m_bLoginWithNewCredentials = true;
                    } else {
                        this.m_bDisconnectCurrentUser = false;
                        bl = false;
                    }
                    break;
                }
            }
            case 2: {
                this.m_bDisconnectCurrentUser = false;
                Boolean bl3 = JFrameThumbnail.m_bModalDlgRequest;
                synchronized (bl3) {
                    Message.show((Component)this.getParentFrame(), (String)RES.getString("JPanelApplianceThumbnailTitle_InvalidPassword"));
                    JDialogLogin jDialogLogin = new JDialogLogin(this.getParentFrame(), RES.getString("JPanelApplianceThumbnailTitle_InvalidPassword"), this.m_userCredentials);
                    jDialogLogin.setModal(true);
                    jDialogLogin.setVisible(true);
                    if (jDialogLogin.wasOkPressed()) {
                        this.m_bLoginWithNewCredentials = true;
                    } else {
                        this.m_bDisconnectCurrentUser = false;
                        bl = false;
                    }
                    break;
                }
            }
            case 3: {
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Channel_Access_Denied"));
                break;
            }
            case 4: {
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                if (aVSPStatus.isSharingAvailable() || aVSPStatus.isPreemptionAvailable() || aVSPStatus.isStealthModeAvailable()) {
                    JDialogConnectionMode jDialogConnectionMode = new JDialogConnectionMode(null, aVSPStatus.isSharingAvailable(), aVSPStatus.isPreemptionAvailable(), aVSPStatus.isStealthModeAvailable(), false, dSPath.getServerName(), aVSPStatus.getUserName(), this.m_szHelpURL);
                    jDialogConnectionMode.setModal(true);
                    jDialogConnectionMode.setVisible(true);
                    if (!jDialogConnectionMode.wasOkPressed()) break;
                    int n = jDialogConnectionMode.getConnectionMode();
                    switch (n) {
                        case 1: {
                            this.m_bConnectionMode = 1;
                            this.m_bDisconnectCurrentUser = false;
                            bl = true;
                            break;
                        }
                        case 2: {
                            this.m_bConnectionMode = (byte)6;
                            this.m_bDisconnectCurrentUser = true;
                            bl = true;
                            break;
                        }
                        case 3: {
                            this.m_bConnectionMode = (byte)2;
                            this.m_bDisconnectCurrentUser = false;
                            bl = true;
                        }
                    }
                    break;
                }
                UserNotification.ServerNotAvailableForViewingChannelInUse(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Channel_In_Use"), aVSPStatus.getUserName());
                break;
            }
            case 5: {
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Channel_Not_Found"));
                break;
            }
            case 6: {
                Hashtable hashtable = videoViewer.m_htPendingConnections;
                Enumeration enumeration = hashtable.keys();
                boolean bl4 = false;
                while (enumeration.hasMoreElements()) {
                    String string;
                    String string2 = (String)enumeration.nextElement();
                    if (string2.compareTo(string = dSPath.toString()) != 0) continue;
                    JDialog jDialog = (JDialog)hashtable.get(string2);
                    jDialog.toFront();
                    bl4 = true;
                    break;
                }
                if (!bl4) {
                    this.m_bDisconnectCurrentUser = UserNotification.ServerNotAvailableCanBePreempted(dSPath.getDisplayName(), aVSPStatus.getUserName(), false);
                }
                if (this.m_bDisconnectCurrentUser) break;
                bl = false;
                break;
            }
            case 7: {
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                if (aVSPStatus.isSharingAvailable() || aVSPStatus.isPreemptionAvailable() || aVSPStatus.isStealthModeAvailable()) {
                    JDialogConnectionMode jDialogConnectionMode = new JDialogConnectionMode(null, aVSPStatus.isSharingAvailable(), aVSPStatus.isPreemptionAvailable(), aVSPStatus.isStealthModeAvailable(), false, dSPath.getServerName(), aVSPStatus.getUserName(), this.m_szHelpURL);
                    jDialogConnectionMode.setModal(true);
                    jDialogConnectionMode.setVisible(true);
                    if (!jDialogConnectionMode.wasOkPressed()) break;
                    int n = jDialogConnectionMode.getConnectionMode();
                    switch (n) {
                        case 1: {
                            this.m_bConnectionMode = 1;
                            this.m_bDisconnectCurrentUser = false;
                            bl = true;
                            break;
                        }
                        case 2: {
                            this.m_bConnectionMode = (byte)6;
                            this.m_bDisconnectCurrentUser = true;
                            bl = true;
                            break;
                        }
                        case 3: {
                            this.m_bConnectionMode = (byte)2;
                            this.m_bDisconnectCurrentUser = false;
                            bl = true;
                        }
                    }
                    break;
                }
                UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Channel_In_Use_By_Local_User"));
                break;
            }
            case 12: {
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                if (aVSPStatus.isSharingAvailable() || aVSPStatus.isPreemptionAvailable() || aVSPStatus.isStealthModeAvailable()) {
                    JDialogConnectionMode jDialogConnectionMode = new JDialogConnectionMode(null, aVSPStatus.isSharingAvailable(), aVSPStatus.isPreemptionAvailable(), aVSPStatus.isStealthModeAvailable(), false, dSPath.getServerName(), aVSPStatus.getUserName(), this.m_szHelpURL);
                    jDialogConnectionMode.setModal(true);
                    jDialogConnectionMode.setVisible(true);
                    if (!jDialogConnectionMode.wasOkPressed()) break;
                    int n = jDialogConnectionMode.getConnectionMode();
                    switch (n) {
                        case 1: {
                            this.m_bConnectionMode = 1;
                            this.m_bDisconnectCurrentUser = false;
                            bl = true;
                            break;
                        }
                        case 2: {
                            this.m_bConnectionMode = (byte)6;
                            this.m_bDisconnectCurrentUser = true;
                            bl = true;
                            break;
                        }
                        case 3: {
                            this.m_bConnectionMode = (byte)2;
                            this.m_bDisconnectCurrentUser = false;
                            bl = true;
                        }
                    }
                    break;
                }
                UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Channel_In_Use_By_Exclusive_Local_User"));
                break;
            }
            case 11: {
                this.m_bDisconnectCurrentUser = UserNotification.ServerNotAvailableCanBePreempted(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Switch_Local_Port"), false);
                if (this.m_bDisconnectCurrentUser) break;
                bl = false;
                break;
            }
            case 8: {
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_All_Channels_In_Use"));
                break;
            }
            case 9: {
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Insufficient_Access_Rights"));
                break;
            }
            case 10: {
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_User_Locked_Out"));
                break;
            }
            case 13: {
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Channel_Upgrade_In_Progress"));
                break;
            }
            case 14: {
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                if (aVSPStatus.isSharingAvailable() || aVSPStatus.isPreemptionAvailable() || aVSPStatus.isStealthModeAvailable()) {
                    JDialogConnectionMode jDialogConnectionMode = new JDialogConnectionMode(null, aVSPStatus.isSharingAvailable(), aVSPStatus.isPreemptionAvailable(), aVSPStatus.isStealthModeAvailable(), false, dSPath.getServerName(), aVSPStatus.getUserName(), this.m_szHelpURL);
                    jDialogConnectionMode.setModal(true);
                    jDialogConnectionMode.setVisible(true);
                    if (!jDialogConnectionMode.wasOkPressed()) break;
                    int n = jDialogConnectionMode.getConnectionMode();
                    switch (n) {
                        case 1: {
                            this.m_bConnectionMode = 1;
                            this.m_bDisconnectCurrentUser = false;
                            bl = true;
                            break;
                        }
                        case 2: {
                            this.m_bConnectionMode = (byte)6;
                            this.m_bDisconnectCurrentUser = true;
                            bl = true;
                            break;
                        }
                        case 3: {
                            this.m_bConnectionMode = (byte)2;
                            this.m_bDisconnectCurrentUser = false;
                            bl = true;
                        }
                    }
                    break;
                }
                UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Channel_In_Use_By_Exclusive_User"));
                break;
            }
            case 15: {
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Channel_Share_Request_Denied"));
                break;
            }
            case 16: {
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Channel_Share_Request_Timed_Out"));
                break;
            }
            case 17: {
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Channel_Exclusive_Request_Failed"));
                break;
            }
            case 18: {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE, or PEM BLOCKAGE returned by appliance");
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                if (aVSPStatus.isSharingAvailable() || aVSPStatus.isPreemptionAvailable() || aVSPStatus.isStealthModeAvailable()) {
                    JDialogConnectionMode jDialogConnectionMode = new JDialogConnectionMode(null, aVSPStatus.isSharingAvailable(), aVSPStatus.isPreemptionAvailable(), aVSPStatus.isStealthModeAvailable(), false, dSPath.getServerName(), aVSPStatus.getUserName(), this.m_szHelpURL);
                    jDialogConnectionMode.setModal(true);
                    jDialogConnectionMode.setVisible(true);
                    if (!jDialogConnectionMode.wasOkPressed()) break;
                    int n = jDialogConnectionMode.getConnectionMode();
                    switch (n) {
                        case 1: {
                            this.m_bConnectionMode = 1;
                            this.m_bDisconnectCurrentUser = false;
                            bl = true;
                            break;
                        }
                        case 2: {
                            this.m_bConnectionMode = (byte)6;
                            this.m_bDisconnectCurrentUser = true;
                            bl = true;
                            break;
                        }
                        case 3: {
                            this.m_bConnectionMode = (byte)2;
                            this.m_bDisconnectCurrentUser = false;
                            bl = true;
                        }
                    }
                    break;
                }
                Object[] objectArray = new Object[]{BrandNaming.getServerName(false, true)};
                String string = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_Server_Not_Available_For_Viewing_Title"), objectArray);
                objectArray = new Object[]{aVSPStatus.getUserName()};
                String string3 = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_CHANNEL_IN_USE_BY"), objectArray);
                objectArray = new Object[]{dSPath.getDisplayName(), string3};
                String string4 = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_CHANNEL_IN_USE_WITH_REASON"), objectArray);
                JOptionPane.showMessageDialog(null, string4, string, 1);
                break;
            }
            case 19: {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, PEM BLOCKAGE, CAN PRE-EMPT returned by appliance");
                Object[] objectArray = new Object[]{aVSPStatus.getUserName()};
                String string = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_CHANNEL_IN_USE_BY"), objectArray);
                objectArray = new Object[]{dSPath.getDisplayName(), string};
                String string5 = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_CHANNEL_IN_USE_WITH_REASON_CAN_PREEMPT"), objectArray);
                objectArray = new Object[]{BrandNaming.getServerName(true, true)};
                String string6 = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_Server_Not_Available_For_Viewing_Title"), objectArray);
                int n = JOptionPaneFixedSize.showConfirmDialog(null, (Object)string5, (String)string6, (int)0, (int)3);
                boolean bl5 = this.m_bDisconnectCurrentUser = n == 0;
                if (this.m_bDisconnectCurrentUser) break;
                bl = false;
                break;
            }
            case 20: {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE BY LOCAL USER returned by appliance");
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                if (aVSPStatus.isSharingAvailable() || aVSPStatus.isPreemptionAvailable() || aVSPStatus.isStealthModeAvailable()) {
                    JDialogConnectionMode jDialogConnectionMode = new JDialogConnectionMode(null, aVSPStatus.isSharingAvailable(), aVSPStatus.isPreemptionAvailable(), aVSPStatus.isStealthModeAvailable(), false, dSPath.getServerName(), aVSPStatus.getUserName(), this.m_szHelpURL);
                    jDialogConnectionMode.setModal(true);
                    jDialogConnectionMode.setVisible(true);
                    if (!jDialogConnectionMode.wasOkPressed()) break;
                    int n = jDialogConnectionMode.getConnectionMode();
                    switch (n) {
                        case 1: {
                            this.m_bConnectionMode = 1;
                            this.m_bDisconnectCurrentUser = false;
                            bl = true;
                            break;
                        }
                        case 2: {
                            this.m_bConnectionMode = (byte)6;
                            this.m_bDisconnectCurrentUser = true;
                            bl = true;
                            break;
                        }
                        case 3: {
                            this.m_bConnectionMode = (byte)2;
                            this.m_bDisconnectCurrentUser = false;
                            bl = true;
                        }
                    }
                    break;
                }
                Object[] objectArray = new Object[]{BrandNaming.getServerName(false, true)};
                String string = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_Server_Not_Available_For_Viewing_Title"), objectArray);
                objectArray = new Object[]{dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Channel_In_Use_By_Local_User")};
                String string7 = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_CHANNEL_IN_USE_WITH_REASON"), objectArray);
                JOptionPane.showMessageDialog(null, string7, string, 1);
                break;
            }
            case 21: {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, PEM BLOCKAGE, CAN PRE-EMPT returned by appliance");
                Object[] objectArray = new Object[]{dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Channel_In_Use_By_Local_User")};
                String string = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_CHANNEL_IN_USE_WITH_REASON_CAN_PREEMPT"), objectArray);
                objectArray = new Object[]{BrandNaming.getServerName(false, true)};
                String string8 = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_Server_Not_Available_For_Viewing_Title"), objectArray);
                int n = JOptionPaneFixedSize.showConfirmDialog(null, (Object)string, (String)string8, (int)0, (int)3);
                boolean bl6 = this.m_bDisconnectCurrentUser = n == 0;
                if (this.m_bDisconnectCurrentUser) break;
                bl = false;
                break;
            }
            case 50: {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, CHANNEL IN USE BY LOCAL USER, CAN PRE-EMPT, TIMEOUT INFO returned by appliance");
                this.m_bLocalUserUsingChannelWeArePreempting = true;
                this.m_bDisconnectCurrentUser = UserNotification.ServerNotAvailableCanBePreempted(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Switch_Local_Port"), false);
                if (this.m_bDisconnectCurrentUser) {
                    this.m_dlgElapsed = new JDialogWaitingForPreemption(null, RES.getString("JPanelApplianceThumbnailTitle_Switch_Local_Port"), aVSPStatus.canOtherUserRejectPreemption(), aVSPStatus.getPreemptionTimeout());
                    ThreadCheckUserCancel threadCheckUserCancel = new ThreadCheckUserCancel(this.m_dlgElapsed);
                    threadCheckUserCancel.start();
                    break;
                }
                bl = false;
                break;
            }
            case 51: {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, SERVER NOT AVAILABLE, CAN PRE-EMPT, TIMEOUT INFO returned by appliance");
                this.m_bLocalUserUsingChannelWeArePreempting = false;
                this.m_bDisconnectCurrentUser = UserNotification.ServerNotAvailableCanBePreempted(dSPath.getDisplayName(), aVSPStatus.getUserName(), false);
                if (this.m_bDisconnectCurrentUser) {
                    this.m_dlgElapsed = new JDialogWaitingForPreemption(null, aVSPStatus.getUserName(), aVSPStatus.canOtherUserRejectPreemption(), aVSPStatus.getPreemptionTimeout());
                    ThreadCheckUserCancel threadCheckUserCancel = new ThreadCheckUserCancel(this.m_dlgElapsed);
                    threadCheckUserCancel.start();
                    break;
                }
                bl = false;
                break;
            }
            case 52: {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, PREEMPT REJECTED returned by appliance");
                this.m_bDisconnectCurrentUser = false;
                bl = false;
                Object[] objectArray = this.m_bLocalUserUsingChannelWeArePreempting ? new Object[]{RES.getString("JPanelApplianceThumbnailTitle_Switch_Local_Port_Cap"), dSPath.getDisplayName()} : new Object[]{aVSPStatus.getUserName(), dSPath.getDisplayName()};
                String string = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_PREEMPTION_REJECTED"), objectArray);
                JOptionPane.showMessageDialog(null, string, RES.getString("JPanelApplianceThumbnailTitle_PREEMPTION_REJECTED_TITLE"), 1);
                break;
            }
            case 53: {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, PEM BLOCKAGE BY LOCAL USER, CAN PRE-EMPT, TIMEOUT INFO returned by appliance");
                this.m_bLocalUserUsingChannelWeArePreempting = true;
                Object[] objectArray = new Object[]{aVSPStatus.getUserName()};
                String string = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_CHANNEL_IN_USE_BY"), objectArray);
                objectArray = new Object[]{dSPath.getDisplayName(), string};
                String string9 = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_CHANNEL_IN_USE_WITH_REASON_CAN_PREEMPT"), objectArray);
                objectArray = new Object[]{BrandNaming.getServerName(false, true)};
                String string10 = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_Server_Not_Available_For_Viewing_Title"), objectArray);
                int n = JOptionPaneFixedSize.showConfirmDialog(null, (Object)string9, (String)string10, (int)0, (int)3);
                boolean bl7 = this.m_bDisconnectCurrentUser = n == 0;
                if (this.m_bDisconnectCurrentUser) {
                    this.m_dlgElapsed = new JDialogWaitingForPreemption(null, RES.getString("JPanelApplianceThumbnailTitle_Switch_Local_Port"), aVSPStatus.canOtherUserRejectPreemption(), aVSPStatus.getPreemptionTimeout());
                    ThreadCheckUserCancel threadCheckUserCancel = new ThreadCheckUserCancel(this.m_dlgElapsed);
                    threadCheckUserCancel.start();
                    break;
                }
                bl = false;
                break;
            }
            case 54: {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"(videoViewer avspConnect) LOGIN FAILED, PEM BLOCKAGE, CAN PRE-EMPT, TIMEOUT INFO returned by appliance");
                this.m_bLocalUserUsingChannelWeArePreempting = false;
                Object[] objectArray = new Object[]{aVSPStatus.getUserName()};
                String string = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_CHANNEL_IN_USE_BY"), objectArray);
                objectArray = new Object[]{dSPath.getDisplayName(), string};
                String string11 = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_CHANNEL_IN_USE_WITH_REASON_CAN_PREEMPT"), objectArray);
                objectArray = new Object[]{BrandNaming.getServerName(false, true)};
                String string12 = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_Server_Not_Available_For_Viewing_Title"), objectArray);
                int n = JOptionPaneFixedSize.showConfirmDialog(null, (Object)string11, (String)string12, (int)0, (int)3);
                boolean bl8 = this.m_bDisconnectCurrentUser = n == 0;
                if (this.m_bDisconnectCurrentUser) {
                    this.m_dlgElapsed = new JDialogWaitingForPreemption(null, aVSPStatus.getUserName(), aVSPStatus.canOtherUserRejectPreemption(), aVSPStatus.getPreemptionTimeout());
                    ThreadCheckUserCancel threadCheckUserCancel = new ThreadCheckUserCancel(this.m_dlgElapsed);
                    threadCheckUserCancel.start();
                    break;
                }
                bl = false;
                break;
            }
            default: {
                bl = false;
                UserNotification.ServerNotAvailableForViewing(dSPath.getDisplayName(), RES.getString("JPanelApplianceThumbnailTitle_Unknown_error"));
            }
        }
        return bl;
    }

    private String getAuthFailureReason(int n) {
        String string;
        switch (n) {
            case 1: 
            case 2: 
            case 6: {
                string = RES.getString("JPanelApplianceThumbnailTitle_Channel_In_Use");
                break;
            }
            case 3: {
                string = RES.getString("JPanelApplianceThumbnailTitle_Insufficient_Access_Rights");
                break;
            }
            case 4: {
                string = RES.getString("JPanelApplianceThumbnailTitle_Channel_Upgrade_In_Progress");
                break;
            }
            case 5: {
                string = RES.getString("JPanelApplianceThumbnailTitle_Status_Error");
                break;
            }
            default: {
                string = RES.getString("JPanelApplianceThumbnailTitle_Unknown_error");
            }
        }
        Object[] objectArray = new Object[]{string};
        String string2 = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_Thumbnail_Unavailable"), objectArray);
        return string2;
    }

    private String getLoginFailureReason(AVSPStatus aVSPStatus) {
        String string;
        if (aVSPStatus == null) {
            string = RES.getString("JPanelApplianceThumbnailTitle_Unknown_error");
        } else {
            switch (aVSPStatus.getLoginStatus()) {
                case 1: {
                    string = RES.getString("JPanelApplianceThumbnailTitle_Invalid_UserName");
                    break;
                }
                case 2: {
                    string = RES.getString("JPanelApplianceThumbnailTitle_InvalidPassword");
                    break;
                }
                case 3: 
                case 22: 
                case 23: {
                    string = RES.getString("JPanelApplianceThumbnailTitle_Channel_Access_Denied");
                    break;
                }
                case 4: 
                case 6: 
                case 15: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 50: 
                case 51: 
                case 53: 
                case 54: 
                case 60: 
                case 61: {
                    string = RES.getString("JPanelApplianceThumbnailTitle_Channel_In_Use");
                    break;
                }
                case 5: {
                    string = RES.getString("JPanelApplianceThumbnailTitle_Channel_Not_Found");
                    break;
                }
                case 7: 
                case 11: 
                case 12: {
                    string = RES.getString("JPanelApplianceThumbnailTitle_Channel_In_Use_By_Local_User");
                    break;
                }
                case 8: {
                    string = RES.getString("JPanelApplianceThumbnailTitle_All_Channels_In_Use");
                    break;
                }
                case 9: 
                case 62: 
                case 63: 
                case 64: {
                    string = RES.getString("JPanelApplianceThumbnailTitle_Insufficient_Access_Rights");
                    break;
                }
                case 10: {
                    string = RES.getString("JPanelApplianceThumbnailTitle_User_Locked_Out");
                    break;
                }
                case 13: {
                    string = RES.getString("JPanelApplianceThumbnailTitle_Channel_Upgrade_In_Progress");
                    break;
                }
                case 100: {
                    string = RES.getString("JPanelApplianceThumbnailTitle_No_Network_Connection");
                    break;
                }
                default: {
                    string = RES.getString("JPanelApplianceThumbnailTitle_Unknown_error");
                }
            }
        }
        Object[] objectArray = new Object[]{string};
        String string2 = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_Thumbnail_Unavailable"), objectArray);
        return string2;
    }

    public void disconnectAppliance() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.disconnectAppliance");
        if (this.m_bDisplayTitle) {
            this.m_labelName.setForeground(this.m_colorForegroundLabel);
        }
        if (!this.m_bFrameActive) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.disconnectAppliance not an interactive session");
            if (this.m_frameThumbnail != null && !this.m_frameThumbnail.isClosing() && this.m_bConnectingSession && !this.isConnectedForThumbnail()) {
                this.waitForConnectingSession();
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.disconnectAppliance waiting for connecting session to end");
                if (this.isConnectedForThumbnail()) {
                    this.wait(3);
                }
            }
            if (this.m_applianceSession != null) {
                try {
                    this.m_appliancePanel.ignoreVideoData(true);
                    this.restoreNonThumbnailSize();
                    this.m_applianceSession.terminateSession();
                    this.m_appliancePanel.ignoreVideoData(false, false);
                    this.m_appliancePanel.repaint();
                    if (this.m_frameThumbnail != null && !this.m_frameThumbnail.isClosing()) {
                        int n = this.isThumbnailConnToSwitch() ? 15 : 3;
                        this.wait(n);
                    }
                }
                catch (Exception exception) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"m_applianceSession null during disconnectAppliance method", (Throwable)exception);
                }
                this.m_applianceSession = null;
            }
            this.connectedForThumbnail(false);
        }
        this.m_led.setLedState(5);
    }

    public void disconnect() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.disconnect");
        if (this.m_bDisplayTitle) {
            this.m_labelName.setForeground(this.m_colorForegroundLabel);
        }
        if (!this.m_bFrameActive) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.disconnect not an interactive session");
            if (this.m_applianceSession != null) {
                try {
                    this.m_appliancePanel.ignoreVideoData(true);
                    this.restoreNonThumbnailSize();
                    this.m_applianceSession.terminateSession();
                    this.m_appliancePanel.ignoreVideoData(false, false);
                    int n = this.m_frameThumbnail.getTimeBetweenServers();
                    if (this.m_frameThumbnail != null && !this.m_frameThumbnail.isClosing()) {
                        int n2;
                        int n3 = n2 = this.isThumbnailConnToSwitch() ? 15 - n : 3 - n;
                        if (n2 > 0) {
                            this.wait(n2);
                        }
                    }
                }
                catch (Exception exception) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"m_applianceSession null during disconnect method", (Throwable)exception);
                }
                this.m_applianceSession = null;
            }
            this.connectedForThumbnail(false);
        }
        this.m_led.setLedState(5);
    }

    public void disconnectInteractiveSession() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.disconnectInteractiveSession");
        if (this.m_bDisplayTitle) {
            this.m_labelName.setForeground(this.m_colorForegroundLabel);
            this.m_led.setLedState(5);
        }
        this.m_applianceSession.terminateSession();
    }

    public synchronized boolean isConnecting() {
        return this.m_led.getLedState() == 2;
    }

    public void disconnectAll() {
        if (!this.m_bFrameActive) {
            this.disconnectAppliance();
        } else {
            SessionManager.removeSession(this.m_applianceSession);
            this.disconnectInteractiveSession();
        }
    }

    private void wait(int n) {
        int n2 = 10 * n;
        while (n2-- > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void waitForConnectingSession() {
        while (this.m_bConnectingSession) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean isThumbnailConnToSwitch() {
        int n = this.getFirstDSPath().getCascadeChannel();
        return n > 0;
    }

    private void restoreNonThumbnailSize() {
        try {
            if (this.m_applianceSession != null) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.restoreNonThumbnailSize getting session info");
                ApplianceSessionInfo applianceSessionInfo = this.m_applianceSession.getPersistentData();
                applianceSessionInfo.setPanedWidth((short)1024, true);
                applianceSessionInfo.setPanedHeight((short)768, true);
                applianceSessionInfo.setDecimationFactor(1, true);
                this.m_applianceSession.setPersistentData(applianceSessionInfo);
            }
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    private void showWaitCursor() {
        this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(3));
    }

    private void showDefaultCursor() {
        this.getTopLevelAncestor().setCursor(Cursor.getPredefinedCursor(0));
    }

    public JPanelAppliance getPanelAppliance() {
        return this.m_appliancePanel;
    }

    public synchronized void enableMouseClicks(boolean bl) {
        this.m_bEnableMouseClicks = bl;
    }

    public int getBitmapWidth() {
        return this.m_nBitmapWidth;
    }

    public int getBitmapHeight() {
        return this.m_nBitmapHeight;
    }

    public int getPixelArrayWidth() {
        return this.m_appliancePanel.getPixelArrayWidth();
    }

    public void initWindow(ApplianceSession applianceSession, int n, int n2, short s, short s2, short s3, short s4, int n3) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("(JPanelApplianceThumbnailTitle initWindow) nX: " + n + " nY:" + n2 + " sWidth:" + s + " sVideoWidth:" + s3 + " sVideoHeight:" + s4 + " nDecimationFactor:" + n3));
        this.setSize(s + 10, s2 + 10);
        this.m_appliancePanel.initPanelAppliance(applianceSession, 0, 0, (int)s, (int)s2, (int)s3, (int)s4, this.m_nDecimationFactor, false);
        this.m_appliancePanel.setVisible(true);
        this.setVisible(true);
    }

    public void enableScalingControls(boolean bl) {
    }

    public boolean isSingleCursorActive() {
        return false;
    }

    public void activateSingleCursorMode(boolean bl) {
    }

    public void initToolbar(ApplianceSession applianceSession) {
    }

    public void mouseAlign() {
    }

    public void setConnectionType(int n) {
    }

    public void notifyLockedModeChanged() {
    }

    public void notifyReserveModeChanged() {
    }

    public void notifyManualVideoAdjustDialogClosed() {
    }

    public void notifyVmAvailableChanged() {
    }

    public void repaintAppliance() {
    }

    public void terminate() {
        this.disconnectAll();
    }

    public void bringWindowToTop() {
    }

    public void terminateThumbnail() {
        this.disconnectAll();
        this.removeAll();
        this.m_appliancePanel.terminatePanelAppliance();
        this.m_appliancePanel = null;
        this.m_frameThumbnail = null;
        Trace.logInfo((String)TRACE_CONTEXT, (String)"terminateThumbnail has been executed.");
    }

    private void jbInit() throws Exception {
    }

    public synchronized void connectedForThumbnail(boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JPanelApplianceThumbnailTitle.connectedForThumbnail bConnectedForThumbnail: " + bl));
        this.m_bConnectedForThumbnail = bl;
    }

    public synchronized boolean isConnectedForThumbnail() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JPanelApplianceThumbnailTitle.isConnectedForThumbnail m_bConnectedForThumbnail: " + this.m_bConnectedForThumbnail));
        return this.m_bConnectedForThumbnail;
    }

    void sizeThumbnail(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.sizeThumbnail");
        switch (n) {
            default: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 7;
                break;
            }
            case 2: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 16;
                break;
            }
            case 3: {
                this.m_nBitmapWidth = 960;
                this.m_nBitmapHeight = 720;
                this.m_nDecimationFactor = 8;
                break;
            }
            case 4: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 6;
                break;
            }
            case 5: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 8;
                break;
            }
            case 6: {
                this.m_nBitmapWidth = 960;
                this.m_nBitmapHeight = 720;
                this.m_nDecimationFactor = 7;
                break;
            }
            case 7: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 5;
                break;
            }
            case 8: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 4;
                break;
            }
            case 9: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 3;
                break;
            }
            case 10: {
                this.m_nBitmapWidth = 960;
                this.m_nBitmapHeight = 720;
                this.m_nDecimationFactor = 6;
                break;
            }
            case 11: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 2;
                break;
            }
            case 12: {
                this.m_nBitmapWidth = 832;
                this.m_nBitmapHeight = 624;
                this.m_nDecimationFactor = 2;
                break;
            }
            case 13: {
                this.m_nBitmapWidth = 1024;
                this.m_nBitmapHeight = 768;
                this.m_nDecimationFactor = 2;
                break;
            }
            case 14: {
                this.m_nBitmapWidth = 640;
                this.m_nBitmapHeight = 480;
                this.m_nDecimationFactor = 1;
            }
        }
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JPanelApplianceThumbnailTitle.sizeThumbnail new size m_bitmapWidth=" + this.m_nBitmapWidth + " m_nBitmapHeight=" + this.m_nBitmapHeight + " m_nDecimationFactor=" + this.m_nDecimationFactor));
        if (this.m_bDisplayTitle) {
            int n2 = this.m_nBitmapWidth / this.m_nDecimationFactor - this.m_led.getWidth();
            this.m_labelName.setBounds(this.m_led.getWidth() + (this.m_nBitmapWidth / this.m_nDecimationFactor - this.m_led.getWidth() - n2) / 2, this.m_nBitmapHeight / this.m_nDecimationFactor, n2, 20);
            this.setSize(this.m_nBitmapWidth / this.m_nDecimationFactor, this.m_nBitmapHeight / this.m_nDecimationFactor + 20);
        } else {
            this.setSize(this.m_nBitmapWidth / this.m_nDecimationFactor, this.m_nBitmapHeight / this.m_nDecimationFactor);
        }
        this.m_led.setLocation(0, this.m_nBitmapHeight / this.m_nDecimationFactor + 5);
        this.validate();
        this.m_appliancePanel.initPanelAppliance(this.m_applianceSession, 0, 0, this.m_nBitmapWidth, this.m_nBitmapHeight, 1024, 768, this.m_nDecimationFactor, false, false);
        this.m_appliancePanel.setVisible(true);
        this.m_appliancePanel.repaint();
    }

    void appliancePanel_mousePressed(MouseEvent mouseEvent) {
        if (!this.m_bEnableMouseClicks) {
            mouseEvent.consume();
            return;
        }
        if (mouseEvent.getClickCount() >= 2) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JPanelApplianceThumbnailTitle this_mousePressed) clickCount >= 2");
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    JPanelApplianceThumbnailTitle.this.launchInteractiveSession();
                }
            });
            thread.start();
        } else if (mouseEvent.isPopupTrigger()) {
            this.createAndShowPopupMenu(mouseEvent);
        }
    }

    void appliancePanel_mouseReleased(MouseEvent mouseEvent) {
        if (!this.m_bEnableMouseClicks) {
            mouseEvent.consume();
            return;
        }
        if (mouseEvent.isPopupTrigger()) {
            this.createAndShowPopupMenu(mouseEvent);
        }
    }

    private void createAndShowPopupMenu(MouseEvent mouseEvent) {
        final JPopupMenuKeyListener jPopupMenuKeyListener = new JPopupMenuKeyListener();
        jPopupMenuKeyListener.setBorder(new BevelBorder(0));
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(RES.getString("JPanelApplianceThumbnailTitle_Enable_Menu_Item"));
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                Trace.logInfo((String)JPanelApplianceThumbnailTitle.TRACE_CONTEXT, (String)("JPanelApplianceThumbnailTitle.createAndShowPopupMenu keyTyped: " + keyEvent.getKeyChar()));
                if (keyEvent.getKeyChar() == '\u001b') {
                    jPopupMenuKeyListener.setVisible(false);
                    keyEvent.consume();
                    JPanelApplianceThumbnailTitle.this.requestFocus();
                } else {
                    char[] cArray = new char[]{keyEvent.getKeyChar()};
                    String string = new String(cArray).toUpperCase();
                    if (string.charAt(0) == RES.getString("JPanelApplianceThumbnailTitle_View_Interactive_Session_Menu_Mnemonic").charAt(0)) {
                        jPopupMenuKeyListener.setVisible(false);
                        JPanelApplianceThumbnailTitle.this.jMenuItemInteractiveSession_actionPerformed(null);
                        keyEvent.consume();
                    } else if (string.charAt(0) == RES.getString("JPanelApplianceThumbnailTitle_Enable_Menu_Mnemonic").charAt(0)) {
                        if (jCheckBoxMenuItem.isEnabled()) {
                            JPanelApplianceThumbnailTitle.this.setScanEnabled(!JPanelApplianceThumbnailTitle.this.isScanEnabled());
                            jPopupMenuKeyListener.setVisible(false);
                            keyEvent.consume();
                            JPanelApplianceThumbnailTitle.this.requestFocus();
                        }
                    } else if (string.charAt(0) == RES.getString("JPanelApplianceThumbnailTitle_Credentials_Menu_Mnemonic").charAt(0)) {
                        jPopupMenuKeyListener.setVisible(false);
                        keyEvent.consume();
                        JPanelApplianceThumbnailTitle.this.jMenuItemSetCredentials_actionPerformed(null);
                        JPanelApplianceThumbnailTitle.this.requestFocus();
                    }
                }
            }
        };
        jPopupMenuKeyListener.setKeyAdapter(keyAdapter);
        this.m_frameThumbnail.addKeyListener(keyAdapter);
        JMenuItem jMenuItem = new JMenuItem(RES.getString("JPanelApplianceThumbnailTitle_View_Interactive_Session_Menu_Item"));
        String string = RES.getString("JPanelApplianceThumbnailTitle_View_Interactive_Session_Menu_Mnemonic");
        if (string != null && string.length() > 0) {
            jMenuItem.setMnemonic(string.charAt(0));
        }
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelApplianceThumbnailTitle.this.jMenuItemInteractiveSession_actionPerformed(actionEvent);
            }
        });
        jPopupMenuKeyListener.add(jMenuItem);
        string = RES.getString("JPanelApplianceThumbnailTitle_Enable_Menu_Mnemonic");
        if (string != null && string.length() > 0) {
            jCheckBoxMenuItem.setMnemonic(string.charAt(0));
        }
        jCheckBoxMenuItem.setSelected(this.m_bScanEnabled);
        DSPath dSPath = this.getDSPathInteractiveSession();
        if (dSPath != null) {
            jCheckBoxMenuItem.setEnabled(false);
        } else {
            jCheckBoxMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JPanelApplianceThumbnailTitle.this.setScanEnabled(jCheckBoxMenuItem.isSelected());
                }
            });
        }
        jPopupMenuKeyListener.add(jCheckBoxMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(RES.getString("JPanelApplianceThumbnailTitle_Credentials_Menu_Item"));
        string = RES.getString("JPanelApplianceThumbnailTitle_Credentials_Menu_Mnemonic");
        if (string != null && string.length() > 0) {
            jMenuItem2.setMnemonic(string.charAt(0));
        }
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JPanelApplianceThumbnailTitle.this.jMenuItemSetCredentials_actionPerformed(actionEvent);
            }
        });
        if (this.m_nApplication != 2) {
            jPopupMenuKeyListener.add(jMenuItem2);
        }
        jPopupMenuKeyListener.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
    }

    void jMenuItemInteractiveSession_actionPerformed(ActionEvent actionEvent) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                JPanelApplianceThumbnailTitle.this.launchInteractiveSession();
            }
        });
        thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void jMenuItemSetCredentials_actionPerformed(ActionEvent actionEvent) {
        UsernamePassword usernamePassword = new UsernamePassword(this.getUserCredentials());
        try {
            Object[] objectArray = new Object[]{this.getServerName()};
            String string = MessageFormat.format(RES.getString("JPanelApplianceThumbnailTitle_Thumbnail_Server_Credentials"), objectArray);
            Boolean bl = JFrameThumbnail.m_bModalDlgRequest;
            synchronized (bl) {
                JDialogLogin jDialogLogin = new JDialogLogin(this.getParentFrame(), string, usernamePassword);
                jDialogLogin.setModal(true);
                jDialogLogin.setVisible(true);
                if (jDialogLogin.wasOkPressed()) {
                    this.setUserCredentials(usernamePassword, true);
                }
            }
        }
        catch (ExceptionConstructorFailed exceptionConstructorFailed) {
            Trace.logError((String)TRACE_CONTEXT, (String)exceptionConstructorFailed.getMessage(), (Throwable)exceptionConstructorFailed);
        }
    }

    public void applianceSessionClosing() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.applianceSessionClosing");
        if (this.isConnectedForThumbnail()) {
            this.m_led.setLedState(5);
            this.connectedForThumbnail(false);
        } else {
            this.m_applianceSession = null;
        }
        this.m_bFrameActive = false;
    }

    public void launchInteractiveSession() {
        boolean bl = this.m_frameThumbnail.isScanPaused();
        this.m_frameThumbnail.pauseScan(true);
        this.m_frameThumbnail.disableJFrameThumbnail();
        this.showWaitCursor();
        if (this.m_applianceSession == null && !this.m_bConnectingSession) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.launchInteractiveSession no current appliance session and no connecting session");
            DSPath dSPath = this.getDSPathInteractiveSession();
            if (dSPath != null) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.launchInteractiveSession appliance session from another source, bringing it to the foreground");
                SessionManager.bringSessionToForeground(dSPath.getDeviceID());
            } else {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.launchInteractiveSession, no current appliance session and no connecting session");
                this.connectAppliance(false, new AVSPStatus());
            }
        } else if (this.m_bConnectingSession) {
            this.waitForConnectingSession();
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.launchInteractiveSession connecting session, connecting session ended");
            if (this.isConnectedForThumbnail()) {
                this.wait(3);
            }
            if (this.m_applianceSession != null) {
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.launchInteractiveSession no interactive frame session, connecting session ended, calling disconnectAppliance");
                this.disconnectAppliance();
                Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.launchInteractiveSession no interactive frame session, connecting session ended, calling connectAppliance");
                this.connectAppliance(false, new AVSPStatus());
            }
        } else if (this.m_bFrameActive) {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"(JPanelApplianceThumbnailTitle this_mousePressed) bringing appliance window to forground");
            this.m_applianceSession.getApplianceWindow().bringWindowToTop();
        } else {
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.launchInteractiveSession no interactive frame session, appliance session is not null, calling disconnectAppliance");
            this.disconnectAppliance();
            Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.launchInteractiveSession no interactive frame session, appliance session is not null, calling connectAppliance");
            this.connectAppliance(false, new AVSPStatus());
        }
        this.showDefaultCursor();
        this.m_frameThumbnail.enableJFrameThumbnail();
        this.m_frameThumbnail.pauseScan(bl);
    }

    public DSPath getFirstDSPath() {
        return (DSPath)this.m_vDSPaths.get(0);
    }

    public DSPath getDSPathInteractiveSession() {
        Trace.logInfo((String)TRACE_CONTEXT, (String)"JPanelApplianceThumbnailTitle.getDSPathInteractiveSession");
        DSPath dSPath = null;
        for (int i = 0; i < this.m_vDSPaths.size(); ++i) {
            DSPath dSPath2 = (DSPath)this.m_vDSPaths.get(i);
            Trace.logInfo((String)TRACE_CONTEXT, (String)("JPanelApplianceThumbnailTitle.getDSPathInteractiveSession Checking for session for " + dSPath2.toString()));
            boolean bl = SessionManager.isThisDeviceIDSessionRunning(dSPath2.getDeviceID(), false);
            if (!bl || this.isConnectedForThumbnail()) continue;
            dSPath = dSPath2;
            break;
        }
        return dSPath;
    }

    public String getServerName() {
        return this.getFirstDSPath().getServerName();
    }

    public String getIPAddress() {
        return this.getFirstDSPath().getIPAddress();
    }

    public JFrameThumbnail getThumbnailFrame() {
        return this.m_frameThumbnail;
    }

    public UsernamePassword getUserCredentials() {
        return this.m_userCredentials;
    }

    public void setUserCredentials(UsernamePassword usernamePassword, boolean bl) {
        this.m_userCredentials = new UsernamePassword(usernamePassword);
        this.m_bUserCredentialsSet = bl;
    }

    public boolean haveUserCredentialsBeenSet() {
        return this.m_bUserCredentialsSet;
    }

    Frame getParentFrame() {
        Container container = this.getTopLevelAncestor();
        return container instanceof Frame ? (Frame)container : null;
    }

    public Component getViewComponent() {
        return this.m_frameThumbnail;
    }

    public void fullScreenToggle() {
    }

    public boolean activateMenu() {
        this.m_frameThumbnail.activateMenu();
        return true;
    }

    public void resizeVideoWindow(int n, int n2, boolean bl) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("JPanelApplianceThumbnailTitle.resizeVideoWindow nWidth=" + n + " nHeight=" + n2 + " bEraseImage=" + bl));
        this.m_nBitmapWidth = n;
        this.m_nBitmapHeight = n2;
        Rectangle rectangle = this.m_appliancePanel.getBounds();
        this.m_appliancePanel.initPanelAppliance(this.m_applianceSession, rectangle, this.m_nBitmapWidth, this.m_nBitmapHeight, 1024, 768, this.m_nDecimationFactor, false, true);
    }

    public void resizeVideoWindow(int n, int n2) {
    }

    public Frame getFrameWindow() {
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class ThreadCheckUserCancel
    extends Thread {
        InterfaceElapsedTimeDialog m_dlg;

        private ThreadCheckUserCancel(InterfaceElapsedTimeDialog interfaceElapsedTimeDialog) {
            this.m_dlg = interfaceElapsedTimeDialog;
        }

        public void run() {
            try {
                JPanelApplianceThumbnailTitle.this.m_bUserCancelled = false;
                this.m_dlg.setEnableCancelButton(true);
                this.m_dlg.setVisible(true);
                while (this.m_dlg.isDisplayable()) {
                    JPanelApplianceThumbnailTitle.this.m_bUserCancelled = this.m_dlg.checkCancelButton();
                    if (JPanelApplianceThumbnailTitle.this.m_bUserCancelled) {
                        this.m_dlg.setVisible(false);
                        this.m_dlg.dispose();
                        try {
                            JPanelApplianceThumbnailTitle.this.m_disAppliance.getSocket().close();
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public class JLed
    extends JLabel {
        public static final int LED_STATE_CREATED = 0;
        public static final int LED_STATE_CONNECTING = 2;
        public static final int LED_STATE_CONNECTED = 3;
        public static final int LED_STATE_CONNECT_FAILED = 4;
        public static final int LED_STATE_CONNECT_SUCCEEDED = 5;
        public static final int LED_STATE_INTERACTIVE_SESSION_ACTIVE = 6;
        public static final int LED_STATE_DISABLED = 7;
        public static final int LED_STATE_DISCONNECTING = 8;
        private int m_nLEDState = 0;

        public JLed(int n, int n2) {
            ImageIcon imageIcon = new ImageIcon((class$com$avocent$video$JPanelApplianceThumbnailTitle == null ? (class$com$avocent$video$JPanelApplianceThumbnailTitle = JPanelApplianceThumbnailTitle.class$("com.avocent.video.JPanelApplianceThumbnailTitle")) : class$com$avocent$video$JPanelApplianceThumbnailTitle).getResource("images/riponline.gif"));
            this.setIcon(imageIcon);
            this.setBounds(n, n2, imageIcon.getIconWidth(), imageIcon.getIconHeight());
            this.setVisible(false);
        }

        public void setLedState(int n) {
            this.setLedState(n, null);
        }

        public void setLedState(int n, String string) {
            switch (n) {
                default: {
                    this.m_nLEDState = 0;
                    this.setVisible(false);
                    break;
                }
                case 2: {
                    ImageIcon imageIcon = new ImageIcon((class$com$avocent$video$JPanelApplianceThumbnailTitle == null ? (class$com$avocent$video$JPanelApplianceThumbnailTitle = JPanelApplianceThumbnailTitle.class$("com.avocent.video.JPanelApplianceThumbnailTitle")) : class$com$avocent$video$JPanelApplianceThumbnailTitle).getResource("images/riponline.gif"));
                    if (string != null) {
                        this.setToolTipText(string);
                    } else {
                        this.setToolTipText(RES.getString("JPanelApplianceThumbnailTitle_Thumbnail_Connecting"));
                    }
                    this.m_nLEDState = 2;
                    this.setVisible(true);
                    break;
                }
                case 3: {
                    ImageIcon imageIcon = new ImageIcon((class$com$avocent$video$JPanelApplianceThumbnailTitle == null ? (class$com$avocent$video$JPanelApplianceThumbnailTitle = JPanelApplianceThumbnailTitle.class$("com.avocent.video.JPanelApplianceThumbnailTitle")) : class$com$avocent$video$JPanelApplianceThumbnailTitle).getResource("images/riponline.gif"));
                    this.setIcon(imageIcon);
                    if (string != null) {
                        this.setToolTipText(string);
                    } else {
                        this.setToolTipText(RES.getString("JPanelApplianceThumbnailTitle_Thumbnail_Connected"));
                    }
                    this.m_nLEDState = 3;
                    this.setVisible(true);
                    break;
                }
                case 8: {
                    ImageIcon imageIcon = new ImageIcon((class$com$avocent$video$JPanelApplianceThumbnailTitle == null ? (class$com$avocent$video$JPanelApplianceThumbnailTitle = JPanelApplianceThumbnailTitle.class$("com.avocent.video.JPanelApplianceThumbnailTitle")) : class$com$avocent$video$JPanelApplianceThumbnailTitle).getResource("images/riponline.gif"));
                    this.setIcon(imageIcon);
                    if (string != null) {
                        this.setToolTipText(string);
                    } else {
                        this.setToolTipText(RES.getString("JPanelApplianceThumbnailTitle_Thumbnail_Disconnecting"));
                    }
                    this.m_nLEDState = 8;
                    this.setVisible(true);
                    break;
                }
                case 4: {
                    ImageIcon imageIcon = new ImageIcon((class$com$avocent$video$JPanelApplianceThumbnailTitle == null ? (class$com$avocent$video$JPanelApplianceThumbnailTitle = JPanelApplianceThumbnailTitle.class$("com.avocent.video.JPanelApplianceThumbnailTitle")) : class$com$avocent$video$JPanelApplianceThumbnailTitle).getResource("images/ripoffline.gif"));
                    this.setIcon(imageIcon);
                    if (string != null) {
                        this.setToolTipText(string);
                    } else {
                        this.setToolTipText(RES.getString("JPanelApplianceThumbnailTitle_Thumbnail_Login_Failed"));
                    }
                    this.m_nLEDState = 4;
                    this.setVisible(true);
                    break;
                }
                case 5: {
                    this.m_nLEDState = 5;
                    this.setVisible(false);
                    this.setToolTipText(null);
                    break;
                }
                case 6: {
                    this.setVisible(false);
                    if (string != null) {
                        this.setToolTipText(string);
                    } else {
                        this.setToolTipText(null);
                    }
                    this.m_nLEDState = 6;
                    break;
                }
                case 7: {
                    this.setVisible(false);
                    if (string != null) {
                        this.setToolTipText(string);
                    } else {
                        this.setToolTipText("");
                    }
                    this.m_nLEDState = 6;
                }
            }
            this.repaint();
        }

        public int getLedState() {
            return this.m_nLEDState;
        }
    }

    private class JPopupMenuKeyListener
    extends JPopupMenu {
        KeyAdapter m_keyAdapter;

        private JPopupMenuKeyListener() {
        }

        public void setVisible(boolean bl) {
            if (!bl && this.isVisible()) {
                ((DefaultSingleSelectionModel)this.getSelectionModel()).clearSelection();
                this.getInvoker().removeKeyListener(this.m_keyAdapter);
                JPanelApplianceThumbnailTitle.this.m_frameThumbnail.removeKeyListener(this.m_keyAdapter);
            }
            super.setVisible(bl);
        }

        public void setKeyAdapter(KeyAdapter keyAdapter) {
            this.m_keyAdapter = keyAdapter;
        }
    }

    private class SessionAuth {
        private SessionStatus sessionStatus = null;
        private Socket socketSSL = null;

        private SessionAuth() {
        }
    }
}

