/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.video.InterfaceNativeKeyEventListener;
import com.avocent.video.NativeAvocentLibrary;
import java.util.Vector;

public class KeyEventQueue
implements InterfaceNativeKeyEventListener {
    protected Vector m_vKeyEvent = new Vector();
    protected InterfaceNativeKeyEventListener m_targetWindow;
    protected KeyEventProcessorThread m_thread;
    static int m_nKeyEventThreadInstanceCount = 0;
    protected NativeAvocentLibrary m_nalNativeLibrary;

    public KeyEventQueue(NativeAvocentLibrary nativeAvocentLibrary, InterfaceNativeKeyEventListener interfaceNativeKeyEventListener) {
        this.m_targetWindow = interfaceNativeKeyEventListener;
        this.m_nalNativeLibrary = nativeAvocentLibrary;
    }

    public void startProcessorThread() {
        Trace.logInfo((String)"KeyEventQueue", (String)"Starting thread to listen for native key events.");
        if (this.m_thread != null) {
            this.m_thread.stopThread();
        }
        this.m_thread = new KeyEventProcessorThread();
        this.m_thread.start();
    }

    public void stopProcessorThread() {
        Trace.logInfo((String)"KeyEventQueue", (String)"Stopping the thread that listens for native key events.");
        this.m_thread.stopThread();
        this.m_thread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyKeyPressedLinux(short s, int n) {
        Trace.logInfo((String)"videoviewertrace", (String)("KeyEventQueue notifyKeyPressedLinux sScanCode:" + s + " nKeyState=" + n));
        if (this.m_thread.isPaused()) {
            return;
        }
        Vector vector = this.m_vKeyEvent;
        synchronized (vector) {
            this.m_vKeyEvent.addElement(new AVWorksKeyEvent(s, true, n, true));
            this.m_vKeyEvent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyKeyPressed(short s) {
        if (this.m_thread.isPaused()) {
            return;
        }
        Vector vector = this.m_vKeyEvent;
        synchronized (vector) {
            this.m_vKeyEvent.addElement(new AVWorksKeyEvent(s, true));
            this.m_vKeyEvent.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyKeyReleased(short s) {
        if (this.m_thread.isPaused()) {
            return;
        }
        Vector vector = this.m_vKeyEvent;
        synchronized (vector) {
            this.m_vKeyEvent.addElement(new AVWorksKeyEvent(s, false));
            this.m_vKeyEvent.notifyAll();
        }
    }

    public void pauseThreadAndClearQueue() {
        this.m_thread.pauseThreadAndClearQueue();
    }

    public void restartThread() {
        this.m_thread.restartThread();
    }

    class AVWorksKeyEvent {
        short m_sScanCode;
        boolean m_bIsKeyPressed;
        int m_nKeyState = 0;
        boolean m_bForLinux = false;

        AVWorksKeyEvent(short s, boolean bl) {
            this.m_sScanCode = s;
            this.m_bIsKeyPressed = bl;
        }

        AVWorksKeyEvent(short s, boolean bl, int n, boolean bl2) {
            this.m_sScanCode = s;
            this.m_bIsKeyPressed = bl;
            this.m_nKeyState = n;
            this.m_bForLinux = bl2;
        }
    }

    class KeyEventProcessorThread
    extends Thread {
        int m_nId = m_nKeyEventThreadInstanceCount;
        private boolean m_bStopThead = false;
        private boolean m_bIsPaused = false;

        KeyEventProcessorThread() {
            super("AVWorks Key Event Thread(" + ++m_nKeyEventThreadInstanceCount + ")");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            Trace.logInfo((String)"KeyEventQueue", (String)("Key Event Thread(" + this.m_nId + ") started."));
            try {
                while (!this.m_bStopThead) {
                    Object object = KeyEventQueue.this.m_vKeyEvent;
                    // MONITORENTER : object
                    while (this.m_bIsPaused && !this.m_bStopThead) {
                        try {
                            KeyEventQueue.this.m_vKeyEvent.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    // MONITOREXIT : object
                    if (!this.m_bStopThead) {
                        Trace.logInfo((String)"KeyEventQueue", (String)("About to process " + KeyEventQueue.this.m_vKeyEvent.size() + " events."));
                        while (KeyEventQueue.this.m_vKeyEvent.size() > 0) {
                            object = (AVWorksKeyEvent)KeyEventQueue.this.m_vKeyEvent.elementAt(0);
                            KeyEventQueue.this.m_vKeyEvent.remove(0);
                            if (((AVWorksKeyEvent)object).m_bIsKeyPressed) {
                                if (((AVWorksKeyEvent)object).m_bForLinux) {
                                    KeyEventQueue.this.m_targetWindow.notifyKeyPressedLinux(((AVWorksKeyEvent)object).m_sScanCode, ((AVWorksKeyEvent)object).m_nKeyState);
                                    continue;
                                }
                                KeyEventQueue.this.m_targetWindow.notifyKeyPressed(((AVWorksKeyEvent)object).m_sScanCode);
                                continue;
                            }
                            KeyEventQueue.this.m_targetWindow.notifyKeyReleased(((AVWorksKeyEvent)object).m_sScanCode);
                        }
                        object = KeyEventQueue.this.m_vKeyEvent;
                        // MONITORENTER : object
                        KeyEventQueue.this.m_vKeyEvent.wait();
                        // MONITOREXIT : object
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                Trace.logInfo((String)"KeyEventQueue", (String)("  Key Event Thread(" + this.m_nId + ") was interrupted."));
            }
            Trace.logInfo((String)"KeyEventQueue", (String)("  Key Event Thread(" + this.m_nId + ") has stopped."));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stopThread() {
            this.m_bStopThead = true;
            Vector vector = KeyEventQueue.this.m_vKeyEvent;
            synchronized (vector) {
                KeyEventQueue.this.m_vKeyEvent.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pauseThreadAndClearQueue() {
            Trace.logInfo((String)"KeyEventQueue", (String)" called pauseThreadAndClearQueue");
            Vector vector = KeyEventQueue.this.m_vKeyEvent;
            synchronized (vector) {
                this.m_bIsPaused = true;
                KeyEventQueue.this.m_vKeyEvent.removeAllElements();
                KeyEventQueue.this.m_vKeyEvent.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restartThread() {
            Trace.logInfo((String)"KeyEventQueue", (String)" called restartThread");
            Trace.logInfo((String)"KeyEventQueue", (String)("    key event queue size: " + KeyEventQueue.this.m_vKeyEvent.size()));
            Vector vector = KeyEventQueue.this.m_vKeyEvent;
            synchronized (vector) {
                this.m_bIsPaused = false;
                KeyEventQueue.this.m_vKeyEvent.removeAllElements();
                KeyEventQueue.this.m_vKeyEvent.notifyAll();
            }
        }

        public boolean isPaused() {
            return this.m_bIsPaused;
        }
    }
}

