/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.util.ResourceManager;
import java.io.Serializable;

public class KeyStroke
implements Serializable {
    public static final String CNAME = "KeyStroke";
    private static ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    private static final String TRACE_CONTEXT = "VideoViewer";
    public static final int STROKE_TYPE_MAKE = 0;
    public static final int STROKE_TYPE_BREAK = 1;
    public static final int STROKE_TYPE_MAKE_AND_BREAK = 2;
    public static final int USB_CAPS_LOCK = 57;
    public static final int USB_NUM_LOCK = 83;
    public static final int USB_SCROLL_LOCK = 71;
    public static final int USB_KANA_LOCK = 146;
    public static final int USB_A = 4;
    public static final int USB_B = 5;
    public static final int USB_C = 6;
    public static final int USB_D = 7;
    public static final int USB_E = 8;
    public static final int USB_F = 9;
    public static final int USB_G = 10;
    public static final int USB_H = 11;
    public static final int USB_I = 12;
    public static final int USB_J = 13;
    public static final int USB_K = 14;
    public static final int USB_L = 15;
    public static final int USB_M = 16;
    public static final int USB_N = 17;
    public static final int USB_O = 18;
    public static final int USB_P = 19;
    public static final int USB_Q = 20;
    public static final int USB_R = 21;
    public static final int USB_S = 22;
    public static final int USB_T = 23;
    public static final int USB_U = 24;
    public static final int USB_V = 25;
    public static final int USB_W = 26;
    public static final int USB_X = 27;
    public static final int USB_Y = 28;
    public static final int USB_Z = 29;
    public static final int USB_AGAIN = 121;
    public static final int USB_ALT_LEFT = 226;
    public static final int USB_COPY = 124;
    public static final int USB_CTRL_LEFT = 224;
    public static final int USB_CUT = 123;
    public static final int USB_ENTER = 40;
    public static final int USB_EXECUTE = 116;
    public static final int USB_DEL = 76;
    public static final int USB_FIND = 126;
    public static final int USB_ESC = 41;
    public static final int USB_BACKSPACE = 42;
    public static final int USB_HELP = 117;
    public static final int USB_HYPEN = 45;
    public static final int USB_MENU = 118;
    public static final int USB_MINUS = 45;
    public static final int USB_MUTE = 127;
    public static final int USB_PAUSE = 72;
    public static final int USB_PASTE = 125;
    public static final int USB_PRINTSCREEN = 70;
    public static final int USB_POWER = 102;
    public static final int USB_SELECT = 119;
    public static final int USB_SPACE = 44;
    public static final int USB_STOP = 120;
    public static final int USB_TAB = 43;
    public static final int USB_UNDO = 122;
    public static final int USB_VOL_DOWN = 129;
    public static final int USB_VOL_UP = 128;
    public static final int USB_SHIFT_LEFT = 225;
    public static final int USB_SHIFT_RIGHT = 229;
    public static final int USB_KEYPAD_MINUS = 86;
    public static final int USB_KEYPAD_PLUS = 87;
    public static final int USB_F1 = 58;
    public static final int USB_F2 = 59;
    public static final int USB_F3 = 60;
    public static final int USB_F4 = 61;
    public static final int USB_F5 = 62;
    public static final int USB_F6 = 63;
    public static final int USB_F7 = 64;
    public static final int USB_F8 = 65;
    public static final int USB_F9 = 66;
    public static final int USB_F10 = 67;
    public static final int USB_F11 = 68;
    public static final int USB_F12 = 69;
    public static final int USB_F13 = 104;
    public static final int USB_F14 = 105;
    public static final int USB_F15 = 106;
    public static final int USB_F16 = 107;
    public static final int USB_F17 = 108;
    public static final int USB_F18 = 109;
    public static final int USB_F19 = 110;
    public static final int USB_F20 = 111;
    public static final int USB_F21 = 112;
    public static final int USB_F22 = 113;
    public static final int USB_F23 = 114;
    public static final int USB_F24 = 115;
    private int m_nUsb;
    private int m_nStrokeType;
    private String m_szKeyCap;

    public KeyStroke(int n, int n2, String string) {
        this.m_nUsb = n2;
        this.m_nStrokeType = n;
        this.m_szKeyCap = string;
    }

    public KeyStroke(String string) throws ExceptionRequestFailed {
        String[] stringArray = string.split(",");
        if (stringArray.length != 3) {
            throw new ExceptionRequestFailed("Format of storage string incorrect");
        }
        this.m_nUsb = Integer.parseInt(stringArray[0]);
        this.m_nStrokeType = Integer.parseInt(stringArray[1]);
        this.m_szKeyCap = stringArray[2];
    }

    public KeyStroke(int n) throws ExceptionRequestFailed {
        this.m_nStrokeType = 2;
        this.m_nUsb = n;
        switch (n) {
            case -1: {
                this.m_szKeyCap = RES.getString("KeyStroke_None");
                break;
            }
            case 58: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_F1");
                break;
            }
            case 59: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_F2");
                break;
            }
            case 60: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_F3");
                break;
            }
            case 61: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_F4");
                break;
            }
            case 62: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_F5");
                break;
            }
            case 63: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_F6");
                break;
            }
            case 64: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_F7");
                break;
            }
            case 65: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_F8");
                break;
            }
            case 66: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_F9");
                break;
            }
            case 67: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_F10");
                break;
            }
            case 68: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_F11");
                break;
            }
            case 69: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_F12");
                break;
            }
            case 70: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_PRTSCN");
                break;
            }
            case 72: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_PAUSE");
                break;
            }
            case 225: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_LSHIFT");
                break;
            }
            case 229: {
                this.m_szKeyCap = RES.getString("KeyStroke_KEYCAP_RSHIFT");
                break;
            }
            default: {
                throw new ExceptionRequestFailed("Unrecognized USB code.  Must be F1-F12 or PrtScrn or Pause");
            }
        }
    }

    public KeyStroke(KeyStroke keyStroke) {
        this.m_nUsb = keyStroke.m_nUsb;
        this.m_nStrokeType = keyStroke.m_nStrokeType;
        this.m_szKeyCap = keyStroke.m_szKeyCap;
    }

    public final int getStrokeType() {
        return this.m_nStrokeType;
    }

    public final int getUsbCode() {
        return this.m_nUsb;
    }

    public String getStorageString() {
        String string = this.m_nUsb + "," + this.m_nStrokeType + "," + this.m_szKeyCap;
        return string;
    }

    public String toString() {
        if (this.m_nStrokeType == 0) {
            return this.m_szKeyCap + RES.getString("KeyStroke_Press");
        }
        if (this.m_nStrokeType == 1) {
            return this.m_szKeyCap + RES.getString("KeyStroke_Release");
        }
        return this.m_szKeyCap;
    }

    public static KeyStroke[] getStandardSelectionKeyStrokes() {
        KeyStroke[] keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 72, RES.getString("KeyStroke_KEYCAP_PAUSE")), new KeyStroke(2, 58, RES.getString("KeyStroke_KEYCAP_F1")), new KeyStroke(2, 59, RES.getString("KeyStroke_KEYCAP_F2")), new KeyStroke(2, 60, RES.getString("KeyStroke_KEYCAP_F3")), new KeyStroke(2, 61, RES.getString("KeyStroke_KEYCAP_F4")), new KeyStroke(2, 62, RES.getString("KeyStroke_KEYCAP_F5")), new KeyStroke(2, 63, RES.getString("KeyStroke_KEYCAP_F6")), new KeyStroke(2, 64, RES.getString("KeyStroke_KEYCAP_F7")), new KeyStroke(2, 65, RES.getString("KeyStroke_KEYCAP_F8")), new KeyStroke(2, 66, RES.getString("KeyStroke_KEYCAP_F9")), new KeyStroke(2, 67, RES.getString("KeyStroke_KEYCAP_F10")), new KeyStroke(2, 68, RES.getString("KeyStroke_KEYCAP_F11")), new KeyStroke(2, 69, RES.getString("KeyStroke_KEYCAP_F12"))};
        return keyStrokeArray;
    }

    public static int getScanCodeForStandardSelectionKeyStroke(KeyStroke keyStroke) {
        int n = 0;
        switch (keyStroke.getUsbCode()) {
            case 72: {
                n = 19;
                break;
            }
            case 58: {
                n = 112;
                break;
            }
            case 59: {
                n = 113;
                break;
            }
            case 60: {
                n = 114;
                break;
            }
            case 61: {
                n = 115;
                break;
            }
            case 62: {
                n = 116;
                break;
            }
            case 63: {
                n = 117;
                break;
            }
            case 64: {
                n = 118;
                break;
            }
            case 65: {
                n = 119;
                break;
            }
            case 66: {
                n = 120;
                break;
            }
            case 67: {
                n = 121;
                break;
            }
            case 68: {
                n = 122;
                break;
            }
            case 69: {
                n = 123;
            }
        }
        return n;
    }

    public static KeyStroke getStandardSelectionKeyStrokeFromScanCode(int n) {
        KeyStroke keyStroke = null;
        switch (n) {
            case 19: {
                keyStroke = new KeyStroke(2, 72, RES.getString("KeyStroke_KEYCAP_PAUSE"));
                break;
            }
            case 112: {
                keyStroke = new KeyStroke(2, 58, RES.getString("KeyStroke_KEYCAP_F1"));
                break;
            }
            case 113: {
                keyStroke = new KeyStroke(2, 59, RES.getString("KeyStroke_KEYCAP_F2"));
                break;
            }
            case 114: {
                keyStroke = new KeyStroke(2, 60, RES.getString("KeyStroke_KEYCAP_F3"));
                break;
            }
            case 115: {
                keyStroke = new KeyStroke(2, 61, RES.getString("KeyStroke_KEYCAP_F4"));
                break;
            }
            case 116: {
                keyStroke = new KeyStroke(2, 62, RES.getString("KeyStroke_KEYCAP_F5"));
                break;
            }
            case 117: {
                keyStroke = new KeyStroke(2, 63, RES.getString("KeyStroke_KEYCAP_F6"));
                break;
            }
            case 118: {
                keyStroke = new KeyStroke(2, 64, RES.getString("KeyStroke_KEYCAP_F7"));
                break;
            }
            case 119: {
                keyStroke = new KeyStroke(2, 65, RES.getString("KeyStroke_KEYCAP_F8"));
                break;
            }
            case 120: {
                keyStroke = new KeyStroke(2, 66, RES.getString("KeyStroke_KEYCAP_F9"));
                break;
            }
            case 121: {
                keyStroke = new KeyStroke(2, 67, RES.getString("KeyStroke_KEYCAP_F10"));
                break;
            }
            case 122: {
                keyStroke = new KeyStroke(2, 68, RES.getString("KeyStroke_KEYCAP_F11"));
                break;
            }
            case 123: {
                keyStroke = new KeyStroke(2, 69, RES.getString("KeyStroke_KEYCAP_F12"));
            }
        }
        return keyStroke;
    }
}

