/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.video.InterfaceKeyCodes;
import com.avocent.video.KeyIdentifier;
import com.avocent.video.KeyTranslatorMapping;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Locale;

class KeyTranslator
implements InterfaceKeyCodes {
    public static final String TRACE_CONTEXT = "KeyTranslator";
    protected Component m_cComponent;
    protected Locale m_lCurrentLocale;
    protected Hashtable m_anKeyMap;
    protected Locale m_lOverrideLocale = null;

    public KeyTranslator(Component component) {
        this.m_cComponent = component;
        String string = System.getProperty("com.avocent.video.locale");
        if (string != null) {
            if (string.equalsIgnoreCase("eng")) {
                this.m_lOverrideLocale = new Locale("en", "EN");
            } else if (string.equalsIgnoreCase("spa")) {
                this.m_lOverrideLocale = new Locale("es", "ES");
            } else if (string.equalsIgnoreCase("fra")) {
                this.m_lOverrideLocale = new Locale("fr", "FR");
            } else if (string.equalsIgnoreCase("deu")) {
                this.m_lOverrideLocale = new Locale("de", "DE");
            } else if (string.equalsIgnoreCase("ita")) {
                this.m_lOverrideLocale = new Locale("it", "IT");
            } else {
                Trace.logError((String)TRACE_CONTEXT, (String)(" Specified input locale (" + string + ") is not supported and will be ignored."));
            }
            if (this.m_lOverrideLocale != null) {
                Trace.logError((String)TRACE_CONTEXT, (String)(" Setting local override to (" + this.m_lOverrideLocale.getDisplayName() + ")."));
            }
        }
    }

    public int translateJavaKeyToUSB(int n) {
        return this.translateJavaKeyToUSB(n, '\u0000', 0);
    }

    public int translateJavaKeyToUSB(int n, char c, int n2) {
        Object v;
        int n3;
        Object object;
        Trace.logInfo((String)"VideoViewerTrace", (String)("DSKeyTranslator.translateKeyUnicodeToUSB nUnicodeKey:" + n));
        Locale locale = this.m_lOverrideLocale != null ? this.m_lOverrideLocale : this.m_cComponent.getInputContext().getLocale();
        Trace.logInfo((String)TRACE_CONTEXT, (String)(" Input locale: " + locale.getISO3Language()));
        if (locale == null) {
            return -1;
        }
        if (this.m_lCurrentLocale != locale) {
            object = locale.getISO3Language();
            Trace.logInfo((String)TRACE_CONTEXT, (String)(" Locale language changed to: " + (String)object));
            this.m_anKeyMap = ((String)object).equalsIgnoreCase("eng") ? KeyTranslatorMapping.eng_MAPPING : (((String)object).equalsIgnoreCase("deu") ? KeyTranslatorMapping.deu_MAPPING : (((String)object).equalsIgnoreCase("fra") ? KeyTranslatorMapping.fra_MAPPING : (((String)object).equalsIgnoreCase("ita") ? KeyTranslatorMapping.ita_MAPPING : (((String)object).equalsIgnoreCase("spa") ? KeyTranslatorMapping.spa_MAPPING : KeyTranslatorMapping.eng_MAPPING))));
            this.m_lCurrentLocale = locale;
        }
        int n4 = n3 = (v = this.m_anKeyMap.get(object = new KeyIdentifier(n, c, n2))) != null ? (Integer)v : 0;
        if (n3 == 0) {
            switch (n) {
                case 414865: {
                    n3 = 102;
                    break;
                }
                case 414854: {
                    n3 = 116;
                    break;
                }
                case 414868: {
                    n3 = 117;
                    break;
                }
                case 65482: {
                    n3 = 118;
                    break;
                }
                case 65480: {
                    n3 = 120;
                    break;
                }
                case 414852: {
                    n3 = 119;
                    break;
                }
                case 65481: {
                    n3 = 121;
                    break;
                }
                case 65483: {
                    n3 = 122;
                    break;
                }
                case 414864: {
                    n3 = 127;
                    break;
                }
                case 65489: {
                    n3 = 123;
                    break;
                }
                case 65485: {
                    n3 = 124;
                    break;
                }
                case 65487: {
                    n3 = 125;
                    break;
                }
                case 65488: {
                    n3 = 126;
                    break;
                }
                case 414866: {
                    n3 = 128;
                    break;
                }
                case 414867: {
                    n3 = 129;
                    break;
                }
                case 417792: {
                    n3 = 138;
                    break;
                }
                case 417793: {
                    n3 = 139;
                    break;
                }
                case 417794: {
                    n3 = 135;
                    break;
                }
                case 417795: {
                    n3 = 137;
                    break;
                }
                case 417796: {
                    n3 = 227;
                    break;
                }
                case 417797: {
                    n3 = 101;
                    break;
                }
                case 417799: {
                    n3 = 230;
                    break;
                }
                case 417798: {
                    n3 = 226;
                    break;
                }
                case 417801: {
                    n3 = 228;
                    break;
                }
                case 417800: {
                    n3 = 224;
                    break;
                }
                case 417803: {
                    n3 = 229;
                    break;
                }
                case 417802: {
                    n3 = 225;
                }
            }
        }
        Trace.logInfo((String)"VideoViewerTrace", (String)("DSKeyTranslator.translateKeyUnicodeToUSB nUnicodeKey:" + n + "  nUsbKey:" + n3));
        return n3;
    }
}

