/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.BrandNaming;
import com.avocent.video.KeyStroke;
import com.avocent.video.KeyboardMacroGroup;
import java.io.Serializable;
import java.util.Vector;

public class KeyboardMacro
implements Serializable {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    public static final String CNAME = "KeyboardMacro";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    public static final String MACRONAME_CTRL_ALT_DEL = RES.getString("KeyboardMacro_Macro_Ctrl_Alt_Del");
    public static final String MACRONAME_ALT_TAB = RES.getString("KeyboardMacro_Macro_Alt_Tab");
    public static final String MACRONAME_ALT_ESC = RES.getString("KeyboardMacro_Macro_Alt_ESC");
    public static final String MACRONAME_CTRL_ESC = RES.getString("KeyboardMacro_Macro_Ctrl_ESC");
    public static final String MACRONAME_ALT_SPACE = RES.getString("KeyboardMacro_Macro_Alt_Space");
    public static final String MACRONAME_ALT_ENTER = RES.getString("KeyboardMacro_Macro_Alt_Enter");
    public static final String MACRONAME_ALT_HYPHEN = RES.getString("KeyboardMacro_Macro_Alt_Hyphen");
    public static final String MACRONAME_ALT_F4 = RES.getString("KeyboardMacro_Macro_Alt_F4");
    public static final String MACRONAME_PRTSCRN = RES.getString("KeyboardMacro_Macro_PrtScrn");
    public static final String MACRONAME_ALT_PRTSCRN = RES.getString("KeyboardMacro_Macro_Alt_PrtScrn");
    public static final String MACRONAME_F1 = RES.getString("KeyboardMacro_Macro_F1");
    public static final String MACRONAME_PAUSE = RES.getString("KeyboardMacro_Macro_Pause");
    public static final String MACRONAME_OPEN_EXECUTE = RES.getString("KeyboardMacro_Macro_Open_Execute");
    public static final String MACRONAME_HELP = RES.getString("KeyboardMacro_Macro_Help");
    public static final String MACRONAME_PROPS_MENU = RES.getString("KeyboardMacro_Macro_Props_Menu");
    public static final String MACRONAME_FRONT_SELECT = RES.getString("KeyboardMacro_Macro_Front_Select");
    public static final String MACRONAME_STOP_Q = RES.getString("KeyboardMacro_Macro_Stop_Q");
    public static final String MACRONAME_STOP_A = RES.getString("KeyboardMacro_Macro_Stop");
    public static final String MACRONAME_AGAIN = RES.getString("KeyboardMacro_Macro_Again");
    public static final String MACRONAME_UNDO = RES.getString("KeyboardMacro_Macro_Undo");
    public static final String MACRONAME_COPY = RES.getString("KeyboardMacro_Macro_Copy");
    public static final String MACRONAME_CUT = RES.getString("KeyboardMacro_Macro_Cut");
    public static final String MACRONAME_PASTE = RES.getString("KeyboardMacro_Macro_Paste");
    public static final String MACRONAME_FIND = RES.getString("KeyboardMacro_Macro_Find");
    public static final String MACRONAME_POWER_SLEEP = RES.getString("KeyboardMacro_Macro_Power_Sleep");
    public static final String MACRONAME_MUTE = RES.getString("KeyboardMacro_Macro_Mute");
    public static final String MACRONAME_VOL_PLUS = RES.getString("KeyboardMacro_Macro_Vol_Plus");
    public static final String MACRONAME_VOL_MINUS = RES.getString("KeyboardMacro_Macro_Vol_Minus");
    public static final String MACRONAME_LEFT_ALT = RES.getString("KeyboardMacro_Macro_Left_Alt");
    public static final String MACRONAME_CTRL_ALT_PLUS = RES.getString("KeyboardMacro_Macro_Ctrl_Alt_Plus");
    public static final String MACRONAME_CTRL_ALT_MINUS = RES.getString("KeyboardMacro_Macro_Ctrl_Alt_Minus");
    public static final String MACRONAME_CTRL_ALT_ESC = RES.getString("KeyboardMacro_Macro_Ctrl_Alt_Esc");
    public static final String MACRONAME_CTRL_ALT_BACKSPACE = RES.getString("KeyboardMacro_Macro_Ctrl_Alt_Backspace");
    public static final String MACRO_KEYBOARD_TYPE_DA = "da";
    public static final String MACRO_KEYBOARD_TYPE_DE = "de";
    public static final String MACRO_KEYBOARD_TYPE_EN = "en";
    public static final String MACRO_KEYBOARD_TYPE_ES = "es";
    public static final String MACRO_KEYBOARD_TYPE_FR = "fr";
    public static final String MACRO_KEYBOARD_TYPE_IE = "ie";
    public static final String MACRO_KEYBOARD_TYPE_IT = "it";
    public static final String MACRO_KEYBOARD_TYPE_JA = "ja";
    public static final String MACRO_KEYBOARD_TYPE_KO = "ko";
    public static final String MACRO_KEYBOARD_TYPE_NL = "nl";
    public static final String MACRO_KEYBOARD_TYPE_PT = "pt";
    public static final String MACRO_KEYBOARD_TYPE_ZH = "zh";
    private String m_szID;
    private KeyStroke[] m_keyStrokes;
    private String m_strName;
    private int m_nIconIndex;
    private boolean m_bMacroOnToolbar;
    private boolean m_bGlobalMacro = false;
    private String m_szKeyboardLanguage;

    public KeyboardMacro(String string, String string2, KeyStroke[] keyStrokeArray, int n, boolean bl, String string3) {
        this.m_szID = string;
        this.m_strName = string2;
        this.m_keyStrokes = keyStrokeArray;
        this.m_nIconIndex = n;
        this.m_bMacroOnToolbar = bl;
        this.m_bGlobalMacro = false;
        this.m_szKeyboardLanguage = string3;
    }

    public KeyboardMacro(String string, String string2, KeyStroke[] keyStrokeArray, int n, boolean bl, boolean bl2, String string3) {
        this.m_szID = string;
        this.m_strName = string2;
        this.m_keyStrokes = keyStrokeArray;
        this.m_nIconIndex = n;
        this.m_bMacroOnToolbar = bl;
        this.m_bGlobalMacro = bl2;
        this.m_szKeyboardLanguage = string3;
    }

    public KeyboardMacro(String string, String string2, Vector vector, int n, boolean bl, String string3) {
        this.m_szID = string;
        this.m_strName = string2;
        this.m_nIconIndex = n;
        this.m_bMacroOnToolbar = bl;
        this.m_bGlobalMacro = false;
        this.m_szKeyboardLanguage = string3;
        this.m_keyStrokes = new KeyStroke[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.m_keyStrokes[i] = (KeyStroke)vector.get(i);
        }
    }

    public KeyboardMacro(String string, String string2, Vector vector, int n, boolean bl, boolean bl2, String string3) {
        this.m_szID = string;
        this.m_strName = string2;
        this.m_nIconIndex = n;
        this.m_bMacroOnToolbar = bl;
        this.m_bGlobalMacro = bl2;
        this.m_szKeyboardLanguage = string3;
        this.m_keyStrokes = new KeyStroke[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            this.m_keyStrokes[i] = (KeyStroke)vector.get(i);
        }
    }

    public KeyboardMacro(String string, String string2, boolean bl) throws ExceptionRequestFailed {
        try {
            String[] stringArray = string2.split(",");
            this.m_szID = string;
            this.m_strName = stringArray[0];
            this.m_szKeyboardLanguage = stringArray[1];
            this.m_nIconIndex = new Integer(stringArray[2]);
            this.m_bMacroOnToolbar = stringArray[3].compareTo("1") == 0;
            this.m_bGlobalMacro = bl;
            int n = 4;
            Vector<KeyStroke> vector = new Vector<KeyStroke>();
            while (n < stringArray.length) {
                int n2 = new Integer(stringArray[n++]);
                if (n >= stringArray.length) continue;
                int n3 = new Integer(stringArray[n++]);
                if (n >= stringArray.length) continue;
                String string3 = stringArray[n++];
                KeyStroke keyStroke = new KeyStroke(n3, n2, string3);
                vector.add(keyStroke);
            }
            this.m_keyStrokes = new KeyStroke[vector.size()];
            vector.toArray(this.m_keyStrokes);
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            throw new ExceptionRequestFailed(exception.getMessage());
        }
    }

    public KeyboardMacro(KeyboardMacro keyboardMacro, boolean bl) {
        try {
            this.m_szID = bl ? "MACRO_" + System.currentTimeMillis() : new String(keyboardMacro.m_szID);
            this.m_strName = new String(keyboardMacro.m_strName);
            this.m_nIconIndex = keyboardMacro.m_nIconIndex;
            this.m_bMacroOnToolbar = keyboardMacro.m_bMacroOnToolbar;
            this.m_bGlobalMacro = keyboardMacro.m_bGlobalMacro;
            this.m_szKeyboardLanguage = keyboardMacro.m_szKeyboardLanguage;
            this.m_keyStrokes = new KeyStroke[keyboardMacro.m_keyStrokes.length];
            for (int i = 0; i < keyboardMacro.m_keyStrokes.length; ++i) {
                this.m_keyStrokes[i] = new KeyStroke(keyboardMacro.m_keyStrokes[i]);
            }
        }
        catch (NullPointerException nullPointerException) {
            Trace.logError((String)TRACE_CONTEXT, (String)"(KeyboardMacro copy constructor) KeyboardMacro parameter was null.", (Throwable)nullPointerException);
        }
    }

    public final KeyStroke[] getKeyStrokes() {
        return this.m_keyStrokes;
    }

    public final String getID() {
        return this.m_szID;
    }

    public final String getName() {
        return this.m_strName;
    }

    public final void setName(String string) {
        this.m_strName = string;
    }

    public final String getKeyboardLanguage() {
        return this.m_szKeyboardLanguage;
    }

    public final int getIconIndex() {
        return this.m_nIconIndex;
    }

    public final void setIconIndex(int n) {
        this.m_nIconIndex = n;
    }

    public final boolean isMacroOnToolbar() {
        return this.m_bMacroOnToolbar;
    }

    public final void setMacroOnToolbar(boolean bl) {
        this.m_bMacroOnToolbar = bl;
    }

    public final boolean isGlobalMacro() {
        return this.m_bGlobalMacro;
    }

    public final void setGlobalMacro(boolean bl) {
        this.m_bGlobalMacro = bl;
    }

    public final String getStorageString() {
        String string = this.m_strName + "," + this.m_szKeyboardLanguage + "," + this.m_nIconIndex + "," + (this.m_bMacroOnToolbar ? "1" : "0");
        for (int i = 0; i < this.m_keyStrokes.length; ++i) {
            string = string + "," + this.m_keyStrokes[i].getStorageString();
        }
        return string;
    }

    public final String toString() {
        return this.m_strName;
    }

    public static KeyboardMacro[] createStandardMacros(KeyboardMacroGroup keyboardMacroGroup, KeyboardMacroGroup keyboardMacroGroup2, KeyboardMacroGroup keyboardMacroGroup3, KeyboardMacroGroup keyboardMacroGroup4) {
        Object object;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        long l = System.currentTimeMillis();
        String[][] stringArray = BrandNaming.getBrandableVideoMacros();
        KeyboardMacro[] keyboardMacroArray = new KeyboardMacro[32 + stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                object = stringArray[i][2].split(",");
                if ((((String[])object).length - 4) % 3 != 0) {
                    Trace.logError((String)TRACE_CONTEXT, (String)"Invalid Branding String returned. Unable to add macro");
                    continue;
                }
                n2 = (((String[])object).length - 4) / 3;
                KeyStroke[] keyStrokeArray = new KeyStroke[n2];
                n3 = 3;
                for (int j = 0; j < n2; ++j) {
                    if (n3 == ((String[])object).length) {
                        Trace.logError((String)TRACE_CONTEXT, (String)"Invalid Branding String returned. Unable to add macro");
                        continue;
                    }
                    keyStrokeArray[j] = new KeyStroke(Integer.parseInt(object[n3 + 2]), Integer.parseInt(object[n3 + 1]), object[n3 + 3]);
                    n3 += 3;
                }
                bl = object[3].compareTo("1") == 0;
                KeyboardMacro keyboardMacro = new KeyboardMacro("MACRO_" + l++, object[0], keyStrokeArray, Integer.parseInt(object[2]), bl, object[1]);
                keyboardMacroArray[n++] = keyboardMacro;
                if (stringArray[i][1].equals(RES.getString("ApplianceSessionInfo_Macro_Group_Windows"))) {
                    if (keyboardMacroGroup == null) continue;
                    keyboardMacroGroup.addMacroToGroup(keyboardMacro);
                    continue;
                }
                if (stringArray[i][1].equals(RES.getString("ApplianceSessionInfo_Macro_Group_Sun"))) {
                    if (keyboardMacroGroup2 == null) continue;
                    keyboardMacroGroup2.addMacroToGroup(keyboardMacro);
                    continue;
                }
                if (stringArray[i][1].equals(RES.getString("ApplianceSessionInfo_Macro_Group_Novell"))) {
                    if (keyboardMacroGroup3 == null) continue;
                    keyboardMacroGroup3.addMacroToGroup(keyboardMacro);
                    continue;
                }
                if (!stringArray[i][1].equals(RES.getString("ApplianceSessionInfo_Macro_Group_MacIntosh")) || keyboardMacroGroup4 == null) continue;
                keyboardMacroGroup4.addMacroToGroup(keyboardMacro);
                continue;
            }
            catch (Exception exception) {
                Trace.logError((String)TRACE_CONTEXT, (String)("ERROR WITH BRANDING MACROS REASON:" + exception.getMessage()));
            }
        }
        KeyStroke[] keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT")), new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 76, RES.getString("KeyboardMacro_KEYCAP_DEL")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(1, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_CTRL_ALT_DEL, keyStrokeArray, 12, true, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup != null) {
            keyboardMacroGroup.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 43, RES.getString("KeyboardMacro_KEYCAP_TAB")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_ALT_TAB, keyStrokeArray, 13, true, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup != null) {
            keyboardMacroGroup.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 41, RES.getString("KeyboardMacro_KEYCAP_ESC")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_ALT_ESC, keyStrokeArray, 14, true, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup != null) {
            keyboardMacroGroup.addMacroToGroup((KeyboardMacro)object);
        }
        if (keyboardMacroGroup3 != null) {
            keyboardMacroGroup3.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT")), new KeyStroke(2, 41, RES.getString("KeyboardMacro_KEYCAP_ESC")), new KeyStroke(1, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_CTRL_ESC, keyStrokeArray, 15, true, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup != null) {
            keyboardMacroGroup.addMacroToGroup((KeyboardMacro)object);
        }
        if (keyboardMacroGroup3 != null) {
            keyboardMacroGroup3.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 44, RES.getString("KeyboardMacro_KEYCAP_SPACE")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_ALT_SPACE, keyStrokeArray, 16, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup != null) {
            keyboardMacroGroup.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 40, RES.getString("KeyboardMacro_KEYCAP_ENTER")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_ALT_ENTER, keyStrokeArray, 17, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup != null) {
            keyboardMacroGroup.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 45, RES.getString("KeyboardMacro_KEYCAP_HYPHEN")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_ALT_HYPHEN, keyStrokeArray, 18, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup != null) {
            keyboardMacroGroup.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 61, RES.getString("KeyboardMacro_KEYCAP_F4")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_ALT_F4, keyStrokeArray, 19, true, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup != null) {
            keyboardMacroGroup.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 70, RES.getString("KeyboardMacro_KEYCAP_PRTSCN"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_PRTSCRN, keyStrokeArray, 20, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup != null) {
            keyboardMacroGroup.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 70, RES.getString("KeyboardMacro_KEYCAP_PRTSCN")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_ALT_PRTSCRN, keyStrokeArray, 21, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup != null) {
            keyboardMacroGroup.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 58, RES.getString("KeyboardMacro_KEYCAP_F1"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_F1, keyStrokeArray, 22, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup != null) {
            keyboardMacroGroup.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 72, RES.getString("KeyboardMacro_KEYCAP_PAUSE"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_PAUSE, keyStrokeArray, 23, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup != null) {
            keyboardMacroGroup.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 116, RES.getString("KeyboardMacro_KEYCAP_EXECUTE"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_OPEN_EXECUTE, keyStrokeArray, 24, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 117, RES.getString("KeyboardMacro_KEYCAP_HELP"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_HELP, keyStrokeArray, 25, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 118, RES.getString("KeyboardMacro_KEYCAP_MENU"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_PROPS_MENU, keyStrokeArray, 26, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 119, RES.getString("KeyboardMacro_KEYCAP_SELECT"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_FRONT_SELECT, keyStrokeArray, 27, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 120, RES.getString("KeyboardMacro_KEYCAP_STOP")), new KeyStroke(2, 4, RES.getString("KeyboardMacro_KEYCAP_A")), new KeyStroke(1, 120, RES.getString("KeyboardMacro_KEYCAP_STOP"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_STOP_A, keyStrokeArray, 28, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 120, RES.getString("KeyboardMacro_KEYCAP_STOP")), new KeyStroke(2, 20, RES.getString("KeyboardMacro_KEYCAP_Q")), new KeyStroke(1, 120, RES.getString("KeyboardMacro_KEYCAP_STOP"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_STOP_Q, keyStrokeArray, 29, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 121, RES.getString("KeyboardMacro_KEYCAP_AGAIN"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_AGAIN, keyStrokeArray, 30, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 122, RES.getString("KeyboardMacro_KEYCAP_UNDO"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_UNDO, keyStrokeArray, 31, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 124, RES.getString("KeyboardMacro_KEYCAP_COPY"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_COPY, keyStrokeArray, 32, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 123, RES.getString("KeyboardMacro_KEYCAP_CUT"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_CUT, keyStrokeArray, 33, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 125, RES.getString("KeyboardMacro_KEYCAP_PASTE"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_PASTE, keyStrokeArray, 34, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 126, RES.getString("KeyboardMacro_KEYCAP_FIND"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_FIND, keyStrokeArray, 35, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 102, RES.getString("KeyboardMacro_KEYCAP_POWER"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_POWER_SLEEP, keyStrokeArray, 36, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 127, RES.getString("KeyboardMacro_KEYCAP_MUTE"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_MUTE, keyStrokeArray, 37, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 128, RES.getString("KeyboardMacro_KEYCAP_VOLUME_UP"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_VOL_PLUS, keyStrokeArray, 38, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 129, RES.getString("KeyboardMacro_KEYCAP_VOLUME_DOWN"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_VOL_MINUS, keyStrokeArray, 39, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT")), new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 87, RES.getString("KeyboardMacro_KEYCAP_KEYPAD_PLUS")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(1, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_CTRL_ALT_PLUS, keyStrokeArray, 40, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT")), new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 86, RES.getString("KeyboardMacro_KEYCAP_KEYPAD_MINUS")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(1, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_CTRL_ALT_MINUS, keyStrokeArray, 41, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup2 != null) {
            keyboardMacroGroup2.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT")), new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 41, RES.getString("KeyboardMacro_KEYCAP_ESC")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(1, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_CTRL_ALT_ESC, keyStrokeArray, 12, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup3 != null) {
            keyboardMacroGroup3.addMacroToGroup((KeyboardMacro)object);
        }
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT")), new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 42, RES.getString("KeyboardMacro_KEYCAP_BACKSPACE")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(1, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT"))};
        object = new KeyboardMacro("MACRO_" + l++, MACRONAME_CTRL_ALT_BACKSPACE, keyStrokeArray, 12, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = object;
        if (keyboardMacroGroup3 != null) {
            keyboardMacroGroup3.addMacroToGroup((KeyboardMacro)object);
        }
        return keyboardMacroArray;
    }

    public static KeyboardMacro[] createMacrosGlacierD() {
        KeyboardMacro[] keyboardMacroArray = new KeyboardMacro[17];
        int n = 0;
        long l = System.currentTimeMillis();
        KeyStroke[] keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT")), new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 76, RES.getString("KeyboardMacro_KEYCAP_DEL")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(1, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT"))};
        KeyboardMacro keyboardMacro = new KeyboardMacro("MACRO_" + l++, MACRONAME_CTRL_ALT_DEL, keyStrokeArray, 12, true, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 43, RES.getString("KeyboardMacro_KEYCAP_TAB")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, MACRONAME_ALT_TAB, keyStrokeArray, 13, true, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 41, RES.getString("KeyboardMacro_KEYCAP_ESC")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, MACRONAME_ALT_ESC, keyStrokeArray, 14, true, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT")), new KeyStroke(2, 41, RES.getString("KeyboardMacro_KEYCAP_ESC")), new KeyStroke(1, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, MACRONAME_CTRL_ESC, keyStrokeArray, 15, true, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 44, RES.getString("KeyboardMacro_KEYCAP_SPACE")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, MACRONAME_ALT_SPACE, keyStrokeArray, 16, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 40, RES.getString("KeyboardMacro_KEYCAP_ENTER")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, MACRONAME_ALT_ENTER, keyStrokeArray, 17, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 45, RES.getString("KeyboardMacro_KEYCAP_HYPHEN")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, MACRONAME_ALT_HYPHEN, keyStrokeArray, 18, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 61, RES.getString("KeyboardMacro_KEYCAP_F4")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, MACRONAME_ALT_F4, keyStrokeArray, 19, true, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 70, RES.getString("KeyboardMacro_KEYCAP_PRTSCN"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, MACRONAME_PRTSCRN, keyStrokeArray, 20, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 70, RES.getString("KeyboardMacro_KEYCAP_PRTSCN")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, MACRONAME_ALT_PRTSCRN, keyStrokeArray, 21, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 58, RES.getString("KeyboardMacro_KEYCAP_F1"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, MACRONAME_F1, keyStrokeArray, 22, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 72, RES.getString("KeyboardMacro_KEYCAP_PAUSE"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, MACRONAME_PAUSE, keyStrokeArray, 23, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 43, RES.getString("KeyboardMacro_KEYCAP_TAB"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, RES.getString("KeyboardMacro_Macro_Tab"), keyStrokeArray, -1, true, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT")), new KeyStroke(2, 40, RES.getString("KeyboardMacro_KEYCAP_ENTER")), new KeyStroke(1, 224, RES.getString("KeyboardMacro_KEYCAP_CTRL_LEFT"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, RES.getString("KeyboardMacro_Macro_Ctrl_Enter"), keyStrokeArray, -1, true, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(2, 70, RES.getString("KeyboardMacro_KEYCAP_SYSREQ"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, RES.getString("KeyboardMacro_Macro_SysReq"), keyStrokeArray, -1, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(2, 70, RES.getString("KeyboardMacro_KEYCAP_SYSREQ")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, RES.getString("KeyboardMacro_Macro_Alt_SysReq"), keyStrokeArray, -1, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        keyStrokeArray = new KeyStroke[]{new KeyStroke(0, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT")), new KeyStroke(0, 225, RES.getString("KeyboardMacro_KEYCAP_LSHIFT")), new KeyStroke(0, 229, RES.getString("KeyboardMacro_KEYCAP_RSHIFT")), new KeyStroke(2, 41, RES.getString("KeyboardMacro_KEYCAP_ESC")), new KeyStroke(1, 229, RES.getString("KeyboardMacro_KEYCAP_RSHIFT")), new KeyStroke(1, 225, RES.getString("KeyboardMacro_KEYCAP_LSHIFT")), new KeyStroke(1, 226, RES.getString("KeyboardMacro_KEYCAP_ALT_LEFT"))};
        keyboardMacro = new KeyboardMacro("MACRO_" + l++, RES.getString("KeyboardMacro_Macro_Alt_LShift_RShift_Esc"), keyStrokeArray, -1, false, MACRO_KEYBOARD_TYPE_EN);
        keyboardMacroArray[n++] = keyboardMacro;
        return keyboardMacroArray;
    }
}

