/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.exceptions.ExceptionRequestFailed;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.KeyboardMacro;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class KeyboardMacroGroup
implements Serializable {
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    public static final String CNAME = "KeyboardMacroGroup";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    public static final String MACRO_GROUP_WINDOWS = RES.getString("KeyboardMacroGroup_Macro_Group_Windows");
    public static final String MACRO_GROUP_SUN = RES.getString("KeyboardMacroGroup_Macro_Group_Sun");
    public static final String MACRO_GROUP_NOVELL = RES.getString("KeyboardMacroGroup_Macro_Group_Novell");
    private String m_szID;
    private String m_strName;
    private Vector m_vectorMacroIDsInGroup;
    private boolean m_bGlobalGroup = false;

    public KeyboardMacroGroup(String string, String string2, int n) {
        this.m_szID = string;
        this.m_strName = string2;
        try {
            this.m_vectorMacroIDsInGroup = new Vector(n);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            this.m_vectorMacroIDsInGroup = new Vector(1);
        }
    }

    public KeyboardMacroGroup(String string, String string2, int n, boolean bl) {
        this.m_szID = string;
        this.m_strName = string2;
        this.m_bGlobalGroup = bl;
        try {
            this.m_vectorMacroIDsInGroup = new Vector(n);
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            this.m_vectorMacroIDsInGroup = new Vector(1);
        }
    }

    public KeyboardMacroGroup(String string, boolean bl) {
        this.m_szID = "GROUP_" + System.currentTimeMillis();
        this.m_strName = string;
        this.m_bGlobalGroup = bl;
        this.m_vectorMacroIDsInGroup = new Vector();
    }

    public KeyboardMacroGroup(String string, String string2, boolean bl) throws ExceptionRequestFailed {
        try {
            String[] stringArray = string2.split(",");
            this.m_szID = string;
            this.m_strName = stringArray[0];
            this.m_bGlobalGroup = bl;
            this.m_vectorMacroIDsInGroup = new Vector();
            for (int i = 1; i < stringArray.length; ++i) {
                if (stringArray[i].startsWith("MACRO_")) {
                    this.m_vectorMacroIDsInGroup.add(stringArray[i]);
                    continue;
                }
                this.m_vectorMacroIDsInGroup.add("MACRO_" + stringArray[i]);
            }
        }
        catch (Exception exception) {
            Trace.logError((String)TRACE_CONTEXT, (String)exception.getMessage(), (Throwable)exception);
            throw new ExceptionRequestFailed(exception.getMessage());
        }
    }

    public KeyboardMacroGroup(KeyboardMacroGroup keyboardMacroGroup, boolean bl) {
        this.m_szID = bl ? "GROUP_" + System.currentTimeMillis() : keyboardMacroGroup.m_szID;
        this.m_strName = keyboardMacroGroup.m_strName;
        this.m_vectorMacroIDsInGroup = new Vector(keyboardMacroGroup.m_vectorMacroIDsInGroup.size());
        this.m_bGlobalGroup = keyboardMacroGroup.m_bGlobalGroup;
        Enumeration enumeration = keyboardMacroGroup.m_vectorMacroIDsInGroup.elements();
        while (enumeration.hasMoreElements()) {
            String string = new String((String)enumeration.nextElement());
            this.m_vectorMacroIDsInGroup.add(string);
        }
    }

    public void addMacroToGroup(KeyboardMacro keyboardMacro) {
        this.m_vectorMacroIDsInGroup.add(keyboardMacro.getID());
    }

    public void addMacroToGroup(String string) {
        this.m_vectorMacroIDsInGroup.add(string);
    }

    public void removeMacroFromGroup(KeyboardMacro keyboardMacro) {
        for (int i = 0; i < this.m_vectorMacroIDsInGroup.size(); ++i) {
            String string = (String)this.m_vectorMacroIDsInGroup.get(i);
            if (!string.equalsIgnoreCase(keyboardMacro.getID())) continue;
            Trace.logInfo((String)TRACE_CONTEXT, (String)("KeyboardMacroGroup.removeMacroFromGroup removing ID=" + keyboardMacro.getID() + " Name=" + keyboardMacro.getName()));
            this.m_vectorMacroIDsInGroup.remove(i);
            break;
        }
    }

    public void removeMacroFromGroup(String string) {
        for (int i = 0; i < this.m_vectorMacroIDsInGroup.size(); ++i) {
            if (!string.equalsIgnoreCase((String)this.m_vectorMacroIDsInGroup.get(i))) continue;
            Trace.logInfo((String)TRACE_CONTEXT, (String)("KeyboardMacroGroup.removeMacroFromGroup removing ID=" + string));
            this.m_vectorMacroIDsInGroup.remove(i);
            break;
        }
    }

    public void removeAllMacrosFromGroup() {
        this.m_vectorMacroIDsInGroup.removeAllElements();
    }

    public String getMacroInGroup(int n) {
        String string = "";
        try {
            string = (String)this.m_vectorMacroIDsInGroup.get(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return string;
    }

    public String[] getMacrosIDsInGroup() {
        String[] stringArray = new String[this.m_vectorMacroIDsInGroup.size()];
        this.m_vectorMacroIDsInGroup.toArray(stringArray);
        return stringArray;
    }

    public int size() {
        return this.m_vectorMacroIDsInGroup.size();
    }

    public boolean isMacroInGroup(KeyboardMacro keyboardMacro) {
        return this.m_vectorMacroIDsInGroup.contains(keyboardMacro.getID());
    }

    public boolean isMacroInGroup(String string) {
        return this.m_vectorMacroIDsInGroup.contains(string);
    }

    public final String getID() {
        return this.m_szID;
    }

    public final String getName() {
        return this.m_strName;
    }

    public final void setName(String string) {
        this.m_strName = string;
    }

    public String[] getMacroIDs() {
        String[] stringArray = new String[this.m_vectorMacroIDsInGroup.size()];
        for (int i = 0; i < this.m_vectorMacroIDsInGroup.size(); ++i) {
            stringArray[i] = (String)this.m_vectorMacroIDsInGroup.get(i);
        }
        return stringArray;
    }

    public final boolean isGlobalGroup() {
        return this.m_bGlobalGroup;
    }

    public final void setGlobalGroup(boolean bl) {
        this.m_bGlobalGroup = bl;
    }

    public String getStorageString() {
        String string = this.m_strName;
        for (int i = 0; i < this.m_vectorMacroIDsInGroup.size(); ++i) {
            string = string + "," + (String)this.m_vectorMacroIDsInGroup.get(i);
        }
        return string;
    }
}

