/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.video.InterfaceNativeKeyEventListener;
import com.avocent.video.KeyEventQueue;
import com.avocent.video.LinuxKeyTranslator;
import com.avocent.video.NativeAvocentLibrary;
import com.avocent.video.NativeKeyTranslator;
import java.awt.Component;
import java.awt.Window;
import java.awt.peer.WindowPeer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.swing.SwingUtilities;

public class LinuxLibrary
extends NativeAvocentLibrary {
    protected NativeKeyTranslator m_ktKeyTranslator;
    protected static Hashtable m_hListenerList = new Hashtable();
    protected static boolean m_bIsLibraryLoaded;

    public LinuxLibrary() {
        if (!m_bIsLibraryLoaded) {
            try {
                try {
                    System.loadLibrary("jawt");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    // empty catch block
                }
                System.loadLibrary("avctLinux");
                m_bIsLibraryLoaded = true;
                Trace.logInfo((String)"Linux Library", (String)" Linux shared library has been loaded.");
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                Trace.logError((String)"Linux Library", (String)" Linux shared library has failed to load.", (Throwable)unsatisfiedLinkError);
                m_bIsLibraryLoaded = false;
            }
        }
        this.m_ktKeyTranslator = new LinuxKeyTranslator();
    }

    public static native void registerKeyEventHandler(Component var0, InterfaceNativeKeyEventListener var1);

    public static native boolean registerKeyEventHandler(long var0, InterfaceNativeKeyEventListener var2);

    public static native void unregisterKeyEventHandler(Component var0, InterfaceNativeKeyEventListener var1);

    public static native void unregisterKeyEventHandler(long var0, InterfaceNativeKeyEventListener var2);

    public static native void KeyboardPassThru(Component var0, boolean var1);

    public static native void KeyboardPassThru(long var0, boolean var2);

    public void registerNativeKeyListenerImpl(InterfaceNativeKeyEventListener interfaceNativeKeyEventListener, final Component component) {
        Trace.logInfo((String)"KeyEventQueue", (String)" register native key event listener.");
        final KeyEventQueue keyEventQueue = new KeyEventQueue(LinuxLibrary.getInstance(), interfaceNativeKeyEventListener);
        keyEventQueue.startProcessorThread();
        m_hListenerList.put(interfaceNativeKeyEventListener, keyEventQueue);
        final long l = this.getPeerWindowID(component);
        Trace.logInfo((String)"NativeAvocentLibrary", (String)("XAWT Peer window ID: " + l));
        Thread thread = new Thread("AvctKeyEventThread"){

            public void run() {
                if (l > 0L) {
                    LinuxLibrary.registerKeyEventHandler(l, (InterfaceNativeKeyEventListener)keyEventQueue);
                } else {
                    LinuxLibrary.registerKeyEventHandler(component, (InterfaceNativeKeyEventListener)keyEventQueue);
                }
            }
        };
        thread.start();
    }

    long getPeerWindowID(Component component) {
        long l = -1L;
        Window window = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
        WindowPeer windowPeer = (WindowPeer)window.getPeer();
        Class<?> clazz = null;
        try {
            clazz = Class.forName("sun.awt.X11ComponentPeer");
            if (clazz != null && clazz.isInstance(windowPeer)) {
                try {
                    Method method = clazz.getMethod("getContentWindow", null);
                    Object object = method.invoke((Object)windowPeer, null);
                    l = (Long)object;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    Trace.logError((String)"LinuxLibrary", (String)noSuchMethodException.getMessage(), (Throwable)noSuchMethodException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    Trace.logError((String)"LinuxLibrary", (String)illegalAccessException.getMessage(), (Throwable)illegalAccessException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    Trace.logError((String)"LinuxLibrary", (String)invocationTargetException.getMessage(), (Throwable)invocationTargetException);
                }
            } else {
                Trace.logInfo((String)"NativeAvocentLibrary", (String)" Peer component is not an instance of a X11ComponentPeer");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            Trace.logInfo((String)"NativeAvocentLibrary", (String)"Did not find Java 1.5 X11 peer component class.");
        }
        Trace.logInfo((String)"NativeAvocentLibrary", (String)("XAWT Peer window ID: " + l));
        return l;
    }

    public void unregisterNativeKeyListenerImpl(InterfaceNativeKeyEventListener interfaceNativeKeyEventListener, Component component) {
        Trace.logInfo((String)"KeyEventQueue", (String)(" unregister native key event listener for peer component: " + component));
        KeyEventQueue keyEventQueue = (KeyEventQueue)m_hListenerList.get(interfaceNativeKeyEventListener);
        if (keyEventQueue != null) {
            long l = this.getPeerWindowID(component);
            if (l > 0L) {
                LinuxLibrary.unregisterKeyEventHandler(l, (InterfaceNativeKeyEventListener)keyEventQueue);
            } else {
                LinuxLibrary.unregisterKeyEventHandler(component, (InterfaceNativeKeyEventListener)keyEventQueue);
            }
            keyEventQueue.stopProcessorThread();
            m_hListenerList.remove(interfaceNativeKeyEventListener);
        }
    }

    public void setNativeKeyboardPassThru(boolean bl, Component component) {
        Trace.logInfo((String)"setNativeKeyboardPassThru", (String)(" set native Keyboard passthru to:" + bl + " Peer Component: " + component));
        long l = this.getPeerWindowID(component);
        try {
            if (l > 0L) {
                LinuxLibrary.KeyboardPassThru(l, bl);
            } else {
                LinuxLibrary.KeyboardPassThru(component, bl);
            }
        }
        catch (Exception exception) {
            Trace.logInfo((String)"NativeAvocentLibrary", (String)("Exception:" + exception.getMessage()));
        }
    }

    public static void stopKeyListener(InterfaceNativeKeyEventListener interfaceNativeKeyEventListener) {
        KeyEventQueue keyEventQueue = (KeyEventQueue)m_hListenerList.get(interfaceNativeKeyEventListener);
        if (keyEventQueue != null) {
            keyEventQueue.pauseThreadAndClearQueue();
        }
    }

    public static void startKeyListener(InterfaceNativeKeyEventListener interfaceNativeKeyEventListener) {
        KeyEventQueue keyEventQueue = (KeyEventQueue)m_hListenerList.get(interfaceNativeKeyEventListener);
        if (keyEventQueue != null) {
            keyEventQueue.restartThread();
        }
    }

    public static boolean isLibraryLoaded() {
        return m_bIsLibraryLoaded;
    }

    public boolean isLibraryLoadedImpl() {
        return m_bIsLibraryLoaded;
    }

    public void setEnableLoggingImpl(boolean bl) {
    }

    public NativeKeyTranslator getKeyTranslatorImpl() {
        return this.m_ktKeyTranslator;
    }
}

