/*
 * Decompiled with CFR 0.152.
 */
package com.avocent.video;

import com.avocent.lib.debug.Trace;
import com.avocent.lib.util.ResourceManager;
import com.avocent.video.BrandNaming;

public class MajorFunction {
    public static final String CNAME = "MajorFunction";
    static final ResourceManager RES = ResourceManager.getManager((String)"com.avocent.video.Res");
    private static final String TRACE_CONTEXT = "VideoViewerTrace";
    private static final String VIDEO_VIEWER_MACRO_EDITOR_KEY = "VideoViewerMacroEditor";
    public static final int TOOLBAR_FUNCTION_ALIGN_LOCAL_CURSOR = 0;
    public static final int TOOLBAR_FUNCTION_REFRESH_SCREEN = 1;
    public static final int TOOLBAR_FUNCTION_SINGLE_CURSOR_MODE = 2;
    public static final int TOOLBAR_FUNCTION_CAPTURE_TO_FILE = 3;
    public static final int TOOLBAR_FUNCTION_CAPTURE_TO_CLIPBOARD = 4;
    public static final int TOOLBAR_FUNCTION_CONNECTED_USERS = 5;
    public static final int TOOLBAR_FUNCTION_MACROS = 6;
    public static final int TOOLBAR_FUNCTION_MACRO_GROUPS = 7;
    public static final int TOOLBAR_FUNCTION_AUTOMATIC_VIDEO_ADJUST = 8;
    public static final int TOOLBAR_FUNCTION_MANUAL_VIDEO_ADJUST = 9;
    public static final int TOOLBAR_FUNCTION_SESSION_OPTIONS = 10;
    public static final int TOOLBAR_FUNCTION_POWER_CONTROL = 11;
    public static final int TOOLBAR_FUNCTION_VIRTUAL_MEDIA = 64;
    private String m_szID;
    private String m_szName;
    private boolean m_bOnToolbar = false;
    private int m_nFunctionCode = -1;
    private int m_nIconIndex = -1;

    public MajorFunction(String string, String string2) {
        this.m_szID = string;
        String[] stringArray = string2.split(",");
        this.m_szName = stringArray[0];
        this.m_nIconIndex = Integer.decode(stringArray[2]);
        this.m_nFunctionCode = Integer.decode(stringArray[2]);
        this.m_bOnToolbar = stringArray[3].compareTo("1") == 0;
    }

    public boolean isOnToolbar() {
        return this.m_bOnToolbar;
    }

    public void setOnToolbar(boolean bl) {
        this.m_bOnToolbar = bl;
    }

    public int getIconIndex() {
        return this.m_nIconIndex;
    }

    public int getFunctionCode() {
        return this.m_nFunctionCode;
    }

    public String getName() {
        return this.m_szName;
    }

    public String getStorageString() {
        String string = this.m_szName + "," + this.m_nIconIndex + "," + this.m_nFunctionCode + "," + (this.m_bOnToolbar ? "1" : "0");
        return string;
    }

    public String getID() {
        return this.m_szID;
    }

    public static MajorFunction[] getDefaultMajorFunctions(int n) {
        Trace.logInfo((String)TRACE_CONTEXT, (String)("getDefaultMajorFunctions nApplication=" + n));
        boolean bl = !BrandNaming.getString("VirtualMediaSupport", "true").equalsIgnoreCase("false");
        boolean bl2 = BrandNaming.getBoolean(VIDEO_VIEWER_MACRO_EDITOR_KEY, true);
        Trace.logInfo((String)TRACE_CONTEXT, (String)("getDefaultMajorFunctions bDisplayMacroEditor=" + bl2));
        int n2 = 0;
        if (n != 3 && n != 1 && n != 5) {
            n2 = 13;
        } else if (n != 3 && n != 5 && bl) {
            n2 = 12;
            if (!bl2) {
                n2 -= 2;
            }
        } else if (n != 5) {
            n2 = 11;
            if (!bl2) {
                n2 -= 2;
            }
        } else {
            n2 = 9;
        }
        MajorFunction[] majorFunctionArray = new MajorFunction[n2];
        Trace.logInfo((String)TRACE_CONTEXT, (String)("getDefaultMajorFunctions majorFunctions.length=" + majorFunctionArray.length));
        int n3 = 0;
        majorFunctionArray[n3++] = new MajorFunction("FUNCTION_0", RES.getString("MajorFunction_Align_Local_Cursor") + "," + "0" + "," + "0" + "," + "1");
        majorFunctionArray[n3++] = new MajorFunction("FUNCTION_1", RES.getString("MajorFunction_Refresh_Screen") + "," + "1" + "," + "1" + "," + "1");
        majorFunctionArray[n3++] = new MajorFunction("FUNCTION_2", RES.getString("MajorFunction_Single_Cursor_Mode") + "," + "2" + "," + "2" + "," + "1");
        majorFunctionArray[n3++] = new MajorFunction("FUNCTION_3", RES.getString("MajorFunction_CaptureToFile_") + "," + "3" + "," + "3" + "," + "0");
        majorFunctionArray[n3++] = new MajorFunction("FUNCTION_4", RES.getString("MajorFunction_CaptureToClipboard") + "," + "4" + "," + "4" + "," + "0");
        if (n != 5) {
            majorFunctionArray[n3++] = new MajorFunction("FUNCTION_5", RES.getString("MajorFunction_ConnectedUsers_") + "," + "5" + "," + "5" + "," + "0");
        }
        if (bl2) {
            majorFunctionArray[n3++] = new MajorFunction("FUNCTION_6", RES.getString("MajorFunction_Macros") + "," + "6" + "," + "6" + "," + "0");
            if (n != 5) {
                majorFunctionArray[n3++] = new MajorFunction("FUNCTION_7", RES.getString("MajorFunction_Macro_Groups") + "," + "7" + "," + "7" + "," + "0");
            }
        }
        majorFunctionArray[n3++] = new MajorFunction("FUNCTION_8", RES.getString("MajorFunction_Automatic_Video_Adjust") + "," + "8" + "," + "8" + "," + "0");
        majorFunctionArray[n3++] = new MajorFunction("FUNCTION_9", RES.getString("MajorFunction_Manual_Video_Adjust") + "," + "9" + "," + "9" + "," + "0");
        majorFunctionArray[n3++] = new MajorFunction("FUNCTION_10", RES.getString("MajorFunction_Session_Options") + "," + "10" + "," + "10" + "," + "0");
        if (n != 3 && n != 1 && n != 5) {
            majorFunctionArray[n3++] = new MajorFunction("FUNCTION_11", RES.getString("MajorFunction_Power_Control") + "," + "11" + "," + "11" + "," + "0");
        }
        if (n != 3 && n != 5 && bl) {
            majorFunctionArray[n3++] = new MajorFunction("FUNCTION_64", RES.getString("MajorFunction_Virtual_Media") + "," + "64" + "," + "64" + "," + "0");
        }
        return majorFunctionArray;
    }

    public static MajorFunction[] get31MajorFunctions() {
        MajorFunction[] majorFunctionArray = new MajorFunction[1];
        int n = 0;
        majorFunctionArray[n++] = new MajorFunction("FUNCTION_64", RES.getString("MajorFunction_Virtual_Media") + "," + "64" + "," + "64" + "," + "0");
        return majorFunctionArray;
    }
}

